# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ApiKeyProjectAssignmentArgs', 'ApiKeyProjectAssignment']

@pulumi.input_type
class ApiKeyProjectAssignmentArgs:
    def __init__(__self__, *,
                 api_key_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 roles: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a ApiKeyProjectAssignment resource.
        :param pulumi.Input[_builtins.str] api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
               Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        pulumi.set(__self__, "api_key_id", api_key_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
        Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class _ApiKeyProjectAssignmentState:
    def __init__(__self__, *,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApiKeyProjectAssignment resources.
        :param pulumi.Input[_builtins.str] api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
               Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
        Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "roles", value)


@pulumi.type_token("mongodbatlas:index/apiKeyProjectAssignment:ApiKeyProjectAssignment")
class ApiKeyProjectAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## # Resource: ApiKeyProjectAssignment

        `ApiKeyProjectAssignment` provides an API Key Project Assignment resource. The resource lets you create, edit, and delete Organization API keys assignments to projects.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        this = mongodbatlas.ApiKey("this",
            org_id=org_id,
            description="Test API Key",
            role_names=["ORG_READ_ONLY"])
        first_project = mongodbatlas.Project("first_project",
            name="First Project",
            org_id=org_id)
        second_project = mongodbatlas.Project("second_project",
            name="Second Project",
            org_id=org_id)
        first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
            project_id=first_project.id,
            api_key_id=this.api_key_id,
            roles=["GROUP_OWNER"])
        second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
            project_id=second_project.id,
            api_key_id=this.api_key_id,
            roles=["GROUP_OWNER"])
        # Add IP Access List Entry to Programmatic API Key 
        this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
            org_id=org_id,
            cidr_block="0.0.0.0/1",
            api_key_id=this.api_key_id)
        ```

        ## Import

        API Key Project Assignment resource can be imported using the project ID and API key ID, in the format `{PROJECT_ID}/{API_KEY_ID}`, e.g.

        For more information see: [MongoDB Atlas API - Programmatic API Keys Project Assignment](https://www.mongodb.com/docs/api/doc/atlas-admin-api-v2/group/endpoint-programmatic-api-keys) Documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
               Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiKeyProjectAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: ApiKeyProjectAssignment

        `ApiKeyProjectAssignment` provides an API Key Project Assignment resource. The resource lets you create, edit, and delete Organization API keys assignments to projects.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        this = mongodbatlas.ApiKey("this",
            org_id=org_id,
            description="Test API Key",
            role_names=["ORG_READ_ONLY"])
        first_project = mongodbatlas.Project("first_project",
            name="First Project",
            org_id=org_id)
        second_project = mongodbatlas.Project("second_project",
            name="Second Project",
            org_id=org_id)
        first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
            project_id=first_project.id,
            api_key_id=this.api_key_id,
            roles=["GROUP_OWNER"])
        second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
            project_id=second_project.id,
            api_key_id=this.api_key_id,
            roles=["GROUP_OWNER"])
        # Add IP Access List Entry to Programmatic API Key 
        this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
            org_id=org_id,
            cidr_block="0.0.0.0/1",
            api_key_id=this.api_key_id)
        ```

        ## Import

        API Key Project Assignment resource can be imported using the project ID and API key ID, in the format `{PROJECT_ID}/{API_KEY_ID}`, e.g.

        For more information see: [MongoDB Atlas API - Programmatic API Keys Project Assignment](https://www.mongodb.com/docs/api/doc/atlas-admin-api-v2/group/endpoint-programmatic-api-keys) Documentation.

        :param str resource_name: The name of the resource.
        :param ApiKeyProjectAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyProjectAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyProjectAssignmentArgs.__new__(ApiKeyProjectAssignmentArgs)

            if api_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_key_id'")
            __props__.__dict__["api_key_id"] = api_key_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if roles is None and not opts.urn:
                raise TypeError("Missing required property 'roles'")
            __props__.__dict__["roles"] = roles
        super(ApiKeyProjectAssignment, __self__).__init__(
            'mongodbatlas:index/apiKeyProjectAssignment:ApiKeyProjectAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ApiKeyProjectAssignment':
        """
        Get an existing ApiKeyProjectAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] roles: Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
               Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiKeyProjectAssignmentState.__new__(_ApiKeyProjectAssignmentState)

        __props__.__dict__["api_key_id"] = api_key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["roles"] = roles
        return ApiKeyProjectAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        """
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Human-readable label that identifies the collection of privileges that MongoDB Cloud grants a specific API key, MongoDB
        Cloud user, or MongoDB Cloud team. These roles include only the specific project-level roles.
        """
        return pulumi.get(self, "roles")

