# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudBackupScheduleArgs', 'CloudBackupSchedule']

@pulumi.input_type
class CloudBackupScheduleArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 auto_export_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]] = None,
                 export: Optional[pulumi.Input['CloudBackupScheduleExportArgs']] = None,
                 policy_item_daily: Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']] = None,
                 policy_item_hourly: Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]] = None,
                 reference_hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 reference_minute_of_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 update_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_org_and_group_names_in_export_prefix: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a CloudBackupSchedule resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.bool] auto_export_enabled: Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
               * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
               * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]] copy_settings: List that contains a document for each copy setting item in the desired backup policy. See below
        :param pulumi.Input['CloudBackupScheduleExportArgs'] export: Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        :param pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs'] policy_item_daily: Daily policy item. See below
        :param pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs'] policy_item_hourly: Hourly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]] policy_item_monthlies: Monthly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]] policy_item_weeklies: Weekly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]] policy_item_yearlies: Yearly policy item. See below
        :param pulumi.Input[_builtins.int] reference_hour_of_day: UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        :param pulumi.Input[_builtins.int] reference_minute_of_hour: UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        :param pulumi.Input[_builtins.bool] use_org_and_group_names_in_export_prefix: Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "project_id", project_id)
        if auto_export_enabled is not None:
            pulumi.set(__self__, "auto_export_enabled", auto_export_enabled)
        if copy_settings is not None:
            pulumi.set(__self__, "copy_settings", copy_settings)
        if export is not None:
            pulumi.set(__self__, "export", export)
        if policy_item_daily is not None:
            pulumi.set(__self__, "policy_item_daily", policy_item_daily)
        if policy_item_hourly is not None:
            pulumi.set(__self__, "policy_item_hourly", policy_item_hourly)
        if policy_item_monthlies is not None:
            pulumi.set(__self__, "policy_item_monthlies", policy_item_monthlies)
        if policy_item_weeklies is not None:
            pulumi.set(__self__, "policy_item_weeklies", policy_item_weeklies)
        if policy_item_yearlies is not None:
            pulumi.set(__self__, "policy_item_yearlies", policy_item_yearlies)
        if reference_hour_of_day is not None:
            pulumi.set(__self__, "reference_hour_of_day", reference_hour_of_day)
        if reference_minute_of_hour is not None:
            pulumi.set(__self__, "reference_minute_of_hour", reference_minute_of_hour)
        if restore_window_days is not None:
            pulumi.set(__self__, "restore_window_days", restore_window_days)
        if update_snapshots is not None:
            pulumi.set(__self__, "update_snapshots", update_snapshots)
        if use_org_and_group_names_in_export_prefix is not None:
            pulumi.set(__self__, "use_org_and_group_names_in_export_prefix", use_org_and_group_names_in_export_prefix)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="autoExportEnabled")
    def auto_export_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
        * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
        * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        """
        return pulumi.get(self, "auto_export_enabled")

    @auto_export_enabled.setter
    def auto_export_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_export_enabled", value)

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]]:
        """
        List that contains a document for each copy setting item in the desired backup policy. See below
        """
        return pulumi.get(self, "copy_settings")

    @copy_settings.setter
    def copy_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]]):
        pulumi.set(self, "copy_settings", value)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['CloudBackupScheduleExportArgs']]:
        """
        Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['CloudBackupScheduleExportArgs']]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']]:
        """
        Daily policy item. See below
        """
        return pulumi.get(self, "policy_item_daily")

    @policy_item_daily.setter
    def policy_item_daily(self, value: Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']]):
        pulumi.set(self, "policy_item_daily", value)

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']]:
        """
        Hourly policy item. See below
        """
        return pulumi.get(self, "policy_item_hourly")

    @policy_item_hourly.setter
    def policy_item_hourly(self, value: Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']]):
        pulumi.set(self, "policy_item_hourly", value)

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]]:
        """
        Monthly policy item. See below
        """
        return pulumi.get(self, "policy_item_monthlies")

    @policy_item_monthlies.setter
    def policy_item_monthlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]]):
        pulumi.set(self, "policy_item_monthlies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]]:
        """
        Weekly policy item. See below
        """
        return pulumi.get(self, "policy_item_weeklies")

    @policy_item_weeklies.setter
    def policy_item_weeklies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]]):
        pulumi.set(self, "policy_item_weeklies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]]:
        """
        Yearly policy item. See below
        """
        return pulumi.get(self, "policy_item_yearlies")

    @policy_item_yearlies.setter
    def policy_item_yearlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]]):
        pulumi.set(self, "policy_item_yearlies", value)

    @_builtins.property
    @pulumi.getter(name="referenceHourOfDay")
    def reference_hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        """
        return pulumi.get(self, "reference_hour_of_day")

    @reference_hour_of_day.setter
    def reference_hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_hour_of_day", value)

    @_builtins.property
    @pulumi.getter(name="referenceMinuteOfHour")
    def reference_minute_of_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        """
        return pulumi.get(self, "reference_minute_of_hour")

    @reference_minute_of_hour.setter
    def reference_minute_of_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_minute_of_hour", value)

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        """
        return pulumi.get(self, "restore_window_days")

    @restore_window_days.setter
    def restore_window_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_window_days", value)

    @_builtins.property
    @pulumi.getter(name="updateSnapshots")
    def update_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "update_snapshots")

    @update_snapshots.setter
    def update_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_snapshots", value)

    @_builtins.property
    @pulumi.getter(name="useOrgAndGroupNamesInExportPrefix")
    def use_org_and_group_names_in_export_prefix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        return pulumi.get(self, "use_org_and_group_names_in_export_prefix")

    @use_org_and_group_names_in_export_prefix.setter
    def use_org_and_group_names_in_export_prefix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_org_and_group_names_in_export_prefix", value)


@pulumi.input_type
class _CloudBackupScheduleState:
    def __init__(__self__, *,
                 auto_export_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]] = None,
                 export: Optional[pulumi.Input['CloudBackupScheduleExportArgs']] = None,
                 id_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 next_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_item_daily: Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']] = None,
                 policy_item_hourly: Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 reference_minute_of_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 update_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_org_and_group_names_in_export_prefix: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering CloudBackupSchedule resources.
        :param pulumi.Input[_builtins.bool] auto_export_enabled: Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
               * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
               * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        :param pulumi.Input[_builtins.str] cluster_id: Unique identifier of the Atlas cluster.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]] copy_settings: List that contains a document for each copy setting item in the desired backup policy. See below
        :param pulumi.Input['CloudBackupScheduleExportArgs'] export: Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        :param pulumi.Input[_builtins.str] id_policy: Unique identifier of the backup policy.
        :param pulumi.Input[_builtins.str] next_snapshot: Timestamp in the number of seconds that have elapsed since the UNIX epoch when Atlas takes the next snapshot.
        :param pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs'] policy_item_daily: Daily policy item. See below
        :param pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs'] policy_item_hourly: Hourly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]] policy_item_monthlies: Monthly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]] policy_item_weeklies: Weekly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]] policy_item_yearlies: Yearly policy item. See below
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.int] reference_hour_of_day: UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        :param pulumi.Input[_builtins.int] reference_minute_of_hour: UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        :param pulumi.Input[_builtins.bool] use_org_and_group_names_in_export_prefix: Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        if auto_export_enabled is not None:
            pulumi.set(__self__, "auto_export_enabled", auto_export_enabled)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if copy_settings is not None:
            pulumi.set(__self__, "copy_settings", copy_settings)
        if export is not None:
            pulumi.set(__self__, "export", export)
        if id_policy is not None:
            pulumi.set(__self__, "id_policy", id_policy)
        if next_snapshot is not None:
            pulumi.set(__self__, "next_snapshot", next_snapshot)
        if policy_item_daily is not None:
            pulumi.set(__self__, "policy_item_daily", policy_item_daily)
        if policy_item_hourly is not None:
            pulumi.set(__self__, "policy_item_hourly", policy_item_hourly)
        if policy_item_monthlies is not None:
            pulumi.set(__self__, "policy_item_monthlies", policy_item_monthlies)
        if policy_item_weeklies is not None:
            pulumi.set(__self__, "policy_item_weeklies", policy_item_weeklies)
        if policy_item_yearlies is not None:
            pulumi.set(__self__, "policy_item_yearlies", policy_item_yearlies)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if reference_hour_of_day is not None:
            pulumi.set(__self__, "reference_hour_of_day", reference_hour_of_day)
        if reference_minute_of_hour is not None:
            pulumi.set(__self__, "reference_minute_of_hour", reference_minute_of_hour)
        if restore_window_days is not None:
            pulumi.set(__self__, "restore_window_days", restore_window_days)
        if update_snapshots is not None:
            pulumi.set(__self__, "update_snapshots", update_snapshots)
        if use_org_and_group_names_in_export_prefix is not None:
            pulumi.set(__self__, "use_org_and_group_names_in_export_prefix", use_org_and_group_names_in_export_prefix)

    @_builtins.property
    @pulumi.getter(name="autoExportEnabled")
    def auto_export_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
        * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
        * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        """
        return pulumi.get(self, "auto_export_enabled")

    @auto_export_enabled.setter
    def auto_export_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_export_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Atlas cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]]:
        """
        List that contains a document for each copy setting item in the desired backup policy. See below
        """
        return pulumi.get(self, "copy_settings")

    @copy_settings.setter
    def copy_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupScheduleCopySettingArgs']]]]):
        pulumi.set(self, "copy_settings", value)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['CloudBackupScheduleExportArgs']]:
        """
        Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['CloudBackupScheduleExportArgs']]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter(name="idPolicy")
    def id_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the backup policy.
        """
        return pulumi.get(self, "id_policy")

    @id_policy.setter
    def id_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_policy", value)

    @_builtins.property
    @pulumi.getter(name="nextSnapshot")
    def next_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp in the number of seconds that have elapsed since the UNIX epoch when Atlas takes the next snapshot.
        """
        return pulumi.get(self, "next_snapshot")

    @next_snapshot.setter
    def next_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']]:
        """
        Daily policy item. See below
        """
        return pulumi.get(self, "policy_item_daily")

    @policy_item_daily.setter
    def policy_item_daily(self, value: Optional[pulumi.Input['CloudBackupSchedulePolicyItemDailyArgs']]):
        pulumi.set(self, "policy_item_daily", value)

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']]:
        """
        Hourly policy item. See below
        """
        return pulumi.get(self, "policy_item_hourly")

    @policy_item_hourly.setter
    def policy_item_hourly(self, value: Optional[pulumi.Input['CloudBackupSchedulePolicyItemHourlyArgs']]):
        pulumi.set(self, "policy_item_hourly", value)

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]]:
        """
        Monthly policy item. See below
        """
        return pulumi.get(self, "policy_item_monthlies")

    @policy_item_monthlies.setter
    def policy_item_monthlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemMonthlyArgs']]]]):
        pulumi.set(self, "policy_item_monthlies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]]:
        """
        Weekly policy item. See below
        """
        return pulumi.get(self, "policy_item_weeklies")

    @policy_item_weeklies.setter
    def policy_item_weeklies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemWeeklyArgs']]]]):
        pulumi.set(self, "policy_item_weeklies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]]:
        """
        Yearly policy item. See below
        """
        return pulumi.get(self, "policy_item_yearlies")

    @policy_item_yearlies.setter
    def policy_item_yearlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudBackupSchedulePolicyItemYearlyArgs']]]]):
        pulumi.set(self, "policy_item_yearlies", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="referenceHourOfDay")
    def reference_hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        """
        return pulumi.get(self, "reference_hour_of_day")

    @reference_hour_of_day.setter
    def reference_hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_hour_of_day", value)

    @_builtins.property
    @pulumi.getter(name="referenceMinuteOfHour")
    def reference_minute_of_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        """
        return pulumi.get(self, "reference_minute_of_hour")

    @reference_minute_of_hour.setter
    def reference_minute_of_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reference_minute_of_hour", value)

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        """
        return pulumi.get(self, "restore_window_days")

    @restore_window_days.setter
    def restore_window_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_window_days", value)

    @_builtins.property
    @pulumi.getter(name="updateSnapshots")
    def update_snapshots(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "update_snapshots")

    @update_snapshots.setter
    def update_snapshots(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "update_snapshots", value)

    @_builtins.property
    @pulumi.getter(name="useOrgAndGroupNamesInExportPrefix")
    def use_org_and_group_names_in_export_prefix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        return pulumi.get(self, "use_org_and_group_names_in_export_prefix")

    @use_org_and_group_names_in_export_prefix.setter
    def use_org_and_group_names_in_export_prefix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_org_and_group_names_in_export_prefix", value)


@pulumi.type_token("mongodbatlas:index/cloudBackupSchedule:CloudBackupSchedule")
class CloudBackupSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_export_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupScheduleCopySettingArgs', 'CloudBackupScheduleCopySettingArgsDict']]]]] = None,
                 export: Optional[pulumi.Input[Union['CloudBackupScheduleExportArgs', 'CloudBackupScheduleExportArgsDict']]] = None,
                 policy_item_daily: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemDailyArgs', 'CloudBackupSchedulePolicyItemDailyArgsDict']]] = None,
                 policy_item_hourly: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemHourlyArgs', 'CloudBackupSchedulePolicyItemHourlyArgsDict']]] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemMonthlyArgs', 'CloudBackupSchedulePolicyItemMonthlyArgsDict']]]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemWeeklyArgs', 'CloudBackupSchedulePolicyItemWeeklyArgsDict']]]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemYearlyArgs', 'CloudBackupSchedulePolicyItemYearlyArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 reference_minute_of_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 update_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_org_and_group_names_in_export_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Import

        Cloud Backup Schedule entries can be imported using project_id and cluster_name, in the format `PROJECTID-CLUSTERNAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSchedule:CloudBackupSchedule test 5d0f1f73cf09a29120e173cf-MyClusterTest
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/schedule/modify-one-schedule/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_export_enabled: Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
               * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
               * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupScheduleCopySettingArgs', 'CloudBackupScheduleCopySettingArgsDict']]]] copy_settings: List that contains a document for each copy setting item in the desired backup policy. See below
        :param pulumi.Input[Union['CloudBackupScheduleExportArgs', 'CloudBackupScheduleExportArgsDict']] export: Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        :param pulumi.Input[Union['CloudBackupSchedulePolicyItemDailyArgs', 'CloudBackupSchedulePolicyItemDailyArgsDict']] policy_item_daily: Daily policy item. See below
        :param pulumi.Input[Union['CloudBackupSchedulePolicyItemHourlyArgs', 'CloudBackupSchedulePolicyItemHourlyArgsDict']] policy_item_hourly: Hourly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemMonthlyArgs', 'CloudBackupSchedulePolicyItemMonthlyArgsDict']]]] policy_item_monthlies: Monthly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemWeeklyArgs', 'CloudBackupSchedulePolicyItemWeeklyArgsDict']]]] policy_item_weeklies: Weekly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemYearlyArgs', 'CloudBackupSchedulePolicyItemYearlyArgsDict']]]] policy_item_yearlies: Yearly policy item. See below
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.int] reference_hour_of_day: UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        :param pulumi.Input[_builtins.int] reference_minute_of_hour: UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        :param pulumi.Input[_builtins.bool] use_org_and_group_names_in_export_prefix: Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudBackupScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Cloud Backup Schedule entries can be imported using project_id and cluster_name, in the format `PROJECTID-CLUSTERNAME`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSchedule:CloudBackupSchedule test 5d0f1f73cf09a29120e173cf-MyClusterTest
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/schedule/modify-one-schedule/)

        :param str resource_name: The name of the resource.
        :param CloudBackupScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudBackupScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_export_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupScheduleCopySettingArgs', 'CloudBackupScheduleCopySettingArgsDict']]]]] = None,
                 export: Optional[pulumi.Input[Union['CloudBackupScheduleExportArgs', 'CloudBackupScheduleExportArgsDict']]] = None,
                 policy_item_daily: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemDailyArgs', 'CloudBackupSchedulePolicyItemDailyArgsDict']]] = None,
                 policy_item_hourly: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemHourlyArgs', 'CloudBackupSchedulePolicyItemHourlyArgsDict']]] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemMonthlyArgs', 'CloudBackupSchedulePolicyItemMonthlyArgsDict']]]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemWeeklyArgs', 'CloudBackupSchedulePolicyItemWeeklyArgsDict']]]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemYearlyArgs', 'CloudBackupSchedulePolicyItemYearlyArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 reference_minute_of_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 update_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_org_and_group_names_in_export_prefix: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudBackupScheduleArgs.__new__(CloudBackupScheduleArgs)

            __props__.__dict__["auto_export_enabled"] = auto_export_enabled
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["copy_settings"] = copy_settings
            __props__.__dict__["export"] = export
            __props__.__dict__["policy_item_daily"] = policy_item_daily
            __props__.__dict__["policy_item_hourly"] = policy_item_hourly
            __props__.__dict__["policy_item_monthlies"] = policy_item_monthlies
            __props__.__dict__["policy_item_weeklies"] = policy_item_weeklies
            __props__.__dict__["policy_item_yearlies"] = policy_item_yearlies
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["reference_hour_of_day"] = reference_hour_of_day
            __props__.__dict__["reference_minute_of_hour"] = reference_minute_of_hour
            __props__.__dict__["restore_window_days"] = restore_window_days
            __props__.__dict__["update_snapshots"] = update_snapshots
            __props__.__dict__["use_org_and_group_names_in_export_prefix"] = use_org_and_group_names_in_export_prefix
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["id_policy"] = None
            __props__.__dict__["next_snapshot"] = None
        super(CloudBackupSchedule, __self__).__init__(
            'mongodbatlas:index/cloudBackupSchedule:CloudBackupSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_export_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            copy_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupScheduleCopySettingArgs', 'CloudBackupScheduleCopySettingArgsDict']]]]] = None,
            export: Optional[pulumi.Input[Union['CloudBackupScheduleExportArgs', 'CloudBackupScheduleExportArgsDict']]] = None,
            id_policy: Optional[pulumi.Input[_builtins.str]] = None,
            next_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
            policy_item_daily: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemDailyArgs', 'CloudBackupSchedulePolicyItemDailyArgsDict']]] = None,
            policy_item_hourly: Optional[pulumi.Input[Union['CloudBackupSchedulePolicyItemHourlyArgs', 'CloudBackupSchedulePolicyItemHourlyArgsDict']]] = None,
            policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemMonthlyArgs', 'CloudBackupSchedulePolicyItemMonthlyArgsDict']]]]] = None,
            policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemWeeklyArgs', 'CloudBackupSchedulePolicyItemWeeklyArgsDict']]]]] = None,
            policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemYearlyArgs', 'CloudBackupSchedulePolicyItemYearlyArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            reference_hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
            reference_minute_of_hour: Optional[pulumi.Input[_builtins.int]] = None,
            restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
            update_snapshots: Optional[pulumi.Input[_builtins.bool]] = None,
            use_org_and_group_names_in_export_prefix: Optional[pulumi.Input[_builtins.bool]] = None) -> 'CloudBackupSchedule':
        """
        Get an existing CloudBackupSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_export_enabled: Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
               * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
               * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        :param pulumi.Input[_builtins.str] cluster_id: Unique identifier of the Atlas cluster.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupScheduleCopySettingArgs', 'CloudBackupScheduleCopySettingArgsDict']]]] copy_settings: List that contains a document for each copy setting item in the desired backup policy. See below
        :param pulumi.Input[Union['CloudBackupScheduleExportArgs', 'CloudBackupScheduleExportArgsDict']] export: Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        :param pulumi.Input[_builtins.str] id_policy: Unique identifier of the backup policy.
        :param pulumi.Input[_builtins.str] next_snapshot: Timestamp in the number of seconds that have elapsed since the UNIX epoch when Atlas takes the next snapshot.
        :param pulumi.Input[Union['CloudBackupSchedulePolicyItemDailyArgs', 'CloudBackupSchedulePolicyItemDailyArgsDict']] policy_item_daily: Daily policy item. See below
        :param pulumi.Input[Union['CloudBackupSchedulePolicyItemHourlyArgs', 'CloudBackupSchedulePolicyItemHourlyArgsDict']] policy_item_hourly: Hourly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemMonthlyArgs', 'CloudBackupSchedulePolicyItemMonthlyArgsDict']]]] policy_item_monthlies: Monthly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemWeeklyArgs', 'CloudBackupSchedulePolicyItemWeeklyArgsDict']]]] policy_item_weeklies: Weekly policy item. See below
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudBackupSchedulePolicyItemYearlyArgs', 'CloudBackupSchedulePolicyItemYearlyArgsDict']]]] policy_item_yearlies: Yearly policy item. See below
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.int] reference_hour_of_day: UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        :param pulumi.Input[_builtins.int] reference_minute_of_hour: UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        :param pulumi.Input[_builtins.bool] use_org_and_group_names_in_export_prefix: Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudBackupScheduleState.__new__(_CloudBackupScheduleState)

        __props__.__dict__["auto_export_enabled"] = auto_export_enabled
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["copy_settings"] = copy_settings
        __props__.__dict__["export"] = export
        __props__.__dict__["id_policy"] = id_policy
        __props__.__dict__["next_snapshot"] = next_snapshot
        __props__.__dict__["policy_item_daily"] = policy_item_daily
        __props__.__dict__["policy_item_hourly"] = policy_item_hourly
        __props__.__dict__["policy_item_monthlies"] = policy_item_monthlies
        __props__.__dict__["policy_item_weeklies"] = policy_item_weeklies
        __props__.__dict__["policy_item_yearlies"] = policy_item_yearlies
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["reference_hour_of_day"] = reference_hour_of_day
        __props__.__dict__["reference_minute_of_hour"] = reference_minute_of_hour
        __props__.__dict__["restore_window_days"] = restore_window_days
        __props__.__dict__["update_snapshots"] = update_snapshots
        __props__.__dict__["use_org_and_group_names_in_export_prefix"] = use_org_and_group_names_in_export_prefix
        return CloudBackupSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoExportEnabled")
    def auto_export_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag that indicates whether MongoDB Cloud automatically exports Cloud Backup Snapshots to the Export Bucket. Once enabled, it must be disabled by explicitly setting the value to `false`. Value can be one of the following:
        * true - Enables automatic export of cloud backup snapshots to the Export Bucket.
        * false - Disables automatic export of cloud backup snapshots to the Export Bucket. (default)
        """
        return pulumi.get(self, "auto_export_enabled")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the Atlas cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Atlas cluster that contains the snapshot backup policy you want to retrieve.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="copySettings")
    def copy_settings(self) -> pulumi.Output[Optional[Sequence['outputs.CloudBackupScheduleCopySetting']]]:
        """
        List that contains a document for each copy setting item in the desired backup policy. See below
        """
        return pulumi.get(self, "copy_settings")

    @_builtins.property
    @pulumi.getter
    def export(self) -> pulumi.Output['outputs.CloudBackupScheduleExport']:
        """
        Policy for automatically exporting Cloud Backup Snapshots. `auto_export_enabled` must be set to true when defining this attribute. See below
        """
        return pulumi.get(self, "export")

    @_builtins.property
    @pulumi.getter(name="idPolicy")
    def id_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the backup policy.
        """
        return pulumi.get(self, "id_policy")

    @_builtins.property
    @pulumi.getter(name="nextSnapshot")
    def next_snapshot(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp in the number of seconds that have elapsed since the UNIX epoch when Atlas takes the next snapshot.
        """
        return pulumi.get(self, "next_snapshot")

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> pulumi.Output[Optional['outputs.CloudBackupSchedulePolicyItemDaily']]:
        """
        Daily policy item. See below
        """
        return pulumi.get(self, "policy_item_daily")

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> pulumi.Output[Optional['outputs.CloudBackupSchedulePolicyItemHourly']]:
        """
        Hourly policy item. See below
        """
        return pulumi.get(self, "policy_item_hourly")

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> pulumi.Output[Optional[Sequence['outputs.CloudBackupSchedulePolicyItemMonthly']]]:
        """
        Monthly policy item. See below
        """
        return pulumi.get(self, "policy_item_monthlies")

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> pulumi.Output[Optional[Sequence['outputs.CloudBackupSchedulePolicyItemWeekly']]]:
        """
        Weekly policy item. See below
        """
        return pulumi.get(self, "policy_item_weeklies")

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> pulumi.Output[Optional[Sequence['outputs.CloudBackupSchedulePolicyItemYearly']]]:
        """
        Yearly policy item. See below
        """
        return pulumi.get(self, "policy_item_yearlies")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="referenceHourOfDay")
    def reference_hour_of_day(self) -> pulumi.Output[_builtins.int]:
        """
        UTC Hour of day between 0 and 23, inclusive, representing which hour of the day that Atlas takes snapshots for backup policy items.
        """
        return pulumi.get(self, "reference_hour_of_day")

    @_builtins.property
    @pulumi.getter(name="referenceMinuteOfHour")
    def reference_minute_of_hour(self) -> pulumi.Output[_builtins.int]:
        """
        UTC Minutes after `reference_hour_of_day` that Atlas takes snapshots for backup policy items. Must be between 0 and 59, inclusive.
        """
        return pulumi.get(self, "reference_minute_of_hour")

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> pulumi.Output[_builtins.int]:
        """
        Number of days back in time you can restore to with point-in-time accuracy. Must be a positive, non-zero integer.
        """
        return pulumi.get(self, "restore_window_days")

    @_builtins.property
    @pulumi.getter(name="updateSnapshots")
    def update_snapshots(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "update_snapshots")

    @_builtins.property
    @pulumi.getter(name="useOrgAndGroupNamesInExportPrefix")
    def use_org_and_group_names_in_export_prefix(self) -> pulumi.Output[_builtins.bool]:
        """
        Specify true to use organization and project names instead of organization and project UUIDs in the path for the metadata files that Atlas uploads to your bucket after it finishes exporting the snapshots. To learn more about the metadata files that Atlas uploads, see [Export Cloud Backup Snapshot](https://www.mongodb.com/docs/atlas/backup/cloud-backup/export/#std-label-cloud-provider-snapshot-export).
        """
        return pulumi.get(self, "use_org_and_group_names_in_export_prefix")

