# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudBackupSnapshotExportBucketArgs', 'CloudBackupSnapshotExportBucket']

@pulumi.input_type
class CloudBackupSnapshotExportBucketArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[_builtins.str],
                 cloud_provider: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 iam_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudBackupSnapshotExportBucket resource.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket that the provided role ID is authorized to access.
        :param pulumi.Input[_builtins.str] cloud_provider: Name of the provider of the cloud service where Atlas can access the S3 bucket.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.str] iam_role_id: Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        :param pulumi.Input[_builtins.str] role_id: Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] service_url: URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] tenant_id: This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "project_id", project_id)
        if iam_role_id is not None:
            pulumi.set(__self__, "iam_role_id", iam_role_id)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if tenant_id is not None:
            warnings.warn("""This parameter is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: This parameter is deprecated.""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket that the provided role ID is authorized to access.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the provider of the cloud service where Atlas can access the S3 bucket.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        """
        return pulumi.get(self, "iam_role_id")

    @iam_role_id.setter
    def iam_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_id", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_url", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _CloudBackupSnapshotExportBucketState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 export_bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudBackupSnapshotExportBucket resources.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket that the provided role ID is authorized to access.
        :param pulumi.Input[_builtins.str] cloud_provider: Name of the provider of the cloud service where Atlas can access the S3 bucket.
        :param pulumi.Input[_builtins.str] export_bucket_id: Unique identifier of the snapshot export bucket.
        :param pulumi.Input[_builtins.str] iam_role_id: Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.str] role_id: Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] service_url: URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] tenant_id: This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if export_bucket_id is not None:
            pulumi.set(__self__, "export_bucket_id", export_bucket_id)
        if iam_role_id is not None:
            pulumi.set(__self__, "iam_role_id", iam_role_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if tenant_id is not None:
            warnings.warn("""This parameter is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: This parameter is deprecated.""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket that the provided role ID is authorized to access.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the provider of the cloud service where Atlas can access the S3 bucket.
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_provider", value)

    @_builtins.property
    @pulumi.getter(name="exportBucketId")
    def export_bucket_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the snapshot export bucket.
        """
        return pulumi.get(self, "export_bucket_id")

    @export_bucket_id.setter
    def export_bucket_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_bucket_id", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        """
        return pulumi.get(self, "iam_role_id")

    @iam_role_id.setter
    def iam_role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_url", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("mongodbatlas:index/cloudBackupSnapshotExportBucket:CloudBackupSnapshotExportBucket")
class CloudBackupSnapshotExportBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## # Resource: CloudBackupSnapshotExportBucket

        `CloudBackupSnapshotExportBucket` allows you to create an export snapshot bucket for the specified project.

        > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

        > **NOTE:** To prevent errors during resource destruction, ensure that no `CloudBackupSchedule` resource that defines an automatic export policy references this resource. If you must update related `CloudBackupSchedule` resources, make these updates in isolated `pulumi up` operations first, then run the operation that destroys the `CloudBackupSnapshotExportBucket` resource.

        ## Example Usage

        ### AWS Example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.CloudBackupSnapshotExportBucket("test",
            project_id="{PROJECT_ID}",
            iam_role_id="{IAM_ROLE_ID}",
            bucket_name="example-bucket",
            cloud_provider="AWS")
        ```

        ### Azure Example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.CloudBackupSnapshotExportBucket("test",
            project_id="{PROJECT_ID}",
            role_id="{ROLE_ID}",
            service_url="{SERVICE_URL}",
            bucket_name="example-bucket",
            cloud_provider="AZURE")
        ```

        ## Import

        Cloud Backup Snapshot Export Backup entries can be imported using project project_id, and bucket_id (Unique identifier of the snapshot export bucket), in the format `PROJECTID-BUCKETID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSnapshotExportBucket:CloudBackupSnapshotExportBucket test 5d0f1f73cf09a29120e173cf-5d116d82014b764445b2f9b5
        ```

        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/export/create-one-export-bucket/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket that the provided role ID is authorized to access.
        :param pulumi.Input[_builtins.str] cloud_provider: Name of the provider of the cloud service where Atlas can access the S3 bucket.
        :param pulumi.Input[_builtins.str] iam_role_id: Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.str] role_id: Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] service_url: URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] tenant_id: This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudBackupSnapshotExportBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: CloudBackupSnapshotExportBucket

        `CloudBackupSnapshotExportBucket` allows you to create an export snapshot bucket for the specified project.

        > **NOTE:** Groups and projects are synonymous terms. You may find `groupId` in the official documentation.

        > **NOTE:** To prevent errors during resource destruction, ensure that no `CloudBackupSchedule` resource that defines an automatic export policy references this resource. If you must update related `CloudBackupSchedule` resources, make these updates in isolated `pulumi up` operations first, then run the operation that destroys the `CloudBackupSnapshotExportBucket` resource.

        ## Example Usage

        ### AWS Example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.CloudBackupSnapshotExportBucket("test",
            project_id="{PROJECT_ID}",
            iam_role_id="{IAM_ROLE_ID}",
            bucket_name="example-bucket",
            cloud_provider="AWS")
        ```

        ### Azure Example

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.CloudBackupSnapshotExportBucket("test",
            project_id="{PROJECT_ID}",
            role_id="{ROLE_ID}",
            service_url="{SERVICE_URL}",
            bucket_name="example-bucket",
            cloud_provider="AZURE")
        ```

        ## Import

        Cloud Backup Snapshot Export Backup entries can be imported using project project_id, and bucket_id (Unique identifier of the snapshot export bucket), in the format `PROJECTID-BUCKETID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSnapshotExportBucket:CloudBackupSnapshotExportBucket test 5d0f1f73cf09a29120e173cf-5d116d82014b764445b2f9b5
        ```

        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/export/create-one-export-bucket/)

        :param str resource_name: The name of the resource.
        :param CloudBackupSnapshotExportBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudBackupSnapshotExportBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudBackupSnapshotExportBucketArgs.__new__(CloudBackupSnapshotExportBucketArgs)

            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            __props__.__dict__["iam_role_id"] = iam_role_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["role_id"] = role_id
            __props__.__dict__["service_url"] = service_url
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["export_bucket_id"] = None
        super(CloudBackupSnapshotExportBucket, __self__).__init__(
            'mongodbatlas:index/cloudBackupSnapshotExportBucket:CloudBackupSnapshotExportBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_provider: Optional[pulumi.Input[_builtins.str]] = None,
            export_bucket_id: Optional[pulumi.Input[_builtins.str]] = None,
            iam_role_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_url: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudBackupSnapshotExportBucket':
        """
        Get an existing CloudBackupSnapshotExportBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket that the provided role ID is authorized to access.
        :param pulumi.Input[_builtins.str] cloud_provider: Name of the provider of the cloud service where Atlas can access the S3 bucket.
        :param pulumi.Input[_builtins.str] export_bucket_id: Unique identifier of the snapshot export bucket.
        :param pulumi.Input[_builtins.str] iam_role_id: Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster.
        :param pulumi.Input[_builtins.str] role_id: Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] service_url: URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        :param pulumi.Input[_builtins.str] tenant_id: This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudBackupSnapshotExportBucketState.__new__(_CloudBackupSnapshotExportBucketState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["export_bucket_id"] = export_bucket_id
        __props__.__dict__["iam_role_id"] = iam_role_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["service_url"] = service_url
        __props__.__dict__["tenant_id"] = tenant_id
        return CloudBackupSnapshotExportBucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket that the provided role ID is authorized to access.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the provider of the cloud service where Atlas can access the S3 bucket.
        """
        return pulumi.get(self, "cloud_provider")

    @_builtins.property
    @pulumi.getter(name="exportBucketId")
    def export_bucket_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the snapshot export bucket.
        """
        return pulumi.get(self, "export_bucket_id")

    @_builtins.property
    @pulumi.getter(name="iamRoleId")
    def iam_role_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the role that Atlas can use to access the bucket. Required if `cloud_provider` is set to `AWS`.
        """
        return pulumi.get(self, "iam_role_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the Azure Service Principal that Atlas can use to access the Azure Blob Storage Container. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL that identifies the blob Endpoint of the Azure Blob Storage Account. Required if `cloud_provider` is set to `AZURE`.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    @_utilities.deprecated("""This parameter is deprecated.""")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        This field is ignored; the `mongodbatlas_cloud_provider_access_authorization.azure.tenant_id` is used instead and returned as an attribute. UUID that identifies the Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

