# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetApiKeyProjectAssignmentResult',
    'AwaitableGetApiKeyProjectAssignmentResult',
    'get_api_key_project_assignment',
    'get_api_key_project_assignment_output',
]

@pulumi.output_type
class GetApiKeyProjectAssignmentResult:
    """
    A collection of values returned by getApiKeyProjectAssignment.
    """
    def __init__(__self__, api_key_id=None, id=None, project_id=None, roles=None):
        if api_key_id and not isinstance(api_key_id, str):
            raise TypeError("Expected argument 'api_key_id' to be a str")
        pulumi.set(__self__, "api_key_id", api_key_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
        """
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "roles")


class AwaitableGetApiKeyProjectAssignmentResult(GetApiKeyProjectAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyProjectAssignmentResult(
            api_key_id=self.api_key_id,
            id=self.id,
            project_id=self.project_id,
            roles=self.roles)


def get_api_key_project_assignment(api_key_id: Optional[_builtins.str] = None,
                                   project_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyProjectAssignmentResult:
    """
    ## # Data Source: ApiKeyProjectAssignment

    `ApiKeyProjectAssignment` describes an API Key Project Assignment.

    ## Example Usage

    ### S

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    this = mongodbatlas.ApiKey("this",
        org_id=org_id,
        description="Test API Key",
        role_names=["ORG_READ_ONLY"])
    first_project = mongodbatlas.Project("first_project",
        name="First Project",
        org_id=org_id)
    second_project = mongodbatlas.Project("second_project",
        name="Second Project",
        org_id=org_id)
    first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
        project_id=first_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
        project_id=second_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    # Add IP Access List Entry to Programmatic API Key 
    this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
        org_id=org_id,
        cidr_block="0.0.0.0/1",
        api_key_id=this.api_key_id)
    ```


    :param _builtins.str api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['apiKeyId'] = api_key_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getApiKeyProjectAssignment:getApiKeyProjectAssignment', __args__, opts=opts, typ=GetApiKeyProjectAssignmentResult).value

    return AwaitableGetApiKeyProjectAssignmentResult(
        api_key_id=pulumi.get(__ret__, 'api_key_id'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        roles=pulumi.get(__ret__, 'roles'))
def get_api_key_project_assignment_output(api_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiKeyProjectAssignmentResult]:
    """
    ## # Data Source: ApiKeyProjectAssignment

    `ApiKeyProjectAssignment` describes an API Key Project Assignment.

    ## Example Usage

    ### S

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    this = mongodbatlas.ApiKey("this",
        org_id=org_id,
        description="Test API Key",
        role_names=["ORG_READ_ONLY"])
    first_project = mongodbatlas.Project("first_project",
        name="First Project",
        org_id=org_id)
    second_project = mongodbatlas.Project("second_project",
        name="Second Project",
        org_id=org_id)
    first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
        project_id=first_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
        project_id=second_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    # Add IP Access List Entry to Programmatic API Key 
    this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
        org_id=org_id,
        cidr_block="0.0.0.0/1",
        api_key_id=this.api_key_id)
    ```


    :param _builtins.str api_key_id: Unique 24-hexadecimal digit string that identifies this organization API key that you want to assign to one project.
    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['apiKeyId'] = api_key_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getApiKeyProjectAssignment:getApiKeyProjectAssignment', __args__, opts=opts, typ=GetApiKeyProjectAssignmentResult)
    return __ret__.apply(lambda __response__: GetApiKeyProjectAssignmentResult(
        api_key_id=pulumi.get(__response__, 'api_key_id'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        roles=pulumi.get(__response__, 'roles')))
