# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiKeyProjectAssignmentsResult',
    'AwaitableGetApiKeyProjectAssignmentsResult',
    'get_api_key_project_assignments',
    'get_api_key_project_assignments_output',
]

@pulumi.output_type
class GetApiKeyProjectAssignmentsResult:
    """
    A collection of values returned by getApiKeyProjectAssignments.
    """
    def __init__(__self__, id=None, project_id=None, results=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetApiKeyProjectAssignmentsResultResult']:
        return pulumi.get(self, "results")


class AwaitableGetApiKeyProjectAssignmentsResult(GetApiKeyProjectAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyProjectAssignmentsResult(
            id=self.id,
            project_id=self.project_id,
            results=self.results)


def get_api_key_project_assignments(project_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyProjectAssignmentsResult:
    """
    ## # Data Source: get_api_key_project_assignments

    `get_api_key_project_assignments` provides an API Key Project Assignments data source. The data source lets you list all API key project assignments for an organization.

    ## Example Usage

    ### S

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    this = mongodbatlas.ApiKey("this",
        org_id=org_id,
        description="Test API Key",
        role_names=["ORG_READ_ONLY"])
    first_project = mongodbatlas.Project("first_project",
        name="First Project",
        org_id=org_id)
    second_project = mongodbatlas.Project("second_project",
        name="Second Project",
        org_id=org_id)
    first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
        project_id=first_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
        project_id=second_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    # Add IP Access List Entry to Programmatic API Key 
    this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
        org_id=org_id,
        cidr_block="0.0.0.0/1",
        api_key_id=this.api_key_id)
    ```


    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getApiKeyProjectAssignments:getApiKeyProjectAssignments', __args__, opts=opts, typ=GetApiKeyProjectAssignmentsResult).value

    return AwaitableGetApiKeyProjectAssignmentsResult(
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        results=pulumi.get(__ret__, 'results'))
def get_api_key_project_assignments_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiKeyProjectAssignmentsResult]:
    """
    ## # Data Source: get_api_key_project_assignments

    `get_api_key_project_assignments` provides an API Key Project Assignments data source. The data source lets you list all API key project assignments for an organization.

    ## Example Usage

    ### S

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    this = mongodbatlas.ApiKey("this",
        org_id=org_id,
        description="Test API Key",
        role_names=["ORG_READ_ONLY"])
    first_project = mongodbatlas.Project("first_project",
        name="First Project",
        org_id=org_id)
    second_project = mongodbatlas.Project("second_project",
        name="Second Project",
        org_id=org_id)
    first_assignment = mongodbatlas.ApiKeyProjectAssignment("first_assignment",
        project_id=first_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    second_assignment = mongodbatlas.ApiKeyProjectAssignment("second_assignment",
        project_id=second_project.id,
        api_key_id=this.api_key_id,
        roles=["GROUP_OWNER"])
    # Add IP Access List Entry to Programmatic API Key 
    this_access_list_api_key = mongodbatlas.AccessListApiKey("this",
        org_id=org_id,
        cidr_block="0.0.0.0/1",
        api_key_id=this.api_key_id)
    ```


    :param _builtins.str project_id: Unique 24-hexadecimal digit string that identifies your project. Use the /groups endpoint to retrieve all projects to which the authenticated user has access.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getApiKeyProjectAssignments:getApiKeyProjectAssignments', __args__, opts=opts, typ=GetApiKeyProjectAssignmentsResult)
    return __ret__.apply(lambda __response__: GetApiKeyProjectAssignmentsResult(
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        results=pulumi.get(__response__, 'results')))
