# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PrivateLinkEndpointArgs', 'PrivateLinkEndpoint']

@pulumi.input_type
class PrivateLinkEndpointArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 provider_name: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PrivateLinkEndpoint resource.
        :param pulumi.Input[_builtins.str] project_id: Required 	Unique identifier for the project.
        :param pulumi.Input[_builtins.str] provider_name: Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        :param pulumi.Input[_builtins.str] region: Cloud provider region in which you want to create the private endpoint connection.
               Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required 	Unique identifier for the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Cloud provider region in which you want to create the private endpoint connection.
        Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PrivateLinkEndpointState:
    def __init__(__self__, *,
                 endpoint_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 error_message: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_service_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_attachment_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateLinkEndpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_group_names: GCP network endpoint groups corresponding to the Private Service Connect endpoint service.
        :param pulumi.Input[_builtins.str] endpoint_service_name: Name of the PrivateLink endpoint service in AWS. Returns null while the endpoint service is being created.
        :param pulumi.Input[_builtins.str] error_message: Error message pertaining to the AWS PrivateLink connection. Returns null if there are no errors.
               AWS:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_endpoints: Unique identifiers of the interface endpoints in your VPC that you added to the AWS PrivateLink connection.
               AZURE:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_endpoints: All private endpoints that you have added to this Azure Private Link Service.
        :param pulumi.Input[_builtins.str] private_link_id: Unique identifier of the AWS PrivateLink connection.
        :param pulumi.Input[_builtins.str] private_link_service_name: Name of the Azure Private Link Service that Atlas manages.
               GCP:
        :param pulumi.Input[_builtins.str] project_id: Required 	Unique identifier for the project.
        :param pulumi.Input[_builtins.str] provider_name: Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        :param pulumi.Input[_builtins.str] region: Cloud provider region in which you want to create the private endpoint connection.
               Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        :param pulumi.Input[_builtins.str] region_name: GCP region for the Private Service Connect endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_attachment_names: Unique alphanumeric and special character strings that identify the service attachments associated with the GCP Private Service Connect endpoint service. Returns an empty list while Atlas creates the service attachments.
        :param pulumi.Input[_builtins.str] status: Status of the AWS PrivateLink connection or Status of the Azure Private Link Service. Atlas returns one of the following values:
               AWS:
               * `AVAILABLE` 	Atlas is creating the network load balancer and VPC endpoint service.
               * `WAITING_FOR_USER` The Atlas network load balancer and VPC endpoint service are created and ready to receive connection requests. When you receive this status, create an interface endpoint to continue configuring the AWS PrivateLink connection.
               * `FAILED` 	A system failure has occurred.
               * `DELETING` 	The AWS PrivateLink connection is being deleted.
               AZURE:
               * `AVAILABLE` 	Atlas created the load balancer and the Private Link Service.
               * `INITIATING` 	Atlas is creating the load balancer and the Private Link Service.
               * `FAILED` 	Atlas failed to create the load balancer and the Private Link service.
               * `DELETING` 	Atlas is deleting the Private Link service.
               GCP:
               * `AVAILABLE` 	Atlas created the load balancer and the GCP Private Service Connect service.
               * `INITIATING` 	Atlas is creating the load balancer and the GCP Private Service Connect service.
               * `FAILED`  	Atlas failed to create the load balancer and the GCP Private Service Connect service.
               * `DELETING` 	Atlas is deleting the GCP Private Service Connect service.
        """
        if endpoint_group_names is not None:
            pulumi.set(__self__, "endpoint_group_names", endpoint_group_names)
        if endpoint_service_name is not None:
            pulumi.set(__self__, "endpoint_service_name", endpoint_service_name)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if interface_endpoints is not None:
            pulumi.set(__self__, "interface_endpoints", interface_endpoints)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if private_link_id is not None:
            pulumi.set(__self__, "private_link_id", private_link_id)
        if private_link_service_name is not None:
            pulumi.set(__self__, "private_link_service_name", private_link_service_name)
        if private_link_service_resource_id is not None:
            pulumi.set(__self__, "private_link_service_resource_id", private_link_service_resource_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)
        if service_attachment_names is not None:
            pulumi.set(__self__, "service_attachment_names", service_attachment_names)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="endpointGroupNames")
    def endpoint_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        GCP network endpoint groups corresponding to the Private Service Connect endpoint service.
        """
        return pulumi.get(self, "endpoint_group_names")

    @endpoint_group_names.setter
    def endpoint_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_group_names", value)

    @_builtins.property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the PrivateLink endpoint service in AWS. Returns null while the endpoint service is being created.
        """
        return pulumi.get(self, "endpoint_service_name")

    @endpoint_service_name.setter
    def endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_service_name", value)

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message pertaining to the AWS PrivateLink connection. Returns null if there are no errors.
        AWS:
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_message", value)

    @_builtins.property
    @pulumi.getter(name="interfaceEndpoints")
    def interface_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Unique identifiers of the interface endpoints in your VPC that you added to the AWS PrivateLink connection.
        AZURE:
        """
        return pulumi.get(self, "interface_endpoints")

    @interface_endpoints.setter
    def interface_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "interface_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All private endpoints that you have added to this Azure Private Link Service.
        """
        return pulumi.get(self, "private_endpoints")

    @private_endpoints.setter
    def private_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkId")
    def private_link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the AWS PrivateLink connection.
        """
        return pulumi.get(self, "private_link_id")

    @private_link_id.setter
    def private_link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_id", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceName")
    def private_link_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Azure Private Link Service that Atlas manages.
        GCP:
        """
        return pulumi.get(self, "private_link_service_name")

    @private_link_service_name.setter
    def private_link_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_service_name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceResourceId")
    def private_link_service_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_link_service_resource_id")

    @private_link_service_resource_id.setter
    def private_link_service_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_link_service_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required 	Unique identifier for the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud provider region in which you want to create the private endpoint connection.
        Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        GCP region for the Private Service Connect endpoint service.
        """
        return pulumi.get(self, "region_name")

    @region_name.setter
    def region_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAttachmentNames")
    def service_attachment_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Unique alphanumeric and special character strings that identify the service attachments associated with the GCP Private Service Connect endpoint service. Returns an empty list while Atlas creates the service attachments.
        """
        return pulumi.get(self, "service_attachment_names")

    @service_attachment_names.setter
    def service_attachment_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "service_attachment_names", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the AWS PrivateLink connection or Status of the Azure Private Link Service. Atlas returns one of the following values:
        AWS:
        * `AVAILABLE` 	Atlas is creating the network load balancer and VPC endpoint service.
        * `WAITING_FOR_USER` The Atlas network load balancer and VPC endpoint service are created and ready to receive connection requests. When you receive this status, create an interface endpoint to continue configuring the AWS PrivateLink connection.
        * `FAILED` 	A system failure has occurred.
        * `DELETING` 	The AWS PrivateLink connection is being deleted.
        AZURE:
        * `AVAILABLE` 	Atlas created the load balancer and the Private Link Service.
        * `INITIATING` 	Atlas is creating the load balancer and the Private Link Service.
        * `FAILED` 	Atlas failed to create the load balancer and the Private Link service.
        * `DELETING` 	Atlas is deleting the Private Link service.
        GCP:
        * `AVAILABLE` 	Atlas created the load balancer and the GCP Private Service Connect service.
        * `INITIATING` 	Atlas is creating the load balancer and the GCP Private Service Connect service.
        * `FAILED`  	Atlas failed to create the load balancer and the GCP Private Service Connect service.
        * `DELETING` 	Atlas is deleting the GCP Private Service Connect service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("mongodbatlas:index/privateLinkEndpoint:PrivateLinkEndpoint")
class PrivateLinkEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.PrivateLinkEndpoint("test",
            project_id="<PROJECT-ID>",
            provider_name="AWS/AZURE",
            region="US_EAST_1")
        ```

        ### Available complete examples
        - Setup private connection to a MongoDB Atlas Cluster with AWS VPC

        ## Import

        Private Endpoint Service can be imported using project ID, private link ID, provider name and region, in the format `{project_id}-{private_link_id}-{provider_name}-{region}`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/privateLinkEndpoint:PrivateLinkEndpoint test 1112222b3bf99403840e8934-3242342343112-AWS-us-east-1
        ```
        See detailed information for arguments and attributes: [MongoDB API Private Endpoint Service](https://docs.atlas.mongodb.com/reference/api/private-endpoints-service-create-one/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: Required 	Unique identifier for the project.
        :param pulumi.Input[_builtins.str] provider_name: Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        :param pulumi.Input[_builtins.str] region: Cloud provider region in which you want to create the private endpoint connection.
               Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateLinkEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.PrivateLinkEndpoint("test",
            project_id="<PROJECT-ID>",
            provider_name="AWS/AZURE",
            region="US_EAST_1")
        ```

        ### Available complete examples
        - Setup private connection to a MongoDB Atlas Cluster with AWS VPC

        ## Import

        Private Endpoint Service can be imported using project ID, private link ID, provider name and region, in the format `{project_id}-{private_link_id}-{provider_name}-{region}`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/privateLinkEndpoint:PrivateLinkEndpoint test 1112222b3bf99403840e8934-3242342343112-AWS-us-east-1
        ```
        See detailed information for arguments and attributes: [MongoDB API Private Endpoint Service](https://docs.atlas.mongodb.com/reference/api/private-endpoints-service-create-one/)

        :param str resource_name: The name of the resource.
        :param PrivateLinkEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateLinkEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateLinkEndpointArgs.__new__(PrivateLinkEndpointArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'provider_name'")
            __props__.__dict__["provider_name"] = provider_name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["endpoint_group_names"] = None
            __props__.__dict__["endpoint_service_name"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["interface_endpoints"] = None
            __props__.__dict__["private_endpoints"] = None
            __props__.__dict__["private_link_id"] = None
            __props__.__dict__["private_link_service_name"] = None
            __props__.__dict__["private_link_service_resource_id"] = None
            __props__.__dict__["region_name"] = None
            __props__.__dict__["service_attachment_names"] = None
            __props__.__dict__["status"] = None
        super(PrivateLinkEndpoint, __self__).__init__(
            'mongodbatlas:index/privateLinkEndpoint:PrivateLinkEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            error_message: Optional[pulumi.Input[_builtins.str]] = None,
            interface_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_link_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_service_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            provider_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            region_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_attachment_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateLinkEndpoint':
        """
        Get an existing PrivateLinkEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_group_names: GCP network endpoint groups corresponding to the Private Service Connect endpoint service.
        :param pulumi.Input[_builtins.str] endpoint_service_name: Name of the PrivateLink endpoint service in AWS. Returns null while the endpoint service is being created.
        :param pulumi.Input[_builtins.str] error_message: Error message pertaining to the AWS PrivateLink connection. Returns null if there are no errors.
               AWS:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] interface_endpoints: Unique identifiers of the interface endpoints in your VPC that you added to the AWS PrivateLink connection.
               AZURE:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_endpoints: All private endpoints that you have added to this Azure Private Link Service.
        :param pulumi.Input[_builtins.str] private_link_id: Unique identifier of the AWS PrivateLink connection.
        :param pulumi.Input[_builtins.str] private_link_service_name: Name of the Azure Private Link Service that Atlas manages.
               GCP:
        :param pulumi.Input[_builtins.str] project_id: Required 	Unique identifier for the project.
        :param pulumi.Input[_builtins.str] provider_name: Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        :param pulumi.Input[_builtins.str] region: Cloud provider region in which you want to create the private endpoint connection.
               Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        :param pulumi.Input[_builtins.str] region_name: GCP region for the Private Service Connect endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] service_attachment_names: Unique alphanumeric and special character strings that identify the service attachments associated with the GCP Private Service Connect endpoint service. Returns an empty list while Atlas creates the service attachments.
        :param pulumi.Input[_builtins.str] status: Status of the AWS PrivateLink connection or Status of the Azure Private Link Service. Atlas returns one of the following values:
               AWS:
               * `AVAILABLE` 	Atlas is creating the network load balancer and VPC endpoint service.
               * `WAITING_FOR_USER` The Atlas network load balancer and VPC endpoint service are created and ready to receive connection requests. When you receive this status, create an interface endpoint to continue configuring the AWS PrivateLink connection.
               * `FAILED` 	A system failure has occurred.
               * `DELETING` 	The AWS PrivateLink connection is being deleted.
               AZURE:
               * `AVAILABLE` 	Atlas created the load balancer and the Private Link Service.
               * `INITIATING` 	Atlas is creating the load balancer and the Private Link Service.
               * `FAILED` 	Atlas failed to create the load balancer and the Private Link service.
               * `DELETING` 	Atlas is deleting the Private Link service.
               GCP:
               * `AVAILABLE` 	Atlas created the load balancer and the GCP Private Service Connect service.
               * `INITIATING` 	Atlas is creating the load balancer and the GCP Private Service Connect service.
               * `FAILED`  	Atlas failed to create the load balancer and the GCP Private Service Connect service.
               * `DELETING` 	Atlas is deleting the GCP Private Service Connect service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateLinkEndpointState.__new__(_PrivateLinkEndpointState)

        __props__.__dict__["endpoint_group_names"] = endpoint_group_names
        __props__.__dict__["endpoint_service_name"] = endpoint_service_name
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["interface_endpoints"] = interface_endpoints
        __props__.__dict__["private_endpoints"] = private_endpoints
        __props__.__dict__["private_link_id"] = private_link_id
        __props__.__dict__["private_link_service_name"] = private_link_service_name
        __props__.__dict__["private_link_service_resource_id"] = private_link_service_resource_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_name"] = region_name
        __props__.__dict__["service_attachment_names"] = service_attachment_names
        __props__.__dict__["status"] = status
        return PrivateLinkEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endpointGroupNames")
    def endpoint_group_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        GCP network endpoint groups corresponding to the Private Service Connect endpoint service.
        """
        return pulumi.get(self, "endpoint_group_names")

    @_builtins.property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the PrivateLink endpoint service in AWS. Returns null while the endpoint service is being created.
        """
        return pulumi.get(self, "endpoint_service_name")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[_builtins.str]:
        """
        Error message pertaining to the AWS PrivateLink connection. Returns null if there are no errors.
        AWS:
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="interfaceEndpoints")
    def interface_endpoints(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Unique identifiers of the interface endpoints in your VPC that you added to the AWS PrivateLink connection.
        AZURE:
        """
        return pulumi.get(self, "interface_endpoints")

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All private endpoints that you have added to this Azure Private Link Service.
        """
        return pulumi.get(self, "private_endpoints")

    @_builtins.property
    @pulumi.getter(name="privateLinkId")
    def private_link_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the AWS PrivateLink connection.
        """
        return pulumi.get(self, "private_link_id")

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceName")
    def private_link_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Azure Private Link Service that Atlas manages.
        GCP:
        """
        return pulumi.get(self, "private_link_service_name")

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceResourceId")
    def private_link_service_resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "private_link_service_resource_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required 	Unique identifier for the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cloud provider for which you want to create the private endpoint service. Atlas accepts `AWS`, `AZURE` or `GCP`.
        """
        return pulumi.get(self, "provider_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud provider region in which you want to create the private endpoint connection.
        Accepted values are: [AWS regions](https://docs.atlas.mongodb.com/reference/amazon-aws/#amazon-aws), [AZURE regions](https://docs.atlas.mongodb.com/reference/microsoft-azure/#microsoft-azure) and [GCP regions](https://docs.atlas.mongodb.com/reference/google-gcp/#std-label-google-gcp)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> pulumi.Output[_builtins.str]:
        """
        GCP region for the Private Service Connect endpoint service.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="serviceAttachmentNames")
    def service_attachment_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Unique alphanumeric and special character strings that identify the service attachments associated with the GCP Private Service Connect endpoint service. Returns an empty list while Atlas creates the service attachments.
        """
        return pulumi.get(self, "service_attachment_names")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the AWS PrivateLink connection or Status of the Azure Private Link Service. Atlas returns one of the following values:
        AWS:
        * `AVAILABLE` 	Atlas is creating the network load balancer and VPC endpoint service.
        * `WAITING_FOR_USER` The Atlas network load balancer and VPC endpoint service are created and ready to receive connection requests. When you receive this status, create an interface endpoint to continue configuring the AWS PrivateLink connection.
        * `FAILED` 	A system failure has occurred.
        * `DELETING` 	The AWS PrivateLink connection is being deleted.
        AZURE:
        * `AVAILABLE` 	Atlas created the load balancer and the Private Link Service.
        * `INITIATING` 	Atlas is creating the load balancer and the Private Link Service.
        * `FAILED` 	Atlas failed to create the load balancer and the Private Link service.
        * `DELETING` 	Atlas is deleting the Private Link service.
        GCP:
        * `AVAILABLE` 	Atlas created the load balancer and the GCP Private Service Connect service.
        * `INITIATING` 	Atlas is creating the load balancer and the GCP Private Service Connect service.
        * `FAILED`  	Atlas failed to create the load balancer and the GCP Private Service Connect service.
        * `DELETING` 	Atlas is deleting the GCP Private Service Connect service.
        """
        return pulumi.get(self, "status")

