# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SearchDeploymentArgs', 'SearchDeployment']

@pulumi.input_type
class SearchDeploymentArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 specs: pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]],
                 delete_on_create_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_wait_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a SearchDeployment resource.
        :param pulumi.Input[_builtins.str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        :param pulumi.Input[_builtins.bool] delete_on_create_timeout: Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "specs", specs)
        if delete_on_create_timeout is not None:
            pulumi.set(__self__, "delete_on_create_timeout", delete_on_create_timeout)
        if skip_wait_on_update is not None:
            pulumi.set(__self__, "skip_wait_on_update", skip_wait_on_update)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def specs(self) -> pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]):
        pulumi.set(self, "specs", value)

    @_builtins.property
    @pulumi.getter(name="deleteOnCreateTimeout")
    def delete_on_create_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        """
        return pulumi.get(self, "delete_on_create_timeout")

    @delete_on_create_timeout.setter
    def delete_on_create_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_create_timeout", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitOnUpdate")
    def skip_wait_on_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_update")

    @skip_wait_on_update.setter
    def skip_wait_on_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_on_update", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _SearchDeploymentState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_on_create_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]] = None,
                 state_name: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering SearchDeployment resources.
        :param pulumi.Input[_builtins.str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[_builtins.bool] delete_on_create_timeout: Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Cloud service provider that manages your customer keys to provide an additional layer of Encryption At Rest for the cluster.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        :param pulumi.Input[_builtins.str] state_name: Human-readable label that indicates the current operating condition of this search deployment.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if delete_on_create_timeout is not None:
            pulumi.set(__self__, "delete_on_create_timeout", delete_on_create_timeout)
        if encryption_at_rest_provider is not None:
            pulumi.set(__self__, "encryption_at_rest_provider", encryption_at_rest_provider)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if skip_wait_on_update is not None:
            pulumi.set(__self__, "skip_wait_on_update", skip_wait_on_update)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if state_name is not None:
            pulumi.set(__self__, "state_name", state_name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="deleteOnCreateTimeout")
    def delete_on_create_timeout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        """
        return pulumi.get(self, "delete_on_create_timeout")

    @delete_on_create_timeout.setter
    def delete_on_create_timeout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_create_timeout", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud service provider that manages your customer keys to provide an additional layer of Encryption At Rest for the cluster.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @encryption_at_rest_provider.setter
    def encryption_at_rest_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_at_rest_provider", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="skipWaitOnUpdate")
    def skip_wait_on_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_update")

    @skip_wait_on_update.setter
    def skip_wait_on_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_wait_on_update", value)

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @_builtins.property
    @pulumi.getter(name="stateName")
    def state_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable label that indicates the current operating condition of this search deployment.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_name", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("mongodbatlas:index/searchDeployment:SearchDeployment")
class SearchDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_on_create_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SearchDeploymentSpecArgs', 'SearchDeploymentSpecArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SearchDeploymentTimeoutsArgs', 'SearchDeploymentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        ## # Resource: SearchDeployment

        `SearchDeployment` provides a Search Deployment resource. The resource lets you create, edit and delete dedicated search nodes in a cluster.

        > **NOTE:** For details on supported cloud providers and existing limitations you can visit the [Search Node Documentation](https://www.mongodb.com/docs/atlas/cluster-config/multi-cloud-distribution/#search-nodes-for-workload-isolation).

        > **NOTE:** Only a single search deployment resource can be defined for each cluster.

        ## Example Usage

        ## Import

        Search node resource can be imported using the project ID and cluster name, in the format `PROJECT_ID-CLUSTER_NAME`, e.g.

        After an import, a non-empty plan is expected if the configuration defines the `skip_wait_on_update` attribute. However, the update will not have any effect on the search deployment since `skip_wait_on_update` only relates to the update operations wait time.

        For more information see: [MongoDB Atlas API - Search Node](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Atlas-Search/operation/createAtlasSearchDeployment) Documentation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[_builtins.bool] delete_on_create_timeout: Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SearchDeploymentSpecArgs', 'SearchDeploymentSpecArgsDict']]]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SearchDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: SearchDeployment

        `SearchDeployment` provides a Search Deployment resource. The resource lets you create, edit and delete dedicated search nodes in a cluster.

        > **NOTE:** For details on supported cloud providers and existing limitations you can visit the [Search Node Documentation](https://www.mongodb.com/docs/atlas/cluster-config/multi-cloud-distribution/#search-nodes-for-workload-isolation).

        > **NOTE:** Only a single search deployment resource can be defined for each cluster.

        ## Example Usage

        ## Import

        Search node resource can be imported using the project ID and cluster name, in the format `PROJECT_ID-CLUSTER_NAME`, e.g.

        After an import, a non-empty plan is expected if the configuration defines the `skip_wait_on_update` attribute. However, the update will not have any effect on the search deployment since `skip_wait_on_update` only relates to the update operations wait time.

        For more information see: [MongoDB Atlas API - Search Node](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Atlas-Search/operation/createAtlasSearchDeployment) Documentation.

        :param str resource_name: The name of the resource.
        :param SearchDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SearchDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_on_create_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_wait_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SearchDeploymentSpecArgs', 'SearchDeploymentSpecArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['SearchDeploymentTimeoutsArgs', 'SearchDeploymentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SearchDeploymentArgs.__new__(SearchDeploymentArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["delete_on_create_timeout"] = delete_on_create_timeout
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["skip_wait_on_update"] = skip_wait_on_update
            if specs is None and not opts.urn:
                raise TypeError("Missing required property 'specs'")
            __props__.__dict__["specs"] = specs
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["encryption_at_rest_provider"] = None
            __props__.__dict__["state_name"] = None
        super(SearchDeployment, __self__).__init__(
            'mongodbatlas:index/searchDeployment:SearchDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            delete_on_create_timeout: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_at_rest_provider: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            skip_wait_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
            specs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SearchDeploymentSpecArgs', 'SearchDeploymentSpecArgsDict']]]]] = None,
            state_name: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['SearchDeploymentTimeoutsArgs', 'SearchDeploymentTimeoutsArgsDict']]] = None) -> 'SearchDeployment':
        """
        Get an existing SearchDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[_builtins.bool] delete_on_create_timeout: Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        :param pulumi.Input[_builtins.str] encryption_at_rest_provider: Cloud service provider that manages your customer keys to provide an additional layer of Encryption At Rest for the cluster.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SearchDeploymentSpecArgs', 'SearchDeploymentSpecArgsDict']]]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        :param pulumi.Input[_builtins.str] state_name: Human-readable label that indicates the current operating condition of this search deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SearchDeploymentState.__new__(_SearchDeploymentState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["delete_on_create_timeout"] = delete_on_create_timeout
        __props__.__dict__["encryption_at_rest_provider"] = encryption_at_rest_provider
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["skip_wait_on_update"] = skip_wait_on_update
        __props__.__dict__["specs"] = specs
        __props__.__dict__["state_name"] = state_name
        __props__.__dict__["timeouts"] = timeouts
        return SearchDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="deleteOnCreateTimeout")
    def delete_on_create_timeout(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that indicates whether to delete the search deployment if the creation times out, default is false.
        """
        return pulumi.get(self, "delete_on_create_timeout")

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestProvider")
    def encryption_at_rest_provider(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud service provider that manages your customer keys to provide an additional layer of Encryption At Rest for the cluster.
        """
        return pulumi.get(self, "encryption_at_rest_provider")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="skipWaitOnUpdate")
    def skip_wait_on_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "skip_wait_on_update")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> pulumi.Output[Sequence['outputs.SearchDeploymentSpec']]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @_builtins.property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable label that indicates the current operating condition of this search deployment.
        """
        return pulumi.get(self, "state_name")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.SearchDeploymentTimeouts']]:
        return pulumi.get(self, "timeouts")

