# -*- coding: UTF-8 -*-
# generated by lino.sphinxcontrib.help_text_builder
# fmt: off
from django.utils.translation import gettext_lazy as _

help_texts = {
    'lino.AppConfig' : _("""This is the only django.apps.AppConfig object used by Lino. Lino applications instead use the lino.core.plugins.Plugin class to define plugins. See /dev/plugins."""),
    'lino.mixins.Contactable' : _("""Mixin for models that represent somebody who can be contacted by email."""),
    'lino.mixins.Contactable.get_as_user' : _("""Return the user object representing this contactable."""),
    'lino.mixins.Phonable' : _("""Mixin for models that represent somebody who can be contacted by phone."""),
    'lino.mixins.Modified' : _("""Adds a a timestamp field that holds the last modification time of every individual database object."""),
    'lino.mixins.Modified.modified' : _("""The time when this database object was last modified."""),
    'lino.mixins.Modified.auto_touch' : _("""Whether to touch objects automatically when saving them."""),
    'lino.mixins.Created' : _("""Adds a timestamp field that holds the creation time of every individual database row."""),
    'lino.mixins.Created.created' : _("""The time when this database row was created."""),
    'lino.mixins.CreatedModified' : _("""Adds two timestamp fields created and modified."""),
    'lino.mixins.ProjectRelated' : _("""Mixin for models that are related to a “project”, i.e. to an object of the type given by your lino.core.site.Site.project_model."""),
    'lino.mixins.ProjectRelated.project' : _("""Pointer to the project to which this object is related."""),
    'lino.mixins.ProjectRelated.update_owned_instance' : _("""When a project-related object controls another project-related object, then the controlled automatically inherits the project of its controller."""),
    'lino.mixins.clonable.CloneRow' : _("""See /dev/duplicate."""),
    'lino.mixins.clonable.Clonable' : _("""See /dev/duplicate."""),
    'lino.mixins.dupable.CheckedSubmitInsert' : _("""Like the standard lino.core.actions.SubmitInsert, but adds a confirmation if there is a possible duplicate record."""),
    'lino.mixins.dupable.PhoneticWordBase' : _("""Base class for the table of phonetic words of a given dupable model. For every (non-abstract) dupable model there must be a subclass of PhoneticWordBase. The subclass must define a field owner which points to the Dupable, and the Dupable’s dupable_word_model must point to its subclass of PhoneticWordBase."""),
    'lino.mixins.dupable.Dupable' : _("""Base class for models that can be “dupable”."""),
    'lino.mixins.dupable.Dupable.submit_insert' : _("""A dupable model has its submit_insert action overridden by CheckedSubmitInsert, a extended variant of the action which checks for duplicate rows and asks a user confirmation when necessary."""),
    'lino.mixins.dupable.Dupable.dupable_words_field' : _("""The name of a CharField on this model which holds the full-text description that is being tested for duplicates."""),
    'lino.mixins.dupable.Dupable.dupable_word_model' : _("""Full name of the model used to hold dupable words for instances of this model. Applications can specify a string which will be resolved at startup to the model’s class object."""),
    'lino.mixins.dupable.Dupable.on_analyze' : _("""Setup the dupable_word_model attribute. This will be called only on concrete subclasses."""),
    'lino.mixins.dupable.Dupable.dupable_matches_required' : _("""Return the minimum number of words that must sound alike before two rows should be considered similar."""),
    'lino.mixins.dupable.Dupable.update_dupable_words' : _("""Update the phonetic words of this row."""),
    'lino.mixins.dupable.Dupable.find_similar_instances' : _("""Return a queryset or yield a list of similar objects."""),
    'lino.mixins.dupable.DupableChecker' : _("""Checks for the following repairable problem:"""),
    'lino.mixins.dupable.DupableChecker.model' : _("""alias of Dupable"""),
    'lino.mixins.dupable.SimilarObjects' : _("""Shows the other objects that are similar to this one."""),
    'lino.mixins.human.Human' : _("""Base class for models that represent a human."""),
    'lino.mixins.human.Human.title' : _("""Used to specify a professional position or academic qualification like “Dr.” or “PhD”."""),
    'lino.mixins.human.Human.first_name' : _("""The first name, also known as given name."""),
    'lino.mixins.human.Human.last_name' : _("""The last name, also known as family name."""),
    'lino.mixins.human.Human.middle_name' : _("""A space-separated list of all middle names."""),
    'lino.mixins.human.Human.gender' : _("""The sex of this person (male or female)."""),
    'lino.mixins.human.Human.mf' : _("""Taking three parameters m, f and u of any type, returns one of them depending on whether this Person is male, female or of unknown gender."""),
    'lino.mixins.human.Human.get_last_name_prefix' : _("""May be used for handling special of titles (e.g. “Cardinal”, “Graf”) which come before the last name (not before the first name)."""),
    'lino.mixins.human.Human.get_full_name' : _("""Returns a one-line string composed of salutation, first_name and last_name."""),
    'lino.mixins.human.Human.format_family_member' : _("""Used in humanlinks.LinksByHuman and in households.SiblingsByPerson."""),
    'lino.mixins.human.Born' : _("""Abstract base class that adds a birth_date field and a virtual field “Age”."""),
    'lino.mixins.human.Born.birth_date' : _("""An IncompleteDateField."""),
    'lino.mixins.human.Born.age' : _("""Virtual field displaying the age in years."""),
    'lino.mixins.human.Born.get_age' : _("""Return the age (in years) of this human. See lino.utils.IncompleteDate.get_age()."""),
    'lino.mixins.human.Born.get_exact_age' : _("""Return the age as a datetime.timedelta object."""),
    'lino.mixins.periods.CombinedDateTime' : _("""Mixin for models having at least one couple of date and time fields that form a kind of editable timestamp field."""),
    'lino.mixins.periods.CombinedDateTime.get_time_zone' : _("""The time zone for the date and time fields in this model."""),
    'lino.mixins.periods.CombinedDateTime.set_datetime' : _("""Given a datetime value, update the two corresponding fields FOO_date and FOO_time (where FOO is specified in name which must be either “start” or “end”)."""),
    'lino.mixins.periods.CombinedDateTime.get_datetime' : _("""Return a datetime value from the two corresponding date and time fields."""),
    'lino.mixins.periods.Started' : _("""Adds two fields start_date and start_time."""),
    'lino.mixins.periods.Started.save' : _("""Fills default value “today” to start_date"""),
    'lino.mixins.periods.Ended' : _("""Mixin for models with two fields end_date and end_time."""),
    'lino.mixins.periods.Ended.get_duration' : _("""Return the duration in hours."""),
    'lino.mixins.periods.DateRange' : _("""A model mixin that adds two fields start_date and end_date. DateRangeObservable"""),
    'lino.mixins.periods.ObservedDateRange' : _("""lino.core.param_panel.ParameterPanel with two fields start_date and end_date."""),
    'lino.mixins.periods.Yearly' : _("""An ObservedDateRange for which start_date defaults to Jan 1st and end_date to Dec 31 of the current year."""),
    'lino.mixins.periods.Monthly' : _("""An ObservedDateRange which defaults to the current month."""),
    'lino.mixins.periods.Weekly' : _("""An ObservedDateRange which defaults to the current week."""),
    'lino.mixins.periods.Today' : _("""A ParameterPanel with a field today that defaults to today."""),
    'lino.mixins.polymorphic.Polymorphic' : _("""Mixin for models that use Multiple Table Inheritance to implement polymorphism."""),
    'lino.mixins.polymorphic.Polymorphic.mti_navigator' : _("""A virtual field which defines buttons for switching between the different views."""),
    'lino.mixins.polymorphic.Polymorphic.get_mti_child' : _("""Return the specified specialization or None."""),
    'lino.mixins.polymorphic.Polymorphic.disable_delete' : _("""Overrides lino.core.model.Model.disable_delete()."""),
    'lino.mixins.ref.Referrable' : _("""Mixin for things that have a unique reference, i.e. an identifying name used by humans to refer to an individual object."""),
    'lino.mixins.ref.Referrable.ref' : _("""The reference. This must be either empty or unique."""),
    'lino.mixins.ref.Referrable.ref_max_length' : _("""The preferred width of the ref field."""),
    'lino.mixins.ref.Referrable.on_duplicate' : _("""Before saving a duplicated object for the first time, we must change the ref in order to avoid an IntegrityError."""),
    'lino.mixins.ref.Referrable.get_next_row' : _("""Return the next database row, or None if this is the last one."""),
    'lino.mixins.ref.Referrable.get_by_ref' : _("""Return the object identified by the given reference."""),
    'lino.mixins.ref.Referrable.quick_search_filter' : _("""Overrides the default behaviour defined in lino.core.model.Model.quick_search_filter(). For Referrable objects, when quick-searching for a text containing only digits, the user usually means the ref and not the primary key."""),
    'lino.mixins.ref.StructuredReferrable' : _("""A referrable whose ref field is used to define a hierarchical structure."""),
    'lino.mixins.ref.StructuredReferrable.ref_description' : _("""Displays the structured together with the designation."""),
    'lino.mixins.ref.StructuredReferrable.get_designation' : _("""Return the “designation” part (without the reference)."""),
    'lino.mixins.registrable.RegistrableState' : _("""Base class for the choices of the choicelist that defines the state field of any Registrable."""),
    'lino.mixins.registrable.RegistrableState.is_editable' : _("""Whether the registrable object having this state should be editable or not."""),
    'lino.mixins.registrable.Registrable' : _("""Base class to anything that may be “registered” and “deregistered”, where “registered” means “this object has been taken account of”."""),
    'lino.mixins.registrable.Registrable.state' : _("""The workflow state field."""),
    'lino.mixins.registrable.Registrable.get_registrable_fields' : _("""Return a list of the fields that are disabled when this is registered (i.e. state is not editable)."""),
    'lino.mixins.registrable.Registrable.get_row_permission' : _("""Only rows in an editable state may be edited."""),
    'lino.mixins.registrable.Registrable.register' : _("""Register this object. The base implementation just sets the state to “registered”."""),
    'lino.mixins.registrable.Registrable.deregister' : _("""Deregister this object. The base implementation just sets the state to “draft”."""),
    'lino.mixins.sequenced.MoveByN' : _("""Move this row N rows upwards or downwards."""),
    'lino.mixins.sequenced.MoveUp' : _("""Move this row one row upwards."""),
    'lino.mixins.sequenced.MoveDown' : _("""Move this row one row downwards."""),
    'lino.mixins.sequenced.Sequenced' : _("""Mixin for models that have a field seqno containing a “sequence number”."""),
    'lino.mixins.sequenced.Sequenced.seqno' : _("""The sequence number of this item with its parent."""),
    'lino.mixins.sequenced.Sequenced.clone_row' : _("""Create a duplicate of this row and insert the new row below this one."""),
    'lino.mixins.sequenced.Sequenced.move_up' : _("""Exchange the seqno of this item and the previous item."""),
    'lino.mixins.sequenced.Sequenced.move_down' : _("""Exchange the seqno of this item and the next item."""),
    'lino.mixins.sequenced.Sequenced.move_buttons' : _("""Displays buttons for certain actions on this row:"""),
    'lino.mixins.sequenced.Sequenced.move_action_names' : _("""The names of the actions to display in the move_buttons column."""),
    'lino.mixins.sequenced.Sequenced.get_siblings' : _("""Return a Django Queryset with all siblings of this, or None if this is a root element which cannot have any siblings."""),
    'lino.mixins.sequenced.Sequenced.set_seqno' : _("""Initialize seqno to the seqno of eldest sibling + 1."""),
    'lino.mixins.sequenced.Sequenced.seqno_changed' : _("""If the user manually assigns a seqno."""),
    'lino.mixins.sequenced.Sequenced.dndreorder' : _("""A place holder column for drag and drop row reorder on React front end"""),
    'lino.mixins.sequenced.Hierarchical' : _("""Model mixin for things that have a “parent” and “siblings”."""),
    'lino.mixins.sequenced.Hierarchical.children_summary' : _("""A comma-separated list of the children."""),
    'lino.mixins.sequenced.Hierarchical.get_parental_line' : _("""Return an ordered list of all ancestors of this instance."""),
    'lino.mixins.sequenced.Hierarchical.whole_clan' : _("""Return a set of this instance and all children and grandchildren."""),
    'lino.mixins.sequenced.Hierarchical.whole_tree' : _("""Returns a tuple with two items (obj, children) representing the whole tree."""),
    'lino.modlib.about.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.checkdata.Plugin' : _("""The config descriptor for this plugin."""),
    'lino.modlib.checkdata.Plugin.on_plugins_loaded' : _("""Set responsible_user to "'robin' if this is a demo site (is_demo_site)."""),
    'lino.modlib.checkdata.roles.CheckdataUser' : _("""Can see checkdata messages."""),
    'lino.modlib.comments.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.comments.Plugin.emotion_range' : _("""Which range of emotion icons to provide. Either “business” or “social”."""),
    'lino.modlib.dashboard.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.dashboard.UpdateWidgets' : _("""Create or update the dashboard widgets for this user."""),
    'lino.modlib.export_excel.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.extjs.Plugin' : _("""Extends lino.core.plugin.Plugin."""),
    'lino.modlib.extjs.Plugin.enter_submits_form' : _("""Whether the ENTER key (or CTRL+ENTER when in a textarea field) should submit the form."""),
    'lino.modlib.extjs.Plugin.use_statusbar' : _("""Whether to use a status bar to display certain messages to the user. Default is False since currently this is not really useful."""),
    'lino.modlib.extjs.Plugin.media_name' : _("""The URL from where to include the ExtJS library files."""),
    'lino.modlib.extjs.Plugin.autorefresh_seconds' : _("""Number of seconds to wait between two refreshes of the dashboard. Default is 0, which deactivates the feature."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer' : _("""An HTML renderer that uses the ExtJS Javascript toolkit."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.py2js_converter' : _("""Additional converting logic for serializing Python values to json."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.window_action_button' : _("""Return a HTML chunk for a button that will execute this action using a Javascript link to this action."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.quick_manage_toolbar' : _("""Returns a HTML chunk that displays a “toolbar” with a series of “quick manage buttons”: one “Insert” and another to open the table."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.action_call_on_instance' : _("""Note that ba.actor may differ from ar.actor when defined on a different actor. Remember e.g. the “Must read eID card” action button in eid_info of newcomers.NewClients (20140422)."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.get_request_url' : _("""Called from ActionRequest.absolute_url() used in Team.eml.html"""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.html_text' : _("""Wrap the given html fragment into a <div class="htmlText">, which specifies that this fragment contains simple html text inside an ExtJS component. This is required because ExtJS does a lot of CSS magic which neutralizes the “usual” effects of most html tags."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.html_page' : _("""Return a string with the index page. Content is mostly in the extjs/index.html template."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.html_page_main_window' : _("""Called from https://gitlab.com/lino-framework/lino/blob/master/lino/modlib/extjs/config/extjs/index.html."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.html_page_user' : _("""Build the “user menu”, i.e. the menu in the top right corner."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.toolbar' : _("""This also manages action groups"""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.build_on_render' : _("""dh is a FormLayout or a ColumnsLayout"""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.js_render_custom_action' : _("""Defines the non-window action handler used by row_action_button()"""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.linolib_intro' : _("""Called from linolib.js."""),
    'lino.modlib.extjs.ext_renderer.ExtRenderer.goto_instance' : _("""See JsRenderer.goto_instance(), but when this is called while the detail window is already open (only on another record), then we don’t want to redirect to another page because that would take more time."""),
    'lino.modlib.extjs.views.AdminIndex' : _("""Similar to PlainIndex"""),
    'lino.modlib.extjs.views.Restful' : _("""Used to collaborate with a restful Ext.data.Store."""),
    'lino.modlib.extjs.views.ApiElement' : _("""The view that responds to api/app_label/actor/pk."""),
    'lino.modlib.gfks.Plugin' : _("""Base class for this plugin."""),
    'lino.modlib.importfilters.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.jinja.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.jinja.Plugin.post_site_startup' : _("""This is being called from lino.core.kernel.Kernel.kernel_startup()."""),
    'lino.modlib.jinja.Plugin.list_templates' : _("""Return a list of possible choices for a field that contains a template name."""),
    'lino.modlib.jinja.Plugin.render_from_request' : _("""Render the named Jinja template using an incoming HTTP request."""),
    'lino.modlib.jinja.Plugin.render_from_ar' : _("""Render the named Jinja template using the given action request ar."""),
    'lino.modlib.jinja.Plugin.render_jinja' : _("""Render the named Jinja template, replacing ar.renderer by the Jinja renderer."""),
    'lino.modlib.jinja.loader.DjangoJinjaTemplate' : _("""used e.g. to render https://gitlab.com/lino-framework/lino/blob/master//lino/lino/config/500.html"""),
    'lino.modlib.languages.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.memo.Plugin' : _("""Base class for this plugin."""),
    'lino.modlib.memo.Plugin.parser' : _("""An instance of lino.modlib.memo.parser.Parser."""),
    'lino.modlib.memo.Plugin.front_end' : _("""The front end to use when writing previews."""),
    'lino.modlib.memo.parser.Suggester' : _("""Holds the configuration for the behaviour of a given “trigger”."""),
    'lino.modlib.memo.parser.Parser' : _("""The memo parser."""),
    'lino.modlib.memo.parser.Parser.add_suggester' : _("""Add a Suggester (see there for args and kwargs)."""),
    'lino.modlib.memo.parser.Parser.register_command' : _("""Register a memo command identified by the given text cmd."""),
    'lino.modlib.memo.parser.Parser.register_django_model' : _("""Register the given string name as command for referring to database rows of the given Django database model model."""),
    'lino.modlib.memo.parser.Parser.get_referred_objects' : _("""Yield all database objects referred in the given text using a suggester."""),
    'lino.modlib.memo.parser.Parser.parse' : _("""Parse the given string src, replacing memo commands by their result."""),
    'lino.modlib.restful.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.smtpd.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.system.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.tinymce.Plugin' : _("""See /dev/plugins."""),
    'lino.modlib.tinymce.Plugin.document_domain' : _("""The domain name of this production site."""),
    'lino.modlib.tinymce.Plugin.window_width' : _("""The initial width of the window to use when editing in own window."""),
    'lino.modlib.tinymce.Plugin.window_height' : _("""The initial height of the window to use when editing in own window."""),
    'lino.modlib.tinymce.Plugin.field_buttons' : _("""The toolbar buttons when editing a field inside a detail form."""),
    'lino.modlib.tinymce.Plugin.window_buttons1' : _("""The first row of toolbar buttons when editing in own window."""),
    'lino.modlib.tinymce.Plugin.window_buttons2' : _("""The second row of toolbar buttons when editing in own window."""),
    'lino.modlib.tinymce.Plugin.window_buttons3' : _("""The third row of toolbar buttons when editing in own window."""),
    'lino.modlib.tinymce.Plugin.media_name' : _("""Lino currently includes three versions of TinyMCE, but for production sites we still use the eldest version 3.4.8."""),
    'lino.modlib.wkhtmltopdf.Plugin' : _("""See /dev/plugins."""),
    'lino.sphinxcontrib.actordoc.CurrentLanguage' : _("""Tell Sphinx to switch to the specified language until the end of this document."""),
    'lino.sphinxcontrib.actordoc.CurrentProject' : _("""Tell Sphinx to switch to the specified project until the end of this document."""),
    'lino.sphinxcontrib.actordoc.Lino2rstDirective' : _("""Defines the lino2rst directive."""),
    'lino.utils.AttrDict' : _("""Dictionary-like helper object."""),
    'lino.utils.AttrDict.define' : _("""args must be a series of names followed by the value"""),
    'lino.utils.AttrDict.resolve' : _("""return an attribute with dotted name"""),
    'lino.utils.IncompleteDate' : _("""Naive representation of a potentially incomplete gregorian date."""),
    'lino.utils.IncompleteDate.parse' : _("""Parse the given string and return an IncompleteDate object."""),
    'lino.utils.IncompleteDate.get_age' : _("""Return age in years as integer."""),
    'lino.utils.MissingRow' : _("""Represents a database row that is expected to exist but doesn’t."""),
    'lino.utils.addressable.Addressable' : _("""General mixin (not only for Django models) to encapsulate the generating of “traditional” (“snail”) mail addresses."""),
    'lino.utils.addressable.Addressable.address_person_lines' : _("""Yield one or more text lines, one for each line of the person part."""),
    'lino.utils.addressable.Addressable.address_location_lines' : _("""Yield one or more text lines, one for each line of the location part."""),
    'lino.utils.addressable.Addressable.get_address_lines' : _("""Yield a series of text lines, one for each line of the address."""),
    'lino.utils.addressable.Addressable.get_address' : _("""The plain text full postal address (person and location). Lines are separated by linesep, which defaults to a newline."""),
    'lino.utils.addressable.Addressable.get_address_html' : _("""Return the full postal address as a text containing simple html markup with a single paragraph (<p>)."""),
    'lino.utils.addressable.Addressable.has_address' : _("""Returns True if the address location is non empty."""),
    'lino.utils.addressable.TestAddress' : _("""Used only for testing."""),
    'lino.utils.ajax.AjaxExceptionResponse' : _("""The middleware class definition."""),
    'lino.utils.choosers.LookupConverter' : _("""A Converter for ForeignKey and ManyToManyField. If the lookup_field is a BabelField, then it tries all available languages."""),
    'lino.utils.choosers.ChoiceConverter' : _("""Converter for ChoiceListField."""),
    'lino.utils.choosers.ForeignKeyConverter' : _("""Converter for ForeignKey fields."""),
    'lino.utils.choosers.GenericForeignKeyConverter' : _("""Converter for GenericForeignKey fields."""),
    'lino.utils.choosers.ManyToManyConverter' : _("""Converter for ManyToMany fields."""),
    'lino.utils.choosers.Chooser' : _("""Holds information about the possible choices of a field."""),
    'lino.utils.choosers.Chooser.get_data_elem' : _("""Calls dd.Actor.get_data_elem() or dd.Model.get_data_elem() or dd.Action.get_data_elem()."""),
    'lino.utils.choosers.Chooser.get_choices' : _("""Return a list of choices for this chooser, using keyword parameters as context."""),
    'lino.utils.choosers.Chooser.get_request_choices' : _("""Return a list of choices for this chooser, using a HttpRequest to build the context."""),
    'lino.utils.config.ConfigDir' : _("""A directory that may contain configuration files."""),
    'lino.utils.cycler.Cycler' : _("""An iterator that loops over an iteration and starts back at the beginning when it reaches the end."""),
    'lino.utils.daemoncommand.DaemonCommand' : _("""If you have an existing Django management command, just rename it’s handle method to handle_daemon and inherit from this instead of django.core.management.base.BaseCommand."""),
    'lino.utils.daemoncommand.DaemonCommand.help' : _("""The loggers to preserve. If not None, this should be a list of loggers (logging.Logger instances) whose file handles should not get closed."""),
    'lino.utils.daemoncommand.DaemonCommand.execute' : _("""Takes the options and starts a daemon context from them."""),
    'lino.utils.dataserializer.FakeDeserializedObject' : _("""loaddata requires DeserializedObject instances, but this Deserializer does not bypass pre_save/save methods."""),
    'lino.utils.dates.DateRangeValue' : _("""A named tuple with two fields start_date and end_date."""),
    'lino.utils.dates.DateRangeValue.end_date' : _("""Alias for field number 1"""),
    'lino.utils.dates.DateRangeValue.start_date' : _("""Alias for field number 0"""),
    'lino.utils.dbfreader.DBFFile' : _("""Represents a single DBF file."""),
    'lino.utils.dbfreader.DBFField' : _("""Represents a field in a DBF file."""),
    'lino.utils.dbfreader.FPTFile' : _("""Represents an FPT block file"""),
    'lino.utils.dbfreader.DBTFile' : _("""Represents a DBT block file"""),
    'lino.utils.diag.Analyzer' : _("""The class of the lino.utils.diag.analyzer object."""),
    'lino.utils.diag.Analyzer.show_window_fields' : _("""List all window actions and the form fields they contain."""),
    'lino.utils.diag.Analyzer.show_window_permissions' : _("""List all window actions and the user types that can see them."""),
    'lino.utils.diag.Analyzer.show_memo_commands' : _("""List the memo commands defined in this application."""),
    'lino.utils.diag.Analyzer.show_db_structure' : _("""Show a bullet list of all models and their fields."""),
    'lino.utils.diag.Analyzer.show_database_structure' : _("""Show a bullet list of all models and their fields."""),
    'lino.utils.diag.Analyzer.show_db_overview' : _("""Print a reStructredText-formatted “database overview” report. Used by test cases in tested documents."""),
    'lino.utils.diag.Analyzer.show_foreign_keys' : _("""Return a list that shows how database objects are being referred to by some other database object. This information is important (1) before deleting objects and (2) when merging them."""),
    'lino.utils.diag.Analyzer.get_complexity_factors' : _("""Yield a series of plain text lines that describe the complexity factors of this application."""),
    'lino.utils.djangotest.DjangoManageTestCase' : _("""Adds some extensions to the Django TestCase."""),
    'lino.utils.djangotest.DjangoManageTestCase.override_djangosite_settings' : _("""If specified, this is a dict of Site attributes to override before running the test."""),
    'lino.utils.djangotest.DjangoManageTestCase.defining_module' : _("""When you decorate your subclass of TestCase, you must also specify:"""),
    'lino.utils.djangotest.DjangoManageTestCase.check_sql_queries' : _("""Checks whether the specified expected SQL queries match to those who actually have been emitted."""),
    'lino.utils.djangotest.DjangoManageTestCase.client_json_dict' : _("""Send a GET or POST or PUT to client with given username, url and data. The server is expected to respond with a JSON encoded response. Parse the response’s content (which is expected to contain a dict), convert this dict to an AttrDict before returning it."""),
    'lino.utils.djangotest.DjangoManageTestCase.check_callback_dialog' : _("""Check wether the given dialog runs as expected and return the final response as an AttrDict."""),
    'lino.utils.djangotest.RemoteAuthTestCase' : _("""Base class for tests that use remote http authentication. We override the __call__() method in order to simulate remote_user_header <lino.core.site.Site.remote_user_header> being set to 'REMOTE_USER'."""),
    'lino.utils.djangotest.TestCase' : _("""alias of RemoteAuthTestCase"""),
    'lino.utils.djangotest.RestoreTestCase' : _("""Used for testing migrations from previous versions."""),
    'lino.utils.djangotest.RestoreTestCase.tested_versions' : _("""A list of strings, each string is a version for which there must be a migration dump created by makemigdump."""),
    'lino.utils.dpy.FakeDeserializedObject' : _("""Imitates DeserializedObject required by loaddata."""),
    'lino.utils.dpy.FakeDeserializedObject.try_save' : _("""Try to save this Model instance."""),
    'lino.utils.dpy.Serializer' : _("""Serializes a QuerySet to a py stream."""),
    'lino.utils.dpy.FlushDeferredObjects' : _("""Indicator class object. Fixture may yield a FlushDeferredObjects to indicate that all deferred objects should get saved before going on."""),
    'lino.utils.dpy.DpyLoader' : _("""Instantiated by restore.py."""),
    'lino.utils.dpy.DpyDeserializer' : _("""The Django deserializer for dpy."""),
    'lino.utils.dpy.Migrator' : _("""The SITE’s Migrator class is instantiated by install_migrations."""),
    'lino.utils.dpy.Migrator.after_load' : _("""Declare a function to be called after all data has been loaded."""),
    'lino.utils.dpy.Migrator.before_load' : _("""Declare a function to be called before loading dumped data."""),
    'lino.utils.instantiator.Instantiator' : _("""A utility class to make python fixtures more compact. See tutorial.instantiator."""),
    'lino.utils.instantiator.Instantiator.build' : _("""Instantiate an object using the default values of this instantiator, overridden by the given specified values. The number of positional arguments may not exceed the number of fieldnames specified when creating this Instantiator."""),
    'lino.utils.instantiator.InstanceGenerator' : _("""Usage example see lino_xl.lib.humanlinks.fixtures."""),
    'lino.utils.jinja.Counter' : _("""Represents a counter. Usage see"""),
    'lino.utils.jsgen.js_code' : _("""A string that py2js will represent as is, not between quotes."""),
    'lino.utils.jsgen.Component' : _("""A Component is a Variable whose value is a dict of options. Deserves more documentation."""),
    'lino.utils.jsgen.Component.walk' : _("""Walk over this component and its children."""),
    'lino.utils.jsgen.VisibleComponent' : _("""A visible component"""),
    'lino.utils.jsgen.VisibleComponent.install_permission_handler' : _("""Define the allow_read handler used by get_view_permission(). This must be done only once, but after having configured debug_permissions and required_roles."""),
    'lino.utils.media.MediaFile' : _("""Represents a file on the server below MEDIA_ROOT with two properties path and url."""),
    'lino.utils.media.MediaFile.path' : _("""A pathlib.Path naming the file on the server’s file system."""),
    'lino.utils.media.MediaFile.url' : _("""The URL to use for getting this file from a web client."""),
    'lino.utils.mldbc.fields.BabelCharField' : _("""Define a variable number of CharField database fields, one for each language of your lino.core.site.Site.languages. See mldbc."""),
    'lino.utils.mldbc.fields.BabelTextField' : _("""Used for the clones of the master field, one for each non-default language. See mldbc."""),
    'lino.utils.mldbc.fields.LanguageField' : _("""A field that lets the user select a language from the available lino.core.site.Site.languages."""),
    'lino.utils.mldbc.BabelNamed' : _("""Mixin for models that have a babel field name (labelled “Designation” by default) for each language."""),
    'lino.utils.mldbc.BabelNamed.name' : _("""The translatable name of this database row."""),
    'lino.utils.mldbc.BabelDesignated' : _("""Mixin for models that have a babel field “Designation” (i.e. one designation for each language defined in the site’s languages."""),
    'lino.utils.mldbc.BabelDesignated.designation' : _("""The translatable name of this database row."""),
    'lino.utils.mti.ChildCollector' : _("""A Collector that does not delete the MTI parents."""),
    'lino.utils.mti.EnableChild' : _("""Rendered as a checkbox that indicates whether an mti child of the given model exists."""),
    'lino.utils.mti.EnableChild.is_enabled' : _("""When a FormLayout is inherited by an MTI child, EnableChild fields must be disabled."""),
    'lino.utils.mti.EnableChild.has_child' : _("""Returns True if obj has an MTI child in self.child_model. The optional 2nd argument request (passed from VirtualField.value_from_object) is ignored."""),
    'lino.utils.odsreader.SimpleOdsReader' : _("""Abstract base class. For each .ods file you are probably creating a subclass of this."""),
    'lino.utils.odsreader.SimpleOdsReader.filename' : _("""The full path name of the .ods file to be read."""),
    'lino.utils.odsreader.SimpleOdsReader.headers' : _("""A list of unicode strings, one for each column in the file. The headers specified here must match exactly those found in the .ods file."""),
    'lino.utils.odsreader.SimpleOdsReader.cells2row' : _("""This will be called for each recognized data row and may perform a conversion before yielding it. Subclasses may override this."""),
    'lino.utils.odsreader.SimpleOdsReader.rows' : _("""Yields the data rows found in this .ods file."""),
    'lino.utils.odsreader.OdsReader' : _("""Like SimpleOdsReader, but each row is converted to an lino.utils.AttrDict. This requires you to specifiy, besides the SimpleOdsReader.headers attrribute, another list of pure ASCII strings which must be valid Python attribute names."""),
    'lino.utils.pythontest.TestCase' : _("""An extended atelier.test.TestCase to be run using setup.py in the root of a project that may contain several Django projects."""),
    'lino.utils.pythontest.TestCase.django_settings_module' : _("""The DJANGO_SETTINGS_MODULE to set for each subprocess launched by this test case."""),
    'lino.utils.pythontest.TestCase.run_django_manage_test' : _("""Run python manage.py test command in the given directory."""),
    'lino.utils.pythontest.TestCase.run_django_admin_test_cd' : _("""Run django-admin.py test in the given directory."""),
    'lino.utils.pythontest.TestCase.run_django_admin_command_cd' : _("""Run django-admin.py CMD in the given directory."""),
    'lino.utils.pythontest.TestCase.run_docs_doctests' : _("""Run a simple doctest for specified file after importing the docs conf.py (which causes the demo database to be activated)."""),
    'lino.utils.pythontest.TestCase.do_test_demo_project' : _("""Run test and demotest in a subprocess in the given demo project."""),
    'lino.utils.report.EmptyTableRow' : _("""Base class for virtual rows of an EmptyTable. An EmptyTableRow instance"""),
    'lino.utils.report.EmptyTableRow.get_print_templates' : _("""Overrides lino.modlib.printing.mixins.Printable.get_print_templates()"""),
    'lino.utils.report.EmptyTable' : _("""A “Table” that has exactly one virtual row and thus is visible only using a Detail view on that row."""),
    'lino.utils.report.EmptyTable.get_print_templates' : _("""Called from EmptyTableRow."""),
    'lino.utils.report.Report' : _("""A special kind of EmptyTable used to create “reports”. A report is a series of headings, paragraphs and tables combined into a single printable and previewable document."""),
    'lino.utils.report.Report.get_story' : _("""Yield a sequence of story items. Every item can be (1) an ElementTree element or (2) a table or (3) an action request."""),
    'lino.utils.restify.HTMLTranslator' : _("""Suppress surrounding DIV tag. Used by restify()."""),
    'lino.utils.sqllog.SQLLogMiddleware' : _("""Log all SQL statements direct to the console."""),
    'lino.utils.sqllog.SQLLogToConsoleMiddleware' : _("""Log all SQL statements to the console. Intended for use with the django development server."""),
    'lino.utils.sqllog.ShortSQLLogToConsoleMiddleware' : _("""Log a summary of the SQL statements made to the console. Intended for use with the django development server."""),
    'lino.utils.test.HttpQuery.expected_rows' : _("""Alias for field number 3"""),
    'lino.utils.test.HttpQuery.json_fields' : _("""Alias for field number 2"""),
    'lino.utils.test.HttpQuery.kwargs' : _("""Alias for field number 4"""),
    'lino.utils.test.HttpQuery.url_base' : _("""Alias for field number 1"""),
    'lino.utils.test.HttpQuery.username' : _("""Alias for field number 0"""),
    'lino.utils.test.CommonTestCase' : _("""A unittest.TestCase (not a django.test.TestCase) that starts a Django test client on a demo database populated using pm prep."""),
    'lino.utils.test.CommonTestCase.create_obj' : _("""Create the given database object, run full_clean() and save(), return the object."""),
    'lino.utils.test.CommonTestCase.check_json_result' : _("""Checks the result of response which is expected to return a JSON-encoded dictionary with the expected_keys."""),
    'lino.utils.test.CommonTestCase.assertEquivalent' : _("""Compares two strings a (expected) and b (got), ignoring whitespace repetitions and writing a logger message in case they are different. For long strings it’s then more easy to find the difference."""),
    'lino.utils.test.CommonTestCase.request_PUT' : _("""Sends a PUT request using Django’s test client, overriding the content_type keyword. This is how ExtJS grids behave by default."""),
    'lino.utils.test.DocTest' : _("""Looks for a file “index.rst” in your project_dir and (if it exists) runs doctest on it."""),
    'lino.utils.test.DocTest.doctest_files' : _("""The files to be tested."""),
    'lino.utils.test.DemoTestCase' : _("""Base class for unit tests that are meant to run directly in a demo project that has been initialized with pm prep."""),
    'lino.utils.test.DemoTestCase.login' : _("""Invoke the lino.modlib.users.SignIn action for the given username and password. Unlike django.test.Client.force_login(), this simulates a real login, which later causes Lino to build the JS cache for this user."""),
    'lino.utils.ucsv.UTF8Recoder' : _("""Iterator that reads an encoded stream and reencodes the input to UTF-8"""),
    'lino.utils.ucsv.UnicodeReader' : _("""A CSV reader which will iterate over lines in the CSV file “f”, which is encoded in the given encoding."""),
    'lino.utils.ucsv.UnicodeWriter' : _("""A CSV writer which will write rows to CSV file “f”, which is encoded in the given encoding."""),
    'lino.core.model.Model.disable_create' : _("""Return a veto message if you want to refuse creating rows on this model in the given action request even when permission has been given."""),
    'lino.core.model.Model.on_create' : _("""Override this to set default values that depend on the request."""),
    'lino.core.model.Model.after_ui_create' : _("""Hook to define custom behaviour to run when a user has created a new instance of this model."""),
    'lino.core.model.Model.submit_insert' : _("""The SubmitInsert action to be executed when the when the users submits an insert window."""),
    'lino.core.model.Model.create_from_choice' : _("""Called when a learning combo has been submitted. Create a persistent database object if the given text contains enough information."""),
    'lino.core.model.Model.choice_text_to_dict' : _("""Return a dict of the fields to fill when the given text contains enough information for creating a new database object."""),
    'lino.core.model.Model.__str__' : _("""Return a translatable text that describes this database row."""),
    'lino.core.model.Model.as_str' : _("""Return a translatable text that describes this database row. Unlike __str__() this method gets an action request when it is called, so it knows the context."""),
    'lino.core.model.Model.get_str_words' : _("""Yield a series of words that describe this database row in plain text."""),
    'lino.core.model.Model.as_summary_item' : _("""Return a HTML element that represents this database row in a data window in display mode “summary”."""),
    'lino.core.model.Model.as_paragraph' : _("""Return a safe HTML string that represents this database row as a paragraph."""),
    'lino.core.model.Model.set_widget_options' : _("""Set default values for the widget options of a given element."""),
    'lino.core.model.Model.get_overview_elems' : _("""Return a list of HTML elements to be shown in overview field."""),
    'lino.core.model.Model.merge_row' : _("""Merge this object into another object of same class."""),
    'lino.utils.quantities.Quantity' : _("""The base class for all quantities."""),
    'lino.utils.quantities.Quantity.limit_length' : _("""Reduce the number of decimal places so that the value fits into a field of the specified max_length, if possible. This will round the value (reducing precision) if needed."""),
    'lino.utils.quantities.Duration' : _("""The class to represent a duration."""),
    'lino.utils.quantities.Percentage' : _("""The class to represent a percentage."""),
    'lino.utils.quantities.Fraction' : _("""The class to represent a fraction. (Not yet implemented)"""),
    'lino.core.model.Model.get_request_queryset' : _("""Return the Django queryset to be used by action request ar for any data table on this model."""),
    'lino.core.model.Model.before_ui_save' : _("""A hook for adding custom code to be executed each time an instance of this model gets updated via the user interface and before the changes are written to the database."""),
    'lino.core.model.Model.after_ui_save' : _("""Like before_ui_save(), but is called after the changes are written to the database."""),
    'lino.core.model.Model.update_owned_instance' : _("""Called by lino.modlib.gfks.Controllable."""),
    'lino.core.model.Model.after_update_owned_instance' : _("""Called by lino.modlib.gfks.Controllable."""),
    'lino.modlib.about.About' : _("""A dialog window which displays some information about the site."""),
    'lino.modlib.about.TimeZones' : _("""The list of time zones available on this site."""),
    'lino.modlib.about.TimeZones.default' : _("""The default time zone on this server, corresponding to TIME_ZONE. Unlike TIME_ZONE (which is a string), default is a Choice object whose text is the same as the string and which has an attribute tzinfo, which contains the time zone info object."""),
    'lino.modlib.about.DateFormats' : _("""A list of date formats."""),
    'lino.modlib.changes.Change' : _("""Django model to represent a registered change in the database."""),
    'lino.modlib.changes.Change.object' : _("""The database object that has been modified."""),
    'lino.modlib.changes.Change.master' : _("""The database object that acts as “master”."""),
    'lino.modlib.changes.ChangesByObject' : _("""Show the history of changes in the current database row."""),
    'lino.modlib.changes.ChangesByMaster' : _("""Show the history of changes in the current database row and related data."""),
    'lino.modlib.changes.ChangeTypes' : _("""The list of possible choices for the type field of a Change."""),
    'lino.modlib.checkdata.Problem' : _("""Django model used to store a data problem message."""),
    'lino.modlib.checkdata.Problem.checker' : _("""The Checker that reported this problem."""),
    'lino.modlib.checkdata.Problem.message' : _("""The message text. This is a concatenation of all messages that were yielded by the checker."""),
    'lino.modlib.checkdata.Problem.user' : _("""The user responsible for fixing this problem."""),
    'lino.modlib.checkdata.Problems' : _("""The base table for data problem messages."""),
    'lino.modlib.checkdata.MyMessages' : _("""Shows the data problem messages assigned to me."""),
    'lino.modlib.checkdata.Checkers' : _("""The list of data checkers known by this application."""),
    'lino.modlib.checkdata.Checker' : _("""Base class for all data checkers."""),
    'lino.modlib.checkdata.Checker.model' : _("""The model to be checked. If this is a string, Lino will resolve it at startup."""),
    'lino.modlib.checkdata.Checker.no_auto' : _("""Whether this checker should be ignored by checkdata."""),
    'lino.modlib.checkdata.Checker.check_instance' : _("""Run get_checkdata_problems() on this checker for the given database object."""),
    'lino.modlib.checkdata.Checker.get_checkable_models' : _("""Return a list of the models to check."""),
    'lino.modlib.checkdata.Checker.activate' : _("""Creates an instance of this class and adds it as a choice to the Checkers choicelist."""),
    'lino.modlib.checkdata.Checker.update_problems' : _("""Update the problem messages of this checker for the specified object."""),
    'lino.modlib.checkdata.Checker.get_checkdata_problems' : _("""Return or yield a series of (fixable, message) tuples, each describing a data problem. fixable is a boolean saying whether this problem can be automatically fixed. And if fix is True, this method is also responsible for fixing it."""),
    'lino.modlib.checkdata.Checker.get_responsible_user' : _("""The site user to be considered responsible for problems detected by this checker on the given database object obj. This will be stored in user."""),
    'lino.core.model.Model.fix_problems' : _("""Update data problem messages and repair those which are automatically fixable."""),
    'lino.core.model.Model.check_data' : _("""Update data problem messages for this database object, also removing messages that no longer exist. This action does not change anything else in the database."""),
    'lino.modlib.users.User.get_contact' : _("""Returns the user’s country."""),
    'lino.modlib.linod.Procedure' : _("""A callable function designed to run in background at default interval given by every_unit and every_value."""),
    'lino.modlib.linod.Procedure.func' : _("""The function to run as a system task."""),
    'lino.modlib.linod.Procedure.every_unit' : _("""The default unit of the interval at which the task func will run."""),
    'lino.modlib.linod.Procedure.every_value' : _("""The default value of the interval at which the task func will run."""),
    'lino.modlib.linod.Procedure.start_datetime' : _("""The time at which this task should run first."""),
    'lino.modlib.linod.Procedure.run' : _("""Calls the function stored in func passing ar as a positional argument."""),
    'lino.modlib.linod.Procedures' : _("""The choicelist of background procedures available in this application."""),
    'lino.modlib.linod.LogLevels' : _("""A choicelist of logging levels available in this application."""),
    'lino.modlib.linod.SystemTask' : _("""Django model used to represent a background task."""),
    'lino.modlib.linod.SystemTask.start_datetime' : _("""Tells at what time exactly this job started."""),
    'lino.modlib.linod.SystemTask.run' : _("""Performs a routine job."""),
    'lino.modlib.linod.SystemTasks' : _("""The default table for the SystemTask model."""),
    'lino.modlib.linod.Runnable' : _("""Model mixin used by SystemTask and other models."""),
    'lino.modlib.linod.Runnable.run_now' : _("""Explicitly request to tun this task as soon as possible."""),
    'lino.modlib.linod.Runnable.cancel_run' : _("""Cancel the explicit request to tun this task as soon as possible."""),
    'lino.modlib.linod.Runnable.procedure' : _("""The background procedure to run in this task."""),
    'lino.modlib.linod.Runnable.requested_at' : _("""The timestamp when a user has explicitly requested to run this task."""),
    'lino.modlib.linod.Runnable.last_start_time' : _("""The timestamp when this task has started running in the task runner."""),
    'lino.modlib.linod.Runnable.last_end_time' : _("""The timestamp when this task has finished running in the task runner."""),
    'lino.modlib.linod.Runnable.message' : _("""Stores information about the job, mostly logs."""),
    'lino.modlib.linod.Runnable.disabled' : _("""Tells whether the task should be ignored."""),
    'lino.modlib.linod.Runnable.log_level' : _("""The logging level to apply when running this task."""),
    'lino.modlib.periods.StoredYear' : _("""The Django model used to store a fiscal year."""),
    'lino.modlib.periods.StoredPeriod' : _("""The Django model used to store an accounting period."""),
    'lino.modlib.periods.StoredYears' : _("""The fiscal years defined in this database."""),
    'lino.modlib.periods.StoredPeriods' : _("""The accounting periods defined in this database."""),
    'lino.modlib.periods.PeriodTypes' : _("""A list of choices for the values allowed as periods.period_type."""),
    'lino.modlib.periods.PeriodRange' : _("""Model mixin for objects that cover a range of accounting periods."""),
    'lino.modlib.periods.PeriodRange.start_period' : _("""The first period of the range to cover."""),
    'lino.modlib.periods.PeriodRange.end_period' : _("""The last period of the range to cover."""),
    'lino.modlib.periods.PeriodRangeObservable' : _("""Model mixin for objects that can be filtered by a range of accounting periods. This adds two parameter fields start_period and end_period to every table on this model."""),
    'lino.modlib.periods.StoredPeriodRange' : _("""A parameter panel with two fields:"""),
    'lino.modlib.periods.StoredPeriodRange.start_period' : _("""Start of observed period range."""),
    'lino.modlib.periods.StoredPeriodRange.end_period' : _("""Optional end of observed period range. Leave empty to consider only the Start period."""),
    'lino.modlib.publisher.Page' : _("""The Django model that represents a content page."""),
    'lino.modlib.publisher.PublisherBuildMethod' : _("""This deserves better documentation."""),
    'lino.modlib.publisher.Publishable' : _("""Model mixin to add to models that are potentially publishable."""),
    'lino.modlib.publisher.Publishable.publisher_template' : _("""The name of the template to use when rendering a database row via the publisher interface."""),
    'lino.modlib.publisher.Publishable.preview_publication' : _("""Show this database row via the publisher interface."""),
    'lino.modlib.publisher.PublishableContent' : _("""Model mixin to add to models that are potentially publishable."""),
    'lino.modlib.publisher.PublishableContent.language' : _("""The language of this content."""),
    'lino.modlib.publisher.PublishableContent.publishing_state' : _("""Default value is ‘draft’"""),
    'lino.modlib.publisher.PublishableContent.filler' : _("""Pointer to PageFillers"""),
    'lino.modlib.publisher.PublishingStates' : _("""A choicelist with the possible states of a publisher page."""),
    'lino.modlib.publisher.SpecialPages' : _("""A choicelist with the special pages available on this site."""),
    'lino.modlib.search.SiteSearch' : _("""A virtual table that searches in all database tables."""),
    'lino.modlib.search.ElasticSiteSearch' : _("""A virtual table used to search on this Lino site using ElasticSearch."""),
    'lino.modlib.summaries.Summarized' : _("""Model mixin for database objects that have summary fields."""),
    'lino.modlib.summaries.Summarized.delete_them_all' : _("""Set this to True if all instances of this model should be considered temporary data to be deleted by checksummaries."""),
    'lino.modlib.summaries.Summarized.compute_results' : _("""Update all the summary fields for this database object."""),
    'lino.modlib.summaries.Summarized.reset_summary_data' : _("""Set all counters and sums to 0."""),
    'lino.modlib.summaries.Summarized.compute_summary_values' : _("""Compute the values of the summary fields in this database row."""),
    'lino.modlib.summaries.Summarized.update_for_filter' : _("""Runs compute_summary_values() on a a filtered queryset based on keyword arguments."""),
    'lino.modlib.summaries.Summarized.get_summary_collectors' : _("""To be implemented by subclasses. This must yield a sequence of (collector, qs) tuples, where collector is a callable and qs a queryset. Lino will call collector for each obj in qs. The collector is responsible for updating that object."""),
    'lino.modlib.summaries.SlaveSummarized' : _("""Mixin for Summarized models that are related to a master."""),
    'lino.modlib.summaries.SlaveSummarized.master' : _("""The target model of the master will automatically receive an action check_summaries."""),
    'lino.modlib.summaries.DateSummarized' : _("""A Summarized that will have more than one entries per master, one for each month."""),
    'lino.modlib.summaries.DateSummarized.summary_period' : _("""Can be 'yearly', 'monthly', 'weekly' or 'timeless'."""),
    'lino.modlib.summaries.DateSummarized.year' : _("""The year"""),
    'lino.modlib.summaries.DateSummarized.month' : _("""The number of the month or the week."""),
    'lino.modlib.summaries.CheckSummaries' : _("""Web UI version of checksummaries."""),
    'lino.modlib.summaries.UpdateSummariesByMaster' : _("""Update summary data for this object."""),
    'lino.modlib.users.User' : _("""The Django model used to represent a user account."""),
    'lino.modlib.users.User.username' : _("""Must be either unique or empty. User accounts having this field empty cannot be used to sign in."""),
    'lino.modlib.users.User.user_type' : _("""The user type assigned to this user. User accounts having this field empty cannot be used to sign in."""),
    'lino.modlib.users.User.partner' : _("""The partner record with additional contact information about this user account."""),
    'lino.modlib.users.User.nickname' : _("""The nickname used to refer to you when speaking to other site users. Does not need to be unique but should be reasonably identifying."""),
    'lino.modlib.users.User.initials' : _("""The initials used to refer to you when speaking to business partners. Does not need to be unique but should be reasonably identifying."""),
    'lino.modlib.users.User.time_zone' : _("""The time zone Lino should use in time fields or when displaying timestamps to this user."""),
    'lino.modlib.users.User.date_format' : _("""The date format to use when parsing or displaying dates."""),
    'lino.modlib.users.User.verification_code' : _("""A random string that has been sent to the user via email in order to verify their email address."""),
    'lino.modlib.users.User.verification_password' : _("""A not-yet-active password given by anonymous when they asked for a password reset. This will become the active password when the user verifies."""),
    'lino.modlib.users.User.person' : _("""A virtual read-only field that returns the Person MTI child of the partner (if it exists) and otherwise None."""),
    'lino.modlib.users.User.company' : _("""A virtual read-only field that returns the Company MTI child of the partner (if it exists) and otherwise None."""),
    'lino.modlib.users.User.last_login' : _("""Not used in Lino."""),
    'lino.modlib.users.User.start_date' : _("""If start_date is given, then the user cannot sign in before that date. If end_date is given, then the user cannot sign in after that date."""),
    'lino.modlib.users.User.authenticated' : _("""No longer used. See as is_authenticated."""),
    'lino.modlib.users.User.is_authenticated' : _("""This is always True. Compare with AnonymousUser.is_authenticated."""),
    'lino.modlib.users.User.get_active_users' : _("""Return a queryset of users that satisfy the specified criteria."""),
    'lino.modlib.users.User.__str__' : _("""Returns nickname if this field is not empty, otherwise get_full_name() unless"""),
    'lino.modlib.users.User.get_full_name' : _("""Return the user’s full name, i.e. first_name followed by last_name. If both fields are empty, return the initials or the username."""),
    'lino.modlib.users.User.get_row_permission' : _("""Only system managers may edit other users. See also disabled_fields()."""),
    'lino.modlib.users.User.change_password' : _("""Ask for a new password to be used for authentication."""),
    'lino.modlib.users.User.verify_me' : _("""Ask for the verification code you have received by email and mark your email address as verified."""),
    'lino.modlib.users.Users' : _("""Base class for all data tables on User."""),
    'lino.modlib.users.AllUsers' : _("""Shows the list of all users on this site."""),
    'lino.modlib.users.UsersOverview' : _("""A variant of Users showing only active users and only some fields. This is used on demo sites in admin_main.html to display the list of available users."""),
    'lino.modlib.users.UserTypes' : _("""The list of user types available in this application."""),
    'lino.modlib.users.UserTypes.user_role' : _("""The user role of users having this type."""),
    'lino.modlib.users.UserTypes.hidden_languages' : _("""Default value for the hidden_languages of newly added choice items."""),
    'lino.modlib.users.UserTypes.get_anonymous_user' : _("""Return an instance of AnonymousUser."""),
    'lino.modlib.users.UserType' : _("""An item of the UserTypes list. Every instance of this represents a user type."""),
    'lino.modlib.users.UserType.role' : _("""The role of users having this type. This is an instance of UserRole or some subclass thereof."""),
    'lino.modlib.users.UserType.readonly' : _("""Whether users of this type get only write-proteced access."""),
    'lino.modlib.users.UserType.hidden_languages' : _("""A subset of languages which should be hidden for users of this type. Default value is hidden_languages. This is used on multilingual sites with more than 4 or 5 languages."""),
    'lino.modlib.users.UserType.context' : _("""Return a context manager so you can write code to be run with this as the current user type:"""),
    'lino.modlib.users.UserType.mask_message_types' : _("""A set of notification message types to be masked for users of this type."""),
    'lino.modlib.users.UserType.mask_notifications' : _("""Add the given notification message types to the notification mask."""),
    'lino.modlib.users.UserType.has_required_roles' : _("""Return True if this user type’s role satisfies the specified requirements."""),
    'lino.modlib.users.UserType.find_menu_item' : _("""Find the item of the main menu for the specified bound action."""),
    'lino.modlib.users.Sessions' : _("""Show a list of all user sessions."""),
    'lino.modlib.users.Authority' : _("""Django model used to represent a authority."""),
    'lino.modlib.users.Authority.user' : _("""The user who gives the right of representation. author of this authority"""),
    'lino.modlib.users.Authority.authorized' : _("""The user who gets the right to represent the author"""),
    'lino.modlib.users.Helper' : _("""Somebody who can help others by running AssignToMe action."""),
    'lino.modlib.users.AuthorshipTaker' : _("""Somebody who can help others by running TakeAuthorship action."""),
    'lino.modlib.users.SendWelcomeMail' : _("""Send a welcome mail to this user."""),
    'lino.modlib.users.ChangePassword' : _("""Change the password of this user."""),
    'lino.modlib.users.ChangePassword.current' : _("""The current password. Leave empty if the user has no password yet. A site manager doesn’t need to specify this at all."""),
    'lino.modlib.users.ChangePassword.new1' : _("""The new password."""),
    'lino.modlib.users.ChangePassword.new2' : _("""The new password a second time. Both passwords must match."""),
    'lino.modlib.users.SignIn' : _("""Open a window that asks for username and password and authenticates as this user when submitted."""),
    'lino.modlib.users.SignOut' : _("""Sign out the current user and return to the welcome screen for anonymous visitors."""),
    'lino.modlib.users.CreateAccount.first_name' : _("""Your first name."""),
    'lino.modlib.users.CreateAccount.last_name' : _("""Your last name."""),
    'lino.modlib.users.CreateAccount.email' : _("""Your email address. This is required to verify your account."""),
    'lino.modlib.users.CreateAccount.username' : _("""The username you want to get. Leave empty to get your email address as your username."""),
    'lino.modlib.users.CreateAccount.password' : _("""Your password."""),
    'lino.modlib.users.Authored.manager_roles_required' : _("""The list of required roles for getting permission to edit other users’ work."""),
    'lino.modlib.users.Authored.author_field_name' : _("""No longer used. The name of the field that defines the author of this object."""),
    'lino.modlib.users.UserAuthored' : _("""Inherits from Authored."""),
    'lino.modlib.users.UserAuthored.user' : _("""The author of this database object."""),
    'lino.modlib.users.StartPlan' : _("""The action to start a user plan."""),
    'lino.modlib.users.StartPlan.update_after_start' : _("""Whether to run Plan.update_plan() after starting the plan."""),
    'lino.modlib.users.UserPlan' : _("""Mixin for anything that represents a “plan” of a given user on a given day."""),
    'lino.modlib.users.UserPlan.user' : _("""The user who owns and uses this plan."""),
    'lino.modlib.users.UserPlan.today' : _("""This date of this plan. This is automatically set to today each time the plan is called or updated."""),
    'lino.modlib.users.UserPlan.create_user_plan' : _("""Return the database object for this plan and user. or create"""),
    'lino.modlib.users.UserPlan.update_plan' : _("""Implementing models should provide this method."""),
    'lino.modlib.users.UpdatePlan' : _("""Build a new list of suggestions. This will remove all current suggestions."""),
    'lino.modlib.users.PrivacyRelevant' : _("""Model mixin to mark a database model as privacy-relevant data, i.e. something that is to be shown only to members of a given user group."""),
    'lino.modlib.users.PrivacyRelevant.private' : _("""Whether this row is confidential."""),
    'lino.modlib.users.PrivacyRelevant.group' : _("""The user group this row belongs to."""),
    'lino.modlib.about.About.sign_in' : _("""Ask for your username and password in order to authenticate."""),
    'lino.modlib.about.About.reset_password' : _("""Ask for your email address and send a verification code."""),
    'lino.modlib.about.About.verify_user' : _("""Ask for the verification code you have received by email and mark your email address as verified."""),
    'lino.core.model.Model.as_list_item' : _("""Old name of lino.core.model.TableRow.as_paragraph()"""),
    'lino.modlib.contacts.Partner.client_contact_type' : _("""Setting this field on a partner makes this partner available as a client contact."""),
    'lino.modlib.users.User.coaching_type' : _("""The coaching type used for new coachings of this user."""),
    'lino.modlib.users.User.coaching_supervisor' : _("""Notify me when a coach has been assigned."""),
    'lino.modlib.comments.Comment' : _("""The database model to represent a comment."""),
    'lino.modlib.comments.Comment.user' : _("""The author of the comment."""),
    'lino.modlib.comments.Comment.group' : _("""The user group this comment belongs to."""),
    'lino.modlib.comments.Comment.owner' : _("""The discussion topic this comment is about."""),
    'lino.modlib.comments.Comment.body' : _("""The full body text of your comment."""),
    'lino.modlib.comments.Comment.short_preview' : _("""The first paragraph of your body."""),
    'lino.modlib.comments.Comment.emotion' : _("""The emotion of this comment."""),
    'lino.modlib.comments.Comment.published' : _("""When this comment has been published. A timestamp."""),
    'lino.modlib.comments.Comments.show_published' : _("""Whether to show only (un)published comments, independently of the publication date."""),
    'lino.modlib.comments.Comments.start_date' : _("""Hide comments before this date."""),
    'lino.modlib.comments.Comments.end_date' : _("""Hide comments after this date."""),
    'lino.modlib.comments.Comments.observed_event' : _("""Which event (created, modified or published) to consider when applying the date range given by start_date and end_date."""),
    'lino.modlib.comments.AllComments' : _("""Show all comments."""),
    'lino.modlib.comments.MyComments' : _("""Show the comments posted by the current user."""),
    'lino.modlib.comments.RecentComments' : _("""Show the most recent comments that have been posted on this site."""),
    'lino.modlib.comments.CommentsByRFC' : _("""Shows the comments about a given database row."""),
    'lino.modlib.comments.CommentEvents' : _("""The choicelist with selections for Comments.observed_event."""),
    'lino.modlib.comments.Emotions' : _("""The list of available values for the Comment.emotion field."""),
    'lino.modlib.comments.CommentType' : _("""The CommentType model is not being used in production, one day we will probably remove it."""),
    'lino.modlib.comments.CommentTypes' : _("""The table with all existing comment types."""),
    'lino.modlib.comments.Commentable' : _("""Mixin for models that are commentable, i.e. the rows of which can become discussion topic of comments."""),
    'lino.modlib.comments.Commentable.add_comments_filter' : _("""Add filters to the given queryset of comments, requested by the given user."""),
    'lino.modlib.comments.Commentable.get_rfc_description' : _("""Return a HTML formatted string with the description of this Commentable as it should be displayed by the slave summary of CommentsByRFC."""),
    'lino.modlib.comments.Commentable.on_create_comment' : _("""Called when a comment about this is being created."""),
    'lino.modlib.comments.Commentable.on_commented' : _("""This is automatically called when a comment has been created or modified."""),
    'lino.modlib.files.Volume' : _("""The Django model representing a file volume."""),
    'lino.modlib.files.Volume.id' : _("""The primary key used to point to this volume from a database object."""),
    'lino.modlib.files.Volume.ref' : _("""The full path of the root folder."""),
    'lino.modlib.files.Volume.text' : _("""A descriptive text."""),
    'lino.modlib.files.Volume.base_url' : _("""The base URL where files of this volume are being served."""),
    'lino.modlib.files.Volume.backend' : _("""The file backend used to access the files on this volume."""),
    'lino.modlib.files.File.id' : _("""Internal ID to be used as primary key."""),
    'lino.modlib.files.File.volume' : _("""The volume where this file is stored."""),
    'lino.modlib.files.File.parent' : _("""The parent directory."""),
    'lino.modlib.files.File.is_folder' : _("""Whether this is a directory, i.e. a special file which contains other files and has no content on its own."""),
    'lino.modlib.files.File.name' : _("""The name of this file. Must be unique among siblings of a same parent."""),
    'lino.modlib.files.File.full_name' : _("""The full path name relative to the root folder of the volume."""),
    'lino.modlib.files.File.broken' : _("""Whether the file no longer exists on the file system."""),
    'lino.modlib.files.File.state' : _("""The state of this file, used to control the workflow."""),
    'lino.modlib.files.FileStates' : _("""A choicelist with the possible states of a file."""),
    'lino.modlib.files.Receivable' : _("""A mixin for models that require their every object to have a scan or pdf file of the “receipt”, i.e. the document serving as the legal proof of this database object. A usage example are purchase invoices in an accounting system."""),
    'lino.modlib.files.Receivable.receipt' : _("""The file which serves as receipt for this database object."""),
    'lino.modlib.files.Receivable.needs_receipt' : _("""Return True if this database object needs a receipt."""),
    'lino.modlib.files.PendingReceivables' : _("""Shows all receivables that need a receipt but don’t have any."""),
    'lino.modlib.files.BrokenFiles' : _("""Shows all unused files (i.e. which aren’t referred to by any database object)."""),
    'lino.modlib.files.DanglingReceipts' : _("""Shows all files that are a receipt but aren’t used as such by any receivable."""),
    'lino.modlib.gkfs.Controllable' : _("""Mixin for models that are “controllable” by another database object."""),
    'lino.modlib.gkfs.Controllable.update_controller_field' : _("""Update attributes of the owner field and its underlying fields owner_id and owner_type."""),
    'lino.modlib.gkfs.Controllable.update_owned_instance' : _("""If this (acting as a controller) is itself controlled, forward the call to the controller."""),
    'lino.modlib.gkfs.Controllable.owner_label' : _("""Deprecated. This is (and always was) being ignored. Use update_controller_field() instead. The labels (verbose_name) of the fields owned_type, owned_id and owned are derived from this attribute which may be overridden by subclasses."""),
    'lino.modlib.gkfs.ContentTypes' : _("""Lino installs this as the default data table for django.contrib.ContentType."""),
    'lino.modlib.gkfs.ContentTypes.base_classes' : _("""Display a clickable list of all MTI parents, i.e. non-abstract base models."""),
    'lino.modlib.gkfs.HelpText' : _("""Django model to represent a customized help text."""),
    'lino.modlib.gkfs.BrokenGFKs' : _("""Shows all database objects that have a broken GeneriForeignKey field."""),
    'lino.modlib.gkfs.GenericForeignKey' : _("""Add verbose_name and help_text to Django’s GFK."""),
    'lino.modlib.gkfs.GenericForeignKeyIdField' : _("""Use this instead of models.PositiveIntegerField for fields that are part of a GFK and you want Lino to render them using a Combobox."""),
    'lino.modlib.jinja.JinjaBuildMethod' : _("""Inherits from lino.modlib.printing.DjangoBuildMethod."""),
    'lino.modlib.jinja.XMLMaker' : _("""Usage example in /topics/xml"""),
    'lino.modlib.jinja.XMLMaker.xml_file_name' : _("""The name of the XML file to generate. This file will be overwritten without asking. The name formatted with one name self in the context."""),
    'lino.modlib.jinja.XMLMaker.xml_file_template' : _("""The name of a Jinja template to render for generating the XML content."""),
    'lino.modlib.jinja.XMLMaker.xml_validator_file' : _("""The name of a “validator” to use for validating the XML content."""),
    'lino.modlib.jinja.XMLMaker.get_xml_file' : _("""Get the name of the XML file to be generated for this database row."""),
    'lino.modlib.jinja.XMLMaker.make_xml_file' : _("""Make the XML file for this database row."""),
    'lino.modlib.memo.Previewable' : _("""See dg.memo.Previewable."""),
    'lino.modlib.memo.Previewable.body' : _("""An editable text body."""),
    'lino.modlib.memo.Previewable.body_short_preview' : _("""A read-only preview of the first paragraph of body."""),
    'lino.modlib.memo.Previewable.body_full_preview' : _("""A read-only full preview of body."""),
    'lino.modlib.memo.BabelPreviewable' : _("""A Previewable where the body field is a babel field."""),
    'lino.modlib.memo.PreviewableChecker' : _("""Check for previewables needing update."""),
    'lino.modlib.memo.Mention' : _("""Django model to represent a mention, i.e. the fact that some memo text of the owner points to some other database row."""),
    'lino.modlib.memo.Mention.owner' : _("""The database row that mentions another one in a memo text."""),
    'lino.modlib.memo.Mention.source' : _("""The mentioned database row."""),
    'lino.modlib.memo.MemoReferrable' : _("""Makes your model referable by a memo command."""),
    'lino.modlib.memo.MemoReferrable.memo_command' : _("""The name of the memo command to define."""),
    'lino.modlib.notify.Message' : _("""The Django model that represents a notification message."""),
    'lino.modlib.notify.Message.subject' : _("""The subject of this message. See Subject and body of a notification message."""),
    'lino.modlib.notify.Message.body' : _("""The body of this message. See Subject and body of a notification message."""),
    'lino.modlib.notify.Message.user' : _("""The recipient of this message. The site user to whom this message is to be delivered."""),
    'lino.modlib.notify.Message.owner' : _("""The owner of this message. Expresses what this message is about."""),
    'lino.modlib.notify.Message.message_type' : _("""The notification message type."""),
    'lino.modlib.notify.Message.reply_to' : _("""The comment to which a reply to this message would reply."""),
    'lino.modlib.notify.Message.created' : _("""Timestamp of when this message has been emitted."""),
    'lino.modlib.notify.Message.sent' : _("""Timestamp of when this message has been sent via email to its recipient."""),
    'lino.modlib.notify.Message.seen' : _("""Timestamp of when the recipient of this message has marked it as seen."""),
    'lino.modlib.notify.Message.emit_notification' : _("""Emit a notification message to each of the given recipients, respecting their individual user settings."""),
    'lino.modlib.notify.Message.create_message' : _("""Create a message unless that user has already been notified about that object."""),
    'lino.modlib.notify.Message.send_summary_emails' : _("""Send summary emails for all pending notifications with the given mail_mode mm."""),
    'lino.modlib.notify.Message.send_browser_message_for_all_users' : _("""Send_message to all connected users"""),
    'lino.modlib.notify.Message.send_browser_message' : _("""Send_message to the user’s browser"""),
    'lino.modlib.notify.Messages' : _("""Base for all tables of messages."""),
    'lino.modlib.notify.AllMessages' : _("""The gobal list of all messages."""),
    'lino.modlib.notify.MyMessages' : _("""Shows messages emitted to me."""),
    'lino.modlib.notify.Subscription' : _("""The Django model that represents a push subscription."""),
    'lino.modlib.notify.ChangeNotifier' : _("""Model mixin for things that emit notifications to a list of observers (or “watchers”) when an instance is modified."""),
    'lino.modlib.notify.ChangeNotifier.add_change_watcher' : _("""Parameters:"""),
    'lino.modlib.notify.ChangeNotifier.get_change_subject' : _("""Returns the subject text of the notification message to emit."""),
    'lino.modlib.notify.ChangeNotifier.get_change_body' : _("""Return the body text of the notification message to emit."""),
    'lino.modlib.notify.ChangeNotifier.get_change_info' : _("""Return a list of HTML elements to be inserted into the body."""),
    'lino.modlib.notify.ChangeNotifier.get_change_owner' : _("""Return the owner of the notification to emit."""),
    'lino.modlib.notify.NotifyingAction' : _("""Mixin for notifying actions."""),
    'lino.modlib.notify.NotifyingAction.get_notify_subject' : _("""Return the default value of the notify_subject field."""),
    'lino.modlib.notify.NotifyingAction.get_notify_body' : _("""Return the default value of the notify_body field."""),
    'lino.modlib.notify.NotifyingAction.get_notify_owner' : _("""Expected to return the owner lino.modlib.notify.Message.owner> of the message."""),
    'lino.modlib.notify.NotifyingAction.get_notify_recipients' : _("""Yield a list of users to be notified."""),
    'lino.modlib.notify.MessageTypes' : _("""The list of possible choices for the message_type field of a Message."""),
    'lino.modlib.notify.MailModes' : _("""How the system should send email notifications to a user."""),
    'lino.modlib.notify.MailModes.silent' : _("""Disable notifications for this user."""),
    'lino.modlib.notify.MailModes.never' : _("""Notify in Lino but never send email."""),
    'lino.modlib.notify.MarkSeen' : _("""Mark this message as seen."""),
    'lino.modlib.notify.MarkAllSeen' : _("""Mark all messages as seen."""),
    'lino.modlib.notify.ClearSeen' : _("""Mark this message as not yet seen."""),
    'lino.modlib.printing.PrintableContext.this' : _("""The printable object instance"""),
    'lino.modlib.printing.PrintableContext.site' : _("""shortcut for settings.SITE"""),
    'lino.modlib.printing.Printable' : _("""Mixin for models for which Lino can generate a printable document."""),
    'lino.modlib.printing.Printable.get_print_language' : _("""Return a Django language code to be activated when an instance of this is being printed. The default implementation returns the Site’s default language."""),
    'lino.modlib.printing.Printable.get_print_templates' : _("""Return a list of file names of templates for the specified build method. Returning an empty list means that this item is not printable. For subclasses of SimpleBuildMethod the returned list may not contain more than 1 element."""),
    'lino.modlib.printing.Printable.get_printable_context' : _("""Adds a series of names to the context used when rendering printable documents."""),
    'lino.modlib.printing.Printable.get_body_template' : _("""Return the name of the body template to use when rendering this object in a printable excerpt (lino_xl.lib.excerpts). An empty string means that Lino should use the default value defined on the ExcerptType."""),
    'lino.modlib.printing.Printable.get_printable_demo_objects' : _("""Return an iterable of database rows for which Lino should generate a printable excerpt."""),
    'lino.modlib.printing.Printable.get_build_method' : _("""Return the build method to use when printing this object."""),
    'lino.modlib.printing.Printable.get_excerpt_options' : _("""Set additional fields of newly created excerpts from this. Called from lino_xl.lib.excerpts.models.ExcerptType.get_or_create_excerpt."""),
    'lino.modlib.printing.Printable.before_printable_build' : _("""This is called by print actions before the printable is being generated. Application code may e.g. raise a Warning exception in order to refuse the print action. The warning message can be a translatable string."""),
    'lino.modlib.printing.CachedPrintable' : _("""Mixin for Models that generate a unique external file at a determined place when being printed."""),
    'lino.modlib.printing.CachedPrintable.build_time' : _("""Timestamp of the built target file. Contains None if no build hasn’t been called yet."""),
    'lino.modlib.printing.CachedPrintable.do_print' : _("""Print this database row."""),
    'lino.modlib.printing.TypedPrintable' : _("""A CachedPrintable that uses a “Type” for deciding which template to use on a given instance."""),
    'lino.modlib.printing.PrintableType' : _("""Base class for models that specify the TypedPrintable.type."""),
    'lino.modlib.printing.PrintableType.templates_group' : _("""Default value for templates_group is the model’s full name."""),
    'lino.modlib.printing.PrintableType.build_method' : _("""A pointer to an item of BuildMethods."""),
    'lino.modlib.printing.PrintableType.template' : _("""The name of the file to be used as template."""),
    'lino.modlib.printing.CachedPrintableChecker' : _("""Checks for missing cache files on all objects which inherit CachedPrintable."""),
    'lino.modlib.printing.BasePrintAction' : _("""Base class for all “Print” actions."""),
    'lino.modlib.printing.DirectPrintAction' : _("""Print using a hard-coded template and without cache."""),
    'lino.modlib.printing.CachedPrintAction' : _("""A print action which uses a cache for the generated printable document and builds is only when it doesn’t yet exist."""),
    'lino.modlib.printing.ClearCacheAction' : _("""Defines the Clear cache button on a Printable record."""),
    'lino.modlib.printing.EditTemplate' : _("""Edit the print template, i.e. the file specified by Printable.get_print_templates()."""),
    'lino.modlib.printing.BuildMethods' : _("""The choicelist of build methods offered on this site."""),
    'lino.modlib.printing.BuildMethod' : _("""Base class for all build methods. A build method encapsulates the process of generating a “printable document” that inserts data from the database into a template, using a given combination of a template parser and post-processor."""),
    'lino.modlib.printing.BuildMethod.use_webdav' : _("""Whether this build method results is an editable file. For example, .odt files are considered editable while .pdf files aren’t."""),
    'lino.modlib.printing.TemplatedBuildMethod' : _("""A BuildMethod which uses a template."""),
    'lino.modlib.printing.DjangoBuildMethod' : _("""A TemplatedBuildMethod which uses Django’s templating engine."""),
    'lino.modlib.printing.XmlBuildMethod' : _("""Generates .xml files from .xml templates."""),
    'lino.modlib.printing.SimpleBuildMethod' : _("""Base for build methods which use Lino’s templating system (find_config_file)."""),
    'lino.modlib.printing.CustomBuildMethod' : _("""For example CourseToXls."""),
    'lino.modlib.printing.CustomBuildMethod.custom_build' : _("""Concrete subclasses must implement this."""),
    'lino.modlib.printing.LatexBuildMethod' : _("""Not actively used. Generates .pdf files from .tex templates."""),
    'lino.modlib.printing.RtfBuildMethod' : _("""Not actively used. Generates .rtf files from .rtf templates."""),
    'lino.modlib.printing.PisaBuildMethod' : _("""Deprecated. Generates .pdf files from .html templates. Requires pisa. Usage example see lino_book.projects.pisa."""),
    'lino.modlib.system.Dashboard' : _("""This is your main page."""),
    'lino.modlib.system.SiteConfig' : _("""A singleton database object used to store persistent site parameters."""),
    'lino.modlib.system.SiteConfig.default_build_method' : _("""The default build method to use when rendering printable documents."""),
    'lino.modlib.system.SiteConfig.simulate_today' : _("""A constant user-defined date to be substituted as current system date."""),
    'lino.modlib.system.SiteConfig.site_company' : _("""The site operator, i.e. the legal person that operates this Lino site."""),
    'lino.modlib.system.SiteConfig.hide_events_before' : _("""If this is not empty, any calendar events before that date are being hidden in certain places."""),
    'lino.modlib.system.SiteConfigManager' : _("""Returns the cached instance, which holds the one and only database instance."""),
    'lino.modlib.system.Lockable' : _("""Mixin to add row-level edit locking to any model."""),
    'lino.modlib.system.BuildSiteCache' : _("""Rebuild the site cache. This action is available on About."""),
    'lino.modlib.system.SiteConfigs' : _("""The table used to present the SiteConfig row in a Detail form."""),
    'lino.modlib.system.RecurrenceSet' : _("""Mixin for database models that express a set of repeating (“recurrent”) events. Example usage can be found in specs.cal.automatic_events."""),
    'lino.modlib.system.RecurrenceSet.start_date' : _("""The start date of the first meeting to be generated."""),
    'lino.modlib.system.RecurrenceSet.end_date' : _("""The end date of the first meeting to be generated. Leave this field empty if the meetings last less than one day."""),
    'lino.modlib.system.RecurrenceSet.every' : _("""The frequency of periodic iteration: daily, weekly, monthly or yearly."""),
    'lino.modlib.system.RecurrenceSet.every_unit' : _("""The interval between each periodic iteration."""),
    'lino.modlib.system.RecurrenceSet.positions' : _("""Space-separated list of one or several positions within the recurrency cycle."""),
    'lino.modlib.system.RecurrenceSet.max_events' : _("""Maximum number of calendar entries to generate."""),
    'lino.modlib.system.RecurrenceSet.weekdays_text' : _("""A virtual field returning the textual formulation of the weekdays where the recurrence occurs."""),
    'lino.modlib.system.Recurrences' : _("""List of possible choices for a ‘recurrency’ field."""),
    'lino.modlib.system.Recurrences.easter' : _("""Repeat events yearly, moving them together with the Easter data of that year."""),
    'lino.modlib.system.Weekdays' : _("""A choicelist with the seven days of a week."""),
    'lino.modlib.system.DurationUnits' : _("""The list of possible duration units defined by this application."""),
    'lino.modlib.system.DurationUnit' : _("""Base class for the choices in the DurationUnits choicelist."""),
    'lino.modlib.system.DurationUnit.add_duration' : _("""Return a date or datetime obtained by adding value times this unit to the specified value orig. Returns None is orig is empty."""),
    'lino.modlib.system.DisplayColors' : _("""A list of colors to be specified for displaying."""),
    'lino.modlib.system.BleachChecker' : _("""A data checker used to find unbleached html content."""),
    'lino.modlib.system.Genders' : _("""Defines the possible choices for the gender of a person (“male”, “female” and “nonbinary”)."""),
    'lino.modlib.system.YesNo' : _("""A choicelist with two values “Yes” and “No”."""),
    'lino.modlib.system.ObservedEvent' : _("""Base class for choices of “observed event”-style choicelists."""),
    'lino.modlib.system.ObservedEvent.add_filter' : _("""Add a filter to the given Django queryset. The given obj must be either a datetime.date object or must have two attributes start_date and end_date. The easiest way is to have it an instance of DateRange or DateRangeValue."""),
    'lino.modlib.system.PeriodEvents' : _("""The list of things you can observe on a lino.mixins.periods.DateRange."""),
    'lino.modlib.system.TimeZones' : _("""Used by lino.modlib.users.User.time_zone and lino_xl.lib.working.Session.time_zone."""),
    'lino.modlib.system.DateFormats' : _("""Used by lino.modlib.users.User.date_format."""),
    'lino.modlib.tinymce.TextFieldTemplate' : _("""A reusable block of text that can be selected from a text editor to be inserted into the text being edited."""),
    'lino.modlib.uploads.Upload' : _("""Django model representing an upload file."""),
    'lino.modlib.uploads.Upload.file' : _("""Pointer to the uploaded file itself (a Django FileField)."""),
    'lino.modlib.uploads.Upload.file_size' : _("""The size of the file in bytes. Not yet implemented."""),
    'lino.modlib.uploads.Upload.mimetype' : _("""The media type of the uploaded file."""),
    'lino.modlib.uploads.Upload.type' : _("""The type of this upload."""),
    'lino.modlib.uploads.Upload.description' : _("""A short description entered manually by the user."""),
    'lino.modlib.uploads.Upload.volume' : _("""A pointer to the library volume where this file is stored."""),
    'lino.modlib.uploads.Upload.upload_area' : _("""The upload area this file belongs to."""),
    'lino.modlib.uploads.Upload.library_file' : _("""The path of this file, relative the volume’s root."""),
    'lino.modlib.uploads.Upload.description_link' : _("""Almost the same as description, but if file is not empty, the text is clickable, and clicking on it opens the uploaded file in a new browser window."""),
    'lino.modlib.uploads.Uploads' : _("""Base class for all data tables of upload files."""),
    'lino.modlib.uploads.AllUploads' : _("""Shows all upload files on this Lino site."""),
    'lino.modlib.uploads.AreaUploads' : _("""Mixin for tables of upload files where the upload area is known."""),
    'lino.modlib.uploads.MyUploads' : _("""Shows my uploads (i.e. those whose author is the requesting user)."""),
    'lino.modlib.uploads.UploadBase' : _("""Abstract base class of Upload encapsulating some really basic functionality."""),
    'lino.modlib.uploads.UploadType' : _("""Django model representing an upload type."""),
    'lino.modlib.uploads.UploadType.shortcut' : _("""Optional pointer to a virtual upload shortcut field. If this is not empty, then the given shortcut field will manage uploads of this type. See also Shortcuts."""),
    'lino.modlib.uploads.UploadTypes' : _("""The table with all existing upload types."""),
    'lino.modlib.uploads.UploadController' : _("""Model mixin for database objects that can have upload files associated to them."""),
    'lino.modlib.uploads.UploadController.show_uploads' : _("""Opens a data window with the uploaded files associated to this database object."""),
    'lino.modlib.uploads.UploadsByController' : _("""Shows the uploaded files associated to this database object."""),
    'lino.modlib.uploads.Shortcuts' : _("""The list of available upload shortcut fields in this application."""),
    'lino.modlib.uploads.UploadsFolderChecker' : _("""Find orphaned files in uploads folder."""),
    'lino.modlib.weasyprint.WeasyBuildMethod' : _("""The base class for both build methods."""),
    'lino.modlib.weasyprint.WeasyHtmlBuildMethod' : _("""Renders the input template and returns the unmodified output as plain HTML."""),
    'lino.modlib.weasyprint.WeasyPdfBuildMethod' : _("""Like WeasyBuildMethod, but the rendered HTML is then passed through weasyprint which converts from HTML to PDF."""),
    'lino.core.model.Model' : _("""Lino extension of Django’s database model. This is a subclass of Django’s Model class (django.db.models.Model)."""),
    'lino.core.model.Model.__init__' : _("""The first positional argument is the optional label, other arguments should be specified as keywords and can be any of the existing class attributes."""),
    'lino.core.model.Model.overview' : _("""A multi-paragraph representation of this database row."""),
    'lino.core.model.Model.navigation_panel' : _("""A virtual field that displays the navigation panel for this row. This may be included in a detail layout, usually either on the left or the right side with full height."""),
    'lino.core.model.Model.workflow_buttons' : _("""Shows the current workflow state of this database row and a list of available workflow actions."""),
    'lino.core.model.Model.workflow_state_field' : _("""Optional default value for the workflow_state_field of all data tables based on this model."""),
    'lino.core.model.Model.workflow_owner_field' : _("""Optional default value for workflow_owner_field on all data tables based on this model."""),
    'lino.core.model.Model.disabled_fields' : _("""Return a set of field names that should be disabled (i.e. not editable) for this database object."""),
    'lino.core.model.Model.FOO_changed' : _("""Called when field FOO of an instance of this model has been modified through the user interface."""),
    'lino.core.model.Model.FOO_choices' : _("""Return a queryset or list of allowed choices for field FOO."""),
    'lino.core.model.Model.create_FOO_choice' : _("""For every field named “FOO” for which a chooser exists, if the model also has a method called “create_FOO_choice”, then this chooser will be a learning chooser. That is, users can enter text into the combobox, and Lino will create a new database object from it."""),
    'lino.core.model.Model.get_choices_text' : _("""Return the text to be displayed when an instance of this model is being used as a choice in a combobox of a ForeignKey field pointing to this model. request is the web request, actor is the requesting actor."""),
    'lino.core.model.Model.get_parent_links' : _("""Yield a series of html chunks to prefix to the standard breadcrumbs of a detail window."""),
    'lino.core.model.Model.disable_delete' : _("""Decide whether this database object may be deleted. Return None when there is no veto against deleting this database row, otherwise a translatable message that explains to the user why they can’t delete this row."""),
    'lino.core.model.Model.update_field' : _("""Shortcut to call lino.core.inject.update_field() for usage during lino.core.site.Site.do_site_startup() in a settings.py or similar place."""),
    'lino.core.model.Model.on_duplicate' : _("""Called after duplicating a row."""),
    'lino.core.model.Model.after_duplicate' : _("""Called by lino.mixins.clonable.Duplicate on the new copied row instance, after the row and its related fields have been saved."""),
    'lino.core.model.Model.delete_veto_message' : _("""Return the message Cannot delete X because N Ys refer to it."""),
    'lino.core.model.Model.allow_cascaded_delete' : _("""A set of foreign key fields that link this model to a master in a “possessive” way, i.e. objects of this model should get deleted together with their master."""),
    'lino.core.model.Model.allow_cascaded_copy' : _("""A set of foreign key fields that that cause database rows to be automatically cloned when their master gets cloned."""),
}
