# -*- coding: UTF-8 -*-
# Copyright 2012-2025 Rumma & Ko Ltd
# License: GNU Affero General Public License v3 (see file COPYING for details)

from django.db import models
from django.utils.translation import get_language

# from django.utils.translation import get_language
# from django.utils.html import format_html

from lino.api import dd, rt, _
from lino.utils.html import E
from lino.utils.soup import MORE_MARKER
from lino.core import constants
# from lino.core.renderer import add_user_language
from lino.modlib.office.roles import OfficeUser, OfficeStaff

from .choicelists import SpecialPages
TICKET_MODEL = dd.plugins.publisher.ticket_model


VARTABS = ""

if dd.is_installed("topics"):
    VARTABS += " topics.TagsByOwner"
if dd.is_installed("comments"):
    VARTABS += " comments.CommentsByRFC"

if TICKET_MODEL is not None:
    VARTABS += " publisher.ItemsByPage"


class PageDetail(dd.DetailLayout):
    # main = "general first_panel more"
    main = f"general first_panel {VARTABS} more"

    first_panel = dd.Panel(
        """
        treeview_panel:20 preview:60
        """, label=_("Preview"))

    general = dd.Panel(
        """
    content_panel:60 right_panel:20
    """,
        label=_("General"),
        required_roles=dd.login_required(OfficeUser),
    )

    # more = dd.Panel(
    #     VARTABS,
    #     label=_("Discussion"),
    #     required_roles=dd.login_required(OfficeUser),
    # )

    content_panel = """
    title id
    body
    """

    # right_panel = """
    # parent seqno
    # child_node_depth
    # page_type
    # filler
    # """

    right_panel = """
    parent seqno
    publisher.PagesByParent
    """

    more = dd.Panel("""
    root_page language
    special_page album
    # filler child_node_depth
    publishing_state
    publisher.TranslationsByPage
    """, label=_("More"))


class Pages(dd.Table):
    model = "publisher.Page"
    column_names = "title root_page id *"
    detail_layout = "publisher.PageDetail"
    insert_layout = """
    title
    root_page
    language #filler
    """
    default_display_modes = {None: constants.DISPLAY_MODE_LIST}


class PagesByParent(Pages):
    master_key = "parent"
    label = _("Children")
    # ~ column_names = "title user *"
    order_by = ["seqno"]
    column_names = "seqno title *"
    # default_display_modes = {None: constants.DISPLAY_MODE_LIST}


class RootPages(Pages):
    filter = models.Q(parent=None)
    label = _("Root pages")
    # ~ column_names = "title user *"
    order_by = ["language", "id"]
    column_names = "id language title *"

    @classmethod
    def param_defaults(self, ar, **kw):
        kw = super().param_defaults(ar, **kw)
        kw.update(language=get_language())
        return kw

    # @classmethod
    # def get_title_tags(self, ar):
    #     return []


# PublisherViews.add_item_lazy("p", Pages)
# PublisherViews.add_item_lazy("n", Nodes)

# PageTypes.add_item(Pages, 'pages')


class TranslationsByPage(Pages):
    master_key = "translated_from"
    label = _("Translations")
    column_names = "title language id *"
    default_display_modes = {None: constants.DISPLAY_MODE_SUMMARY}

    @classmethod
    def row_as_summary(cls, ar, obj, text=None, **kwargs):
        # return format_html("({}) {}", obj.language, obj.as_summary_row(ar, **kwargs))
        return E.span("({}) ".format(obj.language), obj.as_summary_item(ar, text, **kwargs))


if TICKET_MODEL:

    class PageItems(dd.Table):
        model = 'publisher.PageItem'
        required_roles = dd.login_required(OfficeStaff)
        detail_layout = dd.DetailLayout("""
        ticket
        page seqno
        """, window_size=('auto', 40))

        insert_layout = """
        page
        ticket
        """

    class ItemsByPage(PageItems):
        master_key = "page"
        required_roles = set()  # also for anonymous
        default_display_modes = {None: constants.DISPLAY_MODE_TILES}
        column_names = "seqno ticket *"
        insert_layout = """
        ticket
        """

    class ItemsByTicket(PageItems):
        master_key = "ticket"
        default_display_modes = {
            None: constants.DISPLAY_MODE_SUMMARY,
            70: constants.DISPLAY_MODE_GRID}
        column_names = "seqno page *"
        insert_layout = """
        page
        """


SpecialPages.add_item(
    "roots",  # filler=filler,
    body=_("List of root pages on this site.") +
    MORE_MARKER + " [show publisher.RootPages]",
    title=_("Root pages"),
    parent='home')
