# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/audioBusses.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/audioBusses.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.Bus = msgbuffers.Namespace()

class BusType(object):
  "Automatically-generated uint_32 enumeration."
  Cozmo_Robot          = 1723505802
  Invalid              = 0
  Master_Audio_Bus     = 3803692087
  Master_Secondary_Bus = 805203703
  Music                = 3991942870
  Robot_Bus_1          = 2678428988
  Robot_Bus_2          = 2678428991
  Robot_Bus_3          = 2678428990
  Robot_Bus_4          = 2678428985
  Sfx                  = 393239870
  Ui                   = 1551306167
  Vo                   = 1534528548

Anki.Cozmo.Audio.Bus.BusType = BusType
del BusType


