# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/audioEventTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/audioEventTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()

class Coz_App(object):
  "Automatically-generated uint_32 enumeration."
  Enter_Background = 2017190380
  Enter_Foreground = 1225777195
  Invalid          = 0

Anki.Cozmo.Audio.GameEvent.Coz_App = Coz_App
del Coz_App


class Dev_Device(object):
  "Automatically-generated uint_32 enumeration."
  External_Source = 3462246304
  Invalid         = 0
  Tone_Generator  = 2415524415

Anki.Cozmo.Audio.GameEvent.Dev_Device = Dev_Device
del Dev_Device


class Dev_Robot(object):
  "Automatically-generated uint_32 enumeration."
  External_Source  = 2539447680
  Freq_Sweep       = 2028515806
  Invalid          = 0
  Pink_1Sec        = 3980968688
  Pink_5Sec        = 988519260
  Tone_1760Hz_5Sec = 3488492107
  Tone_1K_1Sec     = 4068444155
  Tone_1K_5Sec     = 1034417959
  Tone_440Hz_5Sec  = 1471825745

Anki.Cozmo.Audio.GameEvent.Dev_Robot = Dev_Robot
del Dev_Robot


class EventGroupType(object):
  "Automatically-generated uint_32 enumeration."
  Coz_App      = 0
  Dev_Device   = 1
  Dev_Robot    = 2
  GenericEvent = 3
  Music        = 4
  Robot_Sfx    = 5
  Robot_Vo     = 6
  Sfx          = 7
  Ui           = 8

Anki.Cozmo.Audio.GameEvent.EventGroupType = EventGroupType
del EventGroupType


class GenericEvent(object):
  "Automatically-generated uint_32 enumeration."
  Invalid                                                         = 0
  Play__Coz_App__Enter_Background                                 = 2017190380
  Play__Coz_App__Enter_Foreground                                 = 1225777195
  Play__Dev_Device__External_Source                               = 3462246304
  Play__Dev_Device__Tone_Generator                                = 2415524415
  Play__Dev_Robot__External_Source                                = 2539447680
  Play__Dev_Robot__Freq_Sweep                                     = 2028515806
  Play__Dev_Robot__Pink_1Sec                                      = 3980968688
  Play__Dev_Robot__Pink_5Sec                                      = 988519260
  Play__Dev_Robot__Tone_1760Hz_5Sec                               = 3488492107
  Play__Dev_Robot__Tone_1K_1Sec                                   = 4068444155
  Play__Dev_Robot__Tone_1K_5Sec                                   = 1034417959
  Play__Dev_Robot__Tone_440Hz_5Sec                                = 1471825745
  Play__Music__Play                                               = 2748524418
  Play__Robot_Sfx__Bored_Brickout                                 = 4013569785
  Play__Robot_Sfx__Bored_Pendulum                                 = 62303530
  Play__Robot_Sfx__Bored_Slot                                     = 3905586496
  Play__Robot_Sfx__Bpk_Blue_Loop_Play                             = 4211412779
  Play__Robot_Sfx__Bpk_Green_Loop_Play                            = 1352654968
  Play__Robot_Sfx__Bpk_Red_Loop_Play                              = 2658520760
  Play__Robot_Sfx__Bpk_White_Loop_Play                            = 118136366
  Play__Robot_Sfx__Dog_Siren                                      = 2814310779
  Play__Robot_Sfx__Effort_Fail                                    = 3308460754
  Play__Robot_Sfx__Effort_Long                                    = 668351040
  Play__Robot_Sfx__Effort_Medium                                  = 3696071919
  Play__Robot_Sfx__Mvt_Tread_Backward_Loop_Play                   = 2180021393
  Play__Robot_Sfx__Mvt_Tread_Backward_Start                       = 2613090854
  Play__Robot_Sfx__Mvt_Tread_Backward_Stop                        = 1888692326
  Play__Robot_Sfx__Mvt_Tread_Forward_Loop_Play                    = 1822774717
  Play__Robot_Sfx__Mvt_Tread_Forward_Start                        = 2652548234
  Play__Robot_Sfx__Mvt_Tread_Forward_Stop                         = 3470930658
  Play__Robot_Sfx__Mvt_Tread_Spin_Loop_Play                       = 1721811722
  Play__Robot_Sfx__Mvt_Tread_Spin_Start                           = 952401069
  Play__Robot_Sfx__Mvt_Tread_Spin_Stop                            = 2338140655
  Play__Robot_Sfx__Onboarding_Power_On                            = 3840096848
  Play__Robot_Sfx__Scan_Loop_Play                                 = 866674656
  Play__Robot_Sfx__Scan_Single                                    = 3220792573
  Play__Robot_Sfx__Scan_Start                                     = 3872572455
  Play__Robot_Sfx__Scan_Stop                                      = 2639724621
  Play__Robot_Sfx__Scan_Stop_Bell                                 = 2818178987
  Play__Robot_Sfx__Scrn_Angry                                     = 2974471057
  Play__Robot_Sfx__Scrn_Angry_Long                                = 3501460118
  Play__Robot_Sfx__Scrn_Angry_Short                               = 105427450
  Play__Robot_Sfx__Scrn_Angry_Single                              = 1286585712
  Play__Robot_Sfx__Scrn_Blink                                     = 2666670780
  Play__Robot_Sfx__Scrn_Curious                                   = 1701725212
  Play__Robot_Sfx__Scrn_Curious_Long                              = 3031263429
  Play__Robot_Sfx__Scrn_Curious_Pitch_Up                          = 3559153577
  Play__Robot_Sfx__Scrn_Curious_Short                             = 2929211683
  Play__Robot_Sfx__Scrn_Curious_Single                            = 2347235575
  Play__Robot_Sfx__Scrn_Go_To_Sleep                               = 2177539960
  Play__Robot_Sfx__Scrn_Happy                                     = 302804072
  Play__Robot_Sfx__Scrn_Happy_Long                                = 1961931745
  Play__Robot_Sfx__Scrn_Happy_Short                               = 3678808343
  Play__Robot_Sfx__Scrn_Happy_Single                              = 1484658355
  Play__Robot_Sfx__Scrn_Look                                      = 3560778311
  Play__Robot_Sfx__Scrn_Sad                                       = 2370771958
  Play__Robot_Sfx__Scrn_Sad_Long                                  = 1620542011
  Play__Robot_Sfx__Scrn_Sad_Short                                 = 2584633397
  Play__Robot_Sfx__Scrn_Sad_Single                                = 775385813
  Play__Robot_Sfx__Scrn_Surprised                                 = 3774252557
  Play__Robot_Sfx__Scrn_Surprised_Long                            = 1923508322
  Play__Robot_Sfx__Scrn_Surprised_Short                           = 3952553918
  Play__Robot_Sfx__Scrn_Surprised_Single                          = 3984545916
  Play__Robot_Sfx__Spark_Launch                                   = 771536042
  Play__Robot_Sfx__Sparked_Workout_Break                          = 1558032299
  Play__Robot_Sfx__Sparked_Workout_Break_Loop                     = 2454903272
  Play__Robot_Sfx__Srv_Angry                                      = 1322826570
  Play__Robot_Sfx__Srv_Angry_Long                                 = 3491658847
  Play__Robot_Sfx__Srv_Angry_Short                                = 3765708529
  Play__Robot_Sfx__Srv_Curious                                    = 1279900047
  Play__Robot_Sfx__Srv_Curious_Long                               = 3969150064
  Play__Robot_Sfx__Srv_Curious_Short                              = 974094096
  Play__Robot_Sfx__Srv_Happy                                      = 2128944011
  Play__Robot_Sfx__Srv_Happy_Long                                 = 2435936364
  Play__Robot_Sfx__Srv_Happy_Short                                = 105551732
  Play__Robot_Sfx__Srv_Sad                                        = 3613386685
  Play__Robot_Sfx__Srv_Sad_Long                                   = 25316626
  Play__Robot_Sfx__Srv_Sad_Short                                  = 3699079406
  Play__Robot_Sfx__Srv_Surprised                                  = 1907152766
  Play__Robot_Sfx__Srv_Surprised_Long                             = 3606017555
  Play__Robot_Sfx__Srv_Surprised_Short                            = 4054065165
  Play__Robot_Sfx__Wink                                           = 3564343056
  Play__Robot_Vo__Coz_Word_Cube_Neutral                           = 2117050142
  Play__Robot_Vo__External_Cozmo_Processing                       = 3205213409
  Play__Robot_Vo__External_Unprocessed                            = 2742937278
  Play__Robot_Vo__Gp_Cs_Cuss_Nope                                 = 3018392957
  Play__Robot_Vo__Gp_Cs_Cuss_React                                = 1772137818
  Play__Robot_Vo__Gp_Cs_Cuss_Squint                               = 141123577
  Play__Robot_Vo__Gp_Cs_Getout_Confused_P1                        = 2151470956
  Play__Robot_Vo__Gp_Cs_Getout_Confused_P2                        = 2151470959
  Play__Robot_Vo__Gp_Cs_Thinking_Long                             = 3183384229
  Play__Robot_Vo__Gp_Cs_Thinking_Long_Got_It                      = 726115194
  Play__Robot_Vo__Gp_Cs_Thinking_Medium                           = 448600270
  Play__Robot_Vo__Gp_Cs_Thinking_Medium_Got_It                    = 1735580995
  Play__Robot_Vo__Gp_Explorer_Backup_Beep                         = 1939604322
  Play__Robot_Vo__Gp_Explorer_Drive_Curious                       = 1093526092
  Play__Robot_Vo__Gp_Explorer_Drive_Start                         = 746725306
  Play__Robot_Vo__Gp_Explorer_Drive_Start_Turbo                   = 403916659
  Play__Robot_Vo__Gp_Explorer_Drive_Stop                          = 2294544082
  Play__Robot_Vo__Gp_Explorer_Getin                               = 821905486
  Play__Robot_Vo__Gp_Explorer_Shake_Out                           = 2327316800
  Play__Robot_Vo__Gp_Keepaway_Fakeout_Pounce_Fast                 = 1992185148
  Play__Robot_Vo__Gp_Keepaway_Fakeout_Pounce_Scare                = 888370506
  Play__Robot_Vo__Gp_Keepaway_Fakeout_Sneaky_Start                = 2606311637
  Play__Robot_Vo__Gp_Keepaway_Get_In_Ready                        = 2743085071
  Play__Robot_Vo__Gp_Keepaway_Win_Dance                           = 4061224253
  Play__Robot_Vo__Gp_Mm_Pattern_Struggle_Focused                  = 624174194
  Play__Robot_Vo__Gp_Mm_Pattern_Struggle_Shocked                  = 3286982676
  Play__Robot_Vo__Gp_Mm_Pattern_Struggle_Um                       = 3700907145
  Play__Robot_Vo__Gp_Mm_Pattern_Taunt_Derr                        = 3651300059
  Play__Robot_Vo__Gp_Mm_Pattern_Turn_Big                          = 900238575
  Play__Robot_Vo__Gp_Mm_Pattern_Turn_Short                        = 928871515
  Play__Robot_Vo__Gp_Mm_Pattern_Win_Giggle                        = 1101765759
  Play__Robot_Vo__Gp_Mm_Pattern_Win_Laugh_Short                   = 2208086756
  Play__Robot_Vo__Gp_Mm_Point_Big_Left                            = 1221789239
  Play__Robot_Vo__Gp_Mm_Point_Big_Right                           = 940599258
  Play__Robot_Vo__Gp_Mm_Point_Center                              = 2858254746
  Play__Robot_Vo__Gp_Mm_Point_Small_Left_From_Center              = 4045720587
  Play__Robot_Vo__Gp_Mm_Point_Small_Left_From_Right               = 3608235614
  Play__Robot_Vo__Gp_Mm_Point_Small_Right_From_Center             = 3225747664
  Play__Robot_Vo__Gp_Mm_Point_Small_Right_From_Left               = 3953770308
  Play__Robot_Vo__Gp_Qt_Tap_Effort                                = 2222654907
  Play__Robot_Vo__Gp_Shared_Fakeout                               = 543301532
  Play__Robot_Vo__Gp_Shared_Humph                                 = 2079303
  Play__Robot_Vo__Gp_Shared_Lose_Fit_Medium                       = 3218891970
  Play__Robot_Vo__Gp_Shared_Lose_Fit_Short                        = 876073127
  Play__Robot_Vo__Gp_Shared_Lose_Growl_Medium                     = 2046364900
  Play__Robot_Vo__Gp_Shared_Lose_Growl_Short                      = 3207916529
  Play__Robot_Vo__Gp_Shared_Lose_Growl_Short_01                   = 1671409981
  Play__Robot_Vo__Gp_Shared_Lose_Level_1                          = 420891483
  Play__Robot_Vo__Gp_Shared_Lose_Level_2                          = 420891480
  Play__Robot_Vo__Gp_Shared_Lose_Level_3                          = 420891481
  Play__Robot_Vo__Gp_Shared_Lose_Look_Up                          = 361519622
  Play__Robot_Vo__Gp_Shared_Lose_Look_Up_Surprised                = 2413162080
  Play__Robot_Vo__Gp_Shared_Lose_Surprised_Short                  = 291687249
  Play__Robot_Vo__Gp_Shared_Lose_Throw_Cube                       = 247758371
  Play__Robot_Vo__Gp_Shared_Win_Chachacha                         = 2184979880
  Play__Robot_Vo__Gp_Shared_Win_Dance_Hum_1                       = 1324616160
  Play__Robot_Vo__Gp_Shared_Win_Laugh                             = 2763212437
  Play__Robot_Vo__Gp_Shared_Win_Level_1                           = 430910432
  Play__Robot_Vo__Gp_Shared_Win_Level_2                           = 430910435
  Play__Robot_Vo__Gp_Shared_Win_Level_3                           = 430910434
  Play__Robot_Vo__Gp_Shared_Win_Medium                            = 3810035423
  Play__Robot_Vo__Gp_Shared_Win_Short                             = 943980464
  Play__Robot_Vo__Gp_Shared_Win_Wow_Short                         = 771576844
  Play__Robot_Vo__Gp_Simon_Fail_Hand_P1                           = 3500835092
  Play__Robot_Vo__Gp_Simon_Fail_Hand_P2                           = 3500835095
  Play__Robot_Vo__Gp_Simon_Fail_Hand_P3                           = 3500835094
  Play__Robot_Vo__Gp_Simon_Success_Hand_Cozmo_P3                  = 3632781140
  Play__Robot_Vo__Gp_Simon_Success_Hand_Player_P1                 = 1088973227
  Play__Robot_Vo__Gp_Simon_Success_Hand_Player_P2                 = 1088973224
  Play__Robot_Vo__Gp_Simon_Success_Hand_Player_P3                 = 1088973225
  Play__Robot_Vo__Hiking_Hum_Happy                                = 1163200773
  Play__Robot_Vo__Hiking_Hum_Happy_Short                          = 3113369638
  Play__Robot_Vo__Meet_Cozmo_Got_It                               = 4040383078
  Play__Robot_Vo__Meet_Cozmo_Thinking                             = 1307500180
  Play__Robot_Vo__Onboarding_Cube_Lift_First                      = 1219220413
  Play__Robot_Vo__Onboarding_Cube_Lifted_React                    = 1564490581
  Play__Robot_Vo__Onboarding_Cube_Lifted_React_Taka               = 3320332885
  Play__Robot_Vo__Onboarding_Cube_Lifted_React_Whoa               = 124760265
  Play__Robot_Vo__Onboarding_Cube_Lifted_React_Woohoo             = 2259447157
  Play__Robot_Vo__Onboarding_Cube_Set_Celebrate                   = 1518322125
  Play__Robot_Vo__Onboarding_Cube_Set_First                       = 2694671152
  Play__Robot_Vo__Onboarding_Cube_Set_Wow                         = 3560671663
  Play__Robot_Vo__Onboarding_Curious_Huh                          = 555367759
  Play__Robot_Vo__Onboarding_Curious_Look_Around                  = 3020031119
  Play__Robot_Vo__Onboarding_Curious_Look_Up                      = 2784611827
  Play__Robot_Vo__Onboarding_Eyes_Open                            = 1462474442
  Play__Robot_Vo__Onboarding_Happy                                = 142998609
  Play__Robot_Vo__Onboarding_See_Cube_First                       = 3651618653
  Play__Robot_Vo__Onboarding_See_Face_First                       = 3734844721
  Play__Robot_Vo__Pet_Detection_Bark                              = 3056349377
  Play__Robot_Vo__Pet_Detection_Cat_Meow                          = 629947316
  Play__Robot_Vo__Pet_Detection_Growl                             = 2361443718
  Play__Robot_Vo__Pet_Detection_Howl                              = 1083767857
  Play__Robot_Vo__Pet_Detection_Roar                              = 4176723711
  Play__Robot_Vo__Pet_Detection_Roar_End                          = 4112591521
  Play__Robot_Vo__Pet_Detection_Sneeze                            = 501972637
  Play__Robot_Vo__Pet_Detection_Sneeze_Build                      = 3938249640
  Play__Robot_Vo__Pet_Detection_Sneeze_Shake                      = 593425994
  Play__Robot_Vo__Placeholder                                     = 668634652
  Play__Robot_Vo__React_3_Cube_Topple_P1                          = 3537517197
  Play__Robot_Vo__React_3_Cube_Topple_P2                          = 3537517198
  Play__Robot_Vo__React_Cliff                                     = 3202816225
  Play__Robot_Vo__React_Cliff_Neutral                             = 2157786177
  Play__Robot_Vo__React_Cliff_Nope                                = 2919996492
  Play__Robot_Vo__React_Cliff_Wow                                 = 4237662181
  Play__Robot_Vo__React_Cube_Reach_Struggle                       = 885432736
  Play__Robot_Vo__React_Face_Dislike                              = 982507682
  Play__Robot_Vo__React_Face_Like                                 = 3280935088
  Play__Robot_Vo__React_Face_Suspicious                           = 3698170420
  Play__Robot_Vo__React_Face_Wiggle                               = 3090287958
  Play__Robot_Vo__React_Pickup                                    = 2638083869
  Play__Robot_Vo__React_Pickup_Angry_P1                           = 703918427
  Play__Robot_Vo__React_Pickup_Angry_P2                           = 703918424
  Play__Robot_Vo__React_See_Cube_First                            = 3238039505
  Play__Robot_Vo__React_Stuck_Angry_P1                            = 1511466269
  Play__Robot_Vo__React_Stuck_Angry_P2                            = 1511466270
  Play__Robot_Vo__React_Stuck_Turtle_Roll_Fail_P1                 = 3446648261
  Play__Robot_Vo__React_Stuck_Turtle_Roll_Fail_P2                 = 3446648262
  Play__Robot_Vo__React_Stuck_Turtle_Roll_Fail_P3                 = 3446648263
  Play__Robot_Vo__React_Stuck_Turtle_Roll_Fail_P4                 = 3446648256
  Play__Robot_Vo__React_Stuck_Turtle_Struggle                     = 3969487586
  Play__Robot_Vo__React_Wheely_Spin                               = 1957283066
  Play__Robot_Vo__Shared_Align_Frustrated_Loop_Play               = 768645691
  Play__Robot_Vo__Shared_Align_Grunt                              = 254819395
  Play__Robot_Vo__Shared_Align_Happy_Loop_Play                    = 3811848393
  Play__Robot_Vo__Shared_Align_Loop_Play                          = 4026047306
  Play__Robot_Vo__Shared_Angry_Long                               = 3990793429
  Play__Robot_Vo__Shared_Angry_Loop_Play                          = 1864639974
  Play__Robot_Vo__Shared_Angry_Short                              = 622779059
  Play__Robot_Vo__Shared_Awe                                      = 4199618846
  Play__Robot_Vo__Shared_Bored_Look_Side                          = 751598833
  Play__Robot_Vo__Shared_Bored_Look_Up                            = 2589648919
  Play__Robot_Vo__Shared_Bored_Sigh_Long                          = 412109486
  Play__Robot_Vo__Shared_Bored_Sigh_Short                         = 2741090610
  Play__Robot_Vo__Shared_Celebrate_Spin                           = 2159643843
  Play__Robot_Vo__Shared_Curious                                  = 3556785413
  Play__Robot_Vo__Shared_Curious_Long                             = 2068109610
  Play__Robot_Vo__Shared_Curious_Mutter                           = 2721235403
  Play__Robot_Vo__Shared_Curious_Short                            = 4047754278
  Play__Robot_Vo__Shared_Disappointed_Short                       = 327662522
  Play__Robot_Vo__Shared_Effort_Lift                              = 3824979789
  Play__Robot_Vo__Shared_Effort_Lift_Heavy                        = 3398455981
  Play__Robot_Vo__Shared_Effort_Pounce                            = 3727241044
  Play__Robot_Vo__Shared_Effort_Pounce_Heavy                      = 738969844
  Play__Robot_Vo__Shared_Effort_Set                               = 1467890010
  Play__Robot_Vo__Shared_Effort_Set_Heavy                         = 606158106
  Play__Robot_Vo__Shared_Effort_Short                             = 3200991712
  Play__Robot_Vo__Shared_Excited                                  = 2884456673
  Play__Robot_Vo__Shared_Excited_Loop_Play                        = 2679819871
  Play__Robot_Vo__Shared_Fall_Asleep                              = 3524061431
  Play__Robot_Vo__Shared_Fall_Cliff_Scream                        = 3144703383
  Play__Robot_Vo__Shared_Frustrated_Low                           = 1701937252
  Play__Robot_Vo__Shared_Fussy                                    = 3400453885
  Play__Robot_Vo__Shared_Fussy_Loop_Play                          = 756640443
  Play__Robot_Vo__Shared_Fussy_Short                              = 297407534
  Play__Robot_Vo__Shared_Giggle_Happy_Loop_Play                   = 1488458019
  Play__Robot_Vo__Shared_Giggle_Mischief                          = 855062857
  Play__Robot_Vo__Shared_Giggle_Short                             = 3928693597
  Play__Robot_Vo__Shared_Happy                                    = 3531557633
  Play__Robot_Vo__Shared_Happy_Long                               = 174359366
  Play__Robot_Vo__Shared_Happy_Loop_Play                          = 3025145855
  Play__Robot_Vo__Shared_Happy_Short                              = 1066816362
  Play__Robot_Vo__Shared_Idea                                     = 2993967144
  Play__Robot_Vo__Shared_Idea_Loop_Play                           = 1684239554
  Play__Robot_Vo__Shared_Idea_Short                               = 1143549143
  Play__Robot_Vo__Shared_Inhale                                   = 237432456
  Play__Robot_Vo__Shared_Interested                               = 1609212516
  Play__Robot_Vo__Shared_Interested_Long                          = 3957181661
  Play__Robot_Vo__Shared_Pain                                     = 3089977461
  Play__Robot_Vo__Shared_Pounce_Charge                            = 4216929694
  Play__Robot_Vo__Shared_Pounce_Fail                              = 4228327806
  Play__Robot_Vo__Shared_Raspberry                                = 717035989
  Play__Robot_Vo__Shared_React_Face                               = 60844582
  Play__Robot_Vo__Shared_React_Face_1                             = 581777606
  Play__Robot_Vo__Shared_React_Face_2                             = 581777605
  Play__Robot_Vo__Shared_React_Face_3                             = 581777604
  Play__Robot_Vo__Shared_React_Face_4                             = 581777603
  Play__Robot_Vo__Shared_Sad                                      = 69470719
  Play__Robot_Vo__Shared_Sad_Long                                 = 2147481440
  Play__Robot_Vo__Shared_Snobby                                   = 2457314414
  Play__Robot_Vo__Shared_Snore                                    = 654990394
  Play__Robot_Vo__Shared_Snore_Fade_Out                           = 3606041598
  Play__Robot_Vo__Shared_Snore_Short                              = 2130053793
  Play__Robot_Vo__Shared_Squint                                   = 2057205297
  Play__Robot_Vo__Shared_Struggle                                 = 2593492856
  Play__Robot_Vo__Shared_Surprised                                = 2054953516
  Play__Robot_Vo__Shared_Surprised_Short                          = 1145334899
  Play__Robot_Vo__Shared_Suspicious                               = 844374444
  Play__Robot_Vo__Shared_Suspicious_Short                         = 35665907
  Play__Robot_Vo__Shared_Take_Damage_Light                        = 3078492749
  Play__Robot_Vo__Shared_Take_Damage_Medium                       = 913083578
  Play__Robot_Vo__Shared_Thinking_Short                           = 3456819050
  Play__Robot_Vo__Shared_Upgrade_Curious                          = 2081938528
  Play__Robot_Vo__Shared_Upgrade_Impressed                        = 1733627270
  Play__Robot_Vo__Shared_Upgrade_Surprised                        = 954550705
  Play__Robot_Vo__Shared_Wake_Up_1                                = 67470331
  Play__Robot_Vo__Shared_Wake_Up_2                                = 67470328
  Play__Robot_Vo__Shared_Wake_Up_3                                = 67470329
  Play__Robot_Vo__Shared_Wake_Up_4                                = 67470334
  Play__Robot_Vo__Shared_Wake_Up_P1                               = 246308351
  Play__Robot_Vo__Shared_Wake_Up_P2                               = 246308348
  Play__Robot_Vo__Shared_Wake_Up_Snort                            = 781027234
  Play__Robot_Vo__Shared_Wakeup                                   = 2412938906
  Play__Robot_Vo__Sparked_Driving                                 = 3606845375
  Play__Robot_Vo__Sparked_Driving_Look                            = 2670470879
  Play__Robot_Vo__Sparked_Driving_Start                           = 1233493330
  Play__Robot_Vo__Sparked_Fail                                    = 2861844754
  Play__Robot_Vo__Sparked_Out                                     = 2452343422
  Play__Robot_Vo__Sparked_Pyramid_Complete                        = 1438874844
  Play__Robot_Vo__Sparked_Ready_To_Go                             = 4268262662
  Play__Robot_Vo__Sparked_Succeed                                 = 4231360462
  Play__Robot_Vo__Sparked_Succeed_Tada                            = 2693760973
  Play__Robot_Vo__Sparked_Surprise                                = 3822640315
  Play__Robot_Vo__Sparked_Workout_Break_Lift_Pain                 = 492094136
  Play__Robot_Vo__Sparked_Workout_Break_Lift_Startled             = 1138165379
  Play__Robot_Vo__Sparked_Workout_Break_Lift_Struggle             = 9918389
  Play__Robot_Vo__Sparked_Workout_Lift_Fail                       = 1101180372
  Play__Robot_Vo__Sparked_Workout_Lift_Fail_Struggle              = 835476802
  Play__Robot_Vo__Sparked_Workout_Lift_Fail_Struggle_Long         = 1462283623
  Play__Robot_Vo__Sparked_Workout_Lift_Fail_Struggle_Longest      = 2885068477
  Play__Robot_Vo__Sparked_Workout_Lift_Fail_Tired                 = 3312564867
  Play__Robot_Vo__Sparked_Workout_Lift_Success_Showoff            = 2247677502
  Play__Robot_Vo__Sparked_Workout_Lift_Success_Strong             = 1844409553
  Play__Robot_Vo__Sparked_Workout_Lift_Success_Throw_Block        = 3296787010
  Play__Robot_Vo__Sparked_Workout_Lift_Success_Weak               = 2216609612
  Play__Robot_Vo__Word_Cat                                        = 743962600
  Play__Robot_Vo__Word_Cube_Excited                               = 1262712072
  Play__Robot_Vo__Word_Cube_Happy                                 = 1400293052
  Play__Robot_Vo__Word_Cube_Neutral                               = 740915407
  Play__Robot_Vo__Word_Cube_Request                               = 3660085349
  Play__Robot_Vo__Word_Cube_Sad                                   = 3995541618
  Play__Robot_Vo__Word_Dog                                        = 843495306
  Play__Robot_Vo__Word_Keepaway_Excited                           = 3097808214
  Play__Robot_Vo__Word_Keepaway_Request                           = 3460255911
  Play__Robot_Vo__Word_Keepaway_Sad                               = 2098273712
  Play__Robot_Vo__Word_Memory_Match_Happy                         = 2694835404
  Play__Robot_Vo__Word_Memory_Match_Request                       = 4090420021
  Play__Robot_Vo__Word_Memory_Match_Sad                           = 1881407426
  Play__Robot_Vo__Word_Quick_Tap                                  = 444948971
  Play__Robot_Vo__Word_Speedtap_Excited                           = 2751243663
  Play__Robot_Vo__Word_Speedtap_Request                           = 919083726
  Play__Sfx__Banner_Wipe                                          = 3247701492
  Play__Sfx__Code_Fragment_Collected                              = 2587766166
  Play__Sfx__Code_Fragment_Released                               = 1918333736
  Play__Sfx__Daily_Goal                                           = 3010549659
  Play__Sfx__Daily_Reward_Calendar_Disappear                      = 2897417442
  Play__Sfx__Daily_Reward_Collect                                 = 878067460
  Play__Sfx__Daily_Reward_Disappear                               = 2538266513
  Play__Sfx__Daily_Reward_Goal_Collect                            = 2962215520
  Play__Sfx__Daily_Reward_Open                                    = 1796529350
  Play__Sfx__Daily_Reward_Status                                  = 2202351196
  Play__Sfx__Emotion_Chip_Charged_Start                           = 2709491700
  Play__Sfx__Emotion_Chip_Charged_Tap                             = 53415191
  Play__Sfx__Game_End                                             = 3871304392
  Play__Sfx__Game_Start                                           = 126137843
  Play__Sfx__Gp_Explorer_Night_Vision_Off                         = 132505315
  Play__Sfx__Gp_Explorer_Night_Vision_On                          = 4183101071
  Play__Sfx__Gp_Mm_Light_Blue                                     = 944508478
  Play__Sfx__Gp_Mm_Light_Red                                      = 153648099
  Play__Sfx__Gp_Mm_Light_Yellow                                   = 771679342
  Play__Sfx__Gp_Mm_Pattern_Start                                  = 2601428284
  Play__Sfx__Gp_Shared_Block_Connect                              = 3790068130
  Play__Sfx__Gp_Shared_Game_End                                   = 2218318430
  Play__Sfx__Gp_Shared_Request_Game                               = 1936634046
  Play__Sfx__Gp_Shared_Round_End                                  = 3799430148
  Play__Sfx__Gp_St_Cube_Cozmo_Tap                                 = 2843679148
  Play__Sfx__Gp_St_Lightup                                        = 231361703
  Play__Sfx__Gp_St_Lose                                           = 4278097031
  Play__Sfx__Gp_St_Tap_Red                                        = 600994811
  Play__Sfx__Gp_St_Win                                            = 2704467806
  Play__Sfx__Onboarding_Test_Tone                                 = 1823946677
  Play__Sfx__Placeholder                                          = 3278074531
  Play__Sfx__Relationship_Gain                                    = 1770649520
  Play__Sfx__Relationship_Gain_Collect                            = 447401587
  Play__Sfx__Spark_Launch                                         = 38276463
  Play__Sfx__Spark_Success                                        = 3587224415
  Play__Ui__Attention_Device                                      = 796149778
  Play__Ui__Click_Back                                            = 3218349115
  Play__Ui__Click_General                                         = 902542
  Play__Ui__Cozmo_Connect                                         = 647774144
  Play__Ui__Cozmo_Connect_Fail                                    = 1743202231
  Play__Ui__Cozmo_Connect_Scan_Loop                               = 1356238993
  Play__Ui__Cozmo_Connect_Scan_Loop_Stop                          = 698059508
  Play__Ui__Cozmo_Disconnect                                      = 2439191052
  Play__Ui__Cozmo_Upgrade                                         = 1233383102
  Play__Ui__Placeholder                                           = 1840201236
  Play__Ui__Window_Close                                          = 974187556
  Play__Ui__Window_Open                                           = 1763539616
  Play__Ui__Window_Vertical_Wipe                                  = 931790836
  Stop__Music__Stop                                               = 148746486
  Stop__Robot_Sfx__Bpk_Blue_Loop_Stop                             = 3465206791
  Stop__Robot_Sfx__Bpk_Green_Loop_Stop                            = 1179892788
  Stop__Robot_Sfx__Bpk_Red_Loop_Stop                              = 1319205172
  Stop__Robot_Sfx__Bpk_White_Loop_Stop                            = 3518231466
  Stop__Robot_Sfx__Effort_Long_Stop                               = 809545185
  Stop__Robot_Sfx__Mvt_Tread_Backward_Loop_Stop                   = 1804693497
  Stop__Robot_Sfx__Mvt_Tread_Forward_Loop_Stop                    = 2726200329
  Stop__Robot_Sfx__Mvt_Tread_Spin_Loop_Stop                       = 3541928210
  Stop__Robot_Sfx__Scan_Loop_Stop                                 = 3944269316
  Stop__Robot_Sfx__Sparked_Workout_Break_Loop_Stop                = 2283733205
  Stop__Robot_Vo__Shared_Angry_Loop_Stop                          = 4168951898
  Stop__Robot_Vo__Shared_Excited_Loop_Stop                        = 1864261839
  Stop__Robot_Vo__Shared_Fussy_Loop_Stop                          = 3912485995
  Stop__Robot_Vo__Shared_Giggle_Happy_Loop_Stop                   = 3962033227
  Stop__Robot_Vo__Shared_Happy_Loop_Stop                          = 4286366971
  Stop__Robot_Vo__Shared_Idea_Loop_Stop                           = 273762158
  Stop__Robot_Vo__Sparked_Workout_Lift_Fail_Struggle_Longest_Stop = 1084850966

Anki.Cozmo.Audio.GameEvent.GenericEvent = GenericEvent
del GenericEvent


class Music(object):
  "Automatically-generated uint_32 enumeration."
  Invalid = 0
  Play    = 2748524418
  Stop    = 148746486

Anki.Cozmo.Audio.GameEvent.Music = Music
del Music


class Robot_Sfx(object):
  "Automatically-generated uint_32 enumeration."
  Bored_Brickout                  = 4013569785
  Bored_Pendulum                  = 62303530
  Bored_Slot                      = 3905586496
  Bpk_Blue_Loop_Play              = 4211412779
  Bpk_Blue_Loop_Stop              = 3465206791
  Bpk_Green_Loop_Play             = 1352654968
  Bpk_Green_Loop_Stop             = 1179892788
  Bpk_Red_Loop_Play               = 2658520760
  Bpk_Red_Loop_Stop               = 1319205172
  Bpk_White_Loop_Play             = 118136366
  Bpk_White_Loop_Stop             = 3518231466
  Dog_Siren                       = 2814310779
  Effort_Fail                     = 3308460754
  Effort_Long                     = 668351040
  Effort_Long_Stop                = 809545185
  Effort_Medium                   = 3696071919
  Invalid                         = 0
  Mvt_Tread_Backward_Loop_Play    = 2180021393
  Mvt_Tread_Backward_Loop_Stop    = 1804693497
  Mvt_Tread_Backward_Start        = 2613090854
  Mvt_Tread_Backward_Stop         = 1888692326
  Mvt_Tread_Forward_Loop_Play     = 1822774717
  Mvt_Tread_Forward_Loop_Stop     = 2726200329
  Mvt_Tread_Forward_Start         = 2652548234
  Mvt_Tread_Forward_Stop          = 3470930658
  Mvt_Tread_Spin_Loop_Play        = 1721811722
  Mvt_Tread_Spin_Loop_Stop        = 3541928210
  Mvt_Tread_Spin_Start            = 952401069
  Mvt_Tread_Spin_Stop             = 2338140655
  Onboarding_Power_On             = 3840096848
  Scan_Loop_Play                  = 866674656
  Scan_Loop_Stop                  = 3944269316
  Scan_Single                     = 3220792573
  Scan_Start                      = 3872572455
  Scan_Stop                       = 2639724621
  Scan_Stop_Bell                  = 2818178987
  Scrn_Angry                      = 2974471057
  Scrn_Angry_Long                 = 3501460118
  Scrn_Angry_Short                = 105427450
  Scrn_Angry_Single               = 1286585712
  Scrn_Blink                      = 2666670780
  Scrn_Curious                    = 1701725212
  Scrn_Curious_Long               = 3031263429
  Scrn_Curious_Pitch_Up           = 3559153577
  Scrn_Curious_Short              = 2929211683
  Scrn_Curious_Single             = 2347235575
  Scrn_Go_To_Sleep                = 2177539960
  Scrn_Happy                      = 302804072
  Scrn_Happy_Long                 = 1961931745
  Scrn_Happy_Short                = 3678808343
  Scrn_Happy_Single               = 1484658355
  Scrn_Look                       = 3560778311
  Scrn_Sad                        = 2370771958
  Scrn_Sad_Long                   = 1620542011
  Scrn_Sad_Short                  = 2584633397
  Scrn_Sad_Single                 = 775385813
  Scrn_Surprised                  = 3774252557
  Scrn_Surprised_Long             = 1923508322
  Scrn_Surprised_Short            = 3952553918
  Scrn_Surprised_Single           = 3984545916
  Spark_Launch                    = 771536042
  Sparked_Workout_Break           = 1558032299
  Sparked_Workout_Break_Loop      = 2454903272
  Sparked_Workout_Break_Loop_Stop = 2283733205
  Srv_Angry                       = 1322826570
  Srv_Angry_Long                  = 3491658847
  Srv_Angry_Short                 = 3765708529
  Srv_Curious                     = 1279900047
  Srv_Curious_Long                = 3969150064
  Srv_Curious_Short               = 974094096
  Srv_Happy                       = 2128944011
  Srv_Happy_Long                  = 2435936364
  Srv_Happy_Short                 = 105551732
  Srv_Sad                         = 3613386685
  Srv_Sad_Long                    = 25316626
  Srv_Sad_Short                   = 3699079406
  Srv_Surprised                   = 1907152766
  Srv_Surprised_Long              = 3606017555
  Srv_Surprised_Short             = 4054065165
  Wink                            = 3564343056

Anki.Cozmo.Audio.GameEvent.Robot_Sfx = Robot_Sfx
del Robot_Sfx


class Robot_Vo(object):
  "Automatically-generated uint_32 enumeration."
  Coz_Word_Cube_Neutral                           = 2117050142
  External_Cozmo_Processing                       = 3205213409
  External_Unprocessed                            = 2742937278
  Gp_Cs_Cuss_Nope                                 = 3018392957
  Gp_Cs_Cuss_React                                = 1772137818
  Gp_Cs_Cuss_Squint                               = 141123577
  Gp_Cs_Getout_Confused_P1                        = 2151470956
  Gp_Cs_Getout_Confused_P2                        = 2151470959
  Gp_Cs_Thinking_Long                             = 3183384229
  Gp_Cs_Thinking_Long_Got_It                      = 726115194
  Gp_Cs_Thinking_Medium                           = 448600270
  Gp_Cs_Thinking_Medium_Got_It                    = 1735580995
  Gp_Explorer_Backup_Beep                         = 1939604322
  Gp_Explorer_Drive_Curious                       = 1093526092
  Gp_Explorer_Drive_Start                         = 746725306
  Gp_Explorer_Drive_Start_Turbo                   = 403916659
  Gp_Explorer_Drive_Stop                          = 2294544082
  Gp_Explorer_Getin                               = 821905486
  Gp_Explorer_Shake_Out                           = 2327316800
  Gp_Keepaway_Fakeout_Pounce_Fast                 = 1992185148
  Gp_Keepaway_Fakeout_Pounce_Scare                = 888370506
  Gp_Keepaway_Fakeout_Sneaky_Start                = 2606311637
  Gp_Keepaway_Get_In_Ready                        = 2743085071
  Gp_Keepaway_Win_Dance                           = 4061224253
  Gp_Mm_Pattern_Struggle_Focused                  = 624174194
  Gp_Mm_Pattern_Struggle_Shocked                  = 3286982676
  Gp_Mm_Pattern_Struggle_Um                       = 3700907145
  Gp_Mm_Pattern_Taunt_Derr                        = 3651300059
  Gp_Mm_Pattern_Turn_Big                          = 900238575
  Gp_Mm_Pattern_Turn_Short                        = 928871515
  Gp_Mm_Pattern_Win_Giggle                        = 1101765759
  Gp_Mm_Pattern_Win_Laugh_Short                   = 2208086756
  Gp_Mm_Point_Big_Left                            = 1221789239
  Gp_Mm_Point_Big_Right                           = 940599258
  Gp_Mm_Point_Center                              = 2858254746
  Gp_Mm_Point_Small_Left_From_Center              = 4045720587
  Gp_Mm_Point_Small_Left_From_Right               = 3608235614
  Gp_Mm_Point_Small_Right_From_Center             = 3225747664
  Gp_Mm_Point_Small_Right_From_Left               = 3953770308
  Gp_Qt_Tap_Effort                                = 2222654907
  Gp_Shared_Fakeout                               = 543301532
  Gp_Shared_Humph                                 = 2079303
  Gp_Shared_Lose_Fit_Medium                       = 3218891970
  Gp_Shared_Lose_Fit_Short                        = 876073127
  Gp_Shared_Lose_Growl_Medium                     = 2046364900
  Gp_Shared_Lose_Growl_Short                      = 3207916529
  Gp_Shared_Lose_Growl_Short_01                   = 1671409981
  Gp_Shared_Lose_Level_1                          = 420891483
  Gp_Shared_Lose_Level_2                          = 420891480
  Gp_Shared_Lose_Level_3                          = 420891481
  Gp_Shared_Lose_Look_Up                          = 361519622
  Gp_Shared_Lose_Look_Up_Surprised                = 2413162080
  Gp_Shared_Lose_Surprised_Short                  = 291687249
  Gp_Shared_Lose_Throw_Cube                       = 247758371
  Gp_Shared_Win_Chachacha                         = 2184979880
  Gp_Shared_Win_Dance_Hum_1                       = 1324616160
  Gp_Shared_Win_Laugh                             = 2763212437
  Gp_Shared_Win_Level_1                           = 430910432
  Gp_Shared_Win_Level_2                           = 430910435
  Gp_Shared_Win_Level_3                           = 430910434
  Gp_Shared_Win_Medium                            = 3810035423
  Gp_Shared_Win_Short                             = 943980464
  Gp_Shared_Win_Wow_Short                         = 771576844
  Gp_Simon_Fail_Hand_P1                           = 3500835092
  Gp_Simon_Fail_Hand_P2                           = 3500835095
  Gp_Simon_Fail_Hand_P3                           = 3500835094
  Gp_Simon_Success_Hand_Cozmo_P3                  = 3632781140
  Gp_Simon_Success_Hand_Player_P1                 = 1088973227
  Gp_Simon_Success_Hand_Player_P2                 = 1088973224
  Gp_Simon_Success_Hand_Player_P3                 = 1088973225
  Hiking_Hum_Happy                                = 1163200773
  Hiking_Hum_Happy_Short                          = 3113369638
  Invalid                                         = 0
  Meet_Cozmo_Got_It                               = 4040383078
  Meet_Cozmo_Thinking                             = 1307500180
  Onboarding_Cube_Lift_First                      = 1219220413
  Onboarding_Cube_Lifted_React                    = 1564490581
  Onboarding_Cube_Lifted_React_Taka               = 3320332885
  Onboarding_Cube_Lifted_React_Whoa               = 124760265
  Onboarding_Cube_Lifted_React_Woohoo             = 2259447157
  Onboarding_Cube_Set_Celebrate                   = 1518322125
  Onboarding_Cube_Set_First                       = 2694671152
  Onboarding_Cube_Set_Wow                         = 3560671663
  Onboarding_Curious_Huh                          = 555367759
  Onboarding_Curious_Look_Around                  = 3020031119
  Onboarding_Curious_Look_Up                      = 2784611827
  Onboarding_Eyes_Open                            = 1462474442
  Onboarding_Happy                                = 142998609
  Onboarding_See_Cube_First                       = 3651618653
  Onboarding_See_Face_First                       = 3734844721
  Pet_Detection_Bark                              = 3056349377
  Pet_Detection_Cat_Meow                          = 629947316
  Pet_Detection_Growl                             = 2361443718
  Pet_Detection_Howl                              = 1083767857
  Pet_Detection_Roar                              = 4176723711
  Pet_Detection_Roar_End                          = 4112591521
  Pet_Detection_Sneeze                            = 501972637
  Pet_Detection_Sneeze_Build                      = 3938249640
  Pet_Detection_Sneeze_Shake                      = 593425994
  Placeholder                                     = 668634652
  React_3_Cube_Topple_P1                          = 3537517197
  React_3_Cube_Topple_P2                          = 3537517198
  React_Cliff                                     = 3202816225
  React_Cliff_Neutral                             = 2157786177
  React_Cliff_Nope                                = 2919996492
  React_Cliff_Wow                                 = 4237662181
  React_Cube_Reach_Struggle                       = 885432736
  React_Face_Dislike                              = 982507682
  React_Face_Like                                 = 3280935088
  React_Face_Suspicious                           = 3698170420
  React_Face_Wiggle                               = 3090287958
  React_Pickup                                    = 2638083869
  React_Pickup_Angry_P1                           = 703918427
  React_Pickup_Angry_P2                           = 703918424
  React_See_Cube_First                            = 3238039505
  React_Stuck_Angry_P1                            = 1511466269
  React_Stuck_Angry_P2                            = 1511466270
  React_Stuck_Turtle_Roll_Fail_P1                 = 3446648261
  React_Stuck_Turtle_Roll_Fail_P2                 = 3446648262
  React_Stuck_Turtle_Roll_Fail_P3                 = 3446648263
  React_Stuck_Turtle_Roll_Fail_P4                 = 3446648256
  React_Stuck_Turtle_Struggle                     = 3969487586
  React_Wheely_Spin                               = 1957283066
  Shared_Align_Frustrated_Loop_Play               = 768645691
  Shared_Align_Grunt                              = 254819395
  Shared_Align_Happy_Loop_Play                    = 3811848393
  Shared_Align_Loop_Play                          = 4026047306
  Shared_Angry_Long                               = 3990793429
  Shared_Angry_Loop_Play                          = 1864639974
  Shared_Angry_Loop_Stop                          = 4168951898
  Shared_Angry_Short                              = 622779059
  Shared_Awe                                      = 4199618846
  Shared_Bored_Look_Side                          = 751598833
  Shared_Bored_Look_Up                            = 2589648919
  Shared_Bored_Sigh_Long                          = 412109486
  Shared_Bored_Sigh_Short                         = 2741090610
  Shared_Celebrate_Spin                           = 2159643843
  Shared_Curious                                  = 3556785413
  Shared_Curious_Long                             = 2068109610
  Shared_Curious_Mutter                           = 2721235403
  Shared_Curious_Short                            = 4047754278
  Shared_Disappointed_Short                       = 327662522
  Shared_Effort_Lift                              = 3824979789
  Shared_Effort_Lift_Heavy                        = 3398455981
  Shared_Effort_Pounce                            = 3727241044
  Shared_Effort_Pounce_Heavy                      = 738969844
  Shared_Effort_Set                               = 1467890010
  Shared_Effort_Set_Heavy                         = 606158106
  Shared_Effort_Short                             = 3200991712
  Shared_Excited                                  = 2884456673
  Shared_Excited_Loop_Play                        = 2679819871
  Shared_Excited_Loop_Stop                        = 1864261839
  Shared_Fall_Asleep                              = 3524061431
  Shared_Fall_Cliff_Scream                        = 3144703383
  Shared_Frustrated_Low                           = 1701937252
  Shared_Fussy                                    = 3400453885
  Shared_Fussy_Loop_Play                          = 756640443
  Shared_Fussy_Loop_Stop                          = 3912485995
  Shared_Fussy_Short                              = 297407534
  Shared_Giggle_Happy_Loop_Play                   = 1488458019
  Shared_Giggle_Happy_Loop_Stop                   = 3962033227
  Shared_Giggle_Mischief                          = 855062857
  Shared_Giggle_Short                             = 3928693597
  Shared_Happy                                    = 3531557633
  Shared_Happy_Long                               = 174359366
  Shared_Happy_Loop_Play                          = 3025145855
  Shared_Happy_Loop_Stop                          = 4286366971
  Shared_Happy_Short                              = 1066816362
  Shared_Idea                                     = 2993967144
  Shared_Idea_Loop_Play                           = 1684239554
  Shared_Idea_Loop_Stop                           = 273762158
  Shared_Idea_Short                               = 1143549143
  Shared_Inhale                                   = 237432456
  Shared_Interested                               = 1609212516
  Shared_Interested_Long                          = 3957181661
  Shared_Pain                                     = 3089977461
  Shared_Pounce_Charge                            = 4216929694
  Shared_Pounce_Fail                              = 4228327806
  Shared_Raspberry                                = 717035989
  Shared_React_Face                               = 60844582
  Shared_React_Face_1                             = 581777606
  Shared_React_Face_2                             = 581777605
  Shared_React_Face_3                             = 581777604
  Shared_React_Face_4                             = 581777603
  Shared_Sad                                      = 69470719
  Shared_Sad_Long                                 = 2147481440
  Shared_Snobby                                   = 2457314414
  Shared_Snore                                    = 654990394
  Shared_Snore_Fade_Out                           = 3606041598
  Shared_Snore_Short                              = 2130053793
  Shared_Squint                                   = 2057205297
  Shared_Struggle                                 = 2593492856
  Shared_Surprised                                = 2054953516
  Shared_Surprised_Short                          = 1145334899
  Shared_Suspicious                               = 844374444
  Shared_Suspicious_Short                         = 35665907
  Shared_Take_Damage_Light                        = 3078492749
  Shared_Take_Damage_Medium                       = 913083578
  Shared_Thinking_Short                           = 3456819050
  Shared_Upgrade_Curious                          = 2081938528
  Shared_Upgrade_Impressed                        = 1733627270
  Shared_Upgrade_Surprised                        = 954550705
  Shared_Wake_Up_1                                = 67470331
  Shared_Wake_Up_2                                = 67470328
  Shared_Wake_Up_3                                = 67470329
  Shared_Wake_Up_4                                = 67470334
  Shared_Wake_Up_P1                               = 246308351
  Shared_Wake_Up_P2                               = 246308348
  Shared_Wake_Up_Snort                            = 781027234
  Shared_Wakeup                                   = 2412938906
  Sparked_Driving                                 = 3606845375
  Sparked_Driving_Look                            = 2670470879
  Sparked_Driving_Start                           = 1233493330
  Sparked_Fail                                    = 2861844754
  Sparked_Out                                     = 2452343422
  Sparked_Pyramid_Complete                        = 1438874844
  Sparked_Ready_To_Go                             = 4268262662
  Sparked_Succeed                                 = 4231360462
  Sparked_Succeed_Tada                            = 2693760973
  Sparked_Surprise                                = 3822640315
  Sparked_Workout_Break_Lift_Pain                 = 492094136
  Sparked_Workout_Break_Lift_Startled             = 1138165379
  Sparked_Workout_Break_Lift_Struggle             = 9918389
  Sparked_Workout_Lift_Fail                       = 1101180372
  Sparked_Workout_Lift_Fail_Struggle              = 835476802
  Sparked_Workout_Lift_Fail_Struggle_Long         = 1462283623
  Sparked_Workout_Lift_Fail_Struggle_Longest      = 2885068477
  Sparked_Workout_Lift_Fail_Struggle_Longest_Stop = 1084850966
  Sparked_Workout_Lift_Fail_Tired                 = 3312564867
  Sparked_Workout_Lift_Success_Showoff            = 2247677502
  Sparked_Workout_Lift_Success_Strong             = 1844409553
  Sparked_Workout_Lift_Success_Throw_Block        = 3296787010
  Sparked_Workout_Lift_Success_Weak               = 2216609612
  Word_Cat                                        = 743962600
  Word_Cube_Excited                               = 1262712072
  Word_Cube_Happy                                 = 1400293052
  Word_Cube_Neutral                               = 740915407
  Word_Cube_Request                               = 3660085349
  Word_Cube_Sad                                   = 3995541618
  Word_Dog                                        = 843495306
  Word_Keepaway_Excited                           = 3097808214
  Word_Keepaway_Request                           = 3460255911
  Word_Keepaway_Sad                               = 2098273712
  Word_Memory_Match_Happy                         = 2694835404
  Word_Memory_Match_Request                       = 4090420021
  Word_Memory_Match_Sad                           = 1881407426
  Word_Quick_Tap                                  = 444948971
  Word_Speedtap_Excited                           = 2751243663
  Word_Speedtap_Request                           = 919083726

Anki.Cozmo.Audio.GameEvent.Robot_Vo = Robot_Vo
del Robot_Vo


class Sfx(object):
  "Automatically-generated uint_32 enumeration."
  Banner_Wipe                     = 3247701492
  Code_Fragment_Collected         = 2587766166
  Code_Fragment_Released          = 1918333736
  Daily_Goal                      = 3010549659
  Daily_Reward_Calendar_Disappear = 2897417442
  Daily_Reward_Collect            = 878067460
  Daily_Reward_Disappear          = 2538266513
  Daily_Reward_Goal_Collect       = 2962215520
  Daily_Reward_Open               = 1796529350
  Daily_Reward_Status             = 2202351196
  Emotion_Chip_Charged_Start      = 2709491700
  Emotion_Chip_Charged_Tap        = 53415191
  Game_End                        = 3871304392
  Game_Start                      = 126137843
  Gp_Explorer_Night_Vision_Off    = 132505315
  Gp_Explorer_Night_Vision_On     = 4183101071
  Gp_Mm_Light_Blue                = 944508478
  Gp_Mm_Light_Red                 = 153648099
  Gp_Mm_Light_Yellow              = 771679342
  Gp_Mm_Pattern_Start             = 2601428284
  Gp_Shared_Block_Connect         = 3790068130
  Gp_Shared_Game_End              = 2218318430
  Gp_Shared_Request_Game          = 1936634046
  Gp_Shared_Round_End             = 3799430148
  Gp_St_Cube_Cozmo_Tap            = 2843679148
  Gp_St_Lightup                   = 231361703
  Gp_St_Lose                      = 4278097031
  Gp_St_Tap_Red                   = 600994811
  Gp_St_Win                       = 2704467806
  Invalid                         = 0
  Onboarding_Test_Tone            = 1823946677
  Placeholder                     = 3278074531
  Relationship_Gain               = 1770649520
  Relationship_Gain_Collect       = 447401587
  Spark_Launch                    = 38276463
  Spark_Success                   = 3587224415

Anki.Cozmo.Audio.GameEvent.Sfx = Sfx
del Sfx


class Ui(object):
  "Automatically-generated uint_32 enumeration."
  Attention_Device             = 796149778
  Click_Back                   = 3218349115
  Click_General                = 902542
  Cozmo_Connect                = 647774144
  Cozmo_Connect_Fail           = 1743202231
  Cozmo_Connect_Scan_Loop      = 1356238993
  Cozmo_Connect_Scan_Loop_Stop = 698059508
  Cozmo_Disconnect             = 2439191052
  Cozmo_Upgrade                = 1233383102
  Invalid                      = 0
  Placeholder                  = 1840201236
  Window_Close                 = 974187556
  Window_Open                  = 1763539616
  Window_Vertical_Wipe         = 931790836

Anki.Cozmo.Audio.GameEvent.Ui = Ui
del Ui


