# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/audioMessage.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/audioMessage.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameParameter = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameState = msgbuffers.Namespace()
Anki.Cozmo.Audio.SwitchState = msgbuffers.Namespace()

from clad.audio.audioEventTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioGameObjectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioMessageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioParameterTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioStateTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioSwitchTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class PostAudioEvent(object):
  "Generated message-passing message."

  __slots__ = (
    '_audioEvent', # Anki.Cozmo.Audio.GameEvent.GenericEvent
    '_gameObject', # Anki.Cozmo.Audio.GameObjectType
    '_callbackId', # uint_16
  )

  @property
  def audioEvent(self):
    "Anki.Cozmo.Audio.GameEvent.GenericEvent audioEvent struct property."
    return self._audioEvent

  @audioEvent.setter
  def audioEvent(self, value):
    self._audioEvent = msgbuffers.validate_integer(
      'PostAudioEvent.audioEvent', value, 0, 4294967295)

  @property
  def gameObject(self):
    "Anki.Cozmo.Audio.GameObjectType gameObject struct property."
    return self._gameObject

  @gameObject.setter
  def gameObject(self, value):
    self._gameObject = msgbuffers.validate_integer(
      'PostAudioEvent.gameObject', value, 0, 4294967295)

  @property
  def callbackId(self):
    "uint_16 callbackId struct property."
    return self._callbackId

  @callbackId.setter
  def callbackId(self, value):
    self._callbackId = msgbuffers.validate_integer(
      'PostAudioEvent.callbackId', value, 0, 65535)

  def __init__(self, audioEvent=Anki.Cozmo.Audio.GameEvent.GenericEvent.Invalid, gameObject=Anki.Cozmo.Audio.GameObjectType.Invalid, callbackId=0):
    self.audioEvent = audioEvent
    self.gameObject = gameObject
    self.callbackId = callbackId

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PostAudioEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PostAudioEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PostAudioEvent from the given BinaryReader."
    _audioEvent = reader.read('I')
    _gameObject = reader.read('I')
    _callbackId = reader.read('H')
    return cls(_audioEvent, _gameObject, _callbackId)

  def pack(self):
    "Writes the current PostAudioEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PostAudioEvent to the given BinaryWriter."
    writer.write(self._audioEvent, 'I')
    writer.write(self._gameObject, 'I')
    writer.write(self._callbackId, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._audioEvent == other._audioEvent and
        self._gameObject == other._gameObject and
        self._callbackId == other._callbackId)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._audioEvent, 'I') +
      msgbuffers.size(self._gameObject, 'I') +
      msgbuffers.size(self._callbackId, 'H'))

  def __str__(self):
    return '{type}(audioEvent={audioEvent}, gameObject={gameObject}, callbackId={callbackId})'.format(
      type=type(self).__name__,
      audioEvent=self._audioEvent,
      gameObject=self._gameObject,
      callbackId=self._callbackId)

  def __repr__(self):
    return '{type}(audioEvent={audioEvent}, gameObject={gameObject}, callbackId={callbackId})'.format(
      type=type(self).__name__,
      audioEvent=repr(self._audioEvent),
      gameObject=repr(self._gameObject),
      callbackId=repr(self._callbackId))

Anki.Cozmo.Audio.PostAudioEvent = PostAudioEvent
del PostAudioEvent


class StopAllAudioEvents(object):
  "Generated message-passing message."

  __slots__ = (
    '_gameObject', # Anki.Cozmo.Audio.GameObjectType
  )

  @property
  def gameObject(self):
    "Anki.Cozmo.Audio.GameObjectType gameObject struct property."
    return self._gameObject

  @gameObject.setter
  def gameObject(self, value):
    self._gameObject = msgbuffers.validate_integer(
      'StopAllAudioEvents.gameObject', value, 0, 4294967295)

  def __init__(self, gameObject=Anki.Cozmo.Audio.GameObjectType.Invalid):
    self.gameObject = gameObject

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StopAllAudioEvents from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StopAllAudioEvents.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StopAllAudioEvents from the given BinaryReader."
    _gameObject = reader.read('I')
    return cls(_gameObject)

  def pack(self):
    "Writes the current StopAllAudioEvents, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StopAllAudioEvents to the given BinaryWriter."
    writer.write(self._gameObject, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._gameObject == other._gameObject
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._gameObject, 'I'))

  def __str__(self):
    return '{type}(gameObject={gameObject})'.format(
      type=type(self).__name__,
      gameObject=self._gameObject)

  def __repr__(self):
    return '{type}(gameObject={gameObject})'.format(
      type=type(self).__name__,
      gameObject=repr(self._gameObject))

Anki.Cozmo.Audio.StopAllAudioEvents = StopAllAudioEvents
del StopAllAudioEvents


class PostAudioGameState(object):
  "Generated message-passing message."

  __slots__ = (
    '_stateGroup', # Anki.Cozmo.Audio.GameState.StateGroupType
    '_stateValue', # Anki.Cozmo.Audio.GameState.GenericState
  )

  @property
  def stateGroup(self):
    "Anki.Cozmo.Audio.GameState.StateGroupType stateGroup struct property."
    return self._stateGroup

  @stateGroup.setter
  def stateGroup(self, value):
    self._stateGroup = msgbuffers.validate_integer(
      'PostAudioGameState.stateGroup', value, 0, 4294967295)

  @property
  def stateValue(self):
    "Anki.Cozmo.Audio.GameState.GenericState stateValue struct property."
    return self._stateValue

  @stateValue.setter
  def stateValue(self, value):
    self._stateValue = msgbuffers.validate_integer(
      'PostAudioGameState.stateValue', value, 0, 4294967295)

  def __init__(self, stateGroup=Anki.Cozmo.Audio.GameState.StateGroupType.External_Name, stateValue=Anki.Cozmo.Audio.GameState.GenericState.Invalid):
    self.stateGroup = stateGroup
    self.stateValue = stateValue

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PostAudioGameState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PostAudioGameState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PostAudioGameState from the given BinaryReader."
    _stateGroup = reader.read('I')
    _stateValue = reader.read('I')
    return cls(_stateGroup, _stateValue)

  def pack(self):
    "Writes the current PostAudioGameState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PostAudioGameState to the given BinaryWriter."
    writer.write(self._stateGroup, 'I')
    writer.write(self._stateValue, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._stateGroup == other._stateGroup and
        self._stateValue == other._stateValue)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._stateGroup, 'I') +
      msgbuffers.size(self._stateValue, 'I'))

  def __str__(self):
    return '{type}(stateGroup={stateGroup}, stateValue={stateValue})'.format(
      type=type(self).__name__,
      stateGroup=self._stateGroup,
      stateValue=self._stateValue)

  def __repr__(self):
    return '{type}(stateGroup={stateGroup}, stateValue={stateValue})'.format(
      type=type(self).__name__,
      stateGroup=repr(self._stateGroup),
      stateValue=repr(self._stateValue))

Anki.Cozmo.Audio.PostAudioGameState = PostAudioGameState
del PostAudioGameState


class PostAudioSwitchState(object):
  "Generated message-passing message."

  __slots__ = (
    '_switchStateGroup', # Anki.Cozmo.Audio.SwitchState.SwitchGroupType
    '_switchStateValue', # Anki.Cozmo.Audio.SwitchState.GenericSwitch
    '_gameObject',       # Anki.Cozmo.Audio.GameObjectType
  )

  @property
  def switchStateGroup(self):
    "Anki.Cozmo.Audio.SwitchState.SwitchGroupType switchStateGroup struct property."
    return self._switchStateGroup

  @switchStateGroup.setter
  def switchStateGroup(self, value):
    self._switchStateGroup = msgbuffers.validate_integer(
      'PostAudioSwitchState.switchStateGroup', value, 0, 4294967295)

  @property
  def switchStateValue(self):
    "Anki.Cozmo.Audio.SwitchState.GenericSwitch switchStateValue struct property."
    return self._switchStateValue

  @switchStateValue.setter
  def switchStateValue(self, value):
    self._switchStateValue = msgbuffers.validate_integer(
      'PostAudioSwitchState.switchStateValue', value, 0, 4294967295)

  @property
  def gameObject(self):
    "Anki.Cozmo.Audio.GameObjectType gameObject struct property."
    return self._gameObject

  @gameObject.setter
  def gameObject(self, value):
    self._gameObject = msgbuffers.validate_integer(
      'PostAudioSwitchState.gameObject', value, 0, 4294967295)

  def __init__(self, switchStateGroup=Anki.Cozmo.Audio.SwitchState.SwitchGroupType.Cozmo_Voice_Processing, switchStateValue=Anki.Cozmo.Audio.SwitchState.GenericSwitch.Invalid, gameObject=Anki.Cozmo.Audio.GameObjectType.Invalid):
    self.switchStateGroup = switchStateGroup
    self.switchStateValue = switchStateValue
    self.gameObject = gameObject

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PostAudioSwitchState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PostAudioSwitchState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PostAudioSwitchState from the given BinaryReader."
    _switchStateGroup = reader.read('I')
    _switchStateValue = reader.read('I')
    _gameObject = reader.read('I')
    return cls(_switchStateGroup, _switchStateValue, _gameObject)

  def pack(self):
    "Writes the current PostAudioSwitchState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PostAudioSwitchState to the given BinaryWriter."
    writer.write(self._switchStateGroup, 'I')
    writer.write(self._switchStateValue, 'I')
    writer.write(self._gameObject, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._switchStateGroup == other._switchStateGroup and
        self._switchStateValue == other._switchStateValue and
        self._gameObject == other._gameObject)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._switchStateGroup, 'I') +
      msgbuffers.size(self._switchStateValue, 'I') +
      msgbuffers.size(self._gameObject, 'I'))

  def __str__(self):
    return '{type}(switchStateGroup={switchStateGroup}, switchStateValue={switchStateValue}, gameObject={gameObject})'.format(
      type=type(self).__name__,
      switchStateGroup=self._switchStateGroup,
      switchStateValue=self._switchStateValue,
      gameObject=self._gameObject)

  def __repr__(self):
    return '{type}(switchStateGroup={switchStateGroup}, switchStateValue={switchStateValue}, gameObject={gameObject})'.format(
      type=type(self).__name__,
      switchStateGroup=repr(self._switchStateGroup),
      switchStateValue=repr(self._switchStateValue),
      gameObject=repr(self._gameObject))

Anki.Cozmo.Audio.PostAudioSwitchState = PostAudioSwitchState
del PostAudioSwitchState


class PostAudioParameter(object):
  "Generated message-passing message."

  __slots__ = (
    '_parameter',          # Anki.Cozmo.Audio.GameParameter.ParameterType
    '_parameterValue',     # float_32
    '_gameObject',         # Anki.Cozmo.Audio.GameObjectType
    '_timeInMilliSeconds', # int_32
    '_curve',              # Anki.Cozmo.Audio.CurveType
  )

  @property
  def parameter(self):
    "Anki.Cozmo.Audio.GameParameter.ParameterType parameter struct property."
    return self._parameter

  @parameter.setter
  def parameter(self, value):
    self._parameter = msgbuffers.validate_integer(
      'PostAudioParameter.parameter', value, 0, 4294967295)

  @property
  def parameterValue(self):
    "float_32 parameterValue struct property."
    return self._parameterValue

  @parameterValue.setter
  def parameterValue(self, value):
    self._parameterValue = msgbuffers.validate_float(
      'PostAudioParameter.parameterValue', value, 'f')

  @property
  def gameObject(self):
    "Anki.Cozmo.Audio.GameObjectType gameObject struct property."
    return self._gameObject

  @gameObject.setter
  def gameObject(self, value):
    self._gameObject = msgbuffers.validate_integer(
      'PostAudioParameter.gameObject', value, 0, 4294967295)

  @property
  def timeInMilliSeconds(self):
    "int_32 timeInMilliSeconds struct property."
    return self._timeInMilliSeconds

  @timeInMilliSeconds.setter
  def timeInMilliSeconds(self, value):
    self._timeInMilliSeconds = msgbuffers.validate_integer(
      'PostAudioParameter.timeInMilliSeconds', value, -2147483648, 2147483647)

  @property
  def curve(self):
    "Anki.Cozmo.Audio.CurveType curve struct property."
    return self._curve

  @curve.setter
  def curve(self, value):
    self._curve = msgbuffers.validate_integer(
      'PostAudioParameter.curve', value, 0, 255)

  def __init__(self, parameter=Anki.Cozmo.Audio.GameParameter.ParameterType.Dev_Tone_Freq, parameterValue=0.0, gameObject=Anki.Cozmo.Audio.GameObjectType.Invalid, timeInMilliSeconds=0, curve=Anki.Cozmo.Audio.CurveType.Linear):
    self.parameter = parameter
    self.parameterValue = parameterValue
    self.gameObject = gameObject
    self.timeInMilliSeconds = timeInMilliSeconds
    self.curve = curve

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PostAudioParameter from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PostAudioParameter.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PostAudioParameter from the given BinaryReader."
    _parameter = reader.read('I')
    _parameterValue = reader.read('f')
    _gameObject = reader.read('I')
    _timeInMilliSeconds = reader.read('i')
    _curve = reader.read('B')
    return cls(_parameter, _parameterValue, _gameObject, _timeInMilliSeconds, _curve)

  def pack(self):
    "Writes the current PostAudioParameter, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PostAudioParameter to the given BinaryWriter."
    writer.write(self._parameter, 'I')
    writer.write(self._parameterValue, 'f')
    writer.write(self._gameObject, 'I')
    writer.write(self._timeInMilliSeconds, 'i')
    writer.write(self._curve, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._parameter == other._parameter and
        self._parameterValue == other._parameterValue and
        self._gameObject == other._gameObject and
        self._timeInMilliSeconds == other._timeInMilliSeconds and
        self._curve == other._curve)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._parameter, 'I') +
      msgbuffers.size(self._parameterValue, 'f') +
      msgbuffers.size(self._gameObject, 'I') +
      msgbuffers.size(self._timeInMilliSeconds, 'i') +
      msgbuffers.size(self._curve, 'B'))

  def __str__(self):
    return '{type}(parameter={parameter}, parameterValue={parameterValue}, gameObject={gameObject}, timeInMilliSeconds={timeInMilliSeconds}, curve={curve})'.format(
      type=type(self).__name__,
      parameter=self._parameter,
      parameterValue=self._parameterValue,
      gameObject=self._gameObject,
      timeInMilliSeconds=self._timeInMilliSeconds,
      curve=self._curve)

  def __repr__(self):
    return '{type}(parameter={parameter}, parameterValue={parameterValue}, gameObject={gameObject}, timeInMilliSeconds={timeInMilliSeconds}, curve={curve})'.format(
      type=type(self).__name__,
      parameter=repr(self._parameter),
      parameterValue=repr(self._parameterValue),
      gameObject=repr(self._gameObject),
      timeInMilliSeconds=repr(self._timeInMilliSeconds),
      curve=repr(self._curve))

Anki.Cozmo.Audio.PostAudioParameter = PostAudioParameter
del PostAudioParameter


class PostAudioMusicState(object):
  "Generated message-passing message."

  __slots__ = (
    '_stateValue',                # Anki.Cozmo.Audio.GameState.GenericState
    '_interrupt',                 # bool
    '_minDurationInMilliSeconds', # uint_32
  )

  @property
  def stateValue(self):
    "Anki.Cozmo.Audio.GameState.GenericState stateValue struct property."
    return self._stateValue

  @stateValue.setter
  def stateValue(self, value):
    self._stateValue = msgbuffers.validate_integer(
      'PostAudioMusicState.stateValue', value, 0, 4294967295)

  @property
  def interrupt(self):
    "bool interrupt struct property."
    return self._interrupt

  @interrupt.setter
  def interrupt(self, value):
    self._interrupt = msgbuffers.validate_bool(
      'PostAudioMusicState.interrupt', value)

  @property
  def minDurationInMilliSeconds(self):
    "uint_32 minDurationInMilliSeconds struct property."
    return self._minDurationInMilliSeconds

  @minDurationInMilliSeconds.setter
  def minDurationInMilliSeconds(self, value):
    self._minDurationInMilliSeconds = msgbuffers.validate_integer(
      'PostAudioMusicState.minDurationInMilliSeconds', value, 0, 4294967295)

  def __init__(self, stateValue=Anki.Cozmo.Audio.GameState.GenericState.Invalid, interrupt=False, minDurationInMilliSeconds=0):
    self.stateValue = stateValue
    self.interrupt = interrupt
    self.minDurationInMilliSeconds = minDurationInMilliSeconds

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PostAudioMusicState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PostAudioMusicState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PostAudioMusicState from the given BinaryReader."
    _stateValue = reader.read('I')
    _interrupt = bool(reader.read('b'))
    _minDurationInMilliSeconds = reader.read('I')
    return cls(_stateValue, _interrupt, _minDurationInMilliSeconds)

  def pack(self):
    "Writes the current PostAudioMusicState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PostAudioMusicState to the given BinaryWriter."
    writer.write(self._stateValue, 'I')
    writer.write(int(self._interrupt), 'b')
    writer.write(self._minDurationInMilliSeconds, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._stateValue == other._stateValue and
        self._interrupt == other._interrupt and
        self._minDurationInMilliSeconds == other._minDurationInMilliSeconds)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._stateValue, 'I') +
      msgbuffers.size(self._interrupt, 'b') +
      msgbuffers.size(self._minDurationInMilliSeconds, 'I'))

  def __str__(self):
    return '{type}(stateValue={stateValue}, interrupt={interrupt}, minDurationInMilliSeconds={minDurationInMilliSeconds})'.format(
      type=type(self).__name__,
      stateValue=self._stateValue,
      interrupt=self._interrupt,
      minDurationInMilliSeconds=self._minDurationInMilliSeconds)

  def __repr__(self):
    return '{type}(stateValue={stateValue}, interrupt={interrupt}, minDurationInMilliSeconds={minDurationInMilliSeconds})'.format(
      type=type(self).__name__,
      stateValue=repr(self._stateValue),
      interrupt=repr(self._interrupt),
      minDurationInMilliSeconds=repr(self._minDurationInMilliSeconds))

Anki.Cozmo.Audio.PostAudioMusicState = PostAudioMusicState
del PostAudioMusicState


