# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/audioParameterTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/audioParameterTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameParameter = msgbuffers.Namespace()

class ParameterType(object):
  "Automatically-generated uint_32 enumeration."
  Dev_Tone_Freq          = 2324555758
  Event_Volume           = 3530059848
  External_Name_Duration = 2145805753
  External_Process_Pitch = 2027863301
  Invalid                = 0
  Mood                   = 3128647864
  Music_Mood             = 1579946944
  Music_Volume           = 1006694123
  Mvt_Speed              = 3464961452
  Relationship           = 3723222599
  Robot_Volume           = 1669075520
  Sfx_Charge             = 3433595557
  Sfx_Volume             = 1564184899
  Ss_Air_Fear            = 1351367891
  Ss_Air_Freefall        = 3002758120
  Ss_Air_Fury            = 1029930033
  Ss_Air_Month           = 2648548617
  Ss_Air_Presence        = 3847924954
  Ss_Air_Rpm             = 822163944
  Ss_Air_Size            = 3074696722
  Ss_Air_Storm           = 3715662592
  Ss_Air_Timeofday       = 3203397129
  Ss_Air_Turbulence      = 4160247818
  Ui_Volume              = 1719345792
  Vo_Volume              = 2295491857

Anki.Cozmo.Audio.GameParameter.ParameterType = ParameterType
del ParameterType


