# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/audioSwitchTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/audioSwitchTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.SwitchState = msgbuffers.Namespace()

class Cozmo_Voice_Processing(object):
  "Automatically-generated uint_32 enumeration."
  Invalid     = 0
  Name        = 797654004
  Sentence    = 906532866
  Unprocessed = 860658140

Anki.Cozmo.Audio.SwitchState.Cozmo_Voice_Processing = Cozmo_Voice_Processing
del Cozmo_Voice_Processing


class External(object):
  "Automatically-generated uint_32 enumeration."
  External_Long    = 3001056757
  External_Maximum = 1931150551
  External_Medium  = 3619992510
  External_Short   = 1727626579
  Invalid          = 0

Anki.Cozmo.Audio.SwitchState.External = External
del External


class Freeplay_Mood(object):
  "Automatically-generated uint_32 enumeration."
  Bored        = 2890913445
  Busy         = 1427625958
  Chill        = 4294400669
  Cubeinteract = 889740396
  Frustrated   = 1309079467
  Happy        = 1427264549
  Hiking       = 296159617
  Invalid      = 0
  Neutral      = 670611050
  Sleep        = 3671647190

Anki.Cozmo.Audio.SwitchState.Freeplay_Mood = Freeplay_Mood
del Freeplay_Mood


class Gameplay_Round(object):
  "Automatically-generated uint_32 enumeration."
  Invalid  = 0
  Round_00 = 4039654994
  Round_01 = 4039654995
  Round_02 = 4039654992
  Round_03 = 4039654993
  Round_04 = 4039654998
  Round_05 = 4039654999
  Round_06 = 4039654996
  Round_07 = 4039654997
  Round_08 = 4039655002
  Round_09 = 4039655003
  Round_10 = 4056432581

Anki.Cozmo.Audio.SwitchState.Gameplay_Round = Gameplay_Round
del Gameplay_Round


class GenericSwitch(object):
  "Automatically-generated uint_32 enumeration."
  Invalid = 0

Anki.Cozmo.Audio.SwitchState.GenericSwitch = GenericSwitch
del GenericSwitch


class Mood(object):
  "Automatically-generated uint_32 enumeration."
  Invalid      = 0
  Mood_Happy   = 457607035
  Mood_Neutral = 3970296952
  Mood_Sad     = 777739821

Anki.Cozmo.Audio.SwitchState.Mood = Mood
del Mood


class Relationship(object):
  "Automatically-generated uint_32 enumeration."
  Invalid               = 0
  Realtionship_Bff      = 743952678
  Realtionship_Friend   = 1061927592
  Relationship_Stranger = 3087192196

Anki.Cozmo.Audio.SwitchState.Relationship = Relationship
del Relationship


class Sparked(object):
  "Automatically-generated uint_32 enumeration."
  Fun     = 982472036
  Invalid = 0
  Pyramid = 797712787
  Sneaky  = 468648200
  Workout = 1875882538

Anki.Cozmo.Audio.SwitchState.Sparked = Sparked
del Sparked


class SwitchGroupType(object):
  "Automatically-generated uint_32 enumeration."
  Cozmo_Voice_Processing = 366280094
  External               = 1442075084
  Freeplay_Mood          = 2205807877
  Gameplay_Round         = 2536359484
  Invalid                = 0
  Mood                   = 3128647864
  Relationship           = 3723222599
  Sparked                = 62349551

Anki.Cozmo.Audio.SwitchState.SwitchGroupType = SwitchGroupType
del SwitchGroupType


