# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/audio/messageAudioClient.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/audio/messageAudioClient.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameParameter = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameState = msgbuffers.Namespace()
Anki.Cozmo.Audio.SwitchState = msgbuffers.Namespace()

from clad.audio.audioCallbackMessage import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.audio.audioMessage import Anki as _Anki
Anki.update(_Anki.deep_clone())

class MessageAudioClient(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    PostAudioEvent       = 0 # Anki.Cozmo.Audio.PostAudioEvent
    StopAllAudioEvents   = 1 # Anki.Cozmo.Audio.StopAllAudioEvents
    PostAudioGameState   = 2 # Anki.Cozmo.Audio.PostAudioGameState
    PostAudioSwitchState = 3 # Anki.Cozmo.Audio.PostAudioSwitchState
    PostAudioParameter   = 4 # Anki.Cozmo.Audio.PostAudioParameter
    PostAudioMusicState  = 5 # Anki.Cozmo.Audio.PostAudioMusicState
    AudioCallback        = 6 # Anki.Cozmo.Audio.AudioCallback

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def PostAudioEvent(self):
    "Anki.Cozmo.Audio.PostAudioEvent PostAudioEvent union property."
    msgbuffers.safety_check_tag('PostAudioEvent', self._tag, self.Tag.PostAudioEvent, self._tags_by_value)
    return self._data

  @PostAudioEvent.setter
  def PostAudioEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.PostAudioEvent', value, Anki.Cozmo.Audio.PostAudioEvent)
    self._tag = self.Tag.PostAudioEvent

  @property
  def StopAllAudioEvents(self):
    "Anki.Cozmo.Audio.StopAllAudioEvents StopAllAudioEvents union property."
    msgbuffers.safety_check_tag('StopAllAudioEvents', self._tag, self.Tag.StopAllAudioEvents, self._tags_by_value)
    return self._data

  @StopAllAudioEvents.setter
  def StopAllAudioEvents(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.StopAllAudioEvents', value, Anki.Cozmo.Audio.StopAllAudioEvents)
    self._tag = self.Tag.StopAllAudioEvents

  @property
  def PostAudioGameState(self):
    "Anki.Cozmo.Audio.PostAudioGameState PostAudioGameState union property."
    msgbuffers.safety_check_tag('PostAudioGameState', self._tag, self.Tag.PostAudioGameState, self._tags_by_value)
    return self._data

  @PostAudioGameState.setter
  def PostAudioGameState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.PostAudioGameState', value, Anki.Cozmo.Audio.PostAudioGameState)
    self._tag = self.Tag.PostAudioGameState

  @property
  def PostAudioSwitchState(self):
    "Anki.Cozmo.Audio.PostAudioSwitchState PostAudioSwitchState union property."
    msgbuffers.safety_check_tag('PostAudioSwitchState', self._tag, self.Tag.PostAudioSwitchState, self._tags_by_value)
    return self._data

  @PostAudioSwitchState.setter
  def PostAudioSwitchState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.PostAudioSwitchState', value, Anki.Cozmo.Audio.PostAudioSwitchState)
    self._tag = self.Tag.PostAudioSwitchState

  @property
  def PostAudioParameter(self):
    "Anki.Cozmo.Audio.PostAudioParameter PostAudioParameter union property."
    msgbuffers.safety_check_tag('PostAudioParameter', self._tag, self.Tag.PostAudioParameter, self._tags_by_value)
    return self._data

  @PostAudioParameter.setter
  def PostAudioParameter(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.PostAudioParameter', value, Anki.Cozmo.Audio.PostAudioParameter)
    self._tag = self.Tag.PostAudioParameter

  @property
  def PostAudioMusicState(self):
    "Anki.Cozmo.Audio.PostAudioMusicState PostAudioMusicState union property."
    msgbuffers.safety_check_tag('PostAudioMusicState', self._tag, self.Tag.PostAudioMusicState, self._tags_by_value)
    return self._data

  @PostAudioMusicState.setter
  def PostAudioMusicState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.PostAudioMusicState', value, Anki.Cozmo.Audio.PostAudioMusicState)
    self._tag = self.Tag.PostAudioMusicState

  @property
  def AudioCallback(self):
    "Anki.Cozmo.Audio.AudioCallback AudioCallback union property."
    msgbuffers.safety_check_tag('AudioCallback', self._tag, self.Tag.AudioCallback, self._tags_by_value)
    return self._data

  @AudioCallback.setter
  def AudioCallback(self, value):
    self._data = msgbuffers.validate_object(
      'MessageAudioClient.AudioCallback', value, Anki.Cozmo.Audio.AudioCallback)
    self._tag = self.Tag.AudioCallback

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MessageAudioClient from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MessageAudioClient.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MessageAudioClient from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MessageAudioClient attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MessageAudioClient, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MessageAudioClient.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 7:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 7:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 7:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    PostAudioEvent=0,
    StopAllAudioEvents=1,
    PostAudioGameState=2,
    PostAudioSwitchState=3,
    PostAudioParameter=4,
    PostAudioMusicState=5,
    AudioCallback=6,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'PostAudioEvent'
  _tags_by_value[1] = 'StopAllAudioEvents'
  _tags_by_value[2] = 'PostAudioGameState'
  _tags_by_value[3] = 'PostAudioSwitchState'
  _tags_by_value[4] = 'PostAudioParameter'
  _tags_by_value[5] = 'PostAudioMusicState'
  _tags_by_value[6] = 'AudioCallback'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioEvent.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.Audio.StopAllAudioEvents.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioGameState.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioSwitchState.unpack_from)
  _tag_unpack_methods[4] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioParameter.unpack_from)
  _tag_unpack_methods[5] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioMusicState.unpack_from)
  _tag_unpack_methods[6] = lambda reader: reader.read_object(Anki.Cozmo.Audio.AudioCallback.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[4] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[5] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[6] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[4] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[5] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[6] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.Audio.PostAudioEvent
  _type_by_tag_value[1] = lambda : Anki.Cozmo.Audio.StopAllAudioEvents
  _type_by_tag_value[2] = lambda : Anki.Cozmo.Audio.PostAudioGameState
  _type_by_tag_value[3] = lambda : Anki.Cozmo.Audio.PostAudioSwitchState
  _type_by_tag_value[4] = lambda : Anki.Cozmo.Audio.PostAudioParameter
  _type_by_tag_value[5] = lambda : Anki.Cozmo.Audio.PostAudioMusicState
  _type_by_tag_value[6] = lambda : Anki.Cozmo.Audio.AudioCallback
  

Anki.Cozmo.Audio.MessageAudioClient = MessageAudioClient
del MessageAudioClient


