# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/externalInterface/messageActions.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/externalInterface/messageActions.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.ExternalInterface = msgbuffers.Namespace()
Anki.Vision = msgbuffers.Namespace()

from clad.types.actionTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.animationTrigger import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.faceEnrollmentSequences import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.objectFamilies import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.pathMotionProfile import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.petTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.sayTextStyles import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.visionModes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class AlignWithObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',              # int_32
    '_motionProf',            # Anki.Cozmo.PathMotionProfile
    '_distanceFromMarker_mm', # float_32
    '_approachAngle_rad',     # float_32
    '_useApproachAngle',      # bool
    '_usePreDockPose',        # bool
    '_useManualSpeed',        # bool
    '_alignmentType',         # Anki.Cozmo.AlignmentType
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'AlignWithObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'AlignWithObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def distanceFromMarker_mm(self):
    "float_32 distanceFromMarker_mm struct property."
    return self._distanceFromMarker_mm

  @distanceFromMarker_mm.setter
  def distanceFromMarker_mm(self, value):
    self._distanceFromMarker_mm = msgbuffers.validate_float(
      'AlignWithObject.distanceFromMarker_mm', value, 'f')

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'AlignWithObject.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'AlignWithObject.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'AlignWithObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'AlignWithObject.useManualSpeed', value)

  @property
  def alignmentType(self):
    "Anki.Cozmo.AlignmentType alignmentType struct property."
    return self._alignmentType

  @alignmentType.setter
  def alignmentType(self, value):
    self._alignmentType = msgbuffers.validate_integer(
      'AlignWithObject.alignmentType', value, 0, 255)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), distanceFromMarker_mm=0.0, approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False, alignmentType=Anki.Cozmo.AlignmentType.LIFT_FINGER):
    self.objectID = objectID
    self.motionProf = motionProf
    self.distanceFromMarker_mm = distanceFromMarker_mm
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed
    self.alignmentType = alignmentType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AlignWithObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AlignWithObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AlignWithObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _distanceFromMarker_mm = reader.read('f')
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    _alignmentType = reader.read('B')
    return cls(_objectID, _motionProf, _distanceFromMarker_mm, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed, _alignmentType)

  def pack(self):
    "Writes the current AlignWithObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AlignWithObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._distanceFromMarker_mm, 'f')
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(self._alignmentType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._distanceFromMarker_mm == other._distanceFromMarker_mm and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed and
        self._alignmentType == other._alignmentType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._distanceFromMarker_mm, 'f') +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._alignmentType, 'B'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, distanceFromMarker_mm={distanceFromMarker_mm}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, alignmentType={alignmentType})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      distanceFromMarker_mm=self._distanceFromMarker_mm,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed,
      alignmentType=self._alignmentType)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, distanceFromMarker_mm={distanceFromMarker_mm}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, alignmentType={alignmentType})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      distanceFromMarker_mm=repr(self._distanceFromMarker_mm),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed),
      alignmentType=repr(self._alignmentType))

Anki.Cozmo.ExternalInterface.AlignWithObject = AlignWithObject
del AlignWithObject


class CalibrateMotors(object):
  "Generated message-passing message."

  __slots__ = (
    '_calibrateHead', # bool
    '_calibrateLift', # bool
  )

  @property
  def calibrateHead(self):
    "bool calibrateHead struct property."
    return self._calibrateHead

  @calibrateHead.setter
  def calibrateHead(self, value):
    self._calibrateHead = msgbuffers.validate_bool(
      'CalibrateMotors.calibrateHead', value)

  @property
  def calibrateLift(self):
    "bool calibrateLift struct property."
    return self._calibrateLift

  @calibrateLift.setter
  def calibrateLift(self, value):
    self._calibrateLift = msgbuffers.validate_bool(
      'CalibrateMotors.calibrateLift', value)

  def __init__(self, calibrateHead=False, calibrateLift=False):
    self.calibrateHead = calibrateHead
    self.calibrateLift = calibrateLift

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CalibrateMotors from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CalibrateMotors.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CalibrateMotors from the given BinaryReader."
    _calibrateHead = bool(reader.read('b'))
    _calibrateLift = bool(reader.read('b'))
    return cls(_calibrateHead, _calibrateLift)

  def pack(self):
    "Writes the current CalibrateMotors, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CalibrateMotors to the given BinaryWriter."
    writer.write(int(self._calibrateHead), 'b')
    writer.write(int(self._calibrateLift), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._calibrateHead == other._calibrateHead and
        self._calibrateLift == other._calibrateLift)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._calibrateHead, 'b') +
      msgbuffers.size(self._calibrateLift, 'b'))

  def __str__(self):
    return '{type}(calibrateHead={calibrateHead}, calibrateLift={calibrateLift})'.format(
      type=type(self).__name__,
      calibrateHead=self._calibrateHead,
      calibrateLift=self._calibrateLift)

  def __repr__(self):
    return '{type}(calibrateHead={calibrateHead}, calibrateLift={calibrateLift})'.format(
      type=type(self).__name__,
      calibrateHead=repr(self._calibrateHead),
      calibrateLift=repr(self._calibrateLift))

Anki.Cozmo.ExternalInterface.CalibrateMotors = CalibrateMotors
del CalibrateMotors


class DisplayFaceImage(object):
  "Generated message-passing message."

  __slots__ = (
    '_duration_ms', # uint_32
    '_faceData',    # uint_8[1024]
  )

  @property
  def duration_ms(self):
    "uint_32 duration_ms struct property."
    return self._duration_ms

  @duration_ms.setter
  def duration_ms(self, value):
    self._duration_ms = msgbuffers.validate_integer(
      'DisplayFaceImage.duration_ms', value, 0, 4294967295)

  @property
  def faceData(self):
    "uint_8[1024] faceData struct property."
    return self._faceData

  @faceData.setter
  def faceData(self, value):
    self._faceData = msgbuffers.validate_farray(
      'DisplayFaceImage.faceData', value, 1024,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, duration_ms=0, faceData=(0,) * 1024):
    self.duration_ms = duration_ms
    self.faceData = faceData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DisplayFaceImage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DisplayFaceImage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DisplayFaceImage from the given BinaryReader."
    _duration_ms = reader.read('I')
    _faceData = reader.read_farray('B', 1024)
    return cls(_duration_ms, _faceData)

  def pack(self):
    "Writes the current DisplayFaceImage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DisplayFaceImage to the given BinaryWriter."
    writer.write(self._duration_ms, 'I')
    writer.write_farray(self._faceData, 'B', 1024)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._duration_ms == other._duration_ms and
        self._faceData == other._faceData)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._duration_ms, 'I') +
      msgbuffers.size_farray(self._faceData, 'B', 1024))

  def __str__(self):
    return '{type}(duration_ms={duration_ms}, faceData={faceData})'.format(
      type=type(self).__name__,
      duration_ms=self._duration_ms,
      faceData=msgbuffers.shorten_sequence(self._faceData))

  def __repr__(self):
    return '{type}(duration_ms={duration_ms}, faceData={faceData})'.format(
      type=type(self).__name__,
      duration_ms=repr(self._duration_ms),
      faceData=repr(self._faceData))

Anki.Cozmo.ExternalInterface.DisplayFaceImage = DisplayFaceImage
del DisplayFaceImage


class DisplayProceduralFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceAngle_deg', # float_32
    '_faceCenX',      # float_32
    '_faceCenY',      # float_32
    '_faceScaleX',    # float_32
    '_faceScaleY',    # float_32
    '_leftEye',       # float_32[uint_8]
    '_rightEye',      # float_32[uint_8]
    '_duration_ms',   # uint_32
  )

  @property
  def faceAngle_deg(self):
    "float_32 faceAngle_deg struct property."
    return self._faceAngle_deg

  @faceAngle_deg.setter
  def faceAngle_deg(self, value):
    self._faceAngle_deg = msgbuffers.validate_float(
      'DisplayProceduralFace.faceAngle_deg', value, 'f')

  @property
  def faceCenX(self):
    "float_32 faceCenX struct property."
    return self._faceCenX

  @faceCenX.setter
  def faceCenX(self, value):
    self._faceCenX = msgbuffers.validate_float(
      'DisplayProceduralFace.faceCenX', value, 'f')

  @property
  def faceCenY(self):
    "float_32 faceCenY struct property."
    return self._faceCenY

  @faceCenY.setter
  def faceCenY(self, value):
    self._faceCenY = msgbuffers.validate_float(
      'DisplayProceduralFace.faceCenY', value, 'f')

  @property
  def faceScaleX(self):
    "float_32 faceScaleX struct property."
    return self._faceScaleX

  @faceScaleX.setter
  def faceScaleX(self, value):
    self._faceScaleX = msgbuffers.validate_float(
      'DisplayProceduralFace.faceScaleX', value, 'f')

  @property
  def faceScaleY(self):
    "float_32 faceScaleY struct property."
    return self._faceScaleY

  @faceScaleY.setter
  def faceScaleY(self, value):
    self._faceScaleY = msgbuffers.validate_float(
      'DisplayProceduralFace.faceScaleY', value, 'f')

  @property
  def leftEye(self):
    "float_32[uint_8] leftEye struct property."
    return self._leftEye

  @leftEye.setter
  def leftEye(self, value):
    self._leftEye = msgbuffers.validate_varray(
      'DisplayProceduralFace.leftEye', value, 255,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def rightEye(self):
    "float_32[uint_8] rightEye struct property."
    return self._rightEye

  @rightEye.setter
  def rightEye(self, value):
    self._rightEye = msgbuffers.validate_varray(
      'DisplayProceduralFace.rightEye', value, 255,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def duration_ms(self):
    "uint_32 duration_ms struct property."
    return self._duration_ms

  @duration_ms.setter
  def duration_ms(self, value):
    self._duration_ms = msgbuffers.validate_integer(
      'DisplayProceduralFace.duration_ms', value, 0, 4294967295)

  def __init__(self, faceAngle_deg=0.0, faceCenX=0.0, faceCenY=0.0, faceScaleX=0.0, faceScaleY=0.0, leftEye=(), rightEye=(), duration_ms=0):
    self.faceAngle_deg = faceAngle_deg
    self.faceCenX = faceCenX
    self.faceCenY = faceCenY
    self.faceScaleX = faceScaleX
    self.faceScaleY = faceScaleY
    self.leftEye = leftEye
    self.rightEye = rightEye
    self.duration_ms = duration_ms

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DisplayProceduralFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DisplayProceduralFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DisplayProceduralFace from the given BinaryReader."
    _faceAngle_deg = reader.read('f')
    _faceCenX = reader.read('f')
    _faceCenY = reader.read('f')
    _faceScaleX = reader.read('f')
    _faceScaleY = reader.read('f')
    _leftEye = reader.read_varray('f', 'B')
    _rightEye = reader.read_varray('f', 'B')
    _duration_ms = reader.read('I')
    return cls(_faceAngle_deg, _faceCenX, _faceCenY, _faceScaleX, _faceScaleY, _leftEye, _rightEye, _duration_ms)

  def pack(self):
    "Writes the current DisplayProceduralFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DisplayProceduralFace to the given BinaryWriter."
    writer.write(self._faceAngle_deg, 'f')
    writer.write(self._faceCenX, 'f')
    writer.write(self._faceCenY, 'f')
    writer.write(self._faceScaleX, 'f')
    writer.write(self._faceScaleY, 'f')
    writer.write_varray(self._leftEye, 'f', 'B')
    writer.write_varray(self._rightEye, 'f', 'B')
    writer.write(self._duration_ms, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceAngle_deg == other._faceAngle_deg and
        self._faceCenX == other._faceCenX and
        self._faceCenY == other._faceCenY and
        self._faceScaleX == other._faceScaleX and
        self._faceScaleY == other._faceScaleY and
        self._leftEye == other._leftEye and
        self._rightEye == other._rightEye and
        self._duration_ms == other._duration_ms)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceAngle_deg, 'f') +
      msgbuffers.size(self._faceCenX, 'f') +
      msgbuffers.size(self._faceCenY, 'f') +
      msgbuffers.size(self._faceScaleX, 'f') +
      msgbuffers.size(self._faceScaleY, 'f') +
      msgbuffers.size_varray(self._leftEye, 'f', 'B') +
      msgbuffers.size_varray(self._rightEye, 'f', 'B') +
      msgbuffers.size(self._duration_ms, 'I'))

  def __str__(self):
    return '{type}(faceAngle_deg={faceAngle_deg}, faceCenX={faceCenX}, faceCenY={faceCenY}, faceScaleX={faceScaleX}, faceScaleY={faceScaleY}, leftEye={leftEye}, rightEye={rightEye}, duration_ms={duration_ms})'.format(
      type=type(self).__name__,
      faceAngle_deg=self._faceAngle_deg,
      faceCenX=self._faceCenX,
      faceCenY=self._faceCenY,
      faceScaleX=self._faceScaleX,
      faceScaleY=self._faceScaleY,
      leftEye=msgbuffers.shorten_sequence(self._leftEye),
      rightEye=msgbuffers.shorten_sequence(self._rightEye),
      duration_ms=self._duration_ms)

  def __repr__(self):
    return '{type}(faceAngle_deg={faceAngle_deg}, faceCenX={faceCenX}, faceCenY={faceCenY}, faceScaleX={faceScaleX}, faceScaleY={faceScaleY}, leftEye={leftEye}, rightEye={rightEye}, duration_ms={duration_ms})'.format(
      type=type(self).__name__,
      faceAngle_deg=repr(self._faceAngle_deg),
      faceCenX=repr(self._faceCenX),
      faceCenY=repr(self._faceCenY),
      faceScaleX=repr(self._faceScaleX),
      faceScaleY=repr(self._faceScaleY),
      leftEye=repr(self._leftEye),
      rightEye=repr(self._rightEye),
      duration_ms=repr(self._duration_ms))

Anki.Cozmo.ExternalInterface.DisplayProceduralFace = DisplayProceduralFace
del DisplayProceduralFace


class DriveOffChargerContacts(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DriveOffChargerContacts from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DriveOffChargerContacts.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DriveOffChargerContacts from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current DriveOffChargerContacts, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DriveOffChargerContacts to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.DriveOffChargerContacts = DriveOffChargerContacts
del DriveOffChargerContacts


class DriveStraight(object):
  "Generated message-passing message."

  __slots__ = (
    '_speed_mmps',          # float_32
    '_dist_mm',             # float_32
    '_shouldPlayAnimation', # bool
  )

  @property
  def speed_mmps(self):
    "float_32 speed_mmps struct property."
    return self._speed_mmps

  @speed_mmps.setter
  def speed_mmps(self, value):
    self._speed_mmps = msgbuffers.validate_float(
      'DriveStraight.speed_mmps', value, 'f')

  @property
  def dist_mm(self):
    "float_32 dist_mm struct property."
    return self._dist_mm

  @dist_mm.setter
  def dist_mm(self, value):
    self._dist_mm = msgbuffers.validate_float(
      'DriveStraight.dist_mm', value, 'f')

  @property
  def shouldPlayAnimation(self):
    "bool shouldPlayAnimation struct property."
    return self._shouldPlayAnimation

  @shouldPlayAnimation.setter
  def shouldPlayAnimation(self, value):
    self._shouldPlayAnimation = msgbuffers.validate_bool(
      'DriveStraight.shouldPlayAnimation', value)

  def __init__(self, speed_mmps=0.0, dist_mm=0.0, shouldPlayAnimation=True):
    self.speed_mmps = speed_mmps
    self.dist_mm = dist_mm
    self.shouldPlayAnimation = shouldPlayAnimation

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DriveStraight from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DriveStraight.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DriveStraight from the given BinaryReader."
    _speed_mmps = reader.read('f')
    _dist_mm = reader.read('f')
    _shouldPlayAnimation = bool(reader.read('b'))
    return cls(_speed_mmps, _dist_mm, _shouldPlayAnimation)

  def pack(self):
    "Writes the current DriveStraight, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DriveStraight to the given BinaryWriter."
    writer.write(self._speed_mmps, 'f')
    writer.write(self._dist_mm, 'f')
    writer.write(int(self._shouldPlayAnimation), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._speed_mmps == other._speed_mmps and
        self._dist_mm == other._dist_mm and
        self._shouldPlayAnimation == other._shouldPlayAnimation)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_mmps, 'f') +
      msgbuffers.size(self._dist_mm, 'f') +
      msgbuffers.size(self._shouldPlayAnimation, 'b'))

  def __str__(self):
    return '{type}(speed_mmps={speed_mmps}, dist_mm={dist_mm}, shouldPlayAnimation={shouldPlayAnimation})'.format(
      type=type(self).__name__,
      speed_mmps=self._speed_mmps,
      dist_mm=self._dist_mm,
      shouldPlayAnimation=self._shouldPlayAnimation)

  def __repr__(self):
    return '{type}(speed_mmps={speed_mmps}, dist_mm={dist_mm}, shouldPlayAnimation={shouldPlayAnimation})'.format(
      type=type(self).__name__,
      speed_mmps=repr(self._speed_mmps),
      dist_mm=repr(self._dist_mm),
      shouldPlayAnimation=repr(self._shouldPlayAnimation))

Anki.Cozmo.ExternalInterface.DriveStraight = DriveStraight
del DriveStraight


class EnrollNamedFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',      # int_32
    '_mergeIntoID', # int_32
    '_name',        # string[uint_8]
    '_sequence',    # Anki.Cozmo.FaceEnrollmentSequence
    '_saveToRobot', # bool
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'EnrollNamedFace.faceID', value, -2147483648, 2147483647)

  @property
  def mergeIntoID(self):
    "int_32 mergeIntoID struct property."
    return self._mergeIntoID

  @mergeIntoID.setter
  def mergeIntoID(self, value):
    self._mergeIntoID = msgbuffers.validate_integer(
      'EnrollNamedFace.mergeIntoID', value, -2147483648, 2147483647)

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'EnrollNamedFace.name', value, 255)

  @property
  def sequence(self):
    "Anki.Cozmo.FaceEnrollmentSequence sequence struct property."
    return self._sequence

  @sequence.setter
  def sequence(self, value):
    self._sequence = msgbuffers.validate_integer(
      'EnrollNamedFace.sequence', value, 0, 255)

  @property
  def saveToRobot(self):
    "bool saveToRobot struct property."
    return self._saveToRobot

  @saveToRobot.setter
  def saveToRobot(self, value):
    self._saveToRobot = msgbuffers.validate_bool(
      'EnrollNamedFace.saveToRobot', value)

  def __init__(self, faceID=0, mergeIntoID=0, name='', sequence=Anki.Cozmo.FaceEnrollmentSequence.Simple, saveToRobot=True):
    self.faceID = faceID
    self.mergeIntoID = mergeIntoID
    self.name = name
    self.sequence = sequence
    self.saveToRobot = saveToRobot

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnrollNamedFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnrollNamedFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnrollNamedFace from the given BinaryReader."
    _faceID = reader.read('i')
    _mergeIntoID = reader.read('i')
    _name = reader.read_string('B')
    _sequence = reader.read('B')
    _saveToRobot = bool(reader.read('b'))
    return cls(_faceID, _mergeIntoID, _name, _sequence, _saveToRobot)

  def pack(self):
    "Writes the current EnrollNamedFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnrollNamedFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._mergeIntoID, 'i')
    writer.write_string(self._name, 'B')
    writer.write(self._sequence, 'B')
    writer.write(int(self._saveToRobot), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._mergeIntoID == other._mergeIntoID and
        self._name == other._name and
        self._sequence == other._sequence and
        self._saveToRobot == other._saveToRobot)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._mergeIntoID, 'i') +
      msgbuffers.size_string(self._name, 'B') +
      msgbuffers.size(self._sequence, 'B') +
      msgbuffers.size(self._saveToRobot, 'b'))

  def __str__(self):
    return '{type}(faceID={faceID}, mergeIntoID={mergeIntoID}, name={name}, sequence={sequence}, saveToRobot={saveToRobot})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      mergeIntoID=self._mergeIntoID,
      name=msgbuffers.shorten_string(self._name),
      sequence=self._sequence,
      saveToRobot=self._saveToRobot)

  def __repr__(self):
    return '{type}(faceID={faceID}, mergeIntoID={mergeIntoID}, name={name}, sequence={sequence}, saveToRobot={saveToRobot})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      mergeIntoID=repr(self._mergeIntoID),
      name=repr(self._name),
      sequence=repr(self._sequence),
      saveToRobot=repr(self._saveToRobot))

Anki.Cozmo.ExternalInterface.EnrollNamedFace = EnrollNamedFace
del EnrollNamedFace


class FlipBlock(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',   # int_32
    '_motionProf', # Anki.Cozmo.PathMotionProfile
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'FlipBlock.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'FlipBlock.motionProf', value, Anki.Cozmo.PathMotionProfile)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile()):
    self.objectID = objectID
    self.motionProf = motionProf

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FlipBlock from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FlipBlock.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FlipBlock from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    return cls(_objectID, _motionProf)

  def pack(self):
    "Writes the current FlipBlock, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FlipBlock to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf))

Anki.Cozmo.ExternalInterface.FlipBlock = FlipBlock
del FlipBlock


class GotoObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',                    # int_32
    '_motionProf',                  # Anki.Cozmo.PathMotionProfile
    '_distanceFromObjectOrigin_mm', # float_32
    '_useManualSpeed',              # bool
    '_usePreDockPose',              # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'GotoObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'GotoObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def distanceFromObjectOrigin_mm(self):
    "float_32 distanceFromObjectOrigin_mm struct property."
    return self._distanceFromObjectOrigin_mm

  @distanceFromObjectOrigin_mm.setter
  def distanceFromObjectOrigin_mm(self, value):
    self._distanceFromObjectOrigin_mm = msgbuffers.validate_float(
      'GotoObject.distanceFromObjectOrigin_mm', value, 'f')

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'GotoObject.useManualSpeed', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'GotoObject.usePreDockPose', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), distanceFromObjectOrigin_mm=0.0, useManualSpeed=False, usePreDockPose=False):
    self.objectID = objectID
    self.motionProf = motionProf
    self.distanceFromObjectOrigin_mm = distanceFromObjectOrigin_mm
    self.useManualSpeed = useManualSpeed
    self.usePreDockPose = usePreDockPose

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GotoObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GotoObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GotoObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _distanceFromObjectOrigin_mm = reader.read('f')
    _useManualSpeed = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _distanceFromObjectOrigin_mm, _useManualSpeed, _usePreDockPose)

  def pack(self):
    "Writes the current GotoObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GotoObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._distanceFromObjectOrigin_mm, 'f')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(int(self._usePreDockPose), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._distanceFromObjectOrigin_mm == other._distanceFromObjectOrigin_mm and
        self._useManualSpeed == other._useManualSpeed and
        self._usePreDockPose == other._usePreDockPose)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._distanceFromObjectOrigin_mm, 'f') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, distanceFromObjectOrigin_mm={distanceFromObjectOrigin_mm}, useManualSpeed={useManualSpeed}, usePreDockPose={usePreDockPose})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      distanceFromObjectOrigin_mm=self._distanceFromObjectOrigin_mm,
      useManualSpeed=self._useManualSpeed,
      usePreDockPose=self._usePreDockPose)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, distanceFromObjectOrigin_mm={distanceFromObjectOrigin_mm}, useManualSpeed={useManualSpeed}, usePreDockPose={usePreDockPose})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      distanceFromObjectOrigin_mm=repr(self._distanceFromObjectOrigin_mm),
      useManualSpeed=repr(self._useManualSpeed),
      usePreDockPose=repr(self._usePreDockPose))

Anki.Cozmo.ExternalInterface.GotoObject = GotoObject
del GotoObject


class GotoPose(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_mm',           # float_32
    '_y_mm',           # float_32
    '_rad',            # float_32
    '_motionProf',     # Anki.Cozmo.PathMotionProfile
    '_level',          # uint_8
    '_useManualSpeed', # bool
  )

  @property
  def x_mm(self):
    "float_32 x_mm struct property."
    return self._x_mm

  @x_mm.setter
  def x_mm(self, value):
    self._x_mm = msgbuffers.validate_float(
      'GotoPose.x_mm', value, 'f')

  @property
  def y_mm(self):
    "float_32 y_mm struct property."
    return self._y_mm

  @y_mm.setter
  def y_mm(self, value):
    self._y_mm = msgbuffers.validate_float(
      'GotoPose.y_mm', value, 'f')

  @property
  def rad(self):
    "float_32 rad struct property."
    return self._rad

  @rad.setter
  def rad(self, value):
    self._rad = msgbuffers.validate_float(
      'GotoPose.rad', value, 'f')

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'GotoPose.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def level(self):
    "uint_8 level struct property."
    return self._level

  @level.setter
  def level(self, value):
    self._level = msgbuffers.validate_integer(
      'GotoPose.level', value, 0, 255)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'GotoPose.useManualSpeed', value)

  def __init__(self, x_mm=0.0, y_mm=0.0, rad=0.0, motionProf=Anki.Cozmo.PathMotionProfile(), level=0, useManualSpeed=False):
    self.x_mm = x_mm
    self.y_mm = y_mm
    self.rad = rad
    self.motionProf = motionProf
    self.level = level
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GotoPose from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GotoPose.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GotoPose from the given BinaryReader."
    _x_mm = reader.read('f')
    _y_mm = reader.read('f')
    _rad = reader.read('f')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _level = reader.read('B')
    _useManualSpeed = bool(reader.read('b'))
    return cls(_x_mm, _y_mm, _rad, _motionProf, _level, _useManualSpeed)

  def pack(self):
    "Writes the current GotoPose, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GotoPose to the given BinaryWriter."
    writer.write(self._x_mm, 'f')
    writer.write(self._y_mm, 'f')
    writer.write(self._rad, 'f')
    writer.write_object(self._motionProf)
    writer.write(self._level, 'B')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_mm == other._x_mm and
        self._y_mm == other._y_mm and
        self._rad == other._rad and
        self._motionProf == other._motionProf and
        self._level == other._level and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_mm, 'f') +
      msgbuffers.size(self._y_mm, 'f') +
      msgbuffers.size(self._rad, 'f') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._level, 'B') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, rad={rad}, motionProf={motionProf}, level={level}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      x_mm=self._x_mm,
      y_mm=self._y_mm,
      rad=self._rad,
      motionProf=self._motionProf,
      level=self._level,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, rad={rad}, motionProf={motionProf}, level={level}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      x_mm=repr(self._x_mm),
      y_mm=repr(self._y_mm),
      rad=repr(self._rad),
      motionProf=repr(self._motionProf),
      level=repr(self._level),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.GotoPose = GotoPose
del GotoPose


class MountCharger(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',       # int_32
    '_motionProf',     # Anki.Cozmo.PathMotionProfile
    '_usePreDockPose', # bool
    '_useManualSpeed', # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'MountCharger.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'MountCharger.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'MountCharger.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'MountCharger.useManualSpeed', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), usePreDockPose=False, useManualSpeed=False):
    self.objectID = objectID
    self.motionProf = motionProf
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MountCharger from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MountCharger.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MountCharger from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _usePreDockPose, _useManualSpeed)

  def pack(self):
    "Writes the current MountCharger, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MountCharger to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.MountCharger = MountCharger
del MountCharger


class PanAndTilt(object):
  "Generated message-passing message."

  __slots__ = (
    '_bodyPan',        # float_32
    '_headTilt',       # float_32
    '_isPanAbsolute',  # bool
    '_isTiltAbsolute', # bool
  )

  @property
  def bodyPan(self):
    "float_32 bodyPan struct property."
    return self._bodyPan

  @bodyPan.setter
  def bodyPan(self, value):
    self._bodyPan = msgbuffers.validate_float(
      'PanAndTilt.bodyPan', value, 'f')

  @property
  def headTilt(self):
    "float_32 headTilt struct property."
    return self._headTilt

  @headTilt.setter
  def headTilt(self, value):
    self._headTilt = msgbuffers.validate_float(
      'PanAndTilt.headTilt', value, 'f')

  @property
  def isPanAbsolute(self):
    "bool isPanAbsolute struct property."
    return self._isPanAbsolute

  @isPanAbsolute.setter
  def isPanAbsolute(self, value):
    self._isPanAbsolute = msgbuffers.validate_bool(
      'PanAndTilt.isPanAbsolute', value)

  @property
  def isTiltAbsolute(self):
    "bool isTiltAbsolute struct property."
    return self._isTiltAbsolute

  @isTiltAbsolute.setter
  def isTiltAbsolute(self, value):
    self._isTiltAbsolute = msgbuffers.validate_bool(
      'PanAndTilt.isTiltAbsolute', value)

  def __init__(self, bodyPan=0.0, headTilt=0.0, isPanAbsolute=False, isTiltAbsolute=False):
    self.bodyPan = bodyPan
    self.headTilt = headTilt
    self.isPanAbsolute = isPanAbsolute
    self.isTiltAbsolute = isTiltAbsolute

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PanAndTilt from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PanAndTilt.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PanAndTilt from the given BinaryReader."
    _bodyPan = reader.read('f')
    _headTilt = reader.read('f')
    _isPanAbsolute = bool(reader.read('b'))
    _isTiltAbsolute = bool(reader.read('b'))
    return cls(_bodyPan, _headTilt, _isPanAbsolute, _isTiltAbsolute)

  def pack(self):
    "Writes the current PanAndTilt, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PanAndTilt to the given BinaryWriter."
    writer.write(self._bodyPan, 'f')
    writer.write(self._headTilt, 'f')
    writer.write(int(self._isPanAbsolute), 'b')
    writer.write(int(self._isTiltAbsolute), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._bodyPan == other._bodyPan and
        self._headTilt == other._headTilt and
        self._isPanAbsolute == other._isPanAbsolute and
        self._isTiltAbsolute == other._isTiltAbsolute)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._bodyPan, 'f') +
      msgbuffers.size(self._headTilt, 'f') +
      msgbuffers.size(self._isPanAbsolute, 'b') +
      msgbuffers.size(self._isTiltAbsolute, 'b'))

  def __str__(self):
    return '{type}(bodyPan={bodyPan}, headTilt={headTilt}, isPanAbsolute={isPanAbsolute}, isTiltAbsolute={isTiltAbsolute})'.format(
      type=type(self).__name__,
      bodyPan=self._bodyPan,
      headTilt=self._headTilt,
      isPanAbsolute=self._isPanAbsolute,
      isTiltAbsolute=self._isTiltAbsolute)

  def __repr__(self):
    return '{type}(bodyPan={bodyPan}, headTilt={headTilt}, isPanAbsolute={isPanAbsolute}, isTiltAbsolute={isTiltAbsolute})'.format(
      type=type(self).__name__,
      bodyPan=repr(self._bodyPan),
      headTilt=repr(self._headTilt),
      isPanAbsolute=repr(self._isPanAbsolute),
      isTiltAbsolute=repr(self._isTiltAbsolute))

Anki.Cozmo.ExternalInterface.PanAndTilt = PanAndTilt
del PanAndTilt


class PickupObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',            # int_32
    '_motionProf',          # Anki.Cozmo.PathMotionProfile
    '_approachAngle_rad',   # float_32
    '_useApproachAngle',    # bool
    '_usePreDockPose',      # bool
    '_useManualSpeed',      # bool
    '_checkForObjectOnTop', # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'PickupObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'PickupObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'PickupObject.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'PickupObject.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'PickupObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'PickupObject.useManualSpeed', value)

  @property
  def checkForObjectOnTop(self):
    "bool checkForObjectOnTop struct property."
    return self._checkForObjectOnTop

  @checkForObjectOnTop.setter
  def checkForObjectOnTop(self, value):
    self._checkForObjectOnTop = msgbuffers.validate_bool(
      'PickupObject.checkForObjectOnTop', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False, checkForObjectOnTop=True):
    self.objectID = objectID
    self.motionProf = motionProf
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed
    self.checkForObjectOnTop = checkForObjectOnTop

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PickupObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PickupObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PickupObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    _checkForObjectOnTop = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed, _checkForObjectOnTop)

  def pack(self):
    "Writes the current PickupObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PickupObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(int(self._checkForObjectOnTop), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed and
        self._checkForObjectOnTop == other._checkForObjectOnTop)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._checkForObjectOnTop, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed,
      checkForObjectOnTop=self._checkForObjectOnTop)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed),
      checkForObjectOnTop=repr(self._checkForObjectOnTop))

Anki.Cozmo.ExternalInterface.PickupObject = PickupObject
del PickupObject


class PlaceObjectOnGround(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_mm',                 # float_32
    '_y_mm',                 # float_32
    '_qw',                   # float_32
    '_qx',                   # float_32
    '_qy',                   # float_32
    '_qz',                   # float_32
    '_motionProf',           # Anki.Cozmo.PathMotionProfile
    '_level',                # uint_8
    '_useManualSpeed',       # bool
    '_useExactRotation',     # bool
    '_checkDestinationFree', # bool
  )

  @property
  def x_mm(self):
    "float_32 x_mm struct property."
    return self._x_mm

  @x_mm.setter
  def x_mm(self, value):
    self._x_mm = msgbuffers.validate_float(
      'PlaceObjectOnGround.x_mm', value, 'f')

  @property
  def y_mm(self):
    "float_32 y_mm struct property."
    return self._y_mm

  @y_mm.setter
  def y_mm(self, value):
    self._y_mm = msgbuffers.validate_float(
      'PlaceObjectOnGround.y_mm', value, 'f')

  @property
  def qw(self):
    "float_32 qw struct property."
    return self._qw

  @qw.setter
  def qw(self, value):
    self._qw = msgbuffers.validate_float(
      'PlaceObjectOnGround.qw', value, 'f')

  @property
  def qx(self):
    "float_32 qx struct property."
    return self._qx

  @qx.setter
  def qx(self, value):
    self._qx = msgbuffers.validate_float(
      'PlaceObjectOnGround.qx', value, 'f')

  @property
  def qy(self):
    "float_32 qy struct property."
    return self._qy

  @qy.setter
  def qy(self, value):
    self._qy = msgbuffers.validate_float(
      'PlaceObjectOnGround.qy', value, 'f')

  @property
  def qz(self):
    "float_32 qz struct property."
    return self._qz

  @qz.setter
  def qz(self, value):
    self._qz = msgbuffers.validate_float(
      'PlaceObjectOnGround.qz', value, 'f')

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'PlaceObjectOnGround.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def level(self):
    "uint_8 level struct property."
    return self._level

  @level.setter
  def level(self, value):
    self._level = msgbuffers.validate_integer(
      'PlaceObjectOnGround.level', value, 0, 255)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'PlaceObjectOnGround.useManualSpeed', value)

  @property
  def useExactRotation(self):
    "bool useExactRotation struct property."
    return self._useExactRotation

  @useExactRotation.setter
  def useExactRotation(self, value):
    self._useExactRotation = msgbuffers.validate_bool(
      'PlaceObjectOnGround.useExactRotation', value)

  @property
  def checkDestinationFree(self):
    "bool checkDestinationFree struct property."
    return self._checkDestinationFree

  @checkDestinationFree.setter
  def checkDestinationFree(self, value):
    self._checkDestinationFree = msgbuffers.validate_bool(
      'PlaceObjectOnGround.checkDestinationFree', value)

  def __init__(self, x_mm=0.0, y_mm=0.0, qw=0.0, qx=0.0, qy=0.0, qz=0.0, motionProf=Anki.Cozmo.PathMotionProfile(), level=0, useManualSpeed=False, useExactRotation=False, checkDestinationFree=False):
    self.x_mm = x_mm
    self.y_mm = y_mm
    self.qw = qw
    self.qx = qx
    self.qy = qy
    self.qz = qz
    self.motionProf = motionProf
    self.level = level
    self.useManualSpeed = useManualSpeed
    self.useExactRotation = useExactRotation
    self.checkDestinationFree = checkDestinationFree

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlaceObjectOnGround from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlaceObjectOnGround.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlaceObjectOnGround from the given BinaryReader."
    _x_mm = reader.read('f')
    _y_mm = reader.read('f')
    _qw = reader.read('f')
    _qx = reader.read('f')
    _qy = reader.read('f')
    _qz = reader.read('f')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _level = reader.read('B')
    _useManualSpeed = bool(reader.read('b'))
    _useExactRotation = bool(reader.read('b'))
    _checkDestinationFree = bool(reader.read('b'))
    return cls(_x_mm, _y_mm, _qw, _qx, _qy, _qz, _motionProf, _level, _useManualSpeed, _useExactRotation, _checkDestinationFree)

  def pack(self):
    "Writes the current PlaceObjectOnGround, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlaceObjectOnGround to the given BinaryWriter."
    writer.write(self._x_mm, 'f')
    writer.write(self._y_mm, 'f')
    writer.write(self._qw, 'f')
    writer.write(self._qx, 'f')
    writer.write(self._qy, 'f')
    writer.write(self._qz, 'f')
    writer.write_object(self._motionProf)
    writer.write(self._level, 'B')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(int(self._useExactRotation), 'b')
    writer.write(int(self._checkDestinationFree), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_mm == other._x_mm and
        self._y_mm == other._y_mm and
        self._qw == other._qw and
        self._qx == other._qx and
        self._qy == other._qy and
        self._qz == other._qz and
        self._motionProf == other._motionProf and
        self._level == other._level and
        self._useManualSpeed == other._useManualSpeed and
        self._useExactRotation == other._useExactRotation and
        self._checkDestinationFree == other._checkDestinationFree)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_mm, 'f') +
      msgbuffers.size(self._y_mm, 'f') +
      msgbuffers.size(self._qw, 'f') +
      msgbuffers.size(self._qx, 'f') +
      msgbuffers.size(self._qy, 'f') +
      msgbuffers.size(self._qz, 'f') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._level, 'B') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._useExactRotation, 'b') +
      msgbuffers.size(self._checkDestinationFree, 'b'))

  def __str__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, qw={qw}, qx={qx}, qy={qy}, qz={qz}, motionProf={motionProf}, level={level}, useManualSpeed={useManualSpeed}, useExactRotation={useExactRotation}, checkDestinationFree={checkDestinationFree})'.format(
      type=type(self).__name__,
      x_mm=self._x_mm,
      y_mm=self._y_mm,
      qw=self._qw,
      qx=self._qx,
      qy=self._qy,
      qz=self._qz,
      motionProf=self._motionProf,
      level=self._level,
      useManualSpeed=self._useManualSpeed,
      useExactRotation=self._useExactRotation,
      checkDestinationFree=self._checkDestinationFree)

  def __repr__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, qw={qw}, qx={qx}, qy={qy}, qz={qz}, motionProf={motionProf}, level={level}, useManualSpeed={useManualSpeed}, useExactRotation={useExactRotation}, checkDestinationFree={checkDestinationFree})'.format(
      type=type(self).__name__,
      x_mm=repr(self._x_mm),
      y_mm=repr(self._y_mm),
      qw=repr(self._qw),
      qx=repr(self._qx),
      qy=repr(self._qy),
      qz=repr(self._qz),
      motionProf=repr(self._motionProf),
      level=repr(self._level),
      useManualSpeed=repr(self._useManualSpeed),
      useExactRotation=repr(self._useExactRotation),
      checkDestinationFree=repr(self._checkDestinationFree))

Anki.Cozmo.ExternalInterface.PlaceObjectOnGround = PlaceObjectOnGround
del PlaceObjectOnGround


class PlaceObjectOnGroundHere(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlaceObjectOnGroundHere from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlaceObjectOnGroundHere.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlaceObjectOnGroundHere from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current PlaceObjectOnGroundHere, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlaceObjectOnGroundHere to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere = PlaceObjectOnGroundHere
del PlaceObjectOnGroundHere


class PlaceOnObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',            # int_32
    '_motionProf',          # Anki.Cozmo.PathMotionProfile
    '_approachAngle_rad',   # float_32
    '_useApproachAngle',    # bool
    '_usePreDockPose',      # bool
    '_useManualSpeed',      # bool
    '_checkForObjectOnTop', # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'PlaceOnObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'PlaceOnObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'PlaceOnObject.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'PlaceOnObject.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'PlaceOnObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'PlaceOnObject.useManualSpeed', value)

  @property
  def checkForObjectOnTop(self):
    "bool checkForObjectOnTop struct property."
    return self._checkForObjectOnTop

  @checkForObjectOnTop.setter
  def checkForObjectOnTop(self, value):
    self._checkForObjectOnTop = msgbuffers.validate_bool(
      'PlaceOnObject.checkForObjectOnTop', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False, checkForObjectOnTop=True):
    self.objectID = objectID
    self.motionProf = motionProf
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed
    self.checkForObjectOnTop = checkForObjectOnTop

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlaceOnObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlaceOnObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlaceOnObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    _checkForObjectOnTop = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed, _checkForObjectOnTop)

  def pack(self):
    "Writes the current PlaceOnObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlaceOnObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(int(self._checkForObjectOnTop), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed and
        self._checkForObjectOnTop == other._checkForObjectOnTop)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._checkForObjectOnTop, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed,
      checkForObjectOnTop=self._checkForObjectOnTop)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed),
      checkForObjectOnTop=repr(self._checkForObjectOnTop))

Anki.Cozmo.ExternalInterface.PlaceOnObject = PlaceOnObject
del PlaceOnObject


class PlaceRelObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',            # int_32
    '_motionProf',          # Anki.Cozmo.PathMotionProfile
    '_placementOffsetX_mm', # float_32
    '_approachAngle_rad',   # float_32
    '_useApproachAngle',    # bool
    '_usePreDockPose',      # bool
    '_useManualSpeed',      # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'PlaceRelObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'PlaceRelObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def placementOffsetX_mm(self):
    "float_32 placementOffsetX_mm struct property."
    return self._placementOffsetX_mm

  @placementOffsetX_mm.setter
  def placementOffsetX_mm(self, value):
    self._placementOffsetX_mm = msgbuffers.validate_float(
      'PlaceRelObject.placementOffsetX_mm', value, 'f')

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'PlaceRelObject.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'PlaceRelObject.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'PlaceRelObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'PlaceRelObject.useManualSpeed', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), placementOffsetX_mm=0.0, approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False):
    self.objectID = objectID
    self.motionProf = motionProf
    self.placementOffsetX_mm = placementOffsetX_mm
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlaceRelObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlaceRelObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlaceRelObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _placementOffsetX_mm = reader.read('f')
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _placementOffsetX_mm, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed)

  def pack(self):
    "Writes the current PlaceRelObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlaceRelObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._placementOffsetX_mm, 'f')
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._placementOffsetX_mm == other._placementOffsetX_mm and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._placementOffsetX_mm, 'f') +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, placementOffsetX_mm={placementOffsetX_mm}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      placementOffsetX_mm=self._placementOffsetX_mm,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, placementOffsetX_mm={placementOffsetX_mm}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      placementOffsetX_mm=repr(self._placementOffsetX_mm),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.PlaceRelObject = PlaceRelObject
del PlaceRelObject


class PlayAnimation(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',       # uint_8
    '_numLoops',      # uint_32
    '_animationName', # string[uint_8]
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'PlayAnimation.robotID', value, 0, 255)

  @property
  def numLoops(self):
    "uint_32 numLoops struct property."
    return self._numLoops

  @numLoops.setter
  def numLoops(self, value):
    self._numLoops = msgbuffers.validate_integer(
      'PlayAnimation.numLoops', value, 0, 4294967295)

  @property
  def animationName(self):
    "string[uint_8] animationName struct property."
    return self._animationName

  @animationName.setter
  def animationName(self, value):
    self._animationName = msgbuffers.validate_string(
      'PlayAnimation.animationName', value, 255)

  def __init__(self, robotID=0, numLoops=0, animationName=''):
    self.robotID = robotID
    self.numLoops = numLoops
    self.animationName = animationName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlayAnimation from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlayAnimation.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlayAnimation from the given BinaryReader."
    _robotID = reader.read('B')
    _numLoops = reader.read('I')
    _animationName = reader.read_string('B')
    return cls(_robotID, _numLoops, _animationName)

  def pack(self):
    "Writes the current PlayAnimation, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlayAnimation to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._numLoops, 'I')
    writer.write_string(self._animationName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._numLoops == other._numLoops and
        self._animationName == other._animationName)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._numLoops, 'I') +
      msgbuffers.size_string(self._animationName, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops}, animationName={animationName})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      numLoops=self._numLoops,
      animationName=msgbuffers.shorten_string(self._animationName))

  def __repr__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops}, animationName={animationName})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      numLoops=repr(self._numLoops),
      animationName=repr(self._animationName))

Anki.Cozmo.ExternalInterface.PlayAnimation = PlayAnimation
del PlayAnimation


class PlayAnimationTrigger(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',         # uint_8
    '_numLoops',        # uint_32
    '_trigger',         # Anki.Cozmo.AnimationTrigger
    '_useLiftSafe',     # bool
    '_ignoreBodyTrack', # bool
    '_ignoreHeadTrack', # bool
    '_ignoreLiftTrack', # bool
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'PlayAnimationTrigger.robotID', value, 0, 255)

  @property
  def numLoops(self):
    "uint_32 numLoops struct property."
    return self._numLoops

  @numLoops.setter
  def numLoops(self, value):
    self._numLoops = msgbuffers.validate_integer(
      'PlayAnimationTrigger.numLoops', value, 0, 4294967295)

  @property
  def trigger(self):
    "Anki.Cozmo.AnimationTrigger trigger struct property."
    return self._trigger

  @trigger.setter
  def trigger(self, value):
    self._trigger = msgbuffers.validate_integer(
      'PlayAnimationTrigger.trigger', value, -2147483648, 2147483647)

  @property
  def useLiftSafe(self):
    "bool useLiftSafe struct property."
    return self._useLiftSafe

  @useLiftSafe.setter
  def useLiftSafe(self, value):
    self._useLiftSafe = msgbuffers.validate_bool(
      'PlayAnimationTrigger.useLiftSafe', value)

  @property
  def ignoreBodyTrack(self):
    "bool ignoreBodyTrack struct property."
    return self._ignoreBodyTrack

  @ignoreBodyTrack.setter
  def ignoreBodyTrack(self, value):
    self._ignoreBodyTrack = msgbuffers.validate_bool(
      'PlayAnimationTrigger.ignoreBodyTrack', value)

  @property
  def ignoreHeadTrack(self):
    "bool ignoreHeadTrack struct property."
    return self._ignoreHeadTrack

  @ignoreHeadTrack.setter
  def ignoreHeadTrack(self, value):
    self._ignoreHeadTrack = msgbuffers.validate_bool(
      'PlayAnimationTrigger.ignoreHeadTrack', value)

  @property
  def ignoreLiftTrack(self):
    "bool ignoreLiftTrack struct property."
    return self._ignoreLiftTrack

  @ignoreLiftTrack.setter
  def ignoreLiftTrack(self, value):
    self._ignoreLiftTrack = msgbuffers.validate_bool(
      'PlayAnimationTrigger.ignoreLiftTrack', value)

  def __init__(self, robotID=0, numLoops=0, trigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, useLiftSafe=False, ignoreBodyTrack=False, ignoreHeadTrack=False, ignoreLiftTrack=False):
    self.robotID = robotID
    self.numLoops = numLoops
    self.trigger = trigger
    self.useLiftSafe = useLiftSafe
    self.ignoreBodyTrack = ignoreBodyTrack
    self.ignoreHeadTrack = ignoreHeadTrack
    self.ignoreLiftTrack = ignoreLiftTrack

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlayAnimationTrigger from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlayAnimationTrigger.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlayAnimationTrigger from the given BinaryReader."
    _robotID = reader.read('B')
    _numLoops = reader.read('I')
    _trigger = reader.read('i')
    _useLiftSafe = bool(reader.read('b'))
    _ignoreBodyTrack = bool(reader.read('b'))
    _ignoreHeadTrack = bool(reader.read('b'))
    _ignoreLiftTrack = bool(reader.read('b'))
    return cls(_robotID, _numLoops, _trigger, _useLiftSafe, _ignoreBodyTrack, _ignoreHeadTrack, _ignoreLiftTrack)

  def pack(self):
    "Writes the current PlayAnimationTrigger, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlayAnimationTrigger to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._numLoops, 'I')
    writer.write(self._trigger, 'i')
    writer.write(int(self._useLiftSafe), 'b')
    writer.write(int(self._ignoreBodyTrack), 'b')
    writer.write(int(self._ignoreHeadTrack), 'b')
    writer.write(int(self._ignoreLiftTrack), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._numLoops == other._numLoops and
        self._trigger == other._trigger and
        self._useLiftSafe == other._useLiftSafe and
        self._ignoreBodyTrack == other._ignoreBodyTrack and
        self._ignoreHeadTrack == other._ignoreHeadTrack and
        self._ignoreLiftTrack == other._ignoreLiftTrack)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._numLoops, 'I') +
      msgbuffers.size(self._trigger, 'i') +
      msgbuffers.size(self._useLiftSafe, 'b') +
      msgbuffers.size(self._ignoreBodyTrack, 'b') +
      msgbuffers.size(self._ignoreHeadTrack, 'b') +
      msgbuffers.size(self._ignoreLiftTrack, 'b'))

  def __str__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops}, trigger={trigger}, useLiftSafe={useLiftSafe}, ignoreBodyTrack={ignoreBodyTrack}, ignoreHeadTrack={ignoreHeadTrack}, ignoreLiftTrack={ignoreLiftTrack})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      numLoops=self._numLoops,
      trigger=self._trigger,
      useLiftSafe=self._useLiftSafe,
      ignoreBodyTrack=self._ignoreBodyTrack,
      ignoreHeadTrack=self._ignoreHeadTrack,
      ignoreLiftTrack=self._ignoreLiftTrack)

  def __repr__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops}, trigger={trigger}, useLiftSafe={useLiftSafe}, ignoreBodyTrack={ignoreBodyTrack}, ignoreHeadTrack={ignoreHeadTrack}, ignoreLiftTrack={ignoreLiftTrack})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      numLoops=repr(self._numLoops),
      trigger=repr(self._trigger),
      useLiftSafe=repr(self._useLiftSafe),
      ignoreBodyTrack=repr(self._ignoreBodyTrack),
      ignoreHeadTrack=repr(self._ignoreHeadTrack),
      ignoreLiftTrack=repr(self._ignoreLiftTrack))

Anki.Cozmo.ExternalInterface.PlayAnimationTrigger = PlayAnimationTrigger
del PlayAnimationTrigger


class PlayAnimation_DEV(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotId',       # uint_8
    '_numLoops',      # uint_32
    '_animationName', # string[uint_8]
  )

  @property
  def robotId(self):
    "uint_8 robotId struct property."
    return self._robotId

  @robotId.setter
  def robotId(self, value):
    self._robotId = msgbuffers.validate_integer(
      'PlayAnimation_DEV.robotId', value, 0, 255)

  @property
  def numLoops(self):
    "uint_32 numLoops struct property."
    return self._numLoops

  @numLoops.setter
  def numLoops(self, value):
    self._numLoops = msgbuffers.validate_integer(
      'PlayAnimation_DEV.numLoops', value, 0, 4294967295)

  @property
  def animationName(self):
    "string[uint_8] animationName struct property."
    return self._animationName

  @animationName.setter
  def animationName(self, value):
    self._animationName = msgbuffers.validate_string(
      'PlayAnimation_DEV.animationName', value, 255)

  def __init__(self, robotId=0, numLoops=0, animationName=''):
    self.robotId = robotId
    self.numLoops = numLoops
    self.animationName = animationName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlayAnimation_DEV from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlayAnimation_DEV.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlayAnimation_DEV from the given BinaryReader."
    _robotId = reader.read('B')
    _numLoops = reader.read('I')
    _animationName = reader.read_string('B')
    return cls(_robotId, _numLoops, _animationName)

  def pack(self):
    "Writes the current PlayAnimation_DEV, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlayAnimation_DEV to the given BinaryWriter."
    writer.write(self._robotId, 'B')
    writer.write(self._numLoops, 'I')
    writer.write_string(self._animationName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotId == other._robotId and
        self._numLoops == other._numLoops and
        self._animationName == other._animationName)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotId, 'B') +
      msgbuffers.size(self._numLoops, 'I') +
      msgbuffers.size_string(self._animationName, 'B'))

  def __str__(self):
    return '{type}(robotId={robotId}, numLoops={numLoops}, animationName={animationName})'.format(
      type=type(self).__name__,
      robotId=self._robotId,
      numLoops=self._numLoops,
      animationName=msgbuffers.shorten_string(self._animationName))

  def __repr__(self):
    return '{type}(robotId={robotId}, numLoops={numLoops}, animationName={animationName})'.format(
      type=type(self).__name__,
      robotId=repr(self._robotId),
      numLoops=repr(self._numLoops),
      animationName=repr(self._animationName))

Anki.Cozmo.ExternalInterface.PlayAnimation_DEV = PlayAnimation_DEV
del PlayAnimation_DEV


class PopAWheelie(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',          # int_32
    '_motionProf',        # Anki.Cozmo.PathMotionProfile
    '_approachAngle_rad', # float_32
    '_useApproachAngle',  # bool
    '_usePreDockPose',    # bool
    '_useManualSpeed',    # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'PopAWheelie.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'PopAWheelie.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'PopAWheelie.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'PopAWheelie.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'PopAWheelie.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'PopAWheelie.useManualSpeed', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False):
    self.objectID = objectID
    self.motionProf = motionProf
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PopAWheelie from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PopAWheelie.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PopAWheelie from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed)

  def pack(self):
    "Writes the current PopAWheelie, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PopAWheelie to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.PopAWheelie = PopAWheelie
del PopAWheelie


class FacePlant(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',          # int_32
    '_motionProf',        # Anki.Cozmo.PathMotionProfile
    '_approachAngle_rad', # float_32
    '_useApproachAngle',  # bool
    '_usePreDockPose',    # bool
    '_useManualSpeed',    # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'FacePlant.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'FacePlant.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'FacePlant.approachAngle_rad', value, 'f')

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'FacePlant.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'FacePlant.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'FacePlant.useManualSpeed', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), approachAngle_rad=0.0, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False):
    self.objectID = objectID
    self.motionProf = motionProf
    self.approachAngle_rad = approachAngle_rad
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FacePlant from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FacePlant.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FacePlant from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _approachAngle_rad = reader.read('f')
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _approachAngle_rad, _useApproachAngle, _usePreDockPose, _useManualSpeed)

  def pack(self):
    "Writes the current FacePlant, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FacePlant to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._approachAngle_rad == other._approachAngle_rad and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      approachAngle_rad=self._approachAngle_rad,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      approachAngle_rad=repr(self._approachAngle_rad),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.FacePlant = FacePlant
del FacePlant


class ReadToolCode(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReadToolCode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReadToolCode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReadToolCode from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ReadToolCode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReadToolCode to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ReadToolCode = ReadToolCode
del ReadToolCode


class RealignWithObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID', # int_32
    '_dist_mm',  # float_32
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'RealignWithObject.objectID', value, -2147483648, 2147483647)

  @property
  def dist_mm(self):
    "float_32 dist_mm struct property."
    return self._dist_mm

  @dist_mm.setter
  def dist_mm(self, value):
    self._dist_mm = msgbuffers.validate_float(
      'RealignWithObject.dist_mm', value, 'f')

  def __init__(self, objectID=0, dist_mm=0.0):
    self.objectID = objectID
    self.dist_mm = dist_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RealignWithObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RealignWithObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RealignWithObject from the given BinaryReader."
    _objectID = reader.read('i')
    _dist_mm = reader.read('f')
    return cls(_objectID, _dist_mm)

  def pack(self):
    "Writes the current RealignWithObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RealignWithObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write(self._dist_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._dist_mm == other._dist_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size(self._dist_mm, 'f'))

  def __str__(self):
    return '{type}(objectID={objectID}, dist_mm={dist_mm})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      dist_mm=self._dist_mm)

  def __repr__(self):
    return '{type}(objectID={objectID}, dist_mm={dist_mm})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      dist_mm=repr(self._dist_mm))

Anki.Cozmo.ExternalInterface.RealignWithObject = RealignWithObject
del RealignWithObject


class RollObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',            # int_32
    '_motionProf',          # Anki.Cozmo.PathMotionProfile
    '_approachAngle_rad',   # float_32
    '_doDeepRoll',          # bool
    '_useApproachAngle',    # bool
    '_usePreDockPose',      # bool
    '_useManualSpeed',      # bool
    '_checkForObjectOnTop', # bool
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'RollObject.objectID', value, -2147483648, 2147483647)

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'RollObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def approachAngle_rad(self):
    "float_32 approachAngle_rad struct property."
    return self._approachAngle_rad

  @approachAngle_rad.setter
  def approachAngle_rad(self, value):
    self._approachAngle_rad = msgbuffers.validate_float(
      'RollObject.approachAngle_rad', value, 'f')

  @property
  def doDeepRoll(self):
    "bool doDeepRoll struct property."
    return self._doDeepRoll

  @doDeepRoll.setter
  def doDeepRoll(self, value):
    self._doDeepRoll = msgbuffers.validate_bool(
      'RollObject.doDeepRoll', value)

  @property
  def useApproachAngle(self):
    "bool useApproachAngle struct property."
    return self._useApproachAngle

  @useApproachAngle.setter
  def useApproachAngle(self, value):
    self._useApproachAngle = msgbuffers.validate_bool(
      'RollObject.useApproachAngle', value)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'RollObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'RollObject.useManualSpeed', value)

  @property
  def checkForObjectOnTop(self):
    "bool checkForObjectOnTop struct property."
    return self._checkForObjectOnTop

  @checkForObjectOnTop.setter
  def checkForObjectOnTop(self, value):
    self._checkForObjectOnTop = msgbuffers.validate_bool(
      'RollObject.checkForObjectOnTop', value)

  def __init__(self, objectID=0, motionProf=Anki.Cozmo.PathMotionProfile(), approachAngle_rad=0.0, doDeepRoll=False, useApproachAngle=False, usePreDockPose=False, useManualSpeed=False, checkForObjectOnTop=True):
    self.objectID = objectID
    self.motionProf = motionProf
    self.approachAngle_rad = approachAngle_rad
    self.doDeepRoll = doDeepRoll
    self.useApproachAngle = useApproachAngle
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed
    self.checkForObjectOnTop = checkForObjectOnTop

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RollObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RollObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RollObject from the given BinaryReader."
    _objectID = reader.read('i')
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _approachAngle_rad = reader.read('f')
    _doDeepRoll = bool(reader.read('b'))
    _useApproachAngle = bool(reader.read('b'))
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    _checkForObjectOnTop = bool(reader.read('b'))
    return cls(_objectID, _motionProf, _approachAngle_rad, _doDeepRoll, _useApproachAngle, _usePreDockPose, _useManualSpeed, _checkForObjectOnTop)

  def pack(self):
    "Writes the current RollObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RollObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write_object(self._motionProf)
    writer.write(self._approachAngle_rad, 'f')
    writer.write(int(self._doDeepRoll), 'b')
    writer.write(int(self._useApproachAngle), 'b')
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')
    writer.write(int(self._checkForObjectOnTop), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._motionProf == other._motionProf and
        self._approachAngle_rad == other._approachAngle_rad and
        self._doDeepRoll == other._doDeepRoll and
        self._useApproachAngle == other._useApproachAngle and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed and
        self._checkForObjectOnTop == other._checkForObjectOnTop)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._approachAngle_rad, 'f') +
      msgbuffers.size(self._doDeepRoll, 'b') +
      msgbuffers.size(self._useApproachAngle, 'b') +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b') +
      msgbuffers.size(self._checkForObjectOnTop, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, doDeepRoll={doDeepRoll}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      motionProf=self._motionProf,
      approachAngle_rad=self._approachAngle_rad,
      doDeepRoll=self._doDeepRoll,
      useApproachAngle=self._useApproachAngle,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed,
      checkForObjectOnTop=self._checkForObjectOnTop)

  def __repr__(self):
    return '{type}(objectID={objectID}, motionProf={motionProf}, approachAngle_rad={approachAngle_rad}, doDeepRoll={doDeepRoll}, useApproachAngle={useApproachAngle}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed}, checkForObjectOnTop={checkForObjectOnTop})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      motionProf=repr(self._motionProf),
      approachAngle_rad=repr(self._approachAngle_rad),
      doDeepRoll=repr(self._doDeepRoll),
      useApproachAngle=repr(self._useApproachAngle),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed),
      checkForObjectOnTop=repr(self._checkForObjectOnTop))

Anki.Cozmo.ExternalInterface.RollObject = RollObject
del RollObject


class SayText(object):
  "Generated message-passing message."

  __slots__ = (
    '_text',           # string[uint_8]
    '_playEvent',      # Anki.Cozmo.AnimationTrigger
    '_voiceStyle',     # Anki.Cozmo.SayTextVoiceStyle
    '_durationScalar', # float_32
    '_voicePitch',     # float_32
    '_fitToDuration',  # bool
  )

  @property
  def text(self):
    "string[uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_string(
      'SayText.text', value, 255)

  @property
  def playEvent(self):
    "Anki.Cozmo.AnimationTrigger playEvent struct property."
    return self._playEvent

  @playEvent.setter
  def playEvent(self, value):
    self._playEvent = msgbuffers.validate_integer(
      'SayText.playEvent', value, -2147483648, 2147483647)

  @property
  def voiceStyle(self):
    "Anki.Cozmo.SayTextVoiceStyle voiceStyle struct property."
    return self._voiceStyle

  @voiceStyle.setter
  def voiceStyle(self, value):
    self._voiceStyle = msgbuffers.validate_integer(
      'SayText.voiceStyle', value, 0, 255)

  @property
  def durationScalar(self):
    "float_32 durationScalar struct property."
    return self._durationScalar

  @durationScalar.setter
  def durationScalar(self, value):
    self._durationScalar = msgbuffers.validate_float(
      'SayText.durationScalar', value, 'f')

  @property
  def voicePitch(self):
    "float_32 voicePitch struct property."
    return self._voicePitch

  @voicePitch.setter
  def voicePitch(self, value):
    self._voicePitch = msgbuffers.validate_float(
      'SayText.voicePitch', value, 'f')

  @property
  def fitToDuration(self):
    "bool fitToDuration struct property."
    return self._fitToDuration

  @fitToDuration.setter
  def fitToDuration(self, value):
    self._fitToDuration = msgbuffers.validate_bool(
      'SayText.fitToDuration', value)

  def __init__(self, text='', playEvent=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, voiceStyle=Anki.Cozmo.SayTextVoiceStyle.Unprocessed, durationScalar=1.0, voicePitch=0.0, fitToDuration=False):
    self.text = text
    self.playEvent = playEvent
    self.voiceStyle = voiceStyle
    self.durationScalar = durationScalar
    self.voicePitch = voicePitch
    self.fitToDuration = fitToDuration

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SayText from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SayText.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SayText from the given BinaryReader."
    _text = reader.read_string('B')
    _playEvent = reader.read('i')
    _voiceStyle = reader.read('B')
    _durationScalar = reader.read('f')
    _voicePitch = reader.read('f')
    _fitToDuration = bool(reader.read('b'))
    return cls(_text, _playEvent, _voiceStyle, _durationScalar, _voicePitch, _fitToDuration)

  def pack(self):
    "Writes the current SayText, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SayText to the given BinaryWriter."
    writer.write_string(self._text, 'B')
    writer.write(self._playEvent, 'i')
    writer.write(self._voiceStyle, 'B')
    writer.write(self._durationScalar, 'f')
    writer.write(self._voicePitch, 'f')
    writer.write(int(self._fitToDuration), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._text == other._text and
        self._playEvent == other._playEvent and
        self._voiceStyle == other._voiceStyle and
        self._durationScalar == other._durationScalar and
        self._voicePitch == other._voicePitch and
        self._fitToDuration == other._fitToDuration)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._text, 'B') +
      msgbuffers.size(self._playEvent, 'i') +
      msgbuffers.size(self._voiceStyle, 'B') +
      msgbuffers.size(self._durationScalar, 'f') +
      msgbuffers.size(self._voicePitch, 'f') +
      msgbuffers.size(self._fitToDuration, 'b'))

  def __str__(self):
    return '{type}(text={text}, playEvent={playEvent}, voiceStyle={voiceStyle}, durationScalar={durationScalar}, voicePitch={voicePitch}, fitToDuration={fitToDuration})'.format(
      type=type(self).__name__,
      text=msgbuffers.shorten_string(self._text),
      playEvent=self._playEvent,
      voiceStyle=self._voiceStyle,
      durationScalar=self._durationScalar,
      voicePitch=self._voicePitch,
      fitToDuration=self._fitToDuration)

  def __repr__(self):
    return '{type}(text={text}, playEvent={playEvent}, voiceStyle={voiceStyle}, durationScalar={durationScalar}, voicePitch={voicePitch}, fitToDuration={fitToDuration})'.format(
      type=type(self).__name__,
      text=repr(self._text),
      playEvent=repr(self._playEvent),
      voiceStyle=repr(self._voiceStyle),
      durationScalar=repr(self._durationScalar),
      voicePitch=repr(self._voicePitch),
      fitToDuration=repr(self._fitToDuration))

Anki.Cozmo.ExternalInterface.SayText = SayText
del SayText


class SayTextWithIntent(object):
  "Generated message-passing message."

  __slots__ = (
    '_text',          # string[uint_8]
    '_playEvent',     # Anki.Cozmo.AnimationTrigger
    '_intent',        # Anki.Cozmo.SayTextIntent
    '_fitToDuration', # bool
  )

  @property
  def text(self):
    "string[uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_string(
      'SayTextWithIntent.text', value, 255)

  @property
  def playEvent(self):
    "Anki.Cozmo.AnimationTrigger playEvent struct property."
    return self._playEvent

  @playEvent.setter
  def playEvent(self, value):
    self._playEvent = msgbuffers.validate_integer(
      'SayTextWithIntent.playEvent', value, -2147483648, 2147483647)

  @property
  def intent(self):
    "Anki.Cozmo.SayTextIntent intent struct property."
    return self._intent

  @intent.setter
  def intent(self, value):
    self._intent = msgbuffers.validate_integer(
      'SayTextWithIntent.intent', value, 0, 255)

  @property
  def fitToDuration(self):
    "bool fitToDuration struct property."
    return self._fitToDuration

  @fitToDuration.setter
  def fitToDuration(self, value):
    self._fitToDuration = msgbuffers.validate_bool(
      'SayTextWithIntent.fitToDuration', value)

  def __init__(self, text='', playEvent=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, intent=Anki.Cozmo.SayTextIntent.UnProcessed, fitToDuration=False):
    self.text = text
    self.playEvent = playEvent
    self.intent = intent
    self.fitToDuration = fitToDuration

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SayTextWithIntent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SayTextWithIntent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SayTextWithIntent from the given BinaryReader."
    _text = reader.read_string('B')
    _playEvent = reader.read('i')
    _intent = reader.read('B')
    _fitToDuration = bool(reader.read('b'))
    return cls(_text, _playEvent, _intent, _fitToDuration)

  def pack(self):
    "Writes the current SayTextWithIntent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SayTextWithIntent to the given BinaryWriter."
    writer.write_string(self._text, 'B')
    writer.write(self._playEvent, 'i')
    writer.write(self._intent, 'B')
    writer.write(int(self._fitToDuration), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._text == other._text and
        self._playEvent == other._playEvent and
        self._intent == other._intent and
        self._fitToDuration == other._fitToDuration)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._text, 'B') +
      msgbuffers.size(self._playEvent, 'i') +
      msgbuffers.size(self._intent, 'B') +
      msgbuffers.size(self._fitToDuration, 'b'))

  def __str__(self):
    return '{type}(text={text}, playEvent={playEvent}, intent={intent}, fitToDuration={fitToDuration})'.format(
      type=type(self).__name__,
      text=msgbuffers.shorten_string(self._text),
      playEvent=self._playEvent,
      intent=self._intent,
      fitToDuration=self._fitToDuration)

  def __repr__(self):
    return '{type}(text={text}, playEvent={playEvent}, intent={intent}, fitToDuration={fitToDuration})'.format(
      type=type(self).__name__,
      text=repr(self._text),
      playEvent=repr(self._playEvent),
      intent=repr(self._intent),
      fitToDuration=repr(self._fitToDuration))

Anki.Cozmo.ExternalInterface.SayTextWithIntent = SayTextWithIntent
del SayTextWithIntent


class SearchForNearbyObjectDefaults(object):
  "Automatically-generated int_32 enumeration."
  BackupDistance_mm = -20
  BackupSpeed_mms   = 100
  HeadAngle_deg     = -5

Anki.Cozmo.ExternalInterface.SearchForNearbyObjectDefaults = SearchForNearbyObjectDefaults
del SearchForNearbyObjectDefaults


class SearchForNearbyObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_desiredObjectID',   # int_32
    '_backupDistance_mm', # float_32
    '_backupSpeed_mms',   # float_32
    '_headAngle_rad',     # float_32
  )

  @property
  def desiredObjectID(self):
    "int_32 desiredObjectID struct property."
    return self._desiredObjectID

  @desiredObjectID.setter
  def desiredObjectID(self, value):
    self._desiredObjectID = msgbuffers.validate_integer(
      'SearchForNearbyObject.desiredObjectID', value, -2147483648, 2147483647)

  @property
  def backupDistance_mm(self):
    "float_32 backupDistance_mm struct property."
    return self._backupDistance_mm

  @backupDistance_mm.setter
  def backupDistance_mm(self, value):
    self._backupDistance_mm = msgbuffers.validate_float(
      'SearchForNearbyObject.backupDistance_mm', value, 'f')

  @property
  def backupSpeed_mms(self):
    "float_32 backupSpeed_mms struct property."
    return self._backupSpeed_mms

  @backupSpeed_mms.setter
  def backupSpeed_mms(self, value):
    self._backupSpeed_mms = msgbuffers.validate_float(
      'SearchForNearbyObject.backupSpeed_mms', value, 'f')

  @property
  def headAngle_rad(self):
    "float_32 headAngle_rad struct property."
    return self._headAngle_rad

  @headAngle_rad.setter
  def headAngle_rad(self, value):
    self._headAngle_rad = msgbuffers.validate_float(
      'SearchForNearbyObject.headAngle_rad', value, 'f')

  def __init__(self, desiredObjectID=-1, backupDistance_mm=0.0, backupSpeed_mms=0.0, headAngle_rad=0.0):
    self.desiredObjectID = desiredObjectID
    self.backupDistance_mm = backupDistance_mm
    self.backupSpeed_mms = backupSpeed_mms
    self.headAngle_rad = headAngle_rad

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SearchForNearbyObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SearchForNearbyObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SearchForNearbyObject from the given BinaryReader."
    _desiredObjectID = reader.read('i')
    _backupDistance_mm = reader.read('f')
    _backupSpeed_mms = reader.read('f')
    _headAngle_rad = reader.read('f')
    return cls(_desiredObjectID, _backupDistance_mm, _backupSpeed_mms, _headAngle_rad)

  def pack(self):
    "Writes the current SearchForNearbyObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SearchForNearbyObject to the given BinaryWriter."
    writer.write(self._desiredObjectID, 'i')
    writer.write(self._backupDistance_mm, 'f')
    writer.write(self._backupSpeed_mms, 'f')
    writer.write(self._headAngle_rad, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._desiredObjectID == other._desiredObjectID and
        self._backupDistance_mm == other._backupDistance_mm and
        self._backupSpeed_mms == other._backupSpeed_mms and
        self._headAngle_rad == other._headAngle_rad)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._desiredObjectID, 'i') +
      msgbuffers.size(self._backupDistance_mm, 'f') +
      msgbuffers.size(self._backupSpeed_mms, 'f') +
      msgbuffers.size(self._headAngle_rad, 'f'))

  def __str__(self):
    return '{type}(desiredObjectID={desiredObjectID}, backupDistance_mm={backupDistance_mm}, backupSpeed_mms={backupSpeed_mms}, headAngle_rad={headAngle_rad})'.format(
      type=type(self).__name__,
      desiredObjectID=self._desiredObjectID,
      backupDistance_mm=self._backupDistance_mm,
      backupSpeed_mms=self._backupSpeed_mms,
      headAngle_rad=self._headAngle_rad)

  def __repr__(self):
    return '{type}(desiredObjectID={desiredObjectID}, backupDistance_mm={backupDistance_mm}, backupSpeed_mms={backupSpeed_mms}, headAngle_rad={headAngle_rad})'.format(
      type=type(self).__name__,
      desiredObjectID=repr(self._desiredObjectID),
      backupDistance_mm=repr(self._backupDistance_mm),
      backupSpeed_mms=repr(self._backupSpeed_mms),
      headAngle_rad=repr(self._headAngle_rad))

Anki.Cozmo.ExternalInterface.SearchForNearbyObject = SearchForNearbyObject
del SearchForNearbyObject


class SetHeadAngle(object):
  "Generated message-passing message."

  __slots__ = (
    '_angle_rad',             # float_32
    '_max_speed_rad_per_sec', # float_32
    '_accel_rad_per_sec2',    # float_32
    '_duration_sec',          # float_32
  )

  @property
  def angle_rad(self):
    "float_32 angle_rad struct property."
    return self._angle_rad

  @angle_rad.setter
  def angle_rad(self, value):
    self._angle_rad = msgbuffers.validate_float(
      'SetHeadAngle.angle_rad', value, 'f')

  @property
  def max_speed_rad_per_sec(self):
    "float_32 max_speed_rad_per_sec struct property."
    return self._max_speed_rad_per_sec

  @max_speed_rad_per_sec.setter
  def max_speed_rad_per_sec(self, value):
    self._max_speed_rad_per_sec = msgbuffers.validate_float(
      'SetHeadAngle.max_speed_rad_per_sec', value, 'f')

  @property
  def accel_rad_per_sec2(self):
    "float_32 accel_rad_per_sec2 struct property."
    return self._accel_rad_per_sec2

  @accel_rad_per_sec2.setter
  def accel_rad_per_sec2(self, value):
    self._accel_rad_per_sec2 = msgbuffers.validate_float(
      'SetHeadAngle.accel_rad_per_sec2', value, 'f')

  @property
  def duration_sec(self):
    "float_32 duration_sec struct property."
    return self._duration_sec

  @duration_sec.setter
  def duration_sec(self, value):
    self._duration_sec = msgbuffers.validate_float(
      'SetHeadAngle.duration_sec', value, 'f')

  def __init__(self, angle_rad=0.0, max_speed_rad_per_sec=0.0, accel_rad_per_sec2=0.0, duration_sec=0.0):
    self.angle_rad = angle_rad
    self.max_speed_rad_per_sec = max_speed_rad_per_sec
    self.accel_rad_per_sec2 = accel_rad_per_sec2
    self.duration_sec = duration_sec

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetHeadAngle from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetHeadAngle.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetHeadAngle from the given BinaryReader."
    _angle_rad = reader.read('f')
    _max_speed_rad_per_sec = reader.read('f')
    _accel_rad_per_sec2 = reader.read('f')
    _duration_sec = reader.read('f')
    return cls(_angle_rad, _max_speed_rad_per_sec, _accel_rad_per_sec2, _duration_sec)

  def pack(self):
    "Writes the current SetHeadAngle, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetHeadAngle to the given BinaryWriter."
    writer.write(self._angle_rad, 'f')
    writer.write(self._max_speed_rad_per_sec, 'f')
    writer.write(self._accel_rad_per_sec2, 'f')
    writer.write(self._duration_sec, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._angle_rad == other._angle_rad and
        self._max_speed_rad_per_sec == other._max_speed_rad_per_sec and
        self._accel_rad_per_sec2 == other._accel_rad_per_sec2 and
        self._duration_sec == other._duration_sec)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._angle_rad, 'f') +
      msgbuffers.size(self._max_speed_rad_per_sec, 'f') +
      msgbuffers.size(self._accel_rad_per_sec2, 'f') +
      msgbuffers.size(self._duration_sec, 'f'))

  def __str__(self):
    return '{type}(angle_rad={angle_rad}, max_speed_rad_per_sec={max_speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, duration_sec={duration_sec})'.format(
      type=type(self).__name__,
      angle_rad=self._angle_rad,
      max_speed_rad_per_sec=self._max_speed_rad_per_sec,
      accel_rad_per_sec2=self._accel_rad_per_sec2,
      duration_sec=self._duration_sec)

  def __repr__(self):
    return '{type}(angle_rad={angle_rad}, max_speed_rad_per_sec={max_speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, duration_sec={duration_sec})'.format(
      type=type(self).__name__,
      angle_rad=repr(self._angle_rad),
      max_speed_rad_per_sec=repr(self._max_speed_rad_per_sec),
      accel_rad_per_sec2=repr(self._accel_rad_per_sec2),
      duration_sec=repr(self._duration_sec))

Anki.Cozmo.ExternalInterface.SetHeadAngle = SetHeadAngle
del SetHeadAngle


class SetLiftHeight(object):
  "Generated message-passing message."

  __slots__ = (
    '_height_mm',             # float_32
    '_max_speed_rad_per_sec', # float_32
    '_accel_rad_per_sec2',    # float_32
    '_duration_sec',          # float_32
  )

  @property
  def height_mm(self):
    "float_32 height_mm struct property."
    return self._height_mm

  @height_mm.setter
  def height_mm(self, value):
    self._height_mm = msgbuffers.validate_float(
      'SetLiftHeight.height_mm', value, 'f')

  @property
  def max_speed_rad_per_sec(self):
    "float_32 max_speed_rad_per_sec struct property."
    return self._max_speed_rad_per_sec

  @max_speed_rad_per_sec.setter
  def max_speed_rad_per_sec(self, value):
    self._max_speed_rad_per_sec = msgbuffers.validate_float(
      'SetLiftHeight.max_speed_rad_per_sec', value, 'f')

  @property
  def accel_rad_per_sec2(self):
    "float_32 accel_rad_per_sec2 struct property."
    return self._accel_rad_per_sec2

  @accel_rad_per_sec2.setter
  def accel_rad_per_sec2(self, value):
    self._accel_rad_per_sec2 = msgbuffers.validate_float(
      'SetLiftHeight.accel_rad_per_sec2', value, 'f')

  @property
  def duration_sec(self):
    "float_32 duration_sec struct property."
    return self._duration_sec

  @duration_sec.setter
  def duration_sec(self, value):
    self._duration_sec = msgbuffers.validate_float(
      'SetLiftHeight.duration_sec', value, 'f')

  def __init__(self, height_mm=0.0, max_speed_rad_per_sec=0.0, accel_rad_per_sec2=0.0, duration_sec=0.0):
    self.height_mm = height_mm
    self.max_speed_rad_per_sec = max_speed_rad_per_sec
    self.accel_rad_per_sec2 = accel_rad_per_sec2
    self.duration_sec = duration_sec

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetLiftHeight from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetLiftHeight.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetLiftHeight from the given BinaryReader."
    _height_mm = reader.read('f')
    _max_speed_rad_per_sec = reader.read('f')
    _accel_rad_per_sec2 = reader.read('f')
    _duration_sec = reader.read('f')
    return cls(_height_mm, _max_speed_rad_per_sec, _accel_rad_per_sec2, _duration_sec)

  def pack(self):
    "Writes the current SetLiftHeight, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetLiftHeight to the given BinaryWriter."
    writer.write(self._height_mm, 'f')
    writer.write(self._max_speed_rad_per_sec, 'f')
    writer.write(self._accel_rad_per_sec2, 'f')
    writer.write(self._duration_sec, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._height_mm == other._height_mm and
        self._max_speed_rad_per_sec == other._max_speed_rad_per_sec and
        self._accel_rad_per_sec2 == other._accel_rad_per_sec2 and
        self._duration_sec == other._duration_sec)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._height_mm, 'f') +
      msgbuffers.size(self._max_speed_rad_per_sec, 'f') +
      msgbuffers.size(self._accel_rad_per_sec2, 'f') +
      msgbuffers.size(self._duration_sec, 'f'))

  def __str__(self):
    return '{type}(height_mm={height_mm}, max_speed_rad_per_sec={max_speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, duration_sec={duration_sec})'.format(
      type=type(self).__name__,
      height_mm=self._height_mm,
      max_speed_rad_per_sec=self._max_speed_rad_per_sec,
      accel_rad_per_sec2=self._accel_rad_per_sec2,
      duration_sec=self._duration_sec)

  def __repr__(self):
    return '{type}(height_mm={height_mm}, max_speed_rad_per_sec={max_speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, duration_sec={duration_sec})'.format(
      type=type(self).__name__,
      height_mm=repr(self._height_mm),
      max_speed_rad_per_sec=repr(self._max_speed_rad_per_sec),
      accel_rad_per_sec2=repr(self._accel_rad_per_sec2),
      duration_sec=repr(self._duration_sec))

Anki.Cozmo.ExternalInterface.SetLiftHeight = SetLiftHeight
del SetLiftHeight


class TrackToFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',   # uint_32
    '_robotID',  # uint_8
    '_headOnly', # bool
  )

  @property
  def faceID(self):
    "uint_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'TrackToFace.faceID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TrackToFace.robotID', value, 0, 255)

  @property
  def headOnly(self):
    "bool headOnly struct property."
    return self._headOnly

  @headOnly.setter
  def headOnly(self, value):
    self._headOnly = msgbuffers.validate_bool(
      'TrackToFace.headOnly', value)

  def __init__(self, faceID=0, robotID=0, headOnly=False):
    self.faceID = faceID
    self.robotID = robotID
    self.headOnly = headOnly

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TrackToFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TrackToFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TrackToFace from the given BinaryReader."
    _faceID = reader.read('I')
    _robotID = reader.read('B')
    _headOnly = bool(reader.read('b'))
    return cls(_faceID, _robotID, _headOnly)

  def pack(self):
    "Writes the current TrackToFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TrackToFace to the given BinaryWriter."
    writer.write(self._faceID, 'I')
    writer.write(self._robotID, 'B')
    writer.write(int(self._headOnly), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._robotID == other._robotID and
        self._headOnly == other._headOnly)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'I') +
      msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._headOnly, 'b'))

  def __str__(self):
    return '{type}(faceID={faceID}, robotID={robotID}, headOnly={headOnly})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      robotID=self._robotID,
      headOnly=self._headOnly)

  def __repr__(self):
    return '{type}(faceID={faceID}, robotID={robotID}, headOnly={headOnly})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      robotID=repr(self._robotID),
      headOnly=repr(self._headOnly))

Anki.Cozmo.ExternalInterface.TrackToFace = TrackToFace
del TrackToFace


class TrackToObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID', # uint_32
    '_robotID',  # uint_8
    '_headOnly', # bool
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'TrackToObject.objectID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TrackToObject.robotID', value, 0, 255)

  @property
  def headOnly(self):
    "bool headOnly struct property."
    return self._headOnly

  @headOnly.setter
  def headOnly(self, value):
    self._headOnly = msgbuffers.validate_bool(
      'TrackToObject.headOnly', value)

  def __init__(self, objectID=0, robotID=0, headOnly=False):
    self.objectID = objectID
    self.robotID = robotID
    self.headOnly = headOnly

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TrackToObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TrackToObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TrackToObject from the given BinaryReader."
    _objectID = reader.read('I')
    _robotID = reader.read('B')
    _headOnly = bool(reader.read('b'))
    return cls(_objectID, _robotID, _headOnly)

  def pack(self):
    "Writes the current TrackToObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TrackToObject to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._robotID, 'B')
    writer.write(int(self._headOnly), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._robotID == other._robotID and
        self._headOnly == other._headOnly)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._headOnly, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, robotID={robotID}, headOnly={headOnly})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      robotID=self._robotID,
      headOnly=self._headOnly)

  def __repr__(self):
    return '{type}(objectID={objectID}, robotID={robotID}, headOnly={headOnly})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      robotID=repr(self._robotID),
      headOnly=repr(self._headOnly))

Anki.Cozmo.ExternalInterface.TrackToObject = TrackToObject
del TrackToObject


class TrackToPet(object):
  "Generated message-passing message."

  __slots__ = (
    '_timeout_sec', # float_32
    '_petID',       # uint_32
    '_petType',     # Anki.Vision.PetType
  )

  @property
  def timeout_sec(self):
    "float_32 timeout_sec struct property."
    return self._timeout_sec

  @timeout_sec.setter
  def timeout_sec(self, value):
    self._timeout_sec = msgbuffers.validate_float(
      'TrackToPet.timeout_sec', value, 'f')

  @property
  def petID(self):
    "uint_32 petID struct property."
    return self._petID

  @petID.setter
  def petID(self, value):
    self._petID = msgbuffers.validate_integer(
      'TrackToPet.petID', value, 0, 4294967295)

  @property
  def petType(self):
    "Anki.Vision.PetType petType struct property."
    return self._petType

  @petType.setter
  def petType(self, value):
    self._petType = msgbuffers.validate_integer(
      'TrackToPet.petType', value, 0, 255)

  def __init__(self, timeout_sec=0.0, petID=0, petType=Anki.Vision.PetType.Unknown):
    self.timeout_sec = timeout_sec
    self.petID = petID
    self.petType = petType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TrackToPet from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TrackToPet.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TrackToPet from the given BinaryReader."
    _timeout_sec = reader.read('f')
    _petID = reader.read('I')
    _petType = reader.read('B')
    return cls(_timeout_sec, _petID, _petType)

  def pack(self):
    "Writes the current TrackToPet, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TrackToPet to the given BinaryWriter."
    writer.write(self._timeout_sec, 'f')
    writer.write(self._petID, 'I')
    writer.write(self._petType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timeout_sec == other._timeout_sec and
        self._petID == other._petID and
        self._petType == other._petType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timeout_sec, 'f') +
      msgbuffers.size(self._petID, 'I') +
      msgbuffers.size(self._petType, 'B'))

  def __str__(self):
    return '{type}(timeout_sec={timeout_sec}, petID={petID}, petType={petType})'.format(
      type=type(self).__name__,
      timeout_sec=self._timeout_sec,
      petID=self._petID,
      petType=self._petType)

  def __repr__(self):
    return '{type}(timeout_sec={timeout_sec}, petID={petID}, petType={petType})'.format(
      type=type(self).__name__,
      timeout_sec=repr(self._timeout_sec),
      petID=repr(self._petID),
      petType=repr(self._petType))

Anki.Cozmo.ExternalInterface.TrackToPet = TrackToPet
del TrackToPet


class TraverseObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_motionProf',     # Anki.Cozmo.PathMotionProfile
    '_usePreDockPose', # bool
    '_useManualSpeed', # bool
  )

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'TraverseObject.motionProf', value, Anki.Cozmo.PathMotionProfile)

  @property
  def usePreDockPose(self):
    "bool usePreDockPose struct property."
    return self._usePreDockPose

  @usePreDockPose.setter
  def usePreDockPose(self, value):
    self._usePreDockPose = msgbuffers.validate_bool(
      'TraverseObject.usePreDockPose', value)

  @property
  def useManualSpeed(self):
    "bool useManualSpeed struct property."
    return self._useManualSpeed

  @useManualSpeed.setter
  def useManualSpeed(self, value):
    self._useManualSpeed = msgbuffers.validate_bool(
      'TraverseObject.useManualSpeed', value)

  def __init__(self, motionProf=Anki.Cozmo.PathMotionProfile(), usePreDockPose=False, useManualSpeed=False):
    self.motionProf = motionProf
    self.usePreDockPose = usePreDockPose
    self.useManualSpeed = useManualSpeed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TraverseObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TraverseObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TraverseObject from the given BinaryReader."
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    _usePreDockPose = bool(reader.read('b'))
    _useManualSpeed = bool(reader.read('b'))
    return cls(_motionProf, _usePreDockPose, _useManualSpeed)

  def pack(self):
    "Writes the current TraverseObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TraverseObject to the given BinaryWriter."
    writer.write_object(self._motionProf)
    writer.write(int(self._usePreDockPose), 'b')
    writer.write(int(self._useManualSpeed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._motionProf == other._motionProf and
        self._usePreDockPose == other._usePreDockPose and
        self._useManualSpeed == other._useManualSpeed)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._motionProf) +
      msgbuffers.size(self._usePreDockPose, 'b') +
      msgbuffers.size(self._useManualSpeed, 'b'))

  def __str__(self):
    return '{type}(motionProf={motionProf}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      motionProf=self._motionProf,
      usePreDockPose=self._usePreDockPose,
      useManualSpeed=self._useManualSpeed)

  def __repr__(self):
    return '{type}(motionProf={motionProf}, usePreDockPose={usePreDockPose}, useManualSpeed={useManualSpeed})'.format(
      type=type(self).__name__,
      motionProf=repr(self._motionProf),
      usePreDockPose=repr(self._usePreDockPose),
      useManualSpeed=repr(self._useManualSpeed))

Anki.Cozmo.ExternalInterface.TraverseObject = TraverseObject
del TraverseObject


class TurnInPlace(object):
  "Generated message-passing message."

  __slots__ = (
    '_angle_rad',          # float_32
    '_speed_rad_per_sec',  # float_32
    '_accel_rad_per_sec2', # float_32
    '_isAbsolute',         # uint_8
    '_robotID',            # uint_8
  )

  @property
  def angle_rad(self):
    "float_32 angle_rad struct property."
    return self._angle_rad

  @angle_rad.setter
  def angle_rad(self, value):
    self._angle_rad = msgbuffers.validate_float(
      'TurnInPlace.angle_rad', value, 'f')

  @property
  def speed_rad_per_sec(self):
    "float_32 speed_rad_per_sec struct property."
    return self._speed_rad_per_sec

  @speed_rad_per_sec.setter
  def speed_rad_per_sec(self, value):
    self._speed_rad_per_sec = msgbuffers.validate_float(
      'TurnInPlace.speed_rad_per_sec', value, 'f')

  @property
  def accel_rad_per_sec2(self):
    "float_32 accel_rad_per_sec2 struct property."
    return self._accel_rad_per_sec2

  @accel_rad_per_sec2.setter
  def accel_rad_per_sec2(self, value):
    self._accel_rad_per_sec2 = msgbuffers.validate_float(
      'TurnInPlace.accel_rad_per_sec2', value, 'f')

  @property
  def isAbsolute(self):
    "uint_8 isAbsolute struct property."
    return self._isAbsolute

  @isAbsolute.setter
  def isAbsolute(self, value):
    self._isAbsolute = msgbuffers.validate_integer(
      'TurnInPlace.isAbsolute', value, 0, 255)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnInPlace.robotID', value, 0, 255)

  def __init__(self, angle_rad=0.0, speed_rad_per_sec=0.0, accel_rad_per_sec2=0.0, isAbsolute=0, robotID=0):
    self.angle_rad = angle_rad
    self.speed_rad_per_sec = speed_rad_per_sec
    self.accel_rad_per_sec2 = accel_rad_per_sec2
    self.isAbsolute = isAbsolute
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnInPlace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnInPlace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnInPlace from the given BinaryReader."
    _angle_rad = reader.read('f')
    _speed_rad_per_sec = reader.read('f')
    _accel_rad_per_sec2 = reader.read('f')
    _isAbsolute = reader.read('B')
    _robotID = reader.read('B')
    return cls(_angle_rad, _speed_rad_per_sec, _accel_rad_per_sec2, _isAbsolute, _robotID)

  def pack(self):
    "Writes the current TurnInPlace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnInPlace to the given BinaryWriter."
    writer.write(self._angle_rad, 'f')
    writer.write(self._speed_rad_per_sec, 'f')
    writer.write(self._accel_rad_per_sec2, 'f')
    writer.write(self._isAbsolute, 'B')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._angle_rad == other._angle_rad and
        self._speed_rad_per_sec == other._speed_rad_per_sec and
        self._accel_rad_per_sec2 == other._accel_rad_per_sec2 and
        self._isAbsolute == other._isAbsolute and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._angle_rad, 'f') +
      msgbuffers.size(self._speed_rad_per_sec, 'f') +
      msgbuffers.size(self._accel_rad_per_sec2, 'f') +
      msgbuffers.size(self._isAbsolute, 'B') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(angle_rad={angle_rad}, speed_rad_per_sec={speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, isAbsolute={isAbsolute}, robotID={robotID})'.format(
      type=type(self).__name__,
      angle_rad=self._angle_rad,
      speed_rad_per_sec=self._speed_rad_per_sec,
      accel_rad_per_sec2=self._accel_rad_per_sec2,
      isAbsolute=self._isAbsolute,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(angle_rad={angle_rad}, speed_rad_per_sec={speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, isAbsolute={isAbsolute}, robotID={robotID})'.format(
      type=type(self).__name__,
      angle_rad=repr(self._angle_rad),
      speed_rad_per_sec=repr(self._speed_rad_per_sec),
      accel_rad_per_sec2=repr(self._accel_rad_per_sec2),
      isAbsolute=repr(self._isAbsolute),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.TurnInPlace = TurnInPlace
del TurnInPlace


class TurnInPlaceAtSpeed(object):
  "Generated message-passing message."

  __slots__ = (
    '_speed_rad_per_sec',  # float_32
    '_accel_rad_per_sec2', # float_32
    '_robotID',            # uint_8
  )

  @property
  def speed_rad_per_sec(self):
    "float_32 speed_rad_per_sec struct property."
    return self._speed_rad_per_sec

  @speed_rad_per_sec.setter
  def speed_rad_per_sec(self, value):
    self._speed_rad_per_sec = msgbuffers.validate_float(
      'TurnInPlaceAtSpeed.speed_rad_per_sec', value, 'f')

  @property
  def accel_rad_per_sec2(self):
    "float_32 accel_rad_per_sec2 struct property."
    return self._accel_rad_per_sec2

  @accel_rad_per_sec2.setter
  def accel_rad_per_sec2(self, value):
    self._accel_rad_per_sec2 = msgbuffers.validate_float(
      'TurnInPlaceAtSpeed.accel_rad_per_sec2', value, 'f')

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnInPlaceAtSpeed.robotID', value, 0, 255)

  def __init__(self, speed_rad_per_sec=0.0, accel_rad_per_sec2=0.0, robotID=0):
    self.speed_rad_per_sec = speed_rad_per_sec
    self.accel_rad_per_sec2 = accel_rad_per_sec2
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnInPlaceAtSpeed from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnInPlaceAtSpeed.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnInPlaceAtSpeed from the given BinaryReader."
    _speed_rad_per_sec = reader.read('f')
    _accel_rad_per_sec2 = reader.read('f')
    _robotID = reader.read('B')
    return cls(_speed_rad_per_sec, _accel_rad_per_sec2, _robotID)

  def pack(self):
    "Writes the current TurnInPlaceAtSpeed, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnInPlaceAtSpeed to the given BinaryWriter."
    writer.write(self._speed_rad_per_sec, 'f')
    writer.write(self._accel_rad_per_sec2, 'f')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._speed_rad_per_sec == other._speed_rad_per_sec and
        self._accel_rad_per_sec2 == other._accel_rad_per_sec2 and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_rad_per_sec, 'f') +
      msgbuffers.size(self._accel_rad_per_sec2, 'f') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, robotID={robotID})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=self._speed_rad_per_sec,
      accel_rad_per_sec2=self._accel_rad_per_sec2,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec}, accel_rad_per_sec2={accel_rad_per_sec2}, robotID={robotID})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=repr(self._speed_rad_per_sec),
      accel_rad_per_sec2=repr(self._accel_rad_per_sec2),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed = TurnInPlaceAtSpeed
del TurnInPlaceAtSpeed


class TurnTowardsFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',                 # int_32
    '_maxTurnAngle_rad',       # float_32
    '_maxPanSpeed_radPerSec',  # float_32
    '_panAccel_radPerSec2',    # float_32
    '_panTolerance_rad',       # float_32
    '_maxTiltSpeed_radPerSec', # float_32
    '_tiltAccel_radPerSec2',   # float_32
    '_tiltTolerance_rad',      # float_32
    '_sayName',                # bool
    '_namedTrigger',           # Anki.Cozmo.AnimationTrigger
    '_unnamedTrigger',         # Anki.Cozmo.AnimationTrigger
    '_robotID',                # uint_8
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'TurnTowardsFace.faceID', value, -2147483648, 2147483647)

  @property
  def maxTurnAngle_rad(self):
    "float_32 maxTurnAngle_rad struct property."
    return self._maxTurnAngle_rad

  @maxTurnAngle_rad.setter
  def maxTurnAngle_rad(self, value):
    self._maxTurnAngle_rad = msgbuffers.validate_float(
      'TurnTowardsFace.maxTurnAngle_rad', value, 'f')

  @property
  def maxPanSpeed_radPerSec(self):
    "float_32 maxPanSpeed_radPerSec struct property."
    return self._maxPanSpeed_radPerSec

  @maxPanSpeed_radPerSec.setter
  def maxPanSpeed_radPerSec(self, value):
    self._maxPanSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsFace.maxPanSpeed_radPerSec', value, 'f')

  @property
  def panAccel_radPerSec2(self):
    "float_32 panAccel_radPerSec2 struct property."
    return self._panAccel_radPerSec2

  @panAccel_radPerSec2.setter
  def panAccel_radPerSec2(self, value):
    self._panAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsFace.panAccel_radPerSec2', value, 'f')

  @property
  def panTolerance_rad(self):
    "float_32 panTolerance_rad struct property."
    return self._panTolerance_rad

  @panTolerance_rad.setter
  def panTolerance_rad(self, value):
    self._panTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsFace.panTolerance_rad', value, 'f')

  @property
  def maxTiltSpeed_radPerSec(self):
    "float_32 maxTiltSpeed_radPerSec struct property."
    return self._maxTiltSpeed_radPerSec

  @maxTiltSpeed_radPerSec.setter
  def maxTiltSpeed_radPerSec(self, value):
    self._maxTiltSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsFace.maxTiltSpeed_radPerSec', value, 'f')

  @property
  def tiltAccel_radPerSec2(self):
    "float_32 tiltAccel_radPerSec2 struct property."
    return self._tiltAccel_radPerSec2

  @tiltAccel_radPerSec2.setter
  def tiltAccel_radPerSec2(self, value):
    self._tiltAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsFace.tiltAccel_radPerSec2', value, 'f')

  @property
  def tiltTolerance_rad(self):
    "float_32 tiltTolerance_rad struct property."
    return self._tiltTolerance_rad

  @tiltTolerance_rad.setter
  def tiltTolerance_rad(self, value):
    self._tiltTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsFace.tiltTolerance_rad', value, 'f')

  @property
  def sayName(self):
    "bool sayName struct property."
    return self._sayName

  @sayName.setter
  def sayName(self, value):
    self._sayName = msgbuffers.validate_bool(
      'TurnTowardsFace.sayName', value)

  @property
  def namedTrigger(self):
    "Anki.Cozmo.AnimationTrigger namedTrigger struct property."
    return self._namedTrigger

  @namedTrigger.setter
  def namedTrigger(self, value):
    self._namedTrigger = msgbuffers.validate_integer(
      'TurnTowardsFace.namedTrigger', value, -2147483648, 2147483647)

  @property
  def unnamedTrigger(self):
    "Anki.Cozmo.AnimationTrigger unnamedTrigger struct property."
    return self._unnamedTrigger

  @unnamedTrigger.setter
  def unnamedTrigger(self, value):
    self._unnamedTrigger = msgbuffers.validate_integer(
      'TurnTowardsFace.unnamedTrigger', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnTowardsFace.robotID', value, 0, 255)

  def __init__(self, faceID=0, maxTurnAngle_rad=0.0, maxPanSpeed_radPerSec=0.0, panAccel_radPerSec2=0.0, panTolerance_rad=0.0, maxTiltSpeed_radPerSec=0.0, tiltAccel_radPerSec2=0.0, tiltTolerance_rad=0.0, sayName=False, namedTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, unnamedTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, robotID=0):
    self.faceID = faceID
    self.maxTurnAngle_rad = maxTurnAngle_rad
    self.maxPanSpeed_radPerSec = maxPanSpeed_radPerSec
    self.panAccel_radPerSec2 = panAccel_radPerSec2
    self.panTolerance_rad = panTolerance_rad
    self.maxTiltSpeed_radPerSec = maxTiltSpeed_radPerSec
    self.tiltAccel_radPerSec2 = tiltAccel_radPerSec2
    self.tiltTolerance_rad = tiltTolerance_rad
    self.sayName = sayName
    self.namedTrigger = namedTrigger
    self.unnamedTrigger = unnamedTrigger
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnTowardsFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnTowardsFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnTowardsFace from the given BinaryReader."
    _faceID = reader.read('i')
    _maxTurnAngle_rad = reader.read('f')
    _maxPanSpeed_radPerSec = reader.read('f')
    _panAccel_radPerSec2 = reader.read('f')
    _panTolerance_rad = reader.read('f')
    _maxTiltSpeed_radPerSec = reader.read('f')
    _tiltAccel_radPerSec2 = reader.read('f')
    _tiltTolerance_rad = reader.read('f')
    _sayName = bool(reader.read('b'))
    _namedTrigger = reader.read('i')
    _unnamedTrigger = reader.read('i')
    _robotID = reader.read('B')
    return cls(_faceID, _maxTurnAngle_rad, _maxPanSpeed_radPerSec, _panAccel_radPerSec2, _panTolerance_rad, _maxTiltSpeed_radPerSec, _tiltAccel_radPerSec2, _tiltTolerance_rad, _sayName, _namedTrigger, _unnamedTrigger, _robotID)

  def pack(self):
    "Writes the current TurnTowardsFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnTowardsFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._maxTurnAngle_rad, 'f')
    writer.write(self._maxPanSpeed_radPerSec, 'f')
    writer.write(self._panAccel_radPerSec2, 'f')
    writer.write(self._panTolerance_rad, 'f')
    writer.write(self._maxTiltSpeed_radPerSec, 'f')
    writer.write(self._tiltAccel_radPerSec2, 'f')
    writer.write(self._tiltTolerance_rad, 'f')
    writer.write(int(self._sayName), 'b')
    writer.write(self._namedTrigger, 'i')
    writer.write(self._unnamedTrigger, 'i')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._maxTurnAngle_rad == other._maxTurnAngle_rad and
        self._maxPanSpeed_radPerSec == other._maxPanSpeed_radPerSec and
        self._panAccel_radPerSec2 == other._panAccel_radPerSec2 and
        self._panTolerance_rad == other._panTolerance_rad and
        self._maxTiltSpeed_radPerSec == other._maxTiltSpeed_radPerSec and
        self._tiltAccel_radPerSec2 == other._tiltAccel_radPerSec2 and
        self._tiltTolerance_rad == other._tiltTolerance_rad and
        self._sayName == other._sayName and
        self._namedTrigger == other._namedTrigger and
        self._unnamedTrigger == other._unnamedTrigger and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._maxTurnAngle_rad, 'f') +
      msgbuffers.size(self._maxPanSpeed_radPerSec, 'f') +
      msgbuffers.size(self._panAccel_radPerSec2, 'f') +
      msgbuffers.size(self._panTolerance_rad, 'f') +
      msgbuffers.size(self._maxTiltSpeed_radPerSec, 'f') +
      msgbuffers.size(self._tiltAccel_radPerSec2, 'f') +
      msgbuffers.size(self._tiltTolerance_rad, 'f') +
      msgbuffers.size(self._sayName, 'b') +
      msgbuffers.size(self._namedTrigger, 'i') +
      msgbuffers.size(self._unnamedTrigger, 'i') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, sayName={sayName}, namedTrigger={namedTrigger}, unnamedTrigger={unnamedTrigger}, robotID={robotID})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      maxTurnAngle_rad=self._maxTurnAngle_rad,
      maxPanSpeed_radPerSec=self._maxPanSpeed_radPerSec,
      panAccel_radPerSec2=self._panAccel_radPerSec2,
      panTolerance_rad=self._panTolerance_rad,
      maxTiltSpeed_radPerSec=self._maxTiltSpeed_radPerSec,
      tiltAccel_radPerSec2=self._tiltAccel_radPerSec2,
      tiltTolerance_rad=self._tiltTolerance_rad,
      sayName=self._sayName,
      namedTrigger=self._namedTrigger,
      unnamedTrigger=self._unnamedTrigger,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(faceID={faceID}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, sayName={sayName}, namedTrigger={namedTrigger}, unnamedTrigger={unnamedTrigger}, robotID={robotID})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      maxTurnAngle_rad=repr(self._maxTurnAngle_rad),
      maxPanSpeed_radPerSec=repr(self._maxPanSpeed_radPerSec),
      panAccel_radPerSec2=repr(self._panAccel_radPerSec2),
      panTolerance_rad=repr(self._panTolerance_rad),
      maxTiltSpeed_radPerSec=repr(self._maxTiltSpeed_radPerSec),
      tiltAccel_radPerSec2=repr(self._tiltAccel_radPerSec2),
      tiltTolerance_rad=repr(self._tiltTolerance_rad),
      sayName=repr(self._sayName),
      namedTrigger=repr(self._namedTrigger),
      unnamedTrigger=repr(self._unnamedTrigger),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.TurnTowardsFace = TurnTowardsFace
del TurnTowardsFace


class TurnTowardsImagePoint(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',              # uint_32
    '_x',                      # float_32
    '_y',                      # float_32
    '_maxPanSpeed_radPerSec',  # float_32
    '_panAccel_radPerSec2',    # float_32
    '_panTolerance_rad',       # float_32
    '_maxTiltSpeed_radPerSec', # float_32
    '_tiltAccel_radPerSec2',   # float_32
    '_tiltTolerance_rad',      # float_32
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'TurnTowardsImagePoint.timestamp', value, 0, 4294967295)

  @property
  def x(self):
    "float_32 x struct property."
    return self._x

  @x.setter
  def x(self, value):
    self._x = msgbuffers.validate_float(
      'TurnTowardsImagePoint.x', value, 'f')

  @property
  def y(self):
    "float_32 y struct property."
    return self._y

  @y.setter
  def y(self, value):
    self._y = msgbuffers.validate_float(
      'TurnTowardsImagePoint.y', value, 'f')

  @property
  def maxPanSpeed_radPerSec(self):
    "float_32 maxPanSpeed_radPerSec struct property."
    return self._maxPanSpeed_radPerSec

  @maxPanSpeed_radPerSec.setter
  def maxPanSpeed_radPerSec(self, value):
    self._maxPanSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsImagePoint.maxPanSpeed_radPerSec', value, 'f')

  @property
  def panAccel_radPerSec2(self):
    "float_32 panAccel_radPerSec2 struct property."
    return self._panAccel_radPerSec2

  @panAccel_radPerSec2.setter
  def panAccel_radPerSec2(self, value):
    self._panAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsImagePoint.panAccel_radPerSec2', value, 'f')

  @property
  def panTolerance_rad(self):
    "float_32 panTolerance_rad struct property."
    return self._panTolerance_rad

  @panTolerance_rad.setter
  def panTolerance_rad(self, value):
    self._panTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsImagePoint.panTolerance_rad', value, 'f')

  @property
  def maxTiltSpeed_radPerSec(self):
    "float_32 maxTiltSpeed_radPerSec struct property."
    return self._maxTiltSpeed_radPerSec

  @maxTiltSpeed_radPerSec.setter
  def maxTiltSpeed_radPerSec(self, value):
    self._maxTiltSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsImagePoint.maxTiltSpeed_radPerSec', value, 'f')

  @property
  def tiltAccel_radPerSec2(self):
    "float_32 tiltAccel_radPerSec2 struct property."
    return self._tiltAccel_radPerSec2

  @tiltAccel_radPerSec2.setter
  def tiltAccel_radPerSec2(self, value):
    self._tiltAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsImagePoint.tiltAccel_radPerSec2', value, 'f')

  @property
  def tiltTolerance_rad(self):
    "float_32 tiltTolerance_rad struct property."
    return self._tiltTolerance_rad

  @tiltTolerance_rad.setter
  def tiltTolerance_rad(self, value):
    self._tiltTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsImagePoint.tiltTolerance_rad', value, 'f')

  def __init__(self, timestamp=0, x=0.0, y=0.0, maxPanSpeed_radPerSec=0.0, panAccel_radPerSec2=0.0, panTolerance_rad=0.0, maxTiltSpeed_radPerSec=0.0, tiltAccel_radPerSec2=0.0, tiltTolerance_rad=0.0):
    self.timestamp = timestamp
    self.x = x
    self.y = y
    self.maxPanSpeed_radPerSec = maxPanSpeed_radPerSec
    self.panAccel_radPerSec2 = panAccel_radPerSec2
    self.panTolerance_rad = panTolerance_rad
    self.maxTiltSpeed_radPerSec = maxTiltSpeed_radPerSec
    self.tiltAccel_radPerSec2 = tiltAccel_radPerSec2
    self.tiltTolerance_rad = tiltTolerance_rad

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnTowardsImagePoint from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnTowardsImagePoint.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnTowardsImagePoint from the given BinaryReader."
    _timestamp = reader.read('I')
    _x = reader.read('f')
    _y = reader.read('f')
    _maxPanSpeed_radPerSec = reader.read('f')
    _panAccel_radPerSec2 = reader.read('f')
    _panTolerance_rad = reader.read('f')
    _maxTiltSpeed_radPerSec = reader.read('f')
    _tiltAccel_radPerSec2 = reader.read('f')
    _tiltTolerance_rad = reader.read('f')
    return cls(_timestamp, _x, _y, _maxPanSpeed_radPerSec, _panAccel_radPerSec2, _panTolerance_rad, _maxTiltSpeed_radPerSec, _tiltAccel_radPerSec2, _tiltTolerance_rad)

  def pack(self):
    "Writes the current TurnTowardsImagePoint, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnTowardsImagePoint to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._x, 'f')
    writer.write(self._y, 'f')
    writer.write(self._maxPanSpeed_radPerSec, 'f')
    writer.write(self._panAccel_radPerSec2, 'f')
    writer.write(self._panTolerance_rad, 'f')
    writer.write(self._maxTiltSpeed_radPerSec, 'f')
    writer.write(self._tiltAccel_radPerSec2, 'f')
    writer.write(self._tiltTolerance_rad, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._x == other._x and
        self._y == other._y and
        self._maxPanSpeed_radPerSec == other._maxPanSpeed_radPerSec and
        self._panAccel_radPerSec2 == other._panAccel_radPerSec2 and
        self._panTolerance_rad == other._panTolerance_rad and
        self._maxTiltSpeed_radPerSec == other._maxTiltSpeed_radPerSec and
        self._tiltAccel_radPerSec2 == other._tiltAccel_radPerSec2 and
        self._tiltTolerance_rad == other._tiltTolerance_rad)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._x, 'f') +
      msgbuffers.size(self._y, 'f') +
      msgbuffers.size(self._maxPanSpeed_radPerSec, 'f') +
      msgbuffers.size(self._panAccel_radPerSec2, 'f') +
      msgbuffers.size(self._panTolerance_rad, 'f') +
      msgbuffers.size(self._maxTiltSpeed_radPerSec, 'f') +
      msgbuffers.size(self._tiltAccel_radPerSec2, 'f') +
      msgbuffers.size(self._tiltTolerance_rad, 'f'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, x={x}, y={y}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      x=self._x,
      y=self._y,
      maxPanSpeed_radPerSec=self._maxPanSpeed_radPerSec,
      panAccel_radPerSec2=self._panAccel_radPerSec2,
      panTolerance_rad=self._panTolerance_rad,
      maxTiltSpeed_radPerSec=self._maxTiltSpeed_radPerSec,
      tiltAccel_radPerSec2=self._tiltAccel_radPerSec2,
      tiltTolerance_rad=self._tiltTolerance_rad)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, x={x}, y={y}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      x=repr(self._x),
      y=repr(self._y),
      maxPanSpeed_radPerSec=repr(self._maxPanSpeed_radPerSec),
      panAccel_radPerSec2=repr(self._panAccel_radPerSec2),
      panTolerance_rad=repr(self._panTolerance_rad),
      maxTiltSpeed_radPerSec=repr(self._maxTiltSpeed_radPerSec),
      tiltAccel_radPerSec2=repr(self._tiltAccel_radPerSec2),
      tiltTolerance_rad=repr(self._tiltTolerance_rad))

Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint = TurnTowardsImagePoint
del TurnTowardsImagePoint


class TurnTowardsLastFacePose(object):
  "Generated message-passing message."

  __slots__ = (
    '_maxTurnAngle_rad',       # float_32
    '_maxPanSpeed_radPerSec',  # float_32
    '_panAccel_radPerSec2',    # float_32
    '_panTolerance_rad',       # float_32
    '_maxTiltSpeed_radPerSec', # float_32
    '_tiltAccel_radPerSec2',   # float_32
    '_tiltTolerance_rad',      # float_32
    '_sayName',                # bool
    '_namedTrigger',           # Anki.Cozmo.AnimationTrigger
    '_unnamedTrigger',         # Anki.Cozmo.AnimationTrigger
    '_robotID',                # uint_8
  )

  @property
  def maxTurnAngle_rad(self):
    "float_32 maxTurnAngle_rad struct property."
    return self._maxTurnAngle_rad

  @maxTurnAngle_rad.setter
  def maxTurnAngle_rad(self, value):
    self._maxTurnAngle_rad = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.maxTurnAngle_rad', value, 'f')

  @property
  def maxPanSpeed_radPerSec(self):
    "float_32 maxPanSpeed_radPerSec struct property."
    return self._maxPanSpeed_radPerSec

  @maxPanSpeed_radPerSec.setter
  def maxPanSpeed_radPerSec(self, value):
    self._maxPanSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.maxPanSpeed_radPerSec', value, 'f')

  @property
  def panAccel_radPerSec2(self):
    "float_32 panAccel_radPerSec2 struct property."
    return self._panAccel_radPerSec2

  @panAccel_radPerSec2.setter
  def panAccel_radPerSec2(self, value):
    self._panAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.panAccel_radPerSec2', value, 'f')

  @property
  def panTolerance_rad(self):
    "float_32 panTolerance_rad struct property."
    return self._panTolerance_rad

  @panTolerance_rad.setter
  def panTolerance_rad(self, value):
    self._panTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.panTolerance_rad', value, 'f')

  @property
  def maxTiltSpeed_radPerSec(self):
    "float_32 maxTiltSpeed_radPerSec struct property."
    return self._maxTiltSpeed_radPerSec

  @maxTiltSpeed_radPerSec.setter
  def maxTiltSpeed_radPerSec(self, value):
    self._maxTiltSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.maxTiltSpeed_radPerSec', value, 'f')

  @property
  def tiltAccel_radPerSec2(self):
    "float_32 tiltAccel_radPerSec2 struct property."
    return self._tiltAccel_radPerSec2

  @tiltAccel_radPerSec2.setter
  def tiltAccel_radPerSec2(self, value):
    self._tiltAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.tiltAccel_radPerSec2', value, 'f')

  @property
  def tiltTolerance_rad(self):
    "float_32 tiltTolerance_rad struct property."
    return self._tiltTolerance_rad

  @tiltTolerance_rad.setter
  def tiltTolerance_rad(self, value):
    self._tiltTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsLastFacePose.tiltTolerance_rad', value, 'f')

  @property
  def sayName(self):
    "bool sayName struct property."
    return self._sayName

  @sayName.setter
  def sayName(self, value):
    self._sayName = msgbuffers.validate_bool(
      'TurnTowardsLastFacePose.sayName', value)

  @property
  def namedTrigger(self):
    "Anki.Cozmo.AnimationTrigger namedTrigger struct property."
    return self._namedTrigger

  @namedTrigger.setter
  def namedTrigger(self, value):
    self._namedTrigger = msgbuffers.validate_integer(
      'TurnTowardsLastFacePose.namedTrigger', value, -2147483648, 2147483647)

  @property
  def unnamedTrigger(self):
    "Anki.Cozmo.AnimationTrigger unnamedTrigger struct property."
    return self._unnamedTrigger

  @unnamedTrigger.setter
  def unnamedTrigger(self, value):
    self._unnamedTrigger = msgbuffers.validate_integer(
      'TurnTowardsLastFacePose.unnamedTrigger', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnTowardsLastFacePose.robotID', value, 0, 255)

  def __init__(self, maxTurnAngle_rad=0.0, maxPanSpeed_radPerSec=0.0, panAccel_radPerSec2=0.0, panTolerance_rad=0.0, maxTiltSpeed_radPerSec=0.0, tiltAccel_radPerSec2=0.0, tiltTolerance_rad=0.0, sayName=False, namedTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, unnamedTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, robotID=0):
    self.maxTurnAngle_rad = maxTurnAngle_rad
    self.maxPanSpeed_radPerSec = maxPanSpeed_radPerSec
    self.panAccel_radPerSec2 = panAccel_radPerSec2
    self.panTolerance_rad = panTolerance_rad
    self.maxTiltSpeed_radPerSec = maxTiltSpeed_radPerSec
    self.tiltAccel_radPerSec2 = tiltAccel_radPerSec2
    self.tiltTolerance_rad = tiltTolerance_rad
    self.sayName = sayName
    self.namedTrigger = namedTrigger
    self.unnamedTrigger = unnamedTrigger
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnTowardsLastFacePose from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnTowardsLastFacePose.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnTowardsLastFacePose from the given BinaryReader."
    _maxTurnAngle_rad = reader.read('f')
    _maxPanSpeed_radPerSec = reader.read('f')
    _panAccel_radPerSec2 = reader.read('f')
    _panTolerance_rad = reader.read('f')
    _maxTiltSpeed_radPerSec = reader.read('f')
    _tiltAccel_radPerSec2 = reader.read('f')
    _tiltTolerance_rad = reader.read('f')
    _sayName = bool(reader.read('b'))
    _namedTrigger = reader.read('i')
    _unnamedTrigger = reader.read('i')
    _robotID = reader.read('B')
    return cls(_maxTurnAngle_rad, _maxPanSpeed_radPerSec, _panAccel_radPerSec2, _panTolerance_rad, _maxTiltSpeed_radPerSec, _tiltAccel_radPerSec2, _tiltTolerance_rad, _sayName, _namedTrigger, _unnamedTrigger, _robotID)

  def pack(self):
    "Writes the current TurnTowardsLastFacePose, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnTowardsLastFacePose to the given BinaryWriter."
    writer.write(self._maxTurnAngle_rad, 'f')
    writer.write(self._maxPanSpeed_radPerSec, 'f')
    writer.write(self._panAccel_radPerSec2, 'f')
    writer.write(self._panTolerance_rad, 'f')
    writer.write(self._maxTiltSpeed_radPerSec, 'f')
    writer.write(self._tiltAccel_radPerSec2, 'f')
    writer.write(self._tiltTolerance_rad, 'f')
    writer.write(int(self._sayName), 'b')
    writer.write(self._namedTrigger, 'i')
    writer.write(self._unnamedTrigger, 'i')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._maxTurnAngle_rad == other._maxTurnAngle_rad and
        self._maxPanSpeed_radPerSec == other._maxPanSpeed_radPerSec and
        self._panAccel_radPerSec2 == other._panAccel_radPerSec2 and
        self._panTolerance_rad == other._panTolerance_rad and
        self._maxTiltSpeed_radPerSec == other._maxTiltSpeed_radPerSec and
        self._tiltAccel_radPerSec2 == other._tiltAccel_radPerSec2 and
        self._tiltTolerance_rad == other._tiltTolerance_rad and
        self._sayName == other._sayName and
        self._namedTrigger == other._namedTrigger and
        self._unnamedTrigger == other._unnamedTrigger and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._maxTurnAngle_rad, 'f') +
      msgbuffers.size(self._maxPanSpeed_radPerSec, 'f') +
      msgbuffers.size(self._panAccel_radPerSec2, 'f') +
      msgbuffers.size(self._panTolerance_rad, 'f') +
      msgbuffers.size(self._maxTiltSpeed_radPerSec, 'f') +
      msgbuffers.size(self._tiltAccel_radPerSec2, 'f') +
      msgbuffers.size(self._tiltTolerance_rad, 'f') +
      msgbuffers.size(self._sayName, 'b') +
      msgbuffers.size(self._namedTrigger, 'i') +
      msgbuffers.size(self._unnamedTrigger, 'i') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, sayName={sayName}, namedTrigger={namedTrigger}, unnamedTrigger={unnamedTrigger}, robotID={robotID})'.format(
      type=type(self).__name__,
      maxTurnAngle_rad=self._maxTurnAngle_rad,
      maxPanSpeed_radPerSec=self._maxPanSpeed_radPerSec,
      panAccel_radPerSec2=self._panAccel_radPerSec2,
      panTolerance_rad=self._panTolerance_rad,
      maxTiltSpeed_radPerSec=self._maxTiltSpeed_radPerSec,
      tiltAccel_radPerSec2=self._tiltAccel_radPerSec2,
      tiltTolerance_rad=self._tiltTolerance_rad,
      sayName=self._sayName,
      namedTrigger=self._namedTrigger,
      unnamedTrigger=self._unnamedTrigger,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, sayName={sayName}, namedTrigger={namedTrigger}, unnamedTrigger={unnamedTrigger}, robotID={robotID})'.format(
      type=type(self).__name__,
      maxTurnAngle_rad=repr(self._maxTurnAngle_rad),
      maxPanSpeed_radPerSec=repr(self._maxPanSpeed_radPerSec),
      panAccel_radPerSec2=repr(self._panAccel_radPerSec2),
      panTolerance_rad=repr(self._panTolerance_rad),
      maxTiltSpeed_radPerSec=repr(self._maxTiltSpeed_radPerSec),
      tiltAccel_radPerSec2=repr(self._tiltAccel_radPerSec2),
      tiltTolerance_rad=repr(self._tiltTolerance_rad),
      sayName=repr(self._sayName),
      namedTrigger=repr(self._namedTrigger),
      unnamedTrigger=repr(self._unnamedTrigger),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose = TurnTowardsLastFacePose
del TurnTowardsLastFacePose


class TurnTowardsObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',               # uint_32
    '_maxTurnAngle_rad',       # float_32
    '_maxPanSpeed_radPerSec',  # float_32
    '_panAccel_radPerSec2',    # float_32
    '_panTolerance_rad',       # float_32
    '_maxTiltSpeed_radPerSec', # float_32
    '_tiltAccel_radPerSec2',   # float_32
    '_tiltTolerance_rad',      # float_32
    '_robotID',                # uint_8
    '_visuallyVerifyWhenDone', # bool
    '_headTrackWhenDone',      # bool
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'TurnTowardsObject.objectID', value, 0, 4294967295)

  @property
  def maxTurnAngle_rad(self):
    "float_32 maxTurnAngle_rad struct property."
    return self._maxTurnAngle_rad

  @maxTurnAngle_rad.setter
  def maxTurnAngle_rad(self, value):
    self._maxTurnAngle_rad = msgbuffers.validate_float(
      'TurnTowardsObject.maxTurnAngle_rad', value, 'f')

  @property
  def maxPanSpeed_radPerSec(self):
    "float_32 maxPanSpeed_radPerSec struct property."
    return self._maxPanSpeed_radPerSec

  @maxPanSpeed_radPerSec.setter
  def maxPanSpeed_radPerSec(self, value):
    self._maxPanSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsObject.maxPanSpeed_radPerSec', value, 'f')

  @property
  def panAccel_radPerSec2(self):
    "float_32 panAccel_radPerSec2 struct property."
    return self._panAccel_radPerSec2

  @panAccel_radPerSec2.setter
  def panAccel_radPerSec2(self, value):
    self._panAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsObject.panAccel_radPerSec2', value, 'f')

  @property
  def panTolerance_rad(self):
    "float_32 panTolerance_rad struct property."
    return self._panTolerance_rad

  @panTolerance_rad.setter
  def panTolerance_rad(self, value):
    self._panTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsObject.panTolerance_rad', value, 'f')

  @property
  def maxTiltSpeed_radPerSec(self):
    "float_32 maxTiltSpeed_radPerSec struct property."
    return self._maxTiltSpeed_radPerSec

  @maxTiltSpeed_radPerSec.setter
  def maxTiltSpeed_radPerSec(self, value):
    self._maxTiltSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsObject.maxTiltSpeed_radPerSec', value, 'f')

  @property
  def tiltAccel_radPerSec2(self):
    "float_32 tiltAccel_radPerSec2 struct property."
    return self._tiltAccel_radPerSec2

  @tiltAccel_radPerSec2.setter
  def tiltAccel_radPerSec2(self, value):
    self._tiltAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsObject.tiltAccel_radPerSec2', value, 'f')

  @property
  def tiltTolerance_rad(self):
    "float_32 tiltTolerance_rad struct property."
    return self._tiltTolerance_rad

  @tiltTolerance_rad.setter
  def tiltTolerance_rad(self, value):
    self._tiltTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsObject.tiltTolerance_rad', value, 'f')

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnTowardsObject.robotID', value, 0, 255)

  @property
  def visuallyVerifyWhenDone(self):
    "bool visuallyVerifyWhenDone struct property."
    return self._visuallyVerifyWhenDone

  @visuallyVerifyWhenDone.setter
  def visuallyVerifyWhenDone(self, value):
    self._visuallyVerifyWhenDone = msgbuffers.validate_bool(
      'TurnTowardsObject.visuallyVerifyWhenDone', value)

  @property
  def headTrackWhenDone(self):
    "bool headTrackWhenDone struct property."
    return self._headTrackWhenDone

  @headTrackWhenDone.setter
  def headTrackWhenDone(self, value):
    self._headTrackWhenDone = msgbuffers.validate_bool(
      'TurnTowardsObject.headTrackWhenDone', value)

  def __init__(self, objectID=0, maxTurnAngle_rad=0.0, maxPanSpeed_radPerSec=0.0, panAccel_radPerSec2=0.0, panTolerance_rad=0.0, maxTiltSpeed_radPerSec=0.0, tiltAccel_radPerSec2=0.0, tiltTolerance_rad=0.0, robotID=0, visuallyVerifyWhenDone=False, headTrackWhenDone=False):
    self.objectID = objectID
    self.maxTurnAngle_rad = maxTurnAngle_rad
    self.maxPanSpeed_radPerSec = maxPanSpeed_radPerSec
    self.panAccel_radPerSec2 = panAccel_radPerSec2
    self.panTolerance_rad = panTolerance_rad
    self.maxTiltSpeed_radPerSec = maxTiltSpeed_radPerSec
    self.tiltAccel_radPerSec2 = tiltAccel_radPerSec2
    self.tiltTolerance_rad = tiltTolerance_rad
    self.robotID = robotID
    self.visuallyVerifyWhenDone = visuallyVerifyWhenDone
    self.headTrackWhenDone = headTrackWhenDone

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnTowardsObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnTowardsObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnTowardsObject from the given BinaryReader."
    _objectID = reader.read('I')
    _maxTurnAngle_rad = reader.read('f')
    _maxPanSpeed_radPerSec = reader.read('f')
    _panAccel_radPerSec2 = reader.read('f')
    _panTolerance_rad = reader.read('f')
    _maxTiltSpeed_radPerSec = reader.read('f')
    _tiltAccel_radPerSec2 = reader.read('f')
    _tiltTolerance_rad = reader.read('f')
    _robotID = reader.read('B')
    _visuallyVerifyWhenDone = bool(reader.read('b'))
    _headTrackWhenDone = bool(reader.read('b'))
    return cls(_objectID, _maxTurnAngle_rad, _maxPanSpeed_radPerSec, _panAccel_radPerSec2, _panTolerance_rad, _maxTiltSpeed_radPerSec, _tiltAccel_radPerSec2, _tiltTolerance_rad, _robotID, _visuallyVerifyWhenDone, _headTrackWhenDone)

  def pack(self):
    "Writes the current TurnTowardsObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnTowardsObject to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._maxTurnAngle_rad, 'f')
    writer.write(self._maxPanSpeed_radPerSec, 'f')
    writer.write(self._panAccel_radPerSec2, 'f')
    writer.write(self._panTolerance_rad, 'f')
    writer.write(self._maxTiltSpeed_radPerSec, 'f')
    writer.write(self._tiltAccel_radPerSec2, 'f')
    writer.write(self._tiltTolerance_rad, 'f')
    writer.write(self._robotID, 'B')
    writer.write(int(self._visuallyVerifyWhenDone), 'b')
    writer.write(int(self._headTrackWhenDone), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._maxTurnAngle_rad == other._maxTurnAngle_rad and
        self._maxPanSpeed_radPerSec == other._maxPanSpeed_radPerSec and
        self._panAccel_radPerSec2 == other._panAccel_radPerSec2 and
        self._panTolerance_rad == other._panTolerance_rad and
        self._maxTiltSpeed_radPerSec == other._maxTiltSpeed_radPerSec and
        self._tiltAccel_radPerSec2 == other._tiltAccel_radPerSec2 and
        self._tiltTolerance_rad == other._tiltTolerance_rad and
        self._robotID == other._robotID and
        self._visuallyVerifyWhenDone == other._visuallyVerifyWhenDone and
        self._headTrackWhenDone == other._headTrackWhenDone)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._maxTurnAngle_rad, 'f') +
      msgbuffers.size(self._maxPanSpeed_radPerSec, 'f') +
      msgbuffers.size(self._panAccel_radPerSec2, 'f') +
      msgbuffers.size(self._panTolerance_rad, 'f') +
      msgbuffers.size(self._maxTiltSpeed_radPerSec, 'f') +
      msgbuffers.size(self._tiltAccel_radPerSec2, 'f') +
      msgbuffers.size(self._tiltTolerance_rad, 'f') +
      msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._visuallyVerifyWhenDone, 'b') +
      msgbuffers.size(self._headTrackWhenDone, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, robotID={robotID}, visuallyVerifyWhenDone={visuallyVerifyWhenDone}, headTrackWhenDone={headTrackWhenDone})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      maxTurnAngle_rad=self._maxTurnAngle_rad,
      maxPanSpeed_radPerSec=self._maxPanSpeed_radPerSec,
      panAccel_radPerSec2=self._panAccel_radPerSec2,
      panTolerance_rad=self._panTolerance_rad,
      maxTiltSpeed_radPerSec=self._maxTiltSpeed_radPerSec,
      tiltAccel_radPerSec2=self._tiltAccel_radPerSec2,
      tiltTolerance_rad=self._tiltTolerance_rad,
      robotID=self._robotID,
      visuallyVerifyWhenDone=self._visuallyVerifyWhenDone,
      headTrackWhenDone=self._headTrackWhenDone)

  def __repr__(self):
    return '{type}(objectID={objectID}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, robotID={robotID}, visuallyVerifyWhenDone={visuallyVerifyWhenDone}, headTrackWhenDone={headTrackWhenDone})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      maxTurnAngle_rad=repr(self._maxTurnAngle_rad),
      maxPanSpeed_radPerSec=repr(self._maxPanSpeed_radPerSec),
      panAccel_radPerSec2=repr(self._panAccel_radPerSec2),
      panTolerance_rad=repr(self._panTolerance_rad),
      maxTiltSpeed_radPerSec=repr(self._maxTiltSpeed_radPerSec),
      tiltAccel_radPerSec2=repr(self._tiltAccel_radPerSec2),
      tiltTolerance_rad=repr(self._tiltTolerance_rad),
      robotID=repr(self._robotID),
      visuallyVerifyWhenDone=repr(self._visuallyVerifyWhenDone),
      headTrackWhenDone=repr(self._headTrackWhenDone))

Anki.Cozmo.ExternalInterface.TurnTowardsObject = TurnTowardsObject
del TurnTowardsObject


class TurnTowardsPose(object):
  "Generated message-passing message."

  __slots__ = (
    '_world_x',                # float_32
    '_world_y',                # float_32
    '_world_z',                # float_32
    '_maxTurnAngle_rad',       # float_32
    '_maxPanSpeed_radPerSec',  # float_32
    '_panAccel_radPerSec2',    # float_32
    '_panTolerance_rad',       # float_32
    '_maxTiltSpeed_radPerSec', # float_32
    '_tiltAccel_radPerSec2',   # float_32
    '_tiltTolerance_rad',      # float_32
    '_robotID',                # uint_8
  )

  @property
  def world_x(self):
    "float_32 world_x struct property."
    return self._world_x

  @world_x.setter
  def world_x(self, value):
    self._world_x = msgbuffers.validate_float(
      'TurnTowardsPose.world_x', value, 'f')

  @property
  def world_y(self):
    "float_32 world_y struct property."
    return self._world_y

  @world_y.setter
  def world_y(self, value):
    self._world_y = msgbuffers.validate_float(
      'TurnTowardsPose.world_y', value, 'f')

  @property
  def world_z(self):
    "float_32 world_z struct property."
    return self._world_z

  @world_z.setter
  def world_z(self, value):
    self._world_z = msgbuffers.validate_float(
      'TurnTowardsPose.world_z', value, 'f')

  @property
  def maxTurnAngle_rad(self):
    "float_32 maxTurnAngle_rad struct property."
    return self._maxTurnAngle_rad

  @maxTurnAngle_rad.setter
  def maxTurnAngle_rad(self, value):
    self._maxTurnAngle_rad = msgbuffers.validate_float(
      'TurnTowardsPose.maxTurnAngle_rad', value, 'f')

  @property
  def maxPanSpeed_radPerSec(self):
    "float_32 maxPanSpeed_radPerSec struct property."
    return self._maxPanSpeed_radPerSec

  @maxPanSpeed_radPerSec.setter
  def maxPanSpeed_radPerSec(self, value):
    self._maxPanSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsPose.maxPanSpeed_radPerSec', value, 'f')

  @property
  def panAccel_radPerSec2(self):
    "float_32 panAccel_radPerSec2 struct property."
    return self._panAccel_radPerSec2

  @panAccel_radPerSec2.setter
  def panAccel_radPerSec2(self, value):
    self._panAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsPose.panAccel_radPerSec2', value, 'f')

  @property
  def panTolerance_rad(self):
    "float_32 panTolerance_rad struct property."
    return self._panTolerance_rad

  @panTolerance_rad.setter
  def panTolerance_rad(self, value):
    self._panTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsPose.panTolerance_rad', value, 'f')

  @property
  def maxTiltSpeed_radPerSec(self):
    "float_32 maxTiltSpeed_radPerSec struct property."
    return self._maxTiltSpeed_radPerSec

  @maxTiltSpeed_radPerSec.setter
  def maxTiltSpeed_radPerSec(self, value):
    self._maxTiltSpeed_radPerSec = msgbuffers.validate_float(
      'TurnTowardsPose.maxTiltSpeed_radPerSec', value, 'f')

  @property
  def tiltAccel_radPerSec2(self):
    "float_32 tiltAccel_radPerSec2 struct property."
    return self._tiltAccel_radPerSec2

  @tiltAccel_radPerSec2.setter
  def tiltAccel_radPerSec2(self, value):
    self._tiltAccel_radPerSec2 = msgbuffers.validate_float(
      'TurnTowardsPose.tiltAccel_radPerSec2', value, 'f')

  @property
  def tiltTolerance_rad(self):
    "float_32 tiltTolerance_rad struct property."
    return self._tiltTolerance_rad

  @tiltTolerance_rad.setter
  def tiltTolerance_rad(self, value):
    self._tiltTolerance_rad = msgbuffers.validate_float(
      'TurnTowardsPose.tiltTolerance_rad', value, 'f')

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'TurnTowardsPose.robotID', value, 0, 255)

  def __init__(self, world_x=0.0, world_y=0.0, world_z=0.0, maxTurnAngle_rad=0.0, maxPanSpeed_radPerSec=0.0, panAccel_radPerSec2=0.0, panTolerance_rad=0.0, maxTiltSpeed_radPerSec=0.0, tiltAccel_radPerSec2=0.0, tiltTolerance_rad=0.0, robotID=0):
    self.world_x = world_x
    self.world_y = world_y
    self.world_z = world_z
    self.maxTurnAngle_rad = maxTurnAngle_rad
    self.maxPanSpeed_radPerSec = maxPanSpeed_radPerSec
    self.panAccel_radPerSec2 = panAccel_radPerSec2
    self.panTolerance_rad = panTolerance_rad
    self.maxTiltSpeed_radPerSec = maxTiltSpeed_radPerSec
    self.tiltAccel_radPerSec2 = tiltAccel_radPerSec2
    self.tiltTolerance_rad = tiltTolerance_rad
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TurnTowardsPose from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TurnTowardsPose.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TurnTowardsPose from the given BinaryReader."
    _world_x = reader.read('f')
    _world_y = reader.read('f')
    _world_z = reader.read('f')
    _maxTurnAngle_rad = reader.read('f')
    _maxPanSpeed_radPerSec = reader.read('f')
    _panAccel_radPerSec2 = reader.read('f')
    _panTolerance_rad = reader.read('f')
    _maxTiltSpeed_radPerSec = reader.read('f')
    _tiltAccel_radPerSec2 = reader.read('f')
    _tiltTolerance_rad = reader.read('f')
    _robotID = reader.read('B')
    return cls(_world_x, _world_y, _world_z, _maxTurnAngle_rad, _maxPanSpeed_radPerSec, _panAccel_radPerSec2, _panTolerance_rad, _maxTiltSpeed_radPerSec, _tiltAccel_radPerSec2, _tiltTolerance_rad, _robotID)

  def pack(self):
    "Writes the current TurnTowardsPose, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TurnTowardsPose to the given BinaryWriter."
    writer.write(self._world_x, 'f')
    writer.write(self._world_y, 'f')
    writer.write(self._world_z, 'f')
    writer.write(self._maxTurnAngle_rad, 'f')
    writer.write(self._maxPanSpeed_radPerSec, 'f')
    writer.write(self._panAccel_radPerSec2, 'f')
    writer.write(self._panTolerance_rad, 'f')
    writer.write(self._maxTiltSpeed_radPerSec, 'f')
    writer.write(self._tiltAccel_radPerSec2, 'f')
    writer.write(self._tiltTolerance_rad, 'f')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._world_x == other._world_x and
        self._world_y == other._world_y and
        self._world_z == other._world_z and
        self._maxTurnAngle_rad == other._maxTurnAngle_rad and
        self._maxPanSpeed_radPerSec == other._maxPanSpeed_radPerSec and
        self._panAccel_radPerSec2 == other._panAccel_radPerSec2 and
        self._panTolerance_rad == other._panTolerance_rad and
        self._maxTiltSpeed_radPerSec == other._maxTiltSpeed_radPerSec and
        self._tiltAccel_radPerSec2 == other._tiltAccel_radPerSec2 and
        self._tiltTolerance_rad == other._tiltTolerance_rad and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._world_x, 'f') +
      msgbuffers.size(self._world_y, 'f') +
      msgbuffers.size(self._world_z, 'f') +
      msgbuffers.size(self._maxTurnAngle_rad, 'f') +
      msgbuffers.size(self._maxPanSpeed_radPerSec, 'f') +
      msgbuffers.size(self._panAccel_radPerSec2, 'f') +
      msgbuffers.size(self._panTolerance_rad, 'f') +
      msgbuffers.size(self._maxTiltSpeed_radPerSec, 'f') +
      msgbuffers.size(self._tiltAccel_radPerSec2, 'f') +
      msgbuffers.size(self._tiltTolerance_rad, 'f') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(world_x={world_x}, world_y={world_y}, world_z={world_z}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, robotID={robotID})'.format(
      type=type(self).__name__,
      world_x=self._world_x,
      world_y=self._world_y,
      world_z=self._world_z,
      maxTurnAngle_rad=self._maxTurnAngle_rad,
      maxPanSpeed_radPerSec=self._maxPanSpeed_radPerSec,
      panAccel_radPerSec2=self._panAccel_radPerSec2,
      panTolerance_rad=self._panTolerance_rad,
      maxTiltSpeed_radPerSec=self._maxTiltSpeed_radPerSec,
      tiltAccel_radPerSec2=self._tiltAccel_radPerSec2,
      tiltTolerance_rad=self._tiltTolerance_rad,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(world_x={world_x}, world_y={world_y}, world_z={world_z}, maxTurnAngle_rad={maxTurnAngle_rad}, maxPanSpeed_radPerSec={maxPanSpeed_radPerSec}, panAccel_radPerSec2={panAccel_radPerSec2}, panTolerance_rad={panTolerance_rad}, maxTiltSpeed_radPerSec={maxTiltSpeed_radPerSec}, tiltAccel_radPerSec2={tiltAccel_radPerSec2}, tiltTolerance_rad={tiltTolerance_rad}, robotID={robotID})'.format(
      type=type(self).__name__,
      world_x=repr(self._world_x),
      world_y=repr(self._world_y),
      world_z=repr(self._world_z),
      maxTurnAngle_rad=repr(self._maxTurnAngle_rad),
      maxPanSpeed_radPerSec=repr(self._maxPanSpeed_radPerSec),
      panAccel_radPerSec2=repr(self._panAccel_radPerSec2),
      panTolerance_rad=repr(self._panTolerance_rad),
      maxTiltSpeed_radPerSec=repr(self._maxTiltSpeed_radPerSec),
      tiltAccel_radPerSec2=repr(self._tiltAccel_radPerSec2),
      tiltTolerance_rad=repr(self._tiltTolerance_rad),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.TurnTowardsPose = TurnTowardsPose
del TurnTowardsPose


class VisuallyVerifyFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',          # int_32
    '_numImagesToWait', # int_32
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'VisuallyVerifyFace.faceID', value, -2147483648, 2147483647)

  @property
  def numImagesToWait(self):
    "int_32 numImagesToWait struct property."
    return self._numImagesToWait

  @numImagesToWait.setter
  def numImagesToWait(self, value):
    self._numImagesToWait = msgbuffers.validate_integer(
      'VisuallyVerifyFace.numImagesToWait', value, -2147483648, 2147483647)

  def __init__(self, faceID=0, numImagesToWait=0):
    self.faceID = faceID
    self.numImagesToWait = numImagesToWait

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisuallyVerifyFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisuallyVerifyFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisuallyVerifyFace from the given BinaryReader."
    _faceID = reader.read('i')
    _numImagesToWait = reader.read('i')
    return cls(_faceID, _numImagesToWait)

  def pack(self):
    "Writes the current VisuallyVerifyFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisuallyVerifyFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._numImagesToWait, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._numImagesToWait == other._numImagesToWait)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._numImagesToWait, 'i'))

  def __str__(self):
    return '{type}(faceID={faceID}, numImagesToWait={numImagesToWait})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      numImagesToWait=self._numImagesToWait)

  def __repr__(self):
    return '{type}(faceID={faceID}, numImagesToWait={numImagesToWait})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      numImagesToWait=repr(self._numImagesToWait))

Anki.Cozmo.ExternalInterface.VisuallyVerifyFace = VisuallyVerifyFace
del VisuallyVerifyFace


class VisuallyVerifyObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',        # uint_32
    '_numImagesToWait', # int_32
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'VisuallyVerifyObject.objectID', value, 0, 4294967295)

  @property
  def numImagesToWait(self):
    "int_32 numImagesToWait struct property."
    return self._numImagesToWait

  @numImagesToWait.setter
  def numImagesToWait(self, value):
    self._numImagesToWait = msgbuffers.validate_integer(
      'VisuallyVerifyObject.numImagesToWait', value, -2147483648, 2147483647)

  def __init__(self, objectID=0, numImagesToWait=0):
    self.objectID = objectID
    self.numImagesToWait = numImagesToWait

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisuallyVerifyObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisuallyVerifyObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisuallyVerifyObject from the given BinaryReader."
    _objectID = reader.read('I')
    _numImagesToWait = reader.read('i')
    return cls(_objectID, _numImagesToWait)

  def pack(self):
    "Writes the current VisuallyVerifyObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisuallyVerifyObject to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._numImagesToWait, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._numImagesToWait == other._numImagesToWait)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._numImagesToWait, 'i'))

  def __str__(self):
    return '{type}(objectID={objectID}, numImagesToWait={numImagesToWait})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      numImagesToWait=self._numImagesToWait)

  def __repr__(self):
    return '{type}(objectID={objectID}, numImagesToWait={numImagesToWait})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      numImagesToWait=repr(self._numImagesToWait))

Anki.Cozmo.ExternalInterface.VisuallyVerifyObject = VisuallyVerifyObject
del VisuallyVerifyObject


class VisuallyVerifyNoObjectAtPose(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_mm',        # float_32
    '_y_mm',        # float_32
    '_z_mm',        # float_32
    '_x_thresh_mm', # float_32
    '_y_thresh_mm', # float_32
    '_z_thresh_mm', # float_32
  )

  @property
  def x_mm(self):
    "float_32 x_mm struct property."
    return self._x_mm

  @x_mm.setter
  def x_mm(self, value):
    self._x_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.x_mm', value, 'f')

  @property
  def y_mm(self):
    "float_32 y_mm struct property."
    return self._y_mm

  @y_mm.setter
  def y_mm(self, value):
    self._y_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.y_mm', value, 'f')

  @property
  def z_mm(self):
    "float_32 z_mm struct property."
    return self._z_mm

  @z_mm.setter
  def z_mm(self, value):
    self._z_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.z_mm', value, 'f')

  @property
  def x_thresh_mm(self):
    "float_32 x_thresh_mm struct property."
    return self._x_thresh_mm

  @x_thresh_mm.setter
  def x_thresh_mm(self, value):
    self._x_thresh_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.x_thresh_mm', value, 'f')

  @property
  def y_thresh_mm(self):
    "float_32 y_thresh_mm struct property."
    return self._y_thresh_mm

  @y_thresh_mm.setter
  def y_thresh_mm(self, value):
    self._y_thresh_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.y_thresh_mm', value, 'f')

  @property
  def z_thresh_mm(self):
    "float_32 z_thresh_mm struct property."
    return self._z_thresh_mm

  @z_thresh_mm.setter
  def z_thresh_mm(self, value):
    self._z_thresh_mm = msgbuffers.validate_float(
      'VisuallyVerifyNoObjectAtPose.z_thresh_mm', value, 'f')

  def __init__(self, x_mm=0.0, y_mm=0.0, z_mm=0.0, x_thresh_mm=10.0, y_thresh_mm=10.0, z_thresh_mm=10.0):
    self.x_mm = x_mm
    self.y_mm = y_mm
    self.z_mm = z_mm
    self.x_thresh_mm = x_thresh_mm
    self.y_thresh_mm = y_thresh_mm
    self.z_thresh_mm = z_thresh_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisuallyVerifyNoObjectAtPose from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisuallyVerifyNoObjectAtPose.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisuallyVerifyNoObjectAtPose from the given BinaryReader."
    _x_mm = reader.read('f')
    _y_mm = reader.read('f')
    _z_mm = reader.read('f')
    _x_thresh_mm = reader.read('f')
    _y_thresh_mm = reader.read('f')
    _z_thresh_mm = reader.read('f')
    return cls(_x_mm, _y_mm, _z_mm, _x_thresh_mm, _y_thresh_mm, _z_thresh_mm)

  def pack(self):
    "Writes the current VisuallyVerifyNoObjectAtPose, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisuallyVerifyNoObjectAtPose to the given BinaryWriter."
    writer.write(self._x_mm, 'f')
    writer.write(self._y_mm, 'f')
    writer.write(self._z_mm, 'f')
    writer.write(self._x_thresh_mm, 'f')
    writer.write(self._y_thresh_mm, 'f')
    writer.write(self._z_thresh_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_mm == other._x_mm and
        self._y_mm == other._y_mm and
        self._z_mm == other._z_mm and
        self._x_thresh_mm == other._x_thresh_mm and
        self._y_thresh_mm == other._y_thresh_mm and
        self._z_thresh_mm == other._z_thresh_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_mm, 'f') +
      msgbuffers.size(self._y_mm, 'f') +
      msgbuffers.size(self._z_mm, 'f') +
      msgbuffers.size(self._x_thresh_mm, 'f') +
      msgbuffers.size(self._y_thresh_mm, 'f') +
      msgbuffers.size(self._z_thresh_mm, 'f'))

  def __str__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, z_mm={z_mm}, x_thresh_mm={x_thresh_mm}, y_thresh_mm={y_thresh_mm}, z_thresh_mm={z_thresh_mm})'.format(
      type=type(self).__name__,
      x_mm=self._x_mm,
      y_mm=self._y_mm,
      z_mm=self._z_mm,
      x_thresh_mm=self._x_thresh_mm,
      y_thresh_mm=self._y_thresh_mm,
      z_thresh_mm=self._z_thresh_mm)

  def __repr__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, z_mm={z_mm}, x_thresh_mm={x_thresh_mm}, y_thresh_mm={y_thresh_mm}, z_thresh_mm={z_thresh_mm})'.format(
      type=type(self).__name__,
      x_mm=repr(self._x_mm),
      y_mm=repr(self._y_mm),
      z_mm=repr(self._z_mm),
      x_thresh_mm=repr(self._x_thresh_mm),
      y_thresh_mm=repr(self._y_thresh_mm),
      z_thresh_mm=repr(self._z_thresh_mm))

Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose = VisuallyVerifyNoObjectAtPose
del VisuallyVerifyNoObjectAtPose


class Wait(object):
  "Generated message-passing message."

  __slots__ = (
    '_time_s', # float_32
  )

  @property
  def time_s(self):
    "float_32 time_s struct property."
    return self._time_s

  @time_s.setter
  def time_s(self, value):
    self._time_s = msgbuffers.validate_float(
      'Wait.time_s', value, 'f')

  def __init__(self, time_s=0.0):
    self.time_s = time_s

  @classmethod
  def unpack(cls, buffer):
    "Reads a new Wait from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('Wait.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new Wait from the given BinaryReader."
    _time_s = reader.read('f')
    return cls(_time_s)

  def pack(self):
    "Writes the current Wait, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current Wait to the given BinaryWriter."
    writer.write(self._time_s, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._time_s == other._time_s
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._time_s, 'f'))

  def __str__(self):
    return '{type}(time_s={time_s})'.format(
      type=type(self).__name__,
      time_s=self._time_s)

  def __repr__(self):
    return '{type}(time_s={time_s})'.format(
      type=type(self).__name__,
      time_s=repr(self._time_s))

Anki.Cozmo.ExternalInterface.Wait = Wait
del Wait


class WaitForImages(object):
  "Generated message-passing message."

  __slots__ = (
    '_numImages',      # uint_32
    '_afterTimeStamp', # uint_32
    '_visionMode',     # Anki.Cozmo.VisionMode
  )

  @property
  def numImages(self):
    "uint_32 numImages struct property."
    return self._numImages

  @numImages.setter
  def numImages(self, value):
    self._numImages = msgbuffers.validate_integer(
      'WaitForImages.numImages', value, 0, 4294967295)

  @property
  def afterTimeStamp(self):
    "uint_32 afterTimeStamp struct property."
    return self._afterTimeStamp

  @afterTimeStamp.setter
  def afterTimeStamp(self, value):
    self._afterTimeStamp = msgbuffers.validate_integer(
      'WaitForImages.afterTimeStamp', value, 0, 4294967295)

  @property
  def visionMode(self):
    "Anki.Cozmo.VisionMode visionMode struct property."
    return self._visionMode

  @visionMode.setter
  def visionMode(self, value):
    self._visionMode = msgbuffers.validate_integer(
      'WaitForImages.visionMode', value, 0, 65535)

  def __init__(self, numImages=0, afterTimeStamp=0, visionMode=Anki.Cozmo.VisionMode.Idle):
    self.numImages = numImages
    self.afterTimeStamp = afterTimeStamp
    self.visionMode = visionMode

  @classmethod
  def unpack(cls, buffer):
    "Reads a new WaitForImages from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('WaitForImages.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new WaitForImages from the given BinaryReader."
    _numImages = reader.read('I')
    _afterTimeStamp = reader.read('I')
    _visionMode = reader.read('H')
    return cls(_numImages, _afterTimeStamp, _visionMode)

  def pack(self):
    "Writes the current WaitForImages, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current WaitForImages to the given BinaryWriter."
    writer.write(self._numImages, 'I')
    writer.write(self._afterTimeStamp, 'I')
    writer.write(self._visionMode, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._numImages == other._numImages and
        self._afterTimeStamp == other._afterTimeStamp and
        self._visionMode == other._visionMode)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._numImages, 'I') +
      msgbuffers.size(self._afterTimeStamp, 'I') +
      msgbuffers.size(self._visionMode, 'H'))

  def __str__(self):
    return '{type}(numImages={numImages}, afterTimeStamp={afterTimeStamp}, visionMode={visionMode})'.format(
      type=type(self).__name__,
      numImages=self._numImages,
      afterTimeStamp=self._afterTimeStamp,
      visionMode=self._visionMode)

  def __repr__(self):
    return '{type}(numImages={numImages}, afterTimeStamp={afterTimeStamp}, visionMode={visionMode})'.format(
      type=type(self).__name__,
      numImages=repr(self._numImages),
      afterTimeStamp=repr(self._afterTimeStamp),
      visionMode=repr(self._visionMode))

Anki.Cozmo.ExternalInterface.WaitForImages = WaitForImages
del WaitForImages


class RobotActionUnion(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    alignWithObject              = 0  # Anki.Cozmo.ExternalInterface.AlignWithObject
    calibrateMotors              = 1  # Anki.Cozmo.ExternalInterface.CalibrateMotors
    displayFaceImage             = 2  # Anki.Cozmo.ExternalInterface.DisplayFaceImage
    displayProceduralFace        = 3  # Anki.Cozmo.ExternalInterface.DisplayProceduralFace
    driveOffChargerContacts      = 4  # Anki.Cozmo.ExternalInterface.DriveOffChargerContacts
    driveStraight                = 5  # Anki.Cozmo.ExternalInterface.DriveStraight
    enrollNamedFace              = 6  # Anki.Cozmo.ExternalInterface.EnrollNamedFace
    facePlant                    = 7  # Anki.Cozmo.ExternalInterface.FacePlant
    flipBlock                    = 8  # Anki.Cozmo.ExternalInterface.FlipBlock
    gotoObject                   = 9  # Anki.Cozmo.ExternalInterface.GotoObject
    gotoPose                     = 10 # Anki.Cozmo.ExternalInterface.GotoPose
    mountCharger                 = 11 # Anki.Cozmo.ExternalInterface.MountCharger
    panAndTilt                   = 12 # Anki.Cozmo.ExternalInterface.PanAndTilt
    pickupObject                 = 13 # Anki.Cozmo.ExternalInterface.PickupObject
    placeObjectOnGround          = 14 # Anki.Cozmo.ExternalInterface.PlaceObjectOnGround
    placeObjectOnGroundHere      = 15 # Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere
    placeOnObject                = 16 # Anki.Cozmo.ExternalInterface.PlaceOnObject
    placeRelObject               = 17 # Anki.Cozmo.ExternalInterface.PlaceRelObject
    playAnimation                = 18 # Anki.Cozmo.ExternalInterface.PlayAnimation
    playAnimationTrigger         = 19 # Anki.Cozmo.ExternalInterface.PlayAnimationTrigger
    popAWheelie                  = 20 # Anki.Cozmo.ExternalInterface.PopAWheelie
    readToolCode                 = 21 # Anki.Cozmo.ExternalInterface.ReadToolCode
    realignWithObject            = 22 # Anki.Cozmo.ExternalInterface.RealignWithObject
    rollObject                   = 23 # Anki.Cozmo.ExternalInterface.RollObject
    sayText                      = 24 # Anki.Cozmo.ExternalInterface.SayText
    sayTextWithIntent            = 25 # Anki.Cozmo.ExternalInterface.SayTextWithIntent
    searchForNearbyObject        = 26 # Anki.Cozmo.ExternalInterface.SearchForNearbyObject
    setHeadAngle                 = 27 # Anki.Cozmo.ExternalInterface.SetHeadAngle
    setLiftHeight                = 28 # Anki.Cozmo.ExternalInterface.SetLiftHeight
    trackFace                    = 29 # Anki.Cozmo.ExternalInterface.TrackToFace
    trackObject                  = 30 # Anki.Cozmo.ExternalInterface.TrackToObject
    trackPet                     = 31 # Anki.Cozmo.ExternalInterface.TrackToPet
    traverseObject               = 32 # Anki.Cozmo.ExternalInterface.TraverseObject
    turnInPlace                  = 33 # Anki.Cozmo.ExternalInterface.TurnInPlace
    turnTowardsFace              = 34 # Anki.Cozmo.ExternalInterface.TurnTowardsFace
    turnTowardsImagePoint        = 35 # Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint
    turnTowardsLastFacePose      = 36 # Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose
    turnTowardsObject            = 37 # Anki.Cozmo.ExternalInterface.TurnTowardsObject
    turnTowardsPose              = 38 # Anki.Cozmo.ExternalInterface.TurnTowardsPose
    visuallyVerifyFace           = 39 # Anki.Cozmo.ExternalInterface.VisuallyVerifyFace
    visuallyVerifyNoObjectAtPose = 40 # Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose
    visuallyVerifyObject         = 41 # Anki.Cozmo.ExternalInterface.VisuallyVerifyObject
    wait                         = 42 # Anki.Cozmo.ExternalInterface.Wait
    waitForImages                = 43 # Anki.Cozmo.ExternalInterface.WaitForImages
    count                        = 44 # uint_8

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def alignWithObject(self):
    "Anki.Cozmo.ExternalInterface.AlignWithObject alignWithObject union property."
    msgbuffers.safety_check_tag('alignWithObject', self._tag, self.Tag.alignWithObject, self._tags_by_value)
    return self._data

  @alignWithObject.setter
  def alignWithObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.alignWithObject', value, Anki.Cozmo.ExternalInterface.AlignWithObject)
    self._tag = self.Tag.alignWithObject

  @property
  def calibrateMotors(self):
    "Anki.Cozmo.ExternalInterface.CalibrateMotors calibrateMotors union property."
    msgbuffers.safety_check_tag('calibrateMotors', self._tag, self.Tag.calibrateMotors, self._tags_by_value)
    return self._data

  @calibrateMotors.setter
  def calibrateMotors(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.calibrateMotors', value, Anki.Cozmo.ExternalInterface.CalibrateMotors)
    self._tag = self.Tag.calibrateMotors

  @property
  def displayFaceImage(self):
    "Anki.Cozmo.ExternalInterface.DisplayFaceImage displayFaceImage union property."
    msgbuffers.safety_check_tag('displayFaceImage', self._tag, self.Tag.displayFaceImage, self._tags_by_value)
    return self._data

  @displayFaceImage.setter
  def displayFaceImage(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.displayFaceImage', value, Anki.Cozmo.ExternalInterface.DisplayFaceImage)
    self._tag = self.Tag.displayFaceImage

  @property
  def displayProceduralFace(self):
    "Anki.Cozmo.ExternalInterface.DisplayProceduralFace displayProceduralFace union property."
    msgbuffers.safety_check_tag('displayProceduralFace', self._tag, self.Tag.displayProceduralFace, self._tags_by_value)
    return self._data

  @displayProceduralFace.setter
  def displayProceduralFace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.displayProceduralFace', value, Anki.Cozmo.ExternalInterface.DisplayProceduralFace)
    self._tag = self.Tag.displayProceduralFace

  @property
  def driveOffChargerContacts(self):
    "Anki.Cozmo.ExternalInterface.DriveOffChargerContacts driveOffChargerContacts union property."
    msgbuffers.safety_check_tag('driveOffChargerContacts', self._tag, self.Tag.driveOffChargerContacts, self._tags_by_value)
    return self._data

  @driveOffChargerContacts.setter
  def driveOffChargerContacts(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.driveOffChargerContacts', value, Anki.Cozmo.ExternalInterface.DriveOffChargerContacts)
    self._tag = self.Tag.driveOffChargerContacts

  @property
  def driveStraight(self):
    "Anki.Cozmo.ExternalInterface.DriveStraight driveStraight union property."
    msgbuffers.safety_check_tag('driveStraight', self._tag, self.Tag.driveStraight, self._tags_by_value)
    return self._data

  @driveStraight.setter
  def driveStraight(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.driveStraight', value, Anki.Cozmo.ExternalInterface.DriveStraight)
    self._tag = self.Tag.driveStraight

  @property
  def enrollNamedFace(self):
    "Anki.Cozmo.ExternalInterface.EnrollNamedFace enrollNamedFace union property."
    msgbuffers.safety_check_tag('enrollNamedFace', self._tag, self.Tag.enrollNamedFace, self._tags_by_value)
    return self._data

  @enrollNamedFace.setter
  def enrollNamedFace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.enrollNamedFace', value, Anki.Cozmo.ExternalInterface.EnrollNamedFace)
    self._tag = self.Tag.enrollNamedFace

  @property
  def facePlant(self):
    "Anki.Cozmo.ExternalInterface.FacePlant facePlant union property."
    msgbuffers.safety_check_tag('facePlant', self._tag, self.Tag.facePlant, self._tags_by_value)
    return self._data

  @facePlant.setter
  def facePlant(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.facePlant', value, Anki.Cozmo.ExternalInterface.FacePlant)
    self._tag = self.Tag.facePlant

  @property
  def flipBlock(self):
    "Anki.Cozmo.ExternalInterface.FlipBlock flipBlock union property."
    msgbuffers.safety_check_tag('flipBlock', self._tag, self.Tag.flipBlock, self._tags_by_value)
    return self._data

  @flipBlock.setter
  def flipBlock(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.flipBlock', value, Anki.Cozmo.ExternalInterface.FlipBlock)
    self._tag = self.Tag.flipBlock

  @property
  def gotoObject(self):
    "Anki.Cozmo.ExternalInterface.GotoObject gotoObject union property."
    msgbuffers.safety_check_tag('gotoObject', self._tag, self.Tag.gotoObject, self._tags_by_value)
    return self._data

  @gotoObject.setter
  def gotoObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.gotoObject', value, Anki.Cozmo.ExternalInterface.GotoObject)
    self._tag = self.Tag.gotoObject

  @property
  def gotoPose(self):
    "Anki.Cozmo.ExternalInterface.GotoPose gotoPose union property."
    msgbuffers.safety_check_tag('gotoPose', self._tag, self.Tag.gotoPose, self._tags_by_value)
    return self._data

  @gotoPose.setter
  def gotoPose(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.gotoPose', value, Anki.Cozmo.ExternalInterface.GotoPose)
    self._tag = self.Tag.gotoPose

  @property
  def mountCharger(self):
    "Anki.Cozmo.ExternalInterface.MountCharger mountCharger union property."
    msgbuffers.safety_check_tag('mountCharger', self._tag, self.Tag.mountCharger, self._tags_by_value)
    return self._data

  @mountCharger.setter
  def mountCharger(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.mountCharger', value, Anki.Cozmo.ExternalInterface.MountCharger)
    self._tag = self.Tag.mountCharger

  @property
  def panAndTilt(self):
    "Anki.Cozmo.ExternalInterface.PanAndTilt panAndTilt union property."
    msgbuffers.safety_check_tag('panAndTilt', self._tag, self.Tag.panAndTilt, self._tags_by_value)
    return self._data

  @panAndTilt.setter
  def panAndTilt(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.panAndTilt', value, Anki.Cozmo.ExternalInterface.PanAndTilt)
    self._tag = self.Tag.panAndTilt

  @property
  def pickupObject(self):
    "Anki.Cozmo.ExternalInterface.PickupObject pickupObject union property."
    msgbuffers.safety_check_tag('pickupObject', self._tag, self.Tag.pickupObject, self._tags_by_value)
    return self._data

  @pickupObject.setter
  def pickupObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.pickupObject', value, Anki.Cozmo.ExternalInterface.PickupObject)
    self._tag = self.Tag.pickupObject

  @property
  def placeObjectOnGround(self):
    "Anki.Cozmo.ExternalInterface.PlaceObjectOnGround placeObjectOnGround union property."
    msgbuffers.safety_check_tag('placeObjectOnGround', self._tag, self.Tag.placeObjectOnGround, self._tags_by_value)
    return self._data

  @placeObjectOnGround.setter
  def placeObjectOnGround(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.placeObjectOnGround', value, Anki.Cozmo.ExternalInterface.PlaceObjectOnGround)
    self._tag = self.Tag.placeObjectOnGround

  @property
  def placeObjectOnGroundHere(self):
    "Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere placeObjectOnGroundHere union property."
    msgbuffers.safety_check_tag('placeObjectOnGroundHere', self._tag, self.Tag.placeObjectOnGroundHere, self._tags_by_value)
    return self._data

  @placeObjectOnGroundHere.setter
  def placeObjectOnGroundHere(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.placeObjectOnGroundHere', value, Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere)
    self._tag = self.Tag.placeObjectOnGroundHere

  @property
  def placeOnObject(self):
    "Anki.Cozmo.ExternalInterface.PlaceOnObject placeOnObject union property."
    msgbuffers.safety_check_tag('placeOnObject', self._tag, self.Tag.placeOnObject, self._tags_by_value)
    return self._data

  @placeOnObject.setter
  def placeOnObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.placeOnObject', value, Anki.Cozmo.ExternalInterface.PlaceOnObject)
    self._tag = self.Tag.placeOnObject

  @property
  def placeRelObject(self):
    "Anki.Cozmo.ExternalInterface.PlaceRelObject placeRelObject union property."
    msgbuffers.safety_check_tag('placeRelObject', self._tag, self.Tag.placeRelObject, self._tags_by_value)
    return self._data

  @placeRelObject.setter
  def placeRelObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.placeRelObject', value, Anki.Cozmo.ExternalInterface.PlaceRelObject)
    self._tag = self.Tag.placeRelObject

  @property
  def playAnimation(self):
    "Anki.Cozmo.ExternalInterface.PlayAnimation playAnimation union property."
    msgbuffers.safety_check_tag('playAnimation', self._tag, self.Tag.playAnimation, self._tags_by_value)
    return self._data

  @playAnimation.setter
  def playAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.playAnimation', value, Anki.Cozmo.ExternalInterface.PlayAnimation)
    self._tag = self.Tag.playAnimation

  @property
  def playAnimationTrigger(self):
    "Anki.Cozmo.ExternalInterface.PlayAnimationTrigger playAnimationTrigger union property."
    msgbuffers.safety_check_tag('playAnimationTrigger', self._tag, self.Tag.playAnimationTrigger, self._tags_by_value)
    return self._data

  @playAnimationTrigger.setter
  def playAnimationTrigger(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.playAnimationTrigger', value, Anki.Cozmo.ExternalInterface.PlayAnimationTrigger)
    self._tag = self.Tag.playAnimationTrigger

  @property
  def popAWheelie(self):
    "Anki.Cozmo.ExternalInterface.PopAWheelie popAWheelie union property."
    msgbuffers.safety_check_tag('popAWheelie', self._tag, self.Tag.popAWheelie, self._tags_by_value)
    return self._data

  @popAWheelie.setter
  def popAWheelie(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.popAWheelie', value, Anki.Cozmo.ExternalInterface.PopAWheelie)
    self._tag = self.Tag.popAWheelie

  @property
  def readToolCode(self):
    "Anki.Cozmo.ExternalInterface.ReadToolCode readToolCode union property."
    msgbuffers.safety_check_tag('readToolCode', self._tag, self.Tag.readToolCode, self._tags_by_value)
    return self._data

  @readToolCode.setter
  def readToolCode(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.readToolCode', value, Anki.Cozmo.ExternalInterface.ReadToolCode)
    self._tag = self.Tag.readToolCode

  @property
  def realignWithObject(self):
    "Anki.Cozmo.ExternalInterface.RealignWithObject realignWithObject union property."
    msgbuffers.safety_check_tag('realignWithObject', self._tag, self.Tag.realignWithObject, self._tags_by_value)
    return self._data

  @realignWithObject.setter
  def realignWithObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.realignWithObject', value, Anki.Cozmo.ExternalInterface.RealignWithObject)
    self._tag = self.Tag.realignWithObject

  @property
  def rollObject(self):
    "Anki.Cozmo.ExternalInterface.RollObject rollObject union property."
    msgbuffers.safety_check_tag('rollObject', self._tag, self.Tag.rollObject, self._tags_by_value)
    return self._data

  @rollObject.setter
  def rollObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.rollObject', value, Anki.Cozmo.ExternalInterface.RollObject)
    self._tag = self.Tag.rollObject

  @property
  def sayText(self):
    "Anki.Cozmo.ExternalInterface.SayText sayText union property."
    msgbuffers.safety_check_tag('sayText', self._tag, self.Tag.sayText, self._tags_by_value)
    return self._data

  @sayText.setter
  def sayText(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.sayText', value, Anki.Cozmo.ExternalInterface.SayText)
    self._tag = self.Tag.sayText

  @property
  def sayTextWithIntent(self):
    "Anki.Cozmo.ExternalInterface.SayTextWithIntent sayTextWithIntent union property."
    msgbuffers.safety_check_tag('sayTextWithIntent', self._tag, self.Tag.sayTextWithIntent, self._tags_by_value)
    return self._data

  @sayTextWithIntent.setter
  def sayTextWithIntent(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.sayTextWithIntent', value, Anki.Cozmo.ExternalInterface.SayTextWithIntent)
    self._tag = self.Tag.sayTextWithIntent

  @property
  def searchForNearbyObject(self):
    "Anki.Cozmo.ExternalInterface.SearchForNearbyObject searchForNearbyObject union property."
    msgbuffers.safety_check_tag('searchForNearbyObject', self._tag, self.Tag.searchForNearbyObject, self._tags_by_value)
    return self._data

  @searchForNearbyObject.setter
  def searchForNearbyObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.searchForNearbyObject', value, Anki.Cozmo.ExternalInterface.SearchForNearbyObject)
    self._tag = self.Tag.searchForNearbyObject

  @property
  def setHeadAngle(self):
    "Anki.Cozmo.ExternalInterface.SetHeadAngle setHeadAngle union property."
    msgbuffers.safety_check_tag('setHeadAngle', self._tag, self.Tag.setHeadAngle, self._tags_by_value)
    return self._data

  @setHeadAngle.setter
  def setHeadAngle(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.setHeadAngle', value, Anki.Cozmo.ExternalInterface.SetHeadAngle)
    self._tag = self.Tag.setHeadAngle

  @property
  def setLiftHeight(self):
    "Anki.Cozmo.ExternalInterface.SetLiftHeight setLiftHeight union property."
    msgbuffers.safety_check_tag('setLiftHeight', self._tag, self.Tag.setLiftHeight, self._tags_by_value)
    return self._data

  @setLiftHeight.setter
  def setLiftHeight(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.setLiftHeight', value, Anki.Cozmo.ExternalInterface.SetLiftHeight)
    self._tag = self.Tag.setLiftHeight

  @property
  def trackFace(self):
    "Anki.Cozmo.ExternalInterface.TrackToFace trackFace union property."
    msgbuffers.safety_check_tag('trackFace', self._tag, self.Tag.trackFace, self._tags_by_value)
    return self._data

  @trackFace.setter
  def trackFace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.trackFace', value, Anki.Cozmo.ExternalInterface.TrackToFace)
    self._tag = self.Tag.trackFace

  @property
  def trackObject(self):
    "Anki.Cozmo.ExternalInterface.TrackToObject trackObject union property."
    msgbuffers.safety_check_tag('trackObject', self._tag, self.Tag.trackObject, self._tags_by_value)
    return self._data

  @trackObject.setter
  def trackObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.trackObject', value, Anki.Cozmo.ExternalInterface.TrackToObject)
    self._tag = self.Tag.trackObject

  @property
  def trackPet(self):
    "Anki.Cozmo.ExternalInterface.TrackToPet trackPet union property."
    msgbuffers.safety_check_tag('trackPet', self._tag, self.Tag.trackPet, self._tags_by_value)
    return self._data

  @trackPet.setter
  def trackPet(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.trackPet', value, Anki.Cozmo.ExternalInterface.TrackToPet)
    self._tag = self.Tag.trackPet

  @property
  def traverseObject(self):
    "Anki.Cozmo.ExternalInterface.TraverseObject traverseObject union property."
    msgbuffers.safety_check_tag('traverseObject', self._tag, self.Tag.traverseObject, self._tags_by_value)
    return self._data

  @traverseObject.setter
  def traverseObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.traverseObject', value, Anki.Cozmo.ExternalInterface.TraverseObject)
    self._tag = self.Tag.traverseObject

  @property
  def turnInPlace(self):
    "Anki.Cozmo.ExternalInterface.TurnInPlace turnInPlace union property."
    msgbuffers.safety_check_tag('turnInPlace', self._tag, self.Tag.turnInPlace, self._tags_by_value)
    return self._data

  @turnInPlace.setter
  def turnInPlace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnInPlace', value, Anki.Cozmo.ExternalInterface.TurnInPlace)
    self._tag = self.Tag.turnInPlace

  @property
  def turnTowardsFace(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsFace turnTowardsFace union property."
    msgbuffers.safety_check_tag('turnTowardsFace', self._tag, self.Tag.turnTowardsFace, self._tags_by_value)
    return self._data

  @turnTowardsFace.setter
  def turnTowardsFace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnTowardsFace', value, Anki.Cozmo.ExternalInterface.TurnTowardsFace)
    self._tag = self.Tag.turnTowardsFace

  @property
  def turnTowardsImagePoint(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint turnTowardsImagePoint union property."
    msgbuffers.safety_check_tag('turnTowardsImagePoint', self._tag, self.Tag.turnTowardsImagePoint, self._tags_by_value)
    return self._data

  @turnTowardsImagePoint.setter
  def turnTowardsImagePoint(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnTowardsImagePoint', value, Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint)
    self._tag = self.Tag.turnTowardsImagePoint

  @property
  def turnTowardsLastFacePose(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose turnTowardsLastFacePose union property."
    msgbuffers.safety_check_tag('turnTowardsLastFacePose', self._tag, self.Tag.turnTowardsLastFacePose, self._tags_by_value)
    return self._data

  @turnTowardsLastFacePose.setter
  def turnTowardsLastFacePose(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnTowardsLastFacePose', value, Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose)
    self._tag = self.Tag.turnTowardsLastFacePose

  @property
  def turnTowardsObject(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsObject turnTowardsObject union property."
    msgbuffers.safety_check_tag('turnTowardsObject', self._tag, self.Tag.turnTowardsObject, self._tags_by_value)
    return self._data

  @turnTowardsObject.setter
  def turnTowardsObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnTowardsObject', value, Anki.Cozmo.ExternalInterface.TurnTowardsObject)
    self._tag = self.Tag.turnTowardsObject

  @property
  def turnTowardsPose(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsPose turnTowardsPose union property."
    msgbuffers.safety_check_tag('turnTowardsPose', self._tag, self.Tag.turnTowardsPose, self._tags_by_value)
    return self._data

  @turnTowardsPose.setter
  def turnTowardsPose(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.turnTowardsPose', value, Anki.Cozmo.ExternalInterface.TurnTowardsPose)
    self._tag = self.Tag.turnTowardsPose

  @property
  def visuallyVerifyFace(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyFace visuallyVerifyFace union property."
    msgbuffers.safety_check_tag('visuallyVerifyFace', self._tag, self.Tag.visuallyVerifyFace, self._tags_by_value)
    return self._data

  @visuallyVerifyFace.setter
  def visuallyVerifyFace(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.visuallyVerifyFace', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyFace)
    self._tag = self.Tag.visuallyVerifyFace

  @property
  def visuallyVerifyNoObjectAtPose(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose visuallyVerifyNoObjectAtPose union property."
    msgbuffers.safety_check_tag('visuallyVerifyNoObjectAtPose', self._tag, self.Tag.visuallyVerifyNoObjectAtPose, self._tags_by_value)
    return self._data

  @visuallyVerifyNoObjectAtPose.setter
  def visuallyVerifyNoObjectAtPose(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.visuallyVerifyNoObjectAtPose', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose)
    self._tag = self.Tag.visuallyVerifyNoObjectAtPose

  @property
  def visuallyVerifyObject(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyObject visuallyVerifyObject union property."
    msgbuffers.safety_check_tag('visuallyVerifyObject', self._tag, self.Tag.visuallyVerifyObject, self._tags_by_value)
    return self._data

  @visuallyVerifyObject.setter
  def visuallyVerifyObject(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.visuallyVerifyObject', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyObject)
    self._tag = self.Tag.visuallyVerifyObject

  @property
  def wait(self):
    "Anki.Cozmo.ExternalInterface.Wait wait union property."
    msgbuffers.safety_check_tag('wait', self._tag, self.Tag.wait, self._tags_by_value)
    return self._data

  @wait.setter
  def wait(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.wait', value, Anki.Cozmo.ExternalInterface.Wait)
    self._tag = self.Tag.wait

  @property
  def waitForImages(self):
    "Anki.Cozmo.ExternalInterface.WaitForImages waitForImages union property."
    msgbuffers.safety_check_tag('waitForImages', self._tag, self.Tag.waitForImages, self._tags_by_value)
    return self._data

  @waitForImages.setter
  def waitForImages(self, value):
    self._data = msgbuffers.validate_object(
      'RobotActionUnion.waitForImages', value, Anki.Cozmo.ExternalInterface.WaitForImages)
    self._tag = self.Tag.waitForImages

  @property
  def count(self):
    "uint_8 count union property."
    msgbuffers.safety_check_tag('count', self._tag, self.Tag.count, self._tags_by_value)
    return self._data

  @count.setter
  def count(self, value):
    self._data = msgbuffers.validate_integer(
      'RobotActionUnion.count', value, 0, 255)
    self._tag = self.Tag.count

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotActionUnion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotActionUnion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotActionUnion from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('RobotActionUnion attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current RobotActionUnion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty RobotActionUnion.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 45:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 45:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 45:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    alignWithObject=0,
    calibrateMotors=1,
    displayFaceImage=2,
    displayProceduralFace=3,
    driveOffChargerContacts=4,
    driveStraight=5,
    enrollNamedFace=6,
    facePlant=7,
    flipBlock=8,
    gotoObject=9,
    gotoPose=10,
    mountCharger=11,
    panAndTilt=12,
    pickupObject=13,
    placeObjectOnGround=14,
    placeObjectOnGroundHere=15,
    placeOnObject=16,
    placeRelObject=17,
    playAnimation=18,
    playAnimationTrigger=19,
    popAWheelie=20,
    readToolCode=21,
    realignWithObject=22,
    rollObject=23,
    sayText=24,
    sayTextWithIntent=25,
    searchForNearbyObject=26,
    setHeadAngle=27,
    setLiftHeight=28,
    trackFace=29,
    trackObject=30,
    trackPet=31,
    traverseObject=32,
    turnInPlace=33,
    turnTowardsFace=34,
    turnTowardsImagePoint=35,
    turnTowardsLastFacePose=36,
    turnTowardsObject=37,
    turnTowardsPose=38,
    visuallyVerifyFace=39,
    visuallyVerifyNoObjectAtPose=40,
    visuallyVerifyObject=41,
    wait=42,
    waitForImages=43,
    count=44,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'alignWithObject'
  _tags_by_value[1] = 'calibrateMotors'
  _tags_by_value[2] = 'displayFaceImage'
  _tags_by_value[3] = 'displayProceduralFace'
  _tags_by_value[4] = 'driveOffChargerContacts'
  _tags_by_value[5] = 'driveStraight'
  _tags_by_value[6] = 'enrollNamedFace'
  _tags_by_value[7] = 'facePlant'
  _tags_by_value[8] = 'flipBlock'
  _tags_by_value[9] = 'gotoObject'
  _tags_by_value[10] = 'gotoPose'
  _tags_by_value[11] = 'mountCharger'
  _tags_by_value[12] = 'panAndTilt'
  _tags_by_value[13] = 'pickupObject'
  _tags_by_value[14] = 'placeObjectOnGround'
  _tags_by_value[15] = 'placeObjectOnGroundHere'
  _tags_by_value[16] = 'placeOnObject'
  _tags_by_value[17] = 'placeRelObject'
  _tags_by_value[18] = 'playAnimation'
  _tags_by_value[19] = 'playAnimationTrigger'
  _tags_by_value[20] = 'popAWheelie'
  _tags_by_value[21] = 'readToolCode'
  _tags_by_value[22] = 'realignWithObject'
  _tags_by_value[23] = 'rollObject'
  _tags_by_value[24] = 'sayText'
  _tags_by_value[25] = 'sayTextWithIntent'
  _tags_by_value[26] = 'searchForNearbyObject'
  _tags_by_value[27] = 'setHeadAngle'
  _tags_by_value[28] = 'setLiftHeight'
  _tags_by_value[29] = 'trackFace'
  _tags_by_value[30] = 'trackObject'
  _tags_by_value[31] = 'trackPet'
  _tags_by_value[32] = 'traverseObject'
  _tags_by_value[33] = 'turnInPlace'
  _tags_by_value[34] = 'turnTowardsFace'
  _tags_by_value[35] = 'turnTowardsImagePoint'
  _tags_by_value[36] = 'turnTowardsLastFacePose'
  _tags_by_value[37] = 'turnTowardsObject'
  _tags_by_value[38] = 'turnTowardsPose'
  _tags_by_value[39] = 'visuallyVerifyFace'
  _tags_by_value[40] = 'visuallyVerifyNoObjectAtPose'
  _tags_by_value[41] = 'visuallyVerifyObject'
  _tags_by_value[42] = 'wait'
  _tags_by_value[43] = 'waitForImages'
  _tags_by_value[44] = 'count'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AlignWithObject.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CalibrateMotors.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DisplayFaceImage.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DisplayProceduralFace.unpack_from)
  _tag_unpack_methods[4] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveOffChargerContacts.unpack_from)
  _tag_unpack_methods[5] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveStraight.unpack_from)
  _tag_unpack_methods[6] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnrollNamedFace.unpack_from)
  _tag_unpack_methods[7] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FacePlant.unpack_from)
  _tag_unpack_methods[8] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FlipBlock.unpack_from)
  _tag_unpack_methods[9] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GotoObject.unpack_from)
  _tag_unpack_methods[10] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GotoPose.unpack_from)
  _tag_unpack_methods[11] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MountCharger.unpack_from)
  _tag_unpack_methods[12] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PanAndTilt.unpack_from)
  _tag_unpack_methods[13] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PickupObject.unpack_from)
  _tag_unpack_methods[14] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceObjectOnGround.unpack_from)
  _tag_unpack_methods[15] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere.unpack_from)
  _tag_unpack_methods[16] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceOnObject.unpack_from)
  _tag_unpack_methods[17] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceRelObject.unpack_from)
  _tag_unpack_methods[18] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlayAnimation.unpack_from)
  _tag_unpack_methods[19] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlayAnimationTrigger.unpack_from)
  _tag_unpack_methods[20] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PopAWheelie.unpack_from)
  _tag_unpack_methods[21] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReadToolCode.unpack_from)
  _tag_unpack_methods[22] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RealignWithObject.unpack_from)
  _tag_unpack_methods[23] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RollObject.unpack_from)
  _tag_unpack_methods[24] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SayText.unpack_from)
  _tag_unpack_methods[25] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SayTextWithIntent.unpack_from)
  _tag_unpack_methods[26] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SearchForNearbyObject.unpack_from)
  _tag_unpack_methods[27] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetHeadAngle.unpack_from)
  _tag_unpack_methods[28] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetLiftHeight.unpack_from)
  _tag_unpack_methods[29] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToFace.unpack_from)
  _tag_unpack_methods[30] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToObject.unpack_from)
  _tag_unpack_methods[31] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToPet.unpack_from)
  _tag_unpack_methods[32] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TraverseObject.unpack_from)
  _tag_unpack_methods[33] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnInPlace.unpack_from)
  _tag_unpack_methods[34] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsFace.unpack_from)
  _tag_unpack_methods[35] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint.unpack_from)
  _tag_unpack_methods[36] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose.unpack_from)
  _tag_unpack_methods[37] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsObject.unpack_from)
  _tag_unpack_methods[38] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsPose.unpack_from)
  _tag_unpack_methods[39] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyFace.unpack_from)
  _tag_unpack_methods[40] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose.unpack_from)
  _tag_unpack_methods[41] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyObject.unpack_from)
  _tag_unpack_methods[42] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.Wait.unpack_from)
  _tag_unpack_methods[43] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.WaitForImages.unpack_from)
  _tag_unpack_methods[44] = lambda reader: reader.read('B')
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[4] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[5] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[6] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[7] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[8] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[9] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[10] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[11] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[12] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[13] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[14] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[15] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[16] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[17] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[18] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[19] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[20] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[21] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[22] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[23] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[24] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[25] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[26] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[27] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[28] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[29] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[30] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[31] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[32] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[33] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[34] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[35] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[36] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[37] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[38] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[39] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[40] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[41] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[42] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[43] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[44] = lambda writer, value: writer.write(value, 'B')
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[4] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[5] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[6] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[7] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[8] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[9] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[10] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[11] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[12] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[13] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[14] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[15] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[16] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[17] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[18] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[19] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[20] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[21] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[22] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[23] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[24] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[25] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[26] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[27] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[28] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[29] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[30] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[31] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[32] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[33] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[34] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[35] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[36] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[37] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[38] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[39] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[40] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[41] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[42] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[43] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[44] = lambda value: msgbuffers.size(value, 'B')
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.ExternalInterface.AlignWithObject
  _type_by_tag_value[1] = lambda : Anki.Cozmo.ExternalInterface.CalibrateMotors
  _type_by_tag_value[2] = lambda : Anki.Cozmo.ExternalInterface.DisplayFaceImage
  _type_by_tag_value[3] = lambda : Anki.Cozmo.ExternalInterface.DisplayProceduralFace
  _type_by_tag_value[4] = lambda : Anki.Cozmo.ExternalInterface.DriveOffChargerContacts
  _type_by_tag_value[5] = lambda : Anki.Cozmo.ExternalInterface.DriveStraight
  _type_by_tag_value[6] = lambda : Anki.Cozmo.ExternalInterface.EnrollNamedFace
  _type_by_tag_value[7] = lambda : Anki.Cozmo.ExternalInterface.FacePlant
  _type_by_tag_value[8] = lambda : Anki.Cozmo.ExternalInterface.FlipBlock
  _type_by_tag_value[9] = lambda : Anki.Cozmo.ExternalInterface.GotoObject
  _type_by_tag_value[10] = lambda : Anki.Cozmo.ExternalInterface.GotoPose
  _type_by_tag_value[11] = lambda : Anki.Cozmo.ExternalInterface.MountCharger
  _type_by_tag_value[12] = lambda : Anki.Cozmo.ExternalInterface.PanAndTilt
  _type_by_tag_value[13] = lambda : Anki.Cozmo.ExternalInterface.PickupObject
  _type_by_tag_value[14] = lambda : Anki.Cozmo.ExternalInterface.PlaceObjectOnGround
  _type_by_tag_value[15] = lambda : Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere
  _type_by_tag_value[16] = lambda : Anki.Cozmo.ExternalInterface.PlaceOnObject
  _type_by_tag_value[17] = lambda : Anki.Cozmo.ExternalInterface.PlaceRelObject
  _type_by_tag_value[18] = lambda : Anki.Cozmo.ExternalInterface.PlayAnimation
  _type_by_tag_value[19] = lambda : Anki.Cozmo.ExternalInterface.PlayAnimationTrigger
  _type_by_tag_value[20] = lambda : Anki.Cozmo.ExternalInterface.PopAWheelie
  _type_by_tag_value[21] = lambda : Anki.Cozmo.ExternalInterface.ReadToolCode
  _type_by_tag_value[22] = lambda : Anki.Cozmo.ExternalInterface.RealignWithObject
  _type_by_tag_value[23] = lambda : Anki.Cozmo.ExternalInterface.RollObject
  _type_by_tag_value[24] = lambda : Anki.Cozmo.ExternalInterface.SayText
  _type_by_tag_value[25] = lambda : Anki.Cozmo.ExternalInterface.SayTextWithIntent
  _type_by_tag_value[26] = lambda : Anki.Cozmo.ExternalInterface.SearchForNearbyObject
  _type_by_tag_value[27] = lambda : Anki.Cozmo.ExternalInterface.SetHeadAngle
  _type_by_tag_value[28] = lambda : Anki.Cozmo.ExternalInterface.SetLiftHeight
  _type_by_tag_value[29] = lambda : Anki.Cozmo.ExternalInterface.TrackToFace
  _type_by_tag_value[30] = lambda : Anki.Cozmo.ExternalInterface.TrackToObject
  _type_by_tag_value[31] = lambda : Anki.Cozmo.ExternalInterface.TrackToPet
  _type_by_tag_value[32] = lambda : Anki.Cozmo.ExternalInterface.TraverseObject
  _type_by_tag_value[33] = lambda : Anki.Cozmo.ExternalInterface.TurnInPlace
  _type_by_tag_value[34] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsFace
  _type_by_tag_value[35] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint
  _type_by_tag_value[36] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose
  _type_by_tag_value[37] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsObject
  _type_by_tag_value[38] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsPose
  _type_by_tag_value[39] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyFace
  _type_by_tag_value[40] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose
  _type_by_tag_value[41] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyObject
  _type_by_tag_value[42] = lambda : Anki.Cozmo.ExternalInterface.Wait
  _type_by_tag_value[43] = lambda : Anki.Cozmo.ExternalInterface.WaitForImages
  _type_by_tag_value[44] = lambda : int
  

Anki.Cozmo.ExternalInterface.RobotActionUnion = RobotActionUnion
del RobotActionUnion


