# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/externalInterface/messageEngineToGame.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/externalInterface/messageEngineToGame.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.ExternalInterface = msgbuffers.Namespace()
Anki.Cozmo.NVStorage = msgbuffers.Namespace()
Anki.Cozmo.RobotInterface = msgbuffers.Namespace()
Anki.Vision = msgbuffers.Namespace()

from clad.audio.audioCallbackMessage import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.externalInterface.messageShared import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.robotInterface.messageFromActiveObject import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.animationEvents import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.behaviorObjectives import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.behaviorTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.cladPoint import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.cladRect import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.debugConsoleTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.deviceDataTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.engineErrorCodes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.engineState import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.facialExpressions import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.factoryTestTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.featureGateTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.firmwareTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.imageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.imu import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.loadedKnownFace import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.motorTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.nvStorageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.objectFamilies import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.objectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.offTreadsStates import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.petTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.poseStructs import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.proxMessages import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.robotStatusAndActions import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.sdkStatusTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.uiConnectionTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.unlockTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.visionModes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class UiDeviceAvailable(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectionType', # Anki.Cozmo.UiConnectionType
    '_deviceID',       # uint_32
  )

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'UiDeviceAvailable.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_32 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'UiDeviceAvailable.deviceID', value, 0, 4294967295)

  def __init__(self, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0):
    self.connectionType = connectionType
    self.deviceID = deviceID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UiDeviceAvailable from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UiDeviceAvailable.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UiDeviceAvailable from the given BinaryReader."
    _connectionType = reader.read('B')
    _deviceID = reader.read('I')
    return cls(_connectionType, _deviceID)

  def pack(self):
    "Writes the current UiDeviceAvailable, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UiDeviceAvailable to the given BinaryWriter."
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._connectionType == other._connectionType and
        self._deviceID == other._deviceID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'I'))

  def __str__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=self._connectionType,
      deviceID=self._deviceID)

  def __repr__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID))

Anki.Cozmo.ExternalInterface.UiDeviceAvailable = UiDeviceAvailable
del UiDeviceAvailable


class RobotConnectionResponse(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',      # uint_32
    '_result',       # Anki.Cozmo.RobotConnectionResult
    '_fwVersion',    # uint_32
    '_serialNumber', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotConnectionResponse.robotID', value, 0, 4294967295)

  @property
  def result(self):
    "Anki.Cozmo.RobotConnectionResult result struct property."
    return self._result

  @result.setter
  def result(self, value):
    self._result = msgbuffers.validate_integer(
      'RobotConnectionResponse.result', value, 0, 255)

  @property
  def fwVersion(self):
    "uint_32 fwVersion struct property."
    return self._fwVersion

  @fwVersion.setter
  def fwVersion(self, value):
    self._fwVersion = msgbuffers.validate_integer(
      'RobotConnectionResponse.fwVersion', value, 0, 4294967295)

  @property
  def serialNumber(self):
    "uint_32 serialNumber struct property."
    return self._serialNumber

  @serialNumber.setter
  def serialNumber(self, value):
    self._serialNumber = msgbuffers.validate_integer(
      'RobotConnectionResponse.serialNumber', value, 0, 4294967295)

  def __init__(self, robotID=0, result=Anki.Cozmo.RobotConnectionResult.Success, fwVersion=0, serialNumber=0):
    self.robotID = robotID
    self.result = result
    self.fwVersion = fwVersion
    self.serialNumber = serialNumber

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotConnectionResponse from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotConnectionResponse.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotConnectionResponse from the given BinaryReader."
    _robotID = reader.read('I')
    _result = reader.read('B')
    _fwVersion = reader.read('I')
    _serialNumber = reader.read('I')
    return cls(_robotID, _result, _fwVersion, _serialNumber)

  def pack(self):
    "Writes the current RobotConnectionResponse, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotConnectionResponse to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._result, 'B')
    writer.write(self._fwVersion, 'I')
    writer.write(self._serialNumber, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._result == other._result and
        self._fwVersion == other._fwVersion and
        self._serialNumber == other._serialNumber)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._result, 'B') +
      msgbuffers.size(self._fwVersion, 'I') +
      msgbuffers.size(self._serialNumber, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID}, result={result}, fwVersion={fwVersion}, serialNumber={serialNumber})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      result=self._result,
      fwVersion=self._fwVersion,
      serialNumber=self._serialNumber)

  def __repr__(self):
    return '{type}(robotID={robotID}, result={result}, fwVersion={fwVersion}, serialNumber={serialNumber})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      result=repr(self._result),
      fwVersion=repr(self._fwVersion),
      serialNumber=repr(self._serialNumber))

Anki.Cozmo.ExternalInterface.RobotConnectionResponse = RobotConnectionResponse
del RobotConnectionResponse


class RobotDisconnected(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',              # uint_32
    '_timeSinceLastMsg_sec', # float_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDisconnected.robotID', value, 0, 4294967295)

  @property
  def timeSinceLastMsg_sec(self):
    "float_32 timeSinceLastMsg_sec struct property."
    return self._timeSinceLastMsg_sec

  @timeSinceLastMsg_sec.setter
  def timeSinceLastMsg_sec(self, value):
    self._timeSinceLastMsg_sec = msgbuffers.validate_float(
      'RobotDisconnected.timeSinceLastMsg_sec', value, 'f')

  def __init__(self, robotID=0, timeSinceLastMsg_sec=0.0):
    self.robotID = robotID
    self.timeSinceLastMsg_sec = timeSinceLastMsg_sec

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDisconnected from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDisconnected.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDisconnected from the given BinaryReader."
    _robotID = reader.read('I')
    _timeSinceLastMsg_sec = reader.read('f')
    return cls(_robotID, _timeSinceLastMsg_sec)

  def pack(self):
    "Writes the current RobotDisconnected, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDisconnected to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._timeSinceLastMsg_sec, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._timeSinceLastMsg_sec == other._timeSinceLastMsg_sec)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._timeSinceLastMsg_sec, 'f'))

  def __str__(self):
    return '{type}(robotID={robotID}, timeSinceLastMsg_sec={timeSinceLastMsg_sec})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      timeSinceLastMsg_sec=self._timeSinceLastMsg_sec)

  def __repr__(self):
    return '{type}(robotID={robotID}, timeSinceLastMsg_sec={timeSinceLastMsg_sec})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      timeSinceLastMsg_sec=repr(self._timeSinceLastMsg_sec))

Anki.Cozmo.ExternalInterface.RobotDisconnected = RobotDisconnected
del RobotDisconnected


class UiDeviceConnected(object):
  "Generated message-passing message."

  __slots__ = (
    '_reserved',         # uint_8
    '_connectionType',   # Anki.Cozmo.UiConnectionType
    '_deviceID',         # uint_32
    '_successful',       # uint_8
    '_toGameCLADHash',   # uint_8[16]
    '_toEngineCLADHash', # uint_8[16]
    '_buildVersion',     # string[uint_8]
  )

  @property
  def reserved(self):
    "uint_8 reserved struct property."
    return self._reserved

  @reserved.setter
  def reserved(self, value):
    self._reserved = msgbuffers.validate_integer(
      'UiDeviceConnected.reserved', value, 0, 255)

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'UiDeviceConnected.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_32 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'UiDeviceConnected.deviceID', value, 0, 4294967295)

  @property
  def successful(self):
    "uint_8 successful struct property."
    return self._successful

  @successful.setter
  def successful(self, value):
    self._successful = msgbuffers.validate_integer(
      'UiDeviceConnected.successful', value, 0, 255)

  @property
  def toGameCLADHash(self):
    "uint_8[16] toGameCLADHash struct property."
    return self._toGameCLADHash

  @toGameCLADHash.setter
  def toGameCLADHash(self, value):
    self._toGameCLADHash = msgbuffers.validate_farray(
      'UiDeviceConnected.toGameCLADHash', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def toEngineCLADHash(self):
    "uint_8[16] toEngineCLADHash struct property."
    return self._toEngineCLADHash

  @toEngineCLADHash.setter
  def toEngineCLADHash(self, value):
    self._toEngineCLADHash = msgbuffers.validate_farray(
      'UiDeviceConnected.toEngineCLADHash', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def buildVersion(self):
    "string[uint_8] buildVersion struct property."
    return self._buildVersion

  @buildVersion.setter
  def buildVersion(self, value):
    self._buildVersion = msgbuffers.validate_string(
      'UiDeviceConnected.buildVersion', value, 255)

  def __init__(self, reserved=0, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0, successful=0, toGameCLADHash=(0,) * 16, toEngineCLADHash=(0,) * 16, buildVersion=''):
    self.reserved = reserved
    self.connectionType = connectionType
    self.deviceID = deviceID
    self.successful = successful
    self.toGameCLADHash = toGameCLADHash
    self.toEngineCLADHash = toEngineCLADHash
    self.buildVersion = buildVersion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UiDeviceConnected from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UiDeviceConnected.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UiDeviceConnected from the given BinaryReader."
    _reserved = reader.read('B')
    _connectionType = reader.read('B')
    _deviceID = reader.read('I')
    _successful = reader.read('B')
    _toGameCLADHash = reader.read_farray('B', 16)
    _toEngineCLADHash = reader.read_farray('B', 16)
    _buildVersion = reader.read_string('B')
    return cls(_reserved, _connectionType, _deviceID, _successful, _toGameCLADHash, _toEngineCLADHash, _buildVersion)

  def pack(self):
    "Writes the current UiDeviceConnected, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UiDeviceConnected to the given BinaryWriter."
    writer.write(self._reserved, 'B')
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'I')
    writer.write(self._successful, 'B')
    writer.write_farray(self._toGameCLADHash, 'B', 16)
    writer.write_farray(self._toEngineCLADHash, 'B', 16)
    writer.write_string(self._buildVersion, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._reserved == other._reserved and
        self._connectionType == other._connectionType and
        self._deviceID == other._deviceID and
        self._successful == other._successful and
        self._toGameCLADHash == other._toGameCLADHash and
        self._toEngineCLADHash == other._toEngineCLADHash and
        self._buildVersion == other._buildVersion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._reserved, 'B') +
      msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'I') +
      msgbuffers.size(self._successful, 'B') +
      msgbuffers.size_farray(self._toGameCLADHash, 'B', 16) +
      msgbuffers.size_farray(self._toEngineCLADHash, 'B', 16) +
      msgbuffers.size_string(self._buildVersion, 'B'))

  def __str__(self):
    return '{type}(reserved={reserved}, connectionType={connectionType}, deviceID={deviceID}, successful={successful}, toGameCLADHash={toGameCLADHash}, toEngineCLADHash={toEngineCLADHash}, buildVersion={buildVersion})'.format(
      type=type(self).__name__,
      reserved=self._reserved,
      connectionType=self._connectionType,
      deviceID=self._deviceID,
      successful=self._successful,
      toGameCLADHash=msgbuffers.shorten_sequence(self._toGameCLADHash),
      toEngineCLADHash=msgbuffers.shorten_sequence(self._toEngineCLADHash),
      buildVersion=msgbuffers.shorten_string(self._buildVersion))

  def __repr__(self):
    return '{type}(reserved={reserved}, connectionType={connectionType}, deviceID={deviceID}, successful={successful}, toGameCLADHash={toGameCLADHash}, toEngineCLADHash={toEngineCLADHash}, buildVersion={buildVersion})'.format(
      type=type(self).__name__,
      reserved=repr(self._reserved),
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID),
      successful=repr(self._successful),
      toGameCLADHash=repr(self._toGameCLADHash),
      toEngineCLADHash=repr(self._toEngineCLADHash),
      buildVersion=repr(self._buildVersion))

Anki.Cozmo.ExternalInterface.UiDeviceConnected = UiDeviceConnected
del UiDeviceConnected


class EngineRobotCLADVersionMismatch(object):
  "Generated message-passing message."

  __slots__ = (
    '_engineToRobotMismatch',   # bool
    '_robotToEngineMismatch',   # bool
    '_engineEnginetoRobotHash', # string[uint_8]
    '_engineRobotToEngineHash', # string[uint_8]
    '_robotEnginetoRobotHash',  # string[uint_8]
    '_robotRobotToEngineHash',  # string[uint_8]
  )

  @property
  def engineToRobotMismatch(self):
    "bool engineToRobotMismatch struct property."
    return self._engineToRobotMismatch

  @engineToRobotMismatch.setter
  def engineToRobotMismatch(self, value):
    self._engineToRobotMismatch = msgbuffers.validate_bool(
      'EngineRobotCLADVersionMismatch.engineToRobotMismatch', value)

  @property
  def robotToEngineMismatch(self):
    "bool robotToEngineMismatch struct property."
    return self._robotToEngineMismatch

  @robotToEngineMismatch.setter
  def robotToEngineMismatch(self, value):
    self._robotToEngineMismatch = msgbuffers.validate_bool(
      'EngineRobotCLADVersionMismatch.robotToEngineMismatch', value)

  @property
  def engineEnginetoRobotHash(self):
    "string[uint_8] engineEnginetoRobotHash struct property."
    return self._engineEnginetoRobotHash

  @engineEnginetoRobotHash.setter
  def engineEnginetoRobotHash(self, value):
    self._engineEnginetoRobotHash = msgbuffers.validate_string(
      'EngineRobotCLADVersionMismatch.engineEnginetoRobotHash', value, 255)

  @property
  def engineRobotToEngineHash(self):
    "string[uint_8] engineRobotToEngineHash struct property."
    return self._engineRobotToEngineHash

  @engineRobotToEngineHash.setter
  def engineRobotToEngineHash(self, value):
    self._engineRobotToEngineHash = msgbuffers.validate_string(
      'EngineRobotCLADVersionMismatch.engineRobotToEngineHash', value, 255)

  @property
  def robotEnginetoRobotHash(self):
    "string[uint_8] robotEnginetoRobotHash struct property."
    return self._robotEnginetoRobotHash

  @robotEnginetoRobotHash.setter
  def robotEnginetoRobotHash(self, value):
    self._robotEnginetoRobotHash = msgbuffers.validate_string(
      'EngineRobotCLADVersionMismatch.robotEnginetoRobotHash', value, 255)

  @property
  def robotRobotToEngineHash(self):
    "string[uint_8] robotRobotToEngineHash struct property."
    return self._robotRobotToEngineHash

  @robotRobotToEngineHash.setter
  def robotRobotToEngineHash(self, value):
    self._robotRobotToEngineHash = msgbuffers.validate_string(
      'EngineRobotCLADVersionMismatch.robotRobotToEngineHash', value, 255)

  def __init__(self, engineToRobotMismatch=False, robotToEngineMismatch=False, engineEnginetoRobotHash='', engineRobotToEngineHash='', robotEnginetoRobotHash='', robotRobotToEngineHash=''):
    self.engineToRobotMismatch = engineToRobotMismatch
    self.robotToEngineMismatch = robotToEngineMismatch
    self.engineEnginetoRobotHash = engineEnginetoRobotHash
    self.engineRobotToEngineHash = engineRobotToEngineHash
    self.robotEnginetoRobotHash = robotEnginetoRobotHash
    self.robotRobotToEngineHash = robotRobotToEngineHash

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EngineRobotCLADVersionMismatch from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EngineRobotCLADVersionMismatch.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EngineRobotCLADVersionMismatch from the given BinaryReader."
    _engineToRobotMismatch = bool(reader.read('b'))
    _robotToEngineMismatch = bool(reader.read('b'))
    _engineEnginetoRobotHash = reader.read_string('B')
    _engineRobotToEngineHash = reader.read_string('B')
    _robotEnginetoRobotHash = reader.read_string('B')
    _robotRobotToEngineHash = reader.read_string('B')
    return cls(_engineToRobotMismatch, _robotToEngineMismatch, _engineEnginetoRobotHash, _engineRobotToEngineHash, _robotEnginetoRobotHash, _robotRobotToEngineHash)

  def pack(self):
    "Writes the current EngineRobotCLADVersionMismatch, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EngineRobotCLADVersionMismatch to the given BinaryWriter."
    writer.write(int(self._engineToRobotMismatch), 'b')
    writer.write(int(self._robotToEngineMismatch), 'b')
    writer.write_string(self._engineEnginetoRobotHash, 'B')
    writer.write_string(self._engineRobotToEngineHash, 'B')
    writer.write_string(self._robotEnginetoRobotHash, 'B')
    writer.write_string(self._robotRobotToEngineHash, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._engineToRobotMismatch == other._engineToRobotMismatch and
        self._robotToEngineMismatch == other._robotToEngineMismatch and
        self._engineEnginetoRobotHash == other._engineEnginetoRobotHash and
        self._engineRobotToEngineHash == other._engineRobotToEngineHash and
        self._robotEnginetoRobotHash == other._robotEnginetoRobotHash and
        self._robotRobotToEngineHash == other._robotRobotToEngineHash)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._engineToRobotMismatch, 'b') +
      msgbuffers.size(self._robotToEngineMismatch, 'b') +
      msgbuffers.size_string(self._engineEnginetoRobotHash, 'B') +
      msgbuffers.size_string(self._engineRobotToEngineHash, 'B') +
      msgbuffers.size_string(self._robotEnginetoRobotHash, 'B') +
      msgbuffers.size_string(self._robotRobotToEngineHash, 'B'))

  def __str__(self):
    return '{type}(engineToRobotMismatch={engineToRobotMismatch}, robotToEngineMismatch={robotToEngineMismatch}, engineEnginetoRobotHash={engineEnginetoRobotHash}, engineRobotToEngineHash={engineRobotToEngineHash}, robotEnginetoRobotHash={robotEnginetoRobotHash}, robotRobotToEngineHash={robotRobotToEngineHash})'.format(
      type=type(self).__name__,
      engineToRobotMismatch=self._engineToRobotMismatch,
      robotToEngineMismatch=self._robotToEngineMismatch,
      engineEnginetoRobotHash=msgbuffers.shorten_string(self._engineEnginetoRobotHash),
      engineRobotToEngineHash=msgbuffers.shorten_string(self._engineRobotToEngineHash),
      robotEnginetoRobotHash=msgbuffers.shorten_string(self._robotEnginetoRobotHash),
      robotRobotToEngineHash=msgbuffers.shorten_string(self._robotRobotToEngineHash))

  def __repr__(self):
    return '{type}(engineToRobotMismatch={engineToRobotMismatch}, robotToEngineMismatch={robotToEngineMismatch}, engineEnginetoRobotHash={engineEnginetoRobotHash}, engineRobotToEngineHash={engineRobotToEngineHash}, robotEnginetoRobotHash={robotEnginetoRobotHash}, robotRobotToEngineHash={robotRobotToEngineHash})'.format(
      type=type(self).__name__,
      engineToRobotMismatch=repr(self._engineToRobotMismatch),
      robotToEngineMismatch=repr(self._robotToEngineMismatch),
      engineEnginetoRobotHash=repr(self._engineEnginetoRobotHash),
      engineRobotToEngineHash=repr(self._engineRobotToEngineHash),
      robotEnginetoRobotHash=repr(self._robotEnginetoRobotHash),
      robotRobotToEngineHash=repr(self._robotRobotToEngineHash))

Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch = EngineRobotCLADVersionMismatch
del EngineRobotCLADVersionMismatch


class ObjectAvailable(object):
  "Generated message-passing message."

  __slots__ = (
    '_factory_id', # uint_32
    '_objectType', # Anki.Cozmo.ObjectType
    '_rssi',       # int_8
  )

  @property
  def factory_id(self):
    "uint_32 factory_id struct property."
    return self._factory_id

  @factory_id.setter
  def factory_id(self, value):
    self._factory_id = msgbuffers.validate_integer(
      'ObjectAvailable.factory_id', value, 0, 4294967295)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'ObjectAvailable.objectType', value, -2147483648, 2147483647)

  @property
  def rssi(self):
    "int_8 rssi struct property."
    return self._rssi

  @rssi.setter
  def rssi(self, value):
    self._rssi = msgbuffers.validate_integer(
      'ObjectAvailable.rssi', value, -128, 127)

  def __init__(self, factory_id=0, objectType=Anki.Cozmo.ObjectType.Invalid, rssi=0):
    self.factory_id = factory_id
    self.objectType = objectType
    self.rssi = rssi

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectAvailable from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectAvailable.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectAvailable from the given BinaryReader."
    _factory_id = reader.read('I')
    _objectType = reader.read('i')
    _rssi = reader.read('b')
    return cls(_factory_id, _objectType, _rssi)

  def pack(self):
    "Writes the current ObjectAvailable, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectAvailable to the given BinaryWriter."
    writer.write(self._factory_id, 'I')
    writer.write(self._objectType, 'i')
    writer.write(self._rssi, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._factory_id == other._factory_id and
        self._objectType == other._objectType and
        self._rssi == other._rssi)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._factory_id, 'I') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size(self._rssi, 'b'))

  def __str__(self):
    return '{type}(factory_id={factory_id}, objectType={objectType}, rssi={rssi})'.format(
      type=type(self).__name__,
      factory_id=self._factory_id,
      objectType=self._objectType,
      rssi=self._rssi)

  def __repr__(self):
    return '{type}(factory_id={factory_id}, objectType={objectType}, rssi={rssi})'.format(
      type=type(self).__name__,
      factory_id=repr(self._factory_id),
      objectType=repr(self._objectType),
      rssi=repr(self._rssi))

Anki.Cozmo.ExternalInterface.ObjectAvailable = ObjectAvailable
del ObjectAvailable


class ObjectUnavailable(object):
  "Generated message-passing message."

  __slots__ = (
    '_factory_id', # uint_32
  )

  @property
  def factory_id(self):
    "uint_32 factory_id struct property."
    return self._factory_id

  @factory_id.setter
  def factory_id(self, value):
    self._factory_id = msgbuffers.validate_integer(
      'ObjectUnavailable.factory_id', value, 0, 4294967295)

  def __init__(self, factory_id=0):
    self.factory_id = factory_id

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectUnavailable from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectUnavailable.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectUnavailable from the given BinaryReader."
    _factory_id = reader.read('I')
    return cls(_factory_id)

  def pack(self):
    "Writes the current ObjectUnavailable, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectUnavailable to the given BinaryWriter."
    writer.write(self._factory_id, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._factory_id == other._factory_id
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._factory_id, 'I'))

  def __str__(self):
    return '{type}(factory_id={factory_id})'.format(
      type=type(self).__name__,
      factory_id=self._factory_id)

  def __repr__(self):
    return '{type}(factory_id={factory_id})'.format(
      type=type(self).__name__,
      factory_id=repr(self._factory_id))

Anki.Cozmo.ExternalInterface.ObjectUnavailable = ObjectUnavailable
del ObjectUnavailable


class FeatureToggles(object):
  "Generated message-passing message."

  __slots__ = (
    '_features', # FeatureToggle[uint_16]
  )

  @property
  def features(self):
    "FeatureToggle[uint_16] features struct property."
    return self._features

  @features.setter
  def features(self, value):
    self._features = msgbuffers.validate_varray(
      'FeatureToggles.features', value, 65535,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.FeatureToggle))

  def __init__(self, features=()):
    self.features = features

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FeatureToggles from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FeatureToggles.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FeatureToggles from the given BinaryReader."
    _features = reader.read_object_varray(Anki.Cozmo.FeatureToggle.unpack_from, 'H')
    return cls(_features)

  def pack(self):
    "Writes the current FeatureToggles, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FeatureToggles to the given BinaryWriter."
    writer.write_object_varray(self._features, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._features == other._features
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object_varray(self._features, 'H'))

  def __str__(self):
    return '{type}(features={features})'.format(
      type=type(self).__name__,
      features=msgbuffers.shorten_sequence(self._features))

  def __repr__(self):
    return '{type}(features={features})'.format(
      type=type(self).__name__,
      features=repr(self._features))

Anki.Cozmo.ExternalInterface.FeatureToggles = FeatureToggles
del FeatureToggles


class GoingToSleep(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GoingToSleep from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GoingToSleep.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GoingToSleep from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GoingToSleep, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GoingToSleep to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GoingToSleep = GoingToSleep
del GoingToSleep


class EngineLoadingDataStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_ratioComplete', # float_32
  )

  @property
  def ratioComplete(self):
    "float_32 ratioComplete struct property."
    return self._ratioComplete

  @ratioComplete.setter
  def ratioComplete(self, value):
    self._ratioComplete = msgbuffers.validate_float(
      'EngineLoadingDataStatus.ratioComplete', value, 'f')

  def __init__(self, ratioComplete=0.0):
    self.ratioComplete = ratioComplete

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EngineLoadingDataStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EngineLoadingDataStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EngineLoadingDataStatus from the given BinaryReader."
    _ratioComplete = reader.read('f')
    return cls(_ratioComplete)

  def pack(self):
    "Writes the current EngineLoadingDataStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EngineLoadingDataStatus to the given BinaryWriter."
    writer.write(self._ratioComplete, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._ratioComplete == other._ratioComplete
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._ratioComplete, 'f'))

  def __str__(self):
    return '{type}(ratioComplete={ratioComplete})'.format(
      type=type(self).__name__,
      ratioComplete=self._ratioComplete)

  def __repr__(self):
    return '{type}(ratioComplete={ratioComplete})'.format(
      type=type(self).__name__,
      ratioComplete=repr(self._ratioComplete))

Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus = EngineLoadingDataStatus
del EngineLoadingDataStatus


class RobotState(object):
  "Generated message-passing message."

  __slots__ = (
    '_pose',                  # Anki.PoseStruct3d
    '_poseAngle_rad',         # float_32
    '_posePitch_rad',         # float_32
    '_leftWheelSpeed_mmps',   # float_32
    '_rightWheelSpeed_mmps',  # float_32
    '_headAngle_rad',         # float_32
    '_liftHeight_mm',         # float_32
    '_batteryVoltage',        # float_32
    '_accel',                 # Anki.Cozmo.AccelData
    '_gyro',                  # Anki.Cozmo.GyroData
    '_carryingObjectID',      # int_32
    '_carryingObjectOnTopID', # int_32
    '_headTrackingObjectID',  # int_32
    '_localizedToObjectID',   # int_32
    '_lastImageTimeStamp',    # uint_32
    '_status',                # uint_32
    '_gameStatus',            # uint_8
    '_robotID',               # uint_8
  )

  @property
  def pose(self):
    "Anki.PoseStruct3d pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_object(
      'RobotState.pose', value, Anki.PoseStruct3d)

  @property
  def poseAngle_rad(self):
    "float_32 poseAngle_rad struct property."
    return self._poseAngle_rad

  @poseAngle_rad.setter
  def poseAngle_rad(self, value):
    self._poseAngle_rad = msgbuffers.validate_float(
      'RobotState.poseAngle_rad', value, 'f')

  @property
  def posePitch_rad(self):
    "float_32 posePitch_rad struct property."
    return self._posePitch_rad

  @posePitch_rad.setter
  def posePitch_rad(self, value):
    self._posePitch_rad = msgbuffers.validate_float(
      'RobotState.posePitch_rad', value, 'f')

  @property
  def leftWheelSpeed_mmps(self):
    "float_32 leftWheelSpeed_mmps struct property."
    return self._leftWheelSpeed_mmps

  @leftWheelSpeed_mmps.setter
  def leftWheelSpeed_mmps(self, value):
    self._leftWheelSpeed_mmps = msgbuffers.validate_float(
      'RobotState.leftWheelSpeed_mmps', value, 'f')

  @property
  def rightWheelSpeed_mmps(self):
    "float_32 rightWheelSpeed_mmps struct property."
    return self._rightWheelSpeed_mmps

  @rightWheelSpeed_mmps.setter
  def rightWheelSpeed_mmps(self, value):
    self._rightWheelSpeed_mmps = msgbuffers.validate_float(
      'RobotState.rightWheelSpeed_mmps', value, 'f')

  @property
  def headAngle_rad(self):
    "float_32 headAngle_rad struct property."
    return self._headAngle_rad

  @headAngle_rad.setter
  def headAngle_rad(self, value):
    self._headAngle_rad = msgbuffers.validate_float(
      'RobotState.headAngle_rad', value, 'f')

  @property
  def liftHeight_mm(self):
    "float_32 liftHeight_mm struct property."
    return self._liftHeight_mm

  @liftHeight_mm.setter
  def liftHeight_mm(self, value):
    self._liftHeight_mm = msgbuffers.validate_float(
      'RobotState.liftHeight_mm', value, 'f')

  @property
  def batteryVoltage(self):
    "float_32 batteryVoltage struct property."
    return self._batteryVoltage

  @batteryVoltage.setter
  def batteryVoltage(self, value):
    self._batteryVoltage = msgbuffers.validate_float(
      'RobotState.batteryVoltage', value, 'f')

  @property
  def accel(self):
    "Anki.Cozmo.AccelData accel struct property."
    return self._accel

  @accel.setter
  def accel(self, value):
    self._accel = msgbuffers.validate_object(
      'RobotState.accel', value, Anki.Cozmo.AccelData)

  @property
  def gyro(self):
    "Anki.Cozmo.GyroData gyro struct property."
    return self._gyro

  @gyro.setter
  def gyro(self, value):
    self._gyro = msgbuffers.validate_object(
      'RobotState.gyro', value, Anki.Cozmo.GyroData)

  @property
  def carryingObjectID(self):
    "int_32 carryingObjectID struct property."
    return self._carryingObjectID

  @carryingObjectID.setter
  def carryingObjectID(self, value):
    self._carryingObjectID = msgbuffers.validate_integer(
      'RobotState.carryingObjectID', value, -2147483648, 2147483647)

  @property
  def carryingObjectOnTopID(self):
    "int_32 carryingObjectOnTopID struct property."
    return self._carryingObjectOnTopID

  @carryingObjectOnTopID.setter
  def carryingObjectOnTopID(self, value):
    self._carryingObjectOnTopID = msgbuffers.validate_integer(
      'RobotState.carryingObjectOnTopID', value, -2147483648, 2147483647)

  @property
  def headTrackingObjectID(self):
    "int_32 headTrackingObjectID struct property."
    return self._headTrackingObjectID

  @headTrackingObjectID.setter
  def headTrackingObjectID(self, value):
    self._headTrackingObjectID = msgbuffers.validate_integer(
      'RobotState.headTrackingObjectID', value, -2147483648, 2147483647)

  @property
  def localizedToObjectID(self):
    "int_32 localizedToObjectID struct property."
    return self._localizedToObjectID

  @localizedToObjectID.setter
  def localizedToObjectID(self, value):
    self._localizedToObjectID = msgbuffers.validate_integer(
      'RobotState.localizedToObjectID', value, -2147483648, 2147483647)

  @property
  def lastImageTimeStamp(self):
    "uint_32 lastImageTimeStamp struct property."
    return self._lastImageTimeStamp

  @lastImageTimeStamp.setter
  def lastImageTimeStamp(self, value):
    self._lastImageTimeStamp = msgbuffers.validate_integer(
      'RobotState.lastImageTimeStamp', value, 0, 4294967295)

  @property
  def status(self):
    "uint_32 status struct property."
    return self._status

  @status.setter
  def status(self, value):
    self._status = msgbuffers.validate_integer(
      'RobotState.status', value, 0, 4294967295)

  @property
  def gameStatus(self):
    "uint_8 gameStatus struct property."
    return self._gameStatus

  @gameStatus.setter
  def gameStatus(self, value):
    self._gameStatus = msgbuffers.validate_integer(
      'RobotState.gameStatus', value, 0, 255)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotState.robotID', value, 0, 255)

  def __init__(self, pose=Anki.PoseStruct3d(), poseAngle_rad=0.0, posePitch_rad=0.0, leftWheelSpeed_mmps=0.0, rightWheelSpeed_mmps=0.0, headAngle_rad=0.0, liftHeight_mm=0.0, batteryVoltage=0.0, accel=Anki.Cozmo.AccelData(), gyro=Anki.Cozmo.GyroData(), carryingObjectID=0, carryingObjectOnTopID=0, headTrackingObjectID=0, localizedToObjectID=0, lastImageTimeStamp=0, status=0, gameStatus=0, robotID=0):
    self.pose = pose
    self.poseAngle_rad = poseAngle_rad
    self.posePitch_rad = posePitch_rad
    self.leftWheelSpeed_mmps = leftWheelSpeed_mmps
    self.rightWheelSpeed_mmps = rightWheelSpeed_mmps
    self.headAngle_rad = headAngle_rad
    self.liftHeight_mm = liftHeight_mm
    self.batteryVoltage = batteryVoltage
    self.accel = accel
    self.gyro = gyro
    self.carryingObjectID = carryingObjectID
    self.carryingObjectOnTopID = carryingObjectOnTopID
    self.headTrackingObjectID = headTrackingObjectID
    self.localizedToObjectID = localizedToObjectID
    self.lastImageTimeStamp = lastImageTimeStamp
    self.status = status
    self.gameStatus = gameStatus
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotState from the given BinaryReader."
    _pose = reader.read_object(Anki.PoseStruct3d.unpack_from)
    _poseAngle_rad = reader.read('f')
    _posePitch_rad = reader.read('f')
    _leftWheelSpeed_mmps = reader.read('f')
    _rightWheelSpeed_mmps = reader.read('f')
    _headAngle_rad = reader.read('f')
    _liftHeight_mm = reader.read('f')
    _batteryVoltage = reader.read('f')
    _accel = reader.read_object(Anki.Cozmo.AccelData.unpack_from)
    _gyro = reader.read_object(Anki.Cozmo.GyroData.unpack_from)
    _carryingObjectID = reader.read('i')
    _carryingObjectOnTopID = reader.read('i')
    _headTrackingObjectID = reader.read('i')
    _localizedToObjectID = reader.read('i')
    _lastImageTimeStamp = reader.read('I')
    _status = reader.read('I')
    _gameStatus = reader.read('B')
    _robotID = reader.read('B')
    return cls(_pose, _poseAngle_rad, _posePitch_rad, _leftWheelSpeed_mmps, _rightWheelSpeed_mmps, _headAngle_rad, _liftHeight_mm, _batteryVoltage, _accel, _gyro, _carryingObjectID, _carryingObjectOnTopID, _headTrackingObjectID, _localizedToObjectID, _lastImageTimeStamp, _status, _gameStatus, _robotID)

  def pack(self):
    "Writes the current RobotState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotState to the given BinaryWriter."
    writer.write_object(self._pose)
    writer.write(self._poseAngle_rad, 'f')
    writer.write(self._posePitch_rad, 'f')
    writer.write(self._leftWheelSpeed_mmps, 'f')
    writer.write(self._rightWheelSpeed_mmps, 'f')
    writer.write(self._headAngle_rad, 'f')
    writer.write(self._liftHeight_mm, 'f')
    writer.write(self._batteryVoltage, 'f')
    writer.write_object(self._accel)
    writer.write_object(self._gyro)
    writer.write(self._carryingObjectID, 'i')
    writer.write(self._carryingObjectOnTopID, 'i')
    writer.write(self._headTrackingObjectID, 'i')
    writer.write(self._localizedToObjectID, 'i')
    writer.write(self._lastImageTimeStamp, 'I')
    writer.write(self._status, 'I')
    writer.write(self._gameStatus, 'B')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._pose == other._pose and
        self._poseAngle_rad == other._poseAngle_rad and
        self._posePitch_rad == other._posePitch_rad and
        self._leftWheelSpeed_mmps == other._leftWheelSpeed_mmps and
        self._rightWheelSpeed_mmps == other._rightWheelSpeed_mmps and
        self._headAngle_rad == other._headAngle_rad and
        self._liftHeight_mm == other._liftHeight_mm and
        self._batteryVoltage == other._batteryVoltage and
        self._accel == other._accel and
        self._gyro == other._gyro and
        self._carryingObjectID == other._carryingObjectID and
        self._carryingObjectOnTopID == other._carryingObjectOnTopID and
        self._headTrackingObjectID == other._headTrackingObjectID and
        self._localizedToObjectID == other._localizedToObjectID and
        self._lastImageTimeStamp == other._lastImageTimeStamp and
        self._status == other._status and
        self._gameStatus == other._gameStatus and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._pose) +
      msgbuffers.size(self._poseAngle_rad, 'f') +
      msgbuffers.size(self._posePitch_rad, 'f') +
      msgbuffers.size(self._leftWheelSpeed_mmps, 'f') +
      msgbuffers.size(self._rightWheelSpeed_mmps, 'f') +
      msgbuffers.size(self._headAngle_rad, 'f') +
      msgbuffers.size(self._liftHeight_mm, 'f') +
      msgbuffers.size(self._batteryVoltage, 'f') +
      msgbuffers.size_object(self._accel) +
      msgbuffers.size_object(self._gyro) +
      msgbuffers.size(self._carryingObjectID, 'i') +
      msgbuffers.size(self._carryingObjectOnTopID, 'i') +
      msgbuffers.size(self._headTrackingObjectID, 'i') +
      msgbuffers.size(self._localizedToObjectID, 'i') +
      msgbuffers.size(self._lastImageTimeStamp, 'I') +
      msgbuffers.size(self._status, 'I') +
      msgbuffers.size(self._gameStatus, 'B') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(pose={pose}, poseAngle_rad={poseAngle_rad}, posePitch_rad={posePitch_rad}, leftWheelSpeed_mmps={leftWheelSpeed_mmps}, rightWheelSpeed_mmps={rightWheelSpeed_mmps}, headAngle_rad={headAngle_rad}, liftHeight_mm={liftHeight_mm}, batteryVoltage={batteryVoltage}, accel={accel}, gyro={gyro}, carryingObjectID={carryingObjectID}, carryingObjectOnTopID={carryingObjectOnTopID}, headTrackingObjectID={headTrackingObjectID}, localizedToObjectID={localizedToObjectID}, lastImageTimeStamp={lastImageTimeStamp}, status={status}, gameStatus={gameStatus}, robotID={robotID})'.format(
      type=type(self).__name__,
      pose=self._pose,
      poseAngle_rad=self._poseAngle_rad,
      posePitch_rad=self._posePitch_rad,
      leftWheelSpeed_mmps=self._leftWheelSpeed_mmps,
      rightWheelSpeed_mmps=self._rightWheelSpeed_mmps,
      headAngle_rad=self._headAngle_rad,
      liftHeight_mm=self._liftHeight_mm,
      batteryVoltage=self._batteryVoltage,
      accel=self._accel,
      gyro=self._gyro,
      carryingObjectID=self._carryingObjectID,
      carryingObjectOnTopID=self._carryingObjectOnTopID,
      headTrackingObjectID=self._headTrackingObjectID,
      localizedToObjectID=self._localizedToObjectID,
      lastImageTimeStamp=self._lastImageTimeStamp,
      status=self._status,
      gameStatus=self._gameStatus,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(pose={pose}, poseAngle_rad={poseAngle_rad}, posePitch_rad={posePitch_rad}, leftWheelSpeed_mmps={leftWheelSpeed_mmps}, rightWheelSpeed_mmps={rightWheelSpeed_mmps}, headAngle_rad={headAngle_rad}, liftHeight_mm={liftHeight_mm}, batteryVoltage={batteryVoltage}, accel={accel}, gyro={gyro}, carryingObjectID={carryingObjectID}, carryingObjectOnTopID={carryingObjectOnTopID}, headTrackingObjectID={headTrackingObjectID}, localizedToObjectID={localizedToObjectID}, lastImageTimeStamp={lastImageTimeStamp}, status={status}, gameStatus={gameStatus}, robotID={robotID})'.format(
      type=type(self).__name__,
      pose=repr(self._pose),
      poseAngle_rad=repr(self._poseAngle_rad),
      posePitch_rad=repr(self._posePitch_rad),
      leftWheelSpeed_mmps=repr(self._leftWheelSpeed_mmps),
      rightWheelSpeed_mmps=repr(self._rightWheelSpeed_mmps),
      headAngle_rad=repr(self._headAngle_rad),
      liftHeight_mm=repr(self._liftHeight_mm),
      batteryVoltage=repr(self._batteryVoltage),
      accel=repr(self._accel),
      gyro=repr(self._gyro),
      carryingObjectID=repr(self._carryingObjectID),
      carryingObjectOnTopID=repr(self._carryingObjectOnTopID),
      headTrackingObjectID=repr(self._headTrackingObjectID),
      localizedToObjectID=repr(self._localizedToObjectID),
      lastImageTimeStamp=repr(self._lastImageTimeStamp),
      status=repr(self._status),
      gameStatus=repr(self._gameStatus),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotState = RobotState
del RobotState


class RobotDelocalized(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDelocalized.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDelocalized from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDelocalized.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDelocalized from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current RobotDelocalized, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDelocalized to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotDelocalized = RobotDelocalized
del RobotDelocalized


class RobotPoked(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotPoked.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotPoked from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotPoked.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotPoked from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current RobotPoked, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotPoked to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotPoked = RobotPoked
del RobotPoked


class RobotStopped(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotStopped from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotStopped.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotStopped from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RobotStopped, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotStopped to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RobotStopped = RobotStopped
del RobotStopped


class RobotOffTreadsStateChanged(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',     # uint_8
    '_treadsState', # Anki.Cozmo.OffTreadsState
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotOffTreadsStateChanged.robotID', value, 0, 255)

  @property
  def treadsState(self):
    "Anki.Cozmo.OffTreadsState treadsState struct property."
    return self._treadsState

  @treadsState.setter
  def treadsState(self, value):
    self._treadsState = msgbuffers.validate_integer(
      'RobotOffTreadsStateChanged.treadsState', value, -128, 127)

  def __init__(self, robotID=0, treadsState=Anki.Cozmo.OffTreadsState.OnTreads):
    self.robotID = robotID
    self.treadsState = treadsState

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotOffTreadsStateChanged from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotOffTreadsStateChanged.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotOffTreadsStateChanged from the given BinaryReader."
    _robotID = reader.read('B')
    _treadsState = reader.read('b')
    return cls(_robotID, _treadsState)

  def pack(self):
    "Writes the current RobotOffTreadsStateChanged, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotOffTreadsStateChanged to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._treadsState, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._treadsState == other._treadsState)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._treadsState, 'b'))

  def __str__(self):
    return '{type}(robotID={robotID}, treadsState={treadsState})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      treadsState=self._treadsState)

  def __repr__(self):
    return '{type}(robotID={robotID}, treadsState={treadsState})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      treadsState=repr(self._treadsState))

Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged = RobotOffTreadsStateChanged
del RobotOffTreadsStateChanged


class RobotCliffEventFinished(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotCliffEventFinished from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotCliffEventFinished.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotCliffEventFinished from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RobotCliffEventFinished, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotCliffEventFinished to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RobotCliffEventFinished = RobotCliffEventFinished
del RobotCliffEventFinished


class RobotOnChargerPlatformEvent(object):
  "Generated message-passing message."

  __slots__ = (
    '_onCharger', # bool
  )

  @property
  def onCharger(self):
    "bool onCharger struct property."
    return self._onCharger

  @onCharger.setter
  def onCharger(self, value):
    self._onCharger = msgbuffers.validate_bool(
      'RobotOnChargerPlatformEvent.onCharger', value)

  def __init__(self, onCharger=False):
    self.onCharger = onCharger

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotOnChargerPlatformEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotOnChargerPlatformEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotOnChargerPlatformEvent from the given BinaryReader."
    _onCharger = bool(reader.read('b'))
    return cls(_onCharger)

  def pack(self):
    "Writes the current RobotOnChargerPlatformEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotOnChargerPlatformEvent to the given BinaryWriter."
    writer.write(int(self._onCharger), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._onCharger == other._onCharger
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._onCharger, 'b'))

  def __str__(self):
    return '{type}(onCharger={onCharger})'.format(
      type=type(self).__name__,
      onCharger=self._onCharger)

  def __repr__(self):
    return '{type}(onCharger={onCharger})'.format(
      type=type(self).__name__,
      onCharger=repr(self._onCharger))

Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent = RobotOnChargerPlatformEvent
del RobotOnChargerPlatformEvent


class ChargerEvent(object):
  "Generated message-passing message."

  __slots__ = (
    '_onCharger', # bool
  )

  @property
  def onCharger(self):
    "bool onCharger struct property."
    return self._onCharger

  @onCharger.setter
  def onCharger(self, value):
    self._onCharger = msgbuffers.validate_bool(
      'ChargerEvent.onCharger', value)

  def __init__(self, onCharger=False):
    self.onCharger = onCharger

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ChargerEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ChargerEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ChargerEvent from the given BinaryReader."
    _onCharger = bool(reader.read('b'))
    return cls(_onCharger)

  def pack(self):
    "Writes the current ChargerEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ChargerEvent to the given BinaryWriter."
    writer.write(int(self._onCharger), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._onCharger == other._onCharger
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._onCharger, 'b'))

  def __str__(self):
    return '{type}(onCharger={onCharger})'.format(
      type=type(self).__name__,
      onCharger=self._onCharger)

  def __repr__(self):
    return '{type}(onCharger={onCharger})'.format(
      type=type(self).__name__,
      onCharger=repr(self._onCharger))

Anki.Cozmo.ExternalInterface.ChargerEvent = ChargerEvent
del ChargerEvent


class UnexpectedMovement(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',    # uint_32
    '_movementType', # Anki.Cozmo.UnexpectedMovementType
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'UnexpectedMovement.timestamp', value, 0, 4294967295)

  @property
  def movementType(self):
    "Anki.Cozmo.UnexpectedMovementType movementType struct property."
    return self._movementType

  @movementType.setter
  def movementType(self, value):
    self._movementType = msgbuffers.validate_integer(
      'UnexpectedMovement.movementType', value, 0, 255)

  def __init__(self, timestamp=0, movementType=Anki.Cozmo.UnexpectedMovementType.TURNED_BUT_STOPPED):
    self.timestamp = timestamp
    self.movementType = movementType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UnexpectedMovement from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UnexpectedMovement.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UnexpectedMovement from the given BinaryReader."
    _timestamp = reader.read('I')
    _movementType = reader.read('B')
    return cls(_timestamp, _movementType)

  def pack(self):
    "Writes the current UnexpectedMovement, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UnexpectedMovement to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._movementType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._movementType == other._movementType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._movementType, 'B'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, movementType={movementType})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      movementType=self._movementType)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, movementType={movementType})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      movementType=repr(self._movementType))

Anki.Cozmo.ExternalInterface.UnexpectedMovement = UnexpectedMovement
del UnexpectedMovement


class RestoreRobotStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_isWipe',  # bool
    '_success', # bool
  )

  @property
  def isWipe(self):
    "bool isWipe struct property."
    return self._isWipe

  @isWipe.setter
  def isWipe(self, value):
    self._isWipe = msgbuffers.validate_bool(
      'RestoreRobotStatus.isWipe', value)

  @property
  def success(self):
    "bool success struct property."
    return self._success

  @success.setter
  def success(self, value):
    self._success = msgbuffers.validate_bool(
      'RestoreRobotStatus.success', value)

  def __init__(self, isWipe=False, success=False):
    self.isWipe = isWipe
    self.success = success

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RestoreRobotStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RestoreRobotStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RestoreRobotStatus from the given BinaryReader."
    _isWipe = bool(reader.read('b'))
    _success = bool(reader.read('b'))
    return cls(_isWipe, _success)

  def pack(self):
    "Writes the current RestoreRobotStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RestoreRobotStatus to the given BinaryWriter."
    writer.write(int(self._isWipe), 'b')
    writer.write(int(self._success), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._isWipe == other._isWipe and
        self._success == other._success)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isWipe, 'b') +
      msgbuffers.size(self._success, 'b'))

  def __str__(self):
    return '{type}(isWipe={isWipe}, success={success})'.format(
      type=type(self).__name__,
      isWipe=self._isWipe,
      success=self._success)

  def __repr__(self):
    return '{type}(isWipe={isWipe}, success={success})'.format(
      type=type(self).__name__,
      isWipe=repr(self._isWipe),
      success=repr(self._success))

Anki.Cozmo.ExternalInterface.RestoreRobotStatus = RestoreRobotStatus
del RestoreRobotStatus


class RestoreRobotOptions(object):
  "Generated message-passing message."

  __slots__ = (
    '_shouldPromptForRestore', # bool
    '_robotsWithBackupData',   # uint_32[uint_8]
  )

  @property
  def shouldPromptForRestore(self):
    "bool shouldPromptForRestore struct property."
    return self._shouldPromptForRestore

  @shouldPromptForRestore.setter
  def shouldPromptForRestore(self, value):
    self._shouldPromptForRestore = msgbuffers.validate_bool(
      'RestoreRobotOptions.shouldPromptForRestore', value)

  @property
  def robotsWithBackupData(self):
    "uint_32[uint_8] robotsWithBackupData struct property."
    return self._robotsWithBackupData

  @robotsWithBackupData.setter
  def robotsWithBackupData(self, value):
    self._robotsWithBackupData = msgbuffers.validate_varray(
      'RestoreRobotOptions.robotsWithBackupData', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  def __init__(self, shouldPromptForRestore=False, robotsWithBackupData=()):
    self.shouldPromptForRestore = shouldPromptForRestore
    self.robotsWithBackupData = robotsWithBackupData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RestoreRobotOptions from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RestoreRobotOptions.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RestoreRobotOptions from the given BinaryReader."
    _shouldPromptForRestore = bool(reader.read('b'))
    _robotsWithBackupData = reader.read_varray('I', 'B')
    return cls(_shouldPromptForRestore, _robotsWithBackupData)

  def pack(self):
    "Writes the current RestoreRobotOptions, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RestoreRobotOptions to the given BinaryWriter."
    writer.write(int(self._shouldPromptForRestore), 'b')
    writer.write_varray(self._robotsWithBackupData, 'I', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._shouldPromptForRestore == other._shouldPromptForRestore and
        self._robotsWithBackupData == other._robotsWithBackupData)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._shouldPromptForRestore, 'b') +
      msgbuffers.size_varray(self._robotsWithBackupData, 'I', 'B'))

  def __str__(self):
    return '{type}(shouldPromptForRestore={shouldPromptForRestore}, robotsWithBackupData={robotsWithBackupData})'.format(
      type=type(self).__name__,
      shouldPromptForRestore=self._shouldPromptForRestore,
      robotsWithBackupData=msgbuffers.shorten_sequence(self._robotsWithBackupData))

  def __repr__(self):
    return '{type}(shouldPromptForRestore={shouldPromptForRestore}, robotsWithBackupData={robotsWithBackupData})'.format(
      type=type(self).__name__,
      shouldPromptForRestore=repr(self._shouldPromptForRestore),
      robotsWithBackupData=repr(self._robotsWithBackupData))

Anki.Cozmo.ExternalInterface.RestoreRobotOptions = RestoreRobotOptions
del RestoreRobotOptions


class DebugString(object):
  "Generated message-passing message."

  __slots__ = (
    '_text', # string[uint_8]
  )

  @property
  def text(self):
    "string[uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_string(
      'DebugString.text', value, 255)

  def __init__(self, text=''):
    self.text = text

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DebugString from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DebugString.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DebugString from the given BinaryReader."
    _text = reader.read_string('B')
    return cls(_text)

  def pack(self):
    "Writes the current DebugString, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DebugString to the given BinaryWriter."
    writer.write_string(self._text, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._text == other._text
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._text, 'B'))

  def __str__(self):
    return '{type}(text={text})'.format(
      type=type(self).__name__,
      text=msgbuffers.shorten_string(self._text))

  def __repr__(self):
    return '{type}(text={text})'.format(
      type=type(self).__name__,
      text=repr(self._text))

Anki.Cozmo.ExternalInterface.DebugString = DebugString
del DebugString


class DebugAnimationString(object):
  "Generated message-passing message."

  __slots__ = (
    '_text', # string[uint_8]
  )

  @property
  def text(self):
    "string[uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_string(
      'DebugAnimationString.text', value, 255)

  def __init__(self, text=''):
    self.text = text

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DebugAnimationString from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DebugAnimationString.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DebugAnimationString from the given BinaryReader."
    _text = reader.read_string('B')
    return cls(_text)

  def pack(self):
    "Writes the current DebugAnimationString, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DebugAnimationString to the given BinaryWriter."
    writer.write_string(self._text, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._text == other._text
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._text, 'B'))

  def __str__(self):
    return '{type}(text={text})'.format(
      type=type(self).__name__,
      text=msgbuffers.shorten_string(self._text))

  def __repr__(self):
    return '{type}(text={text})'.format(
      type=type(self).__name__,
      text=repr(self._text))

Anki.Cozmo.ExternalInterface.DebugAnimationString = DebugAnimationString
del DebugAnimationString


class RobotProcessedImage(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',   # uint_32
    '_visionModes', # VisionMode[uint_8]
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'RobotProcessedImage.timestamp', value, 0, 4294967295)

  @property
  def visionModes(self):
    "VisionMode[uint_8] visionModes struct property."
    return self._visionModes

  @visionModes.setter
  def visionModes(self, value):
    self._visionModes = msgbuffers.validate_varray(
      'RobotProcessedImage.visionModes', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 65535))

  def __init__(self, timestamp=0, visionModes=()):
    self.timestamp = timestamp
    self.visionModes = visionModes

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotProcessedImage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotProcessedImage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotProcessedImage from the given BinaryReader."
    _timestamp = reader.read('I')
    _visionModes = reader.read_varray('H', 'B')
    return cls(_timestamp, _visionModes)

  def pack(self):
    "Writes the current RobotProcessedImage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotProcessedImage to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write_varray(self._visionModes, 'H', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._visionModes == other._visionModes)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size_varray(self._visionModes, 'H', 'B'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, visionModes={visionModes})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      visionModes=msgbuffers.shorten_sequence(self._visionModes))

  def __repr__(self):
    return '{type}(timestamp={timestamp}, visionModes={visionModes})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      visionModes=repr(self._visionModes))

Anki.Cozmo.ExternalInterface.RobotProcessedImage = RobotProcessedImage
del RobotProcessedImage


class RobotObservedObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',                # uint_32
    '_timestamp',              # uint_32
    '_objectFamily',           # Anki.Cozmo.ObjectFamily
    '_objectType',             # Anki.Cozmo.ObjectType
    '_objectID',               # int_32
    '_img_rect',               # Anki.CladRect
    '_pose',                   # Anki.PoseStruct3d
    '_topFaceOrientation_rad', # float_32
    '_isActive',               # uint_8
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotObservedObject.robotID', value, 0, 4294967295)

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'RobotObservedObject.timestamp', value, 0, 4294967295)

  @property
  def objectFamily(self):
    "Anki.Cozmo.ObjectFamily objectFamily struct property."
    return self._objectFamily

  @objectFamily.setter
  def objectFamily(self, value):
    self._objectFamily = msgbuffers.validate_integer(
      'RobotObservedObject.objectFamily', value, -2147483648, 2147483647)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'RobotObservedObject.objectType', value, -2147483648, 2147483647)

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'RobotObservedObject.objectID', value, -2147483648, 2147483647)

  @property
  def img_rect(self):
    "Anki.CladRect img_rect struct property."
    return self._img_rect

  @img_rect.setter
  def img_rect(self, value):
    self._img_rect = msgbuffers.validate_object(
      'RobotObservedObject.img_rect', value, Anki.CladRect)

  @property
  def pose(self):
    "Anki.PoseStruct3d pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_object(
      'RobotObservedObject.pose', value, Anki.PoseStruct3d)

  @property
  def topFaceOrientation_rad(self):
    "float_32 topFaceOrientation_rad struct property."
    return self._topFaceOrientation_rad

  @topFaceOrientation_rad.setter
  def topFaceOrientation_rad(self, value):
    self._topFaceOrientation_rad = msgbuffers.validate_float(
      'RobotObservedObject.topFaceOrientation_rad', value, 'f')

  @property
  def isActive(self):
    "uint_8 isActive struct property."
    return self._isActive

  @isActive.setter
  def isActive(self, value):
    self._isActive = msgbuffers.validate_integer(
      'RobotObservedObject.isActive', value, 0, 255)

  def __init__(self, robotID=0, timestamp=0, objectFamily=Anki.Cozmo.ObjectFamily.Invalid, objectType=Anki.Cozmo.ObjectType.Invalid, objectID=0, img_rect=Anki.CladRect(), pose=Anki.PoseStruct3d(), topFaceOrientation_rad=0.0, isActive=0):
    self.robotID = robotID
    self.timestamp = timestamp
    self.objectFamily = objectFamily
    self.objectType = objectType
    self.objectID = objectID
    self.img_rect = img_rect
    self.pose = pose
    self.topFaceOrientation_rad = topFaceOrientation_rad
    self.isActive = isActive

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotObservedObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotObservedObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotObservedObject from the given BinaryReader."
    _robotID = reader.read('I')
    _timestamp = reader.read('I')
    _objectFamily = reader.read('i')
    _objectType = reader.read('i')
    _objectID = reader.read('i')
    _img_rect = reader.read_object(Anki.CladRect.unpack_from)
    _pose = reader.read_object(Anki.PoseStruct3d.unpack_from)
    _topFaceOrientation_rad = reader.read('f')
    _isActive = reader.read('B')
    return cls(_robotID, _timestamp, _objectFamily, _objectType, _objectID, _img_rect, _pose, _topFaceOrientation_rad, _isActive)

  def pack(self):
    "Writes the current RobotObservedObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotObservedObject to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._timestamp, 'I')
    writer.write(self._objectFamily, 'i')
    writer.write(self._objectType, 'i')
    writer.write(self._objectID, 'i')
    writer.write_object(self._img_rect)
    writer.write_object(self._pose)
    writer.write(self._topFaceOrientation_rad, 'f')
    writer.write(self._isActive, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._timestamp == other._timestamp and
        self._objectFamily == other._objectFamily and
        self._objectType == other._objectType and
        self._objectID == other._objectID and
        self._img_rect == other._img_rect and
        self._pose == other._pose and
        self._topFaceOrientation_rad == other._topFaceOrientation_rad and
        self._isActive == other._isActive)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectFamily, 'i') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._img_rect) +
      msgbuffers.size_object(self._pose) +
      msgbuffers.size(self._topFaceOrientation_rad, 'f') +
      msgbuffers.size(self._isActive, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, timestamp={timestamp}, objectFamily={objectFamily}, objectType={objectType}, objectID={objectID}, img_rect={img_rect}, pose={pose}, topFaceOrientation_rad={topFaceOrientation_rad}, isActive={isActive})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      timestamp=self._timestamp,
      objectFamily=self._objectFamily,
      objectType=self._objectType,
      objectID=self._objectID,
      img_rect=self._img_rect,
      pose=self._pose,
      topFaceOrientation_rad=self._topFaceOrientation_rad,
      isActive=self._isActive)

  def __repr__(self):
    return '{type}(robotID={robotID}, timestamp={timestamp}, objectFamily={objectFamily}, objectType={objectType}, objectID={objectID}, img_rect={img_rect}, pose={pose}, topFaceOrientation_rad={topFaceOrientation_rad}, isActive={isActive})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      timestamp=repr(self._timestamp),
      objectFamily=repr(self._objectFamily),
      objectType=repr(self._objectType),
      objectID=repr(self._objectID),
      img_rect=repr(self._img_rect),
      pose=repr(self._pose),
      topFaceOrientation_rad=repr(self._topFaceOrientation_rad),
      isActive=repr(self._isActive))

Anki.Cozmo.ExternalInterface.RobotObservedObject = RobotObservedObject
del RobotObservedObject


class RobotObservedPossibleObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_possibleObject', # Anki.Cozmo.ExternalInterface.RobotObservedObject
  )

  @property
  def possibleObject(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedObject possibleObject struct property."
    return self._possibleObject

  @possibleObject.setter
  def possibleObject(self, value):
    self._possibleObject = msgbuffers.validate_object(
      'RobotObservedPossibleObject.possibleObject', value, Anki.Cozmo.ExternalInterface.RobotObservedObject)

  def __init__(self, possibleObject=Anki.Cozmo.ExternalInterface.RobotObservedObject()):
    self.possibleObject = possibleObject

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotObservedPossibleObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotObservedPossibleObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotObservedPossibleObject from the given BinaryReader."
    _possibleObject = reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedObject.unpack_from)
    return cls(_possibleObject)

  def pack(self):
    "Writes the current RobotObservedPossibleObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotObservedPossibleObject to the given BinaryWriter."
    writer.write_object(self._possibleObject)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._possibleObject == other._possibleObject
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._possibleObject))

  def __str__(self):
    return '{type}(possibleObject={possibleObject})'.format(
      type=type(self).__name__,
      possibleObject=self._possibleObject)

  def __repr__(self):
    return '{type}(possibleObject={possibleObject})'.format(
      type=type(self).__name__,
      possibleObject=repr(self._possibleObject))

Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject = RobotObservedPossibleObject
del RobotObservedPossibleObject


class ObjectProjectsIntoFOV(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',    # uint_32
    '_objectFamily', # Anki.Cozmo.ObjectFamily
    '_objectType',   # Anki.Cozmo.ObjectType
    '_objectID',     # int_32
    '_img_rect',     # Anki.CladRect
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'ObjectProjectsIntoFOV.timestamp', value, 0, 4294967295)

  @property
  def objectFamily(self):
    "Anki.Cozmo.ObjectFamily objectFamily struct property."
    return self._objectFamily

  @objectFamily.setter
  def objectFamily(self, value):
    self._objectFamily = msgbuffers.validate_integer(
      'ObjectProjectsIntoFOV.objectFamily', value, -2147483648, 2147483647)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'ObjectProjectsIntoFOV.objectType', value, -2147483648, 2147483647)

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectProjectsIntoFOV.objectID', value, -2147483648, 2147483647)

  @property
  def img_rect(self):
    "Anki.CladRect img_rect struct property."
    return self._img_rect

  @img_rect.setter
  def img_rect(self, value):
    self._img_rect = msgbuffers.validate_object(
      'ObjectProjectsIntoFOV.img_rect', value, Anki.CladRect)

  def __init__(self, timestamp=0, objectFamily=Anki.Cozmo.ObjectFamily.Invalid, objectType=Anki.Cozmo.ObjectType.Invalid, objectID=0, img_rect=Anki.CladRect()):
    self.timestamp = timestamp
    self.objectFamily = objectFamily
    self.objectType = objectType
    self.objectID = objectID
    self.img_rect = img_rect

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectProjectsIntoFOV from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectProjectsIntoFOV.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectProjectsIntoFOV from the given BinaryReader."
    _timestamp = reader.read('I')
    _objectFamily = reader.read('i')
    _objectType = reader.read('i')
    _objectID = reader.read('i')
    _img_rect = reader.read_object(Anki.CladRect.unpack_from)
    return cls(_timestamp, _objectFamily, _objectType, _objectID, _img_rect)

  def pack(self):
    "Writes the current ObjectProjectsIntoFOV, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectProjectsIntoFOV to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._objectFamily, 'i')
    writer.write(self._objectType, 'i')
    writer.write(self._objectID, 'i')
    writer.write_object(self._img_rect)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._objectFamily == other._objectFamily and
        self._objectType == other._objectType and
        self._objectID == other._objectID and
        self._img_rect == other._img_rect)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectFamily, 'i') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size_object(self._img_rect))

  def __str__(self):
    return '{type}(timestamp={timestamp}, objectFamily={objectFamily}, objectType={objectType}, objectID={objectID}, img_rect={img_rect})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      objectFamily=self._objectFamily,
      objectType=self._objectType,
      objectID=self._objectID,
      img_rect=self._img_rect)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, objectFamily={objectFamily}, objectType={objectType}, objectID={objectID}, img_rect={img_rect})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      objectFamily=repr(self._objectFamily),
      objectType=repr(self._objectType),
      objectID=repr(self._objectID),
      img_rect=repr(self._img_rect))

Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV = ObjectProjectsIntoFOV
del ObjectProjectsIntoFOV


class RobotObservedFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',     # int_32
    '_robotID',    # uint_32
    '_timestamp',  # uint_32
    '_pose',       # Anki.PoseStruct3d
    '_img_rect',   # Anki.CladRect
    '_name',       # string[uint_8]
    '_expression', # Anki.Vision.FacialExpression
    '_leftEye',    # CladPoint2d[uint_8]
    '_rightEye',   # CladPoint2d[uint_8]
    '_nose',       # CladPoint2d[uint_8]
    '_mouth',      # CladPoint2d[uint_8]
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'RobotObservedFace.faceID', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotObservedFace.robotID', value, 0, 4294967295)

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'RobotObservedFace.timestamp', value, 0, 4294967295)

  @property
  def pose(self):
    "Anki.PoseStruct3d pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_object(
      'RobotObservedFace.pose', value, Anki.PoseStruct3d)

  @property
  def img_rect(self):
    "Anki.CladRect img_rect struct property."
    return self._img_rect

  @img_rect.setter
  def img_rect(self, value):
    self._img_rect = msgbuffers.validate_object(
      'RobotObservedFace.img_rect', value, Anki.CladRect)

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'RobotObservedFace.name', value, 255)

  @property
  def expression(self):
    "Anki.Vision.FacialExpression expression struct property."
    return self._expression

  @expression.setter
  def expression(self, value):
    self._expression = msgbuffers.validate_integer(
      'RobotObservedFace.expression', value, 0, 255)

  @property
  def leftEye(self):
    "CladPoint2d[uint_8] leftEye struct property."
    return self._leftEye

  @leftEye.setter
  def leftEye(self, value):
    self._leftEye = msgbuffers.validate_varray(
      'RobotObservedFace.leftEye', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.CladPoint2d))

  @property
  def rightEye(self):
    "CladPoint2d[uint_8] rightEye struct property."
    return self._rightEye

  @rightEye.setter
  def rightEye(self, value):
    self._rightEye = msgbuffers.validate_varray(
      'RobotObservedFace.rightEye', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.CladPoint2d))

  @property
  def nose(self):
    "CladPoint2d[uint_8] nose struct property."
    return self._nose

  @nose.setter
  def nose(self, value):
    self._nose = msgbuffers.validate_varray(
      'RobotObservedFace.nose', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.CladPoint2d))

  @property
  def mouth(self):
    "CladPoint2d[uint_8] mouth struct property."
    return self._mouth

  @mouth.setter
  def mouth(self, value):
    self._mouth = msgbuffers.validate_varray(
      'RobotObservedFace.mouth', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.CladPoint2d))

  def __init__(self, faceID=0, robotID=0, timestamp=0, pose=Anki.PoseStruct3d(), img_rect=Anki.CladRect(), name='', expression=Anki.Vision.FacialExpression.Unknown, leftEye=(), rightEye=(), nose=(), mouth=()):
    self.faceID = faceID
    self.robotID = robotID
    self.timestamp = timestamp
    self.pose = pose
    self.img_rect = img_rect
    self.name = name
    self.expression = expression
    self.leftEye = leftEye
    self.rightEye = rightEye
    self.nose = nose
    self.mouth = mouth

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotObservedFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotObservedFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotObservedFace from the given BinaryReader."
    _faceID = reader.read('i')
    _robotID = reader.read('I')
    _timestamp = reader.read('I')
    _pose = reader.read_object(Anki.PoseStruct3d.unpack_from)
    _img_rect = reader.read_object(Anki.CladRect.unpack_from)
    _name = reader.read_string('B')
    _expression = reader.read('B')
    _leftEye = reader.read_object_varray(Anki.CladPoint2d.unpack_from, 'B')
    _rightEye = reader.read_object_varray(Anki.CladPoint2d.unpack_from, 'B')
    _nose = reader.read_object_varray(Anki.CladPoint2d.unpack_from, 'B')
    _mouth = reader.read_object_varray(Anki.CladPoint2d.unpack_from, 'B')
    return cls(_faceID, _robotID, _timestamp, _pose, _img_rect, _name, _expression, _leftEye, _rightEye, _nose, _mouth)

  def pack(self):
    "Writes the current RobotObservedFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotObservedFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._robotID, 'I')
    writer.write(self._timestamp, 'I')
    writer.write_object(self._pose)
    writer.write_object(self._img_rect)
    writer.write_string(self._name, 'B')
    writer.write(self._expression, 'B')
    writer.write_object_varray(self._leftEye, 'B')
    writer.write_object_varray(self._rightEye, 'B')
    writer.write_object_varray(self._nose, 'B')
    writer.write_object_varray(self._mouth, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._robotID == other._robotID and
        self._timestamp == other._timestamp and
        self._pose == other._pose and
        self._img_rect == other._img_rect and
        self._name == other._name and
        self._expression == other._expression and
        self._leftEye == other._leftEye and
        self._rightEye == other._rightEye and
        self._nose == other._nose and
        self._mouth == other._mouth)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size_object(self._pose) +
      msgbuffers.size_object(self._img_rect) +
      msgbuffers.size_string(self._name, 'B') +
      msgbuffers.size(self._expression, 'B') +
      msgbuffers.size_object_varray(self._leftEye, 'B') +
      msgbuffers.size_object_varray(self._rightEye, 'B') +
      msgbuffers.size_object_varray(self._nose, 'B') +
      msgbuffers.size_object_varray(self._mouth, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, robotID={robotID}, timestamp={timestamp}, pose={pose}, img_rect={img_rect}, name={name}, expression={expression}, leftEye={leftEye}, rightEye={rightEye}, nose={nose}, mouth={mouth})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      robotID=self._robotID,
      timestamp=self._timestamp,
      pose=self._pose,
      img_rect=self._img_rect,
      name=msgbuffers.shorten_string(self._name),
      expression=self._expression,
      leftEye=msgbuffers.shorten_sequence(self._leftEye),
      rightEye=msgbuffers.shorten_sequence(self._rightEye),
      nose=msgbuffers.shorten_sequence(self._nose),
      mouth=msgbuffers.shorten_sequence(self._mouth))

  def __repr__(self):
    return '{type}(faceID={faceID}, robotID={robotID}, timestamp={timestamp}, pose={pose}, img_rect={img_rect}, name={name}, expression={expression}, leftEye={leftEye}, rightEye={rightEye}, nose={nose}, mouth={mouth})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      robotID=repr(self._robotID),
      timestamp=repr(self._timestamp),
      pose=repr(self._pose),
      img_rect=repr(self._img_rect),
      name=repr(self._name),
      expression=repr(self._expression),
      leftEye=repr(self._leftEye),
      rightEye=repr(self._rightEye),
      nose=repr(self._nose),
      mouth=repr(self._mouth))

Anki.Cozmo.ExternalInterface.RobotObservedFace = RobotObservedFace
del RobotObservedFace


class RobotChangedObservedFaceID(object):
  "Generated message-passing message."

  __slots__ = (
    '_oldID', # int_32
    '_newID', # int_32
  )

  @property
  def oldID(self):
    "int_32 oldID struct property."
    return self._oldID

  @oldID.setter
  def oldID(self, value):
    self._oldID = msgbuffers.validate_integer(
      'RobotChangedObservedFaceID.oldID', value, -2147483648, 2147483647)

  @property
  def newID(self):
    "int_32 newID struct property."
    return self._newID

  @newID.setter
  def newID(self, value):
    self._newID = msgbuffers.validate_integer(
      'RobotChangedObservedFaceID.newID', value, -2147483648, 2147483647)

  def __init__(self, oldID=0, newID=0):
    self.oldID = oldID
    self.newID = newID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotChangedObservedFaceID from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotChangedObservedFaceID.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotChangedObservedFaceID from the given BinaryReader."
    _oldID = reader.read('i')
    _newID = reader.read('i')
    return cls(_oldID, _newID)

  def pack(self):
    "Writes the current RobotChangedObservedFaceID, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotChangedObservedFaceID to the given BinaryWriter."
    writer.write(self._oldID, 'i')
    writer.write(self._newID, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._oldID == other._oldID and
        self._newID == other._newID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._oldID, 'i') +
      msgbuffers.size(self._newID, 'i'))

  def __str__(self):
    return '{type}(oldID={oldID}, newID={newID})'.format(
      type=type(self).__name__,
      oldID=self._oldID,
      newID=self._newID)

  def __repr__(self):
    return '{type}(oldID={oldID}, newID={newID})'.format(
      type=type(self).__name__,
      oldID=repr(self._oldID),
      newID=repr(self._newID))

Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID = RobotChangedObservedFaceID
del RobotChangedObservedFaceID


class RobotObservedPet(object):
  "Generated message-passing message."

  __slots__ = (
    '_petID',            # int_32
    '_timestamp',        # uint_32
    '_numTimesObserved', # uint_32
    '_score',            # float_32
    '_img_rect',         # Anki.CladRect
    '_petType',          # Anki.Vision.PetType
  )

  @property
  def petID(self):
    "int_32 petID struct property."
    return self._petID

  @petID.setter
  def petID(self, value):
    self._petID = msgbuffers.validate_integer(
      'RobotObservedPet.petID', value, -2147483648, 2147483647)

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'RobotObservedPet.timestamp', value, 0, 4294967295)

  @property
  def numTimesObserved(self):
    "uint_32 numTimesObserved struct property."
    return self._numTimesObserved

  @numTimesObserved.setter
  def numTimesObserved(self, value):
    self._numTimesObserved = msgbuffers.validate_integer(
      'RobotObservedPet.numTimesObserved', value, 0, 4294967295)

  @property
  def score(self):
    "float_32 score struct property."
    return self._score

  @score.setter
  def score(self, value):
    self._score = msgbuffers.validate_float(
      'RobotObservedPet.score', value, 'f')

  @property
  def img_rect(self):
    "Anki.CladRect img_rect struct property."
    return self._img_rect

  @img_rect.setter
  def img_rect(self, value):
    self._img_rect = msgbuffers.validate_object(
      'RobotObservedPet.img_rect', value, Anki.CladRect)

  @property
  def petType(self):
    "Anki.Vision.PetType petType struct property."
    return self._petType

  @petType.setter
  def petType(self, value):
    self._petType = msgbuffers.validate_integer(
      'RobotObservedPet.petType', value, 0, 255)

  def __init__(self, petID=0, timestamp=0, numTimesObserved=0, score=0.0, img_rect=Anki.CladRect(), petType=Anki.Vision.PetType.Unknown):
    self.petID = petID
    self.timestamp = timestamp
    self.numTimesObserved = numTimesObserved
    self.score = score
    self.img_rect = img_rect
    self.petType = petType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotObservedPet from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotObservedPet.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotObservedPet from the given BinaryReader."
    _petID = reader.read('i')
    _timestamp = reader.read('I')
    _numTimesObserved = reader.read('I')
    _score = reader.read('f')
    _img_rect = reader.read_object(Anki.CladRect.unpack_from)
    _petType = reader.read('B')
    return cls(_petID, _timestamp, _numTimesObserved, _score, _img_rect, _petType)

  def pack(self):
    "Writes the current RobotObservedPet, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotObservedPet to the given BinaryWriter."
    writer.write(self._petID, 'i')
    writer.write(self._timestamp, 'I')
    writer.write(self._numTimesObserved, 'I')
    writer.write(self._score, 'f')
    writer.write_object(self._img_rect)
    writer.write(self._petType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._petID == other._petID and
        self._timestamp == other._timestamp and
        self._numTimesObserved == other._numTimesObserved and
        self._score == other._score and
        self._img_rect == other._img_rect and
        self._petType == other._petType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._petID, 'i') +
      msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._numTimesObserved, 'I') +
      msgbuffers.size(self._score, 'f') +
      msgbuffers.size_object(self._img_rect) +
      msgbuffers.size(self._petType, 'B'))

  def __str__(self):
    return '{type}(petID={petID}, timestamp={timestamp}, numTimesObserved={numTimesObserved}, score={score}, img_rect={img_rect}, petType={petType})'.format(
      type=type(self).__name__,
      petID=self._petID,
      timestamp=self._timestamp,
      numTimesObserved=self._numTimesObserved,
      score=self._score,
      img_rect=self._img_rect,
      petType=self._petType)

  def __repr__(self):
    return '{type}(petID={petID}, timestamp={timestamp}, numTimesObserved={numTimesObserved}, score={score}, img_rect={img_rect}, petType={petType})'.format(
      type=type(self).__name__,
      petID=repr(self._petID),
      timestamp=repr(self._timestamp),
      numTimesObserved=repr(self._numTimesObserved),
      score=repr(self._score),
      img_rect=repr(self._img_rect),
      petType=repr(self._petType))

Anki.Cozmo.ExternalInterface.RobotObservedPet = RobotObservedPet
del RobotObservedPet


class RobotObservedMotion(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',   # uint_32
    '_img_area',    # float_32
    '_img_x',       # int_16
    '_img_y',       # int_16
    '_ground_area', # float_32
    '_ground_x',    # int_16
    '_ground_y',    # int_16
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'RobotObservedMotion.timestamp', value, 0, 4294967295)

  @property
  def img_area(self):
    "float_32 img_area struct property."
    return self._img_area

  @img_area.setter
  def img_area(self, value):
    self._img_area = msgbuffers.validate_float(
      'RobotObservedMotion.img_area', value, 'f')

  @property
  def img_x(self):
    "int_16 img_x struct property."
    return self._img_x

  @img_x.setter
  def img_x(self, value):
    self._img_x = msgbuffers.validate_integer(
      'RobotObservedMotion.img_x', value, -32768, 32767)

  @property
  def img_y(self):
    "int_16 img_y struct property."
    return self._img_y

  @img_y.setter
  def img_y(self, value):
    self._img_y = msgbuffers.validate_integer(
      'RobotObservedMotion.img_y', value, -32768, 32767)

  @property
  def ground_area(self):
    "float_32 ground_area struct property."
    return self._ground_area

  @ground_area.setter
  def ground_area(self, value):
    self._ground_area = msgbuffers.validate_float(
      'RobotObservedMotion.ground_area', value, 'f')

  @property
  def ground_x(self):
    "int_16 ground_x struct property."
    return self._ground_x

  @ground_x.setter
  def ground_x(self, value):
    self._ground_x = msgbuffers.validate_integer(
      'RobotObservedMotion.ground_x', value, -32768, 32767)

  @property
  def ground_y(self):
    "int_16 ground_y struct property."
    return self._ground_y

  @ground_y.setter
  def ground_y(self, value):
    self._ground_y = msgbuffers.validate_integer(
      'RobotObservedMotion.ground_y', value, -32768, 32767)

  def __init__(self, timestamp=0, img_area=0.0, img_x=0, img_y=0, ground_area=0.0, ground_x=0, ground_y=0):
    self.timestamp = timestamp
    self.img_area = img_area
    self.img_x = img_x
    self.img_y = img_y
    self.ground_area = ground_area
    self.ground_x = ground_x
    self.ground_y = ground_y

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotObservedMotion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotObservedMotion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotObservedMotion from the given BinaryReader."
    _timestamp = reader.read('I')
    _img_area = reader.read('f')
    _img_x = reader.read('h')
    _img_y = reader.read('h')
    _ground_area = reader.read('f')
    _ground_x = reader.read('h')
    _ground_y = reader.read('h')
    return cls(_timestamp, _img_area, _img_x, _img_y, _ground_area, _ground_x, _ground_y)

  def pack(self):
    "Writes the current RobotObservedMotion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotObservedMotion to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._img_area, 'f')
    writer.write(self._img_x, 'h')
    writer.write(self._img_y, 'h')
    writer.write(self._ground_area, 'f')
    writer.write(self._ground_x, 'h')
    writer.write(self._ground_y, 'h')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._img_area == other._img_area and
        self._img_x == other._img_x and
        self._img_y == other._img_y and
        self._ground_area == other._ground_area and
        self._ground_x == other._ground_x and
        self._ground_y == other._ground_y)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._img_area, 'f') +
      msgbuffers.size(self._img_x, 'h') +
      msgbuffers.size(self._img_y, 'h') +
      msgbuffers.size(self._ground_area, 'f') +
      msgbuffers.size(self._ground_x, 'h') +
      msgbuffers.size(self._ground_y, 'h'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, img_area={img_area}, img_x={img_x}, img_y={img_y}, ground_area={ground_area}, ground_x={ground_x}, ground_y={ground_y})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      img_area=self._img_area,
      img_x=self._img_x,
      img_y=self._img_y,
      ground_area=self._ground_area,
      ground_x=self._ground_x,
      ground_y=self._ground_y)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, img_area={img_area}, img_x={img_x}, img_y={img_y}, ground_area={ground_area}, ground_x={ground_x}, ground_y={ground_y})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      img_area=repr(self._img_area),
      img_x=repr(self._img_x),
      img_y=repr(self._img_y),
      ground_area=repr(self._ground_area),
      ground_x=repr(self._ground_x),
      ground_y=repr(self._ground_y))

Anki.Cozmo.ExternalInterface.RobotObservedMotion = RobotObservedMotion
del RobotObservedMotion


class RobotDeletedFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',  # int_32
    '_robotID', # uint_32
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'RobotDeletedFace.faceID', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDeletedFace.robotID', value, 0, 4294967295)

  def __init__(self, faceID=0, robotID=0):
    self.faceID = faceID
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDeletedFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDeletedFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDeletedFace from the given BinaryReader."
    _faceID = reader.read('i')
    _robotID = reader.read('I')
    return cls(_faceID, _robotID)

  def pack(self):
    "Writes the current RobotDeletedFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDeletedFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._robotID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._robotID, 'I'))

  def __str__(self):
    return '{type}(faceID={faceID}, robotID={robotID})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(faceID={faceID}, robotID={robotID})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotDeletedFace = RobotDeletedFace
del RobotDeletedFace


class RobotDeletedObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',  # uint_32
    '_objectID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDeletedObject.robotID', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'RobotDeletedObject.objectID', value, 0, 4294967295)

  def __init__(self, robotID=0, objectID=0):
    self.robotID = robotID
    self.objectID = objectID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDeletedObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDeletedObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDeletedObject from the given BinaryReader."
    _robotID = reader.read('I')
    _objectID = reader.read('I')
    return cls(_robotID, _objectID)

  def pack(self):
    "Writes the current RobotDeletedObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDeletedObject to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._objectID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._objectID == other._objectID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._objectID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      objectID=self._objectID)

  def __repr__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      objectID=repr(self._objectID))

Anki.Cozmo.ExternalInterface.RobotDeletedObject = RobotDeletedObject
del RobotDeletedObject


class RobotDeletedAllObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDeletedAllObjects.robotID', value, 0, 4294967295)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDeletedAllObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDeletedAllObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDeletedAllObjects from the given BinaryReader."
    _robotID = reader.read('I')
    return cls(_robotID)

  def pack(self):
    "Writes the current RobotDeletedAllObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDeletedAllObjects to the given BinaryWriter."
    writer.write(self._robotID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects = RobotDeletedAllObjects
del RobotDeletedAllObjects


class RobotDeletedAllCustomObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotDeletedAllCustomObjects.robotID', value, 0, 4294967295)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotDeletedAllCustomObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotDeletedAllCustomObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotDeletedAllCustomObjects from the given BinaryReader."
    _robotID = reader.read('I')
    return cls(_robotID)

  def pack(self):
    "Writes the current RobotDeletedAllCustomObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotDeletedAllCustomObjects to the given BinaryWriter."
    writer.write(self._robotID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects = RobotDeletedAllCustomObjects
del RobotDeletedAllCustomObjects


class CreatedFixedCustomObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',  # uint_32
    '_objectID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'CreatedFixedCustomObject.robotID', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'CreatedFixedCustomObject.objectID', value, 0, 4294967295)

  def __init__(self, robotID=0, objectID=0):
    self.robotID = robotID
    self.objectID = objectID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CreatedFixedCustomObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CreatedFixedCustomObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CreatedFixedCustomObject from the given BinaryReader."
    _robotID = reader.read('I')
    _objectID = reader.read('I')
    return cls(_robotID, _objectID)

  def pack(self):
    "Writes the current CreatedFixedCustomObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CreatedFixedCustomObject to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._objectID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._objectID == other._objectID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._objectID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      objectID=self._objectID)

  def __repr__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      objectID=repr(self._objectID))

Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject = CreatedFixedCustomObject
del CreatedFixedCustomObject


class DefinedCustomObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'DefinedCustomObject.robotID', value, 0, 4294967295)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DefinedCustomObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DefinedCustomObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DefinedCustomObject from the given BinaryReader."
    _robotID = reader.read('I')
    return cls(_robotID)

  def pack(self):
    "Writes the current DefinedCustomObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DefinedCustomObject to the given BinaryWriter."
    writer.write(self._robotID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.DefinedCustomObject = DefinedCustomObject
del DefinedCustomObject


class RobotMarkedObjectPoseUnknown(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',  # uint_32
    '_objectID', # uint_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotMarkedObjectPoseUnknown.robotID', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'RobotMarkedObjectPoseUnknown.objectID', value, 0, 4294967295)

  def __init__(self, robotID=0, objectID=0):
    self.robotID = robotID
    self.objectID = objectID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotMarkedObjectPoseUnknown from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotMarkedObjectPoseUnknown.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotMarkedObjectPoseUnknown from the given BinaryReader."
    _robotID = reader.read('I')
    _objectID = reader.read('I')
    return cls(_robotID, _objectID)

  def pack(self):
    "Writes the current RobotMarkedObjectPoseUnknown, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotMarkedObjectPoseUnknown to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._objectID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._objectID == other._objectID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._objectID, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      objectID=self._objectID)

  def __repr__(self):
    return '{type}(robotID={robotID}, objectID={objectID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      objectID=repr(self._objectID))

Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown = RobotMarkedObjectPoseUnknown
del RobotMarkedObjectPoseUnknown


class AvailableObject(object):
  "Generated message-passing structure."

  __slots__ = (
    '_objectID',              # uint_32
    '_lastObservedTimestamp', # uint_32
    '_objectFamily',          # Anki.Cozmo.ObjectFamily
    '_objectType',            # Anki.Cozmo.ObjectType
    '_pose',                  # Anki.PoseStruct3d
    '_poseState',             # Anki.PoseState
    '_isConnected',           # bool
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'AvailableObject.objectID', value, 0, 4294967295)

  @property
  def lastObservedTimestamp(self):
    "uint_32 lastObservedTimestamp struct property."
    return self._lastObservedTimestamp

  @lastObservedTimestamp.setter
  def lastObservedTimestamp(self, value):
    self._lastObservedTimestamp = msgbuffers.validate_integer(
      'AvailableObject.lastObservedTimestamp', value, 0, 4294967295)

  @property
  def objectFamily(self):
    "Anki.Cozmo.ObjectFamily objectFamily struct property."
    return self._objectFamily

  @objectFamily.setter
  def objectFamily(self, value):
    self._objectFamily = msgbuffers.validate_integer(
      'AvailableObject.objectFamily', value, -2147483648, 2147483647)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'AvailableObject.objectType', value, -2147483648, 2147483647)

  @property
  def pose(self):
    "Anki.PoseStruct3d pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_object(
      'AvailableObject.pose', value, Anki.PoseStruct3d)

  @property
  def poseState(self):
    "Anki.PoseState poseState struct property."
    return self._poseState

  @poseState.setter
  def poseState(self, value):
    self._poseState = msgbuffers.validate_integer(
      'AvailableObject.poseState', value, 0, 255)

  @property
  def isConnected(self):
    "bool isConnected struct property."
    return self._isConnected

  @isConnected.setter
  def isConnected(self, value):
    self._isConnected = msgbuffers.validate_bool(
      'AvailableObject.isConnected', value)

  def __init__(self, objectID=0, lastObservedTimestamp=0, objectFamily=Anki.Cozmo.ObjectFamily.Invalid, objectType=Anki.Cozmo.ObjectType.Invalid, pose=Anki.PoseStruct3d(), poseState=Anki.PoseState.Known, isConnected=False):
    self.objectID = objectID
    self.lastObservedTimestamp = lastObservedTimestamp
    self.objectFamily = objectFamily
    self.objectType = objectType
    self.pose = pose
    self.poseState = poseState
    self.isConnected = isConnected

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AvailableObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AvailableObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AvailableObject from the given BinaryReader."
    _objectID = reader.read('I')
    _lastObservedTimestamp = reader.read('I')
    _objectFamily = reader.read('i')
    _objectType = reader.read('i')
    _pose = reader.read_object(Anki.PoseStruct3d.unpack_from)
    _poseState = reader.read('B')
    _isConnected = bool(reader.read('b'))
    return cls(_objectID, _lastObservedTimestamp, _objectFamily, _objectType, _pose, _poseState, _isConnected)

  def pack(self):
    "Writes the current AvailableObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AvailableObject to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._lastObservedTimestamp, 'I')
    writer.write(self._objectFamily, 'i')
    writer.write(self._objectType, 'i')
    writer.write_object(self._pose)
    writer.write(self._poseState, 'B')
    writer.write(int(self._isConnected), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._lastObservedTimestamp == other._lastObservedTimestamp and
        self._objectFamily == other._objectFamily and
        self._objectType == other._objectType and
        self._pose == other._pose and
        self._poseState == other._poseState and
        self._isConnected == other._isConnected)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._lastObservedTimestamp, 'I') +
      msgbuffers.size(self._objectFamily, 'i') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size_object(self._pose) +
      msgbuffers.size(self._poseState, 'B') +
      msgbuffers.size(self._isConnected, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, lastObservedTimestamp={lastObservedTimestamp}, objectFamily={objectFamily}, objectType={objectType}, pose={pose}, poseState={poseState}, isConnected={isConnected})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      lastObservedTimestamp=self._lastObservedTimestamp,
      objectFamily=self._objectFamily,
      objectType=self._objectType,
      pose=self._pose,
      poseState=self._poseState,
      isConnected=self._isConnected)

  def __repr__(self):
    return '{type}(objectID={objectID}, lastObservedTimestamp={lastObservedTimestamp}, objectFamily={objectFamily}, objectType={objectType}, pose={pose}, poseState={poseState}, isConnected={isConnected})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      lastObservedTimestamp=repr(self._lastObservedTimestamp),
      objectFamily=repr(self._objectFamily),
      objectType=repr(self._objectType),
      pose=repr(self._pose),
      poseState=repr(self._poseState),
      isConnected=repr(self._isConnected))

Anki.Cozmo.ExternalInterface.AvailableObject = AvailableObject
del AvailableObject


class AvailableObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_objects', # AvailableObject[uint_8]
  )

  @property
  def objects(self):
    "AvailableObject[uint_8] objects struct property."
    return self._objects

  @objects.setter
  def objects(self, value):
    self._objects = msgbuffers.validate_varray(
      'AvailableObjects.objects', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.ExternalInterface.AvailableObject))

  def __init__(self, objects=()):
    self.objects = objects

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AvailableObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AvailableObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AvailableObjects from the given BinaryReader."
    _objects = reader.read_object_varray(Anki.Cozmo.ExternalInterface.AvailableObject.unpack_from, 'B')
    return cls(_objects)

  def pack(self):
    "Writes the current AvailableObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AvailableObjects to the given BinaryWriter."
    writer.write_object_varray(self._objects, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._objects == other._objects
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object_varray(self._objects, 'B'))

  def __str__(self):
    return '{type}(objects={objects})'.format(
      type=type(self).__name__,
      objects=msgbuffers.shorten_sequence(self._objects))

  def __repr__(self):
    return '{type}(objects={objects})'.format(
      type=type(self).__name__,
      objects=repr(self._objects))

Anki.Cozmo.ExternalInterface.AvailableObjects = AvailableObjects
del AvailableObjects


class RobotReadToolCode(object):
  "Generated message-passing message."

  __slots__ = (
    '_info', # Anki.Cozmo.ToolCodeInfo
  )

  @property
  def info(self):
    "Anki.Cozmo.ToolCodeInfo info struct property."
    return self._info

  @info.setter
  def info(self, value):
    self._info = msgbuffers.validate_object(
      'RobotReadToolCode.info', value, Anki.Cozmo.ToolCodeInfo)

  def __init__(self, info=Anki.Cozmo.ToolCodeInfo()):
    self.info = info

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotReadToolCode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotReadToolCode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotReadToolCode from the given BinaryReader."
    _info = reader.read_object(Anki.Cozmo.ToolCodeInfo.unpack_from)
    return cls(_info)

  def pack(self):
    "Writes the current RobotReadToolCode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotReadToolCode to the given BinaryWriter."
    writer.write_object(self._info)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._info == other._info
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._info))

  def __str__(self):
    return '{type}(info={info})'.format(
      type=type(self).__name__,
      info=self._info)

  def __repr__(self):
    return '{type}(info={info})'.format(
      type=type(self).__name__,
      info=repr(self._info))

Anki.Cozmo.ExternalInterface.RobotReadToolCode = RobotReadToolCode
del RobotReadToolCode


class RobotReachedEnrollmentCount(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID', # int_32
    '_count',  # uint_8
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'RobotReachedEnrollmentCount.faceID', value, -2147483648, 2147483647)

  @property
  def count(self):
    "uint_8 count struct property."
    return self._count

  @count.setter
  def count(self, value):
    self._count = msgbuffers.validate_integer(
      'RobotReachedEnrollmentCount.count', value, 0, 255)

  def __init__(self, faceID=0, count=0):
    self.faceID = faceID
    self.count = count

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotReachedEnrollmentCount from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotReachedEnrollmentCount.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotReachedEnrollmentCount from the given BinaryReader."
    _faceID = reader.read('i')
    _count = reader.read('B')
    return cls(_faceID, _count)

  def pack(self):
    "Writes the current RobotReachedEnrollmentCount, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotReachedEnrollmentCount to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write(self._count, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._count == other._count)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size(self._count, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, count={count})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      count=self._count)

  def __repr__(self):
    return '{type}(faceID={faceID}, count={count})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      count=repr(self._count))

Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount = RobotReachedEnrollmentCount
del RobotReachedEnrollmentCount


class RobotErasedEnrolledFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID', # int_32
    '_name',   # string[uint_8]
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'RobotErasedEnrolledFace.faceID', value, -2147483648, 2147483647)

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'RobotErasedEnrolledFace.name', value, 255)

  def __init__(self, faceID=0, name=''):
    self.faceID = faceID
    self.name = name

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotErasedEnrolledFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotErasedEnrolledFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotErasedEnrolledFace from the given BinaryReader."
    _faceID = reader.read('i')
    _name = reader.read_string('B')
    return cls(_faceID, _name)

  def pack(self):
    "Writes the current RobotErasedEnrolledFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotErasedEnrolledFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write_string(self._name, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._name == other._name)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size_string(self._name, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      name=msgbuffers.shorten_string(self._name))

  def __repr__(self):
    return '{type}(faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      name=repr(self._name))

Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace = RobotErasedEnrolledFace
del RobotErasedEnrolledFace


class RobotErasedAllEnrolledFaces(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotErasedAllEnrolledFaces from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotErasedAllEnrolledFaces.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotErasedAllEnrolledFaces from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RobotErasedAllEnrolledFaces, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotErasedAllEnrolledFaces to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces = RobotErasedAllEnrolledFaces
del RobotErasedAllEnrolledFaces


class RobotCompletedFactoryDotTest(object):
  "Generated message-passing message."

  __slots__ = (
    '_camPoseX_mm',      # float_32
    '_camPoseY_mm',      # float_32
    '_camPoseZ_mm',      # float_32
    '_camPoseRoll_rad',  # float_32
    '_camPosePitch_rad', # float_32
    '_camPoseYaw_rad',   # float_32
    '_dotCenX_pix',      # float_32[4]
    '_dotCenY_pix',      # float_32[4]
    '_headAngle',        # float_32
    '_success',          # bool
    '_didComputePose',   # bool
  )

  @property
  def camPoseX_mm(self):
    "float_32 camPoseX_mm struct property."
    return self._camPoseX_mm

  @camPoseX_mm.setter
  def camPoseX_mm(self, value):
    self._camPoseX_mm = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPoseX_mm', value, 'f')

  @property
  def camPoseY_mm(self):
    "float_32 camPoseY_mm struct property."
    return self._camPoseY_mm

  @camPoseY_mm.setter
  def camPoseY_mm(self, value):
    self._camPoseY_mm = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPoseY_mm', value, 'f')

  @property
  def camPoseZ_mm(self):
    "float_32 camPoseZ_mm struct property."
    return self._camPoseZ_mm

  @camPoseZ_mm.setter
  def camPoseZ_mm(self, value):
    self._camPoseZ_mm = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPoseZ_mm', value, 'f')

  @property
  def camPoseRoll_rad(self):
    "float_32 camPoseRoll_rad struct property."
    return self._camPoseRoll_rad

  @camPoseRoll_rad.setter
  def camPoseRoll_rad(self, value):
    self._camPoseRoll_rad = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPoseRoll_rad', value, 'f')

  @property
  def camPosePitch_rad(self):
    "float_32 camPosePitch_rad struct property."
    return self._camPosePitch_rad

  @camPosePitch_rad.setter
  def camPosePitch_rad(self, value):
    self._camPosePitch_rad = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPosePitch_rad', value, 'f')

  @property
  def camPoseYaw_rad(self):
    "float_32 camPoseYaw_rad struct property."
    return self._camPoseYaw_rad

  @camPoseYaw_rad.setter
  def camPoseYaw_rad(self, value):
    self._camPoseYaw_rad = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.camPoseYaw_rad', value, 'f')

  @property
  def dotCenX_pix(self):
    "float_32[4] dotCenX_pix struct property."
    return self._dotCenX_pix

  @dotCenX_pix.setter
  def dotCenX_pix(self, value):
    self._dotCenX_pix = msgbuffers.validate_farray(
      'RobotCompletedFactoryDotTest.dotCenX_pix', value, 4,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def dotCenY_pix(self):
    "float_32[4] dotCenY_pix struct property."
    return self._dotCenY_pix

  @dotCenY_pix.setter
  def dotCenY_pix(self, value):
    self._dotCenY_pix = msgbuffers.validate_farray(
      'RobotCompletedFactoryDotTest.dotCenY_pix', value, 4,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def headAngle(self):
    "float_32 headAngle struct property."
    return self._headAngle

  @headAngle.setter
  def headAngle(self, value):
    self._headAngle = msgbuffers.validate_float(
      'RobotCompletedFactoryDotTest.headAngle', value, 'f')

  @property
  def success(self):
    "bool success struct property."
    return self._success

  @success.setter
  def success(self, value):
    self._success = msgbuffers.validate_bool(
      'RobotCompletedFactoryDotTest.success', value)

  @property
  def didComputePose(self):
    "bool didComputePose struct property."
    return self._didComputePose

  @didComputePose.setter
  def didComputePose(self, value):
    self._didComputePose = msgbuffers.validate_bool(
      'RobotCompletedFactoryDotTest.didComputePose', value)

  def __init__(self, camPoseX_mm=0.0, camPoseY_mm=0.0, camPoseZ_mm=0.0, camPoseRoll_rad=0.0, camPosePitch_rad=0.0, camPoseYaw_rad=0.0, dotCenX_pix=(0.0,) * 4, dotCenY_pix=(0.0,) * 4, headAngle=0.0, success=False, didComputePose=False):
    self.camPoseX_mm = camPoseX_mm
    self.camPoseY_mm = camPoseY_mm
    self.camPoseZ_mm = camPoseZ_mm
    self.camPoseRoll_rad = camPoseRoll_rad
    self.camPosePitch_rad = camPosePitch_rad
    self.camPoseYaw_rad = camPoseYaw_rad
    self.dotCenX_pix = dotCenX_pix
    self.dotCenY_pix = dotCenY_pix
    self.headAngle = headAngle
    self.success = success
    self.didComputePose = didComputePose

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotCompletedFactoryDotTest from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotCompletedFactoryDotTest.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotCompletedFactoryDotTest from the given BinaryReader."
    _camPoseX_mm = reader.read('f')
    _camPoseY_mm = reader.read('f')
    _camPoseZ_mm = reader.read('f')
    _camPoseRoll_rad = reader.read('f')
    _camPosePitch_rad = reader.read('f')
    _camPoseYaw_rad = reader.read('f')
    _dotCenX_pix = reader.read_farray('f', 4)
    _dotCenY_pix = reader.read_farray('f', 4)
    _headAngle = reader.read('f')
    _success = bool(reader.read('b'))
    _didComputePose = bool(reader.read('b'))
    return cls(_camPoseX_mm, _camPoseY_mm, _camPoseZ_mm, _camPoseRoll_rad, _camPosePitch_rad, _camPoseYaw_rad, _dotCenX_pix, _dotCenY_pix, _headAngle, _success, _didComputePose)

  def pack(self):
    "Writes the current RobotCompletedFactoryDotTest, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotCompletedFactoryDotTest to the given BinaryWriter."
    writer.write(self._camPoseX_mm, 'f')
    writer.write(self._camPoseY_mm, 'f')
    writer.write(self._camPoseZ_mm, 'f')
    writer.write(self._camPoseRoll_rad, 'f')
    writer.write(self._camPosePitch_rad, 'f')
    writer.write(self._camPoseYaw_rad, 'f')
    writer.write_farray(self._dotCenX_pix, 'f', 4)
    writer.write_farray(self._dotCenY_pix, 'f', 4)
    writer.write(self._headAngle, 'f')
    writer.write(int(self._success), 'b')
    writer.write(int(self._didComputePose), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._camPoseX_mm == other._camPoseX_mm and
        self._camPoseY_mm == other._camPoseY_mm and
        self._camPoseZ_mm == other._camPoseZ_mm and
        self._camPoseRoll_rad == other._camPoseRoll_rad and
        self._camPosePitch_rad == other._camPosePitch_rad and
        self._camPoseYaw_rad == other._camPoseYaw_rad and
        self._dotCenX_pix == other._dotCenX_pix and
        self._dotCenY_pix == other._dotCenY_pix and
        self._headAngle == other._headAngle and
        self._success == other._success and
        self._didComputePose == other._didComputePose)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._camPoseX_mm, 'f') +
      msgbuffers.size(self._camPoseY_mm, 'f') +
      msgbuffers.size(self._camPoseZ_mm, 'f') +
      msgbuffers.size(self._camPoseRoll_rad, 'f') +
      msgbuffers.size(self._camPosePitch_rad, 'f') +
      msgbuffers.size(self._camPoseYaw_rad, 'f') +
      msgbuffers.size_farray(self._dotCenX_pix, 'f', 4) +
      msgbuffers.size_farray(self._dotCenY_pix, 'f', 4) +
      msgbuffers.size(self._headAngle, 'f') +
      msgbuffers.size(self._success, 'b') +
      msgbuffers.size(self._didComputePose, 'b'))

  def __str__(self):
    return '{type}(camPoseX_mm={camPoseX_mm}, camPoseY_mm={camPoseY_mm}, camPoseZ_mm={camPoseZ_mm}, camPoseRoll_rad={camPoseRoll_rad}, camPosePitch_rad={camPosePitch_rad}, camPoseYaw_rad={camPoseYaw_rad}, dotCenX_pix={dotCenX_pix}, dotCenY_pix={dotCenY_pix}, headAngle={headAngle}, success={success}, didComputePose={didComputePose})'.format(
      type=type(self).__name__,
      camPoseX_mm=self._camPoseX_mm,
      camPoseY_mm=self._camPoseY_mm,
      camPoseZ_mm=self._camPoseZ_mm,
      camPoseRoll_rad=self._camPoseRoll_rad,
      camPosePitch_rad=self._camPosePitch_rad,
      camPoseYaw_rad=self._camPoseYaw_rad,
      dotCenX_pix=msgbuffers.shorten_sequence(self._dotCenX_pix),
      dotCenY_pix=msgbuffers.shorten_sequence(self._dotCenY_pix),
      headAngle=self._headAngle,
      success=self._success,
      didComputePose=self._didComputePose)

  def __repr__(self):
    return '{type}(camPoseX_mm={camPoseX_mm}, camPoseY_mm={camPoseY_mm}, camPoseZ_mm={camPoseZ_mm}, camPoseRoll_rad={camPoseRoll_rad}, camPosePitch_rad={camPosePitch_rad}, camPoseYaw_rad={camPoseYaw_rad}, dotCenX_pix={dotCenX_pix}, dotCenY_pix={dotCenY_pix}, headAngle={headAngle}, success={success}, didComputePose={didComputePose})'.format(
      type=type(self).__name__,
      camPoseX_mm=repr(self._camPoseX_mm),
      camPoseY_mm=repr(self._camPoseY_mm),
      camPoseZ_mm=repr(self._camPoseZ_mm),
      camPoseRoll_rad=repr(self._camPoseRoll_rad),
      camPosePitch_rad=repr(self._camPosePitch_rad),
      camPoseYaw_rad=repr(self._camPoseYaw_rad),
      dotCenX_pix=repr(self._dotCenX_pix),
      dotCenY_pix=repr(self._dotCenY_pix),
      headAngle=repr(self._headAngle),
      success=repr(self._success),
      didComputePose=repr(self._didComputePose))

Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest = RobotCompletedFactoryDotTest
del RobotCompletedFactoryDotTest


class RobotCompletedAction(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',        # uint_32
    '_idTag',          # uint_32
    '_actionType',     # Anki.Cozmo.RobotActionType
    '_result',         # Anki.Cozmo.ActionResult
    '_completionInfo', # Anki.Cozmo.ActionCompletedUnion
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'RobotCompletedAction.robotID', value, 0, 4294967295)

  @property
  def idTag(self):
    "uint_32 idTag struct property."
    return self._idTag

  @idTag.setter
  def idTag(self, value):
    self._idTag = msgbuffers.validate_integer(
      'RobotCompletedAction.idTag', value, 0, 4294967295)

  @property
  def actionType(self):
    "Anki.Cozmo.RobotActionType actionType struct property."
    return self._actionType

  @actionType.setter
  def actionType(self, value):
    self._actionType = msgbuffers.validate_integer(
      'RobotCompletedAction.actionType', value, -2147483648, 2147483647)

  @property
  def result(self):
    "Anki.Cozmo.ActionResult result struct property."
    return self._result

  @result.setter
  def result(self, value):
    self._result = msgbuffers.validate_integer(
      'RobotCompletedAction.result', value, 0, 255)

  @property
  def completionInfo(self):
    "Anki.Cozmo.ActionCompletedUnion completionInfo struct property."
    return self._completionInfo

  @completionInfo.setter
  def completionInfo(self, value):
    self._completionInfo = msgbuffers.validate_object(
      'RobotCompletedAction.completionInfo', value, Anki.Cozmo.ActionCompletedUnion)

  def __init__(self, robotID=0, idTag=0, actionType=Anki.Cozmo.RobotActionType.COMPOUND, result=Anki.Cozmo.ActionResult.SUCCESS, completionInfo=Anki.Cozmo.ActionCompletedUnion()):
    self.robotID = robotID
    self.idTag = idTag
    self.actionType = actionType
    self.result = result
    self.completionInfo = completionInfo

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotCompletedAction from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotCompletedAction.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotCompletedAction from the given BinaryReader."
    _robotID = reader.read('I')
    _idTag = reader.read('I')
    _actionType = reader.read('i')
    _result = reader.read('B')
    _completionInfo = reader.read_object(Anki.Cozmo.ActionCompletedUnion.unpack_from)
    return cls(_robotID, _idTag, _actionType, _result, _completionInfo)

  def pack(self):
    "Writes the current RobotCompletedAction, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotCompletedAction to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._idTag, 'I')
    writer.write(self._actionType, 'i')
    writer.write(self._result, 'B')
    writer.write_object(self._completionInfo)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._idTag == other._idTag and
        self._actionType == other._actionType and
        self._result == other._result and
        self._completionInfo == other._completionInfo)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._idTag, 'I') +
      msgbuffers.size(self._actionType, 'i') +
      msgbuffers.size(self._result, 'B') +
      msgbuffers.size_object(self._completionInfo))

  def __str__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, actionType={actionType}, result={result}, completionInfo={completionInfo})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      idTag=self._idTag,
      actionType=self._actionType,
      result=self._result,
      completionInfo=self._completionInfo)

  def __repr__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, actionType={actionType}, result={result}, completionInfo={completionInfo})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      idTag=repr(self._idTag),
      actionType=repr(self._actionType),
      result=repr(self._result),
      completionInfo=repr(self._completionInfo))

Anki.Cozmo.ExternalInterface.RobotCompletedAction = RobotCompletedAction
del RobotCompletedAction


class BlockPickedUp(object):
  "Generated message-passing message."

  __slots__ = (
    '_didSucceed', # bool
  )

  @property
  def didSucceed(self):
    "bool didSucceed struct property."
    return self._didSucceed

  @didSucceed.setter
  def didSucceed(self, value):
    self._didSucceed = msgbuffers.validate_bool(
      'BlockPickedUp.didSucceed', value)

  def __init__(self, didSucceed=False):
    self.didSucceed = didSucceed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPickedUp from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPickedUp.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPickedUp from the given BinaryReader."
    _didSucceed = bool(reader.read('b'))
    return cls(_didSucceed)

  def pack(self):
    "Writes the current BlockPickedUp, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPickedUp to the given BinaryWriter."
    writer.write(int(self._didSucceed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._didSucceed == other._didSucceed
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._didSucceed, 'b'))

  def __str__(self):
    return '{type}(didSucceed={didSucceed})'.format(
      type=type(self).__name__,
      didSucceed=self._didSucceed)

  def __repr__(self):
    return '{type}(didSucceed={didSucceed})'.format(
      type=type(self).__name__,
      didSucceed=repr(self._didSucceed))

Anki.Cozmo.ExternalInterface.BlockPickedUp = BlockPickedUp
del BlockPickedUp


class BlockPlaced(object):
  "Generated message-passing message."

  __slots__ = (
    '_didSucceed', # bool
  )

  @property
  def didSucceed(self):
    "bool didSucceed struct property."
    return self._didSucceed

  @didSucceed.setter
  def didSucceed(self, value):
    self._didSucceed = msgbuffers.validate_bool(
      'BlockPlaced.didSucceed', value)

  def __init__(self, didSucceed=False):
    self.didSucceed = didSucceed

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPlaced from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPlaced.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPlaced from the given BinaryReader."
    _didSucceed = bool(reader.read('b'))
    return cls(_didSucceed)

  def pack(self):
    "Writes the current BlockPlaced, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPlaced to the given BinaryWriter."
    writer.write(int(self._didSucceed), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._didSucceed == other._didSucceed
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._didSucceed, 'b'))

  def __str__(self):
    return '{type}(didSucceed={didSucceed})'.format(
      type=type(self).__name__,
      didSucceed=self._didSucceed)

  def __repr__(self):
    return '{type}(didSucceed={didSucceed})'.format(
      type=type(self).__name__,
      didSucceed=repr(self._didSucceed))

Anki.Cozmo.ExternalInterface.BlockPlaced = BlockPlaced
del BlockPlaced


class AnimationAvailable(object):
  "Generated message-passing message."

  __slots__ = (
    '_animName', # string[uint_8]
  )

  @property
  def animName(self):
    "string[uint_8] animName struct property."
    return self._animName

  @animName.setter
  def animName(self, value):
    self._animName = msgbuffers.validate_string(
      'AnimationAvailable.animName', value, 255)

  def __init__(self, animName=''):
    self.animName = animName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AnimationAvailable from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AnimationAvailable.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AnimationAvailable from the given BinaryReader."
    _animName = reader.read_string('B')
    return cls(_animName)

  def pack(self):
    "Writes the current AnimationAvailable, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AnimationAvailable to the given BinaryWriter."
    writer.write_string(self._animName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._animName == other._animName
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._animName, 'B'))

  def __str__(self):
    return '{type}(animName={animName})'.format(
      type=type(self).__name__,
      animName=msgbuffers.shorten_string(self._animName))

  def __repr__(self):
    return '{type}(animName={animName})'.format(
      type=type(self).__name__,
      animName=repr(self._animName))

Anki.Cozmo.ExternalInterface.AnimationAvailable = AnimationAvailable
del AnimationAvailable


class AnimationGroupAvailable(object):
  "Generated message-passing message."

  __slots__ = (
    '_animGroupName', # string[uint_8]
  )

  @property
  def animGroupName(self):
    "string[uint_8] animGroupName struct property."
    return self._animGroupName

  @animGroupName.setter
  def animGroupName(self, value):
    self._animGroupName = msgbuffers.validate_string(
      'AnimationGroupAvailable.animGroupName', value, 255)

  def __init__(self, animGroupName=''):
    self.animGroupName = animGroupName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AnimationGroupAvailable from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AnimationGroupAvailable.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AnimationGroupAvailable from the given BinaryReader."
    _animGroupName = reader.read_string('B')
    return cls(_animGroupName)

  def pack(self):
    "Writes the current AnimationGroupAvailable, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AnimationGroupAvailable to the given BinaryWriter."
    writer.write_string(self._animGroupName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._animGroupName == other._animGroupName
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._animGroupName, 'B'))

  def __str__(self):
    return '{type}(animGroupName={animGroupName})'.format(
      type=type(self).__name__,
      animGroupName=msgbuffers.shorten_string(self._animGroupName))

  def __repr__(self):
    return '{type}(animGroupName={animGroupName})'.format(
      type=type(self).__name__,
      animGroupName=repr(self._animGroupName))

Anki.Cozmo.ExternalInterface.AnimationGroupAvailable = AnimationGroupAvailable
del AnimationGroupAvailable


class AnimationAborted(object):
  "Generated message-passing message."

  __slots__ = (
    '_tag', # uint_32
  )

  @property
  def tag(self):
    "uint_32 tag struct property."
    return self._tag

  @tag.setter
  def tag(self, value):
    self._tag = msgbuffers.validate_integer(
      'AnimationAborted.tag', value, 0, 4294967295)

  def __init__(self, tag=0):
    self.tag = tag

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AnimationAborted from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AnimationAborted.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AnimationAborted from the given BinaryReader."
    _tag = reader.read('I')
    return cls(_tag)

  def pack(self):
    "Writes the current AnimationAborted, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AnimationAborted to the given BinaryWriter."
    writer.write(self._tag, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._tag, 'I'))

  def __str__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=self._tag)

  def __repr__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=repr(self._tag))

Anki.Cozmo.ExternalInterface.AnimationAborted = AnimationAborted
del AnimationAborted


class AnimationEvent(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp', # uint_32
    '_event_id',  # Anki.Cozmo.AnimEvent
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'AnimationEvent.timestamp', value, 0, 4294967295)

  @property
  def event_id(self):
    "Anki.Cozmo.AnimEvent event_id struct property."
    return self._event_id

  @event_id.setter
  def event_id(self, value):
    self._event_id = msgbuffers.validate_integer(
      'AnimationEvent.event_id', value, 0, 255)

  def __init__(self, timestamp=0, event_id=Anki.Cozmo.AnimEvent.TAPPED_BLOCK):
    self.timestamp = timestamp
    self.event_id = event_id

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AnimationEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AnimationEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AnimationEvent from the given BinaryReader."
    _timestamp = reader.read('I')
    _event_id = reader.read('B')
    return cls(_timestamp, _event_id)

  def pack(self):
    "Writes the current AnimationEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AnimationEvent to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._event_id, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._event_id == other._event_id)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._event_id, 'B'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, event_id={event_id})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      event_id=self._event_id)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, event_id={event_id})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      event_id=repr(self._event_id))

Anki.Cozmo.ExternalInterface.AnimationEvent = AnimationEvent
del AnimationEvent


class MoodState(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',       # uint_8
    '_emotionValues', # float_32[uint_8]
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'MoodState.robotID', value, 0, 255)

  @property
  def emotionValues(self):
    "float_32[uint_8] emotionValues struct property."
    return self._emotionValues

  @emotionValues.setter
  def emotionValues(self, value):
    self._emotionValues = msgbuffers.validate_varray(
      'MoodState.emotionValues', value, 255,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  def __init__(self, robotID=0, emotionValues=()):
    self.robotID = robotID
    self.emotionValues = emotionValues

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MoodState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MoodState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MoodState from the given BinaryReader."
    _robotID = reader.read('B')
    _emotionValues = reader.read_varray('f', 'B')
    return cls(_robotID, _emotionValues)

  def pack(self):
    "Writes the current MoodState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MoodState to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write_varray(self._emotionValues, 'f', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._emotionValues == other._emotionValues)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size_varray(self._emotionValues, 'f', 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, emotionValues={emotionValues})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      emotionValues=msgbuffers.shorten_sequence(self._emotionValues))

  def __repr__(self):
    return '{type}(robotID={robotID}, emotionValues={emotionValues})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      emotionValues=repr(self._emotionValues))

Anki.Cozmo.ExternalInterface.MoodState = MoodState
del MoodState


class RequestSetUnlockResult(object):
  "Generated message-passing message."

  __slots__ = (
    '_unlockID', # Anki.Cozmo.UnlockId
    '_unlocked', # bool
  )

  @property
  def unlockID(self):
    "Anki.Cozmo.UnlockId unlockID struct property."
    return self._unlockID

  @unlockID.setter
  def unlockID(self, value):
    self._unlockID = msgbuffers.validate_integer(
      'RequestSetUnlockResult.unlockID', value, -2147483648, 2147483647)

  @property
  def unlocked(self):
    "bool unlocked struct property."
    return self._unlocked

  @unlocked.setter
  def unlocked(self, value):
    self._unlocked = msgbuffers.validate_bool(
      'RequestSetUnlockResult.unlocked', value)

  def __init__(self, unlockID=Anki.Cozmo.UnlockId.Invalid, unlocked=False):
    self.unlockID = unlockID
    self.unlocked = unlocked

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestSetUnlockResult from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestSetUnlockResult.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestSetUnlockResult from the given BinaryReader."
    _unlockID = reader.read('i')
    _unlocked = bool(reader.read('b'))
    return cls(_unlockID, _unlocked)

  def pack(self):
    "Writes the current RequestSetUnlockResult, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestSetUnlockResult to the given BinaryWriter."
    writer.write(self._unlockID, 'i')
    writer.write(int(self._unlocked), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._unlockID == other._unlockID and
        self._unlocked == other._unlocked)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._unlockID, 'i') +
      msgbuffers.size(self._unlocked, 'b'))

  def __str__(self):
    return '{type}(unlockID={unlockID}, unlocked={unlocked})'.format(
      type=type(self).__name__,
      unlockID=self._unlockID,
      unlocked=self._unlocked)

  def __repr__(self):
    return '{type}(unlockID={unlockID}, unlocked={unlocked})'.format(
      type=type(self).__name__,
      unlockID=repr(self._unlockID),
      unlocked=repr(self._unlocked))

Anki.Cozmo.ExternalInterface.RequestSetUnlockResult = RequestSetUnlockResult
del RequestSetUnlockResult


class UnlockStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_unlocks',    # UnlockId[uint_8]
    '_fromBackup', # bool
  )

  @property
  def unlocks(self):
    "UnlockId[uint_8] unlocks struct property."
    return self._unlocks

  @unlocks.setter
  def unlocks(self, value):
    self._unlocks = msgbuffers.validate_varray(
      'UnlockStatus.unlocks', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  @property
  def fromBackup(self):
    "bool fromBackup struct property."
    return self._fromBackup

  @fromBackup.setter
  def fromBackup(self, value):
    self._fromBackup = msgbuffers.validate_bool(
      'UnlockStatus.fromBackup', value)

  def __init__(self, unlocks=(), fromBackup=False):
    self.unlocks = unlocks
    self.fromBackup = fromBackup

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UnlockStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UnlockStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UnlockStatus from the given BinaryReader."
    _unlocks = reader.read_varray('i', 'B')
    _fromBackup = bool(reader.read('b'))
    return cls(_unlocks, _fromBackup)

  def pack(self):
    "Writes the current UnlockStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UnlockStatus to the given BinaryWriter."
    writer.write_varray(self._unlocks, 'i', 'B')
    writer.write(int(self._fromBackup), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._unlocks == other._unlocks and
        self._fromBackup == other._fromBackup)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_varray(self._unlocks, 'i', 'B') +
      msgbuffers.size(self._fromBackup, 'b'))

  def __str__(self):
    return '{type}(unlocks={unlocks}, fromBackup={fromBackup})'.format(
      type=type(self).__name__,
      unlocks=msgbuffers.shorten_sequence(self._unlocks),
      fromBackup=self._fromBackup)

  def __repr__(self):
    return '{type}(unlocks={unlocks}, fromBackup={fromBackup})'.format(
      type=type(self).__name__,
      unlocks=repr(self._unlocks),
      fromBackup=repr(self._fromBackup))

Anki.Cozmo.ExternalInterface.UnlockStatus = UnlockStatus
del UnlockStatus


class UnlockedDefaults(object):
  "Generated message-passing message."

  __slots__ = (
    '_defaultUnlocks', # UnlockId[uint_8]
  )

  @property
  def defaultUnlocks(self):
    "UnlockId[uint_8] defaultUnlocks struct property."
    return self._defaultUnlocks

  @defaultUnlocks.setter
  def defaultUnlocks(self, value):
    self._defaultUnlocks = msgbuffers.validate_varray(
      'UnlockedDefaults.defaultUnlocks', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  def __init__(self, defaultUnlocks=()):
    self.defaultUnlocks = defaultUnlocks

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UnlockedDefaults from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UnlockedDefaults.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UnlockedDefaults from the given BinaryReader."
    _defaultUnlocks = reader.read_varray('i', 'B')
    return cls(_defaultUnlocks)

  def pack(self):
    "Writes the current UnlockedDefaults, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UnlockedDefaults to the given BinaryWriter."
    writer.write_varray(self._defaultUnlocks, 'i', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._defaultUnlocks == other._defaultUnlocks
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_varray(self._defaultUnlocks, 'i', 'B'))

  def __str__(self):
    return '{type}(defaultUnlocks={defaultUnlocks})'.format(
      type=type(self).__name__,
      defaultUnlocks=msgbuffers.shorten_sequence(self._defaultUnlocks))

  def __repr__(self):
    return '{type}(defaultUnlocks={defaultUnlocks})'.format(
      type=type(self).__name__,
      defaultUnlocks=repr(self._defaultUnlocks))

Anki.Cozmo.ExternalInterface.UnlockedDefaults = UnlockedDefaults
del UnlockedDefaults


class DebugConsoleVar(object):
  "Generated message-passing structure."

  __slots__ = (
    '_varName',  # string[uint_8]
    '_category', # string[uint_8]
    '_minValue', # float_64
    '_maxValue', # float_64
    '_varValue', # Anki.Cozmo.ConsoleVarUnion
  )

  @property
  def varName(self):
    "string[uint_8] varName struct property."
    return self._varName

  @varName.setter
  def varName(self, value):
    self._varName = msgbuffers.validate_string(
      'DebugConsoleVar.varName', value, 255)

  @property
  def category(self):
    "string[uint_8] category struct property."
    return self._category

  @category.setter
  def category(self, value):
    self._category = msgbuffers.validate_string(
      'DebugConsoleVar.category', value, 255)

  @property
  def minValue(self):
    "float_64 minValue struct property."
    return self._minValue

  @minValue.setter
  def minValue(self, value):
    self._minValue = msgbuffers.validate_float(
      'DebugConsoleVar.minValue', value, 'd')

  @property
  def maxValue(self):
    "float_64 maxValue struct property."
    return self._maxValue

  @maxValue.setter
  def maxValue(self, value):
    self._maxValue = msgbuffers.validate_float(
      'DebugConsoleVar.maxValue', value, 'd')

  @property
  def varValue(self):
    "Anki.Cozmo.ConsoleVarUnion varValue struct property."
    return self._varValue

  @varValue.setter
  def varValue(self, value):
    self._varValue = msgbuffers.validate_object(
      'DebugConsoleVar.varValue', value, Anki.Cozmo.ConsoleVarUnion)

  def __init__(self, varName='', category='', minValue=0.0, maxValue=0.0, varValue=Anki.Cozmo.ConsoleVarUnion()):
    self.varName = varName
    self.category = category
    self.minValue = minValue
    self.maxValue = maxValue
    self.varValue = varValue

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DebugConsoleVar from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DebugConsoleVar.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DebugConsoleVar from the given BinaryReader."
    _varName = reader.read_string('B')
    _category = reader.read_string('B')
    _minValue = reader.read('d')
    _maxValue = reader.read('d')
    _varValue = reader.read_object(Anki.Cozmo.ConsoleVarUnion.unpack_from)
    return cls(_varName, _category, _minValue, _maxValue, _varValue)

  def pack(self):
    "Writes the current DebugConsoleVar, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DebugConsoleVar to the given BinaryWriter."
    writer.write_string(self._varName, 'B')
    writer.write_string(self._category, 'B')
    writer.write(self._minValue, 'd')
    writer.write(self._maxValue, 'd')
    writer.write_object(self._varValue)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._varName == other._varName and
        self._category == other._category and
        self._minValue == other._minValue and
        self._maxValue == other._maxValue and
        self._varValue == other._varValue)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._varName, 'B') +
      msgbuffers.size_string(self._category, 'B') +
      msgbuffers.size(self._minValue, 'd') +
      msgbuffers.size(self._maxValue, 'd') +
      msgbuffers.size_object(self._varValue))

  def __str__(self):
    return '{type}(varName={varName}, category={category}, minValue={minValue}, maxValue={maxValue}, varValue={varValue})'.format(
      type=type(self).__name__,
      varName=msgbuffers.shorten_string(self._varName),
      category=msgbuffers.shorten_string(self._category),
      minValue=self._minValue,
      maxValue=self._maxValue,
      varValue=self._varValue)

  def __repr__(self):
    return '{type}(varName={varName}, category={category}, minValue={minValue}, maxValue={maxValue}, varValue={varValue})'.format(
      type=type(self).__name__,
      varName=repr(self._varName),
      category=repr(self._category),
      minValue=repr(self._minValue),
      maxValue=repr(self._maxValue),
      varValue=repr(self._varValue))

Anki.Cozmo.ExternalInterface.DebugConsoleVar = DebugConsoleVar
del DebugConsoleVar


class InitDebugConsoleVarMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_varData', # DebugConsoleVar[uint_16]
  )

  @property
  def varData(self):
    "DebugConsoleVar[uint_16] varData struct property."
    return self._varData

  @varData.setter
  def varData(self, value):
    self._varData = msgbuffers.validate_varray(
      'InitDebugConsoleVarMessage.varData', value, 65535,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.ExternalInterface.DebugConsoleVar))

  def __init__(self, varData=()):
    self.varData = varData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new InitDebugConsoleVarMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('InitDebugConsoleVarMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new InitDebugConsoleVarMessage from the given BinaryReader."
    _varData = reader.read_object_varray(Anki.Cozmo.ExternalInterface.DebugConsoleVar.unpack_from, 'H')
    return cls(_varData)

  def pack(self):
    "Writes the current InitDebugConsoleVarMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current InitDebugConsoleVarMessage to the given BinaryWriter."
    writer.write_object_varray(self._varData, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._varData == other._varData
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object_varray(self._varData, 'H'))

  def __str__(self):
    return '{type}(varData={varData})'.format(
      type=type(self).__name__,
      varData=msgbuffers.shorten_sequence(self._varData))

  def __repr__(self):
    return '{type}(varData={varData})'.format(
      type=type(self).__name__,
      varData=repr(self._varData))

Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage = InitDebugConsoleVarMessage
del InitDebugConsoleVarMessage


class JsonDasLogMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_fileName', # string[uint_8]
    '_jsonData', # string[uint_16]
  )

  @property
  def fileName(self):
    "string[uint_8] fileName struct property."
    return self._fileName

  @fileName.setter
  def fileName(self, value):
    self._fileName = msgbuffers.validate_string(
      'JsonDasLogMessage.fileName', value, 255)

  @property
  def jsonData(self):
    "string[uint_16] jsonData struct property."
    return self._jsonData

  @jsonData.setter
  def jsonData(self, value):
    self._jsonData = msgbuffers.validate_string(
      'JsonDasLogMessage.jsonData', value, 65535)

  def __init__(self, fileName='', jsonData=''):
    self.fileName = fileName
    self.jsonData = jsonData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new JsonDasLogMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('JsonDasLogMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new JsonDasLogMessage from the given BinaryReader."
    _fileName = reader.read_string('B')
    _jsonData = reader.read_string('H')
    return cls(_fileName, _jsonData)

  def pack(self):
    "Writes the current JsonDasLogMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current JsonDasLogMessage to the given BinaryWriter."
    writer.write_string(self._fileName, 'B')
    writer.write_string(self._jsonData, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._fileName == other._fileName and
        self._jsonData == other._jsonData)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._fileName, 'B') +
      msgbuffers.size_string(self._jsonData, 'H'))

  def __str__(self):
    return '{type}(fileName={fileName}, jsonData={jsonData})'.format(
      type=type(self).__name__,
      fileName=msgbuffers.shorten_string(self._fileName),
      jsonData=msgbuffers.shorten_string(self._jsonData))

  def __repr__(self):
    return '{type}(fileName={fileName}, jsonData={jsonData})'.format(
      type=type(self).__name__,
      fileName=repr(self._fileName),
      jsonData=repr(self._jsonData))

Anki.Cozmo.ExternalInterface.JsonDasLogMessage = JsonDasLogMessage
del JsonDasLogMessage


class JsonDasLogAllSentMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_filesSent', # uint_8
  )

  @property
  def filesSent(self):
    "uint_8 filesSent struct property."
    return self._filesSent

  @filesSent.setter
  def filesSent(self, value):
    self._filesSent = msgbuffers.validate_integer(
      'JsonDasLogAllSentMessage.filesSent', value, 0, 255)

  def __init__(self, filesSent=0):
    self.filesSent = filesSent

  @classmethod
  def unpack(cls, buffer):
    "Reads a new JsonDasLogAllSentMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('JsonDasLogAllSentMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new JsonDasLogAllSentMessage from the given BinaryReader."
    _filesSent = reader.read('B')
    return cls(_filesSent)

  def pack(self):
    "Writes the current JsonDasLogAllSentMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current JsonDasLogAllSentMessage to the given BinaryWriter."
    writer.write(self._filesSent, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._filesSent == other._filesSent
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._filesSent, 'B'))

  def __str__(self):
    return '{type}(filesSent={filesSent})'.format(
      type=type(self).__name__,
      filesSent=self._filesSent)

  def __repr__(self):
    return '{type}(filesSent={filesSent})'.format(
      type=type(self).__name__,
      filesSent=repr(self._filesSent))

Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage = JsonDasLogAllSentMessage
del JsonDasLogAllSentMessage


class VerifyDebugConsoleFuncMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_funcName',      # string[uint_8]
    '_statusMessage', # string[uint_8]
    '_success',       # bool
  )

  @property
  def funcName(self):
    "string[uint_8] funcName struct property."
    return self._funcName

  @funcName.setter
  def funcName(self, value):
    self._funcName = msgbuffers.validate_string(
      'VerifyDebugConsoleFuncMessage.funcName', value, 255)

  @property
  def statusMessage(self):
    "string[uint_8] statusMessage struct property."
    return self._statusMessage

  @statusMessage.setter
  def statusMessage(self, value):
    self._statusMessage = msgbuffers.validate_string(
      'VerifyDebugConsoleFuncMessage.statusMessage', value, 255)

  @property
  def success(self):
    "bool success struct property."
    return self._success

  @success.setter
  def success(self, value):
    self._success = msgbuffers.validate_bool(
      'VerifyDebugConsoleFuncMessage.success', value)

  def __init__(self, funcName='', statusMessage='', success=False):
    self.funcName = funcName
    self.statusMessage = statusMessage
    self.success = success

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VerifyDebugConsoleFuncMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VerifyDebugConsoleFuncMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VerifyDebugConsoleFuncMessage from the given BinaryReader."
    _funcName = reader.read_string('B')
    _statusMessage = reader.read_string('B')
    _success = bool(reader.read('b'))
    return cls(_funcName, _statusMessage, _success)

  def pack(self):
    "Writes the current VerifyDebugConsoleFuncMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VerifyDebugConsoleFuncMessage to the given BinaryWriter."
    writer.write_string(self._funcName, 'B')
    writer.write_string(self._statusMessage, 'B')
    writer.write(int(self._success), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._funcName == other._funcName and
        self._statusMessage == other._statusMessage and
        self._success == other._success)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._funcName, 'B') +
      msgbuffers.size_string(self._statusMessage, 'B') +
      msgbuffers.size(self._success, 'b'))

  def __str__(self):
    return '{type}(funcName={funcName}, statusMessage={statusMessage}, success={success})'.format(
      type=type(self).__name__,
      funcName=msgbuffers.shorten_string(self._funcName),
      statusMessage=msgbuffers.shorten_string(self._statusMessage),
      success=self._success)

  def __repr__(self):
    return '{type}(funcName={funcName}, statusMessage={statusMessage}, success={success})'.format(
      type=type(self).__name__,
      funcName=repr(self._funcName),
      statusMessage=repr(self._statusMessage),
      success=repr(self._success))

Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage = VerifyDebugConsoleFuncMessage
del VerifyDebugConsoleFuncMessage


class VerifyDebugConsoleVarMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_varName',       # string[uint_8]
    '_statusMessage', # string[uint_8]
    '_varValue',      # Anki.Cozmo.ConsoleVarUnion
    '_success',       # bool
  )

  @property
  def varName(self):
    "string[uint_8] varName struct property."
    return self._varName

  @varName.setter
  def varName(self, value):
    self._varName = msgbuffers.validate_string(
      'VerifyDebugConsoleVarMessage.varName', value, 255)

  @property
  def statusMessage(self):
    "string[uint_8] statusMessage struct property."
    return self._statusMessage

  @statusMessage.setter
  def statusMessage(self, value):
    self._statusMessage = msgbuffers.validate_string(
      'VerifyDebugConsoleVarMessage.statusMessage', value, 255)

  @property
  def varValue(self):
    "Anki.Cozmo.ConsoleVarUnion varValue struct property."
    return self._varValue

  @varValue.setter
  def varValue(self, value):
    self._varValue = msgbuffers.validate_object(
      'VerifyDebugConsoleVarMessage.varValue', value, Anki.Cozmo.ConsoleVarUnion)

  @property
  def success(self):
    "bool success struct property."
    return self._success

  @success.setter
  def success(self, value):
    self._success = msgbuffers.validate_bool(
      'VerifyDebugConsoleVarMessage.success', value)

  def __init__(self, varName='', statusMessage='', varValue=Anki.Cozmo.ConsoleVarUnion(), success=False):
    self.varName = varName
    self.statusMessage = statusMessage
    self.varValue = varValue
    self.success = success

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VerifyDebugConsoleVarMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VerifyDebugConsoleVarMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VerifyDebugConsoleVarMessage from the given BinaryReader."
    _varName = reader.read_string('B')
    _statusMessage = reader.read_string('B')
    _varValue = reader.read_object(Anki.Cozmo.ConsoleVarUnion.unpack_from)
    _success = bool(reader.read('b'))
    return cls(_varName, _statusMessage, _varValue, _success)

  def pack(self):
    "Writes the current VerifyDebugConsoleVarMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VerifyDebugConsoleVarMessage to the given BinaryWriter."
    writer.write_string(self._varName, 'B')
    writer.write_string(self._statusMessage, 'B')
    writer.write_object(self._varValue)
    writer.write(int(self._success), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._varName == other._varName and
        self._statusMessage == other._statusMessage and
        self._varValue == other._varValue and
        self._success == other._success)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._varName, 'B') +
      msgbuffers.size_string(self._statusMessage, 'B') +
      msgbuffers.size_object(self._varValue) +
      msgbuffers.size(self._success, 'b'))

  def __str__(self):
    return '{type}(varName={varName}, statusMessage={statusMessage}, varValue={varValue}, success={success})'.format(
      type=type(self).__name__,
      varName=msgbuffers.shorten_string(self._varName),
      statusMessage=msgbuffers.shorten_string(self._statusMessage),
      varValue=self._varValue,
      success=self._success)

  def __repr__(self):
    return '{type}(varName={varName}, statusMessage={statusMessage}, varValue={varValue}, success={success})'.format(
      type=type(self).__name__,
      varName=repr(self._varName),
      statusMessage=repr(self._statusMessage),
      varValue=repr(self._varValue),
      success=repr(self._success))

Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage = VerifyDebugConsoleVarMessage
del VerifyDebugConsoleVarMessage


class TimingInfo(object):
  "Generated message-passing structure."

  __slots__ = (
    '_avgTime_ms', # float_32
    '_minTime_ms', # float_32
    '_maxTime_ms', # float_32
  )

  @property
  def avgTime_ms(self):
    "float_32 avgTime_ms struct property."
    return self._avgTime_ms

  @avgTime_ms.setter
  def avgTime_ms(self, value):
    self._avgTime_ms = msgbuffers.validate_float(
      'TimingInfo.avgTime_ms', value, 'f')

  @property
  def minTime_ms(self):
    "float_32 minTime_ms struct property."
    return self._minTime_ms

  @minTime_ms.setter
  def minTime_ms(self, value):
    self._minTime_ms = msgbuffers.validate_float(
      'TimingInfo.minTime_ms', value, 'f')

  @property
  def maxTime_ms(self):
    "float_32 maxTime_ms struct property."
    return self._maxTime_ms

  @maxTime_ms.setter
  def maxTime_ms(self, value):
    self._maxTime_ms = msgbuffers.validate_float(
      'TimingInfo.maxTime_ms', value, 'f')

  def __init__(self, avgTime_ms=0.0, minTime_ms=0.0, maxTime_ms=0.0):
    self.avgTime_ms = avgTime_ms
    self.minTime_ms = minTime_ms
    self.maxTime_ms = maxTime_ms

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TimingInfo from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TimingInfo.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TimingInfo from the given BinaryReader."
    _avgTime_ms = reader.read('f')
    _minTime_ms = reader.read('f')
    _maxTime_ms = reader.read('f')
    return cls(_avgTime_ms, _minTime_ms, _maxTime_ms)

  def pack(self):
    "Writes the current TimingInfo, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TimingInfo to the given BinaryWriter."
    writer.write(self._avgTime_ms, 'f')
    writer.write(self._minTime_ms, 'f')
    writer.write(self._maxTime_ms, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._avgTime_ms == other._avgTime_ms and
        self._minTime_ms == other._minTime_ms and
        self._maxTime_ms == other._maxTime_ms)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._avgTime_ms, 'f') +
      msgbuffers.size(self._minTime_ms, 'f') +
      msgbuffers.size(self._maxTime_ms, 'f'))

  def __str__(self):
    return '{type}(avgTime_ms={avgTime_ms}, minTime_ms={minTime_ms}, maxTime_ms={maxTime_ms})'.format(
      type=type(self).__name__,
      avgTime_ms=self._avgTime_ms,
      minTime_ms=self._minTime_ms,
      maxTime_ms=self._maxTime_ms)

  def __repr__(self):
    return '{type}(avgTime_ms={avgTime_ms}, minTime_ms={minTime_ms}, maxTime_ms={maxTime_ms})'.format(
      type=type(self).__name__,
      avgTime_ms=repr(self._avgTime_ms),
      minTime_ms=repr(self._minTime_ms),
      maxTime_ms=repr(self._maxTime_ms))

Anki.Cozmo.ExternalInterface.TimingInfo = TimingInfo
del TimingInfo


class CurrentTimingInfo(object):
  "Generated message-passing structure."

  __slots__ = (
    '_avgTime_ms',     # float_32
    '_minTime_ms',     # float_32
    '_maxTime_ms',     # float_32
    '_currentTime_ms', # float_32
  )

  @property
  def avgTime_ms(self):
    "float_32 avgTime_ms struct property."
    return self._avgTime_ms

  @avgTime_ms.setter
  def avgTime_ms(self, value):
    self._avgTime_ms = msgbuffers.validate_float(
      'CurrentTimingInfo.avgTime_ms', value, 'f')

  @property
  def minTime_ms(self):
    "float_32 minTime_ms struct property."
    return self._minTime_ms

  @minTime_ms.setter
  def minTime_ms(self, value):
    self._minTime_ms = msgbuffers.validate_float(
      'CurrentTimingInfo.minTime_ms', value, 'f')

  @property
  def maxTime_ms(self):
    "float_32 maxTime_ms struct property."
    return self._maxTime_ms

  @maxTime_ms.setter
  def maxTime_ms(self, value):
    self._maxTime_ms = msgbuffers.validate_float(
      'CurrentTimingInfo.maxTime_ms', value, 'f')

  @property
  def currentTime_ms(self):
    "float_32 currentTime_ms struct property."
    return self._currentTime_ms

  @currentTime_ms.setter
  def currentTime_ms(self, value):
    self._currentTime_ms = msgbuffers.validate_float(
      'CurrentTimingInfo.currentTime_ms', value, 'f')

  def __init__(self, avgTime_ms=0.0, minTime_ms=0.0, maxTime_ms=0.0, currentTime_ms=0.0):
    self.avgTime_ms = avgTime_ms
    self.minTime_ms = minTime_ms
    self.maxTime_ms = maxTime_ms
    self.currentTime_ms = currentTime_ms

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CurrentTimingInfo from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CurrentTimingInfo.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CurrentTimingInfo from the given BinaryReader."
    _avgTime_ms = reader.read('f')
    _minTime_ms = reader.read('f')
    _maxTime_ms = reader.read('f')
    _currentTime_ms = reader.read('f')
    return cls(_avgTime_ms, _minTime_ms, _maxTime_ms, _currentTime_ms)

  def pack(self):
    "Writes the current CurrentTimingInfo, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CurrentTimingInfo to the given BinaryWriter."
    writer.write(self._avgTime_ms, 'f')
    writer.write(self._minTime_ms, 'f')
    writer.write(self._maxTime_ms, 'f')
    writer.write(self._currentTime_ms, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._avgTime_ms == other._avgTime_ms and
        self._minTime_ms == other._minTime_ms and
        self._maxTime_ms == other._maxTime_ms and
        self._currentTime_ms == other._currentTime_ms)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._avgTime_ms, 'f') +
      msgbuffers.size(self._minTime_ms, 'f') +
      msgbuffers.size(self._maxTime_ms, 'f') +
      msgbuffers.size(self._currentTime_ms, 'f'))

  def __str__(self):
    return '{type}(avgTime_ms={avgTime_ms}, minTime_ms={minTime_ms}, maxTime_ms={maxTime_ms}, currentTime_ms={currentTime_ms})'.format(
      type=type(self).__name__,
      avgTime_ms=self._avgTime_ms,
      minTime_ms=self._minTime_ms,
      maxTime_ms=self._maxTime_ms,
      currentTime_ms=self._currentTime_ms)

  def __repr__(self):
    return '{type}(avgTime_ms={avgTime_ms}, minTime_ms={minTime_ms}, maxTime_ms={maxTime_ms}, currentTime_ms={currentTime_ms})'.format(
      type=type(self).__name__,
      avgTime_ms=repr(self._avgTime_ms),
      minTime_ms=repr(self._minTime_ms),
      maxTime_ms=repr(self._maxTime_ms),
      currentTime_ms=repr(self._currentTime_ms))

Anki.Cozmo.ExternalInterface.CurrentTimingInfo = CurrentTimingInfo
del CurrentTimingInfo


class LatencyMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_wifiLatency',        # Anki.Cozmo.ExternalInterface.TimingInfo
    '_extSendQueueTime',   # Anki.Cozmo.ExternalInterface.TimingInfo
    '_sendQueueTime',      # Anki.Cozmo.ExternalInterface.TimingInfo
    '_recvQueueTime',      # Anki.Cozmo.ExternalInterface.TimingInfo
    '_unityEngineLatency', # Anki.Cozmo.ExternalInterface.TimingInfo
    '_sdkEngineLatency',   # Anki.Cozmo.ExternalInterface.TimingInfo
    '_imageLatency',       # Anki.Cozmo.ExternalInterface.CurrentTimingInfo
  )

  @property
  def wifiLatency(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo wifiLatency struct property."
    return self._wifiLatency

  @wifiLatency.setter
  def wifiLatency(self, value):
    self._wifiLatency = msgbuffers.validate_object(
      'LatencyMessage.wifiLatency', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def extSendQueueTime(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo extSendQueueTime struct property."
    return self._extSendQueueTime

  @extSendQueueTime.setter
  def extSendQueueTime(self, value):
    self._extSendQueueTime = msgbuffers.validate_object(
      'LatencyMessage.extSendQueueTime', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def sendQueueTime(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo sendQueueTime struct property."
    return self._sendQueueTime

  @sendQueueTime.setter
  def sendQueueTime(self, value):
    self._sendQueueTime = msgbuffers.validate_object(
      'LatencyMessage.sendQueueTime', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def recvQueueTime(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo recvQueueTime struct property."
    return self._recvQueueTime

  @recvQueueTime.setter
  def recvQueueTime(self, value):
    self._recvQueueTime = msgbuffers.validate_object(
      'LatencyMessage.recvQueueTime', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def unityEngineLatency(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo unityEngineLatency struct property."
    return self._unityEngineLatency

  @unityEngineLatency.setter
  def unityEngineLatency(self, value):
    self._unityEngineLatency = msgbuffers.validate_object(
      'LatencyMessage.unityEngineLatency', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def sdkEngineLatency(self):
    "Anki.Cozmo.ExternalInterface.TimingInfo sdkEngineLatency struct property."
    return self._sdkEngineLatency

  @sdkEngineLatency.setter
  def sdkEngineLatency(self, value):
    self._sdkEngineLatency = msgbuffers.validate_object(
      'LatencyMessage.sdkEngineLatency', value, Anki.Cozmo.ExternalInterface.TimingInfo)

  @property
  def imageLatency(self):
    "Anki.Cozmo.ExternalInterface.CurrentTimingInfo imageLatency struct property."
    return self._imageLatency

  @imageLatency.setter
  def imageLatency(self, value):
    self._imageLatency = msgbuffers.validate_object(
      'LatencyMessage.imageLatency', value, Anki.Cozmo.ExternalInterface.CurrentTimingInfo)

  def __init__(self, wifiLatency=Anki.Cozmo.ExternalInterface.TimingInfo(), extSendQueueTime=Anki.Cozmo.ExternalInterface.TimingInfo(), sendQueueTime=Anki.Cozmo.ExternalInterface.TimingInfo(), recvQueueTime=Anki.Cozmo.ExternalInterface.TimingInfo(), unityEngineLatency=Anki.Cozmo.ExternalInterface.TimingInfo(), sdkEngineLatency=Anki.Cozmo.ExternalInterface.TimingInfo(), imageLatency=Anki.Cozmo.ExternalInterface.CurrentTimingInfo()):
    self.wifiLatency = wifiLatency
    self.extSendQueueTime = extSendQueueTime
    self.sendQueueTime = sendQueueTime
    self.recvQueueTime = recvQueueTime
    self.unityEngineLatency = unityEngineLatency
    self.sdkEngineLatency = sdkEngineLatency
    self.imageLatency = imageLatency

  @classmethod
  def unpack(cls, buffer):
    "Reads a new LatencyMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('LatencyMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new LatencyMessage from the given BinaryReader."
    _wifiLatency = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _extSendQueueTime = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _sendQueueTime = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _recvQueueTime = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _unityEngineLatency = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _sdkEngineLatency = reader.read_object(Anki.Cozmo.ExternalInterface.TimingInfo.unpack_from)
    _imageLatency = reader.read_object(Anki.Cozmo.ExternalInterface.CurrentTimingInfo.unpack_from)
    return cls(_wifiLatency, _extSendQueueTime, _sendQueueTime, _recvQueueTime, _unityEngineLatency, _sdkEngineLatency, _imageLatency)

  def pack(self):
    "Writes the current LatencyMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current LatencyMessage to the given BinaryWriter."
    writer.write_object(self._wifiLatency)
    writer.write_object(self._extSendQueueTime)
    writer.write_object(self._sendQueueTime)
    writer.write_object(self._recvQueueTime)
    writer.write_object(self._unityEngineLatency)
    writer.write_object(self._sdkEngineLatency)
    writer.write_object(self._imageLatency)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._wifiLatency == other._wifiLatency and
        self._extSendQueueTime == other._extSendQueueTime and
        self._sendQueueTime == other._sendQueueTime and
        self._recvQueueTime == other._recvQueueTime and
        self._unityEngineLatency == other._unityEngineLatency and
        self._sdkEngineLatency == other._sdkEngineLatency and
        self._imageLatency == other._imageLatency)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._wifiLatency) +
      msgbuffers.size_object(self._extSendQueueTime) +
      msgbuffers.size_object(self._sendQueueTime) +
      msgbuffers.size_object(self._recvQueueTime) +
      msgbuffers.size_object(self._unityEngineLatency) +
      msgbuffers.size_object(self._sdkEngineLatency) +
      msgbuffers.size_object(self._imageLatency))

  def __str__(self):
    return '{type}(wifiLatency={wifiLatency}, extSendQueueTime={extSendQueueTime}, sendQueueTime={sendQueueTime}, recvQueueTime={recvQueueTime}, unityEngineLatency={unityEngineLatency}, sdkEngineLatency={sdkEngineLatency}, imageLatency={imageLatency})'.format(
      type=type(self).__name__,
      wifiLatency=self._wifiLatency,
      extSendQueueTime=self._extSendQueueTime,
      sendQueueTime=self._sendQueueTime,
      recvQueueTime=self._recvQueueTime,
      unityEngineLatency=self._unityEngineLatency,
      sdkEngineLatency=self._sdkEngineLatency,
      imageLatency=self._imageLatency)

  def __repr__(self):
    return '{type}(wifiLatency={wifiLatency}, extSendQueueTime={extSendQueueTime}, sendQueueTime={sendQueueTime}, recvQueueTime={recvQueueTime}, unityEngineLatency={unityEngineLatency}, sdkEngineLatency={sdkEngineLatency}, imageLatency={imageLatency})'.format(
      type=type(self).__name__,
      wifiLatency=repr(self._wifiLatency),
      extSendQueueTime=repr(self._extSendQueueTime),
      sendQueueTime=repr(self._sendQueueTime),
      recvQueueTime=repr(self._recvQueueTime),
      unityEngineLatency=repr(self._unityEngineLatency),
      sdkEngineLatency=repr(self._sdkEngineLatency),
      imageLatency=repr(self._imageLatency))

Anki.Cozmo.ExternalInterface.LatencyMessage = LatencyMessage
del LatencyMessage


class DeviceDataMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_dataList', # DeviceDataPair[uint_8]
  )

  @property
  def dataList(self):
    "DeviceDataPair[uint_8] dataList struct property."
    return self._dataList

  @dataList.setter
  def dataList(self, value):
    self._dataList = msgbuffers.validate_varray(
      'DeviceDataMessage.dataList', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.DeviceDataPair))

  def __init__(self, dataList=()):
    self.dataList = dataList

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DeviceDataMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DeviceDataMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DeviceDataMessage from the given BinaryReader."
    _dataList = reader.read_object_varray(Anki.Cozmo.DeviceDataPair.unpack_from, 'B')
    return cls(_dataList)

  def pack(self):
    "Writes the current DeviceDataMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DeviceDataMessage to the given BinaryWriter."
    writer.write_object_varray(self._dataList, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._dataList == other._dataList
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object_varray(self._dataList, 'B'))

  def __str__(self):
    return '{type}(dataList={dataList})'.format(
      type=type(self).__name__,
      dataList=msgbuffers.shorten_sequence(self._dataList))

  def __repr__(self):
    return '{type}(dataList={dataList})'.format(
      type=type(self).__name__,
      dataList=repr(self._dataList))

Anki.Cozmo.ExternalInterface.DeviceDataMessage = DeviceDataMessage
del DeviceDataMessage


class BlockTapFilterStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled',         # bool
    '_tapIntensityMin', # int_16
    '_tapWaitOffset',   # uint_32
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'BlockTapFilterStatus.enabled', value)

  @property
  def tapIntensityMin(self):
    "int_16 tapIntensityMin struct property."
    return self._tapIntensityMin

  @tapIntensityMin.setter
  def tapIntensityMin(self, value):
    self._tapIntensityMin = msgbuffers.validate_integer(
      'BlockTapFilterStatus.tapIntensityMin', value, -32768, 32767)

  @property
  def tapWaitOffset(self):
    "uint_32 tapWaitOffset struct property."
    return self._tapWaitOffset

  @tapWaitOffset.setter
  def tapWaitOffset(self, value):
    self._tapWaitOffset = msgbuffers.validate_integer(
      'BlockTapFilterStatus.tapWaitOffset', value, 0, 4294967295)

  def __init__(self, enabled=False, tapIntensityMin=0, tapWaitOffset=0):
    self.enabled = enabled
    self.tapIntensityMin = tapIntensityMin
    self.tapWaitOffset = tapWaitOffset

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockTapFilterStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockTapFilterStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockTapFilterStatus from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    _tapIntensityMin = reader.read('h')
    _tapWaitOffset = reader.read('I')
    return cls(_enabled, _tapIntensityMin, _tapWaitOffset)

  def pack(self):
    "Writes the current BlockTapFilterStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockTapFilterStatus to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')
    writer.write(self._tapIntensityMin, 'h')
    writer.write(self._tapWaitOffset, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enabled == other._enabled and
        self._tapIntensityMin == other._tapIntensityMin and
        self._tapWaitOffset == other._tapWaitOffset)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b') +
      msgbuffers.size(self._tapIntensityMin, 'h') +
      msgbuffers.size(self._tapWaitOffset, 'I'))

  def __str__(self):
    return '{type}(enabled={enabled}, tapIntensityMin={tapIntensityMin}, tapWaitOffset={tapWaitOffset})'.format(
      type=type(self).__name__,
      enabled=self._enabled,
      tapIntensityMin=self._tapIntensityMin,
      tapWaitOffset=self._tapWaitOffset)

  def __repr__(self):
    return '{type}(enabled={enabled}, tapIntensityMin={tapIntensityMin}, tapWaitOffset={tapWaitOffset})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled),
      tapIntensityMin=repr(self._tapIntensityMin),
      tapWaitOffset=repr(self._tapWaitOffset))

Anki.Cozmo.ExternalInterface.BlockTapFilterStatus = BlockTapFilterStatus
del BlockTapFilterStatus


class UpdateEngineState(object):
  "Generated message-passing message."

  __slots__ = (
    '_oldState', # Anki.Cozmo.EngineState
    '_newState', # Anki.Cozmo.EngineState
  )

  @property
  def oldState(self):
    "Anki.Cozmo.EngineState oldState struct property."
    return self._oldState

  @oldState.setter
  def oldState(self, value):
    self._oldState = msgbuffers.validate_integer(
      'UpdateEngineState.oldState', value, 0, 255)

  @property
  def newState(self):
    "Anki.Cozmo.EngineState newState struct property."
    return self._newState

  @newState.setter
  def newState(self, value):
    self._newState = msgbuffers.validate_integer(
      'UpdateEngineState.newState', value, 0, 255)

  def __init__(self, oldState=Anki.Cozmo.EngineState.Stopped, newState=Anki.Cozmo.EngineState.Stopped):
    self.oldState = oldState
    self.newState = newState

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UpdateEngineState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UpdateEngineState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UpdateEngineState from the given BinaryReader."
    _oldState = reader.read('B')
    _newState = reader.read('B')
    return cls(_oldState, _newState)

  def pack(self):
    "Writes the current UpdateEngineState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UpdateEngineState to the given BinaryWriter."
    writer.write(self._oldState, 'B')
    writer.write(self._newState, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._oldState == other._oldState and
        self._newState == other._newState)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._oldState, 'B') +
      msgbuffers.size(self._newState, 'B'))

  def __str__(self):
    return '{type}(oldState={oldState}, newState={newState})'.format(
      type=type(self).__name__,
      oldState=self._oldState,
      newState=self._newState)

  def __repr__(self):
    return '{type}(oldState={oldState}, newState={newState})'.format(
      type=type(self).__name__,
      oldState=repr(self._oldState),
      newState=repr(self._newState))

Anki.Cozmo.ExternalInterface.UpdateEngineState = UpdateEngineState
del UpdateEngineState


class EngineErrorCodeMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_errorCode', # Anki.Cozmo.EngineErrorCode
  )

  @property
  def errorCode(self):
    "Anki.Cozmo.EngineErrorCode errorCode struct property."
    return self._errorCode

  @errorCode.setter
  def errorCode(self, value):
    self._errorCode = msgbuffers.validate_integer(
      'EngineErrorCodeMessage.errorCode', value, 0, 255)

  def __init__(self, errorCode=Anki.Cozmo.EngineErrorCode.RobotNVStorageFull):
    self.errorCode = errorCode

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EngineErrorCodeMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EngineErrorCodeMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EngineErrorCodeMessage from the given BinaryReader."
    _errorCode = reader.read('B')
    return cls(_errorCode)

  def pack(self):
    "Writes the current EngineErrorCodeMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EngineErrorCodeMessage to the given BinaryWriter."
    writer.write(self._errorCode, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._errorCode == other._errorCode
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._errorCode, 'B'))

  def __str__(self):
    return '{type}(errorCode={errorCode})'.format(
      type=type(self).__name__,
      errorCode=self._errorCode)

  def __repr__(self):
    return '{type}(errorCode={errorCode})'.format(
      type=type(self).__name__,
      errorCode=repr(self._errorCode))

Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage = EngineErrorCodeMessage
del EngineErrorCodeMessage


class CubeLightsStateTransition(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',         # uint_32
    '_factoryID',        # uint_32
    '_objectType',       # Anki.Cozmo.ObjectType
    '_lights',           # LightState[4]
    '_lightRotation_ms', # uint_32
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'CubeLightsStateTransition.objectID', value, 0, 4294967295)

  @property
  def factoryID(self):
    "uint_32 factoryID struct property."
    return self._factoryID

  @factoryID.setter
  def factoryID(self, value):
    self._factoryID = msgbuffers.validate_integer(
      'CubeLightsStateTransition.factoryID', value, 0, 4294967295)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'CubeLightsStateTransition.objectType', value, -2147483648, 2147483647)

  @property
  def lights(self):
    "LightState[4] lights struct property."
    return self._lights

  @lights.setter
  def lights(self, value):
    self._lights = msgbuffers.validate_farray(
      'CubeLightsStateTransition.lights', value, 4,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.LightState))

  @property
  def lightRotation_ms(self):
    "uint_32 lightRotation_ms struct property."
    return self._lightRotation_ms

  @lightRotation_ms.setter
  def lightRotation_ms(self, value):
    self._lightRotation_ms = msgbuffers.validate_integer(
      'CubeLightsStateTransition.lightRotation_ms', value, 0, 4294967295)

  def __init__(self, objectID=0, factoryID=0, objectType=Anki.Cozmo.ObjectType.Invalid, lights=(Anki.Cozmo.LightState(),) * 4, lightRotation_ms=0):
    self.objectID = objectID
    self.factoryID = factoryID
    self.objectType = objectType
    self.lights = lights
    self.lightRotation_ms = lightRotation_ms

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CubeLightsStateTransition from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CubeLightsStateTransition.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CubeLightsStateTransition from the given BinaryReader."
    _objectID = reader.read('I')
    _factoryID = reader.read('I')
    _objectType = reader.read('i')
    _lights = reader.read_object_farray(Anki.Cozmo.LightState.unpack_from, 4)
    _lightRotation_ms = reader.read('I')
    return cls(_objectID, _factoryID, _objectType, _lights, _lightRotation_ms)

  def pack(self):
    "Writes the current CubeLightsStateTransition, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CubeLightsStateTransition to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._factoryID, 'I')
    writer.write(self._objectType, 'i')
    writer.write_object_farray(self._lights, 4)
    writer.write(self._lightRotation_ms, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._factoryID == other._factoryID and
        self._objectType == other._objectType and
        self._lights == other._lights and
        self._lightRotation_ms == other._lightRotation_ms)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._factoryID, 'I') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size_object_farray(self._lights, 4) +
      msgbuffers.size(self._lightRotation_ms, 'I'))

  def __str__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, objectType={objectType}, lights={lights}, lightRotation_ms={lightRotation_ms})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      factoryID=self._factoryID,
      objectType=self._objectType,
      lights=msgbuffers.shorten_sequence(self._lights),
      lightRotation_ms=self._lightRotation_ms)

  def __repr__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, objectType={objectType}, lights={lights}, lightRotation_ms={lightRotation_ms})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      factoryID=repr(self._factoryID),
      objectType=repr(self._objectType),
      lights=repr(self._lights),
      lightRotation_ms=repr(self._lightRotation_ms))

Anki.Cozmo.ExternalInterface.CubeLightsStateTransition = CubeLightsStateTransition
del CubeLightsStateTransition


class BlockPoolBlockData(object):
  "Generated message-passing structure."

  __slots__ = (
    '_factoryID',  # uint_32
    '_objectType', # Anki.Cozmo.ObjectType
  )

  @property
  def factoryID(self):
    "uint_32 factoryID struct property."
    return self._factoryID

  @factoryID.setter
  def factoryID(self, value):
    self._factoryID = msgbuffers.validate_integer(
      'BlockPoolBlockData.factoryID', value, 0, 4294967295)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'BlockPoolBlockData.objectType', value, -2147483648, 2147483647)

  def __init__(self, factoryID=0, objectType=Anki.Cozmo.ObjectType.Invalid):
    self.factoryID = factoryID
    self.objectType = objectType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPoolBlockData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPoolBlockData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPoolBlockData from the given BinaryReader."
    _factoryID = reader.read('I')
    _objectType = reader.read('i')
    return cls(_factoryID, _objectType)

  def pack(self):
    "Writes the current BlockPoolBlockData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPoolBlockData to the given BinaryWriter."
    writer.write(self._factoryID, 'I')
    writer.write(self._objectType, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._factoryID == other._factoryID and
        self._objectType == other._objectType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._factoryID, 'I') +
      msgbuffers.size(self._objectType, 'i'))

  def __str__(self):
    return '{type}(factoryID={factoryID}, objectType={objectType})'.format(
      type=type(self).__name__,
      factoryID=self._factoryID,
      objectType=self._objectType)

  def __repr__(self):
    return '{type}(factoryID={factoryID}, objectType={objectType})'.format(
      type=type(self).__name__,
      factoryID=repr(self._factoryID),
      objectType=repr(self._objectType))

Anki.Cozmo.ExternalInterface.BlockPoolBlockData = BlockPoolBlockData
del BlockPoolBlockData


class BlockPoolDataMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_blockPoolEnabled', # uint_8
    '_blockData',        # BlockPoolBlockData[uint_8]
  )

  @property
  def blockPoolEnabled(self):
    "uint_8 blockPoolEnabled struct property."
    return self._blockPoolEnabled

  @blockPoolEnabled.setter
  def blockPoolEnabled(self, value):
    self._blockPoolEnabled = msgbuffers.validate_integer(
      'BlockPoolDataMessage.blockPoolEnabled', value, 0, 255)

  @property
  def blockData(self):
    "BlockPoolBlockData[uint_8] blockData struct property."
    return self._blockData

  @blockData.setter
  def blockData(self, value):
    self._blockData = msgbuffers.validate_varray(
      'BlockPoolDataMessage.blockData', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.ExternalInterface.BlockPoolBlockData))

  def __init__(self, blockPoolEnabled=0, blockData=()):
    self.blockPoolEnabled = blockPoolEnabled
    self.blockData = blockData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPoolDataMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPoolDataMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPoolDataMessage from the given BinaryReader."
    _blockPoolEnabled = reader.read('B')
    _blockData = reader.read_object_varray(Anki.Cozmo.ExternalInterface.BlockPoolBlockData.unpack_from, 'B')
    return cls(_blockPoolEnabled, _blockData)

  def pack(self):
    "Writes the current BlockPoolDataMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPoolDataMessage to the given BinaryWriter."
    writer.write(self._blockPoolEnabled, 'B')
    writer.write_object_varray(self._blockData, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._blockPoolEnabled == other._blockPoolEnabled and
        self._blockData == other._blockData)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._blockPoolEnabled, 'B') +
      msgbuffers.size_object_varray(self._blockData, 'B'))

  def __str__(self):
    return '{type}(blockPoolEnabled={blockPoolEnabled}, blockData={blockData})'.format(
      type=type(self).__name__,
      blockPoolEnabled=self._blockPoolEnabled,
      blockData=msgbuffers.shorten_sequence(self._blockData))

  def __repr__(self):
    return '{type}(blockPoolEnabled={blockPoolEnabled}, blockData={blockData})'.format(
      type=type(self).__name__,
      blockPoolEnabled=repr(self._blockPoolEnabled),
      blockData=repr(self._blockData))

Anki.Cozmo.ExternalInterface.BlockPoolDataMessage = BlockPoolDataMessage
del BlockPoolDataMessage


class NVStorageOpResult(object):
  "Generated message-passing message."

  __slots__ = (
    '_tag',    # Anki.Cozmo.NVStorage.NVEntryTag
    '_result', # Anki.Cozmo.NVStorage.NVResult
    '_op',     # Anki.Cozmo.NVStorage.NVOperation
    '_index',  # uint_8
    '_data',   # uint_8[uint_16]
  )

  @property
  def tag(self):
    "Anki.Cozmo.NVStorage.NVEntryTag tag struct property."
    return self._tag

  @tag.setter
  def tag(self, value):
    self._tag = msgbuffers.validate_integer(
      'NVStorageOpResult.tag', value, 0, 4294967295)

  @property
  def result(self):
    "Anki.Cozmo.NVStorage.NVResult result struct property."
    return self._result

  @result.setter
  def result(self, value):
    self._result = msgbuffers.validate_integer(
      'NVStorageOpResult.result', value, -128, 127)

  @property
  def op(self):
    "Anki.Cozmo.NVStorage.NVOperation op struct property."
    return self._op

  @op.setter
  def op(self, value):
    self._op = msgbuffers.validate_integer(
      'NVStorageOpResult.op', value, 0, 255)

  @property
  def index(self):
    "uint_8 index struct property."
    return self._index

  @index.setter
  def index(self, value):
    self._index = msgbuffers.validate_integer(
      'NVStorageOpResult.index', value, 0, 255)

  @property
  def data(self):
    "uint_8[uint_16] data struct property."
    return self._data

  @data.setter
  def data(self, value):
    self._data = msgbuffers.validate_varray(
      'NVStorageOpResult.data', value, 65535,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, tag=Anki.Cozmo.NVStorage.NVEntryTag.NVEntry_Invalid, result=Anki.Cozmo.NVStorage.NVResult.NV_OKAY, op=Anki.Cozmo.NVStorage.NVOperation.NVOP_READ, index=0, data=()):
    self.tag = tag
    self.result = result
    self.op = op
    self.index = index
    self.data = data

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageOpResult from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageOpResult.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageOpResult from the given BinaryReader."
    _tag = reader.read('I')
    _result = reader.read('b')
    _op = reader.read('B')
    _index = reader.read('B')
    _data = reader.read_varray('B', 'H')
    return cls(_tag, _result, _op, _index, _data)

  def pack(self):
    "Writes the current NVStorageOpResult, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageOpResult to the given BinaryWriter."
    writer.write(self._tag, 'I')
    writer.write(self._result, 'b')
    writer.write(self._op, 'B')
    writer.write(self._index, 'B')
    writer.write_varray(self._data, 'B', 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._tag == other._tag and
        self._result == other._result and
        self._op == other._op and
        self._index == other._index and
        self._data == other._data)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._tag, 'I') +
      msgbuffers.size(self._result, 'b') +
      msgbuffers.size(self._op, 'B') +
      msgbuffers.size(self._index, 'B') +
      msgbuffers.size_varray(self._data, 'B', 'H'))

  def __str__(self):
    return '{type}(tag={tag}, result={result}, op={op}, index={index}, data={data})'.format(
      type=type(self).__name__,
      tag=self._tag,
      result=self._result,
      op=self._op,
      index=self._index,
      data=msgbuffers.shorten_sequence(self._data))

  def __repr__(self):
    return '{type}(tag={tag}, result={result}, op={op}, index={index}, data={data})'.format(
      type=type(self).__name__,
      tag=repr(self._tag),
      result=repr(self._result),
      op=repr(self._op),
      index=repr(self._index),
      data=repr(self._data))

Anki.Cozmo.ExternalInterface.NVStorageOpResult = NVStorageOpResult
del NVStorageOpResult


class FirmwareUpdateProgress(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',         # uint_32
    '_stage',           # Anki.Cozmo.FirmwareUpdateStage
    '_subStage',        # Anki.Cozmo.FirmwareUpdateSubStage
    '_fwSig',           # string[uint_8]
    '_percentComplete', # uint_8
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'FirmwareUpdateProgress.robotID', value, 0, 4294967295)

  @property
  def stage(self):
    "Anki.Cozmo.FirmwareUpdateStage stage struct property."
    return self._stage

  @stage.setter
  def stage(self, value):
    self._stage = msgbuffers.validate_integer(
      'FirmwareUpdateProgress.stage', value, 0, 255)

  @property
  def subStage(self):
    "Anki.Cozmo.FirmwareUpdateSubStage subStage struct property."
    return self._subStage

  @subStage.setter
  def subStage(self, value):
    self._subStage = msgbuffers.validate_integer(
      'FirmwareUpdateProgress.subStage', value, 0, 255)

  @property
  def fwSig(self):
    "string[uint_8] fwSig struct property."
    return self._fwSig

  @fwSig.setter
  def fwSig(self, value):
    self._fwSig = msgbuffers.validate_string(
      'FirmwareUpdateProgress.fwSig', value, 255)

  @property
  def percentComplete(self):
    "uint_8 percentComplete struct property."
    return self._percentComplete

  @percentComplete.setter
  def percentComplete(self, value):
    self._percentComplete = msgbuffers.validate_integer(
      'FirmwareUpdateProgress.percentComplete', value, 0, 255)

  def __init__(self, robotID=0, stage=Anki.Cozmo.FirmwareUpdateStage.Flashing, subStage=Anki.Cozmo.FirmwareUpdateSubStage.Init, fwSig='', percentComplete=0):
    self.robotID = robotID
    self.stage = stage
    self.subStage = subStage
    self.fwSig = fwSig
    self.percentComplete = percentComplete

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FirmwareUpdateProgress from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FirmwareUpdateProgress.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FirmwareUpdateProgress from the given BinaryReader."
    _robotID = reader.read('I')
    _stage = reader.read('B')
    _subStage = reader.read('B')
    _fwSig = reader.read_string('B')
    _percentComplete = reader.read('B')
    return cls(_robotID, _stage, _subStage, _fwSig, _percentComplete)

  def pack(self):
    "Writes the current FirmwareUpdateProgress, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FirmwareUpdateProgress to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._stage, 'B')
    writer.write(self._subStage, 'B')
    writer.write_string(self._fwSig, 'B')
    writer.write(self._percentComplete, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._stage == other._stage and
        self._subStage == other._subStage and
        self._fwSig == other._fwSig and
        self._percentComplete == other._percentComplete)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._stage, 'B') +
      msgbuffers.size(self._subStage, 'B') +
      msgbuffers.size_string(self._fwSig, 'B') +
      msgbuffers.size(self._percentComplete, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, stage={stage}, subStage={subStage}, fwSig={fwSig}, percentComplete={percentComplete})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      stage=self._stage,
      subStage=self._subStage,
      fwSig=msgbuffers.shorten_string(self._fwSig),
      percentComplete=self._percentComplete)

  def __repr__(self):
    return '{type}(robotID={robotID}, stage={stage}, subStage={subStage}, fwSig={fwSig}, percentComplete={percentComplete})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      stage=repr(self._stage),
      subStage=repr(self._subStage),
      fwSig=repr(self._fwSig),
      percentComplete=repr(self._percentComplete))

Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress = FirmwareUpdateProgress
del FirmwareUpdateProgress


class FirmwareUpdateComplete(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_32
    '_result',  # Anki.Cozmo.FirmwareUpdateResult
    '_fwSig',   # string[uint_8]
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'FirmwareUpdateComplete.robotID', value, 0, 4294967295)

  @property
  def result(self):
    "Anki.Cozmo.FirmwareUpdateResult result struct property."
    return self._result

  @result.setter
  def result(self, value):
    self._result = msgbuffers.validate_integer(
      'FirmwareUpdateComplete.result', value, 0, 255)

  @property
  def fwSig(self):
    "string[uint_8] fwSig struct property."
    return self._fwSig

  @fwSig.setter
  def fwSig(self, value):
    self._fwSig = msgbuffers.validate_string(
      'FirmwareUpdateComplete.fwSig', value, 255)

  def __init__(self, robotID=0, result=Anki.Cozmo.FirmwareUpdateResult.Success, fwSig=''):
    self.robotID = robotID
    self.result = result
    self.fwSig = fwSig

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FirmwareUpdateComplete from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FirmwareUpdateComplete.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FirmwareUpdateComplete from the given BinaryReader."
    _robotID = reader.read('I')
    _result = reader.read('B')
    _fwSig = reader.read_string('B')
    return cls(_robotID, _result, _fwSig)

  def pack(self):
    "Writes the current FirmwareUpdateComplete, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FirmwareUpdateComplete to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._result, 'B')
    writer.write_string(self._fwSig, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._result == other._result and
        self._fwSig == other._fwSig)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._result, 'B') +
      msgbuffers.size_string(self._fwSig, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, result={result}, fwSig={fwSig})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      result=self._result,
      fwSig=msgbuffers.shorten_string(self._fwSig))

  def __repr__(self):
    return '{type}(robotID={robotID}, result={result}, fwSig={fwSig})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      result=repr(self._result),
      fwSig=repr(self._fwSig))

Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete = FirmwareUpdateComplete
del FirmwareUpdateComplete


class RequestGameStart(object):
  "Generated message-passing message."

  __slots__ = (
    '_firstRequest', # bool
  )

  @property
  def firstRequest(self):
    "bool firstRequest struct property."
    return self._firstRequest

  @firstRequest.setter
  def firstRequest(self, value):
    self._firstRequest = msgbuffers.validate_bool(
      'RequestGameStart.firstRequest', value)

  def __init__(self, firstRequest=False):
    self.firstRequest = firstRequest

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestGameStart from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestGameStart.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestGameStart from the given BinaryReader."
    _firstRequest = bool(reader.read('b'))
    return cls(_firstRequest)

  def pack(self):
    "Writes the current RequestGameStart, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestGameStart to the given BinaryWriter."
    writer.write(int(self._firstRequest), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._firstRequest == other._firstRequest
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._firstRequest, 'b'))

  def __str__(self):
    return '{type}(firstRequest={firstRequest})'.format(
      type=type(self).__name__,
      firstRequest=self._firstRequest)

  def __repr__(self):
    return '{type}(firstRequest={firstRequest})'.format(
      type=type(self).__name__,
      firstRequest=repr(self._firstRequest))

Anki.Cozmo.ExternalInterface.RequestGameStart = RequestGameStart
del RequestGameStart


class RequestEnrollFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_firstRequest', # bool
    '_face_id',      # int_32
  )

  @property
  def firstRequest(self):
    "bool firstRequest struct property."
    return self._firstRequest

  @firstRequest.setter
  def firstRequest(self, value):
    self._firstRequest = msgbuffers.validate_bool(
      'RequestEnrollFace.firstRequest', value)

  @property
  def face_id(self):
    "int_32 face_id struct property."
    return self._face_id

  @face_id.setter
  def face_id(self, value):
    self._face_id = msgbuffers.validate_integer(
      'RequestEnrollFace.face_id', value, -2147483648, 2147483647)

  def __init__(self, firstRequest=False, face_id=0):
    self.firstRequest = firstRequest
    self.face_id = face_id

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestEnrollFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestEnrollFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestEnrollFace from the given BinaryReader."
    _firstRequest = bool(reader.read('b'))
    _face_id = reader.read('i')
    return cls(_firstRequest, _face_id)

  def pack(self):
    "Writes the current RequestEnrollFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestEnrollFace to the given BinaryWriter."
    writer.write(int(self._firstRequest), 'b')
    writer.write(self._face_id, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._firstRequest == other._firstRequest and
        self._face_id == other._face_id)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._firstRequest, 'b') +
      msgbuffers.size(self._face_id, 'i'))

  def __str__(self):
    return '{type}(firstRequest={firstRequest}, face_id={face_id})'.format(
      type=type(self).__name__,
      firstRequest=self._firstRequest,
      face_id=self._face_id)

  def __repr__(self):
    return '{type}(firstRequest={firstRequest}, face_id={face_id})'.format(
      type=type(self).__name__,
      firstRequest=repr(self._firstRequest),
      face_id=repr(self._face_id))

Anki.Cozmo.ExternalInterface.RequestEnrollFace = RequestEnrollFace
del RequestEnrollFace


class SparkEnded(object):
  "Generated message-passing message."

  __slots__ = (
    '_success', # bool
  )

  @property
  def success(self):
    "bool success struct property."
    return self._success

  @success.setter
  def success(self, value):
    self._success = msgbuffers.validate_bool(
      'SparkEnded.success', value)

  def __init__(self, success=False):
    self.success = success

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SparkEnded from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SparkEnded.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SparkEnded from the given BinaryReader."
    _success = bool(reader.read('b'))
    return cls(_success)

  def pack(self):
    "Writes the current SparkEnded, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SparkEnded to the given BinaryWriter."
    writer.write(int(self._success), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._success == other._success
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._success, 'b'))

  def __str__(self):
    return '{type}(success={success})'.format(
      type=type(self).__name__,
      success=self._success)

  def __repr__(self):
    return '{type}(success={success})'.format(
      type=type(self).__name__,
      success=repr(self._success))

Anki.Cozmo.ExternalInterface.SparkEnded = SparkEnded
del SparkEnded


class SdkConnectionStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_sdkBuildVersion',           # string[uint_8]
    '_requiredSdkBuildVersion',   # string[uint_8]
    '_numCommands',               # uint_32
    '_timeInCurrentConnection_s', # float_32
    '_isConnected',               # bool
    '_isWrongSdkVersion',         # bool
  )

  @property
  def sdkBuildVersion(self):
    "string[uint_8] sdkBuildVersion struct property."
    return self._sdkBuildVersion

  @sdkBuildVersion.setter
  def sdkBuildVersion(self, value):
    self._sdkBuildVersion = msgbuffers.validate_string(
      'SdkConnectionStatus.sdkBuildVersion', value, 255)

  @property
  def requiredSdkBuildVersion(self):
    "string[uint_8] requiredSdkBuildVersion struct property."
    return self._requiredSdkBuildVersion

  @requiredSdkBuildVersion.setter
  def requiredSdkBuildVersion(self, value):
    self._requiredSdkBuildVersion = msgbuffers.validate_string(
      'SdkConnectionStatus.requiredSdkBuildVersion', value, 255)

  @property
  def numCommands(self):
    "uint_32 numCommands struct property."
    return self._numCommands

  @numCommands.setter
  def numCommands(self, value):
    self._numCommands = msgbuffers.validate_integer(
      'SdkConnectionStatus.numCommands', value, 0, 4294967295)

  @property
  def timeInCurrentConnection_s(self):
    "float_32 timeInCurrentConnection_s struct property."
    return self._timeInCurrentConnection_s

  @timeInCurrentConnection_s.setter
  def timeInCurrentConnection_s(self, value):
    self._timeInCurrentConnection_s = msgbuffers.validate_float(
      'SdkConnectionStatus.timeInCurrentConnection_s', value, 'f')

  @property
  def isConnected(self):
    "bool isConnected struct property."
    return self._isConnected

  @isConnected.setter
  def isConnected(self, value):
    self._isConnected = msgbuffers.validate_bool(
      'SdkConnectionStatus.isConnected', value)

  @property
  def isWrongSdkVersion(self):
    "bool isWrongSdkVersion struct property."
    return self._isWrongSdkVersion

  @isWrongSdkVersion.setter
  def isWrongSdkVersion(self, value):
    self._isWrongSdkVersion = msgbuffers.validate_bool(
      'SdkConnectionStatus.isWrongSdkVersion', value)

  def __init__(self, sdkBuildVersion='', requiredSdkBuildVersion='', numCommands=0, timeInCurrentConnection_s=0.0, isConnected=False, isWrongSdkVersion=False):
    self.sdkBuildVersion = sdkBuildVersion
    self.requiredSdkBuildVersion = requiredSdkBuildVersion
    self.numCommands = numCommands
    self.timeInCurrentConnection_s = timeInCurrentConnection_s
    self.isConnected = isConnected
    self.isWrongSdkVersion = isWrongSdkVersion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SdkConnectionStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SdkConnectionStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SdkConnectionStatus from the given BinaryReader."
    _sdkBuildVersion = reader.read_string('B')
    _requiredSdkBuildVersion = reader.read_string('B')
    _numCommands = reader.read('I')
    _timeInCurrentConnection_s = reader.read('f')
    _isConnected = bool(reader.read('b'))
    _isWrongSdkVersion = bool(reader.read('b'))
    return cls(_sdkBuildVersion, _requiredSdkBuildVersion, _numCommands, _timeInCurrentConnection_s, _isConnected, _isWrongSdkVersion)

  def pack(self):
    "Writes the current SdkConnectionStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SdkConnectionStatus to the given BinaryWriter."
    writer.write_string(self._sdkBuildVersion, 'B')
    writer.write_string(self._requiredSdkBuildVersion, 'B')
    writer.write(self._numCommands, 'I')
    writer.write(self._timeInCurrentConnection_s, 'f')
    writer.write(int(self._isConnected), 'b')
    writer.write(int(self._isWrongSdkVersion), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._sdkBuildVersion == other._sdkBuildVersion and
        self._requiredSdkBuildVersion == other._requiredSdkBuildVersion and
        self._numCommands == other._numCommands and
        self._timeInCurrentConnection_s == other._timeInCurrentConnection_s and
        self._isConnected == other._isConnected and
        self._isWrongSdkVersion == other._isWrongSdkVersion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._sdkBuildVersion, 'B') +
      msgbuffers.size_string(self._requiredSdkBuildVersion, 'B') +
      msgbuffers.size(self._numCommands, 'I') +
      msgbuffers.size(self._timeInCurrentConnection_s, 'f') +
      msgbuffers.size(self._isConnected, 'b') +
      msgbuffers.size(self._isWrongSdkVersion, 'b'))

  def __str__(self):
    return '{type}(sdkBuildVersion={sdkBuildVersion}, requiredSdkBuildVersion={requiredSdkBuildVersion}, numCommands={numCommands}, timeInCurrentConnection_s={timeInCurrentConnection_s}, isConnected={isConnected}, isWrongSdkVersion={isWrongSdkVersion})'.format(
      type=type(self).__name__,
      sdkBuildVersion=msgbuffers.shorten_string(self._sdkBuildVersion),
      requiredSdkBuildVersion=msgbuffers.shorten_string(self._requiredSdkBuildVersion),
      numCommands=self._numCommands,
      timeInCurrentConnection_s=self._timeInCurrentConnection_s,
      isConnected=self._isConnected,
      isWrongSdkVersion=self._isWrongSdkVersion)

  def __repr__(self):
    return '{type}(sdkBuildVersion={sdkBuildVersion}, requiredSdkBuildVersion={requiredSdkBuildVersion}, numCommands={numCommands}, timeInCurrentConnection_s={timeInCurrentConnection_s}, isConnected={isConnected}, isWrongSdkVersion={isWrongSdkVersion})'.format(
      type=type(self).__name__,
      sdkBuildVersion=repr(self._sdkBuildVersion),
      requiredSdkBuildVersion=repr(self._requiredSdkBuildVersion),
      numCommands=repr(self._numCommands),
      timeInCurrentConnection_s=repr(self._timeInCurrentConnection_s),
      isConnected=repr(self._isConnected),
      isWrongSdkVersion=repr(self._isWrongSdkVersion))

Anki.Cozmo.ExternalInterface.SdkConnectionStatus = SdkConnectionStatus
del SdkConnectionStatus


class SdkStatus(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectionStatus',          # Anki.Cozmo.ExternalInterface.SdkConnectionStatus
    '_sdkStatus',                 # string[uint_8][uint_8]
    '_numTimesConnected',         # uint_32
    '_timeInSdkMode_s',           # float_32
    '_timeSinceLastSdkMessage_s', # float_32
    '_timeSinceLastSdkCommand_s', # float_32
  )

  @property
  def connectionStatus(self):
    "Anki.Cozmo.ExternalInterface.SdkConnectionStatus connectionStatus struct property."
    return self._connectionStatus

  @connectionStatus.setter
  def connectionStatus(self, value):
    self._connectionStatus = msgbuffers.validate_object(
      'SdkStatus.connectionStatus', value, Anki.Cozmo.ExternalInterface.SdkConnectionStatus)

  @property
  def sdkStatus(self):
    "string[uint_8][uint_8] sdkStatus struct property."
    return self._sdkStatus

  @sdkStatus.setter
  def sdkStatus(self, value):
    self._sdkStatus = msgbuffers.validate_varray(
      'SdkStatus.sdkStatus', value, 255,
      lambda name, value_inner: msgbuffers.validate_string(
        name, value_inner, 255))

  @property
  def numTimesConnected(self):
    "uint_32 numTimesConnected struct property."
    return self._numTimesConnected

  @numTimesConnected.setter
  def numTimesConnected(self, value):
    self._numTimesConnected = msgbuffers.validate_integer(
      'SdkStatus.numTimesConnected', value, 0, 4294967295)

  @property
  def timeInSdkMode_s(self):
    "float_32 timeInSdkMode_s struct property."
    return self._timeInSdkMode_s

  @timeInSdkMode_s.setter
  def timeInSdkMode_s(self, value):
    self._timeInSdkMode_s = msgbuffers.validate_float(
      'SdkStatus.timeInSdkMode_s', value, 'f')

  @property
  def timeSinceLastSdkMessage_s(self):
    "float_32 timeSinceLastSdkMessage_s struct property."
    return self._timeSinceLastSdkMessage_s

  @timeSinceLastSdkMessage_s.setter
  def timeSinceLastSdkMessage_s(self, value):
    self._timeSinceLastSdkMessage_s = msgbuffers.validate_float(
      'SdkStatus.timeSinceLastSdkMessage_s', value, 'f')

  @property
  def timeSinceLastSdkCommand_s(self):
    "float_32 timeSinceLastSdkCommand_s struct property."
    return self._timeSinceLastSdkCommand_s

  @timeSinceLastSdkCommand_s.setter
  def timeSinceLastSdkCommand_s(self, value):
    self._timeSinceLastSdkCommand_s = msgbuffers.validate_float(
      'SdkStatus.timeSinceLastSdkCommand_s', value, 'f')

  def __init__(self, connectionStatus=Anki.Cozmo.ExternalInterface.SdkConnectionStatus(), sdkStatus=(), numTimesConnected=0, timeInSdkMode_s=0.0, timeSinceLastSdkMessage_s=0.0, timeSinceLastSdkCommand_s=0.0):
    self.connectionStatus = connectionStatus
    self.sdkStatus = sdkStatus
    self.numTimesConnected = numTimesConnected
    self.timeInSdkMode_s = timeInSdkMode_s
    self.timeSinceLastSdkMessage_s = timeSinceLastSdkMessage_s
    self.timeSinceLastSdkCommand_s = timeSinceLastSdkCommand_s

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SdkStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SdkStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SdkStatus from the given BinaryReader."
    _connectionStatus = reader.read_object(Anki.Cozmo.ExternalInterface.SdkConnectionStatus.unpack_from)
    _sdkStatus = reader.read_string_varray('B', 'B')
    _numTimesConnected = reader.read('I')
    _timeInSdkMode_s = reader.read('f')
    _timeSinceLastSdkMessage_s = reader.read('f')
    _timeSinceLastSdkCommand_s = reader.read('f')
    return cls(_connectionStatus, _sdkStatus, _numTimesConnected, _timeInSdkMode_s, _timeSinceLastSdkMessage_s, _timeSinceLastSdkCommand_s)

  def pack(self):
    "Writes the current SdkStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SdkStatus to the given BinaryWriter."
    writer.write_object(self._connectionStatus)
    writer.write_string_varray(self._sdkStatus, 'B', 'B')
    writer.write(self._numTimesConnected, 'I')
    writer.write(self._timeInSdkMode_s, 'f')
    writer.write(self._timeSinceLastSdkMessage_s, 'f')
    writer.write(self._timeSinceLastSdkCommand_s, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._connectionStatus == other._connectionStatus and
        self._sdkStatus == other._sdkStatus and
        self._numTimesConnected == other._numTimesConnected and
        self._timeInSdkMode_s == other._timeInSdkMode_s and
        self._timeSinceLastSdkMessage_s == other._timeSinceLastSdkMessage_s and
        self._timeSinceLastSdkCommand_s == other._timeSinceLastSdkCommand_s)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._connectionStatus) +
      msgbuffers.size_string_varray(self._sdkStatus, 'B', 'B') +
      msgbuffers.size(self._numTimesConnected, 'I') +
      msgbuffers.size(self._timeInSdkMode_s, 'f') +
      msgbuffers.size(self._timeSinceLastSdkMessage_s, 'f') +
      msgbuffers.size(self._timeSinceLastSdkCommand_s, 'f'))

  def __str__(self):
    return '{type}(connectionStatus={connectionStatus}, sdkStatus={sdkStatus}, numTimesConnected={numTimesConnected}, timeInSdkMode_s={timeInSdkMode_s}, timeSinceLastSdkMessage_s={timeSinceLastSdkMessage_s}, timeSinceLastSdkCommand_s={timeSinceLastSdkCommand_s})'.format(
      type=type(self).__name__,
      connectionStatus=self._connectionStatus,
      sdkStatus=msgbuffers.shorten_sequence(self._sdkStatus, msgbuffers.shorten_string),
      numTimesConnected=self._numTimesConnected,
      timeInSdkMode_s=self._timeInSdkMode_s,
      timeSinceLastSdkMessage_s=self._timeSinceLastSdkMessage_s,
      timeSinceLastSdkCommand_s=self._timeSinceLastSdkCommand_s)

  def __repr__(self):
    return '{type}(connectionStatus={connectionStatus}, sdkStatus={sdkStatus}, numTimesConnected={numTimesConnected}, timeInSdkMode_s={timeInSdkMode_s}, timeSinceLastSdkMessage_s={timeSinceLastSdkMessage_s}, timeSinceLastSdkCommand_s={timeSinceLastSdkCommand_s})'.format(
      type=type(self).__name__,
      connectionStatus=repr(self._connectionStatus),
      sdkStatus=repr(self._sdkStatus),
      numTimesConnected=repr(self._numTimesConnected),
      timeInSdkMode_s=repr(self._timeInSdkMode_s),
      timeSinceLastSdkMessage_s=repr(self._timeSinceLastSdkMessage_s),
      timeSinceLastSdkCommand_s=repr(self._timeSinceLastSdkCommand_s))

Anki.Cozmo.ExternalInterface.SdkStatus = SdkStatus
del SdkStatus


class BehaviorTransition(object):
  "Generated message-passing message."

  __slots__ = (
    '_oldBehavior',      # string[uint_8]
    '_newBehavior',      # string[uint_8]
    '_oldBehaviorType',  # Anki.Cozmo.BehaviorType
    '_newBehaviorType',  # Anki.Cozmo.BehaviorType
    '_isOldReactionary', # bool
    '_isNewReactionary', # bool
  )

  @property
  def oldBehavior(self):
    "string[uint_8] oldBehavior struct property."
    return self._oldBehavior

  @oldBehavior.setter
  def oldBehavior(self, value):
    self._oldBehavior = msgbuffers.validate_string(
      'BehaviorTransition.oldBehavior', value, 255)

  @property
  def newBehavior(self):
    "string[uint_8] newBehavior struct property."
    return self._newBehavior

  @newBehavior.setter
  def newBehavior(self, value):
    self._newBehavior = msgbuffers.validate_string(
      'BehaviorTransition.newBehavior', value, 255)

  @property
  def oldBehaviorType(self):
    "Anki.Cozmo.BehaviorType oldBehaviorType struct property."
    return self._oldBehaviorType

  @oldBehaviorType.setter
  def oldBehaviorType(self, value):
    self._oldBehaviorType = msgbuffers.validate_integer(
      'BehaviorTransition.oldBehaviorType', value, 0, 255)

  @property
  def newBehaviorType(self):
    "Anki.Cozmo.BehaviorType newBehaviorType struct property."
    return self._newBehaviorType

  @newBehaviorType.setter
  def newBehaviorType(self, value):
    self._newBehaviorType = msgbuffers.validate_integer(
      'BehaviorTransition.newBehaviorType', value, 0, 255)

  @property
  def isOldReactionary(self):
    "bool isOldReactionary struct property."
    return self._isOldReactionary

  @isOldReactionary.setter
  def isOldReactionary(self, value):
    self._isOldReactionary = msgbuffers.validate_bool(
      'BehaviorTransition.isOldReactionary', value)

  @property
  def isNewReactionary(self):
    "bool isNewReactionary struct property."
    return self._isNewReactionary

  @isNewReactionary.setter
  def isNewReactionary(self, value):
    self._isNewReactionary = msgbuffers.validate_bool(
      'BehaviorTransition.isNewReactionary', value)

  def __init__(self, oldBehavior='', newBehavior='', oldBehaviorType=Anki.Cozmo.BehaviorType.NoneBehavior, newBehaviorType=Anki.Cozmo.BehaviorType.NoneBehavior, isOldReactionary=False, isNewReactionary=False):
    self.oldBehavior = oldBehavior
    self.newBehavior = newBehavior
    self.oldBehaviorType = oldBehaviorType
    self.newBehaviorType = newBehaviorType
    self.isOldReactionary = isOldReactionary
    self.isNewReactionary = isNewReactionary

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BehaviorTransition from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BehaviorTransition.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BehaviorTransition from the given BinaryReader."
    _oldBehavior = reader.read_string('B')
    _newBehavior = reader.read_string('B')
    _oldBehaviorType = reader.read('B')
    _newBehaviorType = reader.read('B')
    _isOldReactionary = bool(reader.read('b'))
    _isNewReactionary = bool(reader.read('b'))
    return cls(_oldBehavior, _newBehavior, _oldBehaviorType, _newBehaviorType, _isOldReactionary, _isNewReactionary)

  def pack(self):
    "Writes the current BehaviorTransition, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BehaviorTransition to the given BinaryWriter."
    writer.write_string(self._oldBehavior, 'B')
    writer.write_string(self._newBehavior, 'B')
    writer.write(self._oldBehaviorType, 'B')
    writer.write(self._newBehaviorType, 'B')
    writer.write(int(self._isOldReactionary), 'b')
    writer.write(int(self._isNewReactionary), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._oldBehavior == other._oldBehavior and
        self._newBehavior == other._newBehavior and
        self._oldBehaviorType == other._oldBehaviorType and
        self._newBehaviorType == other._newBehaviorType and
        self._isOldReactionary == other._isOldReactionary and
        self._isNewReactionary == other._isNewReactionary)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._oldBehavior, 'B') +
      msgbuffers.size_string(self._newBehavior, 'B') +
      msgbuffers.size(self._oldBehaviorType, 'B') +
      msgbuffers.size(self._newBehaviorType, 'B') +
      msgbuffers.size(self._isOldReactionary, 'b') +
      msgbuffers.size(self._isNewReactionary, 'b'))

  def __str__(self):
    return '{type}(oldBehavior={oldBehavior}, newBehavior={newBehavior}, oldBehaviorType={oldBehaviorType}, newBehaviorType={newBehaviorType}, isOldReactionary={isOldReactionary}, isNewReactionary={isNewReactionary})'.format(
      type=type(self).__name__,
      oldBehavior=msgbuffers.shorten_string(self._oldBehavior),
      newBehavior=msgbuffers.shorten_string(self._newBehavior),
      oldBehaviorType=self._oldBehaviorType,
      newBehaviorType=self._newBehaviorType,
      isOldReactionary=self._isOldReactionary,
      isNewReactionary=self._isNewReactionary)

  def __repr__(self):
    return '{type}(oldBehavior={oldBehavior}, newBehavior={newBehavior}, oldBehaviorType={oldBehaviorType}, newBehaviorType={newBehaviorType}, isOldReactionary={isOldReactionary}, isNewReactionary={isNewReactionary})'.format(
      type=type(self).__name__,
      oldBehavior=repr(self._oldBehavior),
      newBehavior=repr(self._newBehavior),
      oldBehaviorType=repr(self._oldBehaviorType),
      newBehaviorType=repr(self._newBehaviorType),
      isOldReactionary=repr(self._isOldReactionary),
      isNewReactionary=repr(self._isNewReactionary))

Anki.Cozmo.ExternalInterface.BehaviorTransition = BehaviorTransition
del BehaviorTransition


class RespondEnabledBehaviorList(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviors', # string[uint_8][uint_8]
  )

  @property
  def behaviors(self):
    "string[uint_8][uint_8] behaviors struct property."
    return self._behaviors

  @behaviors.setter
  def behaviors(self, value):
    self._behaviors = msgbuffers.validate_varray(
      'RespondEnabledBehaviorList.behaviors', value, 255,
      lambda name, value_inner: msgbuffers.validate_string(
        name, value_inner, 255))

  def __init__(self, behaviors=()):
    self.behaviors = behaviors

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RespondEnabledBehaviorList from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RespondEnabledBehaviorList.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RespondEnabledBehaviorList from the given BinaryReader."
    _behaviors = reader.read_string_varray('B', 'B')
    return cls(_behaviors)

  def pack(self):
    "Writes the current RespondEnabledBehaviorList, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RespondEnabledBehaviorList to the given BinaryWriter."
    writer.write_string_varray(self._behaviors, 'B', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviors == other._behaviors
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string_varray(self._behaviors, 'B', 'B'))

  def __str__(self):
    return '{type}(behaviors={behaviors})'.format(
      type=type(self).__name__,
      behaviors=msgbuffers.shorten_sequence(self._behaviors, msgbuffers.shorten_string))

  def __repr__(self):
    return '{type}(behaviors={behaviors})'.format(
      type=type(self).__name__,
      behaviors=repr(self._behaviors))

Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList = RespondEnabledBehaviorList
del RespondEnabledBehaviorList


class ReactionaryBehaviorTransition(object):
  "Generated message-passing message."

  __slots__ = (
    '_reactionaryBehaviorType', # Anki.Cozmo.BehaviorType
    '_behaviorStarted',         # bool
  )

  @property
  def reactionaryBehaviorType(self):
    "Anki.Cozmo.BehaviorType reactionaryBehaviorType struct property."
    return self._reactionaryBehaviorType

  @reactionaryBehaviorType.setter
  def reactionaryBehaviorType(self, value):
    self._reactionaryBehaviorType = msgbuffers.validate_integer(
      'ReactionaryBehaviorTransition.reactionaryBehaviorType', value, 0, 255)

  @property
  def behaviorStarted(self):
    "bool behaviorStarted struct property."
    return self._behaviorStarted

  @behaviorStarted.setter
  def behaviorStarted(self, value):
    self._behaviorStarted = msgbuffers.validate_bool(
      'ReactionaryBehaviorTransition.behaviorStarted', value)

  def __init__(self, reactionaryBehaviorType=Anki.Cozmo.BehaviorType.NoneBehavior, behaviorStarted=False):
    self.reactionaryBehaviorType = reactionaryBehaviorType
    self.behaviorStarted = behaviorStarted

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReactionaryBehaviorTransition from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReactionaryBehaviorTransition.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReactionaryBehaviorTransition from the given BinaryReader."
    _reactionaryBehaviorType = reader.read('B')
    _behaviorStarted = bool(reader.read('b'))
    return cls(_reactionaryBehaviorType, _behaviorStarted)

  def pack(self):
    "Writes the current ReactionaryBehaviorTransition, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReactionaryBehaviorTransition to the given BinaryWriter."
    writer.write(self._reactionaryBehaviorType, 'B')
    writer.write(int(self._behaviorStarted), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._reactionaryBehaviorType == other._reactionaryBehaviorType and
        self._behaviorStarted == other._behaviorStarted)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._reactionaryBehaviorType, 'B') +
      msgbuffers.size(self._behaviorStarted, 'b'))

  def __str__(self):
    return '{type}(reactionaryBehaviorType={reactionaryBehaviorType}, behaviorStarted={behaviorStarted})'.format(
      type=type(self).__name__,
      reactionaryBehaviorType=self._reactionaryBehaviorType,
      behaviorStarted=self._behaviorStarted)

  def __repr__(self):
    return '{type}(reactionaryBehaviorType={reactionaryBehaviorType}, behaviorStarted={behaviorStarted})'.format(
      type=type(self).__name__,
      reactionaryBehaviorType=repr(self._reactionaryBehaviorType),
      behaviorStarted=repr(self._behaviorStarted))

Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition = ReactionaryBehaviorTransition
del ReactionaryBehaviorTransition


class BehaviorObjectiveAchieved(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviorObjective', # Anki.Cozmo.BehaviorObjective
  )

  @property
  def behaviorObjective(self):
    "Anki.Cozmo.BehaviorObjective behaviorObjective struct property."
    return self._behaviorObjective

  @behaviorObjective.setter
  def behaviorObjective(self, value):
    self._behaviorObjective = msgbuffers.validate_integer(
      'BehaviorObjectiveAchieved.behaviorObjective', value, -2147483648, 2147483647)

  def __init__(self, behaviorObjective=Anki.Cozmo.BehaviorObjective.Unknown):
    self.behaviorObjective = behaviorObjective

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BehaviorObjectiveAchieved from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BehaviorObjectiveAchieved.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BehaviorObjectiveAchieved from the given BinaryReader."
    _behaviorObjective = reader.read('i')
    return cls(_behaviorObjective)

  def pack(self):
    "Writes the current BehaviorObjectiveAchieved, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BehaviorObjectiveAchieved to the given BinaryWriter."
    writer.write(self._behaviorObjective, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviorObjective == other._behaviorObjective
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._behaviorObjective, 'i'))

  def __str__(self):
    return '{type}(behaviorObjective={behaviorObjective})'.format(
      type=type(self).__name__,
      behaviorObjective=self._behaviorObjective)

  def __repr__(self):
    return '{type}(behaviorObjective={behaviorObjective})'.format(
      type=type(self).__name__,
      behaviorObjective=repr(self._behaviorObjective))

Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved = BehaviorObjectiveAchieved
del BehaviorObjectiveAchieved


class OnboardingStateEnum(object):
  "Automatically-generated uint_8 enumeration."
  Inactive                = 0
  ErrorCozmo              = 1
  ErrorCubeMoved          = 2
  ErrorCubeWrongSideUp    = 3
  ErrorFinal              = 4
  WaitForShowCube         = 5
  WaitForOKCubeDiscovered = 6
  WaitForInspectCube      = 7
  WaitForFinalContinue    = 8

Anki.Cozmo.ExternalInterface.OnboardingStateEnum = OnboardingStateEnum
del OnboardingStateEnum


class OnboardingState(object):
  "Generated message-passing message."

  __slots__ = (
    '_stateNum', # Anki.Cozmo.ExternalInterface.OnboardingStateEnum
  )

  @property
  def stateNum(self):
    "Anki.Cozmo.ExternalInterface.OnboardingStateEnum stateNum struct property."
    return self._stateNum

  @stateNum.setter
  def stateNum(self, value):
    self._stateNum = msgbuffers.validate_integer(
      'OnboardingState.stateNum', value, 0, 255)

  def __init__(self, stateNum=Anki.Cozmo.ExternalInterface.OnboardingStateEnum.Inactive):
    self.stateNum = stateNum

  @classmethod
  def unpack(cls, buffer):
    "Reads a new OnboardingState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('OnboardingState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new OnboardingState from the given BinaryReader."
    _stateNum = reader.read('B')
    return cls(_stateNum)

  def pack(self):
    "Writes the current OnboardingState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current OnboardingState to the given BinaryWriter."
    writer.write(self._stateNum, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._stateNum == other._stateNum
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._stateNum, 'B'))

  def __str__(self):
    return '{type}(stateNum={stateNum})'.format(
      type=type(self).__name__,
      stateNum=self._stateNum)

  def __repr__(self):
    return '{type}(stateNum={stateNum})'.format(
      type=type(self).__name__,
      stateNum=repr(self._stateNum))

Anki.Cozmo.ExternalInterface.OnboardingState = OnboardingState
del OnboardingState


class SupportInfo(object):
  "Generated message-passing message."

  __slots__ = (
    '_deviceId', # string[uint_8]
  )

  @property
  def deviceId(self):
    "string[uint_8] deviceId struct property."
    return self._deviceId

  @deviceId.setter
  def deviceId(self, value):
    self._deviceId = msgbuffers.validate_string(
      'SupportInfo.deviceId', value, 255)

  def __init__(self, deviceId=''):
    self.deviceId = deviceId

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SupportInfo from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SupportInfo.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SupportInfo from the given BinaryReader."
    _deviceId = reader.read_string('B')
    return cls(_deviceId)

  def pack(self):
    "Writes the current SupportInfo, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SupportInfo to the given BinaryWriter."
    writer.write_string(self._deviceId, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._deviceId == other._deviceId
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._deviceId, 'B'))

  def __str__(self):
    return '{type}(deviceId={deviceId})'.format(
      type=type(self).__name__,
      deviceId=msgbuffers.shorten_string(self._deviceId))

  def __repr__(self):
    return '{type}(deviceId={deviceId})'.format(
      type=type(self).__name__,
      deviceId=repr(self._deviceId))

Anki.Cozmo.ExternalInterface.SupportInfo = SupportInfo
del SupportInfo


class MessageType(object):
  "Automatically-generated uint_8 enumeration."
  AnimationAvailable = 0

Anki.Cozmo.ExternalInterface.MessageType = MessageType
del MessageType


class EndOfMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_messageType', # Anki.Cozmo.ExternalInterface.MessageType
  )

  @property
  def messageType(self):
    "Anki.Cozmo.ExternalInterface.MessageType messageType struct property."
    return self._messageType

  @messageType.setter
  def messageType(self, value):
    self._messageType = msgbuffers.validate_integer(
      'EndOfMessage.messageType', value, 0, 255)

  def __init__(self, messageType=Anki.Cozmo.ExternalInterface.MessageType.AnimationAvailable):
    self.messageType = messageType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EndOfMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EndOfMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EndOfMessage from the given BinaryReader."
    _messageType = reader.read('B')
    return cls(_messageType)

  def pack(self):
    "Writes the current EndOfMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EndOfMessage to the given BinaryWriter."
    writer.write(self._messageType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._messageType == other._messageType
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._messageType, 'B'))

  def __str__(self):
    return '{type}(messageType={messageType})'.format(
      type=type(self).__name__,
      messageType=self._messageType)

  def __repr__(self):
    return '{type}(messageType={messageType})'.format(
      type=type(self).__name__,
      messageType=repr(self._messageType))

Anki.Cozmo.ExternalInterface.EndOfMessage = EndOfMessage
del EndOfMessage


class MessageEngineToGame(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    UiDeviceConnected              = 0x0  # Anki.Cozmo.ExternalInterface.UiDeviceConnected
    AudioCallback                  = 0x1  # Anki.Cozmo.Audio.AudioCallback
    AdvertisementRegistrationMsg   = 0x2  # Anki.Cozmo.AdvertisementRegistrationMsg
    AdvertisementMsg               = 0x3  # Anki.Cozmo.AdvertisementMsg
    Ping                           = 0x4  # Anki.Cozmo.ExternalInterface.Ping
    DenyGameStart                  = 0x5  # Anki.Cozmo.ExternalInterface.DenyGameStart
    ObjectDiscovered               = 0x6  # Anki.Cozmo.ObjectDiscovered
    ObjectConnectionState          = 0x7  # Anki.Cozmo.ObjectConnectionState
    ObjectConnectionStateToRobot   = 0x8  # Anki.Cozmo.ObjectConnectionStateToRobot
    ObjectMoved                    = 0x9  # Anki.Cozmo.ObjectMoved
    ObjectStoppedMoving            = 0xa  # Anki.Cozmo.ObjectStoppedMoving
    ObjectUpAxisChanged            = 0xb  # Anki.Cozmo.ObjectUpAxisChanged
    ObjectTapped                   = 0xc  # Anki.Cozmo.ObjectTapped
    ObjectPowerLevel               = 0xd  # Anki.Cozmo.ObjectPowerLevel
    FactoryTestResultEntry         = 0xe  # Anki.Cozmo.FactoryTestResultEntry
    ImageChunk                     = 0xf  # Anki.Cozmo.ImageChunk
    ImageImuData                   = 0x10 # Anki.Cozmo.ImageImuData
    CameraCalibration              = 0x11 # Anki.Cozmo.CameraCalibration
    IMURequest                     = 0x12 # Anki.Cozmo.IMURequest
    LoadedKnownFace                = 0x13 # Anki.Vision.LoadedKnownFace
    RobotRenamedEnrolledFace       = 0x14 # Anki.Vision.RobotRenamedEnrolledFace
    MotorCalibration               = 0x15 # Anki.Cozmo.MotorCalibration
    MotorAutoEnabled               = 0x16 # Anki.Cozmo.MotorAutoEnabled
    CliffEvent                     = 0x17 # Anki.Cozmo.CliffEvent
    PotentialCliff                 = 0x18 # Anki.Cozmo.PotentialCliff
    ProxObstacle                   = 0x19 # Anki.Cozmo.ProxObstacle
    CarryStateUpdate               = 0x1a # Anki.Cozmo.CarryStateUpdate
    SetBodyRadioMode               = 0x1b # Anki.Cozmo.SetBodyRadioMode
    AnimationState                 = 0x1c # Anki.Cozmo.RobotInterface.AnimationState
    UiDeviceAvailable              = 0x1d # Anki.Cozmo.ExternalInterface.UiDeviceAvailable
    RobotConnectionResponse        = 0x1e # Anki.Cozmo.ExternalInterface.RobotConnectionResponse
    RobotDisconnected              = 0x1f # Anki.Cozmo.ExternalInterface.RobotDisconnected
    EngineRobotCLADVersionMismatch = 0x20 # Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch
    ObjectAvailable                = 0x21 # Anki.Cozmo.ExternalInterface.ObjectAvailable
    ObjectUnavailable              = 0x22 # Anki.Cozmo.ExternalInterface.ObjectUnavailable
    FeatureToggles                 = 0x23 # Anki.Cozmo.ExternalInterface.FeatureToggles
    GoingToSleep                   = 0x24 # Anki.Cozmo.ExternalInterface.GoingToSleep
    EngineLoadingDataStatus        = 0x25 # Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus
    RobotState                     = 0x26 # Anki.Cozmo.ExternalInterface.RobotState
    RobotDelocalized               = 0x27 # Anki.Cozmo.ExternalInterface.RobotDelocalized
    RobotPoked                     = 0x28 # Anki.Cozmo.ExternalInterface.RobotPoked
    RobotStopped                   = 0x29 # Anki.Cozmo.ExternalInterface.RobotStopped
    RobotOffTreadsStateChanged     = 0x2a # Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged
    RobotCliffEventFinished        = 0x2b # Anki.Cozmo.ExternalInterface.RobotCliffEventFinished
    RobotOnChargerPlatformEvent    = 0x2c # Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent
    ChargerEvent                   = 0x2d # Anki.Cozmo.ExternalInterface.ChargerEvent
    UnexpectedMovement             = 0x2e # Anki.Cozmo.ExternalInterface.UnexpectedMovement
    RestoreRobotStatus             = 0x2f # Anki.Cozmo.ExternalInterface.RestoreRobotStatus
    RestoreRobotOptions            = 0x30 # Anki.Cozmo.ExternalInterface.RestoreRobotOptions
    DebugString                    = 0x31 # Anki.Cozmo.ExternalInterface.DebugString
    DebugAnimationString           = 0x32 # Anki.Cozmo.ExternalInterface.DebugAnimationString
    RobotProcessedImage            = 0x33 # Anki.Cozmo.ExternalInterface.RobotProcessedImage
    RobotObservedObject            = 0x34 # Anki.Cozmo.ExternalInterface.RobotObservedObject
    RobotObservedPossibleObject    = 0x35 # Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject
    ObjectProjectsIntoFOV          = 0x36 # Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV
    RobotObservedFace              = 0x37 # Anki.Cozmo.ExternalInterface.RobotObservedFace
    RobotChangedObservedFaceID     = 0x38 # Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID
    RobotObservedPet               = 0x39 # Anki.Cozmo.ExternalInterface.RobotObservedPet
    RobotObservedMotion            = 0x3a # Anki.Cozmo.ExternalInterface.RobotObservedMotion
    RobotDeletedFace               = 0x3b # Anki.Cozmo.ExternalInterface.RobotDeletedFace
    RobotDeletedObject             = 0x3c # Anki.Cozmo.ExternalInterface.RobotDeletedObject
    RobotDeletedAllObjects         = 0x3d # Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects
    RobotDeletedAllCustomObjects   = 0x3e # Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects
    CreatedFixedCustomObject       = 0x3f # Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject
    DefinedCustomObject            = 0x40 # Anki.Cozmo.ExternalInterface.DefinedCustomObject
    RobotMarkedObjectPoseUnknown   = 0x41 # Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown
    AvailableObjects               = 0x42 # Anki.Cozmo.ExternalInterface.AvailableObjects
    RobotReadToolCode              = 0x43 # Anki.Cozmo.ExternalInterface.RobotReadToolCode
    RobotReachedEnrollmentCount    = 0x44 # Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount
    RobotErasedEnrolledFace        = 0x45 # Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace
    RobotErasedAllEnrolledFaces    = 0x46 # Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces
    RobotCompletedFactoryDotTest   = 0x47 # Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest
    RobotCompletedAction           = 0x48 # Anki.Cozmo.ExternalInterface.RobotCompletedAction
    BlockPickedUp                  = 0x49 # Anki.Cozmo.ExternalInterface.BlockPickedUp
    BlockPlaced                    = 0x4a # Anki.Cozmo.ExternalInterface.BlockPlaced
    AnimationAvailable             = 0x4b # Anki.Cozmo.ExternalInterface.AnimationAvailable
    AnimationGroupAvailable        = 0x4c # Anki.Cozmo.ExternalInterface.AnimationGroupAvailable
    AnimationAborted               = 0x4d # Anki.Cozmo.ExternalInterface.AnimationAborted
    AnimationEvent                 = 0x4e # Anki.Cozmo.ExternalInterface.AnimationEvent
    MoodState                      = 0x4f # Anki.Cozmo.ExternalInterface.MoodState
    RequestSetUnlockResult         = 0x50 # Anki.Cozmo.ExternalInterface.RequestSetUnlockResult
    UnlockStatus                   = 0x51 # Anki.Cozmo.ExternalInterface.UnlockStatus
    UnlockedDefaults               = 0x52 # Anki.Cozmo.ExternalInterface.UnlockedDefaults
    InitDebugConsoleVarMessage     = 0x53 # Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage
    JsonDasLogMessage              = 0x54 # Anki.Cozmo.ExternalInterface.JsonDasLogMessage
    JsonDasLogAllSentMessage       = 0x55 # Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage
    VerifyDebugConsoleFuncMessage  = 0x56 # Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage
    VerifyDebugConsoleVarMessage   = 0x57 # Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage
    LatencyMessage                 = 0x58 # Anki.Cozmo.ExternalInterface.LatencyMessage
    DeviceDataMessage              = 0x59 # Anki.Cozmo.ExternalInterface.DeviceDataMessage
    BlockTapFilterStatus           = 0x5a # Anki.Cozmo.ExternalInterface.BlockTapFilterStatus
    UpdateEngineState              = 0x5b # Anki.Cozmo.ExternalInterface.UpdateEngineState
    EngineErrorCodeMessage         = 0x5c # Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage
    CubeLightsStateTransition      = 0x5d # Anki.Cozmo.ExternalInterface.CubeLightsStateTransition
    BlockPoolDataMessage           = 0x5e # Anki.Cozmo.ExternalInterface.BlockPoolDataMessage
    NVStorageOpResult              = 0x5f # Anki.Cozmo.ExternalInterface.NVStorageOpResult
    FirmwareUpdateProgress         = 0x60 # Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress
    FirmwareUpdateComplete         = 0x61 # Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete
    RequestGameStart               = 0x62 # Anki.Cozmo.ExternalInterface.RequestGameStart
    RequestEnrollFace              = 0x63 # Anki.Cozmo.ExternalInterface.RequestEnrollFace
    SparkEnded                     = 0x64 # Anki.Cozmo.ExternalInterface.SparkEnded
    SdkConnectionStatus            = 0x65 # Anki.Cozmo.ExternalInterface.SdkConnectionStatus
    SdkStatus                      = 0x66 # Anki.Cozmo.ExternalInterface.SdkStatus
    BehaviorTransition             = 0x67 # Anki.Cozmo.ExternalInterface.BehaviorTransition
    RespondEnabledBehaviorList     = 0x68 # Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList
    ReactionaryBehaviorTransition  = 0x69 # Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition
    BehaviorObjectiveAchieved      = 0x6a # Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved
    OnboardingState                = 0x6b # Anki.Cozmo.ExternalInterface.OnboardingState
    SupportInfo                    = 0x6c # Anki.Cozmo.ExternalInterface.SupportInfo
    EndOfMessage                   = 0x6d # Anki.Cozmo.ExternalInterface.EndOfMessage

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def UiDeviceConnected(self):
    "Anki.Cozmo.ExternalInterface.UiDeviceConnected UiDeviceConnected union property."
    msgbuffers.safety_check_tag('UiDeviceConnected', self._tag, self.Tag.UiDeviceConnected, self._tags_by_value)
    return self._data

  @UiDeviceConnected.setter
  def UiDeviceConnected(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UiDeviceConnected', value, Anki.Cozmo.ExternalInterface.UiDeviceConnected)
    self._tag = self.Tag.UiDeviceConnected

  @property
  def AudioCallback(self):
    "Anki.Cozmo.Audio.AudioCallback AudioCallback union property."
    msgbuffers.safety_check_tag('AudioCallback', self._tag, self.Tag.AudioCallback, self._tags_by_value)
    return self._data

  @AudioCallback.setter
  def AudioCallback(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AudioCallback', value, Anki.Cozmo.Audio.AudioCallback)
    self._tag = self.Tag.AudioCallback

  @property
  def AdvertisementRegistrationMsg(self):
    "Anki.Cozmo.AdvertisementRegistrationMsg AdvertisementRegistrationMsg union property."
    msgbuffers.safety_check_tag('AdvertisementRegistrationMsg', self._tag, self.Tag.AdvertisementRegistrationMsg, self._tags_by_value)
    return self._data

  @AdvertisementRegistrationMsg.setter
  def AdvertisementRegistrationMsg(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AdvertisementRegistrationMsg', value, Anki.Cozmo.AdvertisementRegistrationMsg)
    self._tag = self.Tag.AdvertisementRegistrationMsg

  @property
  def AdvertisementMsg(self):
    "Anki.Cozmo.AdvertisementMsg AdvertisementMsg union property."
    msgbuffers.safety_check_tag('AdvertisementMsg', self._tag, self.Tag.AdvertisementMsg, self._tags_by_value)
    return self._data

  @AdvertisementMsg.setter
  def AdvertisementMsg(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AdvertisementMsg', value, Anki.Cozmo.AdvertisementMsg)
    self._tag = self.Tag.AdvertisementMsg

  @property
  def Ping(self):
    "Anki.Cozmo.ExternalInterface.Ping Ping union property."
    msgbuffers.safety_check_tag('Ping', self._tag, self.Tag.Ping, self._tags_by_value)
    return self._data

  @Ping.setter
  def Ping(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.Ping', value, Anki.Cozmo.ExternalInterface.Ping)
    self._tag = self.Tag.Ping

  @property
  def DenyGameStart(self):
    "Anki.Cozmo.ExternalInterface.DenyGameStart DenyGameStart union property."
    msgbuffers.safety_check_tag('DenyGameStart', self._tag, self.Tag.DenyGameStart, self._tags_by_value)
    return self._data

  @DenyGameStart.setter
  def DenyGameStart(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.DenyGameStart', value, Anki.Cozmo.ExternalInterface.DenyGameStart)
    self._tag = self.Tag.DenyGameStart

  @property
  def ObjectDiscovered(self):
    "Anki.Cozmo.ObjectDiscovered ObjectDiscovered union property."
    msgbuffers.safety_check_tag('ObjectDiscovered', self._tag, self.Tag.ObjectDiscovered, self._tags_by_value)
    return self._data

  @ObjectDiscovered.setter
  def ObjectDiscovered(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectDiscovered', value, Anki.Cozmo.ObjectDiscovered)
    self._tag = self.Tag.ObjectDiscovered

  @property
  def ObjectConnectionState(self):
    "Anki.Cozmo.ObjectConnectionState ObjectConnectionState union property."
    msgbuffers.safety_check_tag('ObjectConnectionState', self._tag, self.Tag.ObjectConnectionState, self._tags_by_value)
    return self._data

  @ObjectConnectionState.setter
  def ObjectConnectionState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectConnectionState', value, Anki.Cozmo.ObjectConnectionState)
    self._tag = self.Tag.ObjectConnectionState

  @property
  def ObjectConnectionStateToRobot(self):
    "Anki.Cozmo.ObjectConnectionStateToRobot ObjectConnectionStateToRobot union property."
    msgbuffers.safety_check_tag('ObjectConnectionStateToRobot', self._tag, self.Tag.ObjectConnectionStateToRobot, self._tags_by_value)
    return self._data

  @ObjectConnectionStateToRobot.setter
  def ObjectConnectionStateToRobot(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectConnectionStateToRobot', value, Anki.Cozmo.ObjectConnectionStateToRobot)
    self._tag = self.Tag.ObjectConnectionStateToRobot

  @property
  def ObjectMoved(self):
    "Anki.Cozmo.ObjectMoved ObjectMoved union property."
    msgbuffers.safety_check_tag('ObjectMoved', self._tag, self.Tag.ObjectMoved, self._tags_by_value)
    return self._data

  @ObjectMoved.setter
  def ObjectMoved(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectMoved', value, Anki.Cozmo.ObjectMoved)
    self._tag = self.Tag.ObjectMoved

  @property
  def ObjectStoppedMoving(self):
    "Anki.Cozmo.ObjectStoppedMoving ObjectStoppedMoving union property."
    msgbuffers.safety_check_tag('ObjectStoppedMoving', self._tag, self.Tag.ObjectStoppedMoving, self._tags_by_value)
    return self._data

  @ObjectStoppedMoving.setter
  def ObjectStoppedMoving(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectStoppedMoving', value, Anki.Cozmo.ObjectStoppedMoving)
    self._tag = self.Tag.ObjectStoppedMoving

  @property
  def ObjectUpAxisChanged(self):
    "Anki.Cozmo.ObjectUpAxisChanged ObjectUpAxisChanged union property."
    msgbuffers.safety_check_tag('ObjectUpAxisChanged', self._tag, self.Tag.ObjectUpAxisChanged, self._tags_by_value)
    return self._data

  @ObjectUpAxisChanged.setter
  def ObjectUpAxisChanged(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectUpAxisChanged', value, Anki.Cozmo.ObjectUpAxisChanged)
    self._tag = self.Tag.ObjectUpAxisChanged

  @property
  def ObjectTapped(self):
    "Anki.Cozmo.ObjectTapped ObjectTapped union property."
    msgbuffers.safety_check_tag('ObjectTapped', self._tag, self.Tag.ObjectTapped, self._tags_by_value)
    return self._data

  @ObjectTapped.setter
  def ObjectTapped(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectTapped', value, Anki.Cozmo.ObjectTapped)
    self._tag = self.Tag.ObjectTapped

  @property
  def ObjectPowerLevel(self):
    "Anki.Cozmo.ObjectPowerLevel ObjectPowerLevel union property."
    msgbuffers.safety_check_tag('ObjectPowerLevel', self._tag, self.Tag.ObjectPowerLevel, self._tags_by_value)
    return self._data

  @ObjectPowerLevel.setter
  def ObjectPowerLevel(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectPowerLevel', value, Anki.Cozmo.ObjectPowerLevel)
    self._tag = self.Tag.ObjectPowerLevel

  @property
  def FactoryTestResultEntry(self):
    "Anki.Cozmo.FactoryTestResultEntry FactoryTestResultEntry union property."
    msgbuffers.safety_check_tag('FactoryTestResultEntry', self._tag, self.Tag.FactoryTestResultEntry, self._tags_by_value)
    return self._data

  @FactoryTestResultEntry.setter
  def FactoryTestResultEntry(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.FactoryTestResultEntry', value, Anki.Cozmo.FactoryTestResultEntry)
    self._tag = self.Tag.FactoryTestResultEntry

  @property
  def ImageChunk(self):
    "Anki.Cozmo.ImageChunk ImageChunk union property."
    msgbuffers.safety_check_tag('ImageChunk', self._tag, self.Tag.ImageChunk, self._tags_by_value)
    return self._data

  @ImageChunk.setter
  def ImageChunk(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ImageChunk', value, Anki.Cozmo.ImageChunk)
    self._tag = self.Tag.ImageChunk

  @property
  def ImageImuData(self):
    "Anki.Cozmo.ImageImuData ImageImuData union property."
    msgbuffers.safety_check_tag('ImageImuData', self._tag, self.Tag.ImageImuData, self._tags_by_value)
    return self._data

  @ImageImuData.setter
  def ImageImuData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ImageImuData', value, Anki.Cozmo.ImageImuData)
    self._tag = self.Tag.ImageImuData

  @property
  def CameraCalibration(self):
    "Anki.Cozmo.CameraCalibration CameraCalibration union property."
    msgbuffers.safety_check_tag('CameraCalibration', self._tag, self.Tag.CameraCalibration, self._tags_by_value)
    return self._data

  @CameraCalibration.setter
  def CameraCalibration(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.CameraCalibration', value, Anki.Cozmo.CameraCalibration)
    self._tag = self.Tag.CameraCalibration

  @property
  def IMURequest(self):
    "Anki.Cozmo.IMURequest IMURequest union property."
    msgbuffers.safety_check_tag('IMURequest', self._tag, self.Tag.IMURequest, self._tags_by_value)
    return self._data

  @IMURequest.setter
  def IMURequest(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.IMURequest', value, Anki.Cozmo.IMURequest)
    self._tag = self.Tag.IMURequest

  @property
  def LoadedKnownFace(self):
    "Anki.Vision.LoadedKnownFace LoadedKnownFace union property."
    msgbuffers.safety_check_tag('LoadedKnownFace', self._tag, self.Tag.LoadedKnownFace, self._tags_by_value)
    return self._data

  @LoadedKnownFace.setter
  def LoadedKnownFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.LoadedKnownFace', value, Anki.Vision.LoadedKnownFace)
    self._tag = self.Tag.LoadedKnownFace

  @property
  def RobotRenamedEnrolledFace(self):
    "Anki.Vision.RobotRenamedEnrolledFace RobotRenamedEnrolledFace union property."
    msgbuffers.safety_check_tag('RobotRenamedEnrolledFace', self._tag, self.Tag.RobotRenamedEnrolledFace, self._tags_by_value)
    return self._data

  @RobotRenamedEnrolledFace.setter
  def RobotRenamedEnrolledFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotRenamedEnrolledFace', value, Anki.Vision.RobotRenamedEnrolledFace)
    self._tag = self.Tag.RobotRenamedEnrolledFace

  @property
  def MotorCalibration(self):
    "Anki.Cozmo.MotorCalibration MotorCalibration union property."
    msgbuffers.safety_check_tag('MotorCalibration', self._tag, self.Tag.MotorCalibration, self._tags_by_value)
    return self._data

  @MotorCalibration.setter
  def MotorCalibration(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.MotorCalibration', value, Anki.Cozmo.MotorCalibration)
    self._tag = self.Tag.MotorCalibration

  @property
  def MotorAutoEnabled(self):
    "Anki.Cozmo.MotorAutoEnabled MotorAutoEnabled union property."
    msgbuffers.safety_check_tag('MotorAutoEnabled', self._tag, self.Tag.MotorAutoEnabled, self._tags_by_value)
    return self._data

  @MotorAutoEnabled.setter
  def MotorAutoEnabled(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.MotorAutoEnabled', value, Anki.Cozmo.MotorAutoEnabled)
    self._tag = self.Tag.MotorAutoEnabled

  @property
  def CliffEvent(self):
    "Anki.Cozmo.CliffEvent CliffEvent union property."
    msgbuffers.safety_check_tag('CliffEvent', self._tag, self.Tag.CliffEvent, self._tags_by_value)
    return self._data

  @CliffEvent.setter
  def CliffEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.CliffEvent', value, Anki.Cozmo.CliffEvent)
    self._tag = self.Tag.CliffEvent

  @property
  def PotentialCliff(self):
    "Anki.Cozmo.PotentialCliff PotentialCliff union property."
    msgbuffers.safety_check_tag('PotentialCliff', self._tag, self.Tag.PotentialCliff, self._tags_by_value)
    return self._data

  @PotentialCliff.setter
  def PotentialCliff(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.PotentialCliff', value, Anki.Cozmo.PotentialCliff)
    self._tag = self.Tag.PotentialCliff

  @property
  def ProxObstacle(self):
    "Anki.Cozmo.ProxObstacle ProxObstacle union property."
    msgbuffers.safety_check_tag('ProxObstacle', self._tag, self.Tag.ProxObstacle, self._tags_by_value)
    return self._data

  @ProxObstacle.setter
  def ProxObstacle(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ProxObstacle', value, Anki.Cozmo.ProxObstacle)
    self._tag = self.Tag.ProxObstacle

  @property
  def CarryStateUpdate(self):
    "Anki.Cozmo.CarryStateUpdate CarryStateUpdate union property."
    msgbuffers.safety_check_tag('CarryStateUpdate', self._tag, self.Tag.CarryStateUpdate, self._tags_by_value)
    return self._data

  @CarryStateUpdate.setter
  def CarryStateUpdate(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.CarryStateUpdate', value, Anki.Cozmo.CarryStateUpdate)
    self._tag = self.Tag.CarryStateUpdate

  @property
  def SetBodyRadioMode(self):
    "Anki.Cozmo.SetBodyRadioMode SetBodyRadioMode union property."
    msgbuffers.safety_check_tag('SetBodyRadioMode', self._tag, self.Tag.SetBodyRadioMode, self._tags_by_value)
    return self._data

  @SetBodyRadioMode.setter
  def SetBodyRadioMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.SetBodyRadioMode', value, Anki.Cozmo.SetBodyRadioMode)
    self._tag = self.Tag.SetBodyRadioMode

  @property
  def AnimationState(self):
    "Anki.Cozmo.RobotInterface.AnimationState AnimationState union property."
    msgbuffers.safety_check_tag('AnimationState', self._tag, self.Tag.AnimationState, self._tags_by_value)
    return self._data

  @AnimationState.setter
  def AnimationState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AnimationState', value, Anki.Cozmo.RobotInterface.AnimationState)
    self._tag = self.Tag.AnimationState

  @property
  def UiDeviceAvailable(self):
    "Anki.Cozmo.ExternalInterface.UiDeviceAvailable UiDeviceAvailable union property."
    msgbuffers.safety_check_tag('UiDeviceAvailable', self._tag, self.Tag.UiDeviceAvailable, self._tags_by_value)
    return self._data

  @UiDeviceAvailable.setter
  def UiDeviceAvailable(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UiDeviceAvailable', value, Anki.Cozmo.ExternalInterface.UiDeviceAvailable)
    self._tag = self.Tag.UiDeviceAvailable

  @property
  def RobotConnectionResponse(self):
    "Anki.Cozmo.ExternalInterface.RobotConnectionResponse RobotConnectionResponse union property."
    msgbuffers.safety_check_tag('RobotConnectionResponse', self._tag, self.Tag.RobotConnectionResponse, self._tags_by_value)
    return self._data

  @RobotConnectionResponse.setter
  def RobotConnectionResponse(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotConnectionResponse', value, Anki.Cozmo.ExternalInterface.RobotConnectionResponse)
    self._tag = self.Tag.RobotConnectionResponse

  @property
  def RobotDisconnected(self):
    "Anki.Cozmo.ExternalInterface.RobotDisconnected RobotDisconnected union property."
    msgbuffers.safety_check_tag('RobotDisconnected', self._tag, self.Tag.RobotDisconnected, self._tags_by_value)
    return self._data

  @RobotDisconnected.setter
  def RobotDisconnected(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDisconnected', value, Anki.Cozmo.ExternalInterface.RobotDisconnected)
    self._tag = self.Tag.RobotDisconnected

  @property
  def EngineRobotCLADVersionMismatch(self):
    "Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch EngineRobotCLADVersionMismatch union property."
    msgbuffers.safety_check_tag('EngineRobotCLADVersionMismatch', self._tag, self.Tag.EngineRobotCLADVersionMismatch, self._tags_by_value)
    return self._data

  @EngineRobotCLADVersionMismatch.setter
  def EngineRobotCLADVersionMismatch(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.EngineRobotCLADVersionMismatch', value, Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch)
    self._tag = self.Tag.EngineRobotCLADVersionMismatch

  @property
  def ObjectAvailable(self):
    "Anki.Cozmo.ExternalInterface.ObjectAvailable ObjectAvailable union property."
    msgbuffers.safety_check_tag('ObjectAvailable', self._tag, self.Tag.ObjectAvailable, self._tags_by_value)
    return self._data

  @ObjectAvailable.setter
  def ObjectAvailable(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectAvailable', value, Anki.Cozmo.ExternalInterface.ObjectAvailable)
    self._tag = self.Tag.ObjectAvailable

  @property
  def ObjectUnavailable(self):
    "Anki.Cozmo.ExternalInterface.ObjectUnavailable ObjectUnavailable union property."
    msgbuffers.safety_check_tag('ObjectUnavailable', self._tag, self.Tag.ObjectUnavailable, self._tags_by_value)
    return self._data

  @ObjectUnavailable.setter
  def ObjectUnavailable(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectUnavailable', value, Anki.Cozmo.ExternalInterface.ObjectUnavailable)
    self._tag = self.Tag.ObjectUnavailable

  @property
  def FeatureToggles(self):
    "Anki.Cozmo.ExternalInterface.FeatureToggles FeatureToggles union property."
    msgbuffers.safety_check_tag('FeatureToggles', self._tag, self.Tag.FeatureToggles, self._tags_by_value)
    return self._data

  @FeatureToggles.setter
  def FeatureToggles(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.FeatureToggles', value, Anki.Cozmo.ExternalInterface.FeatureToggles)
    self._tag = self.Tag.FeatureToggles

  @property
  def GoingToSleep(self):
    "Anki.Cozmo.ExternalInterface.GoingToSleep GoingToSleep union property."
    msgbuffers.safety_check_tag('GoingToSleep', self._tag, self.Tag.GoingToSleep, self._tags_by_value)
    return self._data

  @GoingToSleep.setter
  def GoingToSleep(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.GoingToSleep', value, Anki.Cozmo.ExternalInterface.GoingToSleep)
    self._tag = self.Tag.GoingToSleep

  @property
  def EngineLoadingDataStatus(self):
    "Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus EngineLoadingDataStatus union property."
    msgbuffers.safety_check_tag('EngineLoadingDataStatus', self._tag, self.Tag.EngineLoadingDataStatus, self._tags_by_value)
    return self._data

  @EngineLoadingDataStatus.setter
  def EngineLoadingDataStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.EngineLoadingDataStatus', value, Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus)
    self._tag = self.Tag.EngineLoadingDataStatus

  @property
  def RobotState(self):
    "Anki.Cozmo.ExternalInterface.RobotState RobotState union property."
    msgbuffers.safety_check_tag('RobotState', self._tag, self.Tag.RobotState, self._tags_by_value)
    return self._data

  @RobotState.setter
  def RobotState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotState', value, Anki.Cozmo.ExternalInterface.RobotState)
    self._tag = self.Tag.RobotState

  @property
  def RobotDelocalized(self):
    "Anki.Cozmo.ExternalInterface.RobotDelocalized RobotDelocalized union property."
    msgbuffers.safety_check_tag('RobotDelocalized', self._tag, self.Tag.RobotDelocalized, self._tags_by_value)
    return self._data

  @RobotDelocalized.setter
  def RobotDelocalized(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDelocalized', value, Anki.Cozmo.ExternalInterface.RobotDelocalized)
    self._tag = self.Tag.RobotDelocalized

  @property
  def RobotPoked(self):
    "Anki.Cozmo.ExternalInterface.RobotPoked RobotPoked union property."
    msgbuffers.safety_check_tag('RobotPoked', self._tag, self.Tag.RobotPoked, self._tags_by_value)
    return self._data

  @RobotPoked.setter
  def RobotPoked(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotPoked', value, Anki.Cozmo.ExternalInterface.RobotPoked)
    self._tag = self.Tag.RobotPoked

  @property
  def RobotStopped(self):
    "Anki.Cozmo.ExternalInterface.RobotStopped RobotStopped union property."
    msgbuffers.safety_check_tag('RobotStopped', self._tag, self.Tag.RobotStopped, self._tags_by_value)
    return self._data

  @RobotStopped.setter
  def RobotStopped(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotStopped', value, Anki.Cozmo.ExternalInterface.RobotStopped)
    self._tag = self.Tag.RobotStopped

  @property
  def RobotOffTreadsStateChanged(self):
    "Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged RobotOffTreadsStateChanged union property."
    msgbuffers.safety_check_tag('RobotOffTreadsStateChanged', self._tag, self.Tag.RobotOffTreadsStateChanged, self._tags_by_value)
    return self._data

  @RobotOffTreadsStateChanged.setter
  def RobotOffTreadsStateChanged(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotOffTreadsStateChanged', value, Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged)
    self._tag = self.Tag.RobotOffTreadsStateChanged

  @property
  def RobotCliffEventFinished(self):
    "Anki.Cozmo.ExternalInterface.RobotCliffEventFinished RobotCliffEventFinished union property."
    msgbuffers.safety_check_tag('RobotCliffEventFinished', self._tag, self.Tag.RobotCliffEventFinished, self._tags_by_value)
    return self._data

  @RobotCliffEventFinished.setter
  def RobotCliffEventFinished(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotCliffEventFinished', value, Anki.Cozmo.ExternalInterface.RobotCliffEventFinished)
    self._tag = self.Tag.RobotCliffEventFinished

  @property
  def RobotOnChargerPlatformEvent(self):
    "Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent RobotOnChargerPlatformEvent union property."
    msgbuffers.safety_check_tag('RobotOnChargerPlatformEvent', self._tag, self.Tag.RobotOnChargerPlatformEvent, self._tags_by_value)
    return self._data

  @RobotOnChargerPlatformEvent.setter
  def RobotOnChargerPlatformEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotOnChargerPlatformEvent', value, Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent)
    self._tag = self.Tag.RobotOnChargerPlatformEvent

  @property
  def ChargerEvent(self):
    "Anki.Cozmo.ExternalInterface.ChargerEvent ChargerEvent union property."
    msgbuffers.safety_check_tag('ChargerEvent', self._tag, self.Tag.ChargerEvent, self._tags_by_value)
    return self._data

  @ChargerEvent.setter
  def ChargerEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ChargerEvent', value, Anki.Cozmo.ExternalInterface.ChargerEvent)
    self._tag = self.Tag.ChargerEvent

  @property
  def UnexpectedMovement(self):
    "Anki.Cozmo.ExternalInterface.UnexpectedMovement UnexpectedMovement union property."
    msgbuffers.safety_check_tag('UnexpectedMovement', self._tag, self.Tag.UnexpectedMovement, self._tags_by_value)
    return self._data

  @UnexpectedMovement.setter
  def UnexpectedMovement(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UnexpectedMovement', value, Anki.Cozmo.ExternalInterface.UnexpectedMovement)
    self._tag = self.Tag.UnexpectedMovement

  @property
  def RestoreRobotStatus(self):
    "Anki.Cozmo.ExternalInterface.RestoreRobotStatus RestoreRobotStatus union property."
    msgbuffers.safety_check_tag('RestoreRobotStatus', self._tag, self.Tag.RestoreRobotStatus, self._tags_by_value)
    return self._data

  @RestoreRobotStatus.setter
  def RestoreRobotStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RestoreRobotStatus', value, Anki.Cozmo.ExternalInterface.RestoreRobotStatus)
    self._tag = self.Tag.RestoreRobotStatus

  @property
  def RestoreRobotOptions(self):
    "Anki.Cozmo.ExternalInterface.RestoreRobotOptions RestoreRobotOptions union property."
    msgbuffers.safety_check_tag('RestoreRobotOptions', self._tag, self.Tag.RestoreRobotOptions, self._tags_by_value)
    return self._data

  @RestoreRobotOptions.setter
  def RestoreRobotOptions(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RestoreRobotOptions', value, Anki.Cozmo.ExternalInterface.RestoreRobotOptions)
    self._tag = self.Tag.RestoreRobotOptions

  @property
  def DebugString(self):
    "Anki.Cozmo.ExternalInterface.DebugString DebugString union property."
    msgbuffers.safety_check_tag('DebugString', self._tag, self.Tag.DebugString, self._tags_by_value)
    return self._data

  @DebugString.setter
  def DebugString(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.DebugString', value, Anki.Cozmo.ExternalInterface.DebugString)
    self._tag = self.Tag.DebugString

  @property
  def DebugAnimationString(self):
    "Anki.Cozmo.ExternalInterface.DebugAnimationString DebugAnimationString union property."
    msgbuffers.safety_check_tag('DebugAnimationString', self._tag, self.Tag.DebugAnimationString, self._tags_by_value)
    return self._data

  @DebugAnimationString.setter
  def DebugAnimationString(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.DebugAnimationString', value, Anki.Cozmo.ExternalInterface.DebugAnimationString)
    self._tag = self.Tag.DebugAnimationString

  @property
  def RobotProcessedImage(self):
    "Anki.Cozmo.ExternalInterface.RobotProcessedImage RobotProcessedImage union property."
    msgbuffers.safety_check_tag('RobotProcessedImage', self._tag, self.Tag.RobotProcessedImage, self._tags_by_value)
    return self._data

  @RobotProcessedImage.setter
  def RobotProcessedImage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotProcessedImage', value, Anki.Cozmo.ExternalInterface.RobotProcessedImage)
    self._tag = self.Tag.RobotProcessedImage

  @property
  def RobotObservedObject(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedObject RobotObservedObject union property."
    msgbuffers.safety_check_tag('RobotObservedObject', self._tag, self.Tag.RobotObservedObject, self._tags_by_value)
    return self._data

  @RobotObservedObject.setter
  def RobotObservedObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotObservedObject', value, Anki.Cozmo.ExternalInterface.RobotObservedObject)
    self._tag = self.Tag.RobotObservedObject

  @property
  def RobotObservedPossibleObject(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject RobotObservedPossibleObject union property."
    msgbuffers.safety_check_tag('RobotObservedPossibleObject', self._tag, self.Tag.RobotObservedPossibleObject, self._tags_by_value)
    return self._data

  @RobotObservedPossibleObject.setter
  def RobotObservedPossibleObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotObservedPossibleObject', value, Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject)
    self._tag = self.Tag.RobotObservedPossibleObject

  @property
  def ObjectProjectsIntoFOV(self):
    "Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV ObjectProjectsIntoFOV union property."
    msgbuffers.safety_check_tag('ObjectProjectsIntoFOV', self._tag, self.Tag.ObjectProjectsIntoFOV, self._tags_by_value)
    return self._data

  @ObjectProjectsIntoFOV.setter
  def ObjectProjectsIntoFOV(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ObjectProjectsIntoFOV', value, Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV)
    self._tag = self.Tag.ObjectProjectsIntoFOV

  @property
  def RobotObservedFace(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedFace RobotObservedFace union property."
    msgbuffers.safety_check_tag('RobotObservedFace', self._tag, self.Tag.RobotObservedFace, self._tags_by_value)
    return self._data

  @RobotObservedFace.setter
  def RobotObservedFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotObservedFace', value, Anki.Cozmo.ExternalInterface.RobotObservedFace)
    self._tag = self.Tag.RobotObservedFace

  @property
  def RobotChangedObservedFaceID(self):
    "Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID RobotChangedObservedFaceID union property."
    msgbuffers.safety_check_tag('RobotChangedObservedFaceID', self._tag, self.Tag.RobotChangedObservedFaceID, self._tags_by_value)
    return self._data

  @RobotChangedObservedFaceID.setter
  def RobotChangedObservedFaceID(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotChangedObservedFaceID', value, Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID)
    self._tag = self.Tag.RobotChangedObservedFaceID

  @property
  def RobotObservedPet(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedPet RobotObservedPet union property."
    msgbuffers.safety_check_tag('RobotObservedPet', self._tag, self.Tag.RobotObservedPet, self._tags_by_value)
    return self._data

  @RobotObservedPet.setter
  def RobotObservedPet(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotObservedPet', value, Anki.Cozmo.ExternalInterface.RobotObservedPet)
    self._tag = self.Tag.RobotObservedPet

  @property
  def RobotObservedMotion(self):
    "Anki.Cozmo.ExternalInterface.RobotObservedMotion RobotObservedMotion union property."
    msgbuffers.safety_check_tag('RobotObservedMotion', self._tag, self.Tag.RobotObservedMotion, self._tags_by_value)
    return self._data

  @RobotObservedMotion.setter
  def RobotObservedMotion(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotObservedMotion', value, Anki.Cozmo.ExternalInterface.RobotObservedMotion)
    self._tag = self.Tag.RobotObservedMotion

  @property
  def RobotDeletedFace(self):
    "Anki.Cozmo.ExternalInterface.RobotDeletedFace RobotDeletedFace union property."
    msgbuffers.safety_check_tag('RobotDeletedFace', self._tag, self.Tag.RobotDeletedFace, self._tags_by_value)
    return self._data

  @RobotDeletedFace.setter
  def RobotDeletedFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDeletedFace', value, Anki.Cozmo.ExternalInterface.RobotDeletedFace)
    self._tag = self.Tag.RobotDeletedFace

  @property
  def RobotDeletedObject(self):
    "Anki.Cozmo.ExternalInterface.RobotDeletedObject RobotDeletedObject union property."
    msgbuffers.safety_check_tag('RobotDeletedObject', self._tag, self.Tag.RobotDeletedObject, self._tags_by_value)
    return self._data

  @RobotDeletedObject.setter
  def RobotDeletedObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDeletedObject', value, Anki.Cozmo.ExternalInterface.RobotDeletedObject)
    self._tag = self.Tag.RobotDeletedObject

  @property
  def RobotDeletedAllObjects(self):
    "Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects RobotDeletedAllObjects union property."
    msgbuffers.safety_check_tag('RobotDeletedAllObjects', self._tag, self.Tag.RobotDeletedAllObjects, self._tags_by_value)
    return self._data

  @RobotDeletedAllObjects.setter
  def RobotDeletedAllObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDeletedAllObjects', value, Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects)
    self._tag = self.Tag.RobotDeletedAllObjects

  @property
  def RobotDeletedAllCustomObjects(self):
    "Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects RobotDeletedAllCustomObjects union property."
    msgbuffers.safety_check_tag('RobotDeletedAllCustomObjects', self._tag, self.Tag.RobotDeletedAllCustomObjects, self._tags_by_value)
    return self._data

  @RobotDeletedAllCustomObjects.setter
  def RobotDeletedAllCustomObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotDeletedAllCustomObjects', value, Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects)
    self._tag = self.Tag.RobotDeletedAllCustomObjects

  @property
  def CreatedFixedCustomObject(self):
    "Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject CreatedFixedCustomObject union property."
    msgbuffers.safety_check_tag('CreatedFixedCustomObject', self._tag, self.Tag.CreatedFixedCustomObject, self._tags_by_value)
    return self._data

  @CreatedFixedCustomObject.setter
  def CreatedFixedCustomObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.CreatedFixedCustomObject', value, Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject)
    self._tag = self.Tag.CreatedFixedCustomObject

  @property
  def DefinedCustomObject(self):
    "Anki.Cozmo.ExternalInterface.DefinedCustomObject DefinedCustomObject union property."
    msgbuffers.safety_check_tag('DefinedCustomObject', self._tag, self.Tag.DefinedCustomObject, self._tags_by_value)
    return self._data

  @DefinedCustomObject.setter
  def DefinedCustomObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.DefinedCustomObject', value, Anki.Cozmo.ExternalInterface.DefinedCustomObject)
    self._tag = self.Tag.DefinedCustomObject

  @property
  def RobotMarkedObjectPoseUnknown(self):
    "Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown RobotMarkedObjectPoseUnknown union property."
    msgbuffers.safety_check_tag('RobotMarkedObjectPoseUnknown', self._tag, self.Tag.RobotMarkedObjectPoseUnknown, self._tags_by_value)
    return self._data

  @RobotMarkedObjectPoseUnknown.setter
  def RobotMarkedObjectPoseUnknown(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotMarkedObjectPoseUnknown', value, Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown)
    self._tag = self.Tag.RobotMarkedObjectPoseUnknown

  @property
  def AvailableObjects(self):
    "Anki.Cozmo.ExternalInterface.AvailableObjects AvailableObjects union property."
    msgbuffers.safety_check_tag('AvailableObjects', self._tag, self.Tag.AvailableObjects, self._tags_by_value)
    return self._data

  @AvailableObjects.setter
  def AvailableObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AvailableObjects', value, Anki.Cozmo.ExternalInterface.AvailableObjects)
    self._tag = self.Tag.AvailableObjects

  @property
  def RobotReadToolCode(self):
    "Anki.Cozmo.ExternalInterface.RobotReadToolCode RobotReadToolCode union property."
    msgbuffers.safety_check_tag('RobotReadToolCode', self._tag, self.Tag.RobotReadToolCode, self._tags_by_value)
    return self._data

  @RobotReadToolCode.setter
  def RobotReadToolCode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotReadToolCode', value, Anki.Cozmo.ExternalInterface.RobotReadToolCode)
    self._tag = self.Tag.RobotReadToolCode

  @property
  def RobotReachedEnrollmentCount(self):
    "Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount RobotReachedEnrollmentCount union property."
    msgbuffers.safety_check_tag('RobotReachedEnrollmentCount', self._tag, self.Tag.RobotReachedEnrollmentCount, self._tags_by_value)
    return self._data

  @RobotReachedEnrollmentCount.setter
  def RobotReachedEnrollmentCount(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotReachedEnrollmentCount', value, Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount)
    self._tag = self.Tag.RobotReachedEnrollmentCount

  @property
  def RobotErasedEnrolledFace(self):
    "Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace RobotErasedEnrolledFace union property."
    msgbuffers.safety_check_tag('RobotErasedEnrolledFace', self._tag, self.Tag.RobotErasedEnrolledFace, self._tags_by_value)
    return self._data

  @RobotErasedEnrolledFace.setter
  def RobotErasedEnrolledFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotErasedEnrolledFace', value, Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace)
    self._tag = self.Tag.RobotErasedEnrolledFace

  @property
  def RobotErasedAllEnrolledFaces(self):
    "Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces RobotErasedAllEnrolledFaces union property."
    msgbuffers.safety_check_tag('RobotErasedAllEnrolledFaces', self._tag, self.Tag.RobotErasedAllEnrolledFaces, self._tags_by_value)
    return self._data

  @RobotErasedAllEnrolledFaces.setter
  def RobotErasedAllEnrolledFaces(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotErasedAllEnrolledFaces', value, Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces)
    self._tag = self.Tag.RobotErasedAllEnrolledFaces

  @property
  def RobotCompletedFactoryDotTest(self):
    "Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest RobotCompletedFactoryDotTest union property."
    msgbuffers.safety_check_tag('RobotCompletedFactoryDotTest', self._tag, self.Tag.RobotCompletedFactoryDotTest, self._tags_by_value)
    return self._data

  @RobotCompletedFactoryDotTest.setter
  def RobotCompletedFactoryDotTest(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotCompletedFactoryDotTest', value, Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest)
    self._tag = self.Tag.RobotCompletedFactoryDotTest

  @property
  def RobotCompletedAction(self):
    "Anki.Cozmo.ExternalInterface.RobotCompletedAction RobotCompletedAction union property."
    msgbuffers.safety_check_tag('RobotCompletedAction', self._tag, self.Tag.RobotCompletedAction, self._tags_by_value)
    return self._data

  @RobotCompletedAction.setter
  def RobotCompletedAction(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RobotCompletedAction', value, Anki.Cozmo.ExternalInterface.RobotCompletedAction)
    self._tag = self.Tag.RobotCompletedAction

  @property
  def BlockPickedUp(self):
    "Anki.Cozmo.ExternalInterface.BlockPickedUp BlockPickedUp union property."
    msgbuffers.safety_check_tag('BlockPickedUp', self._tag, self.Tag.BlockPickedUp, self._tags_by_value)
    return self._data

  @BlockPickedUp.setter
  def BlockPickedUp(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BlockPickedUp', value, Anki.Cozmo.ExternalInterface.BlockPickedUp)
    self._tag = self.Tag.BlockPickedUp

  @property
  def BlockPlaced(self):
    "Anki.Cozmo.ExternalInterface.BlockPlaced BlockPlaced union property."
    msgbuffers.safety_check_tag('BlockPlaced', self._tag, self.Tag.BlockPlaced, self._tags_by_value)
    return self._data

  @BlockPlaced.setter
  def BlockPlaced(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BlockPlaced', value, Anki.Cozmo.ExternalInterface.BlockPlaced)
    self._tag = self.Tag.BlockPlaced

  @property
  def AnimationAvailable(self):
    "Anki.Cozmo.ExternalInterface.AnimationAvailable AnimationAvailable union property."
    msgbuffers.safety_check_tag('AnimationAvailable', self._tag, self.Tag.AnimationAvailable, self._tags_by_value)
    return self._data

  @AnimationAvailable.setter
  def AnimationAvailable(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AnimationAvailable', value, Anki.Cozmo.ExternalInterface.AnimationAvailable)
    self._tag = self.Tag.AnimationAvailable

  @property
  def AnimationGroupAvailable(self):
    "Anki.Cozmo.ExternalInterface.AnimationGroupAvailable AnimationGroupAvailable union property."
    msgbuffers.safety_check_tag('AnimationGroupAvailable', self._tag, self.Tag.AnimationGroupAvailable, self._tags_by_value)
    return self._data

  @AnimationGroupAvailable.setter
  def AnimationGroupAvailable(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AnimationGroupAvailable', value, Anki.Cozmo.ExternalInterface.AnimationGroupAvailable)
    self._tag = self.Tag.AnimationGroupAvailable

  @property
  def AnimationAborted(self):
    "Anki.Cozmo.ExternalInterface.AnimationAborted AnimationAborted union property."
    msgbuffers.safety_check_tag('AnimationAborted', self._tag, self.Tag.AnimationAborted, self._tags_by_value)
    return self._data

  @AnimationAborted.setter
  def AnimationAborted(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AnimationAborted', value, Anki.Cozmo.ExternalInterface.AnimationAborted)
    self._tag = self.Tag.AnimationAborted

  @property
  def AnimationEvent(self):
    "Anki.Cozmo.ExternalInterface.AnimationEvent AnimationEvent union property."
    msgbuffers.safety_check_tag('AnimationEvent', self._tag, self.Tag.AnimationEvent, self._tags_by_value)
    return self._data

  @AnimationEvent.setter
  def AnimationEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.AnimationEvent', value, Anki.Cozmo.ExternalInterface.AnimationEvent)
    self._tag = self.Tag.AnimationEvent

  @property
  def MoodState(self):
    "Anki.Cozmo.ExternalInterface.MoodState MoodState union property."
    msgbuffers.safety_check_tag('MoodState', self._tag, self.Tag.MoodState, self._tags_by_value)
    return self._data

  @MoodState.setter
  def MoodState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.MoodState', value, Anki.Cozmo.ExternalInterface.MoodState)
    self._tag = self.Tag.MoodState

  @property
  def RequestSetUnlockResult(self):
    "Anki.Cozmo.ExternalInterface.RequestSetUnlockResult RequestSetUnlockResult union property."
    msgbuffers.safety_check_tag('RequestSetUnlockResult', self._tag, self.Tag.RequestSetUnlockResult, self._tags_by_value)
    return self._data

  @RequestSetUnlockResult.setter
  def RequestSetUnlockResult(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RequestSetUnlockResult', value, Anki.Cozmo.ExternalInterface.RequestSetUnlockResult)
    self._tag = self.Tag.RequestSetUnlockResult

  @property
  def UnlockStatus(self):
    "Anki.Cozmo.ExternalInterface.UnlockStatus UnlockStatus union property."
    msgbuffers.safety_check_tag('UnlockStatus', self._tag, self.Tag.UnlockStatus, self._tags_by_value)
    return self._data

  @UnlockStatus.setter
  def UnlockStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UnlockStatus', value, Anki.Cozmo.ExternalInterface.UnlockStatus)
    self._tag = self.Tag.UnlockStatus

  @property
  def UnlockedDefaults(self):
    "Anki.Cozmo.ExternalInterface.UnlockedDefaults UnlockedDefaults union property."
    msgbuffers.safety_check_tag('UnlockedDefaults', self._tag, self.Tag.UnlockedDefaults, self._tags_by_value)
    return self._data

  @UnlockedDefaults.setter
  def UnlockedDefaults(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UnlockedDefaults', value, Anki.Cozmo.ExternalInterface.UnlockedDefaults)
    self._tag = self.Tag.UnlockedDefaults

  @property
  def InitDebugConsoleVarMessage(self):
    "Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage InitDebugConsoleVarMessage union property."
    msgbuffers.safety_check_tag('InitDebugConsoleVarMessage', self._tag, self.Tag.InitDebugConsoleVarMessage, self._tags_by_value)
    return self._data

  @InitDebugConsoleVarMessage.setter
  def InitDebugConsoleVarMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.InitDebugConsoleVarMessage', value, Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage)
    self._tag = self.Tag.InitDebugConsoleVarMessage

  @property
  def JsonDasLogMessage(self):
    "Anki.Cozmo.ExternalInterface.JsonDasLogMessage JsonDasLogMessage union property."
    msgbuffers.safety_check_tag('JsonDasLogMessage', self._tag, self.Tag.JsonDasLogMessage, self._tags_by_value)
    return self._data

  @JsonDasLogMessage.setter
  def JsonDasLogMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.JsonDasLogMessage', value, Anki.Cozmo.ExternalInterface.JsonDasLogMessage)
    self._tag = self.Tag.JsonDasLogMessage

  @property
  def JsonDasLogAllSentMessage(self):
    "Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage JsonDasLogAllSentMessage union property."
    msgbuffers.safety_check_tag('JsonDasLogAllSentMessage', self._tag, self.Tag.JsonDasLogAllSentMessage, self._tags_by_value)
    return self._data

  @JsonDasLogAllSentMessage.setter
  def JsonDasLogAllSentMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.JsonDasLogAllSentMessage', value, Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage)
    self._tag = self.Tag.JsonDasLogAllSentMessage

  @property
  def VerifyDebugConsoleFuncMessage(self):
    "Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage VerifyDebugConsoleFuncMessage union property."
    msgbuffers.safety_check_tag('VerifyDebugConsoleFuncMessage', self._tag, self.Tag.VerifyDebugConsoleFuncMessage, self._tags_by_value)
    return self._data

  @VerifyDebugConsoleFuncMessage.setter
  def VerifyDebugConsoleFuncMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.VerifyDebugConsoleFuncMessage', value, Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage)
    self._tag = self.Tag.VerifyDebugConsoleFuncMessage

  @property
  def VerifyDebugConsoleVarMessage(self):
    "Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage VerifyDebugConsoleVarMessage union property."
    msgbuffers.safety_check_tag('VerifyDebugConsoleVarMessage', self._tag, self.Tag.VerifyDebugConsoleVarMessage, self._tags_by_value)
    return self._data

  @VerifyDebugConsoleVarMessage.setter
  def VerifyDebugConsoleVarMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.VerifyDebugConsoleVarMessage', value, Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage)
    self._tag = self.Tag.VerifyDebugConsoleVarMessage

  @property
  def LatencyMessage(self):
    "Anki.Cozmo.ExternalInterface.LatencyMessage LatencyMessage union property."
    msgbuffers.safety_check_tag('LatencyMessage', self._tag, self.Tag.LatencyMessage, self._tags_by_value)
    return self._data

  @LatencyMessage.setter
  def LatencyMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.LatencyMessage', value, Anki.Cozmo.ExternalInterface.LatencyMessage)
    self._tag = self.Tag.LatencyMessage

  @property
  def DeviceDataMessage(self):
    "Anki.Cozmo.ExternalInterface.DeviceDataMessage DeviceDataMessage union property."
    msgbuffers.safety_check_tag('DeviceDataMessage', self._tag, self.Tag.DeviceDataMessage, self._tags_by_value)
    return self._data

  @DeviceDataMessage.setter
  def DeviceDataMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.DeviceDataMessage', value, Anki.Cozmo.ExternalInterface.DeviceDataMessage)
    self._tag = self.Tag.DeviceDataMessage

  @property
  def BlockTapFilterStatus(self):
    "Anki.Cozmo.ExternalInterface.BlockTapFilterStatus BlockTapFilterStatus union property."
    msgbuffers.safety_check_tag('BlockTapFilterStatus', self._tag, self.Tag.BlockTapFilterStatus, self._tags_by_value)
    return self._data

  @BlockTapFilterStatus.setter
  def BlockTapFilterStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BlockTapFilterStatus', value, Anki.Cozmo.ExternalInterface.BlockTapFilterStatus)
    self._tag = self.Tag.BlockTapFilterStatus

  @property
  def UpdateEngineState(self):
    "Anki.Cozmo.ExternalInterface.UpdateEngineState UpdateEngineState union property."
    msgbuffers.safety_check_tag('UpdateEngineState', self._tag, self.Tag.UpdateEngineState, self._tags_by_value)
    return self._data

  @UpdateEngineState.setter
  def UpdateEngineState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.UpdateEngineState', value, Anki.Cozmo.ExternalInterface.UpdateEngineState)
    self._tag = self.Tag.UpdateEngineState

  @property
  def EngineErrorCodeMessage(self):
    "Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage EngineErrorCodeMessage union property."
    msgbuffers.safety_check_tag('EngineErrorCodeMessage', self._tag, self.Tag.EngineErrorCodeMessage, self._tags_by_value)
    return self._data

  @EngineErrorCodeMessage.setter
  def EngineErrorCodeMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.EngineErrorCodeMessage', value, Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage)
    self._tag = self.Tag.EngineErrorCodeMessage

  @property
  def CubeLightsStateTransition(self):
    "Anki.Cozmo.ExternalInterface.CubeLightsStateTransition CubeLightsStateTransition union property."
    msgbuffers.safety_check_tag('CubeLightsStateTransition', self._tag, self.Tag.CubeLightsStateTransition, self._tags_by_value)
    return self._data

  @CubeLightsStateTransition.setter
  def CubeLightsStateTransition(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.CubeLightsStateTransition', value, Anki.Cozmo.ExternalInterface.CubeLightsStateTransition)
    self._tag = self.Tag.CubeLightsStateTransition

  @property
  def BlockPoolDataMessage(self):
    "Anki.Cozmo.ExternalInterface.BlockPoolDataMessage BlockPoolDataMessage union property."
    msgbuffers.safety_check_tag('BlockPoolDataMessage', self._tag, self.Tag.BlockPoolDataMessage, self._tags_by_value)
    return self._data

  @BlockPoolDataMessage.setter
  def BlockPoolDataMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BlockPoolDataMessage', value, Anki.Cozmo.ExternalInterface.BlockPoolDataMessage)
    self._tag = self.Tag.BlockPoolDataMessage

  @property
  def NVStorageOpResult(self):
    "Anki.Cozmo.ExternalInterface.NVStorageOpResult NVStorageOpResult union property."
    msgbuffers.safety_check_tag('NVStorageOpResult', self._tag, self.Tag.NVStorageOpResult, self._tags_by_value)
    return self._data

  @NVStorageOpResult.setter
  def NVStorageOpResult(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.NVStorageOpResult', value, Anki.Cozmo.ExternalInterface.NVStorageOpResult)
    self._tag = self.Tag.NVStorageOpResult

  @property
  def FirmwareUpdateProgress(self):
    "Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress FirmwareUpdateProgress union property."
    msgbuffers.safety_check_tag('FirmwareUpdateProgress', self._tag, self.Tag.FirmwareUpdateProgress, self._tags_by_value)
    return self._data

  @FirmwareUpdateProgress.setter
  def FirmwareUpdateProgress(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.FirmwareUpdateProgress', value, Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress)
    self._tag = self.Tag.FirmwareUpdateProgress

  @property
  def FirmwareUpdateComplete(self):
    "Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete FirmwareUpdateComplete union property."
    msgbuffers.safety_check_tag('FirmwareUpdateComplete', self._tag, self.Tag.FirmwareUpdateComplete, self._tags_by_value)
    return self._data

  @FirmwareUpdateComplete.setter
  def FirmwareUpdateComplete(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.FirmwareUpdateComplete', value, Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete)
    self._tag = self.Tag.FirmwareUpdateComplete

  @property
  def RequestGameStart(self):
    "Anki.Cozmo.ExternalInterface.RequestGameStart RequestGameStart union property."
    msgbuffers.safety_check_tag('RequestGameStart', self._tag, self.Tag.RequestGameStart, self._tags_by_value)
    return self._data

  @RequestGameStart.setter
  def RequestGameStart(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RequestGameStart', value, Anki.Cozmo.ExternalInterface.RequestGameStart)
    self._tag = self.Tag.RequestGameStart

  @property
  def RequestEnrollFace(self):
    "Anki.Cozmo.ExternalInterface.RequestEnrollFace RequestEnrollFace union property."
    msgbuffers.safety_check_tag('RequestEnrollFace', self._tag, self.Tag.RequestEnrollFace, self._tags_by_value)
    return self._data

  @RequestEnrollFace.setter
  def RequestEnrollFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RequestEnrollFace', value, Anki.Cozmo.ExternalInterface.RequestEnrollFace)
    self._tag = self.Tag.RequestEnrollFace

  @property
  def SparkEnded(self):
    "Anki.Cozmo.ExternalInterface.SparkEnded SparkEnded union property."
    msgbuffers.safety_check_tag('SparkEnded', self._tag, self.Tag.SparkEnded, self._tags_by_value)
    return self._data

  @SparkEnded.setter
  def SparkEnded(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.SparkEnded', value, Anki.Cozmo.ExternalInterface.SparkEnded)
    self._tag = self.Tag.SparkEnded

  @property
  def SdkConnectionStatus(self):
    "Anki.Cozmo.ExternalInterface.SdkConnectionStatus SdkConnectionStatus union property."
    msgbuffers.safety_check_tag('SdkConnectionStatus', self._tag, self.Tag.SdkConnectionStatus, self._tags_by_value)
    return self._data

  @SdkConnectionStatus.setter
  def SdkConnectionStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.SdkConnectionStatus', value, Anki.Cozmo.ExternalInterface.SdkConnectionStatus)
    self._tag = self.Tag.SdkConnectionStatus

  @property
  def SdkStatus(self):
    "Anki.Cozmo.ExternalInterface.SdkStatus SdkStatus union property."
    msgbuffers.safety_check_tag('SdkStatus', self._tag, self.Tag.SdkStatus, self._tags_by_value)
    return self._data

  @SdkStatus.setter
  def SdkStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.SdkStatus', value, Anki.Cozmo.ExternalInterface.SdkStatus)
    self._tag = self.Tag.SdkStatus

  @property
  def BehaviorTransition(self):
    "Anki.Cozmo.ExternalInterface.BehaviorTransition BehaviorTransition union property."
    msgbuffers.safety_check_tag('BehaviorTransition', self._tag, self.Tag.BehaviorTransition, self._tags_by_value)
    return self._data

  @BehaviorTransition.setter
  def BehaviorTransition(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BehaviorTransition', value, Anki.Cozmo.ExternalInterface.BehaviorTransition)
    self._tag = self.Tag.BehaviorTransition

  @property
  def RespondEnabledBehaviorList(self):
    "Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList RespondEnabledBehaviorList union property."
    msgbuffers.safety_check_tag('RespondEnabledBehaviorList', self._tag, self.Tag.RespondEnabledBehaviorList, self._tags_by_value)
    return self._data

  @RespondEnabledBehaviorList.setter
  def RespondEnabledBehaviorList(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.RespondEnabledBehaviorList', value, Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList)
    self._tag = self.Tag.RespondEnabledBehaviorList

  @property
  def ReactionaryBehaviorTransition(self):
    "Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition ReactionaryBehaviorTransition union property."
    msgbuffers.safety_check_tag('ReactionaryBehaviorTransition', self._tag, self.Tag.ReactionaryBehaviorTransition, self._tags_by_value)
    return self._data

  @ReactionaryBehaviorTransition.setter
  def ReactionaryBehaviorTransition(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.ReactionaryBehaviorTransition', value, Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition)
    self._tag = self.Tag.ReactionaryBehaviorTransition

  @property
  def BehaviorObjectiveAchieved(self):
    "Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved BehaviorObjectiveAchieved union property."
    msgbuffers.safety_check_tag('BehaviorObjectiveAchieved', self._tag, self.Tag.BehaviorObjectiveAchieved, self._tags_by_value)
    return self._data

  @BehaviorObjectiveAchieved.setter
  def BehaviorObjectiveAchieved(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.BehaviorObjectiveAchieved', value, Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved)
    self._tag = self.Tag.BehaviorObjectiveAchieved

  @property
  def OnboardingState(self):
    "Anki.Cozmo.ExternalInterface.OnboardingState OnboardingState union property."
    msgbuffers.safety_check_tag('OnboardingState', self._tag, self.Tag.OnboardingState, self._tags_by_value)
    return self._data

  @OnboardingState.setter
  def OnboardingState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.OnboardingState', value, Anki.Cozmo.ExternalInterface.OnboardingState)
    self._tag = self.Tag.OnboardingState

  @property
  def SupportInfo(self):
    "Anki.Cozmo.ExternalInterface.SupportInfo SupportInfo union property."
    msgbuffers.safety_check_tag('SupportInfo', self._tag, self.Tag.SupportInfo, self._tags_by_value)
    return self._data

  @SupportInfo.setter
  def SupportInfo(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.SupportInfo', value, Anki.Cozmo.ExternalInterface.SupportInfo)
    self._tag = self.Tag.SupportInfo

  @property
  def EndOfMessage(self):
    "Anki.Cozmo.ExternalInterface.EndOfMessage EndOfMessage union property."
    msgbuffers.safety_check_tag('EndOfMessage', self._tag, self.Tag.EndOfMessage, self._tags_by_value)
    return self._data

  @EndOfMessage.setter
  def EndOfMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageEngineToGame.EndOfMessage', value, Anki.Cozmo.ExternalInterface.EndOfMessage)
    self._tag = self.Tag.EndOfMessage

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MessageEngineToGame from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MessageEngineToGame.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MessageEngineToGame from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MessageEngineToGame attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MessageEngineToGame, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MessageEngineToGame.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 110:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 110:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 110:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    UiDeviceConnected=0,
    AudioCallback=1,
    AdvertisementRegistrationMsg=2,
    AdvertisementMsg=3,
    Ping=4,
    DenyGameStart=5,
    ObjectDiscovered=6,
    ObjectConnectionState=7,
    ObjectConnectionStateToRobot=8,
    ObjectMoved=9,
    ObjectStoppedMoving=10,
    ObjectUpAxisChanged=11,
    ObjectTapped=12,
    ObjectPowerLevel=13,
    FactoryTestResultEntry=14,
    ImageChunk=15,
    ImageImuData=16,
    CameraCalibration=17,
    IMURequest=18,
    LoadedKnownFace=19,
    RobotRenamedEnrolledFace=20,
    MotorCalibration=21,
    MotorAutoEnabled=22,
    CliffEvent=23,
    PotentialCliff=24,
    ProxObstacle=25,
    CarryStateUpdate=26,
    SetBodyRadioMode=27,
    AnimationState=28,
    UiDeviceAvailable=29,
    RobotConnectionResponse=30,
    RobotDisconnected=31,
    EngineRobotCLADVersionMismatch=32,
    ObjectAvailable=33,
    ObjectUnavailable=34,
    FeatureToggles=35,
    GoingToSleep=36,
    EngineLoadingDataStatus=37,
    RobotState=38,
    RobotDelocalized=39,
    RobotPoked=40,
    RobotStopped=41,
    RobotOffTreadsStateChanged=42,
    RobotCliffEventFinished=43,
    RobotOnChargerPlatformEvent=44,
    ChargerEvent=45,
    UnexpectedMovement=46,
    RestoreRobotStatus=47,
    RestoreRobotOptions=48,
    DebugString=49,
    DebugAnimationString=50,
    RobotProcessedImage=51,
    RobotObservedObject=52,
    RobotObservedPossibleObject=53,
    ObjectProjectsIntoFOV=54,
    RobotObservedFace=55,
    RobotChangedObservedFaceID=56,
    RobotObservedPet=57,
    RobotObservedMotion=58,
    RobotDeletedFace=59,
    RobotDeletedObject=60,
    RobotDeletedAllObjects=61,
    RobotDeletedAllCustomObjects=62,
    CreatedFixedCustomObject=63,
    DefinedCustomObject=64,
    RobotMarkedObjectPoseUnknown=65,
    AvailableObjects=66,
    RobotReadToolCode=67,
    RobotReachedEnrollmentCount=68,
    RobotErasedEnrolledFace=69,
    RobotErasedAllEnrolledFaces=70,
    RobotCompletedFactoryDotTest=71,
    RobotCompletedAction=72,
    BlockPickedUp=73,
    BlockPlaced=74,
    AnimationAvailable=75,
    AnimationGroupAvailable=76,
    AnimationAborted=77,
    AnimationEvent=78,
    MoodState=79,
    RequestSetUnlockResult=80,
    UnlockStatus=81,
    UnlockedDefaults=82,
    InitDebugConsoleVarMessage=83,
    JsonDasLogMessage=84,
    JsonDasLogAllSentMessage=85,
    VerifyDebugConsoleFuncMessage=86,
    VerifyDebugConsoleVarMessage=87,
    LatencyMessage=88,
    DeviceDataMessage=89,
    BlockTapFilterStatus=90,
    UpdateEngineState=91,
    EngineErrorCodeMessage=92,
    CubeLightsStateTransition=93,
    BlockPoolDataMessage=94,
    NVStorageOpResult=95,
    FirmwareUpdateProgress=96,
    FirmwareUpdateComplete=97,
    RequestGameStart=98,
    RequestEnrollFace=99,
    SparkEnded=100,
    SdkConnectionStatus=101,
    SdkStatus=102,
    BehaviorTransition=103,
    RespondEnabledBehaviorList=104,
    ReactionaryBehaviorTransition=105,
    BehaviorObjectiveAchieved=106,
    OnboardingState=107,
    SupportInfo=108,
    EndOfMessage=109,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'UiDeviceConnected'
  _tags_by_value[1] = 'AudioCallback'
  _tags_by_value[2] = 'AdvertisementRegistrationMsg'
  _tags_by_value[3] = 'AdvertisementMsg'
  _tags_by_value[4] = 'Ping'
  _tags_by_value[5] = 'DenyGameStart'
  _tags_by_value[6] = 'ObjectDiscovered'
  _tags_by_value[7] = 'ObjectConnectionState'
  _tags_by_value[8] = 'ObjectConnectionStateToRobot'
  _tags_by_value[9] = 'ObjectMoved'
  _tags_by_value[10] = 'ObjectStoppedMoving'
  _tags_by_value[11] = 'ObjectUpAxisChanged'
  _tags_by_value[12] = 'ObjectTapped'
  _tags_by_value[13] = 'ObjectPowerLevel'
  _tags_by_value[14] = 'FactoryTestResultEntry'
  _tags_by_value[15] = 'ImageChunk'
  _tags_by_value[16] = 'ImageImuData'
  _tags_by_value[17] = 'CameraCalibration'
  _tags_by_value[18] = 'IMURequest'
  _tags_by_value[19] = 'LoadedKnownFace'
  _tags_by_value[20] = 'RobotRenamedEnrolledFace'
  _tags_by_value[21] = 'MotorCalibration'
  _tags_by_value[22] = 'MotorAutoEnabled'
  _tags_by_value[23] = 'CliffEvent'
  _tags_by_value[24] = 'PotentialCliff'
  _tags_by_value[25] = 'ProxObstacle'
  _tags_by_value[26] = 'CarryStateUpdate'
  _tags_by_value[27] = 'SetBodyRadioMode'
  _tags_by_value[28] = 'AnimationState'
  _tags_by_value[29] = 'UiDeviceAvailable'
  _tags_by_value[30] = 'RobotConnectionResponse'
  _tags_by_value[31] = 'RobotDisconnected'
  _tags_by_value[32] = 'EngineRobotCLADVersionMismatch'
  _tags_by_value[33] = 'ObjectAvailable'
  _tags_by_value[34] = 'ObjectUnavailable'
  _tags_by_value[35] = 'FeatureToggles'
  _tags_by_value[36] = 'GoingToSleep'
  _tags_by_value[37] = 'EngineLoadingDataStatus'
  _tags_by_value[38] = 'RobotState'
  _tags_by_value[39] = 'RobotDelocalized'
  _tags_by_value[40] = 'RobotPoked'
  _tags_by_value[41] = 'RobotStopped'
  _tags_by_value[42] = 'RobotOffTreadsStateChanged'
  _tags_by_value[43] = 'RobotCliffEventFinished'
  _tags_by_value[44] = 'RobotOnChargerPlatformEvent'
  _tags_by_value[45] = 'ChargerEvent'
  _tags_by_value[46] = 'UnexpectedMovement'
  _tags_by_value[47] = 'RestoreRobotStatus'
  _tags_by_value[48] = 'RestoreRobotOptions'
  _tags_by_value[49] = 'DebugString'
  _tags_by_value[50] = 'DebugAnimationString'
  _tags_by_value[51] = 'RobotProcessedImage'
  _tags_by_value[52] = 'RobotObservedObject'
  _tags_by_value[53] = 'RobotObservedPossibleObject'
  _tags_by_value[54] = 'ObjectProjectsIntoFOV'
  _tags_by_value[55] = 'RobotObservedFace'
  _tags_by_value[56] = 'RobotChangedObservedFaceID'
  _tags_by_value[57] = 'RobotObservedPet'
  _tags_by_value[58] = 'RobotObservedMotion'
  _tags_by_value[59] = 'RobotDeletedFace'
  _tags_by_value[60] = 'RobotDeletedObject'
  _tags_by_value[61] = 'RobotDeletedAllObjects'
  _tags_by_value[62] = 'RobotDeletedAllCustomObjects'
  _tags_by_value[63] = 'CreatedFixedCustomObject'
  _tags_by_value[64] = 'DefinedCustomObject'
  _tags_by_value[65] = 'RobotMarkedObjectPoseUnknown'
  _tags_by_value[66] = 'AvailableObjects'
  _tags_by_value[67] = 'RobotReadToolCode'
  _tags_by_value[68] = 'RobotReachedEnrollmentCount'
  _tags_by_value[69] = 'RobotErasedEnrolledFace'
  _tags_by_value[70] = 'RobotErasedAllEnrolledFaces'
  _tags_by_value[71] = 'RobotCompletedFactoryDotTest'
  _tags_by_value[72] = 'RobotCompletedAction'
  _tags_by_value[73] = 'BlockPickedUp'
  _tags_by_value[74] = 'BlockPlaced'
  _tags_by_value[75] = 'AnimationAvailable'
  _tags_by_value[76] = 'AnimationGroupAvailable'
  _tags_by_value[77] = 'AnimationAborted'
  _tags_by_value[78] = 'AnimationEvent'
  _tags_by_value[79] = 'MoodState'
  _tags_by_value[80] = 'RequestSetUnlockResult'
  _tags_by_value[81] = 'UnlockStatus'
  _tags_by_value[82] = 'UnlockedDefaults'
  _tags_by_value[83] = 'InitDebugConsoleVarMessage'
  _tags_by_value[84] = 'JsonDasLogMessage'
  _tags_by_value[85] = 'JsonDasLogAllSentMessage'
  _tags_by_value[86] = 'VerifyDebugConsoleFuncMessage'
  _tags_by_value[87] = 'VerifyDebugConsoleVarMessage'
  _tags_by_value[88] = 'LatencyMessage'
  _tags_by_value[89] = 'DeviceDataMessage'
  _tags_by_value[90] = 'BlockTapFilterStatus'
  _tags_by_value[91] = 'UpdateEngineState'
  _tags_by_value[92] = 'EngineErrorCodeMessage'
  _tags_by_value[93] = 'CubeLightsStateTransition'
  _tags_by_value[94] = 'BlockPoolDataMessage'
  _tags_by_value[95] = 'NVStorageOpResult'
  _tags_by_value[96] = 'FirmwareUpdateProgress'
  _tags_by_value[97] = 'FirmwareUpdateComplete'
  _tags_by_value[98] = 'RequestGameStart'
  _tags_by_value[99] = 'RequestEnrollFace'
  _tags_by_value[100] = 'SparkEnded'
  _tags_by_value[101] = 'SdkConnectionStatus'
  _tags_by_value[102] = 'SdkStatus'
  _tags_by_value[103] = 'BehaviorTransition'
  _tags_by_value[104] = 'RespondEnabledBehaviorList'
  _tags_by_value[105] = 'ReactionaryBehaviorTransition'
  _tags_by_value[106] = 'BehaviorObjectiveAchieved'
  _tags_by_value[107] = 'OnboardingState'
  _tags_by_value[108] = 'SupportInfo'
  _tags_by_value[109] = 'EndOfMessage'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UiDeviceConnected.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.Audio.AudioCallback.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.AdvertisementRegistrationMsg.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.AdvertisementMsg.unpack_from)
  _tag_unpack_methods[4] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.Ping.unpack_from)
  _tag_unpack_methods[5] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DenyGameStart.unpack_from)
  _tag_unpack_methods[6] = lambda reader: reader.read_object(Anki.Cozmo.ObjectDiscovered.unpack_from)
  _tag_unpack_methods[7] = lambda reader: reader.read_object(Anki.Cozmo.ObjectConnectionState.unpack_from)
  _tag_unpack_methods[8] = lambda reader: reader.read_object(Anki.Cozmo.ObjectConnectionStateToRobot.unpack_from)
  _tag_unpack_methods[9] = lambda reader: reader.read_object(Anki.Cozmo.ObjectMoved.unpack_from)
  _tag_unpack_methods[10] = lambda reader: reader.read_object(Anki.Cozmo.ObjectStoppedMoving.unpack_from)
  _tag_unpack_methods[11] = lambda reader: reader.read_object(Anki.Cozmo.ObjectUpAxisChanged.unpack_from)
  _tag_unpack_methods[12] = lambda reader: reader.read_object(Anki.Cozmo.ObjectTapped.unpack_from)
  _tag_unpack_methods[13] = lambda reader: reader.read_object(Anki.Cozmo.ObjectPowerLevel.unpack_from)
  _tag_unpack_methods[14] = lambda reader: reader.read_object(Anki.Cozmo.FactoryTestResultEntry.unpack_from)
  _tag_unpack_methods[15] = lambda reader: reader.read_object(Anki.Cozmo.ImageChunk.unpack_from)
  _tag_unpack_methods[16] = lambda reader: reader.read_object(Anki.Cozmo.ImageImuData.unpack_from)
  _tag_unpack_methods[17] = lambda reader: reader.read_object(Anki.Cozmo.CameraCalibration.unpack_from)
  _tag_unpack_methods[18] = lambda reader: reader.read_object(Anki.Cozmo.IMURequest.unpack_from)
  _tag_unpack_methods[19] = lambda reader: reader.read_object(Anki.Vision.LoadedKnownFace.unpack_from)
  _tag_unpack_methods[20] = lambda reader: reader.read_object(Anki.Vision.RobotRenamedEnrolledFace.unpack_from)
  _tag_unpack_methods[21] = lambda reader: reader.read_object(Anki.Cozmo.MotorCalibration.unpack_from)
  _tag_unpack_methods[22] = lambda reader: reader.read_object(Anki.Cozmo.MotorAutoEnabled.unpack_from)
  _tag_unpack_methods[23] = lambda reader: reader.read_object(Anki.Cozmo.CliffEvent.unpack_from)
  _tag_unpack_methods[24] = lambda reader: reader.read_object(Anki.Cozmo.PotentialCliff.unpack_from)
  _tag_unpack_methods[25] = lambda reader: reader.read_object(Anki.Cozmo.ProxObstacle.unpack_from)
  _tag_unpack_methods[26] = lambda reader: reader.read_object(Anki.Cozmo.CarryStateUpdate.unpack_from)
  _tag_unpack_methods[27] = lambda reader: reader.read_object(Anki.Cozmo.SetBodyRadioMode.unpack_from)
  _tag_unpack_methods[28] = lambda reader: reader.read_object(Anki.Cozmo.RobotInterface.AnimationState.unpack_from)
  _tag_unpack_methods[29] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UiDeviceAvailable.unpack_from)
  _tag_unpack_methods[30] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotConnectionResponse.unpack_from)
  _tag_unpack_methods[31] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDisconnected.unpack_from)
  _tag_unpack_methods[32] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch.unpack_from)
  _tag_unpack_methods[33] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ObjectAvailable.unpack_from)
  _tag_unpack_methods[34] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ObjectUnavailable.unpack_from)
  _tag_unpack_methods[35] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FeatureToggles.unpack_from)
  _tag_unpack_methods[36] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GoingToSleep.unpack_from)
  _tag_unpack_methods[37] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus.unpack_from)
  _tag_unpack_methods[38] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotState.unpack_from)
  _tag_unpack_methods[39] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDelocalized.unpack_from)
  _tag_unpack_methods[40] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotPoked.unpack_from)
  _tag_unpack_methods[41] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotStopped.unpack_from)
  _tag_unpack_methods[42] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged.unpack_from)
  _tag_unpack_methods[43] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotCliffEventFinished.unpack_from)
  _tag_unpack_methods[44] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent.unpack_from)
  _tag_unpack_methods[45] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ChargerEvent.unpack_from)
  _tag_unpack_methods[46] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UnexpectedMovement.unpack_from)
  _tag_unpack_methods[47] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RestoreRobotStatus.unpack_from)
  _tag_unpack_methods[48] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RestoreRobotOptions.unpack_from)
  _tag_unpack_methods[49] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DebugString.unpack_from)
  _tag_unpack_methods[50] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DebugAnimationString.unpack_from)
  _tag_unpack_methods[51] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotProcessedImage.unpack_from)
  _tag_unpack_methods[52] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedObject.unpack_from)
  _tag_unpack_methods[53] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject.unpack_from)
  _tag_unpack_methods[54] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV.unpack_from)
  _tag_unpack_methods[55] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedFace.unpack_from)
  _tag_unpack_methods[56] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID.unpack_from)
  _tag_unpack_methods[57] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedPet.unpack_from)
  _tag_unpack_methods[58] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotObservedMotion.unpack_from)
  _tag_unpack_methods[59] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDeletedFace.unpack_from)
  _tag_unpack_methods[60] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDeletedObject.unpack_from)
  _tag_unpack_methods[61] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects.unpack_from)
  _tag_unpack_methods[62] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects.unpack_from)
  _tag_unpack_methods[63] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject.unpack_from)
  _tag_unpack_methods[64] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DefinedCustomObject.unpack_from)
  _tag_unpack_methods[65] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown.unpack_from)
  _tag_unpack_methods[66] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AvailableObjects.unpack_from)
  _tag_unpack_methods[67] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotReadToolCode.unpack_from)
  _tag_unpack_methods[68] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount.unpack_from)
  _tag_unpack_methods[69] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace.unpack_from)
  _tag_unpack_methods[70] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces.unpack_from)
  _tag_unpack_methods[71] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest.unpack_from)
  _tag_unpack_methods[72] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RobotCompletedAction.unpack_from)
  _tag_unpack_methods[73] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockPickedUp.unpack_from)
  _tag_unpack_methods[74] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockPlaced.unpack_from)
  _tag_unpack_methods[75] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AnimationAvailable.unpack_from)
  _tag_unpack_methods[76] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AnimationGroupAvailable.unpack_from)
  _tag_unpack_methods[77] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AnimationAborted.unpack_from)
  _tag_unpack_methods[78] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AnimationEvent.unpack_from)
  _tag_unpack_methods[79] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MoodState.unpack_from)
  _tag_unpack_methods[80] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestSetUnlockResult.unpack_from)
  _tag_unpack_methods[81] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UnlockStatus.unpack_from)
  _tag_unpack_methods[82] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UnlockedDefaults.unpack_from)
  _tag_unpack_methods[83] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage.unpack_from)
  _tag_unpack_methods[84] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.JsonDasLogMessage.unpack_from)
  _tag_unpack_methods[85] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage.unpack_from)
  _tag_unpack_methods[86] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage.unpack_from)
  _tag_unpack_methods[87] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage.unpack_from)
  _tag_unpack_methods[88] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.LatencyMessage.unpack_from)
  _tag_unpack_methods[89] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DeviceDataMessage.unpack_from)
  _tag_unpack_methods[90] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockTapFilterStatus.unpack_from)
  _tag_unpack_methods[91] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UpdateEngineState.unpack_from)
  _tag_unpack_methods[92] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage.unpack_from)
  _tag_unpack_methods[93] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CubeLightsStateTransition.unpack_from)
  _tag_unpack_methods[94] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockPoolDataMessage.unpack_from)
  _tag_unpack_methods[95] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageOpResult.unpack_from)
  _tag_unpack_methods[96] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress.unpack_from)
  _tag_unpack_methods[97] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete.unpack_from)
  _tag_unpack_methods[98] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestGameStart.unpack_from)
  _tag_unpack_methods[99] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestEnrollFace.unpack_from)
  _tag_unpack_methods[100] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SparkEnded.unpack_from)
  _tag_unpack_methods[101] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SdkConnectionStatus.unpack_from)
  _tag_unpack_methods[102] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SdkStatus.unpack_from)
  _tag_unpack_methods[103] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BehaviorTransition.unpack_from)
  _tag_unpack_methods[104] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList.unpack_from)
  _tag_unpack_methods[105] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition.unpack_from)
  _tag_unpack_methods[106] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved.unpack_from)
  _tag_unpack_methods[107] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.OnboardingState.unpack_from)
  _tag_unpack_methods[108] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SupportInfo.unpack_from)
  _tag_unpack_methods[109] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EndOfMessage.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[4] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[5] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[6] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[7] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[8] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[9] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[10] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[11] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[12] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[13] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[14] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[15] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[16] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[17] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[18] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[19] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[20] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[21] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[22] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[23] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[24] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[25] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[26] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[27] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[28] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[29] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[30] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[31] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[32] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[33] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[34] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[35] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[36] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[37] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[38] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[39] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[40] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[41] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[42] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[43] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[44] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[45] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[46] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[47] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[48] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[49] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[50] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[51] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[52] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[53] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[54] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[55] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[56] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[57] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[58] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[59] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[60] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[61] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[62] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[63] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[64] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[65] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[66] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[67] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[68] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[69] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[70] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[71] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[72] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[73] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[74] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[75] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[76] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[77] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[78] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[79] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[80] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[81] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[82] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[83] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[84] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[85] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[86] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[87] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[88] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[89] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[90] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[91] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[92] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[93] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[94] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[95] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[96] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[97] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[98] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[99] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[100] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[101] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[102] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[103] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[104] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[105] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[106] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[107] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[108] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[109] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[4] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[5] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[6] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[7] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[8] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[9] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[10] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[11] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[12] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[13] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[14] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[15] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[16] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[17] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[18] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[19] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[20] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[21] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[22] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[23] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[24] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[25] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[26] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[27] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[28] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[29] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[30] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[31] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[32] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[33] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[34] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[35] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[36] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[37] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[38] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[39] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[40] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[41] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[42] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[43] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[44] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[45] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[46] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[47] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[48] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[49] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[50] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[51] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[52] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[53] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[54] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[55] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[56] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[57] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[58] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[59] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[60] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[61] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[62] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[63] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[64] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[65] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[66] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[67] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[68] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[69] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[70] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[71] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[72] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[73] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[74] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[75] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[76] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[77] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[78] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[79] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[80] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[81] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[82] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[83] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[84] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[85] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[86] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[87] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[88] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[89] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[90] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[91] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[92] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[93] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[94] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[95] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[96] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[97] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[98] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[99] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[100] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[101] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[102] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[103] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[104] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[105] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[106] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[107] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[108] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[109] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.ExternalInterface.UiDeviceConnected
  _type_by_tag_value[1] = lambda : Anki.Cozmo.Audio.AudioCallback
  _type_by_tag_value[2] = lambda : Anki.Cozmo.AdvertisementRegistrationMsg
  _type_by_tag_value[3] = lambda : Anki.Cozmo.AdvertisementMsg
  _type_by_tag_value[4] = lambda : Anki.Cozmo.ExternalInterface.Ping
  _type_by_tag_value[5] = lambda : Anki.Cozmo.ExternalInterface.DenyGameStart
  _type_by_tag_value[6] = lambda : Anki.Cozmo.ObjectDiscovered
  _type_by_tag_value[7] = lambda : Anki.Cozmo.ObjectConnectionState
  _type_by_tag_value[8] = lambda : Anki.Cozmo.ObjectConnectionStateToRobot
  _type_by_tag_value[9] = lambda : Anki.Cozmo.ObjectMoved
  _type_by_tag_value[10] = lambda : Anki.Cozmo.ObjectStoppedMoving
  _type_by_tag_value[11] = lambda : Anki.Cozmo.ObjectUpAxisChanged
  _type_by_tag_value[12] = lambda : Anki.Cozmo.ObjectTapped
  _type_by_tag_value[13] = lambda : Anki.Cozmo.ObjectPowerLevel
  _type_by_tag_value[14] = lambda : Anki.Cozmo.FactoryTestResultEntry
  _type_by_tag_value[15] = lambda : Anki.Cozmo.ImageChunk
  _type_by_tag_value[16] = lambda : Anki.Cozmo.ImageImuData
  _type_by_tag_value[17] = lambda : Anki.Cozmo.CameraCalibration
  _type_by_tag_value[18] = lambda : Anki.Cozmo.IMURequest
  _type_by_tag_value[19] = lambda : Anki.Vision.LoadedKnownFace
  _type_by_tag_value[20] = lambda : Anki.Vision.RobotRenamedEnrolledFace
  _type_by_tag_value[21] = lambda : Anki.Cozmo.MotorCalibration
  _type_by_tag_value[22] = lambda : Anki.Cozmo.MotorAutoEnabled
  _type_by_tag_value[23] = lambda : Anki.Cozmo.CliffEvent
  _type_by_tag_value[24] = lambda : Anki.Cozmo.PotentialCliff
  _type_by_tag_value[25] = lambda : Anki.Cozmo.ProxObstacle
  _type_by_tag_value[26] = lambda : Anki.Cozmo.CarryStateUpdate
  _type_by_tag_value[27] = lambda : Anki.Cozmo.SetBodyRadioMode
  _type_by_tag_value[28] = lambda : Anki.Cozmo.RobotInterface.AnimationState
  _type_by_tag_value[29] = lambda : Anki.Cozmo.ExternalInterface.UiDeviceAvailable
  _type_by_tag_value[30] = lambda : Anki.Cozmo.ExternalInterface.RobotConnectionResponse
  _type_by_tag_value[31] = lambda : Anki.Cozmo.ExternalInterface.RobotDisconnected
  _type_by_tag_value[32] = lambda : Anki.Cozmo.ExternalInterface.EngineRobotCLADVersionMismatch
  _type_by_tag_value[33] = lambda : Anki.Cozmo.ExternalInterface.ObjectAvailable
  _type_by_tag_value[34] = lambda : Anki.Cozmo.ExternalInterface.ObjectUnavailable
  _type_by_tag_value[35] = lambda : Anki.Cozmo.ExternalInterface.FeatureToggles
  _type_by_tag_value[36] = lambda : Anki.Cozmo.ExternalInterface.GoingToSleep
  _type_by_tag_value[37] = lambda : Anki.Cozmo.ExternalInterface.EngineLoadingDataStatus
  _type_by_tag_value[38] = lambda : Anki.Cozmo.ExternalInterface.RobotState
  _type_by_tag_value[39] = lambda : Anki.Cozmo.ExternalInterface.RobotDelocalized
  _type_by_tag_value[40] = lambda : Anki.Cozmo.ExternalInterface.RobotPoked
  _type_by_tag_value[41] = lambda : Anki.Cozmo.ExternalInterface.RobotStopped
  _type_by_tag_value[42] = lambda : Anki.Cozmo.ExternalInterface.RobotOffTreadsStateChanged
  _type_by_tag_value[43] = lambda : Anki.Cozmo.ExternalInterface.RobotCliffEventFinished
  _type_by_tag_value[44] = lambda : Anki.Cozmo.ExternalInterface.RobotOnChargerPlatformEvent
  _type_by_tag_value[45] = lambda : Anki.Cozmo.ExternalInterface.ChargerEvent
  _type_by_tag_value[46] = lambda : Anki.Cozmo.ExternalInterface.UnexpectedMovement
  _type_by_tag_value[47] = lambda : Anki.Cozmo.ExternalInterface.RestoreRobotStatus
  _type_by_tag_value[48] = lambda : Anki.Cozmo.ExternalInterface.RestoreRobotOptions
  _type_by_tag_value[49] = lambda : Anki.Cozmo.ExternalInterface.DebugString
  _type_by_tag_value[50] = lambda : Anki.Cozmo.ExternalInterface.DebugAnimationString
  _type_by_tag_value[51] = lambda : Anki.Cozmo.ExternalInterface.RobotProcessedImage
  _type_by_tag_value[52] = lambda : Anki.Cozmo.ExternalInterface.RobotObservedObject
  _type_by_tag_value[53] = lambda : Anki.Cozmo.ExternalInterface.RobotObservedPossibleObject
  _type_by_tag_value[54] = lambda : Anki.Cozmo.ExternalInterface.ObjectProjectsIntoFOV
  _type_by_tag_value[55] = lambda : Anki.Cozmo.ExternalInterface.RobotObservedFace
  _type_by_tag_value[56] = lambda : Anki.Cozmo.ExternalInterface.RobotChangedObservedFaceID
  _type_by_tag_value[57] = lambda : Anki.Cozmo.ExternalInterface.RobotObservedPet
  _type_by_tag_value[58] = lambda : Anki.Cozmo.ExternalInterface.RobotObservedMotion
  _type_by_tag_value[59] = lambda : Anki.Cozmo.ExternalInterface.RobotDeletedFace
  _type_by_tag_value[60] = lambda : Anki.Cozmo.ExternalInterface.RobotDeletedObject
  _type_by_tag_value[61] = lambda : Anki.Cozmo.ExternalInterface.RobotDeletedAllObjects
  _type_by_tag_value[62] = lambda : Anki.Cozmo.ExternalInterface.RobotDeletedAllCustomObjects
  _type_by_tag_value[63] = lambda : Anki.Cozmo.ExternalInterface.CreatedFixedCustomObject
  _type_by_tag_value[64] = lambda : Anki.Cozmo.ExternalInterface.DefinedCustomObject
  _type_by_tag_value[65] = lambda : Anki.Cozmo.ExternalInterface.RobotMarkedObjectPoseUnknown
  _type_by_tag_value[66] = lambda : Anki.Cozmo.ExternalInterface.AvailableObjects
  _type_by_tag_value[67] = lambda : Anki.Cozmo.ExternalInterface.RobotReadToolCode
  _type_by_tag_value[68] = lambda : Anki.Cozmo.ExternalInterface.RobotReachedEnrollmentCount
  _type_by_tag_value[69] = lambda : Anki.Cozmo.ExternalInterface.RobotErasedEnrolledFace
  _type_by_tag_value[70] = lambda : Anki.Cozmo.ExternalInterface.RobotErasedAllEnrolledFaces
  _type_by_tag_value[71] = lambda : Anki.Cozmo.ExternalInterface.RobotCompletedFactoryDotTest
  _type_by_tag_value[72] = lambda : Anki.Cozmo.ExternalInterface.RobotCompletedAction
  _type_by_tag_value[73] = lambda : Anki.Cozmo.ExternalInterface.BlockPickedUp
  _type_by_tag_value[74] = lambda : Anki.Cozmo.ExternalInterface.BlockPlaced
  _type_by_tag_value[75] = lambda : Anki.Cozmo.ExternalInterface.AnimationAvailable
  _type_by_tag_value[76] = lambda : Anki.Cozmo.ExternalInterface.AnimationGroupAvailable
  _type_by_tag_value[77] = lambda : Anki.Cozmo.ExternalInterface.AnimationAborted
  _type_by_tag_value[78] = lambda : Anki.Cozmo.ExternalInterface.AnimationEvent
  _type_by_tag_value[79] = lambda : Anki.Cozmo.ExternalInterface.MoodState
  _type_by_tag_value[80] = lambda : Anki.Cozmo.ExternalInterface.RequestSetUnlockResult
  _type_by_tag_value[81] = lambda : Anki.Cozmo.ExternalInterface.UnlockStatus
  _type_by_tag_value[82] = lambda : Anki.Cozmo.ExternalInterface.UnlockedDefaults
  _type_by_tag_value[83] = lambda : Anki.Cozmo.ExternalInterface.InitDebugConsoleVarMessage
  _type_by_tag_value[84] = lambda : Anki.Cozmo.ExternalInterface.JsonDasLogMessage
  _type_by_tag_value[85] = lambda : Anki.Cozmo.ExternalInterface.JsonDasLogAllSentMessage
  _type_by_tag_value[86] = lambda : Anki.Cozmo.ExternalInterface.VerifyDebugConsoleFuncMessage
  _type_by_tag_value[87] = lambda : Anki.Cozmo.ExternalInterface.VerifyDebugConsoleVarMessage
  _type_by_tag_value[88] = lambda : Anki.Cozmo.ExternalInterface.LatencyMessage
  _type_by_tag_value[89] = lambda : Anki.Cozmo.ExternalInterface.DeviceDataMessage
  _type_by_tag_value[90] = lambda : Anki.Cozmo.ExternalInterface.BlockTapFilterStatus
  _type_by_tag_value[91] = lambda : Anki.Cozmo.ExternalInterface.UpdateEngineState
  _type_by_tag_value[92] = lambda : Anki.Cozmo.ExternalInterface.EngineErrorCodeMessage
  _type_by_tag_value[93] = lambda : Anki.Cozmo.ExternalInterface.CubeLightsStateTransition
  _type_by_tag_value[94] = lambda : Anki.Cozmo.ExternalInterface.BlockPoolDataMessage
  _type_by_tag_value[95] = lambda : Anki.Cozmo.ExternalInterface.NVStorageOpResult
  _type_by_tag_value[96] = lambda : Anki.Cozmo.ExternalInterface.FirmwareUpdateProgress
  _type_by_tag_value[97] = lambda : Anki.Cozmo.ExternalInterface.FirmwareUpdateComplete
  _type_by_tag_value[98] = lambda : Anki.Cozmo.ExternalInterface.RequestGameStart
  _type_by_tag_value[99] = lambda : Anki.Cozmo.ExternalInterface.RequestEnrollFace
  _type_by_tag_value[100] = lambda : Anki.Cozmo.ExternalInterface.SparkEnded
  _type_by_tag_value[101] = lambda : Anki.Cozmo.ExternalInterface.SdkConnectionStatus
  _type_by_tag_value[102] = lambda : Anki.Cozmo.ExternalInterface.SdkStatus
  _type_by_tag_value[103] = lambda : Anki.Cozmo.ExternalInterface.BehaviorTransition
  _type_by_tag_value[104] = lambda : Anki.Cozmo.ExternalInterface.RespondEnabledBehaviorList
  _type_by_tag_value[105] = lambda : Anki.Cozmo.ExternalInterface.ReactionaryBehaviorTransition
  _type_by_tag_value[106] = lambda : Anki.Cozmo.ExternalInterface.BehaviorObjectiveAchieved
  _type_by_tag_value[107] = lambda : Anki.Cozmo.ExternalInterface.OnboardingState
  _type_by_tag_value[108] = lambda : Anki.Cozmo.ExternalInterface.SupportInfo
  _type_by_tag_value[109] = lambda : Anki.Cozmo.ExternalInterface.EndOfMessage
  

Anki.Cozmo.ExternalInterface.MessageEngineToGame = MessageEngineToGame
del MessageEngineToGame


