# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/externalInterface/messageGameToEngine.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/externalInterface/messageGameToEngine.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameParameter = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameState = msgbuffers.Namespace()
Anki.Cozmo.Audio.SwitchState = msgbuffers.Namespace()
Anki.Cozmo.ExternalInterface = msgbuffers.Namespace()
Anki.Cozmo.NVStorage = msgbuffers.Namespace()
Anki.Cozmo.RobotInterface = msgbuffers.Namespace()
Anki.Vision = msgbuffers.Namespace()

from clad.audio.audioMessage import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.externalInterface.messageActions import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.externalInterface.messageShared import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.externalInterface.messageToBehaviorManager import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.activeObjectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.behaviorChooserType import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.behaviorGroup import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.controllerChannels import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.debugConsoleTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.emotionTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.faceEnrollmentPoses import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.featureGateTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.firmwareTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.globalVizOrigin import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.imageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.imu import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.liveIdleAnimationParameters import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.nvStorageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.objectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.poseStructs import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.proceduralEyeParameters import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.robotTestModes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.uiConnectionTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class UiDeviceConnectionWrongVersion(object):
  "Generated message-passing message."

  __slots__ = (
    '_reserved',       # uint_8
    '_connectionType', # Anki.Cozmo.UiConnectionType
    '_deviceID',       # uint_32
    '_buildVersion',   # string[uint_8]
  )

  @property
  def reserved(self):
    "uint_8 reserved struct property."
    return self._reserved

  @reserved.setter
  def reserved(self, value):
    self._reserved = msgbuffers.validate_integer(
      'UiDeviceConnectionWrongVersion.reserved', value, 0, 255)

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'UiDeviceConnectionWrongVersion.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_32 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'UiDeviceConnectionWrongVersion.deviceID', value, 0, 4294967295)

  @property
  def buildVersion(self):
    "string[uint_8] buildVersion struct property."
    return self._buildVersion

  @buildVersion.setter
  def buildVersion(self, value):
    self._buildVersion = msgbuffers.validate_string(
      'UiDeviceConnectionWrongVersion.buildVersion', value, 255)

  def __init__(self, reserved=0, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0, buildVersion=''):
    self.reserved = reserved
    self.connectionType = connectionType
    self.deviceID = deviceID
    self.buildVersion = buildVersion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UiDeviceConnectionWrongVersion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UiDeviceConnectionWrongVersion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UiDeviceConnectionWrongVersion from the given BinaryReader."
    _reserved = reader.read('B')
    _connectionType = reader.read('B')
    _deviceID = reader.read('I')
    _buildVersion = reader.read_string('B')
    return cls(_reserved, _connectionType, _deviceID, _buildVersion)

  def pack(self):
    "Writes the current UiDeviceConnectionWrongVersion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UiDeviceConnectionWrongVersion to the given BinaryWriter."
    writer.write(self._reserved, 'B')
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'I')
    writer.write_string(self._buildVersion, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._reserved == other._reserved and
        self._connectionType == other._connectionType and
        self._deviceID == other._deviceID and
        self._buildVersion == other._buildVersion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._reserved, 'B') +
      msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'I') +
      msgbuffers.size_string(self._buildVersion, 'B'))

  def __str__(self):
    return '{type}(reserved={reserved}, connectionType={connectionType}, deviceID={deviceID}, buildVersion={buildVersion})'.format(
      type=type(self).__name__,
      reserved=self._reserved,
      connectionType=self._connectionType,
      deviceID=self._deviceID,
      buildVersion=msgbuffers.shorten_string(self._buildVersion))

  def __repr__(self):
    return '{type}(reserved={reserved}, connectionType={connectionType}, deviceID={deviceID}, buildVersion={buildVersion})'.format(
      type=type(self).__name__,
      reserved=repr(self._reserved),
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID),
      buildVersion=repr(self._buildVersion))

Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion = UiDeviceConnectionWrongVersion
del UiDeviceConnectionWrongVersion


class UiDeviceConnectionSuccess(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectionType',       # Anki.Cozmo.UiConnectionType
    '_deviceID',             # uint_32
    '_buildVersion',         # string[uint_8]
    '_sdkModuleVersion',     # string[uint_8]
    '_pythonVersion',        # string[uint_8]
    '_pythonImplementation', # string[uint_8]
    '_osVersion',            # string[uint_8]
    '_cpuVersion',           # string[uint_8]
  )

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'UiDeviceConnectionSuccess.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_32 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'UiDeviceConnectionSuccess.deviceID', value, 0, 4294967295)

  @property
  def buildVersion(self):
    "string[uint_8] buildVersion struct property."
    return self._buildVersion

  @buildVersion.setter
  def buildVersion(self, value):
    self._buildVersion = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.buildVersion', value, 255)

  @property
  def sdkModuleVersion(self):
    "string[uint_8] sdkModuleVersion struct property."
    return self._sdkModuleVersion

  @sdkModuleVersion.setter
  def sdkModuleVersion(self, value):
    self._sdkModuleVersion = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.sdkModuleVersion', value, 255)

  @property
  def pythonVersion(self):
    "string[uint_8] pythonVersion struct property."
    return self._pythonVersion

  @pythonVersion.setter
  def pythonVersion(self, value):
    self._pythonVersion = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.pythonVersion', value, 255)

  @property
  def pythonImplementation(self):
    "string[uint_8] pythonImplementation struct property."
    return self._pythonImplementation

  @pythonImplementation.setter
  def pythonImplementation(self, value):
    self._pythonImplementation = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.pythonImplementation', value, 255)

  @property
  def osVersion(self):
    "string[uint_8] osVersion struct property."
    return self._osVersion

  @osVersion.setter
  def osVersion(self, value):
    self._osVersion = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.osVersion', value, 255)

  @property
  def cpuVersion(self):
    "string[uint_8] cpuVersion struct property."
    return self._cpuVersion

  @cpuVersion.setter
  def cpuVersion(self, value):
    self._cpuVersion = msgbuffers.validate_string(
      'UiDeviceConnectionSuccess.cpuVersion', value, 255)

  def __init__(self, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0, buildVersion='', sdkModuleVersion='', pythonVersion='', pythonImplementation='', osVersion='', cpuVersion=''):
    self.connectionType = connectionType
    self.deviceID = deviceID
    self.buildVersion = buildVersion
    self.sdkModuleVersion = sdkModuleVersion
    self.pythonVersion = pythonVersion
    self.pythonImplementation = pythonImplementation
    self.osVersion = osVersion
    self.cpuVersion = cpuVersion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UiDeviceConnectionSuccess from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UiDeviceConnectionSuccess.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UiDeviceConnectionSuccess from the given BinaryReader."
    _connectionType = reader.read('B')
    _deviceID = reader.read('I')
    _buildVersion = reader.read_string('B')
    _sdkModuleVersion = reader.read_string('B')
    _pythonVersion = reader.read_string('B')
    _pythonImplementation = reader.read_string('B')
    _osVersion = reader.read_string('B')
    _cpuVersion = reader.read_string('B')
    return cls(_connectionType, _deviceID, _buildVersion, _sdkModuleVersion, _pythonVersion, _pythonImplementation, _osVersion, _cpuVersion)

  def pack(self):
    "Writes the current UiDeviceConnectionSuccess, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UiDeviceConnectionSuccess to the given BinaryWriter."
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'I')
    writer.write_string(self._buildVersion, 'B')
    writer.write_string(self._sdkModuleVersion, 'B')
    writer.write_string(self._pythonVersion, 'B')
    writer.write_string(self._pythonImplementation, 'B')
    writer.write_string(self._osVersion, 'B')
    writer.write_string(self._cpuVersion, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._connectionType == other._connectionType and
        self._deviceID == other._deviceID and
        self._buildVersion == other._buildVersion and
        self._sdkModuleVersion == other._sdkModuleVersion and
        self._pythonVersion == other._pythonVersion and
        self._pythonImplementation == other._pythonImplementation and
        self._osVersion == other._osVersion and
        self._cpuVersion == other._cpuVersion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'I') +
      msgbuffers.size_string(self._buildVersion, 'B') +
      msgbuffers.size_string(self._sdkModuleVersion, 'B') +
      msgbuffers.size_string(self._pythonVersion, 'B') +
      msgbuffers.size_string(self._pythonImplementation, 'B') +
      msgbuffers.size_string(self._osVersion, 'B') +
      msgbuffers.size_string(self._cpuVersion, 'B'))

  def __str__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID}, buildVersion={buildVersion}, sdkModuleVersion={sdkModuleVersion}, pythonVersion={pythonVersion}, pythonImplementation={pythonImplementation}, osVersion={osVersion}, cpuVersion={cpuVersion})'.format(
      type=type(self).__name__,
      connectionType=self._connectionType,
      deviceID=self._deviceID,
      buildVersion=msgbuffers.shorten_string(self._buildVersion),
      sdkModuleVersion=msgbuffers.shorten_string(self._sdkModuleVersion),
      pythonVersion=msgbuffers.shorten_string(self._pythonVersion),
      pythonImplementation=msgbuffers.shorten_string(self._pythonImplementation),
      osVersion=msgbuffers.shorten_string(self._osVersion),
      cpuVersion=msgbuffers.shorten_string(self._cpuVersion))

  def __repr__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID}, buildVersion={buildVersion}, sdkModuleVersion={sdkModuleVersion}, pythonVersion={pythonVersion}, pythonImplementation={pythonImplementation}, osVersion={osVersion}, cpuVersion={cpuVersion})'.format(
      type=type(self).__name__,
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID),
      buildVersion=repr(self._buildVersion),
      sdkModuleVersion=repr(self._sdkModuleVersion),
      pythonVersion=repr(self._pythonVersion),
      pythonImplementation=repr(self._pythonImplementation),
      osVersion=repr(self._osVersion),
      cpuVersion=repr(self._cpuVersion))

Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess = UiDeviceConnectionSuccess
del UiDeviceConnectionSuccess


class ConnectToRobot(object):
  "Generated message-passing message."

  __slots__ = (
    '_ipAddress',   # uint_8[16]
    '_robotID',     # uint_8
    '_isSimulated', # uint_8
  )

  @property
  def ipAddress(self):
    "uint_8[16] ipAddress struct property."
    return self._ipAddress

  @ipAddress.setter
  def ipAddress(self, value):
    self._ipAddress = msgbuffers.validate_farray(
      'ConnectToRobot.ipAddress', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ConnectToRobot.robotID', value, 0, 255)

  @property
  def isSimulated(self):
    "uint_8 isSimulated struct property."
    return self._isSimulated

  @isSimulated.setter
  def isSimulated(self, value):
    self._isSimulated = msgbuffers.validate_integer(
      'ConnectToRobot.isSimulated', value, 0, 255)

  def __init__(self, ipAddress=(0,) * 16, robotID=0, isSimulated=0):
    self.ipAddress = ipAddress
    self.robotID = robotID
    self.isSimulated = isSimulated

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ConnectToRobot from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ConnectToRobot.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ConnectToRobot from the given BinaryReader."
    _ipAddress = reader.read_farray('B', 16)
    _robotID = reader.read('B')
    _isSimulated = reader.read('B')
    return cls(_ipAddress, _robotID, _isSimulated)

  def pack(self):
    "Writes the current ConnectToRobot, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ConnectToRobot to the given BinaryWriter."
    writer.write_farray(self._ipAddress, 'B', 16)
    writer.write(self._robotID, 'B')
    writer.write(self._isSimulated, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._ipAddress == other._ipAddress and
        self._robotID == other._robotID and
        self._isSimulated == other._isSimulated)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._ipAddress, 'B', 16) +
      msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._isSimulated, 'B'))

  def __str__(self):
    return '{type}(ipAddress={ipAddress}, robotID={robotID}, isSimulated={isSimulated})'.format(
      type=type(self).__name__,
      ipAddress=msgbuffers.shorten_sequence(self._ipAddress),
      robotID=self._robotID,
      isSimulated=self._isSimulated)

  def __repr__(self):
    return '{type}(ipAddress={ipAddress}, robotID={robotID}, isSimulated={isSimulated})'.format(
      type=type(self).__name__,
      ipAddress=repr(self._ipAddress),
      robotID=repr(self._robotID),
      isSimulated=repr(self._isSimulated))

Anki.Cozmo.ExternalInterface.ConnectToRobot = ConnectToRobot
del ConnectToRobot


class ConnectToUiDevice(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectionType', # Anki.Cozmo.UiConnectionType
    '_deviceID',       # uint_8
  )

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'ConnectToUiDevice.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_8 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'ConnectToUiDevice.deviceID', value, 0, 255)

  def __init__(self, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0):
    self.connectionType = connectionType
    self.deviceID = deviceID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ConnectToUiDevice from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ConnectToUiDevice.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ConnectToUiDevice from the given BinaryReader."
    _connectionType = reader.read('B')
    _deviceID = reader.read('B')
    return cls(_connectionType, _deviceID)

  def pack(self):
    "Writes the current ConnectToUiDevice, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ConnectToUiDevice to the given BinaryWriter."
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._connectionType == other._connectionType and
        self._deviceID == other._deviceID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'B'))

  def __str__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=self._connectionType,
      deviceID=self._deviceID)

  def __repr__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID))

Anki.Cozmo.ExternalInterface.ConnectToUiDevice = ConnectToUiDevice
del ConnectToUiDevice


class DisconnectFromUiDevice(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectionType', # Anki.Cozmo.UiConnectionType
    '_deviceID',       # uint_8
  )

  @property
  def connectionType(self):
    "Anki.Cozmo.UiConnectionType connectionType struct property."
    return self._connectionType

  @connectionType.setter
  def connectionType(self, value):
    self._connectionType = msgbuffers.validate_integer(
      'DisconnectFromUiDevice.connectionType', value, 0, 255)

  @property
  def deviceID(self):
    "uint_8 deviceID struct property."
    return self._deviceID

  @deviceID.setter
  def deviceID(self, value):
    self._deviceID = msgbuffers.validate_integer(
      'DisconnectFromUiDevice.deviceID', value, 0, 255)

  def __init__(self, connectionType=Anki.Cozmo.UiConnectionType.UI, deviceID=0):
    self.connectionType = connectionType
    self.deviceID = deviceID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DisconnectFromUiDevice from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DisconnectFromUiDevice.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DisconnectFromUiDevice from the given BinaryReader."
    _connectionType = reader.read('B')
    _deviceID = reader.read('B')
    return cls(_connectionType, _deviceID)

  def pack(self):
    "Writes the current DisconnectFromUiDevice, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DisconnectFromUiDevice to the given BinaryWriter."
    writer.write(self._connectionType, 'B')
    writer.write(self._deviceID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._connectionType == other._connectionType and
        self._deviceID == other._deviceID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._connectionType, 'B') +
      msgbuffers.size(self._deviceID, 'B'))

  def __str__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=self._connectionType,
      deviceID=self._deviceID)

  def __repr__(self):
    return '{type}(connectionType={connectionType}, deviceID={deviceID})'.format(
      type=type(self).__name__,
      connectionType=repr(self._connectionType),
      deviceID=repr(self._deviceID))

Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice = DisconnectFromUiDevice
del DisconnectFromUiDevice


class StartEngine(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StartEngine from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StartEngine.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StartEngine from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current StartEngine, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StartEngine to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.StartEngine = StartEngine
del StartEngine


class ReliableTransportRunMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_isSync', # bool
  )

  @property
  def isSync(self):
    "bool isSync struct property."
    return self._isSync

  @isSync.setter
  def isSync(self, value):
    self._isSync = msgbuffers.validate_bool(
      'ReliableTransportRunMode.isSync', value)

  def __init__(self, isSync=False):
    self.isSync = isSync

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReliableTransportRunMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReliableTransportRunMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReliableTransportRunMode from the given BinaryReader."
    _isSync = bool(reader.read('b'))
    return cls(_isSync)

  def pack(self):
    "Writes the current ReliableTransportRunMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReliableTransportRunMode to the given BinaryWriter."
    writer.write(int(self._isSync), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._isSync == other._isSync
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isSync, 'b'))

  def __str__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=self._isSync)

  def __repr__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=repr(self._isSync))

Anki.Cozmo.ExternalInterface.ReliableTransportRunMode = ReliableTransportRunMode
del ReliableTransportRunMode


class RequestFeatureToggles(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestFeatureToggles from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestFeatureToggles.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestFeatureToggles from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestFeatureToggles, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestFeatureToggles to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestFeatureToggles = RequestFeatureToggles
del RequestFeatureToggles


class SetFeatureToggle(object):
  "Generated message-passing message."

  __slots__ = (
    '_feature', # Anki.Cozmo.FeatureType
    '_value',   # bool
  )

  @property
  def feature(self):
    "Anki.Cozmo.FeatureType feature struct property."
    return self._feature

  @feature.setter
  def feature(self, value):
    self._feature = msgbuffers.validate_integer(
      'SetFeatureToggle.feature', value, 0, 255)

  @property
  def value(self):
    "bool value struct property."
    return self._value

  @value.setter
  def value(self, value):
    self._value = msgbuffers.validate_bool(
      'SetFeatureToggle.value', value)

  def __init__(self, feature=Anki.Cozmo.FeatureType.Dummy, value=False):
    self.feature = feature
    self.value = value

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetFeatureToggle from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetFeatureToggle.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetFeatureToggle from the given BinaryReader."
    _feature = reader.read('B')
    _value = bool(reader.read('b'))
    return cls(_feature, _value)

  def pack(self):
    "Writes the current SetFeatureToggle, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetFeatureToggle to the given BinaryWriter."
    writer.write(self._feature, 'B')
    writer.write(int(self._value), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._feature == other._feature and
        self._value == other._value)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._feature, 'B') +
      msgbuffers.size(self._value, 'b'))

  def __str__(self):
    return '{type}(feature={feature}, value={value})'.format(
      type=type(self).__name__,
      feature=self._feature,
      value=self._value)

  def __repr__(self):
    return '{type}(feature={feature}, value={value})'.format(
      type=type(self).__name__,
      feature=repr(self._feature),
      value=repr(self._value))

Anki.Cozmo.ExternalInterface.SetFeatureToggle = SetFeatureToggle
del SetFeatureToggle


class StartIdleTimeout(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceOffTime_s',    # float_32
    '_disconnectTime_s', # float_32
  )

  @property
  def faceOffTime_s(self):
    "float_32 faceOffTime_s struct property."
    return self._faceOffTime_s

  @faceOffTime_s.setter
  def faceOffTime_s(self, value):
    self._faceOffTime_s = msgbuffers.validate_float(
      'StartIdleTimeout.faceOffTime_s', value, 'f')

  @property
  def disconnectTime_s(self):
    "float_32 disconnectTime_s struct property."
    return self._disconnectTime_s

  @disconnectTime_s.setter
  def disconnectTime_s(self, value):
    self._disconnectTime_s = msgbuffers.validate_float(
      'StartIdleTimeout.disconnectTime_s', value, 'f')

  def __init__(self, faceOffTime_s=-1.0, disconnectTime_s=-1.0):
    self.faceOffTime_s = faceOffTime_s
    self.disconnectTime_s = disconnectTime_s

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StartIdleTimeout from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StartIdleTimeout.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StartIdleTimeout from the given BinaryReader."
    _faceOffTime_s = reader.read('f')
    _disconnectTime_s = reader.read('f')
    return cls(_faceOffTime_s, _disconnectTime_s)

  def pack(self):
    "Writes the current StartIdleTimeout, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StartIdleTimeout to the given BinaryWriter."
    writer.write(self._faceOffTime_s, 'f')
    writer.write(self._disconnectTime_s, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceOffTime_s == other._faceOffTime_s and
        self._disconnectTime_s == other._disconnectTime_s)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceOffTime_s, 'f') +
      msgbuffers.size(self._disconnectTime_s, 'f'))

  def __str__(self):
    return '{type}(faceOffTime_s={faceOffTime_s}, disconnectTime_s={disconnectTime_s})'.format(
      type=type(self).__name__,
      faceOffTime_s=self._faceOffTime_s,
      disconnectTime_s=self._disconnectTime_s)

  def __repr__(self):
    return '{type}(faceOffTime_s={faceOffTime_s}, disconnectTime_s={disconnectTime_s})'.format(
      type=type(self).__name__,
      faceOffTime_s=repr(self._faceOffTime_s),
      disconnectTime_s=repr(self._disconnectTime_s))

Anki.Cozmo.ExternalInterface.StartIdleTimeout = StartIdleTimeout
del StartIdleTimeout


class CancelIdleTimeout(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CancelIdleTimeout from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CancelIdleTimeout.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CancelIdleTimeout from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current CancelIdleTimeout, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CancelIdleTimeout to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.CancelIdleTimeout = CancelIdleTimeout
del CancelIdleTimeout


class SetGameBeingPaused(object):
  "Generated message-passing message."

  __slots__ = (
    '_isPaused', # bool
  )

  @property
  def isPaused(self):
    "bool isPaused struct property."
    return self._isPaused

  @isPaused.setter
  def isPaused(self, value):
    self._isPaused = msgbuffers.validate_bool(
      'SetGameBeingPaused.isPaused', value)

  def __init__(self, isPaused=True):
    self.isPaused = isPaused

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetGameBeingPaused from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetGameBeingPaused.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetGameBeingPaused from the given BinaryReader."
    _isPaused = bool(reader.read('b'))
    return cls(_isPaused)

  def pack(self):
    "Writes the current SetGameBeingPaused, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetGameBeingPaused to the given BinaryWriter."
    writer.write(int(self._isPaused), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._isPaused == other._isPaused
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isPaused, 'b'))

  def __str__(self):
    return '{type}(isPaused={isPaused})'.format(
      type=type(self).__name__,
      isPaused=self._isPaused)

  def __repr__(self):
    return '{type}(isPaused={isPaused})'.format(
      type=type(self).__name__,
      isPaused=repr(self._isPaused))

Anki.Cozmo.ExternalInterface.SetGameBeingPaused = SetGameBeingPaused
del SetGameBeingPaused


class UpdateFirmware(object):
  "Generated message-passing message."

  __slots__ = (
    '_fwType',  # Anki.Cozmo.FirmwareType
    '_version', # int_32
  )

  @property
  def fwType(self):
    "Anki.Cozmo.FirmwareType fwType struct property."
    return self._fwType

  @fwType.setter
  def fwType(self, value):
    self._fwType = msgbuffers.validate_integer(
      'UpdateFirmware.fwType', value, 0, 255)

  @property
  def version(self):
    "int_32 version struct property."
    return self._version

  @version.setter
  def version(self, value):
    self._version = msgbuffers.validate_integer(
      'UpdateFirmware.version', value, -2147483648, 2147483647)

  def __init__(self, fwType=Anki.Cozmo.FirmwareType.Current, version=0):
    self.fwType = fwType
    self.version = version

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UpdateFirmware from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UpdateFirmware.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UpdateFirmware from the given BinaryReader."
    _fwType = reader.read('B')
    _version = reader.read('i')
    return cls(_fwType, _version)

  def pack(self):
    "Writes the current UpdateFirmware, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UpdateFirmware to the given BinaryWriter."
    writer.write(self._fwType, 'B')
    writer.write(self._version, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._fwType == other._fwType and
        self._version == other._version)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._fwType, 'B') +
      msgbuffers.size(self._version, 'i'))

  def __str__(self):
    return '{type}(fwType={fwType}, version={version})'.format(
      type=type(self).__name__,
      fwType=self._fwType,
      version=self._version)

  def __repr__(self):
    return '{type}(fwType={fwType}, version={version})'.format(
      type=type(self).__name__,
      fwType=repr(self._fwType),
      version=repr(self._version))

Anki.Cozmo.ExternalInterface.UpdateFirmware = UpdateFirmware
del UpdateFirmware


class ResetFirmware(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ResetFirmware from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ResetFirmware.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ResetFirmware from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ResetFirmware, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ResetFirmware to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ResetFirmware = ResetFirmware
del ResetFirmware


class DriveWheels(object):
  "Generated message-passing message."

  __slots__ = (
    '_lwheel_speed_mmps',  # float_32
    '_rwheel_speed_mmps',  # float_32
    '_lwheel_accel_mmps2', # float_32
    '_rwheel_accel_mmps2', # float_32
  )

  @property
  def lwheel_speed_mmps(self):
    "float_32 lwheel_speed_mmps struct property."
    return self._lwheel_speed_mmps

  @lwheel_speed_mmps.setter
  def lwheel_speed_mmps(self, value):
    self._lwheel_speed_mmps = msgbuffers.validate_float(
      'DriveWheels.lwheel_speed_mmps', value, 'f')

  @property
  def rwheel_speed_mmps(self):
    "float_32 rwheel_speed_mmps struct property."
    return self._rwheel_speed_mmps

  @rwheel_speed_mmps.setter
  def rwheel_speed_mmps(self, value):
    self._rwheel_speed_mmps = msgbuffers.validate_float(
      'DriveWheels.rwheel_speed_mmps', value, 'f')

  @property
  def lwheel_accel_mmps2(self):
    "float_32 lwheel_accel_mmps2 struct property."
    return self._lwheel_accel_mmps2

  @lwheel_accel_mmps2.setter
  def lwheel_accel_mmps2(self, value):
    self._lwheel_accel_mmps2 = msgbuffers.validate_float(
      'DriveWheels.lwheel_accel_mmps2', value, 'f')

  @property
  def rwheel_accel_mmps2(self):
    "float_32 rwheel_accel_mmps2 struct property."
    return self._rwheel_accel_mmps2

  @rwheel_accel_mmps2.setter
  def rwheel_accel_mmps2(self, value):
    self._rwheel_accel_mmps2 = msgbuffers.validate_float(
      'DriveWheels.rwheel_accel_mmps2', value, 'f')

  def __init__(self, lwheel_speed_mmps=0.0, rwheel_speed_mmps=0.0, lwheel_accel_mmps2=0.0, rwheel_accel_mmps2=0.0):
    self.lwheel_speed_mmps = lwheel_speed_mmps
    self.rwheel_speed_mmps = rwheel_speed_mmps
    self.lwheel_accel_mmps2 = lwheel_accel_mmps2
    self.rwheel_accel_mmps2 = rwheel_accel_mmps2

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DriveWheels from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DriveWheels.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DriveWheels from the given BinaryReader."
    _lwheel_speed_mmps = reader.read('f')
    _rwheel_speed_mmps = reader.read('f')
    _lwheel_accel_mmps2 = reader.read('f')
    _rwheel_accel_mmps2 = reader.read('f')
    return cls(_lwheel_speed_mmps, _rwheel_speed_mmps, _lwheel_accel_mmps2, _rwheel_accel_mmps2)

  def pack(self):
    "Writes the current DriveWheels, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DriveWheels to the given BinaryWriter."
    writer.write(self._lwheel_speed_mmps, 'f')
    writer.write(self._rwheel_speed_mmps, 'f')
    writer.write(self._lwheel_accel_mmps2, 'f')
    writer.write(self._rwheel_accel_mmps2, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._lwheel_speed_mmps == other._lwheel_speed_mmps and
        self._rwheel_speed_mmps == other._rwheel_speed_mmps and
        self._lwheel_accel_mmps2 == other._lwheel_accel_mmps2 and
        self._rwheel_accel_mmps2 == other._rwheel_accel_mmps2)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._lwheel_speed_mmps, 'f') +
      msgbuffers.size(self._rwheel_speed_mmps, 'f') +
      msgbuffers.size(self._lwheel_accel_mmps2, 'f') +
      msgbuffers.size(self._rwheel_accel_mmps2, 'f'))

  def __str__(self):
    return '{type}(lwheel_speed_mmps={lwheel_speed_mmps}, rwheel_speed_mmps={rwheel_speed_mmps}, lwheel_accel_mmps2={lwheel_accel_mmps2}, rwheel_accel_mmps2={rwheel_accel_mmps2})'.format(
      type=type(self).__name__,
      lwheel_speed_mmps=self._lwheel_speed_mmps,
      rwheel_speed_mmps=self._rwheel_speed_mmps,
      lwheel_accel_mmps2=self._lwheel_accel_mmps2,
      rwheel_accel_mmps2=self._rwheel_accel_mmps2)

  def __repr__(self):
    return '{type}(lwheel_speed_mmps={lwheel_speed_mmps}, rwheel_speed_mmps={rwheel_speed_mmps}, lwheel_accel_mmps2={lwheel_accel_mmps2}, rwheel_accel_mmps2={rwheel_accel_mmps2})'.format(
      type=type(self).__name__,
      lwheel_speed_mmps=repr(self._lwheel_speed_mmps),
      rwheel_speed_mmps=repr(self._rwheel_speed_mmps),
      lwheel_accel_mmps2=repr(self._lwheel_accel_mmps2),
      rwheel_accel_mmps2=repr(self._rwheel_accel_mmps2))

Anki.Cozmo.ExternalInterface.DriveWheels = DriveWheels
del DriveWheels


class DriveArc(object):
  "Generated message-passing message."

  __slots__ = (
    '_speed_mmps',         # float_32
    '_curvatureRadius_mm', # float_32
  )

  @property
  def speed_mmps(self):
    "float_32 speed_mmps struct property."
    return self._speed_mmps

  @speed_mmps.setter
  def speed_mmps(self, value):
    self._speed_mmps = msgbuffers.validate_float(
      'DriveArc.speed_mmps', value, 'f')

  @property
  def curvatureRadius_mm(self):
    "float_32 curvatureRadius_mm struct property."
    return self._curvatureRadius_mm

  @curvatureRadius_mm.setter
  def curvatureRadius_mm(self, value):
    self._curvatureRadius_mm = msgbuffers.validate_float(
      'DriveArc.curvatureRadius_mm', value, 'f')

  def __init__(self, speed_mmps=0.0, curvatureRadius_mm=0.0):
    self.speed_mmps = speed_mmps
    self.curvatureRadius_mm = curvatureRadius_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DriveArc from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DriveArc.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DriveArc from the given BinaryReader."
    _speed_mmps = reader.read('f')
    _curvatureRadius_mm = reader.read('f')
    return cls(_speed_mmps, _curvatureRadius_mm)

  def pack(self):
    "Writes the current DriveArc, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DriveArc to the given BinaryWriter."
    writer.write(self._speed_mmps, 'f')
    writer.write(self._curvatureRadius_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._speed_mmps == other._speed_mmps and
        self._curvatureRadius_mm == other._curvatureRadius_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_mmps, 'f') +
      msgbuffers.size(self._curvatureRadius_mm, 'f'))

  def __str__(self):
    return '{type}(speed_mmps={speed_mmps}, curvatureRadius_mm={curvatureRadius_mm})'.format(
      type=type(self).__name__,
      speed_mmps=self._speed_mmps,
      curvatureRadius_mm=self._curvatureRadius_mm)

  def __repr__(self):
    return '{type}(speed_mmps={speed_mmps}, curvatureRadius_mm={curvatureRadius_mm})'.format(
      type=type(self).__name__,
      speed_mmps=repr(self._speed_mmps),
      curvatureRadius_mm=repr(self._curvatureRadius_mm))

Anki.Cozmo.ExternalInterface.DriveArc = DriveArc
del DriveArc


class MoveHead(object):
  "Generated message-passing message."

  __slots__ = (
    '_speed_rad_per_sec', # float_32
  )

  @property
  def speed_rad_per_sec(self):
    "float_32 speed_rad_per_sec struct property."
    return self._speed_rad_per_sec

  @speed_rad_per_sec.setter
  def speed_rad_per_sec(self, value):
    self._speed_rad_per_sec = msgbuffers.validate_float(
      'MoveHead.speed_rad_per_sec', value, 'f')

  def __init__(self, speed_rad_per_sec=0.0):
    self.speed_rad_per_sec = speed_rad_per_sec

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MoveHead from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MoveHead.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MoveHead from the given BinaryReader."
    _speed_rad_per_sec = reader.read('f')
    return cls(_speed_rad_per_sec)

  def pack(self):
    "Writes the current MoveHead, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MoveHead to the given BinaryWriter."
    writer.write(self._speed_rad_per_sec, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._speed_rad_per_sec == other._speed_rad_per_sec
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_rad_per_sec, 'f'))

  def __str__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=self._speed_rad_per_sec)

  def __repr__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=repr(self._speed_rad_per_sec))

Anki.Cozmo.ExternalInterface.MoveHead = MoveHead
del MoveHead


class MoveLift(object):
  "Generated message-passing message."

  __slots__ = (
    '_speed_rad_per_sec', # float_32
  )

  @property
  def speed_rad_per_sec(self):
    "float_32 speed_rad_per_sec struct property."
    return self._speed_rad_per_sec

  @speed_rad_per_sec.setter
  def speed_rad_per_sec(self, value):
    self._speed_rad_per_sec = msgbuffers.validate_float(
      'MoveLift.speed_rad_per_sec', value, 'f')

  def __init__(self, speed_rad_per_sec=0.0):
    self.speed_rad_per_sec = speed_rad_per_sec

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MoveLift from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MoveLift.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MoveLift from the given BinaryReader."
    _speed_rad_per_sec = reader.read('f')
    return cls(_speed_rad_per_sec)

  def pack(self):
    "Writes the current MoveLift, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MoveLift to the given BinaryWriter."
    writer.write(self._speed_rad_per_sec, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._speed_rad_per_sec == other._speed_rad_per_sec
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_rad_per_sec, 'f'))

  def __str__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=self._speed_rad_per_sec)

  def __repr__(self):
    return '{type}(speed_rad_per_sec={speed_rad_per_sec})'.format(
      type=type(self).__name__,
      speed_rad_per_sec=repr(self._speed_rad_per_sec))

Anki.Cozmo.ExternalInterface.MoveLift = MoveLift
del MoveLift


class EnableLiftPower(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableLiftPower.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableLiftPower from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableLiftPower.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableLiftPower from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current EnableLiftPower, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableLiftPower to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableLiftPower = EnableLiftPower
del EnableLiftPower


class EnableCliffSensor(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableCliffSensor.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableCliffSensor from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableCliffSensor.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableCliffSensor from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current EnableCliffSensor, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableCliffSensor to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableCliffSensor = EnableCliffSensor
del EnableCliffSensor


class EnableBlockTapFilter(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableBlockTapFilter.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableBlockTapFilter from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableBlockTapFilter.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableBlockTapFilter from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current EnableBlockTapFilter, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableBlockTapFilter to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableBlockTapFilter = EnableBlockTapFilter
del EnableBlockTapFilter


class GetBlockTapFilterStatus(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetBlockTapFilterStatus from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetBlockTapFilterStatus.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetBlockTapFilterStatus from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GetBlockTapFilterStatus, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetBlockTapFilterStatus to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus = GetBlockTapFilterStatus
del GetBlockTapFilterStatus


class StopAllMotors(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StopAllMotors from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StopAllMotors.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StopAllMotors from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current StopAllMotors, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StopAllMotors to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.StopAllMotors = StopAllMotors
del StopAllMotors


class ControllerGains(object):
  "Generated message-passing message."

  __slots__ = (
    '_kp',               # float_32
    '_ki',               # float_32
    '_kd',               # float_32
    '_maxIntegralError', # float_32
    '_controller',       # Anki.Cozmo.ControllerChannel
  )

  @property
  def kp(self):
    "float_32 kp struct property."
    return self._kp

  @kp.setter
  def kp(self, value):
    self._kp = msgbuffers.validate_float(
      'ControllerGains.kp', value, 'f')

  @property
  def ki(self):
    "float_32 ki struct property."
    return self._ki

  @ki.setter
  def ki(self, value):
    self._ki = msgbuffers.validate_float(
      'ControllerGains.ki', value, 'f')

  @property
  def kd(self):
    "float_32 kd struct property."
    return self._kd

  @kd.setter
  def kd(self, value):
    self._kd = msgbuffers.validate_float(
      'ControllerGains.kd', value, 'f')

  @property
  def maxIntegralError(self):
    "float_32 maxIntegralError struct property."
    return self._maxIntegralError

  @maxIntegralError.setter
  def maxIntegralError(self, value):
    self._maxIntegralError = msgbuffers.validate_float(
      'ControllerGains.maxIntegralError', value, 'f')

  @property
  def controller(self):
    "Anki.Cozmo.ControllerChannel controller struct property."
    return self._controller

  @controller.setter
  def controller(self, value):
    self._controller = msgbuffers.validate_integer(
      'ControllerGains.controller', value, 0, 255)

  def __init__(self, kp=0.0, ki=0.0, kd=0.0, maxIntegralError=0.0, controller=Anki.Cozmo.ControllerChannel.controller_wheel):
    self.kp = kp
    self.ki = ki
    self.kd = kd
    self.maxIntegralError = maxIntegralError
    self.controller = controller

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ControllerGains from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ControllerGains.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ControllerGains from the given BinaryReader."
    _kp = reader.read('f')
    _ki = reader.read('f')
    _kd = reader.read('f')
    _maxIntegralError = reader.read('f')
    _controller = reader.read('B')
    return cls(_kp, _ki, _kd, _maxIntegralError, _controller)

  def pack(self):
    "Writes the current ControllerGains, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ControllerGains to the given BinaryWriter."
    writer.write(self._kp, 'f')
    writer.write(self._ki, 'f')
    writer.write(self._kd, 'f')
    writer.write(self._maxIntegralError, 'f')
    writer.write(self._controller, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._kp == other._kp and
        self._ki == other._ki and
        self._kd == other._kd and
        self._maxIntegralError == other._maxIntegralError and
        self._controller == other._controller)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._kp, 'f') +
      msgbuffers.size(self._ki, 'f') +
      msgbuffers.size(self._kd, 'f') +
      msgbuffers.size(self._maxIntegralError, 'f') +
      msgbuffers.size(self._controller, 'B'))

  def __str__(self):
    return '{type}(kp={kp}, ki={ki}, kd={kd}, maxIntegralError={maxIntegralError}, controller={controller})'.format(
      type=type(self).__name__,
      kp=self._kp,
      ki=self._ki,
      kd=self._kd,
      maxIntegralError=self._maxIntegralError,
      controller=self._controller)

  def __repr__(self):
    return '{type}(kp={kp}, ki={ki}, kd={kd}, maxIntegralError={maxIntegralError}, controller={controller})'.format(
      type=type(self).__name__,
      kp=repr(self._kp),
      ki=repr(self._ki),
      kd=repr(self._kd),
      maxIntegralError=repr(self._maxIntegralError),
      controller=repr(self._controller))

Anki.Cozmo.ExternalInterface.ControllerGains = ControllerGains
del ControllerGains


class RollActionParams(object):
  "Generated message-passing message."

  __slots__ = (
    '_liftHeight_mm',    # float_32
    '_driveSpeed_mmps',  # float_32
    '_driveAccel_mmps2', # float_32
    '_driveDuration_ms', # uint_32
    '_backupDist_mm',    # float_32
  )

  @property
  def liftHeight_mm(self):
    "float_32 liftHeight_mm struct property."
    return self._liftHeight_mm

  @liftHeight_mm.setter
  def liftHeight_mm(self, value):
    self._liftHeight_mm = msgbuffers.validate_float(
      'RollActionParams.liftHeight_mm', value, 'f')

  @property
  def driveSpeed_mmps(self):
    "float_32 driveSpeed_mmps struct property."
    return self._driveSpeed_mmps

  @driveSpeed_mmps.setter
  def driveSpeed_mmps(self, value):
    self._driveSpeed_mmps = msgbuffers.validate_float(
      'RollActionParams.driveSpeed_mmps', value, 'f')

  @property
  def driveAccel_mmps2(self):
    "float_32 driveAccel_mmps2 struct property."
    return self._driveAccel_mmps2

  @driveAccel_mmps2.setter
  def driveAccel_mmps2(self, value):
    self._driveAccel_mmps2 = msgbuffers.validate_float(
      'RollActionParams.driveAccel_mmps2', value, 'f')

  @property
  def driveDuration_ms(self):
    "uint_32 driveDuration_ms struct property."
    return self._driveDuration_ms

  @driveDuration_ms.setter
  def driveDuration_ms(self, value):
    self._driveDuration_ms = msgbuffers.validate_integer(
      'RollActionParams.driveDuration_ms', value, 0, 4294967295)

  @property
  def backupDist_mm(self):
    "float_32 backupDist_mm struct property."
    return self._backupDist_mm

  @backupDist_mm.setter
  def backupDist_mm(self, value):
    self._backupDist_mm = msgbuffers.validate_float(
      'RollActionParams.backupDist_mm', value, 'f')

  def __init__(self, liftHeight_mm=0.0, driveSpeed_mmps=0.0, driveAccel_mmps2=0.0, driveDuration_ms=0, backupDist_mm=0.0):
    self.liftHeight_mm = liftHeight_mm
    self.driveSpeed_mmps = driveSpeed_mmps
    self.driveAccel_mmps2 = driveAccel_mmps2
    self.driveDuration_ms = driveDuration_ms
    self.backupDist_mm = backupDist_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RollActionParams from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RollActionParams.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RollActionParams from the given BinaryReader."
    _liftHeight_mm = reader.read('f')
    _driveSpeed_mmps = reader.read('f')
    _driveAccel_mmps2 = reader.read('f')
    _driveDuration_ms = reader.read('I')
    _backupDist_mm = reader.read('f')
    return cls(_liftHeight_mm, _driveSpeed_mmps, _driveAccel_mmps2, _driveDuration_ms, _backupDist_mm)

  def pack(self):
    "Writes the current RollActionParams, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RollActionParams to the given BinaryWriter."
    writer.write(self._liftHeight_mm, 'f')
    writer.write(self._driveSpeed_mmps, 'f')
    writer.write(self._driveAccel_mmps2, 'f')
    writer.write(self._driveDuration_ms, 'I')
    writer.write(self._backupDist_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._liftHeight_mm == other._liftHeight_mm and
        self._driveSpeed_mmps == other._driveSpeed_mmps and
        self._driveAccel_mmps2 == other._driveAccel_mmps2 and
        self._driveDuration_ms == other._driveDuration_ms and
        self._backupDist_mm == other._backupDist_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._liftHeight_mm, 'f') +
      msgbuffers.size(self._driveSpeed_mmps, 'f') +
      msgbuffers.size(self._driveAccel_mmps2, 'f') +
      msgbuffers.size(self._driveDuration_ms, 'I') +
      msgbuffers.size(self._backupDist_mm, 'f'))

  def __str__(self):
    return '{type}(liftHeight_mm={liftHeight_mm}, driveSpeed_mmps={driveSpeed_mmps}, driveAccel_mmps2={driveAccel_mmps2}, driveDuration_ms={driveDuration_ms}, backupDist_mm={backupDist_mm})'.format(
      type=type(self).__name__,
      liftHeight_mm=self._liftHeight_mm,
      driveSpeed_mmps=self._driveSpeed_mmps,
      driveAccel_mmps2=self._driveAccel_mmps2,
      driveDuration_ms=self._driveDuration_ms,
      backupDist_mm=self._backupDist_mm)

  def __repr__(self):
    return '{type}(liftHeight_mm={liftHeight_mm}, driveSpeed_mmps={driveSpeed_mmps}, driveAccel_mmps2={driveAccel_mmps2}, driveDuration_ms={driveDuration_ms}, backupDist_mm={backupDist_mm})'.format(
      type=type(self).__name__,
      liftHeight_mm=repr(self._liftHeight_mm),
      driveSpeed_mmps=repr(self._driveSpeed_mmps),
      driveAccel_mmps2=repr(self._driveAccel_mmps2),
      driveDuration_ms=repr(self._driveDuration_ms),
      backupDist_mm=repr(self._backupDist_mm))

Anki.Cozmo.ExternalInterface.RollActionParams = RollActionParams
del RollActionParams


class SetMotionModelParams(object):
  "Generated message-passing message."

  __slots__ = (
    '_slipFactor', # float_32
  )

  @property
  def slipFactor(self):
    "float_32 slipFactor struct property."
    return self._slipFactor

  @slipFactor.setter
  def slipFactor(self, value):
    self._slipFactor = msgbuffers.validate_float(
      'SetMotionModelParams.slipFactor', value, 'f')

  def __init__(self, slipFactor=0.0):
    self.slipFactor = slipFactor

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetMotionModelParams from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetMotionModelParams.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetMotionModelParams from the given BinaryReader."
    _slipFactor = reader.read('f')
    return cls(_slipFactor)

  def pack(self):
    "Writes the current SetMotionModelParams, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetMotionModelParams to the given BinaryWriter."
    writer.write(self._slipFactor, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._slipFactor == other._slipFactor
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._slipFactor, 'f'))

  def __str__(self):
    return '{type}(slipFactor={slipFactor})'.format(
      type=type(self).__name__,
      slipFactor=self._slipFactor)

  def __repr__(self):
    return '{type}(slipFactor={slipFactor})'.format(
      type=type(self).__name__,
      slipFactor=repr(self._slipFactor))

Anki.Cozmo.ExternalInterface.SetMotionModelParams = SetMotionModelParams
del SetMotionModelParams


class SetRobotVolume(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotId', # uint_8
    '_volume',  # float_32
  )

  @property
  def robotId(self):
    "uint_8 robotId struct property."
    return self._robotId

  @robotId.setter
  def robotId(self, value):
    self._robotId = msgbuffers.validate_integer(
      'SetRobotVolume.robotId', value, 0, 255)

  @property
  def volume(self):
    "float_32 volume struct property."
    return self._volume

  @volume.setter
  def volume(self, value):
    self._volume = msgbuffers.validate_float(
      'SetRobotVolume.volume', value, 'f')

  def __init__(self, robotId=0, volume=0.0):
    self.robotId = robotId
    self.volume = volume

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetRobotVolume from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetRobotVolume.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetRobotVolume from the given BinaryReader."
    _robotId = reader.read('B')
    _volume = reader.read('f')
    return cls(_robotId, _volume)

  def pack(self):
    "Writes the current SetRobotVolume, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetRobotVolume to the given BinaryWriter."
    writer.write(self._robotId, 'B')
    writer.write(self._volume, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotId == other._robotId and
        self._volume == other._volume)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotId, 'B') +
      msgbuffers.size(self._volume, 'f'))

  def __str__(self):
    return '{type}(robotId={robotId}, volume={volume})'.format(
      type=type(self).__name__,
      robotId=self._robotId,
      volume=self._volume)

  def __repr__(self):
    return '{type}(robotId={robotId}, volume={volume})'.format(
      type=type(self).__name__,
      robotId=repr(self._robotId),
      volume=repr(self._volume))

Anki.Cozmo.ExternalInterface.SetRobotVolume = SetRobotVolume
del SetRobotVolume


class RobotAudioOutputSourceCLAD(object):
  "Automatically-generated uint_8 enumeration."
  NoDevice     = 0
  PlayOnDevice = 1
  PlayOnRobot  = 2

Anki.Cozmo.ExternalInterface.RobotAudioOutputSourceCLAD = RobotAudioOutputSourceCLAD
del RobotAudioOutputSourceCLAD


class SetRobotAudioOutputSource(object):
  "Generated message-passing message."

  __slots__ = (
    '_source', # Anki.Cozmo.ExternalInterface.RobotAudioOutputSourceCLAD
  )

  @property
  def source(self):
    "Anki.Cozmo.ExternalInterface.RobotAudioOutputSourceCLAD source struct property."
    return self._source

  @source.setter
  def source(self, value):
    self._source = msgbuffers.validate_integer(
      'SetRobotAudioOutputSource.source', value, 0, 255)

  def __init__(self, source=Anki.Cozmo.ExternalInterface.RobotAudioOutputSourceCLAD.NoDevice):
    self.source = source

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetRobotAudioOutputSource from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetRobotAudioOutputSource.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetRobotAudioOutputSource from the given BinaryReader."
    _source = reader.read('B')
    return cls(_source)

  def pack(self):
    "Writes the current SetRobotAudioOutputSource, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetRobotAudioOutputSource to the given BinaryWriter."
    writer.write(self._source, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._source == other._source
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._source, 'B'))

  def __str__(self):
    return '{type}(source={source})'.format(
      type=type(self).__name__,
      source=self._source)

  def __repr__(self):
    return '{type}(source={source})'.format(
      type=type(self).__name__,
      source=repr(self._source))

Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource = SetRobotAudioOutputSource
del SetRobotAudioOutputSource


class ForceDelocalizeRobot(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ForceDelocalizeRobot.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ForceDelocalizeRobot from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ForceDelocalizeRobot.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ForceDelocalizeRobot from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current ForceDelocalizeRobot, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ForceDelocalizeRobot to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot = ForceDelocalizeRobot
del ForceDelocalizeRobot


class RestoreRobotFromBackup(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotToRestoreFrom', # uint_32
  )

  @property
  def robotToRestoreFrom(self):
    "uint_32 robotToRestoreFrom struct property."
    return self._robotToRestoreFrom

  @robotToRestoreFrom.setter
  def robotToRestoreFrom(self, value):
    self._robotToRestoreFrom = msgbuffers.validate_integer(
      'RestoreRobotFromBackup.robotToRestoreFrom', value, 0, 4294967295)

  def __init__(self, robotToRestoreFrom=0):
    self.robotToRestoreFrom = robotToRestoreFrom

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RestoreRobotFromBackup from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RestoreRobotFromBackup.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RestoreRobotFromBackup from the given BinaryReader."
    _robotToRestoreFrom = reader.read('I')
    return cls(_robotToRestoreFrom)

  def pack(self):
    "Writes the current RestoreRobotFromBackup, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RestoreRobotFromBackup to the given BinaryWriter."
    writer.write(self._robotToRestoreFrom, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotToRestoreFrom == other._robotToRestoreFrom
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotToRestoreFrom, 'I'))

  def __str__(self):
    return '{type}(robotToRestoreFrom={robotToRestoreFrom})'.format(
      type=type(self).__name__,
      robotToRestoreFrom=self._robotToRestoreFrom)

  def __repr__(self):
    return '{type}(robotToRestoreFrom={robotToRestoreFrom})'.format(
      type=type(self).__name__,
      robotToRestoreFrom=repr(self._robotToRestoreFrom))

Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup = RestoreRobotFromBackup
del RestoreRobotFromBackup


class RequestRobotRestoreData(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestRobotRestoreData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestRobotRestoreData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestRobotRestoreData from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestRobotRestoreData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestRobotRestoreData to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestRobotRestoreData = RequestRobotRestoreData
del RequestRobotRestoreData


class WipeRobotGameData(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new WipeRobotGameData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('WipeRobotGameData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new WipeRobotGameData from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current WipeRobotGameData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current WipeRobotGameData to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.WipeRobotGameData = WipeRobotGameData
del WipeRobotGameData


class RequestUnlockDataFromBackup(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestUnlockDataFromBackup from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestUnlockDataFromBackup.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestUnlockDataFromBackup from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestUnlockDataFromBackup, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestUnlockDataFromBackup to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup = RequestUnlockDataFromBackup
del RequestUnlockDataFromBackup


class CancelAction(object):
  "Generated message-passing message."

  __slots__ = (
    '_actionType', # Anki.Cozmo.RobotActionType
    '_robotID',    # uint_8
  )

  @property
  def actionType(self):
    "Anki.Cozmo.RobotActionType actionType struct property."
    return self._actionType

  @actionType.setter
  def actionType(self, value):
    self._actionType = msgbuffers.validate_integer(
      'CancelAction.actionType', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'CancelAction.robotID', value, 0, 255)

  def __init__(self, actionType=Anki.Cozmo.RobotActionType.COMPOUND, robotID=0):
    self.actionType = actionType
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CancelAction from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CancelAction.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CancelAction from the given BinaryReader."
    _actionType = reader.read('i')
    _robotID = reader.read('B')
    return cls(_actionType, _robotID)

  def pack(self):
    "Writes the current CancelAction, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CancelAction to the given BinaryWriter."
    writer.write(self._actionType, 'i')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._actionType == other._actionType and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._actionType, 'i') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(actionType={actionType}, robotID={robotID})'.format(
      type=type(self).__name__,
      actionType=self._actionType,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(actionType={actionType}, robotID={robotID})'.format(
      type=type(self).__name__,
      actionType=repr(self._actionType),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.CancelAction = CancelAction
del CancelAction


class CancelActionByIdTag(object):
  "Generated message-passing message."

  __slots__ = (
    '_idTag',   # uint_32
    '_robotID', # uint_8
  )

  @property
  def idTag(self):
    "uint_32 idTag struct property."
    return self._idTag

  @idTag.setter
  def idTag(self, value):
    self._idTag = msgbuffers.validate_integer(
      'CancelActionByIdTag.idTag', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'CancelActionByIdTag.robotID', value, 0, 255)

  def __init__(self, idTag=0, robotID=0):
    self.idTag = idTag
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CancelActionByIdTag from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CancelActionByIdTag.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CancelActionByIdTag from the given BinaryReader."
    _idTag = reader.read('I')
    _robotID = reader.read('B')
    return cls(_idTag, _robotID)

  def pack(self):
    "Writes the current CancelActionByIdTag, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CancelActionByIdTag to the given BinaryWriter."
    writer.write(self._idTag, 'I')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._idTag == other._idTag and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._idTag, 'I') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(idTag={idTag}, robotID={robotID})'.format(
      type=type(self).__name__,
      idTag=self._idTag,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(idTag={idTag}, robotID={robotID})'.format(
      type=type(self).__name__,
      idTag=repr(self._idTag),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.CancelActionByIdTag = CancelActionByIdTag
del CancelActionByIdTag


class QueueSingleAction(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',    # uint_8
    '_idTag',      # uint_32
    '_numRetries', # uint_8
    '_position',   # Anki.Cozmo.QueueActionPosition
    '_action',     # Anki.Cozmo.ExternalInterface.RobotActionUnion
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'QueueSingleAction.robotID', value, 0, 255)

  @property
  def idTag(self):
    "uint_32 idTag struct property."
    return self._idTag

  @idTag.setter
  def idTag(self, value):
    self._idTag = msgbuffers.validate_integer(
      'QueueSingleAction.idTag', value, 0, 4294967295)

  @property
  def numRetries(self):
    "uint_8 numRetries struct property."
    return self._numRetries

  @numRetries.setter
  def numRetries(self, value):
    self._numRetries = msgbuffers.validate_integer(
      'QueueSingleAction.numRetries', value, 0, 255)

  @property
  def position(self):
    "Anki.Cozmo.QueueActionPosition position struct property."
    return self._position

  @position.setter
  def position(self, value):
    self._position = msgbuffers.validate_integer(
      'QueueSingleAction.position', value, 0, 255)

  @property
  def action(self):
    "Anki.Cozmo.ExternalInterface.RobotActionUnion action struct property."
    return self._action

  @action.setter
  def action(self, value):
    self._action = msgbuffers.validate_object(
      'QueueSingleAction.action', value, Anki.Cozmo.ExternalInterface.RobotActionUnion)

  def __init__(self, robotID=0, idTag=0, numRetries=0, position=Anki.Cozmo.QueueActionPosition.NOW, action=Anki.Cozmo.ExternalInterface.RobotActionUnion()):
    self.robotID = robotID
    self.idTag = idTag
    self.numRetries = numRetries
    self.position = position
    self.action = action

  @classmethod
  def unpack(cls, buffer):
    "Reads a new QueueSingleAction from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('QueueSingleAction.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new QueueSingleAction from the given BinaryReader."
    _robotID = reader.read('B')
    _idTag = reader.read('I')
    _numRetries = reader.read('B')
    _position = reader.read('B')
    _action = reader.read_object(Anki.Cozmo.ExternalInterface.RobotActionUnion.unpack_from)
    return cls(_robotID, _idTag, _numRetries, _position, _action)

  def pack(self):
    "Writes the current QueueSingleAction, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current QueueSingleAction to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._idTag, 'I')
    writer.write(self._numRetries, 'B')
    writer.write(self._position, 'B')
    writer.write_object(self._action)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._idTag == other._idTag and
        self._numRetries == other._numRetries and
        self._position == other._position and
        self._action == other._action)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._idTag, 'I') +
      msgbuffers.size(self._numRetries, 'B') +
      msgbuffers.size(self._position, 'B') +
      msgbuffers.size_object(self._action))

  def __str__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, numRetries={numRetries}, position={position}, action={action})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      idTag=self._idTag,
      numRetries=self._numRetries,
      position=self._position,
      action=self._action)

  def __repr__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, numRetries={numRetries}, position={position}, action={action})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      idTag=repr(self._idTag),
      numRetries=repr(self._numRetries),
      position=repr(self._position),
      action=repr(self._action))

Anki.Cozmo.ExternalInterface.QueueSingleAction = QueueSingleAction
del QueueSingleAction


class QueueCompoundAction(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',    # uint_8
    '_idTag',      # uint_32
    '_numRetries', # uint_8
    '_parallel',   # bool
    '_position',   # Anki.Cozmo.QueueActionPosition
    '_actions',    # RobotActionUnion[uint_8]
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'QueueCompoundAction.robotID', value, 0, 255)

  @property
  def idTag(self):
    "uint_32 idTag struct property."
    return self._idTag

  @idTag.setter
  def idTag(self, value):
    self._idTag = msgbuffers.validate_integer(
      'QueueCompoundAction.idTag', value, 0, 4294967295)

  @property
  def numRetries(self):
    "uint_8 numRetries struct property."
    return self._numRetries

  @numRetries.setter
  def numRetries(self, value):
    self._numRetries = msgbuffers.validate_integer(
      'QueueCompoundAction.numRetries', value, 0, 255)

  @property
  def parallel(self):
    "bool parallel struct property."
    return self._parallel

  @parallel.setter
  def parallel(self, value):
    self._parallel = msgbuffers.validate_bool(
      'QueueCompoundAction.parallel', value)

  @property
  def position(self):
    "Anki.Cozmo.QueueActionPosition position struct property."
    return self._position

  @position.setter
  def position(self, value):
    self._position = msgbuffers.validate_integer(
      'QueueCompoundAction.position', value, 0, 255)

  @property
  def actions(self):
    "RobotActionUnion[uint_8] actions struct property."
    return self._actions

  @actions.setter
  def actions(self, value):
    self._actions = msgbuffers.validate_varray(
      'QueueCompoundAction.actions', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.ExternalInterface.RobotActionUnion))

  def __init__(self, robotID=0, idTag=0, numRetries=0, parallel=False, position=Anki.Cozmo.QueueActionPosition.NOW, actions=()):
    self.robotID = robotID
    self.idTag = idTag
    self.numRetries = numRetries
    self.parallel = parallel
    self.position = position
    self.actions = actions

  @classmethod
  def unpack(cls, buffer):
    "Reads a new QueueCompoundAction from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('QueueCompoundAction.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new QueueCompoundAction from the given BinaryReader."
    _robotID = reader.read('B')
    _idTag = reader.read('I')
    _numRetries = reader.read('B')
    _parallel = bool(reader.read('b'))
    _position = reader.read('B')
    _actions = reader.read_object_varray(Anki.Cozmo.ExternalInterface.RobotActionUnion.unpack_from, 'B')
    return cls(_robotID, _idTag, _numRetries, _parallel, _position, _actions)

  def pack(self):
    "Writes the current QueueCompoundAction, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current QueueCompoundAction to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._idTag, 'I')
    writer.write(self._numRetries, 'B')
    writer.write(int(self._parallel), 'b')
    writer.write(self._position, 'B')
    writer.write_object_varray(self._actions, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._idTag == other._idTag and
        self._numRetries == other._numRetries and
        self._parallel == other._parallel and
        self._position == other._position and
        self._actions == other._actions)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._idTag, 'I') +
      msgbuffers.size(self._numRetries, 'B') +
      msgbuffers.size(self._parallel, 'b') +
      msgbuffers.size(self._position, 'B') +
      msgbuffers.size_object_varray(self._actions, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, numRetries={numRetries}, parallel={parallel}, position={position}, actions={actions})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      idTag=self._idTag,
      numRetries=self._numRetries,
      parallel=self._parallel,
      position=self._position,
      actions=msgbuffers.shorten_sequence(self._actions))

  def __repr__(self):
    return '{type}(robotID={robotID}, idTag={idTag}, numRetries={numRetries}, parallel={parallel}, position={position}, actions={actions})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      idTag=repr(self._idTag),
      numRetries=repr(self._numRetries),
      parallel=repr(self._parallel),
      position=repr(self._position),
      actions=repr(self._actions))

Anki.Cozmo.ExternalInterface.QueueCompoundAction = QueueCompoundAction
del QueueCompoundAction


class ImageRequest(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
    '_mode',    # Anki.Cozmo.ImageSendMode
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ImageRequest.robotID', value, 0, 255)

  @property
  def mode(self):
    "Anki.Cozmo.ImageSendMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'ImageRequest.mode', value, 0, 255)

  def __init__(self, robotID=0, mode=Anki.Cozmo.ImageSendMode.Off):
    self.robotID = robotID
    self.mode = mode

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ImageRequest from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ImageRequest.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ImageRequest from the given BinaryReader."
    _robotID = reader.read('B')
    _mode = reader.read('B')
    return cls(_robotID, _mode)

  def pack(self):
    "Writes the current ImageRequest, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ImageRequest to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._mode, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._mode == other._mode)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._mode, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, mode={mode})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      mode=self._mode)

  def __repr__(self):
    return '{type}(robotID={robotID}, mode={mode})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      mode=repr(self._mode))

Anki.Cozmo.ExternalInterface.ImageRequest = ImageRequest
del ImageRequest


class SetRobotImageSendMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',    # uint_8
    '_mode',       # Anki.Cozmo.ImageSendMode
    '_resolution', # Anki.Cozmo.ImageResolution
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetRobotImageSendMode.robotID', value, 0, 255)

  @property
  def mode(self):
    "Anki.Cozmo.ImageSendMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'SetRobotImageSendMode.mode', value, 0, 255)

  @property
  def resolution(self):
    "Anki.Cozmo.ImageResolution resolution struct property."
    return self._resolution

  @resolution.setter
  def resolution(self, value):
    self._resolution = msgbuffers.validate_integer(
      'SetRobotImageSendMode.resolution', value, -128, 127)

  def __init__(self, robotID=0, mode=Anki.Cozmo.ImageSendMode.Off, resolution=Anki.Cozmo.ImageResolution.VerificationSnapshot):
    self.robotID = robotID
    self.mode = mode
    self.resolution = resolution

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetRobotImageSendMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetRobotImageSendMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetRobotImageSendMode from the given BinaryReader."
    _robotID = reader.read('B')
    _mode = reader.read('B')
    _resolution = reader.read('b')
    return cls(_robotID, _mode, _resolution)

  def pack(self):
    "Writes the current SetRobotImageSendMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetRobotImageSendMode to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._mode, 'B')
    writer.write(self._resolution, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._mode == other._mode and
        self._resolution == other._resolution)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._mode, 'B') +
      msgbuffers.size(self._resolution, 'b'))

  def __str__(self):
    return '{type}(robotID={robotID}, mode={mode}, resolution={resolution})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      mode=self._mode,
      resolution=self._resolution)

  def __repr__(self):
    return '{type}(robotID={robotID}, mode={mode}, resolution={resolution})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      mode=repr(self._mode),
      resolution=repr(self._resolution))

Anki.Cozmo.ExternalInterface.SetRobotImageSendMode = SetRobotImageSendMode
del SetRobotImageSendMode


class SaveImages(object):
  "Generated message-passing message."

  __slots__ = (
    '_mode', # Anki.Cozmo.ImageSendMode
    '_path', # string[uint_8]
  )

  @property
  def mode(self):
    "Anki.Cozmo.ImageSendMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'SaveImages.mode', value, 0, 255)

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'SaveImages.path', value, 255)

  def __init__(self, mode=Anki.Cozmo.ImageSendMode.Off, path=''):
    self.mode = mode
    self.path = path

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveImages from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveImages.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveImages from the given BinaryReader."
    _mode = reader.read('B')
    _path = reader.read_string('B')
    return cls(_mode, _path)

  def pack(self):
    "Writes the current SaveImages, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveImages to the given BinaryWriter."
    writer.write(self._mode, 'B')
    writer.write_string(self._path, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._mode == other._mode and
        self._path == other._path)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._mode, 'B') +
      msgbuffers.size_string(self._path, 'B'))

  def __str__(self):
    return '{type}(mode={mode}, path={path})'.format(
      type=type(self).__name__,
      mode=self._mode,
      path=msgbuffers.shorten_string(self._path))

  def __repr__(self):
    return '{type}(mode={mode}, path={path})'.format(
      type=type(self).__name__,
      mode=repr(self._mode),
      path=repr(self._path))

Anki.Cozmo.ExternalInterface.SaveImages = SaveImages
del SaveImages


class SaveRobotState(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
    '_path',    # string[uint_8]
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'SaveRobotState.enabled', value)

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'SaveRobotState.path', value, 255)

  def __init__(self, enabled=False, path=''):
    self.enabled = enabled
    self.path = path

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveRobotState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveRobotState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveRobotState from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    _path = reader.read_string('B')
    return cls(_enabled, _path)

  def pack(self):
    "Writes the current SaveRobotState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveRobotState to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')
    writer.write_string(self._path, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enabled == other._enabled and
        self._path == other._path)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b') +
      msgbuffers.size_string(self._path, 'B'))

  def __str__(self):
    return '{type}(enabled={enabled}, path={path})'.format(
      type=type(self).__name__,
      enabled=self._enabled,
      path=msgbuffers.shorten_string(self._path))

  def __repr__(self):
    return '{type}(enabled={enabled}, path={path})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled),
      path=repr(self._path))

Anki.Cozmo.ExternalInterface.SaveRobotState = SaveRobotState
del SaveRobotState


class EnableDisplay(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # uint_8
  )

  @property
  def enable(self):
    "uint_8 enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_integer(
      'EnableDisplay.enable', value, 0, 255)

  def __init__(self, enable=0):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableDisplay from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableDisplay.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableDisplay from the given BinaryReader."
    _enable = reader.read('B')
    return cls(_enable)

  def pack(self):
    "Writes the current EnableDisplay, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableDisplay to the given BinaryWriter."
    writer.write(self._enable, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'B'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableDisplay = EnableDisplay
del EnableDisplay


class ExecuteTestPlan(object):
  "Generated message-passing message."

  __slots__ = (
    '_motionProf', # Anki.Cozmo.PathMotionProfile
  )

  @property
  def motionProf(self):
    "Anki.Cozmo.PathMotionProfile motionProf struct property."
    return self._motionProf

  @motionProf.setter
  def motionProf(self, value):
    self._motionProf = msgbuffers.validate_object(
      'ExecuteTestPlan.motionProf', value, Anki.Cozmo.PathMotionProfile)

  def __init__(self, motionProf=Anki.Cozmo.PathMotionProfile()):
    self.motionProf = motionProf

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ExecuteTestPlan from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ExecuteTestPlan.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ExecuteTestPlan from the given BinaryReader."
    _motionProf = reader.read_object(Anki.Cozmo.PathMotionProfile.unpack_from)
    return cls(_motionProf)

  def pack(self):
    "Writes the current ExecuteTestPlan, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ExecuteTestPlan to the given BinaryWriter."
    writer.write_object(self._motionProf)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._motionProf == other._motionProf
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._motionProf))

  def __str__(self):
    return '{type}(motionProf={motionProf})'.format(
      type=type(self).__name__,
      motionProf=self._motionProf)

  def __repr__(self):
    return '{type}(motionProf={motionProf})'.format(
      type=type(self).__name__,
      motionProf=repr(self._motionProf))

Anki.Cozmo.ExternalInterface.ExecuteTestPlan = ExecuteTestPlan
del ExecuteTestPlan


class PlannerRunMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_isSync', # bool
  )

  @property
  def isSync(self):
    "bool isSync struct property."
    return self._isSync

  @isSync.setter
  def isSync(self, value):
    self._isSync = msgbuffers.validate_bool(
      'PlannerRunMode.isSync', value)

  def __init__(self, isSync=False):
    self.isSync = isSync

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PlannerRunMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PlannerRunMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PlannerRunMode from the given BinaryReader."
    _isSync = bool(reader.read('b'))
    return cls(_isSync)

  def pack(self):
    "Writes the current PlannerRunMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PlannerRunMode to the given BinaryWriter."
    writer.write(int(self._isSync), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._isSync == other._isSync
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isSync, 'b'))

  def __str__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=self._isSync)

  def __repr__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=repr(self._isSync))

Anki.Cozmo.ExternalInterface.PlannerRunMode = PlannerRunMode
del PlannerRunMode


class SelectNextObject(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SelectNextObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SelectNextObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SelectNextObject from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current SelectNextObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SelectNextObject to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.SelectNextObject = SelectNextObject
del SelectNextObject


class SetRobotCarryingObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID', # int_32
    '_robotID',  # uint_8
  )

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'SetRobotCarryingObject.objectID', value, -2147483648, 2147483647)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetRobotCarryingObject.robotID', value, 0, 255)

  def __init__(self, objectID=0, robotID=0):
    self.objectID = objectID
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetRobotCarryingObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetRobotCarryingObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetRobotCarryingObject from the given BinaryReader."
    _objectID = reader.read('i')
    _robotID = reader.read('B')
    return cls(_objectID, _robotID)

  def pack(self):
    "Writes the current SetRobotCarryingObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetRobotCarryingObject to the given BinaryWriter."
    writer.write(self._objectID, 'i')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'i') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(objectID={objectID}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(objectID={objectID}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.SetRobotCarryingObject = SetRobotCarryingObject
del SetRobotCarryingObject


class CreateFixedCustomObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_pose',     # Anki.PoseStruct3d
    '_xSize_mm', # float_32
    '_ySize_mm', # float_32
    '_zSize_mm', # float_32
  )

  @property
  def pose(self):
    "Anki.PoseStruct3d pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_object(
      'CreateFixedCustomObject.pose', value, Anki.PoseStruct3d)

  @property
  def xSize_mm(self):
    "float_32 xSize_mm struct property."
    return self._xSize_mm

  @xSize_mm.setter
  def xSize_mm(self, value):
    self._xSize_mm = msgbuffers.validate_float(
      'CreateFixedCustomObject.xSize_mm', value, 'f')

  @property
  def ySize_mm(self):
    "float_32 ySize_mm struct property."
    return self._ySize_mm

  @ySize_mm.setter
  def ySize_mm(self, value):
    self._ySize_mm = msgbuffers.validate_float(
      'CreateFixedCustomObject.ySize_mm', value, 'f')

  @property
  def zSize_mm(self):
    "float_32 zSize_mm struct property."
    return self._zSize_mm

  @zSize_mm.setter
  def zSize_mm(self, value):
    self._zSize_mm = msgbuffers.validate_float(
      'CreateFixedCustomObject.zSize_mm', value, 'f')

  def __init__(self, pose=Anki.PoseStruct3d(), xSize_mm=0.0, ySize_mm=0.0, zSize_mm=0.0):
    self.pose = pose
    self.xSize_mm = xSize_mm
    self.ySize_mm = ySize_mm
    self.zSize_mm = zSize_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CreateFixedCustomObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CreateFixedCustomObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CreateFixedCustomObject from the given BinaryReader."
    _pose = reader.read_object(Anki.PoseStruct3d.unpack_from)
    _xSize_mm = reader.read('f')
    _ySize_mm = reader.read('f')
    _zSize_mm = reader.read('f')
    return cls(_pose, _xSize_mm, _ySize_mm, _zSize_mm)

  def pack(self):
    "Writes the current CreateFixedCustomObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CreateFixedCustomObject to the given BinaryWriter."
    writer.write_object(self._pose)
    writer.write(self._xSize_mm, 'f')
    writer.write(self._ySize_mm, 'f')
    writer.write(self._zSize_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._pose == other._pose and
        self._xSize_mm == other._xSize_mm and
        self._ySize_mm == other._ySize_mm and
        self._zSize_mm == other._zSize_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._pose) +
      msgbuffers.size(self._xSize_mm, 'f') +
      msgbuffers.size(self._ySize_mm, 'f') +
      msgbuffers.size(self._zSize_mm, 'f'))

  def __str__(self):
    return '{type}(pose={pose}, xSize_mm={xSize_mm}, ySize_mm={ySize_mm}, zSize_mm={zSize_mm})'.format(
      type=type(self).__name__,
      pose=self._pose,
      xSize_mm=self._xSize_mm,
      ySize_mm=self._ySize_mm,
      zSize_mm=self._zSize_mm)

  def __repr__(self):
    return '{type}(pose={pose}, xSize_mm={xSize_mm}, ySize_mm={ySize_mm}, zSize_mm={zSize_mm})'.format(
      type=type(self).__name__,
      pose=repr(self._pose),
      xSize_mm=repr(self._xSize_mm),
      ySize_mm=repr(self._ySize_mm),
      zSize_mm=repr(self._zSize_mm))

Anki.Cozmo.ExternalInterface.CreateFixedCustomObject = CreateFixedCustomObject
del CreateFixedCustomObject


class DefineCustomObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectType',      # Anki.Cozmo.ObjectType
    '_xSize_mm',        # float_32
    '_ySize_mm',        # float_32
    '_zSize_mm',        # float_32
    '_markerWidth_mm',  # float_32
    '_markerHeight_mm', # float_32
  )

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'DefineCustomObject.objectType', value, -2147483648, 2147483647)

  @property
  def xSize_mm(self):
    "float_32 xSize_mm struct property."
    return self._xSize_mm

  @xSize_mm.setter
  def xSize_mm(self, value):
    self._xSize_mm = msgbuffers.validate_float(
      'DefineCustomObject.xSize_mm', value, 'f')

  @property
  def ySize_mm(self):
    "float_32 ySize_mm struct property."
    return self._ySize_mm

  @ySize_mm.setter
  def ySize_mm(self, value):
    self._ySize_mm = msgbuffers.validate_float(
      'DefineCustomObject.ySize_mm', value, 'f')

  @property
  def zSize_mm(self):
    "float_32 zSize_mm struct property."
    return self._zSize_mm

  @zSize_mm.setter
  def zSize_mm(self, value):
    self._zSize_mm = msgbuffers.validate_float(
      'DefineCustomObject.zSize_mm', value, 'f')

  @property
  def markerWidth_mm(self):
    "float_32 markerWidth_mm struct property."
    return self._markerWidth_mm

  @markerWidth_mm.setter
  def markerWidth_mm(self, value):
    self._markerWidth_mm = msgbuffers.validate_float(
      'DefineCustomObject.markerWidth_mm', value, 'f')

  @property
  def markerHeight_mm(self):
    "float_32 markerHeight_mm struct property."
    return self._markerHeight_mm

  @markerHeight_mm.setter
  def markerHeight_mm(self, value):
    self._markerHeight_mm = msgbuffers.validate_float(
      'DefineCustomObject.markerHeight_mm', value, 'f')

  def __init__(self, objectType=Anki.Cozmo.ObjectType.Invalid, xSize_mm=0.0, ySize_mm=0.0, zSize_mm=0.0, markerWidth_mm=0.0, markerHeight_mm=0.0):
    self.objectType = objectType
    self.xSize_mm = xSize_mm
    self.ySize_mm = ySize_mm
    self.zSize_mm = zSize_mm
    self.markerWidth_mm = markerWidth_mm
    self.markerHeight_mm = markerHeight_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DefineCustomObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DefineCustomObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DefineCustomObject from the given BinaryReader."
    _objectType = reader.read('i')
    _xSize_mm = reader.read('f')
    _ySize_mm = reader.read('f')
    _zSize_mm = reader.read('f')
    _markerWidth_mm = reader.read('f')
    _markerHeight_mm = reader.read('f')
    return cls(_objectType, _xSize_mm, _ySize_mm, _zSize_mm, _markerWidth_mm, _markerHeight_mm)

  def pack(self):
    "Writes the current DefineCustomObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DefineCustomObject to the given BinaryWriter."
    writer.write(self._objectType, 'i')
    writer.write(self._xSize_mm, 'f')
    writer.write(self._ySize_mm, 'f')
    writer.write(self._zSize_mm, 'f')
    writer.write(self._markerWidth_mm, 'f')
    writer.write(self._markerHeight_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectType == other._objectType and
        self._xSize_mm == other._xSize_mm and
        self._ySize_mm == other._ySize_mm and
        self._zSize_mm == other._zSize_mm and
        self._markerWidth_mm == other._markerWidth_mm and
        self._markerHeight_mm == other._markerHeight_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size(self._xSize_mm, 'f') +
      msgbuffers.size(self._ySize_mm, 'f') +
      msgbuffers.size(self._zSize_mm, 'f') +
      msgbuffers.size(self._markerWidth_mm, 'f') +
      msgbuffers.size(self._markerHeight_mm, 'f'))

  def __str__(self):
    return '{type}(objectType={objectType}, xSize_mm={xSize_mm}, ySize_mm={ySize_mm}, zSize_mm={zSize_mm}, markerWidth_mm={markerWidth_mm}, markerHeight_mm={markerHeight_mm})'.format(
      type=type(self).__name__,
      objectType=self._objectType,
      xSize_mm=self._xSize_mm,
      ySize_mm=self._ySize_mm,
      zSize_mm=self._zSize_mm,
      markerWidth_mm=self._markerWidth_mm,
      markerHeight_mm=self._markerHeight_mm)

  def __repr__(self):
    return '{type}(objectType={objectType}, xSize_mm={xSize_mm}, ySize_mm={ySize_mm}, zSize_mm={zSize_mm}, markerWidth_mm={markerWidth_mm}, markerHeight_mm={markerHeight_mm})'.format(
      type=type(self).__name__,
      objectType=repr(self._objectType),
      xSize_mm=repr(self._xSize_mm),
      ySize_mm=repr(self._ySize_mm),
      zSize_mm=repr(self._zSize_mm),
      markerWidth_mm=repr(self._markerWidth_mm),
      markerHeight_mm=repr(self._markerHeight_mm))

Anki.Cozmo.ExternalInterface.DefineCustomObject = DefineCustomObject
del DefineCustomObject


class ClearAllBlocks(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ClearAllBlocks.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ClearAllBlocks from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ClearAllBlocks.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ClearAllBlocks from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current ClearAllBlocks, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ClearAllBlocks to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.ClearAllBlocks = ClearAllBlocks
del ClearAllBlocks


class ClearAllObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ClearAllObjects.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ClearAllObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ClearAllObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ClearAllObjects from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current ClearAllObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ClearAllObjects to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.ClearAllObjects = ClearAllObjects
del ClearAllObjects


class DeleteAllObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'DeleteAllObjects.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DeleteAllObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DeleteAllObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DeleteAllObjects from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current DeleteAllObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DeleteAllObjects to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.DeleteAllObjects = DeleteAllObjects
del DeleteAllObjects


class DeleteAllCustomObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'DeleteAllCustomObjects.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DeleteAllCustomObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DeleteAllCustomObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DeleteAllCustomObjects from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current DeleteAllCustomObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DeleteAllCustomObjects to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects = DeleteAllCustomObjects
del DeleteAllCustomObjects


class SetObjectAdditionAndDeletion(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',        # uint_8
    '_enableAddition', # bool
    '_enableDeletion', # bool
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetObjectAdditionAndDeletion.robotID', value, 0, 255)

  @property
  def enableAddition(self):
    "bool enableAddition struct property."
    return self._enableAddition

  @enableAddition.setter
  def enableAddition(self, value):
    self._enableAddition = msgbuffers.validate_bool(
      'SetObjectAdditionAndDeletion.enableAddition', value)

  @property
  def enableDeletion(self):
    "bool enableDeletion struct property."
    return self._enableDeletion

  @enableDeletion.setter
  def enableDeletion(self, value):
    self._enableDeletion = msgbuffers.validate_bool(
      'SetObjectAdditionAndDeletion.enableDeletion', value)

  def __init__(self, robotID=0, enableAddition=False, enableDeletion=False):
    self.robotID = robotID
    self.enableAddition = enableAddition
    self.enableDeletion = enableDeletion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetObjectAdditionAndDeletion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetObjectAdditionAndDeletion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetObjectAdditionAndDeletion from the given BinaryReader."
    _robotID = reader.read('B')
    _enableAddition = bool(reader.read('b'))
    _enableDeletion = bool(reader.read('b'))
    return cls(_robotID, _enableAddition, _enableDeletion)

  def pack(self):
    "Writes the current SetObjectAdditionAndDeletion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetObjectAdditionAndDeletion to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(int(self._enableAddition), 'b')
    writer.write(int(self._enableDeletion), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._enableAddition == other._enableAddition and
        self._enableDeletion == other._enableDeletion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._enableAddition, 'b') +
      msgbuffers.size(self._enableDeletion, 'b'))

  def __str__(self):
    return '{type}(robotID={robotID}, enableAddition={enableAddition}, enableDeletion={enableDeletion})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      enableAddition=self._enableAddition,
      enableDeletion=self._enableDeletion)

  def __repr__(self):
    return '{type}(robotID={robotID}, enableAddition={enableAddition}, enableDeletion={enableDeletion})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      enableAddition=repr(self._enableAddition),
      enableDeletion=repr(self._enableDeletion))

Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion = SetObjectAdditionAndDeletion
del SetObjectAdditionAndDeletion


class VisionWhileMoving(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # uint_8
  )

  @property
  def enable(self):
    "uint_8 enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_integer(
      'VisionWhileMoving.enable', value, 0, 255)

  def __init__(self, enable=0):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisionWhileMoving from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisionWhileMoving.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisionWhileMoving from the given BinaryReader."
    _enable = reader.read('B')
    return cls(_enable)

  def pack(self):
    "Writes the current VisionWhileMoving, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisionWhileMoving to the given BinaryWriter."
    writer.write(self._enable, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'B'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.VisionWhileMoving = VisionWhileMoving
del VisionWhileMoving


class SetFaceEnrollmentPose(object):
  "Generated message-passing message."

  __slots__ = (
    '_pose', # Anki.Vision.FaceEnrollmentPose
  )

  @property
  def pose(self):
    "Anki.Vision.FaceEnrollmentPose pose struct property."
    return self._pose

  @pose.setter
  def pose(self, value):
    self._pose = msgbuffers.validate_integer(
      'SetFaceEnrollmentPose.pose', value, 0, 255)

  def __init__(self, pose=Anki.Vision.FaceEnrollmentPose.LookingStraight):
    self.pose = pose

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetFaceEnrollmentPose from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetFaceEnrollmentPose.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetFaceEnrollmentPose from the given BinaryReader."
    _pose = reader.read('B')
    return cls(_pose)

  def pack(self):
    "Writes the current SetFaceEnrollmentPose, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetFaceEnrollmentPose to the given BinaryWriter."
    writer.write(self._pose, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._pose == other._pose
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._pose, 'B'))

  def __str__(self):
    return '{type}(pose={pose})'.format(
      type=type(self).__name__,
      pose=self._pose)

  def __repr__(self):
    return '{type}(pose={pose})'.format(
      type=type(self).__name__,
      pose=repr(self._pose))

Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose = SetFaceEnrollmentPose
del SetFaceEnrollmentPose


class EraseEnrolledFaceByID(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID', # int_32
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'EraseEnrolledFaceByID.faceID', value, -2147483648, 2147483647)

  def __init__(self, faceID=0):
    self.faceID = faceID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseEnrolledFaceByID from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseEnrolledFaceByID.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseEnrolledFaceByID from the given BinaryReader."
    _faceID = reader.read('i')
    return cls(_faceID)

  def pack(self):
    "Writes the current EraseEnrolledFaceByID, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseEnrolledFaceByID to the given BinaryWriter."
    writer.write(self._faceID, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._faceID == other._faceID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i'))

  def __str__(self):
    return '{type}(faceID={faceID})'.format(
      type=type(self).__name__,
      faceID=self._faceID)

  def __repr__(self):
    return '{type}(faceID={faceID})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID))

Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID = EraseEnrolledFaceByID
del EraseEnrolledFaceByID


class EraseAllEnrolledFaces(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseAllEnrolledFaces from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseAllEnrolledFaces.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseAllEnrolledFaces from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current EraseAllEnrolledFaces, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseAllEnrolledFaces to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces = EraseAllEnrolledFaces
del EraseAllEnrolledFaces


class EnableVisionMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_mode',   # Anki.Cozmo.VisionMode
    '_enable', # bool
  )

  @property
  def mode(self):
    "Anki.Cozmo.VisionMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'EnableVisionMode.mode', value, 0, 65535)

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableVisionMode.enable', value)

  def __init__(self, mode=Anki.Cozmo.VisionMode.Idle, enable=False):
    self.mode = mode
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableVisionMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableVisionMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableVisionMode from the given BinaryReader."
    _mode = reader.read('H')
    _enable = bool(reader.read('b'))
    return cls(_mode, _enable)

  def pack(self):
    "Writes the current EnableVisionMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableVisionMode to the given BinaryWriter."
    writer.write(self._mode, 'H')
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._mode == other._mode and
        self._enable == other._enable)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._mode, 'H') +
      msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(mode={mode}, enable={enable})'.format(
      type=type(self).__name__,
      mode=self._mode,
      enable=self._enable)

  def __repr__(self):
    return '{type}(mode={mode}, enable={enable})'.format(
      type=type(self).__name__,
      mode=repr(self._mode),
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableVisionMode = EnableVisionMode
del EnableVisionMode


class UpdateEnrolledFaceByID(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID',  # int_32
    '_oldName', # string[uint_8]
    '_newName', # string[uint_8]
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'UpdateEnrolledFaceByID.faceID', value, -2147483648, 2147483647)

  @property
  def oldName(self):
    "string[uint_8] oldName struct property."
    return self._oldName

  @oldName.setter
  def oldName(self, value):
    self._oldName = msgbuffers.validate_string(
      'UpdateEnrolledFaceByID.oldName', value, 255)

  @property
  def newName(self):
    "string[uint_8] newName struct property."
    return self._newName

  @newName.setter
  def newName(self, value):
    self._newName = msgbuffers.validate_string(
      'UpdateEnrolledFaceByID.newName', value, 255)

  def __init__(self, faceID=0, oldName='', newName=''):
    self.faceID = faceID
    self.oldName = oldName
    self.newName = newName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UpdateEnrolledFaceByID from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UpdateEnrolledFaceByID.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UpdateEnrolledFaceByID from the given BinaryReader."
    _faceID = reader.read('i')
    _oldName = reader.read_string('B')
    _newName = reader.read_string('B')
    return cls(_faceID, _oldName, _newName)

  def pack(self):
    "Writes the current UpdateEnrolledFaceByID, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UpdateEnrolledFaceByID to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write_string(self._oldName, 'B')
    writer.write_string(self._newName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._oldName == other._oldName and
        self._newName == other._newName)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size_string(self._oldName, 'B') +
      msgbuffers.size_string(self._newName, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, oldName={oldName}, newName={newName})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      oldName=msgbuffers.shorten_string(self._oldName),
      newName=msgbuffers.shorten_string(self._newName))

  def __repr__(self):
    return '{type}(faceID={faceID}, oldName={oldName}, newName={newName})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      oldName=repr(self._oldName),
      newName=repr(self._newName))

Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID = UpdateEnrolledFaceByID
del UpdateEnrolledFaceByID


class VisionRunMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_isSync', # bool
  )

  @property
  def isSync(self):
    "bool isSync struct property."
    return self._isSync

  @isSync.setter
  def isSync(self, value):
    self._isSync = msgbuffers.validate_bool(
      'VisionRunMode.isSync', value)

  def __init__(self, isSync=False):
    self.isSync = isSync

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisionRunMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisionRunMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisionRunMode from the given BinaryReader."
    _isSync = bool(reader.read('b'))
    return cls(_isSync)

  def pack(self):
    "Writes the current VisionRunMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisionRunMode to the given BinaryWriter."
    writer.write(int(self._isSync), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._isSync == other._isSync
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isSync, 'b'))

  def __str__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=self._isSync)

  def __repr__(self):
    return '{type}(isSync={isSync})'.format(
      type=type(self).__name__,
      isSync=repr(self._isSync))

Anki.Cozmo.ExternalInterface.VisionRunMode = VisionRunMode
del VisionRunMode


class SaveFaceAlbumToFile(object):
  "Generated message-passing message."

  __slots__ = (
    '_path',           # string[uint_8]
    '_isRelativePath', # bool
  )

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'SaveFaceAlbumToFile.path', value, 255)

  @property
  def isRelativePath(self):
    "bool isRelativePath struct property."
    return self._isRelativePath

  @isRelativePath.setter
  def isRelativePath(self, value):
    self._isRelativePath = msgbuffers.validate_bool(
      'SaveFaceAlbumToFile.isRelativePath', value)

  def __init__(self, path='', isRelativePath=True):
    self.path = path
    self.isRelativePath = isRelativePath

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveFaceAlbumToFile from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveFaceAlbumToFile.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveFaceAlbumToFile from the given BinaryReader."
    _path = reader.read_string('B')
    _isRelativePath = bool(reader.read('b'))
    return cls(_path, _isRelativePath)

  def pack(self):
    "Writes the current SaveFaceAlbumToFile, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveFaceAlbumToFile to the given BinaryWriter."
    writer.write_string(self._path, 'B')
    writer.write(int(self._isRelativePath), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._path == other._path and
        self._isRelativePath == other._isRelativePath)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._path, 'B') +
      msgbuffers.size(self._isRelativePath, 'b'))

  def __str__(self):
    return '{type}(path={path}, isRelativePath={isRelativePath})'.format(
      type=type(self).__name__,
      path=msgbuffers.shorten_string(self._path),
      isRelativePath=self._isRelativePath)

  def __repr__(self):
    return '{type}(path={path}, isRelativePath={isRelativePath})'.format(
      type=type(self).__name__,
      path=repr(self._path),
      isRelativePath=repr(self._isRelativePath))

Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile = SaveFaceAlbumToFile
del SaveFaceAlbumToFile


class LoadFaceAlbumFromFile(object):
  "Generated message-passing message."

  __slots__ = (
    '_path',           # string[uint_8]
    '_isRelativePath', # bool
  )

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'LoadFaceAlbumFromFile.path', value, 255)

  @property
  def isRelativePath(self):
    "bool isRelativePath struct property."
    return self._isRelativePath

  @isRelativePath.setter
  def isRelativePath(self, value):
    self._isRelativePath = msgbuffers.validate_bool(
      'LoadFaceAlbumFromFile.isRelativePath', value)

  def __init__(self, path='', isRelativePath=True):
    self.path = path
    self.isRelativePath = isRelativePath

  @classmethod
  def unpack(cls, buffer):
    "Reads a new LoadFaceAlbumFromFile from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('LoadFaceAlbumFromFile.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new LoadFaceAlbumFromFile from the given BinaryReader."
    _path = reader.read_string('B')
    _isRelativePath = bool(reader.read('b'))
    return cls(_path, _isRelativePath)

  def pack(self):
    "Writes the current LoadFaceAlbumFromFile, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current LoadFaceAlbumFromFile to the given BinaryWriter."
    writer.write_string(self._path, 'B')
    writer.write(int(self._isRelativePath), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._path == other._path and
        self._isRelativePath == other._isRelativePath)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._path, 'B') +
      msgbuffers.size(self._isRelativePath, 'b'))

  def __str__(self):
    return '{type}(path={path}, isRelativePath={isRelativePath})'.format(
      type=type(self).__name__,
      path=msgbuffers.shorten_string(self._path),
      isRelativePath=self._isRelativePath)

  def __repr__(self):
    return '{type}(path={path}, isRelativePath={isRelativePath})'.format(
      type=type(self).__name__,
      path=repr(self._path),
      isRelativePath=repr(self._isRelativePath))

Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile = LoadFaceAlbumFromFile
del LoadFaceAlbumFromFile


class SetMemoryMapRenderEnabled(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'SetMemoryMapRenderEnabled.enabled', value)

  def __init__(self, enabled=False):
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetMemoryMapRenderEnabled from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetMemoryMapRenderEnabled.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetMemoryMapRenderEnabled from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    return cls(_enabled)

  def pack(self):
    "Writes the current SetMemoryMapRenderEnabled, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetMemoryMapRenderEnabled to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enabled == other._enabled
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled))

Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled = SetMemoryMapRenderEnabled
del SetMemoryMapRenderEnabled


class ActivateBehaviorChooser(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviorChooserType', # Anki.Cozmo.BehaviorChooserType
  )

  @property
  def behaviorChooserType(self):
    "Anki.Cozmo.BehaviorChooserType behaviorChooserType struct property."
    return self._behaviorChooserType

  @behaviorChooserType.setter
  def behaviorChooserType(self, value):
    self._behaviorChooserType = msgbuffers.validate_integer(
      'ActivateBehaviorChooser.behaviorChooserType', value, 0, 255)

  def __init__(self, behaviorChooserType=Anki.Cozmo.BehaviorChooserType.Freeplay):
    self.behaviorChooserType = behaviorChooserType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ActivateBehaviorChooser from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ActivateBehaviorChooser.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ActivateBehaviorChooser from the given BinaryReader."
    _behaviorChooserType = reader.read('B')
    return cls(_behaviorChooserType)

  def pack(self):
    "Writes the current ActivateBehaviorChooser, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ActivateBehaviorChooser to the given BinaryWriter."
    writer.write(self._behaviorChooserType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviorChooserType == other._behaviorChooserType
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._behaviorChooserType, 'B'))

  def __str__(self):
    return '{type}(behaviorChooserType={behaviorChooserType})'.format(
      type=type(self).__name__,
      behaviorChooserType=self._behaviorChooserType)

  def __repr__(self):
    return '{type}(behaviorChooserType={behaviorChooserType})'.format(
      type=type(self).__name__,
      behaviorChooserType=repr(self._behaviorChooserType))

Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser = ActivateBehaviorChooser
del ActivateBehaviorChooser


class ExecuteBehavior(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviorType', # Anki.Cozmo.BehaviorType
  )

  @property
  def behaviorType(self):
    "Anki.Cozmo.BehaviorType behaviorType struct property."
    return self._behaviorType

  @behaviorType.setter
  def behaviorType(self, value):
    self._behaviorType = msgbuffers.validate_integer(
      'ExecuteBehavior.behaviorType', value, 0, 255)

  def __init__(self, behaviorType=Anki.Cozmo.BehaviorType.NoneBehavior):
    self.behaviorType = behaviorType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ExecuteBehavior from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ExecuteBehavior.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ExecuteBehavior from the given BinaryReader."
    _behaviorType = reader.read('B')
    return cls(_behaviorType)

  def pack(self):
    "Writes the current ExecuteBehavior, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ExecuteBehavior to the given BinaryWriter."
    writer.write(self._behaviorType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviorType == other._behaviorType
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._behaviorType, 'B'))

  def __str__(self):
    return '{type}(behaviorType={behaviorType})'.format(
      type=type(self).__name__,
      behaviorType=self._behaviorType)

  def __repr__(self):
    return '{type}(behaviorType={behaviorType})'.format(
      type=type(self).__name__,
      behaviorType=repr(self._behaviorType))

Anki.Cozmo.ExternalInterface.ExecuteBehavior = ExecuteBehavior
del ExecuteBehavior


class ExecuteBehaviorByExecutableType(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviorType', # Anki.Cozmo.ExecutableBehaviorType
  )

  @property
  def behaviorType(self):
    "Anki.Cozmo.ExecutableBehaviorType behaviorType struct property."
    return self._behaviorType

  @behaviorType.setter
  def behaviorType(self, value):
    self._behaviorType = msgbuffers.validate_integer(
      'ExecuteBehaviorByExecutableType.behaviorType', value, 0, 255)

  def __init__(self, behaviorType=Anki.Cozmo.ExecutableBehaviorType.NoneBehavior):
    self.behaviorType = behaviorType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ExecuteBehaviorByExecutableType from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ExecuteBehaviorByExecutableType.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ExecuteBehaviorByExecutableType from the given BinaryReader."
    _behaviorType = reader.read('B')
    return cls(_behaviorType)

  def pack(self):
    "Writes the current ExecuteBehaviorByExecutableType, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ExecuteBehaviorByExecutableType to the given BinaryWriter."
    writer.write(self._behaviorType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviorType == other._behaviorType
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._behaviorType, 'B'))

  def __str__(self):
    return '{type}(behaviorType={behaviorType})'.format(
      type=type(self).__name__,
      behaviorType=self._behaviorType)

  def __repr__(self):
    return '{type}(behaviorType={behaviorType})'.format(
      type=type(self).__name__,
      behaviorType=repr(self._behaviorType))

Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType = ExecuteBehaviorByExecutableType
del ExecuteBehaviorByExecutableType


class ExecuteBehaviorByName(object):
  "Generated message-passing message."

  __slots__ = (
    '_behaviorName', # string[uint_8]
  )

  @property
  def behaviorName(self):
    "string[uint_8] behaviorName struct property."
    return self._behaviorName

  @behaviorName.setter
  def behaviorName(self, value):
    self._behaviorName = msgbuffers.validate_string(
      'ExecuteBehaviorByName.behaviorName', value, 255)

  def __init__(self, behaviorName=''):
    self.behaviorName = behaviorName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ExecuteBehaviorByName from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ExecuteBehaviorByName.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ExecuteBehaviorByName from the given BinaryReader."
    _behaviorName = reader.read_string('B')
    return cls(_behaviorName)

  def pack(self):
    "Writes the current ExecuteBehaviorByName, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ExecuteBehaviorByName to the given BinaryWriter."
    writer.write_string(self._behaviorName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._behaviorName == other._behaviorName
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._behaviorName, 'B'))

  def __str__(self):
    return '{type}(behaviorName={behaviorName})'.format(
      type=type(self).__name__,
      behaviorName=msgbuffers.shorten_string(self._behaviorName))

  def __repr__(self):
    return '{type}(behaviorName={behaviorName})'.format(
      type=type(self).__name__,
      behaviorName=repr(self._behaviorName))

Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName = ExecuteBehaviorByName
del ExecuteBehaviorByName


class BehaviorManagerMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',                     # uint_8
    '_BehaviorManagerMessageUnion', # Anki.Cozmo.ExternalInterface.BehaviorManagerMessageUnion
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'BehaviorManagerMessage.robotID', value, 0, 255)

  @property
  def BehaviorManagerMessageUnion(self):
    "Anki.Cozmo.ExternalInterface.BehaviorManagerMessageUnion BehaviorManagerMessageUnion struct property."
    return self._BehaviorManagerMessageUnion

  @BehaviorManagerMessageUnion.setter
  def BehaviorManagerMessageUnion(self, value):
    self._BehaviorManagerMessageUnion = msgbuffers.validate_object(
      'BehaviorManagerMessage.BehaviorManagerMessageUnion', value, Anki.Cozmo.ExternalInterface.BehaviorManagerMessageUnion)

  def __init__(self, robotID=0, BehaviorManagerMessageUnion=Anki.Cozmo.ExternalInterface.BehaviorManagerMessageUnion()):
    self.robotID = robotID
    self.BehaviorManagerMessageUnion = BehaviorManagerMessageUnion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BehaviorManagerMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BehaviorManagerMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BehaviorManagerMessage from the given BinaryReader."
    _robotID = reader.read('B')
    _BehaviorManagerMessageUnion = reader.read_object(Anki.Cozmo.ExternalInterface.BehaviorManagerMessageUnion.unpack_from)
    return cls(_robotID, _BehaviorManagerMessageUnion)

  def pack(self):
    "Writes the current BehaviorManagerMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BehaviorManagerMessage to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write_object(self._BehaviorManagerMessageUnion)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._BehaviorManagerMessageUnion == other._BehaviorManagerMessageUnion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size_object(self._BehaviorManagerMessageUnion))

  def __str__(self):
    return '{type}(robotID={robotID}, BehaviorManagerMessageUnion={BehaviorManagerMessageUnion})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      BehaviorManagerMessageUnion=self._BehaviorManagerMessageUnion)

  def __repr__(self):
    return '{type}(robotID={robotID}, BehaviorManagerMessageUnion={BehaviorManagerMessageUnion})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      BehaviorManagerMessageUnion=repr(self._BehaviorManagerMessageUnion))

Anki.Cozmo.ExternalInterface.BehaviorManagerMessage = BehaviorManagerMessage
del BehaviorManagerMessage


class AbortPath(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AbortPath from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AbortPath.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AbortPath from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current AbortPath, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AbortPath to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.AbortPath = AbortPath
del AbortPath


class AbortAll(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AbortAll from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AbortAll.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AbortAll from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current AbortAll, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AbortAll to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.AbortAll = AbortAll
del AbortAll


class StartTestMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
    '_p1',      # int_32
    '_p2',      # int_32
    '_p3',      # int_32
    '_mode',    # Anki.Cozmo.TestMode
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'StartTestMode.robotID', value, 0, 255)

  @property
  def p1(self):
    "int_32 p1 struct property."
    return self._p1

  @p1.setter
  def p1(self, value):
    self._p1 = msgbuffers.validate_integer(
      'StartTestMode.p1', value, -2147483648, 2147483647)

  @property
  def p2(self):
    "int_32 p2 struct property."
    return self._p2

  @p2.setter
  def p2(self, value):
    self._p2 = msgbuffers.validate_integer(
      'StartTestMode.p2', value, -2147483648, 2147483647)

  @property
  def p3(self):
    "int_32 p3 struct property."
    return self._p3

  @p3.setter
  def p3(self, value):
    self._p3 = msgbuffers.validate_integer(
      'StartTestMode.p3', value, -2147483648, 2147483647)

  @property
  def mode(self):
    "Anki.Cozmo.TestMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'StartTestMode.mode', value, 0, 255)

  def __init__(self, robotID=0, p1=0, p2=0, p3=0, mode=Anki.Cozmo.TestMode.TM_NONE):
    self.robotID = robotID
    self.p1 = p1
    self.p2 = p2
    self.p3 = p3
    self.mode = mode

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StartTestMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StartTestMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StartTestMode from the given BinaryReader."
    _robotID = reader.read('B')
    _p1 = reader.read('i')
    _p2 = reader.read('i')
    _p3 = reader.read('i')
    _mode = reader.read('B')
    return cls(_robotID, _p1, _p2, _p3, _mode)

  def pack(self):
    "Writes the current StartTestMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StartTestMode to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._p1, 'i')
    writer.write(self._p2, 'i')
    writer.write(self._p3, 'i')
    writer.write(self._mode, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._p1 == other._p1 and
        self._p2 == other._p2 and
        self._p3 == other._p3 and
        self._mode == other._mode)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._p1, 'i') +
      msgbuffers.size(self._p2, 'i') +
      msgbuffers.size(self._p3, 'i') +
      msgbuffers.size(self._mode, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID}, p1={p1}, p2={p2}, p3={p3}, mode={mode})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      p1=self._p1,
      p2=self._p2,
      p3=self._p3,
      mode=self._mode)

  def __repr__(self):
    return '{type}(robotID={robotID}, p1={p1}, p2={p2}, p3={p3}, mode={mode})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      p1=repr(self._p1),
      p2=repr(self._p2),
      p3=repr(self._p3),
      mode=repr(self._mode))

Anki.Cozmo.ExternalInterface.StartTestMode = StartTestMode
del StartTestMode


class RequestEnabledBehaviorList(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestEnabledBehaviorList from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestEnabledBehaviorList.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestEnabledBehaviorList from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestEnabledBehaviorList, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestEnabledBehaviorList to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList = RequestEnabledBehaviorList
del RequestEnabledBehaviorList


class RequestEnableReactionaryBehavior(object):
  "Generated message-passing message."

  __slots__ = (
    '_requesterID', # string[uint_8]
    '_behavior',    # Anki.Cozmo.BehaviorType
    '_enable',      # bool
  )

  @property
  def requesterID(self):
    "string[uint_8] requesterID struct property."
    return self._requesterID

  @requesterID.setter
  def requesterID(self, value):
    self._requesterID = msgbuffers.validate_string(
      'RequestEnableReactionaryBehavior.requesterID', value, 255)

  @property
  def behavior(self):
    "Anki.Cozmo.BehaviorType behavior struct property."
    return self._behavior

  @behavior.setter
  def behavior(self, value):
    self._behavior = msgbuffers.validate_integer(
      'RequestEnableReactionaryBehavior.behavior', value, 0, 255)

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'RequestEnableReactionaryBehavior.enable', value)

  def __init__(self, requesterID='', behavior=Anki.Cozmo.BehaviorType.NoneBehavior, enable=False):
    self.requesterID = requesterID
    self.behavior = behavior
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestEnableReactionaryBehavior from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestEnableReactionaryBehavior.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestEnableReactionaryBehavior from the given BinaryReader."
    _requesterID = reader.read_string('B')
    _behavior = reader.read('B')
    _enable = bool(reader.read('b'))
    return cls(_requesterID, _behavior, _enable)

  def pack(self):
    "Writes the current RequestEnableReactionaryBehavior, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestEnableReactionaryBehavior to the given BinaryWriter."
    writer.write_string(self._requesterID, 'B')
    writer.write(self._behavior, 'B')
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._requesterID == other._requesterID and
        self._behavior == other._behavior and
        self._enable == other._enable)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._requesterID, 'B') +
      msgbuffers.size(self._behavior, 'B') +
      msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(requesterID={requesterID}, behavior={behavior}, enable={enable})'.format(
      type=type(self).__name__,
      requesterID=msgbuffers.shorten_string(self._requesterID),
      behavior=self._behavior,
      enable=self._enable)

  def __repr__(self):
    return '{type}(requesterID={requesterID}, behavior={behavior}, enable={enable})'.format(
      type=type(self).__name__,
      requesterID=repr(self._requesterID),
      behavior=repr(self._behavior),
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior = RequestEnableReactionaryBehavior
del RequestEnableReactionaryBehavior


class SetDefaultHeadAndLiftState(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable',     # bool
    '_headAngle',  # float_32
    '_liftHeight', # float_32
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'SetDefaultHeadAndLiftState.enable', value)

  @property
  def headAngle(self):
    "float_32 headAngle struct property."
    return self._headAngle

  @headAngle.setter
  def headAngle(self, value):
    self._headAngle = msgbuffers.validate_float(
      'SetDefaultHeadAndLiftState.headAngle', value, 'f')

  @property
  def liftHeight(self):
    "float_32 liftHeight struct property."
    return self._liftHeight

  @liftHeight.setter
  def liftHeight(self, value):
    self._liftHeight = msgbuffers.validate_float(
      'SetDefaultHeadAndLiftState.liftHeight', value, 'f')

  def __init__(self, enable=False, headAngle=0.0, liftHeight=0.0):
    self.enable = enable
    self.headAngle = headAngle
    self.liftHeight = liftHeight

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetDefaultHeadAndLiftState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetDefaultHeadAndLiftState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetDefaultHeadAndLiftState from the given BinaryReader."
    _enable = bool(reader.read('b'))
    _headAngle = reader.read('f')
    _liftHeight = reader.read('f')
    return cls(_enable, _headAngle, _liftHeight)

  def pack(self):
    "Writes the current SetDefaultHeadAndLiftState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetDefaultHeadAndLiftState to the given BinaryWriter."
    writer.write(int(self._enable), 'b')
    writer.write(self._headAngle, 'f')
    writer.write(self._liftHeight, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enable == other._enable and
        self._headAngle == other._headAngle and
        self._liftHeight == other._liftHeight)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b') +
      msgbuffers.size(self._headAngle, 'f') +
      msgbuffers.size(self._liftHeight, 'f'))

  def __str__(self):
    return '{type}(enable={enable}, headAngle={headAngle}, liftHeight={liftHeight})'.format(
      type=type(self).__name__,
      enable=self._enable,
      headAngle=self._headAngle,
      liftHeight=self._liftHeight)

  def __repr__(self):
    return '{type}(enable={enable}, headAngle={headAngle}, liftHeight={liftHeight})'.format(
      type=type(self).__name__,
      enable=repr(self._enable),
      headAngle=repr(self._headAngle),
      liftHeight=repr(self._liftHeight))

Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState = SetDefaultHeadAndLiftState
del SetDefaultHeadAndLiftState


class RequestAvailableObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_connectedObjectsOnly', # bool
  )

  @property
  def connectedObjectsOnly(self):
    "bool connectedObjectsOnly struct property."
    return self._connectedObjectsOnly

  @connectedObjectsOnly.setter
  def connectedObjectsOnly(self, value):
    self._connectedObjectsOnly = msgbuffers.validate_bool(
      'RequestAvailableObjects.connectedObjectsOnly', value)

  def __init__(self, connectedObjectsOnly=False):
    self.connectedObjectsOnly = connectedObjectsOnly

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestAvailableObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestAvailableObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestAvailableObjects from the given BinaryReader."
    _connectedObjectsOnly = bool(reader.read('b'))
    return cls(_connectedObjectsOnly)

  def pack(self):
    "Writes the current RequestAvailableObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestAvailableObjects to the given BinaryWriter."
    writer.write(int(self._connectedObjectsOnly), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._connectedObjectsOnly == other._connectedObjectsOnly
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._connectedObjectsOnly, 'b'))

  def __str__(self):
    return '{type}(connectedObjectsOnly={connectedObjectsOnly})'.format(
      type=type(self).__name__,
      connectedObjectsOnly=self._connectedObjectsOnly)

  def __repr__(self):
    return '{type}(connectedObjectsOnly={connectedObjectsOnly})'.format(
      type=type(self).__name__,
      connectedObjectsOnly=repr(self._connectedObjectsOnly))

Anki.Cozmo.ExternalInterface.RequestAvailableObjects = RequestAvailableObjects
del RequestAvailableObjects


class DrawPoseMarker(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_mm',  # float_32
    '_y_mm',  # float_32
    '_rad',   # float_32
    '_level', # uint_8
  )

  @property
  def x_mm(self):
    "float_32 x_mm struct property."
    return self._x_mm

  @x_mm.setter
  def x_mm(self, value):
    self._x_mm = msgbuffers.validate_float(
      'DrawPoseMarker.x_mm', value, 'f')

  @property
  def y_mm(self):
    "float_32 y_mm struct property."
    return self._y_mm

  @y_mm.setter
  def y_mm(self, value):
    self._y_mm = msgbuffers.validate_float(
      'DrawPoseMarker.y_mm', value, 'f')

  @property
  def rad(self):
    "float_32 rad struct property."
    return self._rad

  @rad.setter
  def rad(self, value):
    self._rad = msgbuffers.validate_float(
      'DrawPoseMarker.rad', value, 'f')

  @property
  def level(self):
    "uint_8 level struct property."
    return self._level

  @level.setter
  def level(self, value):
    self._level = msgbuffers.validate_integer(
      'DrawPoseMarker.level', value, 0, 255)

  def __init__(self, x_mm=0.0, y_mm=0.0, rad=0.0, level=0):
    self.x_mm = x_mm
    self.y_mm = y_mm
    self.rad = rad
    self.level = level

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DrawPoseMarker from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DrawPoseMarker.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DrawPoseMarker from the given BinaryReader."
    _x_mm = reader.read('f')
    _y_mm = reader.read('f')
    _rad = reader.read('f')
    _level = reader.read('B')
    return cls(_x_mm, _y_mm, _rad, _level)

  def pack(self):
    "Writes the current DrawPoseMarker, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DrawPoseMarker to the given BinaryWriter."
    writer.write(self._x_mm, 'f')
    writer.write(self._y_mm, 'f')
    writer.write(self._rad, 'f')
    writer.write(self._level, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_mm == other._x_mm and
        self._y_mm == other._y_mm and
        self._rad == other._rad and
        self._level == other._level)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_mm, 'f') +
      msgbuffers.size(self._y_mm, 'f') +
      msgbuffers.size(self._rad, 'f') +
      msgbuffers.size(self._level, 'B'))

  def __str__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, rad={rad}, level={level})'.format(
      type=type(self).__name__,
      x_mm=self._x_mm,
      y_mm=self._y_mm,
      rad=self._rad,
      level=self._level)

  def __repr__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, rad={rad}, level={level})'.format(
      type=type(self).__name__,
      x_mm=repr(self._x_mm),
      y_mm=repr(self._y_mm),
      rad=repr(self._rad),
      level=repr(self._level))

Anki.Cozmo.ExternalInterface.DrawPoseMarker = DrawPoseMarker
del DrawPoseMarker


class ErasePoseMarker(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ErasePoseMarker from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ErasePoseMarker.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ErasePoseMarker from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ErasePoseMarker, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ErasePoseMarker to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ErasePoseMarker = ErasePoseMarker
del ErasePoseMarker


class VisualizeQuad(object):
  "Generated message-passing message."

  __slots__ = (
    '_quadID',      # uint_32
    '_color',       # uint_32
    '_xUpperLeft',  # float_32
    '_yUpperLeft',  # float_32
    '_zUpperLeft',  # float_32
    '_xLowerLeft',  # float_32
    '_yLowerLeft',  # float_32
    '_zLowerLeft',  # float_32
    '_xUpperRight', # float_32
    '_yUpperRight', # float_32
    '_zUpperRight', # float_32
    '_xLowerRight', # float_32
    '_yLowerRight', # float_32
    '_zLowerRight', # float_32
  )

  @property
  def quadID(self):
    "uint_32 quadID struct property."
    return self._quadID

  @quadID.setter
  def quadID(self, value):
    self._quadID = msgbuffers.validate_integer(
      'VisualizeQuad.quadID', value, 0, 4294967295)

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'VisualizeQuad.color', value, 0, 4294967295)

  @property
  def xUpperLeft(self):
    "float_32 xUpperLeft struct property."
    return self._xUpperLeft

  @xUpperLeft.setter
  def xUpperLeft(self, value):
    self._xUpperLeft = msgbuffers.validate_float(
      'VisualizeQuad.xUpperLeft', value, 'f')

  @property
  def yUpperLeft(self):
    "float_32 yUpperLeft struct property."
    return self._yUpperLeft

  @yUpperLeft.setter
  def yUpperLeft(self, value):
    self._yUpperLeft = msgbuffers.validate_float(
      'VisualizeQuad.yUpperLeft', value, 'f')

  @property
  def zUpperLeft(self):
    "float_32 zUpperLeft struct property."
    return self._zUpperLeft

  @zUpperLeft.setter
  def zUpperLeft(self, value):
    self._zUpperLeft = msgbuffers.validate_float(
      'VisualizeQuad.zUpperLeft', value, 'f')

  @property
  def xLowerLeft(self):
    "float_32 xLowerLeft struct property."
    return self._xLowerLeft

  @xLowerLeft.setter
  def xLowerLeft(self, value):
    self._xLowerLeft = msgbuffers.validate_float(
      'VisualizeQuad.xLowerLeft', value, 'f')

  @property
  def yLowerLeft(self):
    "float_32 yLowerLeft struct property."
    return self._yLowerLeft

  @yLowerLeft.setter
  def yLowerLeft(self, value):
    self._yLowerLeft = msgbuffers.validate_float(
      'VisualizeQuad.yLowerLeft', value, 'f')

  @property
  def zLowerLeft(self):
    "float_32 zLowerLeft struct property."
    return self._zLowerLeft

  @zLowerLeft.setter
  def zLowerLeft(self, value):
    self._zLowerLeft = msgbuffers.validate_float(
      'VisualizeQuad.zLowerLeft', value, 'f')

  @property
  def xUpperRight(self):
    "float_32 xUpperRight struct property."
    return self._xUpperRight

  @xUpperRight.setter
  def xUpperRight(self, value):
    self._xUpperRight = msgbuffers.validate_float(
      'VisualizeQuad.xUpperRight', value, 'f')

  @property
  def yUpperRight(self):
    "float_32 yUpperRight struct property."
    return self._yUpperRight

  @yUpperRight.setter
  def yUpperRight(self, value):
    self._yUpperRight = msgbuffers.validate_float(
      'VisualizeQuad.yUpperRight', value, 'f')

  @property
  def zUpperRight(self):
    "float_32 zUpperRight struct property."
    return self._zUpperRight

  @zUpperRight.setter
  def zUpperRight(self, value):
    self._zUpperRight = msgbuffers.validate_float(
      'VisualizeQuad.zUpperRight', value, 'f')

  @property
  def xLowerRight(self):
    "float_32 xLowerRight struct property."
    return self._xLowerRight

  @xLowerRight.setter
  def xLowerRight(self, value):
    self._xLowerRight = msgbuffers.validate_float(
      'VisualizeQuad.xLowerRight', value, 'f')

  @property
  def yLowerRight(self):
    "float_32 yLowerRight struct property."
    return self._yLowerRight

  @yLowerRight.setter
  def yLowerRight(self, value):
    self._yLowerRight = msgbuffers.validate_float(
      'VisualizeQuad.yLowerRight', value, 'f')

  @property
  def zLowerRight(self):
    "float_32 zLowerRight struct property."
    return self._zLowerRight

  @zLowerRight.setter
  def zLowerRight(self, value):
    self._zLowerRight = msgbuffers.validate_float(
      'VisualizeQuad.zLowerRight', value, 'f')

  def __init__(self, quadID=0, color=0, xUpperLeft=0.0, yUpperLeft=0.0, zUpperLeft=0.0, xLowerLeft=0.0, yLowerLeft=0.0, zLowerLeft=0.0, xUpperRight=0.0, yUpperRight=0.0, zUpperRight=0.0, xLowerRight=0.0, yLowerRight=0.0, zLowerRight=0.0):
    self.quadID = quadID
    self.color = color
    self.xUpperLeft = xUpperLeft
    self.yUpperLeft = yUpperLeft
    self.zUpperLeft = zUpperLeft
    self.xLowerLeft = xLowerLeft
    self.yLowerLeft = yLowerLeft
    self.zLowerLeft = zLowerLeft
    self.xUpperRight = xUpperRight
    self.yUpperRight = yUpperRight
    self.zUpperRight = zUpperRight
    self.xLowerRight = xLowerRight
    self.yLowerRight = yLowerRight
    self.zLowerRight = zLowerRight

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisualizeQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisualizeQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisualizeQuad from the given BinaryReader."
    _quadID = reader.read('I')
    _color = reader.read('I')
    _xUpperLeft = reader.read('f')
    _yUpperLeft = reader.read('f')
    _zUpperLeft = reader.read('f')
    _xLowerLeft = reader.read('f')
    _yLowerLeft = reader.read('f')
    _zLowerLeft = reader.read('f')
    _xUpperRight = reader.read('f')
    _yUpperRight = reader.read('f')
    _zUpperRight = reader.read('f')
    _xLowerRight = reader.read('f')
    _yLowerRight = reader.read('f')
    _zLowerRight = reader.read('f')
    return cls(_quadID, _color, _xUpperLeft, _yUpperLeft, _zUpperLeft, _xLowerLeft, _yLowerLeft, _zLowerLeft, _xUpperRight, _yUpperRight, _zUpperRight, _xLowerRight, _yLowerRight, _zLowerRight)

  def pack(self):
    "Writes the current VisualizeQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisualizeQuad to the given BinaryWriter."
    writer.write(self._quadID, 'I')
    writer.write(self._color, 'I')
    writer.write(self._xUpperLeft, 'f')
    writer.write(self._yUpperLeft, 'f')
    writer.write(self._zUpperLeft, 'f')
    writer.write(self._xLowerLeft, 'f')
    writer.write(self._yLowerLeft, 'f')
    writer.write(self._zLowerLeft, 'f')
    writer.write(self._xUpperRight, 'f')
    writer.write(self._yUpperRight, 'f')
    writer.write(self._zUpperRight, 'f')
    writer.write(self._xLowerRight, 'f')
    writer.write(self._yLowerRight, 'f')
    writer.write(self._zLowerRight, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._quadID == other._quadID and
        self._color == other._color and
        self._xUpperLeft == other._xUpperLeft and
        self._yUpperLeft == other._yUpperLeft and
        self._zUpperLeft == other._zUpperLeft and
        self._xLowerLeft == other._xLowerLeft and
        self._yLowerLeft == other._yLowerLeft and
        self._zLowerLeft == other._zLowerLeft and
        self._xUpperRight == other._xUpperRight and
        self._yUpperRight == other._yUpperRight and
        self._zUpperRight == other._zUpperRight and
        self._xLowerRight == other._xLowerRight and
        self._yLowerRight == other._yLowerRight and
        self._zLowerRight == other._zLowerRight)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._quadID, 'I') +
      msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._xUpperLeft, 'f') +
      msgbuffers.size(self._yUpperLeft, 'f') +
      msgbuffers.size(self._zUpperLeft, 'f') +
      msgbuffers.size(self._xLowerLeft, 'f') +
      msgbuffers.size(self._yLowerLeft, 'f') +
      msgbuffers.size(self._zLowerLeft, 'f') +
      msgbuffers.size(self._xUpperRight, 'f') +
      msgbuffers.size(self._yUpperRight, 'f') +
      msgbuffers.size(self._zUpperRight, 'f') +
      msgbuffers.size(self._xLowerRight, 'f') +
      msgbuffers.size(self._yLowerRight, 'f') +
      msgbuffers.size(self._zLowerRight, 'f'))

  def __str__(self):
    return '{type}(quadID={quadID}, color={color}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, zUpperLeft={zUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, zLowerLeft={zLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, zUpperRight={zUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight}, zLowerRight={zLowerRight})'.format(
      type=type(self).__name__,
      quadID=self._quadID,
      color=self._color,
      xUpperLeft=self._xUpperLeft,
      yUpperLeft=self._yUpperLeft,
      zUpperLeft=self._zUpperLeft,
      xLowerLeft=self._xLowerLeft,
      yLowerLeft=self._yLowerLeft,
      zLowerLeft=self._zLowerLeft,
      xUpperRight=self._xUpperRight,
      yUpperRight=self._yUpperRight,
      zUpperRight=self._zUpperRight,
      xLowerRight=self._xLowerRight,
      yLowerRight=self._yLowerRight,
      zLowerRight=self._zLowerRight)

  def __repr__(self):
    return '{type}(quadID={quadID}, color={color}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, zUpperLeft={zUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, zLowerLeft={zLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, zUpperRight={zUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight}, zLowerRight={zLowerRight})'.format(
      type=type(self).__name__,
      quadID=repr(self._quadID),
      color=repr(self._color),
      xUpperLeft=repr(self._xUpperLeft),
      yUpperLeft=repr(self._yUpperLeft),
      zUpperLeft=repr(self._zUpperLeft),
      xLowerLeft=repr(self._xLowerLeft),
      yLowerLeft=repr(self._yLowerLeft),
      zLowerLeft=repr(self._zLowerLeft),
      xUpperRight=repr(self._xUpperRight),
      yUpperRight=repr(self._yUpperRight),
      zUpperRight=repr(self._zUpperRight),
      xLowerRight=repr(self._xLowerRight),
      yLowerRight=repr(self._yLowerRight),
      zLowerRight=repr(self._zLowerRight))

Anki.Cozmo.ExternalInterface.VisualizeQuad = VisualizeQuad
del VisualizeQuad


class EraseQuad(object):
  "Generated message-passing message."

  __slots__ = (
    '_quadID', # uint_32
  )

  @property
  def quadID(self):
    "uint_32 quadID struct property."
    return self._quadID

  @quadID.setter
  def quadID(self, value):
    self._quadID = msgbuffers.validate_integer(
      'EraseQuad.quadID', value, 0, 4294967295)

  def __init__(self, quadID=0):
    self.quadID = quadID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseQuad from the given BinaryReader."
    _quadID = reader.read('I')
    return cls(_quadID)

  def pack(self):
    "Writes the current EraseQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseQuad to the given BinaryWriter."
    writer.write(self._quadID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._quadID == other._quadID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._quadID, 'I'))

  def __str__(self):
    return '{type}(quadID={quadID})'.format(
      type=type(self).__name__,
      quadID=self._quadID)

  def __repr__(self):
    return '{type}(quadID={quadID})'.format(
      type=type(self).__name__,
      quadID=repr(self._quadID))

Anki.Cozmo.ExternalInterface.EraseQuad = EraseQuad
del EraseQuad


class ReplayLastAnimation(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',  # uint_8
    '_numLoops', # uint_32
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ReplayLastAnimation.robotID', value, 0, 255)

  @property
  def numLoops(self):
    "uint_32 numLoops struct property."
    return self._numLoops

  @numLoops.setter
  def numLoops(self, value):
    self._numLoops = msgbuffers.validate_integer(
      'ReplayLastAnimation.numLoops', value, 0, 4294967295)

  def __init__(self, robotID=0, numLoops=0):
    self.robotID = robotID
    self.numLoops = numLoops

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReplayLastAnimation from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReplayLastAnimation.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReplayLastAnimation from the given BinaryReader."
    _robotID = reader.read('B')
    _numLoops = reader.read('I')
    return cls(_robotID, _numLoops)

  def pack(self):
    "Writes the current ReplayLastAnimation, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReplayLastAnimation to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._numLoops, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._numLoops == other._numLoops)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._numLoops, 'I'))

  def __str__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      numLoops=self._numLoops)

  def __repr__(self):
    return '{type}(robotID={robotID}, numLoops={numLoops})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      numLoops=repr(self._numLoops))

Anki.Cozmo.ExternalInterface.ReplayLastAnimation = ReplayLastAnimation
del ReplayLastAnimation


class SetIdleAnimation(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',     # uint_8
    '_animTrigger', # Anki.Cozmo.AnimationTrigger
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetIdleAnimation.robotID', value, 0, 255)

  @property
  def animTrigger(self):
    "Anki.Cozmo.AnimationTrigger animTrigger struct property."
    return self._animTrigger

  @animTrigger.setter
  def animTrigger(self, value):
    self._animTrigger = msgbuffers.validate_integer(
      'SetIdleAnimation.animTrigger', value, -2147483648, 2147483647)

  def __init__(self, robotID=0, animTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause):
    self.robotID = robotID
    self.animTrigger = animTrigger

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetIdleAnimation from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetIdleAnimation.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetIdleAnimation from the given BinaryReader."
    _robotID = reader.read('B')
    _animTrigger = reader.read('i')
    return cls(_robotID, _animTrigger)

  def pack(self):
    "Writes the current SetIdleAnimation, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetIdleAnimation to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(self._animTrigger, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._animTrigger == other._animTrigger)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._animTrigger, 'i'))

  def __str__(self):
    return '{type}(robotID={robotID}, animTrigger={animTrigger})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      animTrigger=self._animTrigger)

  def __repr__(self):
    return '{type}(robotID={robotID}, animTrigger={animTrigger})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      animTrigger=repr(self._animTrigger))

Anki.Cozmo.ExternalInterface.SetIdleAnimation = SetIdleAnimation
del SetIdleAnimation


class PushIdleAnimation(object):
  "Generated message-passing message."

  __slots__ = (
    '_animTrigger', # Anki.Cozmo.AnimationTrigger
  )

  @property
  def animTrigger(self):
    "Anki.Cozmo.AnimationTrigger animTrigger struct property."
    return self._animTrigger

  @animTrigger.setter
  def animTrigger(self, value):
    self._animTrigger = msgbuffers.validate_integer(
      'PushIdleAnimation.animTrigger', value, -2147483648, 2147483647)

  def __init__(self, animTrigger=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause):
    self.animTrigger = animTrigger

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PushIdleAnimation from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PushIdleAnimation.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PushIdleAnimation from the given BinaryReader."
    _animTrigger = reader.read('i')
    return cls(_animTrigger)

  def pack(self):
    "Writes the current PushIdleAnimation, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PushIdleAnimation to the given BinaryWriter."
    writer.write(self._animTrigger, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._animTrigger == other._animTrigger
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._animTrigger, 'i'))

  def __str__(self):
    return '{type}(animTrigger={animTrigger})'.format(
      type=type(self).__name__,
      animTrigger=self._animTrigger)

  def __repr__(self):
    return '{type}(animTrigger={animTrigger})'.format(
      type=type(self).__name__,
      animTrigger=repr(self._animTrigger))

Anki.Cozmo.ExternalInterface.PushIdleAnimation = PushIdleAnimation
del PushIdleAnimation


class PopIdleAnimation(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PopIdleAnimation from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PopIdleAnimation.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PopIdleAnimation from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current PopIdleAnimation, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PopIdleAnimation to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.PopIdleAnimation = PopIdleAnimation
del PopIdleAnimation


class ReadFaceAnimationDir(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReadFaceAnimationDir from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReadFaceAnimationDir.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReadFaceAnimationDir from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ReadFaceAnimationDir, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReadFaceAnimationDir to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir = ReadFaceAnimationDir
del ReadFaceAnimationDir


class ReadAnimationFile(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ReadAnimationFile from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ReadAnimationFile.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ReadAnimationFile from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ReadAnimationFile, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ReadAnimationFile to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ReadAnimationFile = ReadAnimationFile
del ReadAnimationFile


class RequestAvailableAnimations(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestAvailableAnimations from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestAvailableAnimations.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestAvailableAnimations from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestAvailableAnimations, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestAvailableAnimations to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestAvailableAnimations = RequestAvailableAnimations
del RequestAvailableAnimations


class RequestAvailableAnimationGroups(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestAvailableAnimationGroups from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestAvailableAnimationGroups.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestAvailableAnimationGroups from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestAvailableAnimationGroups, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestAvailableAnimationGroups to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups = RequestAvailableAnimationGroups
del RequestAvailableAnimationGroups


class SetLiveIdleAnimationParameters(object):
  "Generated message-passing message."

  __slots__ = (
    '_paramNames',              # LiveIdleAnimationParameter[uint_8]
    '_paramValues',             # float_32[uint_8]
    '_robotID',                 # uint_8
    '_setUnspecifiedToDefault', # bool
  )

  @property
  def paramNames(self):
    "LiveIdleAnimationParameter[uint_8] paramNames struct property."
    return self._paramNames

  @paramNames.setter
  def paramNames(self, value):
    self._paramNames = msgbuffers.validate_varray(
      'SetLiveIdleAnimationParameters.paramNames', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def paramValues(self):
    "float_32[uint_8] paramValues struct property."
    return self._paramValues

  @paramValues.setter
  def paramValues(self, value):
    self._paramValues = msgbuffers.validate_varray(
      'SetLiveIdleAnimationParameters.paramValues', value, 255,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetLiveIdleAnimationParameters.robotID', value, 0, 255)

  @property
  def setUnspecifiedToDefault(self):
    "bool setUnspecifiedToDefault struct property."
    return self._setUnspecifiedToDefault

  @setUnspecifiedToDefault.setter
  def setUnspecifiedToDefault(self, value):
    self._setUnspecifiedToDefault = msgbuffers.validate_bool(
      'SetLiveIdleAnimationParameters.setUnspecifiedToDefault', value)

  def __init__(self, paramNames=(), paramValues=(), robotID=0, setUnspecifiedToDefault=False):
    self.paramNames = paramNames
    self.paramValues = paramValues
    self.robotID = robotID
    self.setUnspecifiedToDefault = setUnspecifiedToDefault

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetLiveIdleAnimationParameters from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetLiveIdleAnimationParameters.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetLiveIdleAnimationParameters from the given BinaryReader."
    _paramNames = reader.read_varray('B', 'B')
    _paramValues = reader.read_varray('f', 'B')
    _robotID = reader.read('B')
    _setUnspecifiedToDefault = bool(reader.read('b'))
    return cls(_paramNames, _paramValues, _robotID, _setUnspecifiedToDefault)

  def pack(self):
    "Writes the current SetLiveIdleAnimationParameters, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetLiveIdleAnimationParameters to the given BinaryWriter."
    writer.write_varray(self._paramNames, 'B', 'B')
    writer.write_varray(self._paramValues, 'f', 'B')
    writer.write(self._robotID, 'B')
    writer.write(int(self._setUnspecifiedToDefault), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._paramNames == other._paramNames and
        self._paramValues == other._paramValues and
        self._robotID == other._robotID and
        self._setUnspecifiedToDefault == other._setUnspecifiedToDefault)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_varray(self._paramNames, 'B', 'B') +
      msgbuffers.size_varray(self._paramValues, 'f', 'B') +
      msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._setUnspecifiedToDefault, 'b'))

  def __str__(self):
    return '{type}(paramNames={paramNames}, paramValues={paramValues}, robotID={robotID}, setUnspecifiedToDefault={setUnspecifiedToDefault})'.format(
      type=type(self).__name__,
      paramNames=msgbuffers.shorten_sequence(self._paramNames),
      paramValues=msgbuffers.shorten_sequence(self._paramValues),
      robotID=self._robotID,
      setUnspecifiedToDefault=self._setUnspecifiedToDefault)

  def __repr__(self):
    return '{type}(paramNames={paramNames}, paramValues={paramValues}, robotID={robotID}, setUnspecifiedToDefault={setUnspecifiedToDefault})'.format(
      type=type(self).__name__,
      paramNames=repr(self._paramNames),
      paramValues=repr(self._paramValues),
      robotID=repr(self._robotID),
      setUnspecifiedToDefault=repr(self._setUnspecifiedToDefault))

Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters = SetLiveIdleAnimationParameters
del SetLiveIdleAnimationParameters


class PushDrivingAnimations(object):
  "Generated message-passing message."

  __slots__ = (
    '_drivingStartAnim', # Anki.Cozmo.AnimationTrigger
    '_drivingLoopAnim',  # Anki.Cozmo.AnimationTrigger
    '_drivingEndAnim',   # Anki.Cozmo.AnimationTrigger
  )

  @property
  def drivingStartAnim(self):
    "Anki.Cozmo.AnimationTrigger drivingStartAnim struct property."
    return self._drivingStartAnim

  @drivingStartAnim.setter
  def drivingStartAnim(self, value):
    self._drivingStartAnim = msgbuffers.validate_integer(
      'PushDrivingAnimations.drivingStartAnim', value, -2147483648, 2147483647)

  @property
  def drivingLoopAnim(self):
    "Anki.Cozmo.AnimationTrigger drivingLoopAnim struct property."
    return self._drivingLoopAnim

  @drivingLoopAnim.setter
  def drivingLoopAnim(self, value):
    self._drivingLoopAnim = msgbuffers.validate_integer(
      'PushDrivingAnimations.drivingLoopAnim', value, -2147483648, 2147483647)

  @property
  def drivingEndAnim(self):
    "Anki.Cozmo.AnimationTrigger drivingEndAnim struct property."
    return self._drivingEndAnim

  @drivingEndAnim.setter
  def drivingEndAnim(self, value):
    self._drivingEndAnim = msgbuffers.validate_integer(
      'PushDrivingAnimations.drivingEndAnim', value, -2147483648, 2147483647)

  def __init__(self, drivingStartAnim=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, drivingLoopAnim=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause, drivingEndAnim=Anki.Cozmo.AnimationTrigger.AcknowledgeFaceInitPause):
    self.drivingStartAnim = drivingStartAnim
    self.drivingLoopAnim = drivingLoopAnim
    self.drivingEndAnim = drivingEndAnim

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PushDrivingAnimations from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PushDrivingAnimations.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PushDrivingAnimations from the given BinaryReader."
    _drivingStartAnim = reader.read('i')
    _drivingLoopAnim = reader.read('i')
    _drivingEndAnim = reader.read('i')
    return cls(_drivingStartAnim, _drivingLoopAnim, _drivingEndAnim)

  def pack(self):
    "Writes the current PushDrivingAnimations, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PushDrivingAnimations to the given BinaryWriter."
    writer.write(self._drivingStartAnim, 'i')
    writer.write(self._drivingLoopAnim, 'i')
    writer.write(self._drivingEndAnim, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._drivingStartAnim == other._drivingStartAnim and
        self._drivingLoopAnim == other._drivingLoopAnim and
        self._drivingEndAnim == other._drivingEndAnim)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._drivingStartAnim, 'i') +
      msgbuffers.size(self._drivingLoopAnim, 'i') +
      msgbuffers.size(self._drivingEndAnim, 'i'))

  def __str__(self):
    return '{type}(drivingStartAnim={drivingStartAnim}, drivingLoopAnim={drivingLoopAnim}, drivingEndAnim={drivingEndAnim})'.format(
      type=type(self).__name__,
      drivingStartAnim=self._drivingStartAnim,
      drivingLoopAnim=self._drivingLoopAnim,
      drivingEndAnim=self._drivingEndAnim)

  def __repr__(self):
    return '{type}(drivingStartAnim={drivingStartAnim}, drivingLoopAnim={drivingLoopAnim}, drivingEndAnim={drivingEndAnim})'.format(
      type=type(self).__name__,
      drivingStartAnim=repr(self._drivingStartAnim),
      drivingLoopAnim=repr(self._drivingLoopAnim),
      drivingEndAnim=repr(self._drivingEndAnim))

Anki.Cozmo.ExternalInterface.PushDrivingAnimations = PushDrivingAnimations
del PushDrivingAnimations


class PopDrivingAnimations(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PopDrivingAnimations from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PopDrivingAnimations.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PopDrivingAnimations from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current PopDrivingAnimations, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PopDrivingAnimations to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.PopDrivingAnimations = PopDrivingAnimations
del PopDrivingAnimations


class SetHeadlight(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'SetHeadlight.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetHeadlight from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetHeadlight.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetHeadlight from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current SetHeadlight, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetHeadlight to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.SetHeadlight = SetHeadlight
del SetHeadlight


class SetActiveObjectLEDs(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',               # uint_32
    '_onColor',                # uint_32
    '_offColor',               # uint_32
    '_onPeriod_ms',            # uint_32
    '_offPeriod_ms',           # uint_32
    '_transitionOnPeriod_ms',  # uint_32
    '_transitionOffPeriod_ms', # uint_32
    '_offset',                 # int_32
    '_rotationPeriod_ms',      # uint_32
    '_relativeToX',            # float_32
    '_relativeToY',            # float_32
    '_whichLEDs',              # Anki.Cozmo.WhichCubeLEDs
    '_makeRelative',           # Anki.Cozmo.MakeRelativeMode
    '_turnOffUnspecifiedLEDs', # uint_8
    '_robotID',                # uint_8
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.objectID', value, 0, 4294967295)

  @property
  def onColor(self):
    "uint_32 onColor struct property."
    return self._onColor

  @onColor.setter
  def onColor(self, value):
    self._onColor = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.onColor', value, 0, 4294967295)

  @property
  def offColor(self):
    "uint_32 offColor struct property."
    return self._offColor

  @offColor.setter
  def offColor(self, value):
    self._offColor = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.offColor', value, 0, 4294967295)

  @property
  def onPeriod_ms(self):
    "uint_32 onPeriod_ms struct property."
    return self._onPeriod_ms

  @onPeriod_ms.setter
  def onPeriod_ms(self, value):
    self._onPeriod_ms = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.onPeriod_ms', value, 0, 4294967295)

  @property
  def offPeriod_ms(self):
    "uint_32 offPeriod_ms struct property."
    return self._offPeriod_ms

  @offPeriod_ms.setter
  def offPeriod_ms(self, value):
    self._offPeriod_ms = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.offPeriod_ms', value, 0, 4294967295)

  @property
  def transitionOnPeriod_ms(self):
    "uint_32 transitionOnPeriod_ms struct property."
    return self._transitionOnPeriod_ms

  @transitionOnPeriod_ms.setter
  def transitionOnPeriod_ms(self, value):
    self._transitionOnPeriod_ms = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.transitionOnPeriod_ms', value, 0, 4294967295)

  @property
  def transitionOffPeriod_ms(self):
    "uint_32 transitionOffPeriod_ms struct property."
    return self._transitionOffPeriod_ms

  @transitionOffPeriod_ms.setter
  def transitionOffPeriod_ms(self, value):
    self._transitionOffPeriod_ms = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.transitionOffPeriod_ms', value, 0, 4294967295)

  @property
  def offset(self):
    "int_32 offset struct property."
    return self._offset

  @offset.setter
  def offset(self, value):
    self._offset = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.offset', value, -2147483648, 2147483647)

  @property
  def rotationPeriod_ms(self):
    "uint_32 rotationPeriod_ms struct property."
    return self._rotationPeriod_ms

  @rotationPeriod_ms.setter
  def rotationPeriod_ms(self, value):
    self._rotationPeriod_ms = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.rotationPeriod_ms', value, 0, 4294967295)

  @property
  def relativeToX(self):
    "float_32 relativeToX struct property."
    return self._relativeToX

  @relativeToX.setter
  def relativeToX(self, value):
    self._relativeToX = msgbuffers.validate_float(
      'SetActiveObjectLEDs.relativeToX', value, 'f')

  @property
  def relativeToY(self):
    "float_32 relativeToY struct property."
    return self._relativeToY

  @relativeToY.setter
  def relativeToY(self, value):
    self._relativeToY = msgbuffers.validate_float(
      'SetActiveObjectLEDs.relativeToY', value, 'f')

  @property
  def whichLEDs(self):
    "Anki.Cozmo.WhichCubeLEDs whichLEDs struct property."
    return self._whichLEDs

  @whichLEDs.setter
  def whichLEDs(self, value):
    self._whichLEDs = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.whichLEDs', value, 0, 255)

  @property
  def makeRelative(self):
    "Anki.Cozmo.MakeRelativeMode makeRelative struct property."
    return self._makeRelative

  @makeRelative.setter
  def makeRelative(self, value):
    self._makeRelative = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.makeRelative', value, 0, 255)

  @property
  def turnOffUnspecifiedLEDs(self):
    "uint_8 turnOffUnspecifiedLEDs struct property."
    return self._turnOffUnspecifiedLEDs

  @turnOffUnspecifiedLEDs.setter
  def turnOffUnspecifiedLEDs(self, value):
    self._turnOffUnspecifiedLEDs = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.turnOffUnspecifiedLEDs', value, 0, 255)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetActiveObjectLEDs.robotID', value, 0, 255)

  def __init__(self, objectID=0, onColor=0, offColor=0, onPeriod_ms=0, offPeriod_ms=0, transitionOnPeriod_ms=0, transitionOffPeriod_ms=0, offset=0, rotationPeriod_ms=0, relativeToX=0.0, relativeToY=0.0, whichLEDs=Anki.Cozmo.WhichCubeLEDs.NONE, makeRelative=Anki.Cozmo.MakeRelativeMode.RELATIVE_LED_MODE_OFF, turnOffUnspecifiedLEDs=0, robotID=0):
    self.objectID = objectID
    self.onColor = onColor
    self.offColor = offColor
    self.onPeriod_ms = onPeriod_ms
    self.offPeriod_ms = offPeriod_ms
    self.transitionOnPeriod_ms = transitionOnPeriod_ms
    self.transitionOffPeriod_ms = transitionOffPeriod_ms
    self.offset = offset
    self.rotationPeriod_ms = rotationPeriod_ms
    self.relativeToX = relativeToX
    self.relativeToY = relativeToY
    self.whichLEDs = whichLEDs
    self.makeRelative = makeRelative
    self.turnOffUnspecifiedLEDs = turnOffUnspecifiedLEDs
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetActiveObjectLEDs from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetActiveObjectLEDs.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetActiveObjectLEDs from the given BinaryReader."
    _objectID = reader.read('I')
    _onColor = reader.read('I')
    _offColor = reader.read('I')
    _onPeriod_ms = reader.read('I')
    _offPeriod_ms = reader.read('I')
    _transitionOnPeriod_ms = reader.read('I')
    _transitionOffPeriod_ms = reader.read('I')
    _offset = reader.read('i')
    _rotationPeriod_ms = reader.read('I')
    _relativeToX = reader.read('f')
    _relativeToY = reader.read('f')
    _whichLEDs = reader.read('B')
    _makeRelative = reader.read('B')
    _turnOffUnspecifiedLEDs = reader.read('B')
    _robotID = reader.read('B')
    return cls(_objectID, _onColor, _offColor, _onPeriod_ms, _offPeriod_ms, _transitionOnPeriod_ms, _transitionOffPeriod_ms, _offset, _rotationPeriod_ms, _relativeToX, _relativeToY, _whichLEDs, _makeRelative, _turnOffUnspecifiedLEDs, _robotID)

  def pack(self):
    "Writes the current SetActiveObjectLEDs, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetActiveObjectLEDs to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._onColor, 'I')
    writer.write(self._offColor, 'I')
    writer.write(self._onPeriod_ms, 'I')
    writer.write(self._offPeriod_ms, 'I')
    writer.write(self._transitionOnPeriod_ms, 'I')
    writer.write(self._transitionOffPeriod_ms, 'I')
    writer.write(self._offset, 'i')
    writer.write(self._rotationPeriod_ms, 'I')
    writer.write(self._relativeToX, 'f')
    writer.write(self._relativeToY, 'f')
    writer.write(self._whichLEDs, 'B')
    writer.write(self._makeRelative, 'B')
    writer.write(self._turnOffUnspecifiedLEDs, 'B')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._onColor == other._onColor and
        self._offColor == other._offColor and
        self._onPeriod_ms == other._onPeriod_ms and
        self._offPeriod_ms == other._offPeriod_ms and
        self._transitionOnPeriod_ms == other._transitionOnPeriod_ms and
        self._transitionOffPeriod_ms == other._transitionOffPeriod_ms and
        self._offset == other._offset and
        self._rotationPeriod_ms == other._rotationPeriod_ms and
        self._relativeToX == other._relativeToX and
        self._relativeToY == other._relativeToY and
        self._whichLEDs == other._whichLEDs and
        self._makeRelative == other._makeRelative and
        self._turnOffUnspecifiedLEDs == other._turnOffUnspecifiedLEDs and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._onColor, 'I') +
      msgbuffers.size(self._offColor, 'I') +
      msgbuffers.size(self._onPeriod_ms, 'I') +
      msgbuffers.size(self._offPeriod_ms, 'I') +
      msgbuffers.size(self._transitionOnPeriod_ms, 'I') +
      msgbuffers.size(self._transitionOffPeriod_ms, 'I') +
      msgbuffers.size(self._offset, 'i') +
      msgbuffers.size(self._rotationPeriod_ms, 'I') +
      msgbuffers.size(self._relativeToX, 'f') +
      msgbuffers.size(self._relativeToY, 'f') +
      msgbuffers.size(self._whichLEDs, 'B') +
      msgbuffers.size(self._makeRelative, 'B') +
      msgbuffers.size(self._turnOffUnspecifiedLEDs, 'B') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(objectID={objectID}, onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, rotationPeriod_ms={rotationPeriod_ms}, relativeToX={relativeToX}, relativeToY={relativeToY}, whichLEDs={whichLEDs}, makeRelative={makeRelative}, turnOffUnspecifiedLEDs={turnOffUnspecifiedLEDs}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      onColor=self._onColor,
      offColor=self._offColor,
      onPeriod_ms=self._onPeriod_ms,
      offPeriod_ms=self._offPeriod_ms,
      transitionOnPeriod_ms=self._transitionOnPeriod_ms,
      transitionOffPeriod_ms=self._transitionOffPeriod_ms,
      offset=self._offset,
      rotationPeriod_ms=self._rotationPeriod_ms,
      relativeToX=self._relativeToX,
      relativeToY=self._relativeToY,
      whichLEDs=self._whichLEDs,
      makeRelative=self._makeRelative,
      turnOffUnspecifiedLEDs=self._turnOffUnspecifiedLEDs,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(objectID={objectID}, onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, rotationPeriod_ms={rotationPeriod_ms}, relativeToX={relativeToX}, relativeToY={relativeToY}, whichLEDs={whichLEDs}, makeRelative={makeRelative}, turnOffUnspecifiedLEDs={turnOffUnspecifiedLEDs}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      onColor=repr(self._onColor),
      offColor=repr(self._offColor),
      onPeriod_ms=repr(self._onPeriod_ms),
      offPeriod_ms=repr(self._offPeriod_ms),
      transitionOnPeriod_ms=repr(self._transitionOnPeriod_ms),
      transitionOffPeriod_ms=repr(self._transitionOffPeriod_ms),
      offset=repr(self._offset),
      rotationPeriod_ms=repr(self._rotationPeriod_ms),
      relativeToX=repr(self._relativeToX),
      relativeToY=repr(self._relativeToY),
      whichLEDs=repr(self._whichLEDs),
      makeRelative=repr(self._makeRelative),
      turnOffUnspecifiedLEDs=repr(self._turnOffUnspecifiedLEDs),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs = SetActiveObjectLEDs
del SetActiveObjectLEDs


class SetAllActiveObjectLEDs(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',               # uint_32
    '_onColor',                # uint_32[4]
    '_offColor',               # uint_32[4]
    '_onPeriod_ms',            # uint_32[4]
    '_offPeriod_ms',           # uint_32[4]
    '_transitionOnPeriod_ms',  # uint_32[4]
    '_transitionOffPeriod_ms', # uint_32[4]
    '_offset',                 # int_32[4]
    '_rotationPeriod_ms',      # uint_32
    '_relativeToX',            # float_32
    '_relativeToY',            # float_32
    '_makeRelative',           # Anki.Cozmo.MakeRelativeMode
    '_robotID',                # uint_8
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'SetAllActiveObjectLEDs.objectID', value, 0, 4294967295)

  @property
  def onColor(self):
    "uint_32[4] onColor struct property."
    return self._onColor

  @onColor.setter
  def onColor(self, value):
    self._onColor = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.onColor', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offColor(self):
    "uint_32[4] offColor struct property."
    return self._offColor

  @offColor.setter
  def offColor(self, value):
    self._offColor = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.offColor', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def onPeriod_ms(self):
    "uint_32[4] onPeriod_ms struct property."
    return self._onPeriod_ms

  @onPeriod_ms.setter
  def onPeriod_ms(self, value):
    self._onPeriod_ms = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.onPeriod_ms', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offPeriod_ms(self):
    "uint_32[4] offPeriod_ms struct property."
    return self._offPeriod_ms

  @offPeriod_ms.setter
  def offPeriod_ms(self, value):
    self._offPeriod_ms = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.offPeriod_ms', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def transitionOnPeriod_ms(self):
    "uint_32[4] transitionOnPeriod_ms struct property."
    return self._transitionOnPeriod_ms

  @transitionOnPeriod_ms.setter
  def transitionOnPeriod_ms(self, value):
    self._transitionOnPeriod_ms = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.transitionOnPeriod_ms', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def transitionOffPeriod_ms(self):
    "uint_32[4] transitionOffPeriod_ms struct property."
    return self._transitionOffPeriod_ms

  @transitionOffPeriod_ms.setter
  def transitionOffPeriod_ms(self, value):
    self._transitionOffPeriod_ms = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.transitionOffPeriod_ms', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offset(self):
    "int_32[4] offset struct property."
    return self._offset

  @offset.setter
  def offset(self, value):
    self._offset = msgbuffers.validate_farray(
      'SetAllActiveObjectLEDs.offset', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  @property
  def rotationPeriod_ms(self):
    "uint_32 rotationPeriod_ms struct property."
    return self._rotationPeriod_ms

  @rotationPeriod_ms.setter
  def rotationPeriod_ms(self, value):
    self._rotationPeriod_ms = msgbuffers.validate_integer(
      'SetAllActiveObjectLEDs.rotationPeriod_ms', value, 0, 4294967295)

  @property
  def relativeToX(self):
    "float_32 relativeToX struct property."
    return self._relativeToX

  @relativeToX.setter
  def relativeToX(self, value):
    self._relativeToX = msgbuffers.validate_float(
      'SetAllActiveObjectLEDs.relativeToX', value, 'f')

  @property
  def relativeToY(self):
    "float_32 relativeToY struct property."
    return self._relativeToY

  @relativeToY.setter
  def relativeToY(self, value):
    self._relativeToY = msgbuffers.validate_float(
      'SetAllActiveObjectLEDs.relativeToY', value, 'f')

  @property
  def makeRelative(self):
    "Anki.Cozmo.MakeRelativeMode makeRelative struct property."
    return self._makeRelative

  @makeRelative.setter
  def makeRelative(self, value):
    self._makeRelative = msgbuffers.validate_integer(
      'SetAllActiveObjectLEDs.makeRelative', value, 0, 255)

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetAllActiveObjectLEDs.robotID', value, 0, 255)

  def __init__(self, objectID=0, onColor=(0,) * 4, offColor=(0,) * 4, onPeriod_ms=(0,) * 4, offPeriod_ms=(0,) * 4, transitionOnPeriod_ms=(0,) * 4, transitionOffPeriod_ms=(0,) * 4, offset=(0,) * 4, rotationPeriod_ms=0, relativeToX=0.0, relativeToY=0.0, makeRelative=Anki.Cozmo.MakeRelativeMode.RELATIVE_LED_MODE_OFF, robotID=0):
    self.objectID = objectID
    self.onColor = onColor
    self.offColor = offColor
    self.onPeriod_ms = onPeriod_ms
    self.offPeriod_ms = offPeriod_ms
    self.transitionOnPeriod_ms = transitionOnPeriod_ms
    self.transitionOffPeriod_ms = transitionOffPeriod_ms
    self.offset = offset
    self.rotationPeriod_ms = rotationPeriod_ms
    self.relativeToX = relativeToX
    self.relativeToY = relativeToY
    self.makeRelative = makeRelative
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetAllActiveObjectLEDs from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetAllActiveObjectLEDs.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetAllActiveObjectLEDs from the given BinaryReader."
    _objectID = reader.read('I')
    _onColor = reader.read_farray('I', 4)
    _offColor = reader.read_farray('I', 4)
    _onPeriod_ms = reader.read_farray('I', 4)
    _offPeriod_ms = reader.read_farray('I', 4)
    _transitionOnPeriod_ms = reader.read_farray('I', 4)
    _transitionOffPeriod_ms = reader.read_farray('I', 4)
    _offset = reader.read_farray('i', 4)
    _rotationPeriod_ms = reader.read('I')
    _relativeToX = reader.read('f')
    _relativeToY = reader.read('f')
    _makeRelative = reader.read('B')
    _robotID = reader.read('B')
    return cls(_objectID, _onColor, _offColor, _onPeriod_ms, _offPeriod_ms, _transitionOnPeriod_ms, _transitionOffPeriod_ms, _offset, _rotationPeriod_ms, _relativeToX, _relativeToY, _makeRelative, _robotID)

  def pack(self):
    "Writes the current SetAllActiveObjectLEDs, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetAllActiveObjectLEDs to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write_farray(self._onColor, 'I', 4)
    writer.write_farray(self._offColor, 'I', 4)
    writer.write_farray(self._onPeriod_ms, 'I', 4)
    writer.write_farray(self._offPeriod_ms, 'I', 4)
    writer.write_farray(self._transitionOnPeriod_ms, 'I', 4)
    writer.write_farray(self._transitionOffPeriod_ms, 'I', 4)
    writer.write_farray(self._offset, 'i', 4)
    writer.write(self._rotationPeriod_ms, 'I')
    writer.write(self._relativeToX, 'f')
    writer.write(self._relativeToY, 'f')
    writer.write(self._makeRelative, 'B')
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._onColor == other._onColor and
        self._offColor == other._offColor and
        self._onPeriod_ms == other._onPeriod_ms and
        self._offPeriod_ms == other._offPeriod_ms and
        self._transitionOnPeriod_ms == other._transitionOnPeriod_ms and
        self._transitionOffPeriod_ms == other._transitionOffPeriod_ms and
        self._offset == other._offset and
        self._rotationPeriod_ms == other._rotationPeriod_ms and
        self._relativeToX == other._relativeToX and
        self._relativeToY == other._relativeToY and
        self._makeRelative == other._makeRelative and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size_farray(self._onColor, 'I', 4) +
      msgbuffers.size_farray(self._offColor, 'I', 4) +
      msgbuffers.size_farray(self._onPeriod_ms, 'I', 4) +
      msgbuffers.size_farray(self._offPeriod_ms, 'I', 4) +
      msgbuffers.size_farray(self._transitionOnPeriod_ms, 'I', 4) +
      msgbuffers.size_farray(self._transitionOffPeriod_ms, 'I', 4) +
      msgbuffers.size_farray(self._offset, 'i', 4) +
      msgbuffers.size(self._rotationPeriod_ms, 'I') +
      msgbuffers.size(self._relativeToX, 'f') +
      msgbuffers.size(self._relativeToY, 'f') +
      msgbuffers.size(self._makeRelative, 'B') +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(objectID={objectID}, onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, rotationPeriod_ms={rotationPeriod_ms}, relativeToX={relativeToX}, relativeToY={relativeToY}, makeRelative={makeRelative}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      onColor=msgbuffers.shorten_sequence(self._onColor),
      offColor=msgbuffers.shorten_sequence(self._offColor),
      onPeriod_ms=msgbuffers.shorten_sequence(self._onPeriod_ms),
      offPeriod_ms=msgbuffers.shorten_sequence(self._offPeriod_ms),
      transitionOnPeriod_ms=msgbuffers.shorten_sequence(self._transitionOnPeriod_ms),
      transitionOffPeriod_ms=msgbuffers.shorten_sequence(self._transitionOffPeriod_ms),
      offset=msgbuffers.shorten_sequence(self._offset),
      rotationPeriod_ms=self._rotationPeriod_ms,
      relativeToX=self._relativeToX,
      relativeToY=self._relativeToY,
      makeRelative=self._makeRelative,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(objectID={objectID}, onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, rotationPeriod_ms={rotationPeriod_ms}, relativeToX={relativeToX}, relativeToY={relativeToY}, makeRelative={makeRelative}, robotID={robotID})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      onColor=repr(self._onColor),
      offColor=repr(self._offColor),
      onPeriod_ms=repr(self._onPeriod_ms),
      offPeriod_ms=repr(self._offPeriod_ms),
      transitionOnPeriod_ms=repr(self._transitionOnPeriod_ms),
      transitionOffPeriod_ms=repr(self._transitionOffPeriod_ms),
      offset=repr(self._offset),
      rotationPeriod_ms=repr(self._rotationPeriod_ms),
      relativeToX=repr(self._relativeToX),
      relativeToY=repr(self._relativeToY),
      makeRelative=repr(self._makeRelative),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs = SetAllActiveObjectLEDs
del SetAllActiveObjectLEDs


class SetBackpackLEDs(object):
  "Generated message-passing message."

  __slots__ = (
    '_onColor',                # uint_32[5]
    '_offColor',               # uint_32[5]
    '_onPeriod_ms',            # uint_32[5]
    '_offPeriod_ms',           # uint_32[5]
    '_transitionOnPeriod_ms',  # uint_32[5]
    '_transitionOffPeriod_ms', # uint_32[5]
    '_offset',                 # int_32[5]
    '_robotID',                # uint_8
  )

  @property
  def onColor(self):
    "uint_32[5] onColor struct property."
    return self._onColor

  @onColor.setter
  def onColor(self, value):
    self._onColor = msgbuffers.validate_farray(
      'SetBackpackLEDs.onColor', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offColor(self):
    "uint_32[5] offColor struct property."
    return self._offColor

  @offColor.setter
  def offColor(self, value):
    self._offColor = msgbuffers.validate_farray(
      'SetBackpackLEDs.offColor', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def onPeriod_ms(self):
    "uint_32[5] onPeriod_ms struct property."
    return self._onPeriod_ms

  @onPeriod_ms.setter
  def onPeriod_ms(self, value):
    self._onPeriod_ms = msgbuffers.validate_farray(
      'SetBackpackLEDs.onPeriod_ms', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offPeriod_ms(self):
    "uint_32[5] offPeriod_ms struct property."
    return self._offPeriod_ms

  @offPeriod_ms.setter
  def offPeriod_ms(self, value):
    self._offPeriod_ms = msgbuffers.validate_farray(
      'SetBackpackLEDs.offPeriod_ms', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def transitionOnPeriod_ms(self):
    "uint_32[5] transitionOnPeriod_ms struct property."
    return self._transitionOnPeriod_ms

  @transitionOnPeriod_ms.setter
  def transitionOnPeriod_ms(self, value):
    self._transitionOnPeriod_ms = msgbuffers.validate_farray(
      'SetBackpackLEDs.transitionOnPeriod_ms', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def transitionOffPeriod_ms(self):
    "uint_32[5] transitionOffPeriod_ms struct property."
    return self._transitionOffPeriod_ms

  @transitionOffPeriod_ms.setter
  def transitionOffPeriod_ms(self, value):
    self._transitionOffPeriod_ms = msgbuffers.validate_farray(
      'SetBackpackLEDs.transitionOffPeriod_ms', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 4294967295))

  @property
  def offset(self):
    "int_32[5] offset struct property."
    return self._offset

  @offset.setter
  def offset(self, value):
    self._offset = msgbuffers.validate_farray(
      'SetBackpackLEDs.offset', value, 5,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetBackpackLEDs.robotID', value, 0, 255)

  def __init__(self, onColor=(0,) * 5, offColor=(0,) * 5, onPeriod_ms=(0,) * 5, offPeriod_ms=(0,) * 5, transitionOnPeriod_ms=(0,) * 5, transitionOffPeriod_ms=(0,) * 5, offset=(0,) * 5, robotID=0):
    self.onColor = onColor
    self.offColor = offColor
    self.onPeriod_ms = onPeriod_ms
    self.offPeriod_ms = offPeriod_ms
    self.transitionOnPeriod_ms = transitionOnPeriod_ms
    self.transitionOffPeriod_ms = transitionOffPeriod_ms
    self.offset = offset
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetBackpackLEDs from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetBackpackLEDs.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetBackpackLEDs from the given BinaryReader."
    _onColor = reader.read_farray('I', 5)
    _offColor = reader.read_farray('I', 5)
    _onPeriod_ms = reader.read_farray('I', 5)
    _offPeriod_ms = reader.read_farray('I', 5)
    _transitionOnPeriod_ms = reader.read_farray('I', 5)
    _transitionOffPeriod_ms = reader.read_farray('I', 5)
    _offset = reader.read_farray('i', 5)
    _robotID = reader.read('B')
    return cls(_onColor, _offColor, _onPeriod_ms, _offPeriod_ms, _transitionOnPeriod_ms, _transitionOffPeriod_ms, _offset, _robotID)

  def pack(self):
    "Writes the current SetBackpackLEDs, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetBackpackLEDs to the given BinaryWriter."
    writer.write_farray(self._onColor, 'I', 5)
    writer.write_farray(self._offColor, 'I', 5)
    writer.write_farray(self._onPeriod_ms, 'I', 5)
    writer.write_farray(self._offPeriod_ms, 'I', 5)
    writer.write_farray(self._transitionOnPeriod_ms, 'I', 5)
    writer.write_farray(self._transitionOffPeriod_ms, 'I', 5)
    writer.write_farray(self._offset, 'i', 5)
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._onColor == other._onColor and
        self._offColor == other._offColor and
        self._onPeriod_ms == other._onPeriod_ms and
        self._offPeriod_ms == other._offPeriod_ms and
        self._transitionOnPeriod_ms == other._transitionOnPeriod_ms and
        self._transitionOffPeriod_ms == other._transitionOffPeriod_ms and
        self._offset == other._offset and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._onColor, 'I', 5) +
      msgbuffers.size_farray(self._offColor, 'I', 5) +
      msgbuffers.size_farray(self._onPeriod_ms, 'I', 5) +
      msgbuffers.size_farray(self._offPeriod_ms, 'I', 5) +
      msgbuffers.size_farray(self._transitionOnPeriod_ms, 'I', 5) +
      msgbuffers.size_farray(self._transitionOffPeriod_ms, 'I', 5) +
      msgbuffers.size_farray(self._offset, 'i', 5) +
      msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, robotID={robotID})'.format(
      type=type(self).__name__,
      onColor=msgbuffers.shorten_sequence(self._onColor),
      offColor=msgbuffers.shorten_sequence(self._offColor),
      onPeriod_ms=msgbuffers.shorten_sequence(self._onPeriod_ms),
      offPeriod_ms=msgbuffers.shorten_sequence(self._offPeriod_ms),
      transitionOnPeriod_ms=msgbuffers.shorten_sequence(self._transitionOnPeriod_ms),
      transitionOffPeriod_ms=msgbuffers.shorten_sequence(self._transitionOffPeriod_ms),
      offset=msgbuffers.shorten_sequence(self._offset),
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(onColor={onColor}, offColor={offColor}, onPeriod_ms={onPeriod_ms}, offPeriod_ms={offPeriod_ms}, transitionOnPeriod_ms={transitionOnPeriod_ms}, transitionOffPeriod_ms={transitionOffPeriod_ms}, offset={offset}, robotID={robotID})'.format(
      type=type(self).__name__,
      onColor=repr(self._onColor),
      offColor=repr(self._offColor),
      onPeriod_ms=repr(self._onPeriod_ms),
      offPeriod_ms=repr(self._offPeriod_ms),
      transitionOnPeriod_ms=repr(self._transitionOnPeriod_ms),
      transitionOffPeriod_ms=repr(self._transitionOffPeriod_ms),
      offset=repr(self._offset),
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.SetBackpackLEDs = SetBackpackLEDs
del SetBackpackLEDs


class EnableLightStates(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable',   # bool
    '_objectID', # int_32
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableLightStates.enable', value)

  @property
  def objectID(self):
    "int_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'EnableLightStates.objectID', value, -2147483648, 2147483647)

  def __init__(self, enable=False, objectID=-1):
    self.enable = enable
    self.objectID = objectID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableLightStates from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableLightStates.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableLightStates from the given BinaryReader."
    _enable = bool(reader.read('b'))
    _objectID = reader.read('i')
    return cls(_enable, _objectID)

  def pack(self):
    "Writes the current EnableLightStates, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableLightStates to the given BinaryWriter."
    writer.write(int(self._enable), 'b')
    writer.write(self._objectID, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enable == other._enable and
        self._objectID == other._objectID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b') +
      msgbuffers.size(self._objectID, 'i'))

  def __str__(self):
    return '{type}(enable={enable}, objectID={objectID})'.format(
      type=type(self).__name__,
      enable=self._enable,
      objectID=self._objectID)

  def __repr__(self):
    return '{type}(enable={enable}, objectID={objectID})'.format(
      type=type(self).__name__,
      enable=repr(self._enable),
      objectID=repr(self._objectID))

Anki.Cozmo.ExternalInterface.EnableLightStates = EnableLightStates
del EnableLightStates


class EnableCubeSleep(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableCubeSleep.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableCubeSleep from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableCubeSleep.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableCubeSleep from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current EnableCubeSleep, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableCubeSleep to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableCubeSleep = EnableCubeSleep
del EnableCubeSleep


class EnableCubeLightsStateTransitionMessages(object):
  "Generated message-passing message."

  __slots__ = (
    '_enable', # bool
  )

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'EnableCubeLightsStateTransitionMessages.enable', value)

  def __init__(self, enable=False):
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableCubeLightsStateTransitionMessages from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableCubeLightsStateTransitionMessages.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableCubeLightsStateTransitionMessages from the given BinaryReader."
    _enable = bool(reader.read('b'))
    return cls(_enable)

  def pack(self):
    "Writes the current EnableCubeLightsStateTransitionMessages, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableCubeLightsStateTransitionMessages to the given BinaryWriter."
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enable == other._enable
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=self._enable)

  def __repr__(self):
    return '{type}(enable={enable})'.format(
      type=type(self).__name__,
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages = EnableCubeLightsStateTransitionMessages
del EnableCubeLightsStateTransitionMessages


class FlashCurrentLightsState(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID', # uint_32
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'FlashCurrentLightsState.objectID', value, 0, 4294967295)

  def __init__(self, objectID=0):
    self.objectID = objectID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FlashCurrentLightsState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FlashCurrentLightsState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FlashCurrentLightsState from the given BinaryReader."
    _objectID = reader.read('I')
    return cls(_objectID)

  def pack(self):
    "Writes the current FlashCurrentLightsState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FlashCurrentLightsState to the given BinaryWriter."
    writer.write(self._objectID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._objectID == other._objectID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I'))

  def __str__(self):
    return '{type}(objectID={objectID})'.format(
      type=type(self).__name__,
      objectID=self._objectID)

  def __repr__(self):
    return '{type}(objectID={objectID})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID))

Anki.Cozmo.ExternalInterface.FlashCurrentLightsState = FlashCurrentLightsState
del FlashCurrentLightsState


class TransitionToNextOnboardingState(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TransitionToNextOnboardingState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TransitionToNextOnboardingState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TransitionToNextOnboardingState from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current TransitionToNextOnboardingState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TransitionToNextOnboardingState to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState = TransitionToNextOnboardingState
del TransitionToNextOnboardingState


class GetEmotions(object):
  "Generated message-passing structure."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetEmotions from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetEmotions.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetEmotions from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GetEmotions, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetEmotions to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GetEmotions = GetEmotions
del GetEmotions


class SetEmotion(object):
  "Generated message-passing structure."

  __slots__ = (
    '_emotionType', # Anki.Cozmo.EmotionType
    '_newVal',      # float_32
  )

  @property
  def emotionType(self):
    "Anki.Cozmo.EmotionType emotionType struct property."
    return self._emotionType

  @emotionType.setter
  def emotionType(self, value):
    self._emotionType = msgbuffers.validate_integer(
      'SetEmotion.emotionType', value, 0, 255)

  @property
  def newVal(self):
    "float_32 newVal struct property."
    return self._newVal

  @newVal.setter
  def newVal(self, value):
    self._newVal = msgbuffers.validate_float(
      'SetEmotion.newVal', value, 'f')

  def __init__(self, emotionType=Anki.Cozmo.EmotionType.Happy, newVal=0.0):
    self.emotionType = emotionType
    self.newVal = newVal

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetEmotion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetEmotion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetEmotion from the given BinaryReader."
    _emotionType = reader.read('B')
    _newVal = reader.read('f')
    return cls(_emotionType, _newVal)

  def pack(self):
    "Writes the current SetEmotion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetEmotion to the given BinaryWriter."
    writer.write(self._emotionType, 'B')
    writer.write(self._newVal, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._emotionType == other._emotionType and
        self._newVal == other._newVal)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._emotionType, 'B') +
      msgbuffers.size(self._newVal, 'f'))

  def __str__(self):
    return '{type}(emotionType={emotionType}, newVal={newVal})'.format(
      type=type(self).__name__,
      emotionType=self._emotionType,
      newVal=self._newVal)

  def __repr__(self):
    return '{type}(emotionType={emotionType}, newVal={newVal})'.format(
      type=type(self).__name__,
      emotionType=repr(self._emotionType),
      newVal=repr(self._newVal))

Anki.Cozmo.ExternalInterface.SetEmotion = SetEmotion
del SetEmotion


class AddToEmotion(object):
  "Generated message-passing structure."

  __slots__ = (
    '_emotionType',    # Anki.Cozmo.EmotionType
    '_deltaVal',       # float_32
    '_uniqueIdString', # string[uint_8]
  )

  @property
  def emotionType(self):
    "Anki.Cozmo.EmotionType emotionType struct property."
    return self._emotionType

  @emotionType.setter
  def emotionType(self, value):
    self._emotionType = msgbuffers.validate_integer(
      'AddToEmotion.emotionType', value, 0, 255)

  @property
  def deltaVal(self):
    "float_32 deltaVal struct property."
    return self._deltaVal

  @deltaVal.setter
  def deltaVal(self, value):
    self._deltaVal = msgbuffers.validate_float(
      'AddToEmotion.deltaVal', value, 'f')

  @property
  def uniqueIdString(self):
    "string[uint_8] uniqueIdString struct property."
    return self._uniqueIdString

  @uniqueIdString.setter
  def uniqueIdString(self, value):
    self._uniqueIdString = msgbuffers.validate_string(
      'AddToEmotion.uniqueIdString', value, 255)

  def __init__(self, emotionType=Anki.Cozmo.EmotionType.Happy, deltaVal=0.0, uniqueIdString=''):
    self.emotionType = emotionType
    self.deltaVal = deltaVal
    self.uniqueIdString = uniqueIdString

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AddToEmotion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AddToEmotion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AddToEmotion from the given BinaryReader."
    _emotionType = reader.read('B')
    _deltaVal = reader.read('f')
    _uniqueIdString = reader.read_string('B')
    return cls(_emotionType, _deltaVal, _uniqueIdString)

  def pack(self):
    "Writes the current AddToEmotion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AddToEmotion to the given BinaryWriter."
    writer.write(self._emotionType, 'B')
    writer.write(self._deltaVal, 'f')
    writer.write_string(self._uniqueIdString, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._emotionType == other._emotionType and
        self._deltaVal == other._deltaVal and
        self._uniqueIdString == other._uniqueIdString)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._emotionType, 'B') +
      msgbuffers.size(self._deltaVal, 'f') +
      msgbuffers.size_string(self._uniqueIdString, 'B'))

  def __str__(self):
    return '{type}(emotionType={emotionType}, deltaVal={deltaVal}, uniqueIdString={uniqueIdString})'.format(
      type=type(self).__name__,
      emotionType=self._emotionType,
      deltaVal=self._deltaVal,
      uniqueIdString=msgbuffers.shorten_string(self._uniqueIdString))

  def __repr__(self):
    return '{type}(emotionType={emotionType}, deltaVal={deltaVal}, uniqueIdString={uniqueIdString})'.format(
      type=type(self).__name__,
      emotionType=repr(self._emotionType),
      deltaVal=repr(self._deltaVal),
      uniqueIdString=repr(self._uniqueIdString))

Anki.Cozmo.ExternalInterface.AddToEmotion = AddToEmotion
del AddToEmotion


class TriggerEmotionEvent(object):
  "Generated message-passing structure."

  __slots__ = (
    '_emotionEventName', # string[uint_8]
  )

  @property
  def emotionEventName(self):
    "string[uint_8] emotionEventName struct property."
    return self._emotionEventName

  @emotionEventName.setter
  def emotionEventName(self, value):
    self._emotionEventName = msgbuffers.validate_string(
      'TriggerEmotionEvent.emotionEventName', value, 255)

  def __init__(self, emotionEventName=''):
    self.emotionEventName = emotionEventName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TriggerEmotionEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TriggerEmotionEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TriggerEmotionEvent from the given BinaryReader."
    _emotionEventName = reader.read_string('B')
    return cls(_emotionEventName)

  def pack(self):
    "Writes the current TriggerEmotionEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TriggerEmotionEvent to the given BinaryWriter."
    writer.write_string(self._emotionEventName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._emotionEventName == other._emotionEventName
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._emotionEventName, 'B'))

  def __str__(self):
    return '{type}(emotionEventName={emotionEventName})'.format(
      type=type(self).__name__,
      emotionEventName=msgbuffers.shorten_string(self._emotionEventName))

  def __repr__(self):
    return '{type}(emotionEventName={emotionEventName})'.format(
      type=type(self).__name__,
      emotionEventName=repr(self._emotionEventName))

Anki.Cozmo.ExternalInterface.TriggerEmotionEvent = TriggerEmotionEvent
del TriggerEmotionEvent


class MoodMessageUnion(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    GetEmotions         = 0 # Anki.Cozmo.ExternalInterface.GetEmotions
    SetEmotion          = 1 # Anki.Cozmo.ExternalInterface.SetEmotion
    AddToEmotion        = 2 # Anki.Cozmo.ExternalInterface.AddToEmotion
    TriggerEmotionEvent = 3 # Anki.Cozmo.ExternalInterface.TriggerEmotionEvent

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def GetEmotions(self):
    "Anki.Cozmo.ExternalInterface.GetEmotions GetEmotions union property."
    msgbuffers.safety_check_tag('GetEmotions', self._tag, self.Tag.GetEmotions, self._tags_by_value)
    return self._data

  @GetEmotions.setter
  def GetEmotions(self, value):
    self._data = msgbuffers.validate_object(
      'MoodMessageUnion.GetEmotions', value, Anki.Cozmo.ExternalInterface.GetEmotions)
    self._tag = self.Tag.GetEmotions

  @property
  def SetEmotion(self):
    "Anki.Cozmo.ExternalInterface.SetEmotion SetEmotion union property."
    msgbuffers.safety_check_tag('SetEmotion', self._tag, self.Tag.SetEmotion, self._tags_by_value)
    return self._data

  @SetEmotion.setter
  def SetEmotion(self, value):
    self._data = msgbuffers.validate_object(
      'MoodMessageUnion.SetEmotion', value, Anki.Cozmo.ExternalInterface.SetEmotion)
    self._tag = self.Tag.SetEmotion

  @property
  def AddToEmotion(self):
    "Anki.Cozmo.ExternalInterface.AddToEmotion AddToEmotion union property."
    msgbuffers.safety_check_tag('AddToEmotion', self._tag, self.Tag.AddToEmotion, self._tags_by_value)
    return self._data

  @AddToEmotion.setter
  def AddToEmotion(self, value):
    self._data = msgbuffers.validate_object(
      'MoodMessageUnion.AddToEmotion', value, Anki.Cozmo.ExternalInterface.AddToEmotion)
    self._tag = self.Tag.AddToEmotion

  @property
  def TriggerEmotionEvent(self):
    "Anki.Cozmo.ExternalInterface.TriggerEmotionEvent TriggerEmotionEvent union property."
    msgbuffers.safety_check_tag('TriggerEmotionEvent', self._tag, self.Tag.TriggerEmotionEvent, self._tags_by_value)
    return self._data

  @TriggerEmotionEvent.setter
  def TriggerEmotionEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MoodMessageUnion.TriggerEmotionEvent', value, Anki.Cozmo.ExternalInterface.TriggerEmotionEvent)
    self._tag = self.Tag.TriggerEmotionEvent

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MoodMessageUnion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MoodMessageUnion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MoodMessageUnion from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MoodMessageUnion attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MoodMessageUnion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MoodMessageUnion.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 4:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 4:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 4:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    GetEmotions=0,
    SetEmotion=1,
    AddToEmotion=2,
    TriggerEmotionEvent=3,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'GetEmotions'
  _tags_by_value[1] = 'SetEmotion'
  _tags_by_value[2] = 'AddToEmotion'
  _tags_by_value[3] = 'TriggerEmotionEvent'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetEmotions.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetEmotion.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AddToEmotion.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TriggerEmotionEvent.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.ExternalInterface.GetEmotions
  _type_by_tag_value[1] = lambda : Anki.Cozmo.ExternalInterface.SetEmotion
  _type_by_tag_value[2] = lambda : Anki.Cozmo.ExternalInterface.AddToEmotion
  _type_by_tag_value[3] = lambda : Anki.Cozmo.ExternalInterface.TriggerEmotionEvent
  

Anki.Cozmo.ExternalInterface.MoodMessageUnion = MoodMessageUnion
del MoodMessageUnion


class MoodMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',          # uint_8
    '_MoodMessageUnion', # Anki.Cozmo.ExternalInterface.MoodMessageUnion
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'MoodMessage.robotID', value, 0, 255)

  @property
  def MoodMessageUnion(self):
    "Anki.Cozmo.ExternalInterface.MoodMessageUnion MoodMessageUnion struct property."
    return self._MoodMessageUnion

  @MoodMessageUnion.setter
  def MoodMessageUnion(self, value):
    self._MoodMessageUnion = msgbuffers.validate_object(
      'MoodMessage.MoodMessageUnion', value, Anki.Cozmo.ExternalInterface.MoodMessageUnion)

  def __init__(self, robotID=0, MoodMessageUnion=Anki.Cozmo.ExternalInterface.MoodMessageUnion()):
    self.robotID = robotID
    self.MoodMessageUnion = MoodMessageUnion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MoodMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MoodMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MoodMessage from the given BinaryReader."
    _robotID = reader.read('B')
    _MoodMessageUnion = reader.read_object(Anki.Cozmo.ExternalInterface.MoodMessageUnion.unpack_from)
    return cls(_robotID, _MoodMessageUnion)

  def pack(self):
    "Writes the current MoodMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MoodMessage to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write_object(self._MoodMessageUnion)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._MoodMessageUnion == other._MoodMessageUnion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size_object(self._MoodMessageUnion))

  def __str__(self):
    return '{type}(robotID={robotID}, MoodMessageUnion={MoodMessageUnion})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      MoodMessageUnion=self._MoodMessageUnion)

  def __repr__(self):
    return '{type}(robotID={robotID}, MoodMessageUnion={MoodMessageUnion})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      MoodMessageUnion=repr(self._MoodMessageUnion))

Anki.Cozmo.ExternalInterface.MoodMessage = MoodMessage
del MoodMessage


class SetFriendshipPoints(object):
  "Generated message-passing structure."

  __slots__ = (
    '_newVal', # int_32
  )

  @property
  def newVal(self):
    "int_32 newVal struct property."
    return self._newVal

  @newVal.setter
  def newVal(self, value):
    self._newVal = msgbuffers.validate_integer(
      'SetFriendshipPoints.newVal', value, -2147483648, 2147483647)

  def __init__(self, newVal=0):
    self.newVal = newVal

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetFriendshipPoints from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetFriendshipPoints.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetFriendshipPoints from the given BinaryReader."
    _newVal = reader.read('i')
    return cls(_newVal)

  def pack(self):
    "Writes the current SetFriendshipPoints, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetFriendshipPoints to the given BinaryWriter."
    writer.write(self._newVal, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._newVal == other._newVal
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._newVal, 'i'))

  def __str__(self):
    return '{type}(newVal={newVal})'.format(
      type=type(self).__name__,
      newVal=self._newVal)

  def __repr__(self):
    return '{type}(newVal={newVal})'.format(
      type=type(self).__name__,
      newVal=repr(self._newVal))

Anki.Cozmo.ExternalInterface.SetFriendshipPoints = SetFriendshipPoints
del SetFriendshipPoints


class SetFriendshipLevel(object):
  "Generated message-passing structure."

  __slots__ = (
    '_newVal', # int_32
  )

  @property
  def newVal(self):
    "int_32 newVal struct property."
    return self._newVal

  @newVal.setter
  def newVal(self, value):
    self._newVal = msgbuffers.validate_integer(
      'SetFriendshipLevel.newVal', value, -2147483648, 2147483647)

  def __init__(self, newVal=0):
    self.newVal = newVal

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetFriendshipLevel from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetFriendshipLevel.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetFriendshipLevel from the given BinaryReader."
    _newVal = reader.read('i')
    return cls(_newVal)

  def pack(self):
    "Writes the current SetFriendshipLevel, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetFriendshipLevel to the given BinaryWriter."
    writer.write(self._newVal, 'i')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._newVal == other._newVal
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._newVal, 'i'))

  def __str__(self):
    return '{type}(newVal={newVal})'.format(
      type=type(self).__name__,
      newVal=self._newVal)

  def __repr__(self):
    return '{type}(newVal={newVal})'.format(
      type=type(self).__name__,
      newVal=repr(self._newVal))

Anki.Cozmo.ExternalInterface.SetFriendshipLevel = SetFriendshipLevel
del SetFriendshipLevel


class ProgressionMessageUnion(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    SetFriendshipPoints = 0 # Anki.Cozmo.ExternalInterface.SetFriendshipPoints
    SetFriendshipLevel  = 1 # Anki.Cozmo.ExternalInterface.SetFriendshipLevel

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def SetFriendshipPoints(self):
    "Anki.Cozmo.ExternalInterface.SetFriendshipPoints SetFriendshipPoints union property."
    msgbuffers.safety_check_tag('SetFriendshipPoints', self._tag, self.Tag.SetFriendshipPoints, self._tags_by_value)
    return self._data

  @SetFriendshipPoints.setter
  def SetFriendshipPoints(self, value):
    self._data = msgbuffers.validate_object(
      'ProgressionMessageUnion.SetFriendshipPoints', value, Anki.Cozmo.ExternalInterface.SetFriendshipPoints)
    self._tag = self.Tag.SetFriendshipPoints

  @property
  def SetFriendshipLevel(self):
    "Anki.Cozmo.ExternalInterface.SetFriendshipLevel SetFriendshipLevel union property."
    msgbuffers.safety_check_tag('SetFriendshipLevel', self._tag, self.Tag.SetFriendshipLevel, self._tags_by_value)
    return self._data

  @SetFriendshipLevel.setter
  def SetFriendshipLevel(self, value):
    self._data = msgbuffers.validate_object(
      'ProgressionMessageUnion.SetFriendshipLevel', value, Anki.Cozmo.ExternalInterface.SetFriendshipLevel)
    self._tag = self.Tag.SetFriendshipLevel

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ProgressionMessageUnion from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ProgressionMessageUnion.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ProgressionMessageUnion from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('ProgressionMessageUnion attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current ProgressionMessageUnion, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty ProgressionMessageUnion.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 2:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 2:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 2:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    SetFriendshipPoints=0,
    SetFriendshipLevel=1,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'SetFriendshipPoints'
  _tags_by_value[1] = 'SetFriendshipLevel'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetFriendshipPoints.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetFriendshipLevel.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.ExternalInterface.SetFriendshipPoints
  _type_by_tag_value[1] = lambda : Anki.Cozmo.ExternalInterface.SetFriendshipLevel
  

Anki.Cozmo.ExternalInterface.ProgressionMessageUnion = ProgressionMessageUnion
del ProgressionMessageUnion


class ProgressionMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',                 # uint_8
    '_ProgressionMessageUnion', # Anki.Cozmo.ExternalInterface.ProgressionMessageUnion
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ProgressionMessage.robotID', value, 0, 255)

  @property
  def ProgressionMessageUnion(self):
    "Anki.Cozmo.ExternalInterface.ProgressionMessageUnion ProgressionMessageUnion struct property."
    return self._ProgressionMessageUnion

  @ProgressionMessageUnion.setter
  def ProgressionMessageUnion(self, value):
    self._ProgressionMessageUnion = msgbuffers.validate_object(
      'ProgressionMessage.ProgressionMessageUnion', value, Anki.Cozmo.ExternalInterface.ProgressionMessageUnion)

  def __init__(self, robotID=0, ProgressionMessageUnion=Anki.Cozmo.ExternalInterface.ProgressionMessageUnion()):
    self.robotID = robotID
    self.ProgressionMessageUnion = ProgressionMessageUnion

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ProgressionMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ProgressionMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ProgressionMessage from the given BinaryReader."
    _robotID = reader.read('B')
    _ProgressionMessageUnion = reader.read_object(Anki.Cozmo.ExternalInterface.ProgressionMessageUnion.unpack_from)
    return cls(_robotID, _ProgressionMessageUnion)

  def pack(self):
    "Writes the current ProgressionMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ProgressionMessage to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write_object(self._ProgressionMessageUnion)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._ProgressionMessageUnion == other._ProgressionMessageUnion)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size_object(self._ProgressionMessageUnion))

  def __str__(self):
    return '{type}(robotID={robotID}, ProgressionMessageUnion={ProgressionMessageUnion})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      ProgressionMessageUnion=self._ProgressionMessageUnion)

  def __repr__(self):
    return '{type}(robotID={robotID}, ProgressionMessageUnion={ProgressionMessageUnion})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      ProgressionMessageUnion=repr(self._ProgressionMessageUnion))

Anki.Cozmo.ExternalInterface.ProgressionMessage = ProgressionMessage
del ProgressionMessage


class RequestSetUnlock(object):
  "Generated message-passing message."

  __slots__ = (
    '_unlockID', # Anki.Cozmo.UnlockId
    '_unlocked', # bool
  )

  @property
  def unlockID(self):
    "Anki.Cozmo.UnlockId unlockID struct property."
    return self._unlockID

  @unlockID.setter
  def unlockID(self, value):
    self._unlockID = msgbuffers.validate_integer(
      'RequestSetUnlock.unlockID', value, -2147483648, 2147483647)

  @property
  def unlocked(self):
    "bool unlocked struct property."
    return self._unlocked

  @unlocked.setter
  def unlocked(self, value):
    self._unlocked = msgbuffers.validate_bool(
      'RequestSetUnlock.unlocked', value)

  def __init__(self, unlockID=Anki.Cozmo.UnlockId.Invalid, unlocked=False):
    self.unlockID = unlockID
    self.unlocked = unlocked

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestSetUnlock from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestSetUnlock.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestSetUnlock from the given BinaryReader."
    _unlockID = reader.read('i')
    _unlocked = bool(reader.read('b'))
    return cls(_unlockID, _unlocked)

  def pack(self):
    "Writes the current RequestSetUnlock, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestSetUnlock to the given BinaryWriter."
    writer.write(self._unlockID, 'i')
    writer.write(int(self._unlocked), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._unlockID == other._unlockID and
        self._unlocked == other._unlocked)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._unlockID, 'i') +
      msgbuffers.size(self._unlocked, 'b'))

  def __str__(self):
    return '{type}(unlockID={unlockID}, unlocked={unlocked})'.format(
      type=type(self).__name__,
      unlockID=self._unlockID,
      unlocked=self._unlocked)

  def __repr__(self):
    return '{type}(unlockID={unlockID}, unlocked={unlocked})'.format(
      type=type(self).__name__,
      unlockID=repr(self._unlockID),
      unlocked=repr(self._unlocked))

Anki.Cozmo.ExternalInterface.RequestSetUnlock = RequestSetUnlock
del RequestSetUnlock


class RequestDeviceData(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RequestDeviceData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RequestDeviceData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RequestDeviceData from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current RequestDeviceData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RequestDeviceData to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.RequestDeviceData = RequestDeviceData
del RequestDeviceData


class SetDebugConsoleVarMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_varName',  # string[uint_8]
    '_tryValue', # string[uint_8]
  )

  @property
  def varName(self):
    "string[uint_8] varName struct property."
    return self._varName

  @varName.setter
  def varName(self, value):
    self._varName = msgbuffers.validate_string(
      'SetDebugConsoleVarMessage.varName', value, 255)

  @property
  def tryValue(self):
    "string[uint_8] tryValue struct property."
    return self._tryValue

  @tryValue.setter
  def tryValue(self, value):
    self._tryValue = msgbuffers.validate_string(
      'SetDebugConsoleVarMessage.tryValue', value, 255)

  def __init__(self, varName='', tryValue=''):
    self.varName = varName
    self.tryValue = tryValue

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetDebugConsoleVarMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetDebugConsoleVarMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetDebugConsoleVarMessage from the given BinaryReader."
    _varName = reader.read_string('B')
    _tryValue = reader.read_string('B')
    return cls(_varName, _tryValue)

  def pack(self):
    "Writes the current SetDebugConsoleVarMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetDebugConsoleVarMessage to the given BinaryWriter."
    writer.write_string(self._varName, 'B')
    writer.write_string(self._tryValue, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._varName == other._varName and
        self._tryValue == other._tryValue)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._varName, 'B') +
      msgbuffers.size_string(self._tryValue, 'B'))

  def __str__(self):
    return '{type}(varName={varName}, tryValue={tryValue})'.format(
      type=type(self).__name__,
      varName=msgbuffers.shorten_string(self._varName),
      tryValue=msgbuffers.shorten_string(self._tryValue))

  def __repr__(self):
    return '{type}(varName={varName}, tryValue={tryValue})'.format(
      type=type(self).__name__,
      varName=repr(self._varName),
      tryValue=repr(self._tryValue))

Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage = SetDebugConsoleVarMessage
del SetDebugConsoleVarMessage


class RunDebugConsoleFuncMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_funcName', # string[uint_8]
    '_funcArgs', # string[uint_8]
  )

  @property
  def funcName(self):
    "string[uint_8] funcName struct property."
    return self._funcName

  @funcName.setter
  def funcName(self, value):
    self._funcName = msgbuffers.validate_string(
      'RunDebugConsoleFuncMessage.funcName', value, 255)

  @property
  def funcArgs(self):
    "string[uint_8] funcArgs struct property."
    return self._funcArgs

  @funcArgs.setter
  def funcArgs(self, value):
    self._funcArgs = msgbuffers.validate_string(
      'RunDebugConsoleFuncMessage.funcArgs', value, 255)

  def __init__(self, funcName='', funcArgs=''):
    self.funcName = funcName
    self.funcArgs = funcArgs

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RunDebugConsoleFuncMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RunDebugConsoleFuncMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RunDebugConsoleFuncMessage from the given BinaryReader."
    _funcName = reader.read_string('B')
    _funcArgs = reader.read_string('B')
    return cls(_funcName, _funcArgs)

  def pack(self):
    "Writes the current RunDebugConsoleFuncMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RunDebugConsoleFuncMessage to the given BinaryWriter."
    writer.write_string(self._funcName, 'B')
    writer.write_string(self._funcArgs, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._funcName == other._funcName and
        self._funcArgs == other._funcArgs)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._funcName, 'B') +
      msgbuffers.size_string(self._funcArgs, 'B'))

  def __str__(self):
    return '{type}(funcName={funcName}, funcArgs={funcArgs})'.format(
      type=type(self).__name__,
      funcName=msgbuffers.shorten_string(self._funcName),
      funcArgs=msgbuffers.shorten_string(self._funcArgs))

  def __repr__(self):
    return '{type}(funcName={funcName}, funcArgs={funcArgs})'.format(
      type=type(self).__name__,
      funcName=repr(self._funcName),
      funcArgs=repr(self._funcArgs))

Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage = RunDebugConsoleFuncMessage
del RunDebugConsoleFuncMessage


class GetDebugConsoleVarMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_varName', # string[uint_8]
  )

  @property
  def varName(self):
    "string[uint_8] varName struct property."
    return self._varName

  @varName.setter
  def varName(self, value):
    self._varName = msgbuffers.validate_string(
      'GetDebugConsoleVarMessage.varName', value, 255)

  def __init__(self, varName=''):
    self.varName = varName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetDebugConsoleVarMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetDebugConsoleVarMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetDebugConsoleVarMessage from the given BinaryReader."
    _varName = reader.read_string('B')
    return cls(_varName)

  def pack(self):
    "Writes the current GetDebugConsoleVarMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetDebugConsoleVarMessage to the given BinaryWriter."
    writer.write_string(self._varName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._varName == other._varName
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._varName, 'B'))

  def __str__(self):
    return '{type}(varName={varName})'.format(
      type=type(self).__name__,
      varName=msgbuffers.shorten_string(self._varName))

  def __repr__(self):
    return '{type}(varName={varName})'.format(
      type=type(self).__name__,
      varName=repr(self._varName))

Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage = GetDebugConsoleVarMessage
del GetDebugConsoleVarMessage


class GetAllDebugConsoleVarMessage(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetAllDebugConsoleVarMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetAllDebugConsoleVarMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetAllDebugConsoleVarMessage from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GetAllDebugConsoleVarMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetAllDebugConsoleVarMessage to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage = GetAllDebugConsoleVarMessage
del GetAllDebugConsoleVarMessage


class GetJsonDasLogsMessage(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetJsonDasLogsMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetJsonDasLogsMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetJsonDasLogsMessage from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GetJsonDasLogsMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetJsonDasLogsMessage to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage = GetJsonDasLogsMessage
del GetJsonDasLogsMessage


class SetEnableSOSLogging(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'SetEnableSOSLogging.enabled', value)

  def __init__(self, enabled=False):
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetEnableSOSLogging from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetEnableSOSLogging.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetEnableSOSLogging from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    return cls(_enabled)

  def pack(self):
    "Writes the current SetEnableSOSLogging, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetEnableSOSLogging to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enabled == other._enabled
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled))

Anki.Cozmo.ExternalInterface.SetEnableSOSLogging = SetEnableSOSLogging
del SetEnableSOSLogging


class EnableReactionaryBehaviors(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'EnableReactionaryBehaviors.enabled', value)

  def __init__(self, enabled=False):
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableReactionaryBehaviors from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableReactionaryBehaviors.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableReactionaryBehaviors from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    return cls(_enabled)

  def pack(self):
    "Writes the current EnableReactionaryBehaviors, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableReactionaryBehaviors to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enabled == other._enabled
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled))

Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors = EnableReactionaryBehaviors
del EnableReactionaryBehaviors


class SetEnableSpeedChooser(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'SetEnableSpeedChooser.enabled', value)

  def __init__(self, enabled=False):
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetEnableSpeedChooser from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetEnableSpeedChooser.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetEnableSpeedChooser from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    return cls(_enabled)

  def pack(self):
    "Writes the current SetEnableSpeedChooser, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetEnableSpeedChooser to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._enabled == other._enabled
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(enabled={enabled})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled))

Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser = SetEnableSpeedChooser
del SetEnableSpeedChooser


class BlockPoolEnabledMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_discoveryTimeSecs', # float_32
    '_enabled',           # bool
  )

  @property
  def discoveryTimeSecs(self):
    "float_32 discoveryTimeSecs struct property."
    return self._discoveryTimeSecs

  @discoveryTimeSecs.setter
  def discoveryTimeSecs(self, value):
    self._discoveryTimeSecs = msgbuffers.validate_float(
      'BlockPoolEnabledMessage.discoveryTimeSecs', value, 'f')

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'BlockPoolEnabledMessage.enabled', value)

  def __init__(self, discoveryTimeSecs=0.0, enabled=False):
    self.discoveryTimeSecs = discoveryTimeSecs
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPoolEnabledMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPoolEnabledMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPoolEnabledMessage from the given BinaryReader."
    _discoveryTimeSecs = reader.read('f')
    _enabled = bool(reader.read('b'))
    return cls(_discoveryTimeSecs, _enabled)

  def pack(self):
    "Writes the current BlockPoolEnabledMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPoolEnabledMessage to the given BinaryWriter."
    writer.write(self._discoveryTimeSecs, 'f')
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._discoveryTimeSecs == other._discoveryTimeSecs and
        self._enabled == other._enabled)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._discoveryTimeSecs, 'f') +
      msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(discoveryTimeSecs={discoveryTimeSecs}, enabled={enabled})'.format(
      type=type(self).__name__,
      discoveryTimeSecs=self._discoveryTimeSecs,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(discoveryTimeSecs={discoveryTimeSecs}, enabled={enabled})'.format(
      type=type(self).__name__,
      discoveryTimeSecs=repr(self._discoveryTimeSecs),
      enabled=repr(self._enabled))

Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage = BlockPoolEnabledMessage
del BlockPoolEnabledMessage


class BlockSelectedMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_factoryId',  # uint_32
    '_objectType', # Anki.Cozmo.ObjectType
    '_selected',   # bool
  )

  @property
  def factoryId(self):
    "uint_32 factoryId struct property."
    return self._factoryId

  @factoryId.setter
  def factoryId(self, value):
    self._factoryId = msgbuffers.validate_integer(
      'BlockSelectedMessage.factoryId', value, 0, 4294967295)

  @property
  def objectType(self):
    "Anki.Cozmo.ObjectType objectType struct property."
    return self._objectType

  @objectType.setter
  def objectType(self, value):
    self._objectType = msgbuffers.validate_integer(
      'BlockSelectedMessage.objectType', value, -2147483648, 2147483647)

  @property
  def selected(self):
    "bool selected struct property."
    return self._selected

  @selected.setter
  def selected(self, value):
    self._selected = msgbuffers.validate_bool(
      'BlockSelectedMessage.selected', value)

  def __init__(self, factoryId=0, objectType=Anki.Cozmo.ObjectType.Invalid, selected=False):
    self.factoryId = factoryId
    self.objectType = objectType
    self.selected = selected

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockSelectedMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockSelectedMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockSelectedMessage from the given BinaryReader."
    _factoryId = reader.read('I')
    _objectType = reader.read('i')
    _selected = bool(reader.read('b'))
    return cls(_factoryId, _objectType, _selected)

  def pack(self):
    "Writes the current BlockSelectedMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockSelectedMessage to the given BinaryWriter."
    writer.write(self._factoryId, 'I')
    writer.write(self._objectType, 'i')
    writer.write(int(self._selected), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._factoryId == other._factoryId and
        self._objectType == other._objectType and
        self._selected == other._selected)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._factoryId, 'I') +
      msgbuffers.size(self._objectType, 'i') +
      msgbuffers.size(self._selected, 'b'))

  def __str__(self):
    return '{type}(factoryId={factoryId}, objectType={objectType}, selected={selected})'.format(
      type=type(self).__name__,
      factoryId=self._factoryId,
      objectType=self._objectType,
      selected=self._selected)

  def __repr__(self):
    return '{type}(factoryId={factoryId}, objectType={objectType}, selected={selected})'.format(
      type=type(self).__name__,
      factoryId=repr(self._factoryId),
      objectType=repr(self._objectType),
      selected=repr(self._selected))

Anki.Cozmo.ExternalInterface.BlockSelectedMessage = BlockSelectedMessage
del BlockSelectedMessage


class GetBlockPoolMessage(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new GetBlockPoolMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('GetBlockPoolMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new GetBlockPoolMessage from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current GetBlockPoolMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current GetBlockPoolMessage to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.GetBlockPoolMessage = GetBlockPoolMessage
del GetBlockPoolMessage


class SendAvailableObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
    '_enable',  # bool
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SendAvailableObjects.robotID', value, 0, 255)

  @property
  def enable(self):
    "bool enable struct property."
    return self._enable

  @enable.setter
  def enable(self, value):
    self._enable = msgbuffers.validate_bool(
      'SendAvailableObjects.enable', value)

  def __init__(self, robotID=0, enable=False):
    self.robotID = robotID
    self.enable = enable

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SendAvailableObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SendAvailableObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SendAvailableObjects from the given BinaryReader."
    _robotID = reader.read('B')
    _enable = bool(reader.read('b'))
    return cls(_robotID, _enable)

  def pack(self):
    "Writes the current SendAvailableObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SendAvailableObjects to the given BinaryWriter."
    writer.write(self._robotID, 'B')
    writer.write(int(self._enable), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._enable == other._enable)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B') +
      msgbuffers.size(self._enable, 'b'))

  def __str__(self):
    return '{type}(robotID={robotID}, enable={enable})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      enable=self._enable)

  def __repr__(self):
    return '{type}(robotID={robotID}, enable={enable})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      enable=repr(self._enable))

Anki.Cozmo.ExternalInterface.SendAvailableObjects = SendAvailableObjects
del SendAvailableObjects


class BlockPoolResetMessage(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BlockPoolResetMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BlockPoolResetMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BlockPoolResetMessage from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current BlockPoolResetMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BlockPoolResetMessage to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.BlockPoolResetMessage = BlockPoolResetMessage
del BlockPoolResetMessage


class SaveCalibrationImage(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SaveCalibrationImage.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveCalibrationImage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveCalibrationImage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveCalibrationImage from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current SaveCalibrationImage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveCalibrationImage to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.SaveCalibrationImage = SaveCalibrationImage
del SaveCalibrationImage


class ClearCalibrationImages(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ClearCalibrationImages.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ClearCalibrationImages from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ClearCalibrationImages.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ClearCalibrationImages from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current ClearCalibrationImages, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ClearCalibrationImages to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.ClearCalibrationImages = ClearCalibrationImages
del ClearCalibrationImages


class ComputeCameraCalibration(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID', # uint_8
  )

  @property
  def robotID(self):
    "uint_8 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ComputeCameraCalibration.robotID', value, 0, 255)

  def __init__(self, robotID=0):
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ComputeCameraCalibration from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ComputeCameraCalibration.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ComputeCameraCalibration from the given BinaryReader."
    _robotID = reader.read('B')
    return cls(_robotID)

  def pack(self):
    "Writes the current ComputeCameraCalibration, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ComputeCameraCalibration to the given BinaryWriter."
    writer.write(self._robotID, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._robotID == other._robotID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'B'))

  def __str__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(robotID={robotID})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID))

Anki.Cozmo.ExternalInterface.ComputeCameraCalibration = ComputeCameraCalibration
del ComputeCameraCalibration


class ContinueFreeplayFromIdle(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ContinueFreeplayFromIdle from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ContinueFreeplayFromIdle.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ContinueFreeplayFromIdle from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ContinueFreeplayFromIdle, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ContinueFreeplayFromIdle to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle = ContinueFreeplayFromIdle
del ContinueFreeplayFromIdle


class EnableDroneMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_isStarted', # bool
  )

  @property
  def isStarted(self):
    "bool isStarted struct property."
    return self._isStarted

  @isStarted.setter
  def isStarted(self, value):
    self._isStarted = msgbuffers.validate_bool(
      'EnableDroneMode.isStarted', value)

  def __init__(self, isStarted=False):
    self.isStarted = isStarted

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnableDroneMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnableDroneMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnableDroneMode from the given BinaryReader."
    _isStarted = bool(reader.read('b'))
    return cls(_isStarted)

  def pack(self):
    "Writes the current EnableDroneMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnableDroneMode to the given BinaryWriter."
    writer.write(int(self._isStarted), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._isStarted == other._isStarted
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._isStarted, 'b'))

  def __str__(self):
    return '{type}(isStarted={isStarted})'.format(
      type=type(self).__name__,
      isStarted=self._isStarted)

  def __repr__(self):
    return '{type}(isStarted={isStarted})'.format(
      type=type(self).__name__,
      isStarted=repr(self._isStarted))

Anki.Cozmo.ExternalInterface.EnableDroneMode = EnableDroneMode
del EnableDroneMode


class EnterSdkMode(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnterSdkMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnterSdkMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnterSdkMode from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current EnterSdkMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnterSdkMode to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.EnterSdkMode = EnterSdkMode
del EnterSdkMode


class ExitSdkMode(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ExitSdkMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ExitSdkMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ExitSdkMode from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current ExitSdkMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ExitSdkMode to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.ExitSdkMode = ExitSdkMode
del ExitSdkMode


class SetStopRobotOnSdkDisconnect(object):
  "Generated message-passing message."

  __slots__ = (
    '_doStop', # bool
  )

  @property
  def doStop(self):
    "bool doStop struct property."
    return self._doStop

  @doStop.setter
  def doStop(self, value):
    self._doStop = msgbuffers.validate_bool(
      'SetStopRobotOnSdkDisconnect.doStop', value)

  def __init__(self, doStop=True):
    self.doStop = doStop

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetStopRobotOnSdkDisconnect from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetStopRobotOnSdkDisconnect.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetStopRobotOnSdkDisconnect from the given BinaryReader."
    _doStop = bool(reader.read('b'))
    return cls(_doStop)

  def pack(self):
    "Writes the current SetStopRobotOnSdkDisconnect, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetStopRobotOnSdkDisconnect to the given BinaryWriter."
    writer.write(int(self._doStop), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._doStop == other._doStop
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._doStop, 'b'))

  def __str__(self):
    return '{type}(doStop={doStop})'.format(
      type=type(self).__name__,
      doStop=self._doStop)

  def __repr__(self):
    return '{type}(doStop={doStop})'.format(
      type=type(self).__name__,
      doStop=repr(self._doStop))

Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect = SetStopRobotOnSdkDisconnect
del SetStopRobotOnSdkDisconnect


class StopRobotForSdk(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StopRobotForSdk from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StopRobotForSdk.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StopRobotForSdk from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current StopRobotForSdk, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StopRobotForSdk to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.StopRobotForSdk = StopRobotForSdk
del StopRobotForSdk


class FileType(object):
  "Automatically-generated uint_8 enumeration."
  Animation = 0
  FaceImg   = 1

Anki.Cozmo.ExternalInterface.FileType = FileType
del FileType


class TransferFile(object):
  "Generated message-passing message."

  __slots__ = (
    '_fileBytes',    # uint_8[uint_16]
    '_filePart',     # uint_8
    '_numFileParts', # uint_8
    '_filename',     # string[uint_8]
    '_fileType',     # Anki.Cozmo.ExternalInterface.FileType
  )

  @property
  def fileBytes(self):
    "uint_8[uint_16] fileBytes struct property."
    return self._fileBytes

  @fileBytes.setter
  def fileBytes(self, value):
    self._fileBytes = msgbuffers.validate_varray(
      'TransferFile.fileBytes', value, 65535,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def filePart(self):
    "uint_8 filePart struct property."
    return self._filePart

  @filePart.setter
  def filePart(self, value):
    self._filePart = msgbuffers.validate_integer(
      'TransferFile.filePart', value, 0, 255)

  @property
  def numFileParts(self):
    "uint_8 numFileParts struct property."
    return self._numFileParts

  @numFileParts.setter
  def numFileParts(self, value):
    self._numFileParts = msgbuffers.validate_integer(
      'TransferFile.numFileParts', value, 0, 255)

  @property
  def filename(self):
    "string[uint_8] filename struct property."
    return self._filename

  @filename.setter
  def filename(self, value):
    self._filename = msgbuffers.validate_string(
      'TransferFile.filename', value, 255)

  @property
  def fileType(self):
    "Anki.Cozmo.ExternalInterface.FileType fileType struct property."
    return self._fileType

  @fileType.setter
  def fileType(self, value):
    self._fileType = msgbuffers.validate_integer(
      'TransferFile.fileType', value, 0, 255)

  def __init__(self, fileBytes=(), filePart=0, numFileParts=0, filename='', fileType=Anki.Cozmo.ExternalInterface.FileType.Animation):
    self.fileBytes = fileBytes
    self.filePart = filePart
    self.numFileParts = numFileParts
    self.filename = filename
    self.fileType = fileType

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TransferFile from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TransferFile.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TransferFile from the given BinaryReader."
    _fileBytes = reader.read_varray('B', 'H')
    _filePart = reader.read('B')
    _numFileParts = reader.read('B')
    _filename = reader.read_string('B')
    _fileType = reader.read('B')
    return cls(_fileBytes, _filePart, _numFileParts, _filename, _fileType)

  def pack(self):
    "Writes the current TransferFile, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TransferFile to the given BinaryWriter."
    writer.write_varray(self._fileBytes, 'B', 'H')
    writer.write(self._filePart, 'B')
    writer.write(self._numFileParts, 'B')
    writer.write_string(self._filename, 'B')
    writer.write(self._fileType, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._fileBytes == other._fileBytes and
        self._filePart == other._filePart and
        self._numFileParts == other._numFileParts and
        self._filename == other._filename and
        self._fileType == other._fileType)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_varray(self._fileBytes, 'B', 'H') +
      msgbuffers.size(self._filePart, 'B') +
      msgbuffers.size(self._numFileParts, 'B') +
      msgbuffers.size_string(self._filename, 'B') +
      msgbuffers.size(self._fileType, 'B'))

  def __str__(self):
    return '{type}(fileBytes={fileBytes}, filePart={filePart}, numFileParts={numFileParts}, filename={filename}, fileType={fileType})'.format(
      type=type(self).__name__,
      fileBytes=msgbuffers.shorten_sequence(self._fileBytes),
      filePart=self._filePart,
      numFileParts=self._numFileParts,
      filename=msgbuffers.shorten_string(self._filename),
      fileType=self._fileType)

  def __repr__(self):
    return '{type}(fileBytes={fileBytes}, filePart={filePart}, numFileParts={numFileParts}, filename={filename}, fileType={fileType})'.format(
      type=type(self).__name__,
      fileBytes=repr(self._fileBytes),
      filePart=repr(self._filePart),
      numFileParts=repr(self._numFileParts),
      filename=repr(self._filename),
      fileType=repr(self._fileType))

Anki.Cozmo.ExternalInterface.TransferFile = TransferFile
del TransferFile


class NVStorageEraseEntry(object):
  "Generated message-passing message."

  __slots__ = (
    '_tag', # Anki.Cozmo.NVStorage.NVEntryTag
  )

  @property
  def tag(self):
    "Anki.Cozmo.NVStorage.NVEntryTag tag struct property."
    return self._tag

  @tag.setter
  def tag(self, value):
    self._tag = msgbuffers.validate_integer(
      'NVStorageEraseEntry.tag', value, 0, 4294967295)

  def __init__(self, tag=Anki.Cozmo.NVStorage.NVEntryTag.NVEntry_Invalid):
    self.tag = tag

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageEraseEntry from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageEraseEntry.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageEraseEntry from the given BinaryReader."
    _tag = reader.read('I')
    return cls(_tag)

  def pack(self):
    "Writes the current NVStorageEraseEntry, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageEraseEntry to the given BinaryWriter."
    writer.write(self._tag, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._tag, 'I'))

  def __str__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=self._tag)

  def __repr__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=repr(self._tag))

Anki.Cozmo.ExternalInterface.NVStorageEraseEntry = NVStorageEraseEntry
del NVStorageEraseEntry


class NVStorageWipeAll(object):
  "Generated message-passing message."

  __slots__ = (
    '_key', # string[uint_8]
  )

  @property
  def key(self):
    "string[uint_8] key struct property."
    return self._key

  @key.setter
  def key(self, value):
    self._key = msgbuffers.validate_string(
      'NVStorageWipeAll.key', value, 255)

  def __init__(self, key=''):
    self.key = key

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageWipeAll from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageWipeAll.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageWipeAll from the given BinaryReader."
    _key = reader.read_string('B')
    return cls(_key)

  def pack(self):
    "Writes the current NVStorageWipeAll, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageWipeAll to the given BinaryWriter."
    writer.write_string(self._key, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._key == other._key
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._key, 'B'))

  def __str__(self):
    return '{type}(key={key})'.format(
      type=type(self).__name__,
      key=msgbuffers.shorten_string(self._key))

  def __repr__(self):
    return '{type}(key={key})'.format(
      type=type(self).__name__,
      key=repr(self._key))

Anki.Cozmo.ExternalInterface.NVStorageWipeAll = NVStorageWipeAll
del NVStorageWipeAll


class NVStorageWriteEntry(object):
  "Generated message-passing message."

  __slots__ = (
    '_tag',           # Anki.Cozmo.NVStorage.NVEntryTag
    '_data',          # uint_8[uint_16]
    '_index',         # uint_8
    '_numTotalBlobs', # uint_8
  )

  @property
  def tag(self):
    "Anki.Cozmo.NVStorage.NVEntryTag tag struct property."
    return self._tag

  @tag.setter
  def tag(self, value):
    self._tag = msgbuffers.validate_integer(
      'NVStorageWriteEntry.tag', value, 0, 4294967295)

  @property
  def data(self):
    "uint_8[uint_16] data struct property."
    return self._data

  @data.setter
  def data(self, value):
    self._data = msgbuffers.validate_varray(
      'NVStorageWriteEntry.data', value, 65535,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def index(self):
    "uint_8 index struct property."
    return self._index

  @index.setter
  def index(self, value):
    self._index = msgbuffers.validate_integer(
      'NVStorageWriteEntry.index', value, 0, 255)

  @property
  def numTotalBlobs(self):
    "uint_8 numTotalBlobs struct property."
    return self._numTotalBlobs

  @numTotalBlobs.setter
  def numTotalBlobs(self, value):
    self._numTotalBlobs = msgbuffers.validate_integer(
      'NVStorageWriteEntry.numTotalBlobs', value, 0, 255)

  def __init__(self, tag=Anki.Cozmo.NVStorage.NVEntryTag.NVEntry_Invalid, data=(), index=0, numTotalBlobs=0):
    self.tag = tag
    self.data = data
    self.index = index
    self.numTotalBlobs = numTotalBlobs

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageWriteEntry from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageWriteEntry.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageWriteEntry from the given BinaryReader."
    _tag = reader.read('I')
    _data = reader.read_varray('B', 'H')
    _index = reader.read('B')
    _numTotalBlobs = reader.read('B')
    return cls(_tag, _data, _index, _numTotalBlobs)

  def pack(self):
    "Writes the current NVStorageWriteEntry, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageWriteEntry to the given BinaryWriter."
    writer.write(self._tag, 'I')
    writer.write_varray(self._data, 'B', 'H')
    writer.write(self._index, 'B')
    writer.write(self._numTotalBlobs, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._tag == other._tag and
        self._data == other._data and
        self._index == other._index and
        self._numTotalBlobs == other._numTotalBlobs)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._tag, 'I') +
      msgbuffers.size_varray(self._data, 'B', 'H') +
      msgbuffers.size(self._index, 'B') +
      msgbuffers.size(self._numTotalBlobs, 'B'))

  def __str__(self):
    return '{type}(tag={tag}, data={data}, index={index}, numTotalBlobs={numTotalBlobs})'.format(
      type=type(self).__name__,
      tag=self._tag,
      data=msgbuffers.shorten_sequence(self._data),
      index=self._index,
      numTotalBlobs=self._numTotalBlobs)

  def __repr__(self):
    return '{type}(tag={tag}, data={data}, index={index}, numTotalBlobs={numTotalBlobs})'.format(
      type=type(self).__name__,
      tag=repr(self._tag),
      data=repr(self._data),
      index=repr(self._index),
      numTotalBlobs=repr(self._numTotalBlobs))

Anki.Cozmo.ExternalInterface.NVStorageWriteEntry = NVStorageWriteEntry
del NVStorageWriteEntry


class NVStorageClearPartialPendingWriteEntry(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageClearPartialPendingWriteEntry from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageClearPartialPendingWriteEntry.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageClearPartialPendingWriteEntry from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current NVStorageClearPartialPendingWriteEntry, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageClearPartialPendingWriteEntry to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry = NVStorageClearPartialPendingWriteEntry
del NVStorageClearPartialPendingWriteEntry


class NVStorageReadEntry(object):
  "Generated message-passing message."

  __slots__ = (
    '_tag', # Anki.Cozmo.NVStorage.NVEntryTag
  )

  @property
  def tag(self):
    "Anki.Cozmo.NVStorage.NVEntryTag tag struct property."
    return self._tag

  @tag.setter
  def tag(self, value):
    self._tag = msgbuffers.validate_integer(
      'NVStorageReadEntry.tag', value, 0, 4294967295)

  def __init__(self, tag=Anki.Cozmo.NVStorage.NVEntryTag.NVEntry_Invalid):
    self.tag = tag

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NVStorageReadEntry from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NVStorageReadEntry.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NVStorageReadEntry from the given BinaryReader."
    _tag = reader.read('I')
    return cls(_tag)

  def pack(self):
    "Writes the current NVStorageReadEntry, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NVStorageReadEntry to the given BinaryWriter."
    writer.write(self._tag, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._tag, 'I'))

  def __str__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=self._tag)

  def __repr__(self):
    return '{type}(tag={tag})'.format(
      type=type(self).__name__,
      tag=repr(self._tag))

Anki.Cozmo.ExternalInterface.NVStorageReadEntry = NVStorageReadEntry
del NVStorageReadEntry


class SetCameraSettings(object):
  "Generated message-passing message."

  __slots__ = (
    '_exposure_ms', # uint_16
    '_gain',        # float_32
  )

  @property
  def exposure_ms(self):
    "uint_16 exposure_ms struct property."
    return self._exposure_ms

  @exposure_ms.setter
  def exposure_ms(self, value):
    self._exposure_ms = msgbuffers.validate_integer(
      'SetCameraSettings.exposure_ms', value, 0, 65535)

  @property
  def gain(self):
    "float_32 gain struct property."
    return self._gain

  @gain.setter
  def gain(self, value):
    self._gain = msgbuffers.validate_float(
      'SetCameraSettings.gain', value, 'f')

  def __init__(self, exposure_ms=0, gain=0.0):
    self.exposure_ms = exposure_ms
    self.gain = gain

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetCameraSettings from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetCameraSettings.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetCameraSettings from the given BinaryReader."
    _exposure_ms = reader.read('H')
    _gain = reader.read('f')
    return cls(_exposure_ms, _gain)

  def pack(self):
    "Writes the current SetCameraSettings, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetCameraSettings to the given BinaryWriter."
    writer.write(self._exposure_ms, 'H')
    writer.write(self._gain, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._exposure_ms == other._exposure_ms and
        self._gain == other._gain)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._exposure_ms, 'H') +
      msgbuffers.size(self._gain, 'f'))

  def __str__(self):
    return '{type}(exposure_ms={exposure_ms}, gain={gain})'.format(
      type=type(self).__name__,
      exposure_ms=self._exposure_ms,
      gain=self._gain)

  def __repr__(self):
    return '{type}(exposure_ms={exposure_ms}, gain={gain})'.format(
      type=type(self).__name__,
      exposure_ms=repr(self._exposure_ms),
      gain=repr(self._gain))

Anki.Cozmo.ExternalInterface.SetCameraSettings = SetCameraSettings
del SetCameraSettings


class MessageGameToEngine(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    UiDeviceConnectionWrongVersion          = 0x0  # Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion
    PostAudioEvent                          = 0x1  # Anki.Cozmo.Audio.PostAudioEvent
    StopAllAudioEvents                      = 0x2  # Anki.Cozmo.Audio.StopAllAudioEvents
    PostAudioGameState                      = 0x3  # Anki.Cozmo.Audio.PostAudioGameState
    PostAudioSwitchState                    = 0x4  # Anki.Cozmo.Audio.PostAudioSwitchState
    PostAudioParameter                      = 0x5  # Anki.Cozmo.Audio.PostAudioParameter
    PostAudioMusicState                     = 0x6  # Anki.Cozmo.Audio.PostAudioMusicState
    AlignWithObject                         = 0x7  # Anki.Cozmo.ExternalInterface.AlignWithObject
    CalibrateMotors                         = 0x8  # Anki.Cozmo.ExternalInterface.CalibrateMotors
    DisplayFaceImage                        = 0x9  # Anki.Cozmo.ExternalInterface.DisplayFaceImage
    DisplayProceduralFace                   = 0xa  # Anki.Cozmo.ExternalInterface.DisplayProceduralFace
    DriveOffChargerContacts                 = 0xb  # Anki.Cozmo.ExternalInterface.DriveOffChargerContacts
    DriveStraight                           = 0xc  # Anki.Cozmo.ExternalInterface.DriveStraight
    EnrollNamedFace                         = 0xd  # Anki.Cozmo.ExternalInterface.EnrollNamedFace
    FlipBlock                               = 0xe  # Anki.Cozmo.ExternalInterface.FlipBlock
    GotoObject                              = 0xf  # Anki.Cozmo.ExternalInterface.GotoObject
    GotoPose                                = 0x10 # Anki.Cozmo.ExternalInterface.GotoPose
    MountCharger                            = 0x11 # Anki.Cozmo.ExternalInterface.MountCharger
    PanAndTilt                              = 0x12 # Anki.Cozmo.ExternalInterface.PanAndTilt
    PickupObject                            = 0x13 # Anki.Cozmo.ExternalInterface.PickupObject
    PlaceObjectOnGround                     = 0x14 # Anki.Cozmo.ExternalInterface.PlaceObjectOnGround
    PlaceObjectOnGroundHere                 = 0x15 # Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere
    PlaceOnObject                           = 0x16 # Anki.Cozmo.ExternalInterface.PlaceOnObject
    PlaceRelObject                          = 0x17 # Anki.Cozmo.ExternalInterface.PlaceRelObject
    PlayAnimation                           = 0x18 # Anki.Cozmo.ExternalInterface.PlayAnimation
    PlayAnimationTrigger                    = 0x19 # Anki.Cozmo.ExternalInterface.PlayAnimationTrigger
    PlayAnimation_DEV                       = 0x1a # Anki.Cozmo.ExternalInterface.PlayAnimation_DEV
    PopAWheelie                             = 0x1b # Anki.Cozmo.ExternalInterface.PopAWheelie
    FacePlant                               = 0x1c # Anki.Cozmo.ExternalInterface.FacePlant
    ReadToolCode                            = 0x1d # Anki.Cozmo.ExternalInterface.ReadToolCode
    RealignWithObject                       = 0x1e # Anki.Cozmo.ExternalInterface.RealignWithObject
    RollObject                              = 0x1f # Anki.Cozmo.ExternalInterface.RollObject
    SayText                                 = 0x20 # Anki.Cozmo.ExternalInterface.SayText
    SayTextWithIntent                       = 0x21 # Anki.Cozmo.ExternalInterface.SayTextWithIntent
    SearchForNearbyObject                   = 0x22 # Anki.Cozmo.ExternalInterface.SearchForNearbyObject
    SetHeadAngle                            = 0x23 # Anki.Cozmo.ExternalInterface.SetHeadAngle
    SetLiftHeight                           = 0x24 # Anki.Cozmo.ExternalInterface.SetLiftHeight
    TrackToFace                             = 0x25 # Anki.Cozmo.ExternalInterface.TrackToFace
    TrackToObject                           = 0x26 # Anki.Cozmo.ExternalInterface.TrackToObject
    TrackToPet                              = 0x27 # Anki.Cozmo.ExternalInterface.TrackToPet
    TraverseObject                          = 0x28 # Anki.Cozmo.ExternalInterface.TraverseObject
    TurnInPlace                             = 0x29 # Anki.Cozmo.ExternalInterface.TurnInPlace
    TurnInPlaceAtSpeed                      = 0x2a # Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed
    TurnTowardsFace                         = 0x2b # Anki.Cozmo.ExternalInterface.TurnTowardsFace
    TurnTowardsImagePoint                   = 0x2c # Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint
    TurnTowardsLastFacePose                 = 0x2d # Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose
    TurnTowardsObject                       = 0x2e # Anki.Cozmo.ExternalInterface.TurnTowardsObject
    TurnTowardsPose                         = 0x2f # Anki.Cozmo.ExternalInterface.TurnTowardsPose
    VisuallyVerifyFace                      = 0x30 # Anki.Cozmo.ExternalInterface.VisuallyVerifyFace
    VisuallyVerifyObject                    = 0x31 # Anki.Cozmo.ExternalInterface.VisuallyVerifyObject
    VisuallyVerifyNoObjectAtPose            = 0x32 # Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose
    Wait                                    = 0x33 # Anki.Cozmo.ExternalInterface.Wait
    WaitForImages                           = 0x34 # Anki.Cozmo.ExternalInterface.WaitForImages
    AdvertisementRegistrationMsg            = 0x35 # Anki.Cozmo.AdvertisementRegistrationMsg
    AdvertisementMsg                        = 0x36 # Anki.Cozmo.AdvertisementMsg
    Ping                                    = 0x37 # Anki.Cozmo.ExternalInterface.Ping
    DenyGameStart                           = 0x38 # Anki.Cozmo.ExternalInterface.DenyGameStart
    SetVizOrigin                            = 0x39 # Anki.Cozmo.SetVizOrigin
    ImageChunk                              = 0x3a # Anki.Cozmo.ImageChunk
    ImageImuData                            = 0x3b # Anki.Cozmo.ImageImuData
    CameraCalibration                       = 0x3c # Anki.Cozmo.CameraCalibration
    IMURequest                              = 0x3d # Anki.Cozmo.IMURequest
    StartControllerTestMode                 = 0x3e # Anki.Cozmo.StartControllerTestMode
    RawPWM                                  = 0x3f # Anki.Cozmo.RawPWM
    UiDeviceConnectionSuccess               = 0x40 # Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess
    ConnectToRobot                          = 0x41 # Anki.Cozmo.ExternalInterface.ConnectToRobot
    ConnectToUiDevice                       = 0x42 # Anki.Cozmo.ExternalInterface.ConnectToUiDevice
    DisconnectFromUiDevice                  = 0x43 # Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice
    StartEngine                             = 0x44 # Anki.Cozmo.ExternalInterface.StartEngine
    ReliableTransportRunMode                = 0x45 # Anki.Cozmo.ExternalInterface.ReliableTransportRunMode
    RequestFeatureToggles                   = 0x46 # Anki.Cozmo.ExternalInterface.RequestFeatureToggles
    SetFeatureToggle                        = 0x47 # Anki.Cozmo.ExternalInterface.SetFeatureToggle
    StartIdleTimeout                        = 0x48 # Anki.Cozmo.ExternalInterface.StartIdleTimeout
    CancelIdleTimeout                       = 0x49 # Anki.Cozmo.ExternalInterface.CancelIdleTimeout
    SetGameBeingPaused                      = 0x4a # Anki.Cozmo.ExternalInterface.SetGameBeingPaused
    UpdateFirmware                          = 0x4b # Anki.Cozmo.ExternalInterface.UpdateFirmware
    ResetFirmware                           = 0x4c # Anki.Cozmo.ExternalInterface.ResetFirmware
    DriveWheels                             = 0x4d # Anki.Cozmo.ExternalInterface.DriveWheels
    DriveArc                                = 0x4e # Anki.Cozmo.ExternalInterface.DriveArc
    MoveHead                                = 0x4f # Anki.Cozmo.ExternalInterface.MoveHead
    MoveLift                                = 0x50 # Anki.Cozmo.ExternalInterface.MoveLift
    EnableLiftPower                         = 0x51 # Anki.Cozmo.ExternalInterface.EnableLiftPower
    EnableCliffSensor                       = 0x52 # Anki.Cozmo.ExternalInterface.EnableCliffSensor
    EnableBlockTapFilter                    = 0x53 # Anki.Cozmo.ExternalInterface.EnableBlockTapFilter
    GetBlockTapFilterStatus                 = 0x54 # Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus
    StopAllMotors                           = 0x55 # Anki.Cozmo.ExternalInterface.StopAllMotors
    ControllerGains                         = 0x56 # Anki.Cozmo.ExternalInterface.ControllerGains
    RollActionParams                        = 0x57 # Anki.Cozmo.ExternalInterface.RollActionParams
    SetMotionModelParams                    = 0x58 # Anki.Cozmo.ExternalInterface.SetMotionModelParams
    SetRobotVolume                          = 0x59 # Anki.Cozmo.ExternalInterface.SetRobotVolume
    SetRobotAudioOutputSource               = 0x5a # Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource
    ForceDelocalizeRobot                    = 0x5b # Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot
    RestoreRobotFromBackup                  = 0x5c # Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup
    RequestRobotRestoreData                 = 0x5d # Anki.Cozmo.ExternalInterface.RequestRobotRestoreData
    WipeRobotGameData                       = 0x5e # Anki.Cozmo.ExternalInterface.WipeRobotGameData
    RequestUnlockDataFromBackup             = 0x5f # Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup
    CancelAction                            = 0x60 # Anki.Cozmo.ExternalInterface.CancelAction
    CancelActionByIdTag                     = 0x61 # Anki.Cozmo.ExternalInterface.CancelActionByIdTag
    QueueSingleAction                       = 0x62 # Anki.Cozmo.ExternalInterface.QueueSingleAction
    QueueCompoundAction                     = 0x63 # Anki.Cozmo.ExternalInterface.QueueCompoundAction
    ImageRequest                            = 0x64 # Anki.Cozmo.ExternalInterface.ImageRequest
    SetRobotImageSendMode                   = 0x65 # Anki.Cozmo.ExternalInterface.SetRobotImageSendMode
    SaveImages                              = 0x66 # Anki.Cozmo.ExternalInterface.SaveImages
    SaveRobotState                          = 0x67 # Anki.Cozmo.ExternalInterface.SaveRobotState
    EnableDisplay                           = 0x68 # Anki.Cozmo.ExternalInterface.EnableDisplay
    ExecuteTestPlan                         = 0x69 # Anki.Cozmo.ExternalInterface.ExecuteTestPlan
    PlannerRunMode                          = 0x6a # Anki.Cozmo.ExternalInterface.PlannerRunMode
    SelectNextObject                        = 0x6b # Anki.Cozmo.ExternalInterface.SelectNextObject
    SetRobotCarryingObject                  = 0x6c # Anki.Cozmo.ExternalInterface.SetRobotCarryingObject
    CreateFixedCustomObject                 = 0x6d # Anki.Cozmo.ExternalInterface.CreateFixedCustomObject
    DefineCustomObject                      = 0x6e # Anki.Cozmo.ExternalInterface.DefineCustomObject
    ClearAllBlocks                          = 0x6f # Anki.Cozmo.ExternalInterface.ClearAllBlocks
    ClearAllObjects                         = 0x70 # Anki.Cozmo.ExternalInterface.ClearAllObjects
    DeleteAllObjects                        = 0x71 # Anki.Cozmo.ExternalInterface.DeleteAllObjects
    DeleteAllCustomObjects                  = 0x72 # Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects
    SetObjectAdditionAndDeletion            = 0x73 # Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion
    VisionWhileMoving                       = 0x74 # Anki.Cozmo.ExternalInterface.VisionWhileMoving
    SetFaceEnrollmentPose                   = 0x75 # Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose
    EraseEnrolledFaceByID                   = 0x76 # Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID
    EraseAllEnrolledFaces                   = 0x77 # Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces
    EnableVisionMode                        = 0x78 # Anki.Cozmo.ExternalInterface.EnableVisionMode
    UpdateEnrolledFaceByID                  = 0x79 # Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID
    VisionRunMode                           = 0x7a # Anki.Cozmo.ExternalInterface.VisionRunMode
    SaveFaceAlbumToFile                     = 0x7b # Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile
    LoadFaceAlbumFromFile                   = 0x7c # Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile
    SetMemoryMapRenderEnabled               = 0x7d # Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled
    ActivateBehaviorChooser                 = 0x7e # Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser
    ExecuteBehavior                         = 0x7f # Anki.Cozmo.ExternalInterface.ExecuteBehavior
    ExecuteBehaviorByExecutableType         = 0x80 # Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType
    ExecuteBehaviorByName                   = 0x81 # Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName
    BehaviorManagerMessage                  = 0x82 # Anki.Cozmo.ExternalInterface.BehaviorManagerMessage
    AbortPath                               = 0x83 # Anki.Cozmo.ExternalInterface.AbortPath
    AbortAll                                = 0x84 # Anki.Cozmo.ExternalInterface.AbortAll
    StartTestMode                           = 0x85 # Anki.Cozmo.ExternalInterface.StartTestMode
    RequestEnabledBehaviorList              = 0x86 # Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList
    RequestEnableReactionaryBehavior        = 0x87 # Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior
    SetDefaultHeadAndLiftState              = 0x88 # Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState
    RequestAvailableObjects                 = 0x89 # Anki.Cozmo.ExternalInterface.RequestAvailableObjects
    DrawPoseMarker                          = 0x8a # Anki.Cozmo.ExternalInterface.DrawPoseMarker
    ErasePoseMarker                         = 0x8b # Anki.Cozmo.ExternalInterface.ErasePoseMarker
    VisualizeQuad                           = 0x8c # Anki.Cozmo.ExternalInterface.VisualizeQuad
    EraseQuad                               = 0x8d # Anki.Cozmo.ExternalInterface.EraseQuad
    ReplayLastAnimation                     = 0x8e # Anki.Cozmo.ExternalInterface.ReplayLastAnimation
    SetIdleAnimation                        = 0x8f # Anki.Cozmo.ExternalInterface.SetIdleAnimation
    PushIdleAnimation                       = 0x90 # Anki.Cozmo.ExternalInterface.PushIdleAnimation
    PopIdleAnimation                        = 0x91 # Anki.Cozmo.ExternalInterface.PopIdleAnimation
    ReadFaceAnimationDir                    = 0x92 # Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir
    ReadAnimationFile                       = 0x93 # Anki.Cozmo.ExternalInterface.ReadAnimationFile
    RequestAvailableAnimations              = 0x94 # Anki.Cozmo.ExternalInterface.RequestAvailableAnimations
    RequestAvailableAnimationGroups         = 0x95 # Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups
    SetLiveIdleAnimationParameters          = 0x96 # Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters
    PushDrivingAnimations                   = 0x97 # Anki.Cozmo.ExternalInterface.PushDrivingAnimations
    PopDrivingAnimations                    = 0x98 # Anki.Cozmo.ExternalInterface.PopDrivingAnimations
    SetHeadlight                            = 0x99 # Anki.Cozmo.ExternalInterface.SetHeadlight
    SetActiveObjectLEDs                     = 0x9a # Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs
    SetAllActiveObjectLEDs                  = 0x9b # Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs
    SetBackpackLEDs                         = 0x9c # Anki.Cozmo.ExternalInterface.SetBackpackLEDs
    EnableLightStates                       = 0x9d # Anki.Cozmo.ExternalInterface.EnableLightStates
    EnableCubeSleep                         = 0x9e # Anki.Cozmo.ExternalInterface.EnableCubeSleep
    EnableCubeLightsStateTransitionMessages = 0x9f # Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages
    FlashCurrentLightsState                 = 0xa0 # Anki.Cozmo.ExternalInterface.FlashCurrentLightsState
    TransitionToNextOnboardingState         = 0xa1 # Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState
    MoodMessage                             = 0xa2 # Anki.Cozmo.ExternalInterface.MoodMessage
    ProgressionMessage                      = 0xa3 # Anki.Cozmo.ExternalInterface.ProgressionMessage
    RequestSetUnlock                        = 0xa4 # Anki.Cozmo.ExternalInterface.RequestSetUnlock
    RequestDeviceData                       = 0xa5 # Anki.Cozmo.ExternalInterface.RequestDeviceData
    SetDebugConsoleVarMessage               = 0xa6 # Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage
    RunDebugConsoleFuncMessage              = 0xa7 # Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage
    GetDebugConsoleVarMessage               = 0xa8 # Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage
    GetAllDebugConsoleVarMessage            = 0xa9 # Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage
    GetJsonDasLogsMessage                   = 0xaa # Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage
    SetEnableSOSLogging                     = 0xab # Anki.Cozmo.ExternalInterface.SetEnableSOSLogging
    EnableReactionaryBehaviors              = 0xac # Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors
    SetEnableSpeedChooser                   = 0xad # Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser
    BlockPoolEnabledMessage                 = 0xae # Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage
    BlockSelectedMessage                    = 0xaf # Anki.Cozmo.ExternalInterface.BlockSelectedMessage
    GetBlockPoolMessage                     = 0xb0 # Anki.Cozmo.ExternalInterface.GetBlockPoolMessage
    SendAvailableObjects                    = 0xb1 # Anki.Cozmo.ExternalInterface.SendAvailableObjects
    BlockPoolResetMessage                   = 0xb2 # Anki.Cozmo.ExternalInterface.BlockPoolResetMessage
    SaveCalibrationImage                    = 0xb3 # Anki.Cozmo.ExternalInterface.SaveCalibrationImage
    ClearCalibrationImages                  = 0xb4 # Anki.Cozmo.ExternalInterface.ClearCalibrationImages
    ComputeCameraCalibration                = 0xb5 # Anki.Cozmo.ExternalInterface.ComputeCameraCalibration
    ContinueFreeplayFromIdle                = 0xb6 # Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle
    EnableDroneMode                         = 0xb7 # Anki.Cozmo.ExternalInterface.EnableDroneMode
    EnterSdkMode                            = 0xb8 # Anki.Cozmo.ExternalInterface.EnterSdkMode
    ExitSdkMode                             = 0xb9 # Anki.Cozmo.ExternalInterface.ExitSdkMode
    SetStopRobotOnSdkDisconnect             = 0xba # Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect
    StopRobotForSdk                         = 0xbb # Anki.Cozmo.ExternalInterface.StopRobotForSdk
    TransferFile                            = 0xbc # Anki.Cozmo.ExternalInterface.TransferFile
    NVStorageEraseEntry                     = 0xbd # Anki.Cozmo.ExternalInterface.NVStorageEraseEntry
    NVStorageWipeAll                        = 0xbe # Anki.Cozmo.ExternalInterface.NVStorageWipeAll
    NVStorageWriteEntry                     = 0xbf # Anki.Cozmo.ExternalInterface.NVStorageWriteEntry
    NVStorageClearPartialPendingWriteEntry  = 0xc0 # Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry
    NVStorageReadEntry                      = 0xc1 # Anki.Cozmo.ExternalInterface.NVStorageReadEntry
    SetCameraSettings                       = 0xc2 # Anki.Cozmo.ExternalInterface.SetCameraSettings

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def UiDeviceConnectionWrongVersion(self):
    "Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion UiDeviceConnectionWrongVersion union property."
    msgbuffers.safety_check_tag('UiDeviceConnectionWrongVersion', self._tag, self.Tag.UiDeviceConnectionWrongVersion, self._tags_by_value)
    return self._data

  @UiDeviceConnectionWrongVersion.setter
  def UiDeviceConnectionWrongVersion(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.UiDeviceConnectionWrongVersion', value, Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion)
    self._tag = self.Tag.UiDeviceConnectionWrongVersion

  @property
  def PostAudioEvent(self):
    "Anki.Cozmo.Audio.PostAudioEvent PostAudioEvent union property."
    msgbuffers.safety_check_tag('PostAudioEvent', self._tag, self.Tag.PostAudioEvent, self._tags_by_value)
    return self._data

  @PostAudioEvent.setter
  def PostAudioEvent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PostAudioEvent', value, Anki.Cozmo.Audio.PostAudioEvent)
    self._tag = self.Tag.PostAudioEvent

  @property
  def StopAllAudioEvents(self):
    "Anki.Cozmo.Audio.StopAllAudioEvents StopAllAudioEvents union property."
    msgbuffers.safety_check_tag('StopAllAudioEvents', self._tag, self.Tag.StopAllAudioEvents, self._tags_by_value)
    return self._data

  @StopAllAudioEvents.setter
  def StopAllAudioEvents(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StopAllAudioEvents', value, Anki.Cozmo.Audio.StopAllAudioEvents)
    self._tag = self.Tag.StopAllAudioEvents

  @property
  def PostAudioGameState(self):
    "Anki.Cozmo.Audio.PostAudioGameState PostAudioGameState union property."
    msgbuffers.safety_check_tag('PostAudioGameState', self._tag, self.Tag.PostAudioGameState, self._tags_by_value)
    return self._data

  @PostAudioGameState.setter
  def PostAudioGameState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PostAudioGameState', value, Anki.Cozmo.Audio.PostAudioGameState)
    self._tag = self.Tag.PostAudioGameState

  @property
  def PostAudioSwitchState(self):
    "Anki.Cozmo.Audio.PostAudioSwitchState PostAudioSwitchState union property."
    msgbuffers.safety_check_tag('PostAudioSwitchState', self._tag, self.Tag.PostAudioSwitchState, self._tags_by_value)
    return self._data

  @PostAudioSwitchState.setter
  def PostAudioSwitchState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PostAudioSwitchState', value, Anki.Cozmo.Audio.PostAudioSwitchState)
    self._tag = self.Tag.PostAudioSwitchState

  @property
  def PostAudioParameter(self):
    "Anki.Cozmo.Audio.PostAudioParameter PostAudioParameter union property."
    msgbuffers.safety_check_tag('PostAudioParameter', self._tag, self.Tag.PostAudioParameter, self._tags_by_value)
    return self._data

  @PostAudioParameter.setter
  def PostAudioParameter(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PostAudioParameter', value, Anki.Cozmo.Audio.PostAudioParameter)
    self._tag = self.Tag.PostAudioParameter

  @property
  def PostAudioMusicState(self):
    "Anki.Cozmo.Audio.PostAudioMusicState PostAudioMusicState union property."
    msgbuffers.safety_check_tag('PostAudioMusicState', self._tag, self.Tag.PostAudioMusicState, self._tags_by_value)
    return self._data

  @PostAudioMusicState.setter
  def PostAudioMusicState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PostAudioMusicState', value, Anki.Cozmo.Audio.PostAudioMusicState)
    self._tag = self.Tag.PostAudioMusicState

  @property
  def AlignWithObject(self):
    "Anki.Cozmo.ExternalInterface.AlignWithObject AlignWithObject union property."
    msgbuffers.safety_check_tag('AlignWithObject', self._tag, self.Tag.AlignWithObject, self._tags_by_value)
    return self._data

  @AlignWithObject.setter
  def AlignWithObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.AlignWithObject', value, Anki.Cozmo.ExternalInterface.AlignWithObject)
    self._tag = self.Tag.AlignWithObject

  @property
  def CalibrateMotors(self):
    "Anki.Cozmo.ExternalInterface.CalibrateMotors CalibrateMotors union property."
    msgbuffers.safety_check_tag('CalibrateMotors', self._tag, self.Tag.CalibrateMotors, self._tags_by_value)
    return self._data

  @CalibrateMotors.setter
  def CalibrateMotors(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CalibrateMotors', value, Anki.Cozmo.ExternalInterface.CalibrateMotors)
    self._tag = self.Tag.CalibrateMotors

  @property
  def DisplayFaceImage(self):
    "Anki.Cozmo.ExternalInterface.DisplayFaceImage DisplayFaceImage union property."
    msgbuffers.safety_check_tag('DisplayFaceImage', self._tag, self.Tag.DisplayFaceImage, self._tags_by_value)
    return self._data

  @DisplayFaceImage.setter
  def DisplayFaceImage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DisplayFaceImage', value, Anki.Cozmo.ExternalInterface.DisplayFaceImage)
    self._tag = self.Tag.DisplayFaceImage

  @property
  def DisplayProceduralFace(self):
    "Anki.Cozmo.ExternalInterface.DisplayProceduralFace DisplayProceduralFace union property."
    msgbuffers.safety_check_tag('DisplayProceduralFace', self._tag, self.Tag.DisplayProceduralFace, self._tags_by_value)
    return self._data

  @DisplayProceduralFace.setter
  def DisplayProceduralFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DisplayProceduralFace', value, Anki.Cozmo.ExternalInterface.DisplayProceduralFace)
    self._tag = self.Tag.DisplayProceduralFace

  @property
  def DriveOffChargerContacts(self):
    "Anki.Cozmo.ExternalInterface.DriveOffChargerContacts DriveOffChargerContacts union property."
    msgbuffers.safety_check_tag('DriveOffChargerContacts', self._tag, self.Tag.DriveOffChargerContacts, self._tags_by_value)
    return self._data

  @DriveOffChargerContacts.setter
  def DriveOffChargerContacts(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DriveOffChargerContacts', value, Anki.Cozmo.ExternalInterface.DriveOffChargerContacts)
    self._tag = self.Tag.DriveOffChargerContacts

  @property
  def DriveStraight(self):
    "Anki.Cozmo.ExternalInterface.DriveStraight DriveStraight union property."
    msgbuffers.safety_check_tag('DriveStraight', self._tag, self.Tag.DriveStraight, self._tags_by_value)
    return self._data

  @DriveStraight.setter
  def DriveStraight(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DriveStraight', value, Anki.Cozmo.ExternalInterface.DriveStraight)
    self._tag = self.Tag.DriveStraight

  @property
  def EnrollNamedFace(self):
    "Anki.Cozmo.ExternalInterface.EnrollNamedFace EnrollNamedFace union property."
    msgbuffers.safety_check_tag('EnrollNamedFace', self._tag, self.Tag.EnrollNamedFace, self._tags_by_value)
    return self._data

  @EnrollNamedFace.setter
  def EnrollNamedFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnrollNamedFace', value, Anki.Cozmo.ExternalInterface.EnrollNamedFace)
    self._tag = self.Tag.EnrollNamedFace

  @property
  def FlipBlock(self):
    "Anki.Cozmo.ExternalInterface.FlipBlock FlipBlock union property."
    msgbuffers.safety_check_tag('FlipBlock', self._tag, self.Tag.FlipBlock, self._tags_by_value)
    return self._data

  @FlipBlock.setter
  def FlipBlock(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.FlipBlock', value, Anki.Cozmo.ExternalInterface.FlipBlock)
    self._tag = self.Tag.FlipBlock

  @property
  def GotoObject(self):
    "Anki.Cozmo.ExternalInterface.GotoObject GotoObject union property."
    msgbuffers.safety_check_tag('GotoObject', self._tag, self.Tag.GotoObject, self._tags_by_value)
    return self._data

  @GotoObject.setter
  def GotoObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GotoObject', value, Anki.Cozmo.ExternalInterface.GotoObject)
    self._tag = self.Tag.GotoObject

  @property
  def GotoPose(self):
    "Anki.Cozmo.ExternalInterface.GotoPose GotoPose union property."
    msgbuffers.safety_check_tag('GotoPose', self._tag, self.Tag.GotoPose, self._tags_by_value)
    return self._data

  @GotoPose.setter
  def GotoPose(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GotoPose', value, Anki.Cozmo.ExternalInterface.GotoPose)
    self._tag = self.Tag.GotoPose

  @property
  def MountCharger(self):
    "Anki.Cozmo.ExternalInterface.MountCharger MountCharger union property."
    msgbuffers.safety_check_tag('MountCharger', self._tag, self.Tag.MountCharger, self._tags_by_value)
    return self._data

  @MountCharger.setter
  def MountCharger(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.MountCharger', value, Anki.Cozmo.ExternalInterface.MountCharger)
    self._tag = self.Tag.MountCharger

  @property
  def PanAndTilt(self):
    "Anki.Cozmo.ExternalInterface.PanAndTilt PanAndTilt union property."
    msgbuffers.safety_check_tag('PanAndTilt', self._tag, self.Tag.PanAndTilt, self._tags_by_value)
    return self._data

  @PanAndTilt.setter
  def PanAndTilt(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PanAndTilt', value, Anki.Cozmo.ExternalInterface.PanAndTilt)
    self._tag = self.Tag.PanAndTilt

  @property
  def PickupObject(self):
    "Anki.Cozmo.ExternalInterface.PickupObject PickupObject union property."
    msgbuffers.safety_check_tag('PickupObject', self._tag, self.Tag.PickupObject, self._tags_by_value)
    return self._data

  @PickupObject.setter
  def PickupObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PickupObject', value, Anki.Cozmo.ExternalInterface.PickupObject)
    self._tag = self.Tag.PickupObject

  @property
  def PlaceObjectOnGround(self):
    "Anki.Cozmo.ExternalInterface.PlaceObjectOnGround PlaceObjectOnGround union property."
    msgbuffers.safety_check_tag('PlaceObjectOnGround', self._tag, self.Tag.PlaceObjectOnGround, self._tags_by_value)
    return self._data

  @PlaceObjectOnGround.setter
  def PlaceObjectOnGround(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlaceObjectOnGround', value, Anki.Cozmo.ExternalInterface.PlaceObjectOnGround)
    self._tag = self.Tag.PlaceObjectOnGround

  @property
  def PlaceObjectOnGroundHere(self):
    "Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere PlaceObjectOnGroundHere union property."
    msgbuffers.safety_check_tag('PlaceObjectOnGroundHere', self._tag, self.Tag.PlaceObjectOnGroundHere, self._tags_by_value)
    return self._data

  @PlaceObjectOnGroundHere.setter
  def PlaceObjectOnGroundHere(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlaceObjectOnGroundHere', value, Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere)
    self._tag = self.Tag.PlaceObjectOnGroundHere

  @property
  def PlaceOnObject(self):
    "Anki.Cozmo.ExternalInterface.PlaceOnObject PlaceOnObject union property."
    msgbuffers.safety_check_tag('PlaceOnObject', self._tag, self.Tag.PlaceOnObject, self._tags_by_value)
    return self._data

  @PlaceOnObject.setter
  def PlaceOnObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlaceOnObject', value, Anki.Cozmo.ExternalInterface.PlaceOnObject)
    self._tag = self.Tag.PlaceOnObject

  @property
  def PlaceRelObject(self):
    "Anki.Cozmo.ExternalInterface.PlaceRelObject PlaceRelObject union property."
    msgbuffers.safety_check_tag('PlaceRelObject', self._tag, self.Tag.PlaceRelObject, self._tags_by_value)
    return self._data

  @PlaceRelObject.setter
  def PlaceRelObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlaceRelObject', value, Anki.Cozmo.ExternalInterface.PlaceRelObject)
    self._tag = self.Tag.PlaceRelObject

  @property
  def PlayAnimation(self):
    "Anki.Cozmo.ExternalInterface.PlayAnimation PlayAnimation union property."
    msgbuffers.safety_check_tag('PlayAnimation', self._tag, self.Tag.PlayAnimation, self._tags_by_value)
    return self._data

  @PlayAnimation.setter
  def PlayAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlayAnimation', value, Anki.Cozmo.ExternalInterface.PlayAnimation)
    self._tag = self.Tag.PlayAnimation

  @property
  def PlayAnimationTrigger(self):
    "Anki.Cozmo.ExternalInterface.PlayAnimationTrigger PlayAnimationTrigger union property."
    msgbuffers.safety_check_tag('PlayAnimationTrigger', self._tag, self.Tag.PlayAnimationTrigger, self._tags_by_value)
    return self._data

  @PlayAnimationTrigger.setter
  def PlayAnimationTrigger(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlayAnimationTrigger', value, Anki.Cozmo.ExternalInterface.PlayAnimationTrigger)
    self._tag = self.Tag.PlayAnimationTrigger

  @property
  def PlayAnimation_DEV(self):
    "Anki.Cozmo.ExternalInterface.PlayAnimation_DEV PlayAnimation_DEV union property."
    msgbuffers.safety_check_tag('PlayAnimation_DEV', self._tag, self.Tag.PlayAnimation_DEV, self._tags_by_value)
    return self._data

  @PlayAnimation_DEV.setter
  def PlayAnimation_DEV(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlayAnimation_DEV', value, Anki.Cozmo.ExternalInterface.PlayAnimation_DEV)
    self._tag = self.Tag.PlayAnimation_DEV

  @property
  def PopAWheelie(self):
    "Anki.Cozmo.ExternalInterface.PopAWheelie PopAWheelie union property."
    msgbuffers.safety_check_tag('PopAWheelie', self._tag, self.Tag.PopAWheelie, self._tags_by_value)
    return self._data

  @PopAWheelie.setter
  def PopAWheelie(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PopAWheelie', value, Anki.Cozmo.ExternalInterface.PopAWheelie)
    self._tag = self.Tag.PopAWheelie

  @property
  def FacePlant(self):
    "Anki.Cozmo.ExternalInterface.FacePlant FacePlant union property."
    msgbuffers.safety_check_tag('FacePlant', self._tag, self.Tag.FacePlant, self._tags_by_value)
    return self._data

  @FacePlant.setter
  def FacePlant(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.FacePlant', value, Anki.Cozmo.ExternalInterface.FacePlant)
    self._tag = self.Tag.FacePlant

  @property
  def ReadToolCode(self):
    "Anki.Cozmo.ExternalInterface.ReadToolCode ReadToolCode union property."
    msgbuffers.safety_check_tag('ReadToolCode', self._tag, self.Tag.ReadToolCode, self._tags_by_value)
    return self._data

  @ReadToolCode.setter
  def ReadToolCode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ReadToolCode', value, Anki.Cozmo.ExternalInterface.ReadToolCode)
    self._tag = self.Tag.ReadToolCode

  @property
  def RealignWithObject(self):
    "Anki.Cozmo.ExternalInterface.RealignWithObject RealignWithObject union property."
    msgbuffers.safety_check_tag('RealignWithObject', self._tag, self.Tag.RealignWithObject, self._tags_by_value)
    return self._data

  @RealignWithObject.setter
  def RealignWithObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RealignWithObject', value, Anki.Cozmo.ExternalInterface.RealignWithObject)
    self._tag = self.Tag.RealignWithObject

  @property
  def RollObject(self):
    "Anki.Cozmo.ExternalInterface.RollObject RollObject union property."
    msgbuffers.safety_check_tag('RollObject', self._tag, self.Tag.RollObject, self._tags_by_value)
    return self._data

  @RollObject.setter
  def RollObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RollObject', value, Anki.Cozmo.ExternalInterface.RollObject)
    self._tag = self.Tag.RollObject

  @property
  def SayText(self):
    "Anki.Cozmo.ExternalInterface.SayText SayText union property."
    msgbuffers.safety_check_tag('SayText', self._tag, self.Tag.SayText, self._tags_by_value)
    return self._data

  @SayText.setter
  def SayText(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SayText', value, Anki.Cozmo.ExternalInterface.SayText)
    self._tag = self.Tag.SayText

  @property
  def SayTextWithIntent(self):
    "Anki.Cozmo.ExternalInterface.SayTextWithIntent SayTextWithIntent union property."
    msgbuffers.safety_check_tag('SayTextWithIntent', self._tag, self.Tag.SayTextWithIntent, self._tags_by_value)
    return self._data

  @SayTextWithIntent.setter
  def SayTextWithIntent(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SayTextWithIntent', value, Anki.Cozmo.ExternalInterface.SayTextWithIntent)
    self._tag = self.Tag.SayTextWithIntent

  @property
  def SearchForNearbyObject(self):
    "Anki.Cozmo.ExternalInterface.SearchForNearbyObject SearchForNearbyObject union property."
    msgbuffers.safety_check_tag('SearchForNearbyObject', self._tag, self.Tag.SearchForNearbyObject, self._tags_by_value)
    return self._data

  @SearchForNearbyObject.setter
  def SearchForNearbyObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SearchForNearbyObject', value, Anki.Cozmo.ExternalInterface.SearchForNearbyObject)
    self._tag = self.Tag.SearchForNearbyObject

  @property
  def SetHeadAngle(self):
    "Anki.Cozmo.ExternalInterface.SetHeadAngle SetHeadAngle union property."
    msgbuffers.safety_check_tag('SetHeadAngle', self._tag, self.Tag.SetHeadAngle, self._tags_by_value)
    return self._data

  @SetHeadAngle.setter
  def SetHeadAngle(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetHeadAngle', value, Anki.Cozmo.ExternalInterface.SetHeadAngle)
    self._tag = self.Tag.SetHeadAngle

  @property
  def SetLiftHeight(self):
    "Anki.Cozmo.ExternalInterface.SetLiftHeight SetLiftHeight union property."
    msgbuffers.safety_check_tag('SetLiftHeight', self._tag, self.Tag.SetLiftHeight, self._tags_by_value)
    return self._data

  @SetLiftHeight.setter
  def SetLiftHeight(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetLiftHeight', value, Anki.Cozmo.ExternalInterface.SetLiftHeight)
    self._tag = self.Tag.SetLiftHeight

  @property
  def TrackToFace(self):
    "Anki.Cozmo.ExternalInterface.TrackToFace TrackToFace union property."
    msgbuffers.safety_check_tag('TrackToFace', self._tag, self.Tag.TrackToFace, self._tags_by_value)
    return self._data

  @TrackToFace.setter
  def TrackToFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TrackToFace', value, Anki.Cozmo.ExternalInterface.TrackToFace)
    self._tag = self.Tag.TrackToFace

  @property
  def TrackToObject(self):
    "Anki.Cozmo.ExternalInterface.TrackToObject TrackToObject union property."
    msgbuffers.safety_check_tag('TrackToObject', self._tag, self.Tag.TrackToObject, self._tags_by_value)
    return self._data

  @TrackToObject.setter
  def TrackToObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TrackToObject', value, Anki.Cozmo.ExternalInterface.TrackToObject)
    self._tag = self.Tag.TrackToObject

  @property
  def TrackToPet(self):
    "Anki.Cozmo.ExternalInterface.TrackToPet TrackToPet union property."
    msgbuffers.safety_check_tag('TrackToPet', self._tag, self.Tag.TrackToPet, self._tags_by_value)
    return self._data

  @TrackToPet.setter
  def TrackToPet(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TrackToPet', value, Anki.Cozmo.ExternalInterface.TrackToPet)
    self._tag = self.Tag.TrackToPet

  @property
  def TraverseObject(self):
    "Anki.Cozmo.ExternalInterface.TraverseObject TraverseObject union property."
    msgbuffers.safety_check_tag('TraverseObject', self._tag, self.Tag.TraverseObject, self._tags_by_value)
    return self._data

  @TraverseObject.setter
  def TraverseObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TraverseObject', value, Anki.Cozmo.ExternalInterface.TraverseObject)
    self._tag = self.Tag.TraverseObject

  @property
  def TurnInPlace(self):
    "Anki.Cozmo.ExternalInterface.TurnInPlace TurnInPlace union property."
    msgbuffers.safety_check_tag('TurnInPlace', self._tag, self.Tag.TurnInPlace, self._tags_by_value)
    return self._data

  @TurnInPlace.setter
  def TurnInPlace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnInPlace', value, Anki.Cozmo.ExternalInterface.TurnInPlace)
    self._tag = self.Tag.TurnInPlace

  @property
  def TurnInPlaceAtSpeed(self):
    "Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed TurnInPlaceAtSpeed union property."
    msgbuffers.safety_check_tag('TurnInPlaceAtSpeed', self._tag, self.Tag.TurnInPlaceAtSpeed, self._tags_by_value)
    return self._data

  @TurnInPlaceAtSpeed.setter
  def TurnInPlaceAtSpeed(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnInPlaceAtSpeed', value, Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed)
    self._tag = self.Tag.TurnInPlaceAtSpeed

  @property
  def TurnTowardsFace(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsFace TurnTowardsFace union property."
    msgbuffers.safety_check_tag('TurnTowardsFace', self._tag, self.Tag.TurnTowardsFace, self._tags_by_value)
    return self._data

  @TurnTowardsFace.setter
  def TurnTowardsFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnTowardsFace', value, Anki.Cozmo.ExternalInterface.TurnTowardsFace)
    self._tag = self.Tag.TurnTowardsFace

  @property
  def TurnTowardsImagePoint(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint TurnTowardsImagePoint union property."
    msgbuffers.safety_check_tag('TurnTowardsImagePoint', self._tag, self.Tag.TurnTowardsImagePoint, self._tags_by_value)
    return self._data

  @TurnTowardsImagePoint.setter
  def TurnTowardsImagePoint(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnTowardsImagePoint', value, Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint)
    self._tag = self.Tag.TurnTowardsImagePoint

  @property
  def TurnTowardsLastFacePose(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose TurnTowardsLastFacePose union property."
    msgbuffers.safety_check_tag('TurnTowardsLastFacePose', self._tag, self.Tag.TurnTowardsLastFacePose, self._tags_by_value)
    return self._data

  @TurnTowardsLastFacePose.setter
  def TurnTowardsLastFacePose(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnTowardsLastFacePose', value, Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose)
    self._tag = self.Tag.TurnTowardsLastFacePose

  @property
  def TurnTowardsObject(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsObject TurnTowardsObject union property."
    msgbuffers.safety_check_tag('TurnTowardsObject', self._tag, self.Tag.TurnTowardsObject, self._tags_by_value)
    return self._data

  @TurnTowardsObject.setter
  def TurnTowardsObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnTowardsObject', value, Anki.Cozmo.ExternalInterface.TurnTowardsObject)
    self._tag = self.Tag.TurnTowardsObject

  @property
  def TurnTowardsPose(self):
    "Anki.Cozmo.ExternalInterface.TurnTowardsPose TurnTowardsPose union property."
    msgbuffers.safety_check_tag('TurnTowardsPose', self._tag, self.Tag.TurnTowardsPose, self._tags_by_value)
    return self._data

  @TurnTowardsPose.setter
  def TurnTowardsPose(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TurnTowardsPose', value, Anki.Cozmo.ExternalInterface.TurnTowardsPose)
    self._tag = self.Tag.TurnTowardsPose

  @property
  def VisuallyVerifyFace(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyFace VisuallyVerifyFace union property."
    msgbuffers.safety_check_tag('VisuallyVerifyFace', self._tag, self.Tag.VisuallyVerifyFace, self._tags_by_value)
    return self._data

  @VisuallyVerifyFace.setter
  def VisuallyVerifyFace(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisuallyVerifyFace', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyFace)
    self._tag = self.Tag.VisuallyVerifyFace

  @property
  def VisuallyVerifyObject(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyObject VisuallyVerifyObject union property."
    msgbuffers.safety_check_tag('VisuallyVerifyObject', self._tag, self.Tag.VisuallyVerifyObject, self._tags_by_value)
    return self._data

  @VisuallyVerifyObject.setter
  def VisuallyVerifyObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisuallyVerifyObject', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyObject)
    self._tag = self.Tag.VisuallyVerifyObject

  @property
  def VisuallyVerifyNoObjectAtPose(self):
    "Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose VisuallyVerifyNoObjectAtPose union property."
    msgbuffers.safety_check_tag('VisuallyVerifyNoObjectAtPose', self._tag, self.Tag.VisuallyVerifyNoObjectAtPose, self._tags_by_value)
    return self._data

  @VisuallyVerifyNoObjectAtPose.setter
  def VisuallyVerifyNoObjectAtPose(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisuallyVerifyNoObjectAtPose', value, Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose)
    self._tag = self.Tag.VisuallyVerifyNoObjectAtPose

  @property
  def Wait(self):
    "Anki.Cozmo.ExternalInterface.Wait Wait union property."
    msgbuffers.safety_check_tag('Wait', self._tag, self.Tag.Wait, self._tags_by_value)
    return self._data

  @Wait.setter
  def Wait(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.Wait', value, Anki.Cozmo.ExternalInterface.Wait)
    self._tag = self.Tag.Wait

  @property
  def WaitForImages(self):
    "Anki.Cozmo.ExternalInterface.WaitForImages WaitForImages union property."
    msgbuffers.safety_check_tag('WaitForImages', self._tag, self.Tag.WaitForImages, self._tags_by_value)
    return self._data

  @WaitForImages.setter
  def WaitForImages(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.WaitForImages', value, Anki.Cozmo.ExternalInterface.WaitForImages)
    self._tag = self.Tag.WaitForImages

  @property
  def AdvertisementRegistrationMsg(self):
    "Anki.Cozmo.AdvertisementRegistrationMsg AdvertisementRegistrationMsg union property."
    msgbuffers.safety_check_tag('AdvertisementRegistrationMsg', self._tag, self.Tag.AdvertisementRegistrationMsg, self._tags_by_value)
    return self._data

  @AdvertisementRegistrationMsg.setter
  def AdvertisementRegistrationMsg(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.AdvertisementRegistrationMsg', value, Anki.Cozmo.AdvertisementRegistrationMsg)
    self._tag = self.Tag.AdvertisementRegistrationMsg

  @property
  def AdvertisementMsg(self):
    "Anki.Cozmo.AdvertisementMsg AdvertisementMsg union property."
    msgbuffers.safety_check_tag('AdvertisementMsg', self._tag, self.Tag.AdvertisementMsg, self._tags_by_value)
    return self._data

  @AdvertisementMsg.setter
  def AdvertisementMsg(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.AdvertisementMsg', value, Anki.Cozmo.AdvertisementMsg)
    self._tag = self.Tag.AdvertisementMsg

  @property
  def Ping(self):
    "Anki.Cozmo.ExternalInterface.Ping Ping union property."
    msgbuffers.safety_check_tag('Ping', self._tag, self.Tag.Ping, self._tags_by_value)
    return self._data

  @Ping.setter
  def Ping(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.Ping', value, Anki.Cozmo.ExternalInterface.Ping)
    self._tag = self.Tag.Ping

  @property
  def DenyGameStart(self):
    "Anki.Cozmo.ExternalInterface.DenyGameStart DenyGameStart union property."
    msgbuffers.safety_check_tag('DenyGameStart', self._tag, self.Tag.DenyGameStart, self._tags_by_value)
    return self._data

  @DenyGameStart.setter
  def DenyGameStart(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DenyGameStart', value, Anki.Cozmo.ExternalInterface.DenyGameStart)
    self._tag = self.Tag.DenyGameStart

  @property
  def SetVizOrigin(self):
    "Anki.Cozmo.SetVizOrigin SetVizOrigin union property."
    msgbuffers.safety_check_tag('SetVizOrigin', self._tag, self.Tag.SetVizOrigin, self._tags_by_value)
    return self._data

  @SetVizOrigin.setter
  def SetVizOrigin(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetVizOrigin', value, Anki.Cozmo.SetVizOrigin)
    self._tag = self.Tag.SetVizOrigin

  @property
  def ImageChunk(self):
    "Anki.Cozmo.ImageChunk ImageChunk union property."
    msgbuffers.safety_check_tag('ImageChunk', self._tag, self.Tag.ImageChunk, self._tags_by_value)
    return self._data

  @ImageChunk.setter
  def ImageChunk(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ImageChunk', value, Anki.Cozmo.ImageChunk)
    self._tag = self.Tag.ImageChunk

  @property
  def ImageImuData(self):
    "Anki.Cozmo.ImageImuData ImageImuData union property."
    msgbuffers.safety_check_tag('ImageImuData', self._tag, self.Tag.ImageImuData, self._tags_by_value)
    return self._data

  @ImageImuData.setter
  def ImageImuData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ImageImuData', value, Anki.Cozmo.ImageImuData)
    self._tag = self.Tag.ImageImuData

  @property
  def CameraCalibration(self):
    "Anki.Cozmo.CameraCalibration CameraCalibration union property."
    msgbuffers.safety_check_tag('CameraCalibration', self._tag, self.Tag.CameraCalibration, self._tags_by_value)
    return self._data

  @CameraCalibration.setter
  def CameraCalibration(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CameraCalibration', value, Anki.Cozmo.CameraCalibration)
    self._tag = self.Tag.CameraCalibration

  @property
  def IMURequest(self):
    "Anki.Cozmo.IMURequest IMURequest union property."
    msgbuffers.safety_check_tag('IMURequest', self._tag, self.Tag.IMURequest, self._tags_by_value)
    return self._data

  @IMURequest.setter
  def IMURequest(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.IMURequest', value, Anki.Cozmo.IMURequest)
    self._tag = self.Tag.IMURequest

  @property
  def StartControllerTestMode(self):
    "Anki.Cozmo.StartControllerTestMode StartControllerTestMode union property."
    msgbuffers.safety_check_tag('StartControllerTestMode', self._tag, self.Tag.StartControllerTestMode, self._tags_by_value)
    return self._data

  @StartControllerTestMode.setter
  def StartControllerTestMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StartControllerTestMode', value, Anki.Cozmo.StartControllerTestMode)
    self._tag = self.Tag.StartControllerTestMode

  @property
  def RawPWM(self):
    "Anki.Cozmo.RawPWM RawPWM union property."
    msgbuffers.safety_check_tag('RawPWM', self._tag, self.Tag.RawPWM, self._tags_by_value)
    return self._data

  @RawPWM.setter
  def RawPWM(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RawPWM', value, Anki.Cozmo.RawPWM)
    self._tag = self.Tag.RawPWM

  @property
  def UiDeviceConnectionSuccess(self):
    "Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess UiDeviceConnectionSuccess union property."
    msgbuffers.safety_check_tag('UiDeviceConnectionSuccess', self._tag, self.Tag.UiDeviceConnectionSuccess, self._tags_by_value)
    return self._data

  @UiDeviceConnectionSuccess.setter
  def UiDeviceConnectionSuccess(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.UiDeviceConnectionSuccess', value, Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess)
    self._tag = self.Tag.UiDeviceConnectionSuccess

  @property
  def ConnectToRobot(self):
    "Anki.Cozmo.ExternalInterface.ConnectToRobot ConnectToRobot union property."
    msgbuffers.safety_check_tag('ConnectToRobot', self._tag, self.Tag.ConnectToRobot, self._tags_by_value)
    return self._data

  @ConnectToRobot.setter
  def ConnectToRobot(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ConnectToRobot', value, Anki.Cozmo.ExternalInterface.ConnectToRobot)
    self._tag = self.Tag.ConnectToRobot

  @property
  def ConnectToUiDevice(self):
    "Anki.Cozmo.ExternalInterface.ConnectToUiDevice ConnectToUiDevice union property."
    msgbuffers.safety_check_tag('ConnectToUiDevice', self._tag, self.Tag.ConnectToUiDevice, self._tags_by_value)
    return self._data

  @ConnectToUiDevice.setter
  def ConnectToUiDevice(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ConnectToUiDevice', value, Anki.Cozmo.ExternalInterface.ConnectToUiDevice)
    self._tag = self.Tag.ConnectToUiDevice

  @property
  def DisconnectFromUiDevice(self):
    "Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice DisconnectFromUiDevice union property."
    msgbuffers.safety_check_tag('DisconnectFromUiDevice', self._tag, self.Tag.DisconnectFromUiDevice, self._tags_by_value)
    return self._data

  @DisconnectFromUiDevice.setter
  def DisconnectFromUiDevice(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DisconnectFromUiDevice', value, Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice)
    self._tag = self.Tag.DisconnectFromUiDevice

  @property
  def StartEngine(self):
    "Anki.Cozmo.ExternalInterface.StartEngine StartEngine union property."
    msgbuffers.safety_check_tag('StartEngine', self._tag, self.Tag.StartEngine, self._tags_by_value)
    return self._data

  @StartEngine.setter
  def StartEngine(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StartEngine', value, Anki.Cozmo.ExternalInterface.StartEngine)
    self._tag = self.Tag.StartEngine

  @property
  def ReliableTransportRunMode(self):
    "Anki.Cozmo.ExternalInterface.ReliableTransportRunMode ReliableTransportRunMode union property."
    msgbuffers.safety_check_tag('ReliableTransportRunMode', self._tag, self.Tag.ReliableTransportRunMode, self._tags_by_value)
    return self._data

  @ReliableTransportRunMode.setter
  def ReliableTransportRunMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ReliableTransportRunMode', value, Anki.Cozmo.ExternalInterface.ReliableTransportRunMode)
    self._tag = self.Tag.ReliableTransportRunMode

  @property
  def RequestFeatureToggles(self):
    "Anki.Cozmo.ExternalInterface.RequestFeatureToggles RequestFeatureToggles union property."
    msgbuffers.safety_check_tag('RequestFeatureToggles', self._tag, self.Tag.RequestFeatureToggles, self._tags_by_value)
    return self._data

  @RequestFeatureToggles.setter
  def RequestFeatureToggles(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestFeatureToggles', value, Anki.Cozmo.ExternalInterface.RequestFeatureToggles)
    self._tag = self.Tag.RequestFeatureToggles

  @property
  def SetFeatureToggle(self):
    "Anki.Cozmo.ExternalInterface.SetFeatureToggle SetFeatureToggle union property."
    msgbuffers.safety_check_tag('SetFeatureToggle', self._tag, self.Tag.SetFeatureToggle, self._tags_by_value)
    return self._data

  @SetFeatureToggle.setter
  def SetFeatureToggle(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetFeatureToggle', value, Anki.Cozmo.ExternalInterface.SetFeatureToggle)
    self._tag = self.Tag.SetFeatureToggle

  @property
  def StartIdleTimeout(self):
    "Anki.Cozmo.ExternalInterface.StartIdleTimeout StartIdleTimeout union property."
    msgbuffers.safety_check_tag('StartIdleTimeout', self._tag, self.Tag.StartIdleTimeout, self._tags_by_value)
    return self._data

  @StartIdleTimeout.setter
  def StartIdleTimeout(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StartIdleTimeout', value, Anki.Cozmo.ExternalInterface.StartIdleTimeout)
    self._tag = self.Tag.StartIdleTimeout

  @property
  def CancelIdleTimeout(self):
    "Anki.Cozmo.ExternalInterface.CancelIdleTimeout CancelIdleTimeout union property."
    msgbuffers.safety_check_tag('CancelIdleTimeout', self._tag, self.Tag.CancelIdleTimeout, self._tags_by_value)
    return self._data

  @CancelIdleTimeout.setter
  def CancelIdleTimeout(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CancelIdleTimeout', value, Anki.Cozmo.ExternalInterface.CancelIdleTimeout)
    self._tag = self.Tag.CancelIdleTimeout

  @property
  def SetGameBeingPaused(self):
    "Anki.Cozmo.ExternalInterface.SetGameBeingPaused SetGameBeingPaused union property."
    msgbuffers.safety_check_tag('SetGameBeingPaused', self._tag, self.Tag.SetGameBeingPaused, self._tags_by_value)
    return self._data

  @SetGameBeingPaused.setter
  def SetGameBeingPaused(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetGameBeingPaused', value, Anki.Cozmo.ExternalInterface.SetGameBeingPaused)
    self._tag = self.Tag.SetGameBeingPaused

  @property
  def UpdateFirmware(self):
    "Anki.Cozmo.ExternalInterface.UpdateFirmware UpdateFirmware union property."
    msgbuffers.safety_check_tag('UpdateFirmware', self._tag, self.Tag.UpdateFirmware, self._tags_by_value)
    return self._data

  @UpdateFirmware.setter
  def UpdateFirmware(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.UpdateFirmware', value, Anki.Cozmo.ExternalInterface.UpdateFirmware)
    self._tag = self.Tag.UpdateFirmware

  @property
  def ResetFirmware(self):
    "Anki.Cozmo.ExternalInterface.ResetFirmware ResetFirmware union property."
    msgbuffers.safety_check_tag('ResetFirmware', self._tag, self.Tag.ResetFirmware, self._tags_by_value)
    return self._data

  @ResetFirmware.setter
  def ResetFirmware(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ResetFirmware', value, Anki.Cozmo.ExternalInterface.ResetFirmware)
    self._tag = self.Tag.ResetFirmware

  @property
  def DriveWheels(self):
    "Anki.Cozmo.ExternalInterface.DriveWheels DriveWheels union property."
    msgbuffers.safety_check_tag('DriveWheels', self._tag, self.Tag.DriveWheels, self._tags_by_value)
    return self._data

  @DriveWheels.setter
  def DriveWheels(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DriveWheels', value, Anki.Cozmo.ExternalInterface.DriveWheels)
    self._tag = self.Tag.DriveWheels

  @property
  def DriveArc(self):
    "Anki.Cozmo.ExternalInterface.DriveArc DriveArc union property."
    msgbuffers.safety_check_tag('DriveArc', self._tag, self.Tag.DriveArc, self._tags_by_value)
    return self._data

  @DriveArc.setter
  def DriveArc(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DriveArc', value, Anki.Cozmo.ExternalInterface.DriveArc)
    self._tag = self.Tag.DriveArc

  @property
  def MoveHead(self):
    "Anki.Cozmo.ExternalInterface.MoveHead MoveHead union property."
    msgbuffers.safety_check_tag('MoveHead', self._tag, self.Tag.MoveHead, self._tags_by_value)
    return self._data

  @MoveHead.setter
  def MoveHead(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.MoveHead', value, Anki.Cozmo.ExternalInterface.MoveHead)
    self._tag = self.Tag.MoveHead

  @property
  def MoveLift(self):
    "Anki.Cozmo.ExternalInterface.MoveLift MoveLift union property."
    msgbuffers.safety_check_tag('MoveLift', self._tag, self.Tag.MoveLift, self._tags_by_value)
    return self._data

  @MoveLift.setter
  def MoveLift(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.MoveLift', value, Anki.Cozmo.ExternalInterface.MoveLift)
    self._tag = self.Tag.MoveLift

  @property
  def EnableLiftPower(self):
    "Anki.Cozmo.ExternalInterface.EnableLiftPower EnableLiftPower union property."
    msgbuffers.safety_check_tag('EnableLiftPower', self._tag, self.Tag.EnableLiftPower, self._tags_by_value)
    return self._data

  @EnableLiftPower.setter
  def EnableLiftPower(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableLiftPower', value, Anki.Cozmo.ExternalInterface.EnableLiftPower)
    self._tag = self.Tag.EnableLiftPower

  @property
  def EnableCliffSensor(self):
    "Anki.Cozmo.ExternalInterface.EnableCliffSensor EnableCliffSensor union property."
    msgbuffers.safety_check_tag('EnableCliffSensor', self._tag, self.Tag.EnableCliffSensor, self._tags_by_value)
    return self._data

  @EnableCliffSensor.setter
  def EnableCliffSensor(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableCliffSensor', value, Anki.Cozmo.ExternalInterface.EnableCliffSensor)
    self._tag = self.Tag.EnableCliffSensor

  @property
  def EnableBlockTapFilter(self):
    "Anki.Cozmo.ExternalInterface.EnableBlockTapFilter EnableBlockTapFilter union property."
    msgbuffers.safety_check_tag('EnableBlockTapFilter', self._tag, self.Tag.EnableBlockTapFilter, self._tags_by_value)
    return self._data

  @EnableBlockTapFilter.setter
  def EnableBlockTapFilter(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableBlockTapFilter', value, Anki.Cozmo.ExternalInterface.EnableBlockTapFilter)
    self._tag = self.Tag.EnableBlockTapFilter

  @property
  def GetBlockTapFilterStatus(self):
    "Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus GetBlockTapFilterStatus union property."
    msgbuffers.safety_check_tag('GetBlockTapFilterStatus', self._tag, self.Tag.GetBlockTapFilterStatus, self._tags_by_value)
    return self._data

  @GetBlockTapFilterStatus.setter
  def GetBlockTapFilterStatus(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GetBlockTapFilterStatus', value, Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus)
    self._tag = self.Tag.GetBlockTapFilterStatus

  @property
  def StopAllMotors(self):
    "Anki.Cozmo.ExternalInterface.StopAllMotors StopAllMotors union property."
    msgbuffers.safety_check_tag('StopAllMotors', self._tag, self.Tag.StopAllMotors, self._tags_by_value)
    return self._data

  @StopAllMotors.setter
  def StopAllMotors(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StopAllMotors', value, Anki.Cozmo.ExternalInterface.StopAllMotors)
    self._tag = self.Tag.StopAllMotors

  @property
  def ControllerGains(self):
    "Anki.Cozmo.ExternalInterface.ControllerGains ControllerGains union property."
    msgbuffers.safety_check_tag('ControllerGains', self._tag, self.Tag.ControllerGains, self._tags_by_value)
    return self._data

  @ControllerGains.setter
  def ControllerGains(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ControllerGains', value, Anki.Cozmo.ExternalInterface.ControllerGains)
    self._tag = self.Tag.ControllerGains

  @property
  def RollActionParams(self):
    "Anki.Cozmo.ExternalInterface.RollActionParams RollActionParams union property."
    msgbuffers.safety_check_tag('RollActionParams', self._tag, self.Tag.RollActionParams, self._tags_by_value)
    return self._data

  @RollActionParams.setter
  def RollActionParams(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RollActionParams', value, Anki.Cozmo.ExternalInterface.RollActionParams)
    self._tag = self.Tag.RollActionParams

  @property
  def SetMotionModelParams(self):
    "Anki.Cozmo.ExternalInterface.SetMotionModelParams SetMotionModelParams union property."
    msgbuffers.safety_check_tag('SetMotionModelParams', self._tag, self.Tag.SetMotionModelParams, self._tags_by_value)
    return self._data

  @SetMotionModelParams.setter
  def SetMotionModelParams(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetMotionModelParams', value, Anki.Cozmo.ExternalInterface.SetMotionModelParams)
    self._tag = self.Tag.SetMotionModelParams

  @property
  def SetRobotVolume(self):
    "Anki.Cozmo.ExternalInterface.SetRobotVolume SetRobotVolume union property."
    msgbuffers.safety_check_tag('SetRobotVolume', self._tag, self.Tag.SetRobotVolume, self._tags_by_value)
    return self._data

  @SetRobotVolume.setter
  def SetRobotVolume(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetRobotVolume', value, Anki.Cozmo.ExternalInterface.SetRobotVolume)
    self._tag = self.Tag.SetRobotVolume

  @property
  def SetRobotAudioOutputSource(self):
    "Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource SetRobotAudioOutputSource union property."
    msgbuffers.safety_check_tag('SetRobotAudioOutputSource', self._tag, self.Tag.SetRobotAudioOutputSource, self._tags_by_value)
    return self._data

  @SetRobotAudioOutputSource.setter
  def SetRobotAudioOutputSource(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetRobotAudioOutputSource', value, Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource)
    self._tag = self.Tag.SetRobotAudioOutputSource

  @property
  def ForceDelocalizeRobot(self):
    "Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot ForceDelocalizeRobot union property."
    msgbuffers.safety_check_tag('ForceDelocalizeRobot', self._tag, self.Tag.ForceDelocalizeRobot, self._tags_by_value)
    return self._data

  @ForceDelocalizeRobot.setter
  def ForceDelocalizeRobot(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ForceDelocalizeRobot', value, Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot)
    self._tag = self.Tag.ForceDelocalizeRobot

  @property
  def RestoreRobotFromBackup(self):
    "Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup RestoreRobotFromBackup union property."
    msgbuffers.safety_check_tag('RestoreRobotFromBackup', self._tag, self.Tag.RestoreRobotFromBackup, self._tags_by_value)
    return self._data

  @RestoreRobotFromBackup.setter
  def RestoreRobotFromBackup(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RestoreRobotFromBackup', value, Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup)
    self._tag = self.Tag.RestoreRobotFromBackup

  @property
  def RequestRobotRestoreData(self):
    "Anki.Cozmo.ExternalInterface.RequestRobotRestoreData RequestRobotRestoreData union property."
    msgbuffers.safety_check_tag('RequestRobotRestoreData', self._tag, self.Tag.RequestRobotRestoreData, self._tags_by_value)
    return self._data

  @RequestRobotRestoreData.setter
  def RequestRobotRestoreData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestRobotRestoreData', value, Anki.Cozmo.ExternalInterface.RequestRobotRestoreData)
    self._tag = self.Tag.RequestRobotRestoreData

  @property
  def WipeRobotGameData(self):
    "Anki.Cozmo.ExternalInterface.WipeRobotGameData WipeRobotGameData union property."
    msgbuffers.safety_check_tag('WipeRobotGameData', self._tag, self.Tag.WipeRobotGameData, self._tags_by_value)
    return self._data

  @WipeRobotGameData.setter
  def WipeRobotGameData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.WipeRobotGameData', value, Anki.Cozmo.ExternalInterface.WipeRobotGameData)
    self._tag = self.Tag.WipeRobotGameData

  @property
  def RequestUnlockDataFromBackup(self):
    "Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup RequestUnlockDataFromBackup union property."
    msgbuffers.safety_check_tag('RequestUnlockDataFromBackup', self._tag, self.Tag.RequestUnlockDataFromBackup, self._tags_by_value)
    return self._data

  @RequestUnlockDataFromBackup.setter
  def RequestUnlockDataFromBackup(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestUnlockDataFromBackup', value, Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup)
    self._tag = self.Tag.RequestUnlockDataFromBackup

  @property
  def CancelAction(self):
    "Anki.Cozmo.ExternalInterface.CancelAction CancelAction union property."
    msgbuffers.safety_check_tag('CancelAction', self._tag, self.Tag.CancelAction, self._tags_by_value)
    return self._data

  @CancelAction.setter
  def CancelAction(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CancelAction', value, Anki.Cozmo.ExternalInterface.CancelAction)
    self._tag = self.Tag.CancelAction

  @property
  def CancelActionByIdTag(self):
    "Anki.Cozmo.ExternalInterface.CancelActionByIdTag CancelActionByIdTag union property."
    msgbuffers.safety_check_tag('CancelActionByIdTag', self._tag, self.Tag.CancelActionByIdTag, self._tags_by_value)
    return self._data

  @CancelActionByIdTag.setter
  def CancelActionByIdTag(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CancelActionByIdTag', value, Anki.Cozmo.ExternalInterface.CancelActionByIdTag)
    self._tag = self.Tag.CancelActionByIdTag

  @property
  def QueueSingleAction(self):
    "Anki.Cozmo.ExternalInterface.QueueSingleAction QueueSingleAction union property."
    msgbuffers.safety_check_tag('QueueSingleAction', self._tag, self.Tag.QueueSingleAction, self._tags_by_value)
    return self._data

  @QueueSingleAction.setter
  def QueueSingleAction(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.QueueSingleAction', value, Anki.Cozmo.ExternalInterface.QueueSingleAction)
    self._tag = self.Tag.QueueSingleAction

  @property
  def QueueCompoundAction(self):
    "Anki.Cozmo.ExternalInterface.QueueCompoundAction QueueCompoundAction union property."
    msgbuffers.safety_check_tag('QueueCompoundAction', self._tag, self.Tag.QueueCompoundAction, self._tags_by_value)
    return self._data

  @QueueCompoundAction.setter
  def QueueCompoundAction(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.QueueCompoundAction', value, Anki.Cozmo.ExternalInterface.QueueCompoundAction)
    self._tag = self.Tag.QueueCompoundAction

  @property
  def ImageRequest(self):
    "Anki.Cozmo.ExternalInterface.ImageRequest ImageRequest union property."
    msgbuffers.safety_check_tag('ImageRequest', self._tag, self.Tag.ImageRequest, self._tags_by_value)
    return self._data

  @ImageRequest.setter
  def ImageRequest(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ImageRequest', value, Anki.Cozmo.ExternalInterface.ImageRequest)
    self._tag = self.Tag.ImageRequest

  @property
  def SetRobotImageSendMode(self):
    "Anki.Cozmo.ExternalInterface.SetRobotImageSendMode SetRobotImageSendMode union property."
    msgbuffers.safety_check_tag('SetRobotImageSendMode', self._tag, self.Tag.SetRobotImageSendMode, self._tags_by_value)
    return self._data

  @SetRobotImageSendMode.setter
  def SetRobotImageSendMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetRobotImageSendMode', value, Anki.Cozmo.ExternalInterface.SetRobotImageSendMode)
    self._tag = self.Tag.SetRobotImageSendMode

  @property
  def SaveImages(self):
    "Anki.Cozmo.ExternalInterface.SaveImages SaveImages union property."
    msgbuffers.safety_check_tag('SaveImages', self._tag, self.Tag.SaveImages, self._tags_by_value)
    return self._data

  @SaveImages.setter
  def SaveImages(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SaveImages', value, Anki.Cozmo.ExternalInterface.SaveImages)
    self._tag = self.Tag.SaveImages

  @property
  def SaveRobotState(self):
    "Anki.Cozmo.ExternalInterface.SaveRobotState SaveRobotState union property."
    msgbuffers.safety_check_tag('SaveRobotState', self._tag, self.Tag.SaveRobotState, self._tags_by_value)
    return self._data

  @SaveRobotState.setter
  def SaveRobotState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SaveRobotState', value, Anki.Cozmo.ExternalInterface.SaveRobotState)
    self._tag = self.Tag.SaveRobotState

  @property
  def EnableDisplay(self):
    "Anki.Cozmo.ExternalInterface.EnableDisplay EnableDisplay union property."
    msgbuffers.safety_check_tag('EnableDisplay', self._tag, self.Tag.EnableDisplay, self._tags_by_value)
    return self._data

  @EnableDisplay.setter
  def EnableDisplay(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableDisplay', value, Anki.Cozmo.ExternalInterface.EnableDisplay)
    self._tag = self.Tag.EnableDisplay

  @property
  def ExecuteTestPlan(self):
    "Anki.Cozmo.ExternalInterface.ExecuteTestPlan ExecuteTestPlan union property."
    msgbuffers.safety_check_tag('ExecuteTestPlan', self._tag, self.Tag.ExecuteTestPlan, self._tags_by_value)
    return self._data

  @ExecuteTestPlan.setter
  def ExecuteTestPlan(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ExecuteTestPlan', value, Anki.Cozmo.ExternalInterface.ExecuteTestPlan)
    self._tag = self.Tag.ExecuteTestPlan

  @property
  def PlannerRunMode(self):
    "Anki.Cozmo.ExternalInterface.PlannerRunMode PlannerRunMode union property."
    msgbuffers.safety_check_tag('PlannerRunMode', self._tag, self.Tag.PlannerRunMode, self._tags_by_value)
    return self._data

  @PlannerRunMode.setter
  def PlannerRunMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PlannerRunMode', value, Anki.Cozmo.ExternalInterface.PlannerRunMode)
    self._tag = self.Tag.PlannerRunMode

  @property
  def SelectNextObject(self):
    "Anki.Cozmo.ExternalInterface.SelectNextObject SelectNextObject union property."
    msgbuffers.safety_check_tag('SelectNextObject', self._tag, self.Tag.SelectNextObject, self._tags_by_value)
    return self._data

  @SelectNextObject.setter
  def SelectNextObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SelectNextObject', value, Anki.Cozmo.ExternalInterface.SelectNextObject)
    self._tag = self.Tag.SelectNextObject

  @property
  def SetRobotCarryingObject(self):
    "Anki.Cozmo.ExternalInterface.SetRobotCarryingObject SetRobotCarryingObject union property."
    msgbuffers.safety_check_tag('SetRobotCarryingObject', self._tag, self.Tag.SetRobotCarryingObject, self._tags_by_value)
    return self._data

  @SetRobotCarryingObject.setter
  def SetRobotCarryingObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetRobotCarryingObject', value, Anki.Cozmo.ExternalInterface.SetRobotCarryingObject)
    self._tag = self.Tag.SetRobotCarryingObject

  @property
  def CreateFixedCustomObject(self):
    "Anki.Cozmo.ExternalInterface.CreateFixedCustomObject CreateFixedCustomObject union property."
    msgbuffers.safety_check_tag('CreateFixedCustomObject', self._tag, self.Tag.CreateFixedCustomObject, self._tags_by_value)
    return self._data

  @CreateFixedCustomObject.setter
  def CreateFixedCustomObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.CreateFixedCustomObject', value, Anki.Cozmo.ExternalInterface.CreateFixedCustomObject)
    self._tag = self.Tag.CreateFixedCustomObject

  @property
  def DefineCustomObject(self):
    "Anki.Cozmo.ExternalInterface.DefineCustomObject DefineCustomObject union property."
    msgbuffers.safety_check_tag('DefineCustomObject', self._tag, self.Tag.DefineCustomObject, self._tags_by_value)
    return self._data

  @DefineCustomObject.setter
  def DefineCustomObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DefineCustomObject', value, Anki.Cozmo.ExternalInterface.DefineCustomObject)
    self._tag = self.Tag.DefineCustomObject

  @property
  def ClearAllBlocks(self):
    "Anki.Cozmo.ExternalInterface.ClearAllBlocks ClearAllBlocks union property."
    msgbuffers.safety_check_tag('ClearAllBlocks', self._tag, self.Tag.ClearAllBlocks, self._tags_by_value)
    return self._data

  @ClearAllBlocks.setter
  def ClearAllBlocks(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ClearAllBlocks', value, Anki.Cozmo.ExternalInterface.ClearAllBlocks)
    self._tag = self.Tag.ClearAllBlocks

  @property
  def ClearAllObjects(self):
    "Anki.Cozmo.ExternalInterface.ClearAllObjects ClearAllObjects union property."
    msgbuffers.safety_check_tag('ClearAllObjects', self._tag, self.Tag.ClearAllObjects, self._tags_by_value)
    return self._data

  @ClearAllObjects.setter
  def ClearAllObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ClearAllObjects', value, Anki.Cozmo.ExternalInterface.ClearAllObjects)
    self._tag = self.Tag.ClearAllObjects

  @property
  def DeleteAllObjects(self):
    "Anki.Cozmo.ExternalInterface.DeleteAllObjects DeleteAllObjects union property."
    msgbuffers.safety_check_tag('DeleteAllObjects', self._tag, self.Tag.DeleteAllObjects, self._tags_by_value)
    return self._data

  @DeleteAllObjects.setter
  def DeleteAllObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DeleteAllObjects', value, Anki.Cozmo.ExternalInterface.DeleteAllObjects)
    self._tag = self.Tag.DeleteAllObjects

  @property
  def DeleteAllCustomObjects(self):
    "Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects DeleteAllCustomObjects union property."
    msgbuffers.safety_check_tag('DeleteAllCustomObjects', self._tag, self.Tag.DeleteAllCustomObjects, self._tags_by_value)
    return self._data

  @DeleteAllCustomObjects.setter
  def DeleteAllCustomObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DeleteAllCustomObjects', value, Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects)
    self._tag = self.Tag.DeleteAllCustomObjects

  @property
  def SetObjectAdditionAndDeletion(self):
    "Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion SetObjectAdditionAndDeletion union property."
    msgbuffers.safety_check_tag('SetObjectAdditionAndDeletion', self._tag, self.Tag.SetObjectAdditionAndDeletion, self._tags_by_value)
    return self._data

  @SetObjectAdditionAndDeletion.setter
  def SetObjectAdditionAndDeletion(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetObjectAdditionAndDeletion', value, Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion)
    self._tag = self.Tag.SetObjectAdditionAndDeletion

  @property
  def VisionWhileMoving(self):
    "Anki.Cozmo.ExternalInterface.VisionWhileMoving VisionWhileMoving union property."
    msgbuffers.safety_check_tag('VisionWhileMoving', self._tag, self.Tag.VisionWhileMoving, self._tags_by_value)
    return self._data

  @VisionWhileMoving.setter
  def VisionWhileMoving(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisionWhileMoving', value, Anki.Cozmo.ExternalInterface.VisionWhileMoving)
    self._tag = self.Tag.VisionWhileMoving

  @property
  def SetFaceEnrollmentPose(self):
    "Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose SetFaceEnrollmentPose union property."
    msgbuffers.safety_check_tag('SetFaceEnrollmentPose', self._tag, self.Tag.SetFaceEnrollmentPose, self._tags_by_value)
    return self._data

  @SetFaceEnrollmentPose.setter
  def SetFaceEnrollmentPose(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetFaceEnrollmentPose', value, Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose)
    self._tag = self.Tag.SetFaceEnrollmentPose

  @property
  def EraseEnrolledFaceByID(self):
    "Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID EraseEnrolledFaceByID union property."
    msgbuffers.safety_check_tag('EraseEnrolledFaceByID', self._tag, self.Tag.EraseEnrolledFaceByID, self._tags_by_value)
    return self._data

  @EraseEnrolledFaceByID.setter
  def EraseEnrolledFaceByID(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EraseEnrolledFaceByID', value, Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID)
    self._tag = self.Tag.EraseEnrolledFaceByID

  @property
  def EraseAllEnrolledFaces(self):
    "Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces EraseAllEnrolledFaces union property."
    msgbuffers.safety_check_tag('EraseAllEnrolledFaces', self._tag, self.Tag.EraseAllEnrolledFaces, self._tags_by_value)
    return self._data

  @EraseAllEnrolledFaces.setter
  def EraseAllEnrolledFaces(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EraseAllEnrolledFaces', value, Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces)
    self._tag = self.Tag.EraseAllEnrolledFaces

  @property
  def EnableVisionMode(self):
    "Anki.Cozmo.ExternalInterface.EnableVisionMode EnableVisionMode union property."
    msgbuffers.safety_check_tag('EnableVisionMode', self._tag, self.Tag.EnableVisionMode, self._tags_by_value)
    return self._data

  @EnableVisionMode.setter
  def EnableVisionMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableVisionMode', value, Anki.Cozmo.ExternalInterface.EnableVisionMode)
    self._tag = self.Tag.EnableVisionMode

  @property
  def UpdateEnrolledFaceByID(self):
    "Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID UpdateEnrolledFaceByID union property."
    msgbuffers.safety_check_tag('UpdateEnrolledFaceByID', self._tag, self.Tag.UpdateEnrolledFaceByID, self._tags_by_value)
    return self._data

  @UpdateEnrolledFaceByID.setter
  def UpdateEnrolledFaceByID(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.UpdateEnrolledFaceByID', value, Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID)
    self._tag = self.Tag.UpdateEnrolledFaceByID

  @property
  def VisionRunMode(self):
    "Anki.Cozmo.ExternalInterface.VisionRunMode VisionRunMode union property."
    msgbuffers.safety_check_tag('VisionRunMode', self._tag, self.Tag.VisionRunMode, self._tags_by_value)
    return self._data

  @VisionRunMode.setter
  def VisionRunMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisionRunMode', value, Anki.Cozmo.ExternalInterface.VisionRunMode)
    self._tag = self.Tag.VisionRunMode

  @property
  def SaveFaceAlbumToFile(self):
    "Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile SaveFaceAlbumToFile union property."
    msgbuffers.safety_check_tag('SaveFaceAlbumToFile', self._tag, self.Tag.SaveFaceAlbumToFile, self._tags_by_value)
    return self._data

  @SaveFaceAlbumToFile.setter
  def SaveFaceAlbumToFile(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SaveFaceAlbumToFile', value, Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile)
    self._tag = self.Tag.SaveFaceAlbumToFile

  @property
  def LoadFaceAlbumFromFile(self):
    "Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile LoadFaceAlbumFromFile union property."
    msgbuffers.safety_check_tag('LoadFaceAlbumFromFile', self._tag, self.Tag.LoadFaceAlbumFromFile, self._tags_by_value)
    return self._data

  @LoadFaceAlbumFromFile.setter
  def LoadFaceAlbumFromFile(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.LoadFaceAlbumFromFile', value, Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile)
    self._tag = self.Tag.LoadFaceAlbumFromFile

  @property
  def SetMemoryMapRenderEnabled(self):
    "Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled SetMemoryMapRenderEnabled union property."
    msgbuffers.safety_check_tag('SetMemoryMapRenderEnabled', self._tag, self.Tag.SetMemoryMapRenderEnabled, self._tags_by_value)
    return self._data

  @SetMemoryMapRenderEnabled.setter
  def SetMemoryMapRenderEnabled(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetMemoryMapRenderEnabled', value, Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled)
    self._tag = self.Tag.SetMemoryMapRenderEnabled

  @property
  def ActivateBehaviorChooser(self):
    "Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser ActivateBehaviorChooser union property."
    msgbuffers.safety_check_tag('ActivateBehaviorChooser', self._tag, self.Tag.ActivateBehaviorChooser, self._tags_by_value)
    return self._data

  @ActivateBehaviorChooser.setter
  def ActivateBehaviorChooser(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ActivateBehaviorChooser', value, Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser)
    self._tag = self.Tag.ActivateBehaviorChooser

  @property
  def ExecuteBehavior(self):
    "Anki.Cozmo.ExternalInterface.ExecuteBehavior ExecuteBehavior union property."
    msgbuffers.safety_check_tag('ExecuteBehavior', self._tag, self.Tag.ExecuteBehavior, self._tags_by_value)
    return self._data

  @ExecuteBehavior.setter
  def ExecuteBehavior(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ExecuteBehavior', value, Anki.Cozmo.ExternalInterface.ExecuteBehavior)
    self._tag = self.Tag.ExecuteBehavior

  @property
  def ExecuteBehaviorByExecutableType(self):
    "Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType ExecuteBehaviorByExecutableType union property."
    msgbuffers.safety_check_tag('ExecuteBehaviorByExecutableType', self._tag, self.Tag.ExecuteBehaviorByExecutableType, self._tags_by_value)
    return self._data

  @ExecuteBehaviorByExecutableType.setter
  def ExecuteBehaviorByExecutableType(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ExecuteBehaviorByExecutableType', value, Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType)
    self._tag = self.Tag.ExecuteBehaviorByExecutableType

  @property
  def ExecuteBehaviorByName(self):
    "Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName ExecuteBehaviorByName union property."
    msgbuffers.safety_check_tag('ExecuteBehaviorByName', self._tag, self.Tag.ExecuteBehaviorByName, self._tags_by_value)
    return self._data

  @ExecuteBehaviorByName.setter
  def ExecuteBehaviorByName(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ExecuteBehaviorByName', value, Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName)
    self._tag = self.Tag.ExecuteBehaviorByName

  @property
  def BehaviorManagerMessage(self):
    "Anki.Cozmo.ExternalInterface.BehaviorManagerMessage BehaviorManagerMessage union property."
    msgbuffers.safety_check_tag('BehaviorManagerMessage', self._tag, self.Tag.BehaviorManagerMessage, self._tags_by_value)
    return self._data

  @BehaviorManagerMessage.setter
  def BehaviorManagerMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.BehaviorManagerMessage', value, Anki.Cozmo.ExternalInterface.BehaviorManagerMessage)
    self._tag = self.Tag.BehaviorManagerMessage

  @property
  def AbortPath(self):
    "Anki.Cozmo.ExternalInterface.AbortPath AbortPath union property."
    msgbuffers.safety_check_tag('AbortPath', self._tag, self.Tag.AbortPath, self._tags_by_value)
    return self._data

  @AbortPath.setter
  def AbortPath(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.AbortPath', value, Anki.Cozmo.ExternalInterface.AbortPath)
    self._tag = self.Tag.AbortPath

  @property
  def AbortAll(self):
    "Anki.Cozmo.ExternalInterface.AbortAll AbortAll union property."
    msgbuffers.safety_check_tag('AbortAll', self._tag, self.Tag.AbortAll, self._tags_by_value)
    return self._data

  @AbortAll.setter
  def AbortAll(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.AbortAll', value, Anki.Cozmo.ExternalInterface.AbortAll)
    self._tag = self.Tag.AbortAll

  @property
  def StartTestMode(self):
    "Anki.Cozmo.ExternalInterface.StartTestMode StartTestMode union property."
    msgbuffers.safety_check_tag('StartTestMode', self._tag, self.Tag.StartTestMode, self._tags_by_value)
    return self._data

  @StartTestMode.setter
  def StartTestMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StartTestMode', value, Anki.Cozmo.ExternalInterface.StartTestMode)
    self._tag = self.Tag.StartTestMode

  @property
  def RequestEnabledBehaviorList(self):
    "Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList RequestEnabledBehaviorList union property."
    msgbuffers.safety_check_tag('RequestEnabledBehaviorList', self._tag, self.Tag.RequestEnabledBehaviorList, self._tags_by_value)
    return self._data

  @RequestEnabledBehaviorList.setter
  def RequestEnabledBehaviorList(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestEnabledBehaviorList', value, Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList)
    self._tag = self.Tag.RequestEnabledBehaviorList

  @property
  def RequestEnableReactionaryBehavior(self):
    "Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior RequestEnableReactionaryBehavior union property."
    msgbuffers.safety_check_tag('RequestEnableReactionaryBehavior', self._tag, self.Tag.RequestEnableReactionaryBehavior, self._tags_by_value)
    return self._data

  @RequestEnableReactionaryBehavior.setter
  def RequestEnableReactionaryBehavior(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestEnableReactionaryBehavior', value, Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior)
    self._tag = self.Tag.RequestEnableReactionaryBehavior

  @property
  def SetDefaultHeadAndLiftState(self):
    "Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState SetDefaultHeadAndLiftState union property."
    msgbuffers.safety_check_tag('SetDefaultHeadAndLiftState', self._tag, self.Tag.SetDefaultHeadAndLiftState, self._tags_by_value)
    return self._data

  @SetDefaultHeadAndLiftState.setter
  def SetDefaultHeadAndLiftState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetDefaultHeadAndLiftState', value, Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState)
    self._tag = self.Tag.SetDefaultHeadAndLiftState

  @property
  def RequestAvailableObjects(self):
    "Anki.Cozmo.ExternalInterface.RequestAvailableObjects RequestAvailableObjects union property."
    msgbuffers.safety_check_tag('RequestAvailableObjects', self._tag, self.Tag.RequestAvailableObjects, self._tags_by_value)
    return self._data

  @RequestAvailableObjects.setter
  def RequestAvailableObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestAvailableObjects', value, Anki.Cozmo.ExternalInterface.RequestAvailableObjects)
    self._tag = self.Tag.RequestAvailableObjects

  @property
  def DrawPoseMarker(self):
    "Anki.Cozmo.ExternalInterface.DrawPoseMarker DrawPoseMarker union property."
    msgbuffers.safety_check_tag('DrawPoseMarker', self._tag, self.Tag.DrawPoseMarker, self._tags_by_value)
    return self._data

  @DrawPoseMarker.setter
  def DrawPoseMarker(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.DrawPoseMarker', value, Anki.Cozmo.ExternalInterface.DrawPoseMarker)
    self._tag = self.Tag.DrawPoseMarker

  @property
  def ErasePoseMarker(self):
    "Anki.Cozmo.ExternalInterface.ErasePoseMarker ErasePoseMarker union property."
    msgbuffers.safety_check_tag('ErasePoseMarker', self._tag, self.Tag.ErasePoseMarker, self._tags_by_value)
    return self._data

  @ErasePoseMarker.setter
  def ErasePoseMarker(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ErasePoseMarker', value, Anki.Cozmo.ExternalInterface.ErasePoseMarker)
    self._tag = self.Tag.ErasePoseMarker

  @property
  def VisualizeQuad(self):
    "Anki.Cozmo.ExternalInterface.VisualizeQuad VisualizeQuad union property."
    msgbuffers.safety_check_tag('VisualizeQuad', self._tag, self.Tag.VisualizeQuad, self._tags_by_value)
    return self._data

  @VisualizeQuad.setter
  def VisualizeQuad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.VisualizeQuad', value, Anki.Cozmo.ExternalInterface.VisualizeQuad)
    self._tag = self.Tag.VisualizeQuad

  @property
  def EraseQuad(self):
    "Anki.Cozmo.ExternalInterface.EraseQuad EraseQuad union property."
    msgbuffers.safety_check_tag('EraseQuad', self._tag, self.Tag.EraseQuad, self._tags_by_value)
    return self._data

  @EraseQuad.setter
  def EraseQuad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EraseQuad', value, Anki.Cozmo.ExternalInterface.EraseQuad)
    self._tag = self.Tag.EraseQuad

  @property
  def ReplayLastAnimation(self):
    "Anki.Cozmo.ExternalInterface.ReplayLastAnimation ReplayLastAnimation union property."
    msgbuffers.safety_check_tag('ReplayLastAnimation', self._tag, self.Tag.ReplayLastAnimation, self._tags_by_value)
    return self._data

  @ReplayLastAnimation.setter
  def ReplayLastAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ReplayLastAnimation', value, Anki.Cozmo.ExternalInterface.ReplayLastAnimation)
    self._tag = self.Tag.ReplayLastAnimation

  @property
  def SetIdleAnimation(self):
    "Anki.Cozmo.ExternalInterface.SetIdleAnimation SetIdleAnimation union property."
    msgbuffers.safety_check_tag('SetIdleAnimation', self._tag, self.Tag.SetIdleAnimation, self._tags_by_value)
    return self._data

  @SetIdleAnimation.setter
  def SetIdleAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetIdleAnimation', value, Anki.Cozmo.ExternalInterface.SetIdleAnimation)
    self._tag = self.Tag.SetIdleAnimation

  @property
  def PushIdleAnimation(self):
    "Anki.Cozmo.ExternalInterface.PushIdleAnimation PushIdleAnimation union property."
    msgbuffers.safety_check_tag('PushIdleAnimation', self._tag, self.Tag.PushIdleAnimation, self._tags_by_value)
    return self._data

  @PushIdleAnimation.setter
  def PushIdleAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PushIdleAnimation', value, Anki.Cozmo.ExternalInterface.PushIdleAnimation)
    self._tag = self.Tag.PushIdleAnimation

  @property
  def PopIdleAnimation(self):
    "Anki.Cozmo.ExternalInterface.PopIdleAnimation PopIdleAnimation union property."
    msgbuffers.safety_check_tag('PopIdleAnimation', self._tag, self.Tag.PopIdleAnimation, self._tags_by_value)
    return self._data

  @PopIdleAnimation.setter
  def PopIdleAnimation(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PopIdleAnimation', value, Anki.Cozmo.ExternalInterface.PopIdleAnimation)
    self._tag = self.Tag.PopIdleAnimation

  @property
  def ReadFaceAnimationDir(self):
    "Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir ReadFaceAnimationDir union property."
    msgbuffers.safety_check_tag('ReadFaceAnimationDir', self._tag, self.Tag.ReadFaceAnimationDir, self._tags_by_value)
    return self._data

  @ReadFaceAnimationDir.setter
  def ReadFaceAnimationDir(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ReadFaceAnimationDir', value, Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir)
    self._tag = self.Tag.ReadFaceAnimationDir

  @property
  def ReadAnimationFile(self):
    "Anki.Cozmo.ExternalInterface.ReadAnimationFile ReadAnimationFile union property."
    msgbuffers.safety_check_tag('ReadAnimationFile', self._tag, self.Tag.ReadAnimationFile, self._tags_by_value)
    return self._data

  @ReadAnimationFile.setter
  def ReadAnimationFile(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ReadAnimationFile', value, Anki.Cozmo.ExternalInterface.ReadAnimationFile)
    self._tag = self.Tag.ReadAnimationFile

  @property
  def RequestAvailableAnimations(self):
    "Anki.Cozmo.ExternalInterface.RequestAvailableAnimations RequestAvailableAnimations union property."
    msgbuffers.safety_check_tag('RequestAvailableAnimations', self._tag, self.Tag.RequestAvailableAnimations, self._tags_by_value)
    return self._data

  @RequestAvailableAnimations.setter
  def RequestAvailableAnimations(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestAvailableAnimations', value, Anki.Cozmo.ExternalInterface.RequestAvailableAnimations)
    self._tag = self.Tag.RequestAvailableAnimations

  @property
  def RequestAvailableAnimationGroups(self):
    "Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups RequestAvailableAnimationGroups union property."
    msgbuffers.safety_check_tag('RequestAvailableAnimationGroups', self._tag, self.Tag.RequestAvailableAnimationGroups, self._tags_by_value)
    return self._data

  @RequestAvailableAnimationGroups.setter
  def RequestAvailableAnimationGroups(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestAvailableAnimationGroups', value, Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups)
    self._tag = self.Tag.RequestAvailableAnimationGroups

  @property
  def SetLiveIdleAnimationParameters(self):
    "Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters SetLiveIdleAnimationParameters union property."
    msgbuffers.safety_check_tag('SetLiveIdleAnimationParameters', self._tag, self.Tag.SetLiveIdleAnimationParameters, self._tags_by_value)
    return self._data

  @SetLiveIdleAnimationParameters.setter
  def SetLiveIdleAnimationParameters(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetLiveIdleAnimationParameters', value, Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters)
    self._tag = self.Tag.SetLiveIdleAnimationParameters

  @property
  def PushDrivingAnimations(self):
    "Anki.Cozmo.ExternalInterface.PushDrivingAnimations PushDrivingAnimations union property."
    msgbuffers.safety_check_tag('PushDrivingAnimations', self._tag, self.Tag.PushDrivingAnimations, self._tags_by_value)
    return self._data

  @PushDrivingAnimations.setter
  def PushDrivingAnimations(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PushDrivingAnimations', value, Anki.Cozmo.ExternalInterface.PushDrivingAnimations)
    self._tag = self.Tag.PushDrivingAnimations

  @property
  def PopDrivingAnimations(self):
    "Anki.Cozmo.ExternalInterface.PopDrivingAnimations PopDrivingAnimations union property."
    msgbuffers.safety_check_tag('PopDrivingAnimations', self._tag, self.Tag.PopDrivingAnimations, self._tags_by_value)
    return self._data

  @PopDrivingAnimations.setter
  def PopDrivingAnimations(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.PopDrivingAnimations', value, Anki.Cozmo.ExternalInterface.PopDrivingAnimations)
    self._tag = self.Tag.PopDrivingAnimations

  @property
  def SetHeadlight(self):
    "Anki.Cozmo.ExternalInterface.SetHeadlight SetHeadlight union property."
    msgbuffers.safety_check_tag('SetHeadlight', self._tag, self.Tag.SetHeadlight, self._tags_by_value)
    return self._data

  @SetHeadlight.setter
  def SetHeadlight(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetHeadlight', value, Anki.Cozmo.ExternalInterface.SetHeadlight)
    self._tag = self.Tag.SetHeadlight

  @property
  def SetActiveObjectLEDs(self):
    "Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs SetActiveObjectLEDs union property."
    msgbuffers.safety_check_tag('SetActiveObjectLEDs', self._tag, self.Tag.SetActiveObjectLEDs, self._tags_by_value)
    return self._data

  @SetActiveObjectLEDs.setter
  def SetActiveObjectLEDs(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetActiveObjectLEDs', value, Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs)
    self._tag = self.Tag.SetActiveObjectLEDs

  @property
  def SetAllActiveObjectLEDs(self):
    "Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs SetAllActiveObjectLEDs union property."
    msgbuffers.safety_check_tag('SetAllActiveObjectLEDs', self._tag, self.Tag.SetAllActiveObjectLEDs, self._tags_by_value)
    return self._data

  @SetAllActiveObjectLEDs.setter
  def SetAllActiveObjectLEDs(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetAllActiveObjectLEDs', value, Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs)
    self._tag = self.Tag.SetAllActiveObjectLEDs

  @property
  def SetBackpackLEDs(self):
    "Anki.Cozmo.ExternalInterface.SetBackpackLEDs SetBackpackLEDs union property."
    msgbuffers.safety_check_tag('SetBackpackLEDs', self._tag, self.Tag.SetBackpackLEDs, self._tags_by_value)
    return self._data

  @SetBackpackLEDs.setter
  def SetBackpackLEDs(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetBackpackLEDs', value, Anki.Cozmo.ExternalInterface.SetBackpackLEDs)
    self._tag = self.Tag.SetBackpackLEDs

  @property
  def EnableLightStates(self):
    "Anki.Cozmo.ExternalInterface.EnableLightStates EnableLightStates union property."
    msgbuffers.safety_check_tag('EnableLightStates', self._tag, self.Tag.EnableLightStates, self._tags_by_value)
    return self._data

  @EnableLightStates.setter
  def EnableLightStates(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableLightStates', value, Anki.Cozmo.ExternalInterface.EnableLightStates)
    self._tag = self.Tag.EnableLightStates

  @property
  def EnableCubeSleep(self):
    "Anki.Cozmo.ExternalInterface.EnableCubeSleep EnableCubeSleep union property."
    msgbuffers.safety_check_tag('EnableCubeSleep', self._tag, self.Tag.EnableCubeSleep, self._tags_by_value)
    return self._data

  @EnableCubeSleep.setter
  def EnableCubeSleep(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableCubeSleep', value, Anki.Cozmo.ExternalInterface.EnableCubeSleep)
    self._tag = self.Tag.EnableCubeSleep

  @property
  def EnableCubeLightsStateTransitionMessages(self):
    "Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages EnableCubeLightsStateTransitionMessages union property."
    msgbuffers.safety_check_tag('EnableCubeLightsStateTransitionMessages', self._tag, self.Tag.EnableCubeLightsStateTransitionMessages, self._tags_by_value)
    return self._data

  @EnableCubeLightsStateTransitionMessages.setter
  def EnableCubeLightsStateTransitionMessages(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableCubeLightsStateTransitionMessages', value, Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages)
    self._tag = self.Tag.EnableCubeLightsStateTransitionMessages

  @property
  def FlashCurrentLightsState(self):
    "Anki.Cozmo.ExternalInterface.FlashCurrentLightsState FlashCurrentLightsState union property."
    msgbuffers.safety_check_tag('FlashCurrentLightsState', self._tag, self.Tag.FlashCurrentLightsState, self._tags_by_value)
    return self._data

  @FlashCurrentLightsState.setter
  def FlashCurrentLightsState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.FlashCurrentLightsState', value, Anki.Cozmo.ExternalInterface.FlashCurrentLightsState)
    self._tag = self.Tag.FlashCurrentLightsState

  @property
  def TransitionToNextOnboardingState(self):
    "Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState TransitionToNextOnboardingState union property."
    msgbuffers.safety_check_tag('TransitionToNextOnboardingState', self._tag, self.Tag.TransitionToNextOnboardingState, self._tags_by_value)
    return self._data

  @TransitionToNextOnboardingState.setter
  def TransitionToNextOnboardingState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TransitionToNextOnboardingState', value, Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState)
    self._tag = self.Tag.TransitionToNextOnboardingState

  @property
  def MoodMessage(self):
    "Anki.Cozmo.ExternalInterface.MoodMessage MoodMessage union property."
    msgbuffers.safety_check_tag('MoodMessage', self._tag, self.Tag.MoodMessage, self._tags_by_value)
    return self._data

  @MoodMessage.setter
  def MoodMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.MoodMessage', value, Anki.Cozmo.ExternalInterface.MoodMessage)
    self._tag = self.Tag.MoodMessage

  @property
  def ProgressionMessage(self):
    "Anki.Cozmo.ExternalInterface.ProgressionMessage ProgressionMessage union property."
    msgbuffers.safety_check_tag('ProgressionMessage', self._tag, self.Tag.ProgressionMessage, self._tags_by_value)
    return self._data

  @ProgressionMessage.setter
  def ProgressionMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ProgressionMessage', value, Anki.Cozmo.ExternalInterface.ProgressionMessage)
    self._tag = self.Tag.ProgressionMessage

  @property
  def RequestSetUnlock(self):
    "Anki.Cozmo.ExternalInterface.RequestSetUnlock RequestSetUnlock union property."
    msgbuffers.safety_check_tag('RequestSetUnlock', self._tag, self.Tag.RequestSetUnlock, self._tags_by_value)
    return self._data

  @RequestSetUnlock.setter
  def RequestSetUnlock(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestSetUnlock', value, Anki.Cozmo.ExternalInterface.RequestSetUnlock)
    self._tag = self.Tag.RequestSetUnlock

  @property
  def RequestDeviceData(self):
    "Anki.Cozmo.ExternalInterface.RequestDeviceData RequestDeviceData union property."
    msgbuffers.safety_check_tag('RequestDeviceData', self._tag, self.Tag.RequestDeviceData, self._tags_by_value)
    return self._data

  @RequestDeviceData.setter
  def RequestDeviceData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RequestDeviceData', value, Anki.Cozmo.ExternalInterface.RequestDeviceData)
    self._tag = self.Tag.RequestDeviceData

  @property
  def SetDebugConsoleVarMessage(self):
    "Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage SetDebugConsoleVarMessage union property."
    msgbuffers.safety_check_tag('SetDebugConsoleVarMessage', self._tag, self.Tag.SetDebugConsoleVarMessage, self._tags_by_value)
    return self._data

  @SetDebugConsoleVarMessage.setter
  def SetDebugConsoleVarMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetDebugConsoleVarMessage', value, Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage)
    self._tag = self.Tag.SetDebugConsoleVarMessage

  @property
  def RunDebugConsoleFuncMessage(self):
    "Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage RunDebugConsoleFuncMessage union property."
    msgbuffers.safety_check_tag('RunDebugConsoleFuncMessage', self._tag, self.Tag.RunDebugConsoleFuncMessage, self._tags_by_value)
    return self._data

  @RunDebugConsoleFuncMessage.setter
  def RunDebugConsoleFuncMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.RunDebugConsoleFuncMessage', value, Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage)
    self._tag = self.Tag.RunDebugConsoleFuncMessage

  @property
  def GetDebugConsoleVarMessage(self):
    "Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage GetDebugConsoleVarMessage union property."
    msgbuffers.safety_check_tag('GetDebugConsoleVarMessage', self._tag, self.Tag.GetDebugConsoleVarMessage, self._tags_by_value)
    return self._data

  @GetDebugConsoleVarMessage.setter
  def GetDebugConsoleVarMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GetDebugConsoleVarMessage', value, Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage)
    self._tag = self.Tag.GetDebugConsoleVarMessage

  @property
  def GetAllDebugConsoleVarMessage(self):
    "Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage GetAllDebugConsoleVarMessage union property."
    msgbuffers.safety_check_tag('GetAllDebugConsoleVarMessage', self._tag, self.Tag.GetAllDebugConsoleVarMessage, self._tags_by_value)
    return self._data

  @GetAllDebugConsoleVarMessage.setter
  def GetAllDebugConsoleVarMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GetAllDebugConsoleVarMessage', value, Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage)
    self._tag = self.Tag.GetAllDebugConsoleVarMessage

  @property
  def GetJsonDasLogsMessage(self):
    "Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage GetJsonDasLogsMessage union property."
    msgbuffers.safety_check_tag('GetJsonDasLogsMessage', self._tag, self.Tag.GetJsonDasLogsMessage, self._tags_by_value)
    return self._data

  @GetJsonDasLogsMessage.setter
  def GetJsonDasLogsMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GetJsonDasLogsMessage', value, Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage)
    self._tag = self.Tag.GetJsonDasLogsMessage

  @property
  def SetEnableSOSLogging(self):
    "Anki.Cozmo.ExternalInterface.SetEnableSOSLogging SetEnableSOSLogging union property."
    msgbuffers.safety_check_tag('SetEnableSOSLogging', self._tag, self.Tag.SetEnableSOSLogging, self._tags_by_value)
    return self._data

  @SetEnableSOSLogging.setter
  def SetEnableSOSLogging(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetEnableSOSLogging', value, Anki.Cozmo.ExternalInterface.SetEnableSOSLogging)
    self._tag = self.Tag.SetEnableSOSLogging

  @property
  def EnableReactionaryBehaviors(self):
    "Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors EnableReactionaryBehaviors union property."
    msgbuffers.safety_check_tag('EnableReactionaryBehaviors', self._tag, self.Tag.EnableReactionaryBehaviors, self._tags_by_value)
    return self._data

  @EnableReactionaryBehaviors.setter
  def EnableReactionaryBehaviors(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableReactionaryBehaviors', value, Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors)
    self._tag = self.Tag.EnableReactionaryBehaviors

  @property
  def SetEnableSpeedChooser(self):
    "Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser SetEnableSpeedChooser union property."
    msgbuffers.safety_check_tag('SetEnableSpeedChooser', self._tag, self.Tag.SetEnableSpeedChooser, self._tags_by_value)
    return self._data

  @SetEnableSpeedChooser.setter
  def SetEnableSpeedChooser(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetEnableSpeedChooser', value, Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser)
    self._tag = self.Tag.SetEnableSpeedChooser

  @property
  def BlockPoolEnabledMessage(self):
    "Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage BlockPoolEnabledMessage union property."
    msgbuffers.safety_check_tag('BlockPoolEnabledMessage', self._tag, self.Tag.BlockPoolEnabledMessage, self._tags_by_value)
    return self._data

  @BlockPoolEnabledMessage.setter
  def BlockPoolEnabledMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.BlockPoolEnabledMessage', value, Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage)
    self._tag = self.Tag.BlockPoolEnabledMessage

  @property
  def BlockSelectedMessage(self):
    "Anki.Cozmo.ExternalInterface.BlockSelectedMessage BlockSelectedMessage union property."
    msgbuffers.safety_check_tag('BlockSelectedMessage', self._tag, self.Tag.BlockSelectedMessage, self._tags_by_value)
    return self._data

  @BlockSelectedMessage.setter
  def BlockSelectedMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.BlockSelectedMessage', value, Anki.Cozmo.ExternalInterface.BlockSelectedMessage)
    self._tag = self.Tag.BlockSelectedMessage

  @property
  def GetBlockPoolMessage(self):
    "Anki.Cozmo.ExternalInterface.GetBlockPoolMessage GetBlockPoolMessage union property."
    msgbuffers.safety_check_tag('GetBlockPoolMessage', self._tag, self.Tag.GetBlockPoolMessage, self._tags_by_value)
    return self._data

  @GetBlockPoolMessage.setter
  def GetBlockPoolMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.GetBlockPoolMessage', value, Anki.Cozmo.ExternalInterface.GetBlockPoolMessage)
    self._tag = self.Tag.GetBlockPoolMessage

  @property
  def SendAvailableObjects(self):
    "Anki.Cozmo.ExternalInterface.SendAvailableObjects SendAvailableObjects union property."
    msgbuffers.safety_check_tag('SendAvailableObjects', self._tag, self.Tag.SendAvailableObjects, self._tags_by_value)
    return self._data

  @SendAvailableObjects.setter
  def SendAvailableObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SendAvailableObjects', value, Anki.Cozmo.ExternalInterface.SendAvailableObjects)
    self._tag = self.Tag.SendAvailableObjects

  @property
  def BlockPoolResetMessage(self):
    "Anki.Cozmo.ExternalInterface.BlockPoolResetMessage BlockPoolResetMessage union property."
    msgbuffers.safety_check_tag('BlockPoolResetMessage', self._tag, self.Tag.BlockPoolResetMessage, self._tags_by_value)
    return self._data

  @BlockPoolResetMessage.setter
  def BlockPoolResetMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.BlockPoolResetMessage', value, Anki.Cozmo.ExternalInterface.BlockPoolResetMessage)
    self._tag = self.Tag.BlockPoolResetMessage

  @property
  def SaveCalibrationImage(self):
    "Anki.Cozmo.ExternalInterface.SaveCalibrationImage SaveCalibrationImage union property."
    msgbuffers.safety_check_tag('SaveCalibrationImage', self._tag, self.Tag.SaveCalibrationImage, self._tags_by_value)
    return self._data

  @SaveCalibrationImage.setter
  def SaveCalibrationImage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SaveCalibrationImage', value, Anki.Cozmo.ExternalInterface.SaveCalibrationImage)
    self._tag = self.Tag.SaveCalibrationImage

  @property
  def ClearCalibrationImages(self):
    "Anki.Cozmo.ExternalInterface.ClearCalibrationImages ClearCalibrationImages union property."
    msgbuffers.safety_check_tag('ClearCalibrationImages', self._tag, self.Tag.ClearCalibrationImages, self._tags_by_value)
    return self._data

  @ClearCalibrationImages.setter
  def ClearCalibrationImages(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ClearCalibrationImages', value, Anki.Cozmo.ExternalInterface.ClearCalibrationImages)
    self._tag = self.Tag.ClearCalibrationImages

  @property
  def ComputeCameraCalibration(self):
    "Anki.Cozmo.ExternalInterface.ComputeCameraCalibration ComputeCameraCalibration union property."
    msgbuffers.safety_check_tag('ComputeCameraCalibration', self._tag, self.Tag.ComputeCameraCalibration, self._tags_by_value)
    return self._data

  @ComputeCameraCalibration.setter
  def ComputeCameraCalibration(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ComputeCameraCalibration', value, Anki.Cozmo.ExternalInterface.ComputeCameraCalibration)
    self._tag = self.Tag.ComputeCameraCalibration

  @property
  def ContinueFreeplayFromIdle(self):
    "Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle ContinueFreeplayFromIdle union property."
    msgbuffers.safety_check_tag('ContinueFreeplayFromIdle', self._tag, self.Tag.ContinueFreeplayFromIdle, self._tags_by_value)
    return self._data

  @ContinueFreeplayFromIdle.setter
  def ContinueFreeplayFromIdle(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ContinueFreeplayFromIdle', value, Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle)
    self._tag = self.Tag.ContinueFreeplayFromIdle

  @property
  def EnableDroneMode(self):
    "Anki.Cozmo.ExternalInterface.EnableDroneMode EnableDroneMode union property."
    msgbuffers.safety_check_tag('EnableDroneMode', self._tag, self.Tag.EnableDroneMode, self._tags_by_value)
    return self._data

  @EnableDroneMode.setter
  def EnableDroneMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnableDroneMode', value, Anki.Cozmo.ExternalInterface.EnableDroneMode)
    self._tag = self.Tag.EnableDroneMode

  @property
  def EnterSdkMode(self):
    "Anki.Cozmo.ExternalInterface.EnterSdkMode EnterSdkMode union property."
    msgbuffers.safety_check_tag('EnterSdkMode', self._tag, self.Tag.EnterSdkMode, self._tags_by_value)
    return self._data

  @EnterSdkMode.setter
  def EnterSdkMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.EnterSdkMode', value, Anki.Cozmo.ExternalInterface.EnterSdkMode)
    self._tag = self.Tag.EnterSdkMode

  @property
  def ExitSdkMode(self):
    "Anki.Cozmo.ExternalInterface.ExitSdkMode ExitSdkMode union property."
    msgbuffers.safety_check_tag('ExitSdkMode', self._tag, self.Tag.ExitSdkMode, self._tags_by_value)
    return self._data

  @ExitSdkMode.setter
  def ExitSdkMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.ExitSdkMode', value, Anki.Cozmo.ExternalInterface.ExitSdkMode)
    self._tag = self.Tag.ExitSdkMode

  @property
  def SetStopRobotOnSdkDisconnect(self):
    "Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect SetStopRobotOnSdkDisconnect union property."
    msgbuffers.safety_check_tag('SetStopRobotOnSdkDisconnect', self._tag, self.Tag.SetStopRobotOnSdkDisconnect, self._tags_by_value)
    return self._data

  @SetStopRobotOnSdkDisconnect.setter
  def SetStopRobotOnSdkDisconnect(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetStopRobotOnSdkDisconnect', value, Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect)
    self._tag = self.Tag.SetStopRobotOnSdkDisconnect

  @property
  def StopRobotForSdk(self):
    "Anki.Cozmo.ExternalInterface.StopRobotForSdk StopRobotForSdk union property."
    msgbuffers.safety_check_tag('StopRobotForSdk', self._tag, self.Tag.StopRobotForSdk, self._tags_by_value)
    return self._data

  @StopRobotForSdk.setter
  def StopRobotForSdk(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.StopRobotForSdk', value, Anki.Cozmo.ExternalInterface.StopRobotForSdk)
    self._tag = self.Tag.StopRobotForSdk

  @property
  def TransferFile(self):
    "Anki.Cozmo.ExternalInterface.TransferFile TransferFile union property."
    msgbuffers.safety_check_tag('TransferFile', self._tag, self.Tag.TransferFile, self._tags_by_value)
    return self._data

  @TransferFile.setter
  def TransferFile(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.TransferFile', value, Anki.Cozmo.ExternalInterface.TransferFile)
    self._tag = self.Tag.TransferFile

  @property
  def NVStorageEraseEntry(self):
    "Anki.Cozmo.ExternalInterface.NVStorageEraseEntry NVStorageEraseEntry union property."
    msgbuffers.safety_check_tag('NVStorageEraseEntry', self._tag, self.Tag.NVStorageEraseEntry, self._tags_by_value)
    return self._data

  @NVStorageEraseEntry.setter
  def NVStorageEraseEntry(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.NVStorageEraseEntry', value, Anki.Cozmo.ExternalInterface.NVStorageEraseEntry)
    self._tag = self.Tag.NVStorageEraseEntry

  @property
  def NVStorageWipeAll(self):
    "Anki.Cozmo.ExternalInterface.NVStorageWipeAll NVStorageWipeAll union property."
    msgbuffers.safety_check_tag('NVStorageWipeAll', self._tag, self.Tag.NVStorageWipeAll, self._tags_by_value)
    return self._data

  @NVStorageWipeAll.setter
  def NVStorageWipeAll(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.NVStorageWipeAll', value, Anki.Cozmo.ExternalInterface.NVStorageWipeAll)
    self._tag = self.Tag.NVStorageWipeAll

  @property
  def NVStorageWriteEntry(self):
    "Anki.Cozmo.ExternalInterface.NVStorageWriteEntry NVStorageWriteEntry union property."
    msgbuffers.safety_check_tag('NVStorageWriteEntry', self._tag, self.Tag.NVStorageWriteEntry, self._tags_by_value)
    return self._data

  @NVStorageWriteEntry.setter
  def NVStorageWriteEntry(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.NVStorageWriteEntry', value, Anki.Cozmo.ExternalInterface.NVStorageWriteEntry)
    self._tag = self.Tag.NVStorageWriteEntry

  @property
  def NVStorageClearPartialPendingWriteEntry(self):
    "Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry NVStorageClearPartialPendingWriteEntry union property."
    msgbuffers.safety_check_tag('NVStorageClearPartialPendingWriteEntry', self._tag, self.Tag.NVStorageClearPartialPendingWriteEntry, self._tags_by_value)
    return self._data

  @NVStorageClearPartialPendingWriteEntry.setter
  def NVStorageClearPartialPendingWriteEntry(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.NVStorageClearPartialPendingWriteEntry', value, Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry)
    self._tag = self.Tag.NVStorageClearPartialPendingWriteEntry

  @property
  def NVStorageReadEntry(self):
    "Anki.Cozmo.ExternalInterface.NVStorageReadEntry NVStorageReadEntry union property."
    msgbuffers.safety_check_tag('NVStorageReadEntry', self._tag, self.Tag.NVStorageReadEntry, self._tags_by_value)
    return self._data

  @NVStorageReadEntry.setter
  def NVStorageReadEntry(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.NVStorageReadEntry', value, Anki.Cozmo.ExternalInterface.NVStorageReadEntry)
    self._tag = self.Tag.NVStorageReadEntry

  @property
  def SetCameraSettings(self):
    "Anki.Cozmo.ExternalInterface.SetCameraSettings SetCameraSettings union property."
    msgbuffers.safety_check_tag('SetCameraSettings', self._tag, self.Tag.SetCameraSettings, self._tags_by_value)
    return self._data

  @SetCameraSettings.setter
  def SetCameraSettings(self, value):
    self._data = msgbuffers.validate_object(
      'MessageGameToEngine.SetCameraSettings', value, Anki.Cozmo.ExternalInterface.SetCameraSettings)
    self._tag = self.Tag.SetCameraSettings

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MessageGameToEngine from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MessageGameToEngine.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MessageGameToEngine from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MessageGameToEngine attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MessageGameToEngine, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MessageGameToEngine.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 195:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 195:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 195:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    UiDeviceConnectionWrongVersion=0,
    PostAudioEvent=1,
    StopAllAudioEvents=2,
    PostAudioGameState=3,
    PostAudioSwitchState=4,
    PostAudioParameter=5,
    PostAudioMusicState=6,
    AlignWithObject=7,
    CalibrateMotors=8,
    DisplayFaceImage=9,
    DisplayProceduralFace=10,
    DriveOffChargerContacts=11,
    DriveStraight=12,
    EnrollNamedFace=13,
    FlipBlock=14,
    GotoObject=15,
    GotoPose=16,
    MountCharger=17,
    PanAndTilt=18,
    PickupObject=19,
    PlaceObjectOnGround=20,
    PlaceObjectOnGroundHere=21,
    PlaceOnObject=22,
    PlaceRelObject=23,
    PlayAnimation=24,
    PlayAnimationTrigger=25,
    PlayAnimation_DEV=26,
    PopAWheelie=27,
    FacePlant=28,
    ReadToolCode=29,
    RealignWithObject=30,
    RollObject=31,
    SayText=32,
    SayTextWithIntent=33,
    SearchForNearbyObject=34,
    SetHeadAngle=35,
    SetLiftHeight=36,
    TrackToFace=37,
    TrackToObject=38,
    TrackToPet=39,
    TraverseObject=40,
    TurnInPlace=41,
    TurnInPlaceAtSpeed=42,
    TurnTowardsFace=43,
    TurnTowardsImagePoint=44,
    TurnTowardsLastFacePose=45,
    TurnTowardsObject=46,
    TurnTowardsPose=47,
    VisuallyVerifyFace=48,
    VisuallyVerifyObject=49,
    VisuallyVerifyNoObjectAtPose=50,
    Wait=51,
    WaitForImages=52,
    AdvertisementRegistrationMsg=53,
    AdvertisementMsg=54,
    Ping=55,
    DenyGameStart=56,
    SetVizOrigin=57,
    ImageChunk=58,
    ImageImuData=59,
    CameraCalibration=60,
    IMURequest=61,
    StartControllerTestMode=62,
    RawPWM=63,
    UiDeviceConnectionSuccess=64,
    ConnectToRobot=65,
    ConnectToUiDevice=66,
    DisconnectFromUiDevice=67,
    StartEngine=68,
    ReliableTransportRunMode=69,
    RequestFeatureToggles=70,
    SetFeatureToggle=71,
    StartIdleTimeout=72,
    CancelIdleTimeout=73,
    SetGameBeingPaused=74,
    UpdateFirmware=75,
    ResetFirmware=76,
    DriveWheels=77,
    DriveArc=78,
    MoveHead=79,
    MoveLift=80,
    EnableLiftPower=81,
    EnableCliffSensor=82,
    EnableBlockTapFilter=83,
    GetBlockTapFilterStatus=84,
    StopAllMotors=85,
    ControllerGains=86,
    RollActionParams=87,
    SetMotionModelParams=88,
    SetRobotVolume=89,
    SetRobotAudioOutputSource=90,
    ForceDelocalizeRobot=91,
    RestoreRobotFromBackup=92,
    RequestRobotRestoreData=93,
    WipeRobotGameData=94,
    RequestUnlockDataFromBackup=95,
    CancelAction=96,
    CancelActionByIdTag=97,
    QueueSingleAction=98,
    QueueCompoundAction=99,
    ImageRequest=100,
    SetRobotImageSendMode=101,
    SaveImages=102,
    SaveRobotState=103,
    EnableDisplay=104,
    ExecuteTestPlan=105,
    PlannerRunMode=106,
    SelectNextObject=107,
    SetRobotCarryingObject=108,
    CreateFixedCustomObject=109,
    DefineCustomObject=110,
    ClearAllBlocks=111,
    ClearAllObjects=112,
    DeleteAllObjects=113,
    DeleteAllCustomObjects=114,
    SetObjectAdditionAndDeletion=115,
    VisionWhileMoving=116,
    SetFaceEnrollmentPose=117,
    EraseEnrolledFaceByID=118,
    EraseAllEnrolledFaces=119,
    EnableVisionMode=120,
    UpdateEnrolledFaceByID=121,
    VisionRunMode=122,
    SaveFaceAlbumToFile=123,
    LoadFaceAlbumFromFile=124,
    SetMemoryMapRenderEnabled=125,
    ActivateBehaviorChooser=126,
    ExecuteBehavior=127,
    ExecuteBehaviorByExecutableType=128,
    ExecuteBehaviorByName=129,
    BehaviorManagerMessage=130,
    AbortPath=131,
    AbortAll=132,
    StartTestMode=133,
    RequestEnabledBehaviorList=134,
    RequestEnableReactionaryBehavior=135,
    SetDefaultHeadAndLiftState=136,
    RequestAvailableObjects=137,
    DrawPoseMarker=138,
    ErasePoseMarker=139,
    VisualizeQuad=140,
    EraseQuad=141,
    ReplayLastAnimation=142,
    SetIdleAnimation=143,
    PushIdleAnimation=144,
    PopIdleAnimation=145,
    ReadFaceAnimationDir=146,
    ReadAnimationFile=147,
    RequestAvailableAnimations=148,
    RequestAvailableAnimationGroups=149,
    SetLiveIdleAnimationParameters=150,
    PushDrivingAnimations=151,
    PopDrivingAnimations=152,
    SetHeadlight=153,
    SetActiveObjectLEDs=154,
    SetAllActiveObjectLEDs=155,
    SetBackpackLEDs=156,
    EnableLightStates=157,
    EnableCubeSleep=158,
    EnableCubeLightsStateTransitionMessages=159,
    FlashCurrentLightsState=160,
    TransitionToNextOnboardingState=161,
    MoodMessage=162,
    ProgressionMessage=163,
    RequestSetUnlock=164,
    RequestDeviceData=165,
    SetDebugConsoleVarMessage=166,
    RunDebugConsoleFuncMessage=167,
    GetDebugConsoleVarMessage=168,
    GetAllDebugConsoleVarMessage=169,
    GetJsonDasLogsMessage=170,
    SetEnableSOSLogging=171,
    EnableReactionaryBehaviors=172,
    SetEnableSpeedChooser=173,
    BlockPoolEnabledMessage=174,
    BlockSelectedMessage=175,
    GetBlockPoolMessage=176,
    SendAvailableObjects=177,
    BlockPoolResetMessage=178,
    SaveCalibrationImage=179,
    ClearCalibrationImages=180,
    ComputeCameraCalibration=181,
    ContinueFreeplayFromIdle=182,
    EnableDroneMode=183,
    EnterSdkMode=184,
    ExitSdkMode=185,
    SetStopRobotOnSdkDisconnect=186,
    StopRobotForSdk=187,
    TransferFile=188,
    NVStorageEraseEntry=189,
    NVStorageWipeAll=190,
    NVStorageWriteEntry=191,
    NVStorageClearPartialPendingWriteEntry=192,
    NVStorageReadEntry=193,
    SetCameraSettings=194,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'UiDeviceConnectionWrongVersion'
  _tags_by_value[1] = 'PostAudioEvent'
  _tags_by_value[2] = 'StopAllAudioEvents'
  _tags_by_value[3] = 'PostAudioGameState'
  _tags_by_value[4] = 'PostAudioSwitchState'
  _tags_by_value[5] = 'PostAudioParameter'
  _tags_by_value[6] = 'PostAudioMusicState'
  _tags_by_value[7] = 'AlignWithObject'
  _tags_by_value[8] = 'CalibrateMotors'
  _tags_by_value[9] = 'DisplayFaceImage'
  _tags_by_value[10] = 'DisplayProceduralFace'
  _tags_by_value[11] = 'DriveOffChargerContacts'
  _tags_by_value[12] = 'DriveStraight'
  _tags_by_value[13] = 'EnrollNamedFace'
  _tags_by_value[14] = 'FlipBlock'
  _tags_by_value[15] = 'GotoObject'
  _tags_by_value[16] = 'GotoPose'
  _tags_by_value[17] = 'MountCharger'
  _tags_by_value[18] = 'PanAndTilt'
  _tags_by_value[19] = 'PickupObject'
  _tags_by_value[20] = 'PlaceObjectOnGround'
  _tags_by_value[21] = 'PlaceObjectOnGroundHere'
  _tags_by_value[22] = 'PlaceOnObject'
  _tags_by_value[23] = 'PlaceRelObject'
  _tags_by_value[24] = 'PlayAnimation'
  _tags_by_value[25] = 'PlayAnimationTrigger'
  _tags_by_value[26] = 'PlayAnimation_DEV'
  _tags_by_value[27] = 'PopAWheelie'
  _tags_by_value[28] = 'FacePlant'
  _tags_by_value[29] = 'ReadToolCode'
  _tags_by_value[30] = 'RealignWithObject'
  _tags_by_value[31] = 'RollObject'
  _tags_by_value[32] = 'SayText'
  _tags_by_value[33] = 'SayTextWithIntent'
  _tags_by_value[34] = 'SearchForNearbyObject'
  _tags_by_value[35] = 'SetHeadAngle'
  _tags_by_value[36] = 'SetLiftHeight'
  _tags_by_value[37] = 'TrackToFace'
  _tags_by_value[38] = 'TrackToObject'
  _tags_by_value[39] = 'TrackToPet'
  _tags_by_value[40] = 'TraverseObject'
  _tags_by_value[41] = 'TurnInPlace'
  _tags_by_value[42] = 'TurnInPlaceAtSpeed'
  _tags_by_value[43] = 'TurnTowardsFace'
  _tags_by_value[44] = 'TurnTowardsImagePoint'
  _tags_by_value[45] = 'TurnTowardsLastFacePose'
  _tags_by_value[46] = 'TurnTowardsObject'
  _tags_by_value[47] = 'TurnTowardsPose'
  _tags_by_value[48] = 'VisuallyVerifyFace'
  _tags_by_value[49] = 'VisuallyVerifyObject'
  _tags_by_value[50] = 'VisuallyVerifyNoObjectAtPose'
  _tags_by_value[51] = 'Wait'
  _tags_by_value[52] = 'WaitForImages'
  _tags_by_value[53] = 'AdvertisementRegistrationMsg'
  _tags_by_value[54] = 'AdvertisementMsg'
  _tags_by_value[55] = 'Ping'
  _tags_by_value[56] = 'DenyGameStart'
  _tags_by_value[57] = 'SetVizOrigin'
  _tags_by_value[58] = 'ImageChunk'
  _tags_by_value[59] = 'ImageImuData'
  _tags_by_value[60] = 'CameraCalibration'
  _tags_by_value[61] = 'IMURequest'
  _tags_by_value[62] = 'StartControllerTestMode'
  _tags_by_value[63] = 'RawPWM'
  _tags_by_value[64] = 'UiDeviceConnectionSuccess'
  _tags_by_value[65] = 'ConnectToRobot'
  _tags_by_value[66] = 'ConnectToUiDevice'
  _tags_by_value[67] = 'DisconnectFromUiDevice'
  _tags_by_value[68] = 'StartEngine'
  _tags_by_value[69] = 'ReliableTransportRunMode'
  _tags_by_value[70] = 'RequestFeatureToggles'
  _tags_by_value[71] = 'SetFeatureToggle'
  _tags_by_value[72] = 'StartIdleTimeout'
  _tags_by_value[73] = 'CancelIdleTimeout'
  _tags_by_value[74] = 'SetGameBeingPaused'
  _tags_by_value[75] = 'UpdateFirmware'
  _tags_by_value[76] = 'ResetFirmware'
  _tags_by_value[77] = 'DriveWheels'
  _tags_by_value[78] = 'DriveArc'
  _tags_by_value[79] = 'MoveHead'
  _tags_by_value[80] = 'MoveLift'
  _tags_by_value[81] = 'EnableLiftPower'
  _tags_by_value[82] = 'EnableCliffSensor'
  _tags_by_value[83] = 'EnableBlockTapFilter'
  _tags_by_value[84] = 'GetBlockTapFilterStatus'
  _tags_by_value[85] = 'StopAllMotors'
  _tags_by_value[86] = 'ControllerGains'
  _tags_by_value[87] = 'RollActionParams'
  _tags_by_value[88] = 'SetMotionModelParams'
  _tags_by_value[89] = 'SetRobotVolume'
  _tags_by_value[90] = 'SetRobotAudioOutputSource'
  _tags_by_value[91] = 'ForceDelocalizeRobot'
  _tags_by_value[92] = 'RestoreRobotFromBackup'
  _tags_by_value[93] = 'RequestRobotRestoreData'
  _tags_by_value[94] = 'WipeRobotGameData'
  _tags_by_value[95] = 'RequestUnlockDataFromBackup'
  _tags_by_value[96] = 'CancelAction'
  _tags_by_value[97] = 'CancelActionByIdTag'
  _tags_by_value[98] = 'QueueSingleAction'
  _tags_by_value[99] = 'QueueCompoundAction'
  _tags_by_value[100] = 'ImageRequest'
  _tags_by_value[101] = 'SetRobotImageSendMode'
  _tags_by_value[102] = 'SaveImages'
  _tags_by_value[103] = 'SaveRobotState'
  _tags_by_value[104] = 'EnableDisplay'
  _tags_by_value[105] = 'ExecuteTestPlan'
  _tags_by_value[106] = 'PlannerRunMode'
  _tags_by_value[107] = 'SelectNextObject'
  _tags_by_value[108] = 'SetRobotCarryingObject'
  _tags_by_value[109] = 'CreateFixedCustomObject'
  _tags_by_value[110] = 'DefineCustomObject'
  _tags_by_value[111] = 'ClearAllBlocks'
  _tags_by_value[112] = 'ClearAllObjects'
  _tags_by_value[113] = 'DeleteAllObjects'
  _tags_by_value[114] = 'DeleteAllCustomObjects'
  _tags_by_value[115] = 'SetObjectAdditionAndDeletion'
  _tags_by_value[116] = 'VisionWhileMoving'
  _tags_by_value[117] = 'SetFaceEnrollmentPose'
  _tags_by_value[118] = 'EraseEnrolledFaceByID'
  _tags_by_value[119] = 'EraseAllEnrolledFaces'
  _tags_by_value[120] = 'EnableVisionMode'
  _tags_by_value[121] = 'UpdateEnrolledFaceByID'
  _tags_by_value[122] = 'VisionRunMode'
  _tags_by_value[123] = 'SaveFaceAlbumToFile'
  _tags_by_value[124] = 'LoadFaceAlbumFromFile'
  _tags_by_value[125] = 'SetMemoryMapRenderEnabled'
  _tags_by_value[126] = 'ActivateBehaviorChooser'
  _tags_by_value[127] = 'ExecuteBehavior'
  _tags_by_value[128] = 'ExecuteBehaviorByExecutableType'
  _tags_by_value[129] = 'ExecuteBehaviorByName'
  _tags_by_value[130] = 'BehaviorManagerMessage'
  _tags_by_value[131] = 'AbortPath'
  _tags_by_value[132] = 'AbortAll'
  _tags_by_value[133] = 'StartTestMode'
  _tags_by_value[134] = 'RequestEnabledBehaviorList'
  _tags_by_value[135] = 'RequestEnableReactionaryBehavior'
  _tags_by_value[136] = 'SetDefaultHeadAndLiftState'
  _tags_by_value[137] = 'RequestAvailableObjects'
  _tags_by_value[138] = 'DrawPoseMarker'
  _tags_by_value[139] = 'ErasePoseMarker'
  _tags_by_value[140] = 'VisualizeQuad'
  _tags_by_value[141] = 'EraseQuad'
  _tags_by_value[142] = 'ReplayLastAnimation'
  _tags_by_value[143] = 'SetIdleAnimation'
  _tags_by_value[144] = 'PushIdleAnimation'
  _tags_by_value[145] = 'PopIdleAnimation'
  _tags_by_value[146] = 'ReadFaceAnimationDir'
  _tags_by_value[147] = 'ReadAnimationFile'
  _tags_by_value[148] = 'RequestAvailableAnimations'
  _tags_by_value[149] = 'RequestAvailableAnimationGroups'
  _tags_by_value[150] = 'SetLiveIdleAnimationParameters'
  _tags_by_value[151] = 'PushDrivingAnimations'
  _tags_by_value[152] = 'PopDrivingAnimations'
  _tags_by_value[153] = 'SetHeadlight'
  _tags_by_value[154] = 'SetActiveObjectLEDs'
  _tags_by_value[155] = 'SetAllActiveObjectLEDs'
  _tags_by_value[156] = 'SetBackpackLEDs'
  _tags_by_value[157] = 'EnableLightStates'
  _tags_by_value[158] = 'EnableCubeSleep'
  _tags_by_value[159] = 'EnableCubeLightsStateTransitionMessages'
  _tags_by_value[160] = 'FlashCurrentLightsState'
  _tags_by_value[161] = 'TransitionToNextOnboardingState'
  _tags_by_value[162] = 'MoodMessage'
  _tags_by_value[163] = 'ProgressionMessage'
  _tags_by_value[164] = 'RequestSetUnlock'
  _tags_by_value[165] = 'RequestDeviceData'
  _tags_by_value[166] = 'SetDebugConsoleVarMessage'
  _tags_by_value[167] = 'RunDebugConsoleFuncMessage'
  _tags_by_value[168] = 'GetDebugConsoleVarMessage'
  _tags_by_value[169] = 'GetAllDebugConsoleVarMessage'
  _tags_by_value[170] = 'GetJsonDasLogsMessage'
  _tags_by_value[171] = 'SetEnableSOSLogging'
  _tags_by_value[172] = 'EnableReactionaryBehaviors'
  _tags_by_value[173] = 'SetEnableSpeedChooser'
  _tags_by_value[174] = 'BlockPoolEnabledMessage'
  _tags_by_value[175] = 'BlockSelectedMessage'
  _tags_by_value[176] = 'GetBlockPoolMessage'
  _tags_by_value[177] = 'SendAvailableObjects'
  _tags_by_value[178] = 'BlockPoolResetMessage'
  _tags_by_value[179] = 'SaveCalibrationImage'
  _tags_by_value[180] = 'ClearCalibrationImages'
  _tags_by_value[181] = 'ComputeCameraCalibration'
  _tags_by_value[182] = 'ContinueFreeplayFromIdle'
  _tags_by_value[183] = 'EnableDroneMode'
  _tags_by_value[184] = 'EnterSdkMode'
  _tags_by_value[185] = 'ExitSdkMode'
  _tags_by_value[186] = 'SetStopRobotOnSdkDisconnect'
  _tags_by_value[187] = 'StopRobotForSdk'
  _tags_by_value[188] = 'TransferFile'
  _tags_by_value[189] = 'NVStorageEraseEntry'
  _tags_by_value[190] = 'NVStorageWipeAll'
  _tags_by_value[191] = 'NVStorageWriteEntry'
  _tags_by_value[192] = 'NVStorageClearPartialPendingWriteEntry'
  _tags_by_value[193] = 'NVStorageReadEntry'
  _tags_by_value[194] = 'SetCameraSettings'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioEvent.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.Audio.StopAllAudioEvents.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioGameState.unpack_from)
  _tag_unpack_methods[4] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioSwitchState.unpack_from)
  _tag_unpack_methods[5] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioParameter.unpack_from)
  _tag_unpack_methods[6] = lambda reader: reader.read_object(Anki.Cozmo.Audio.PostAudioMusicState.unpack_from)
  _tag_unpack_methods[7] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AlignWithObject.unpack_from)
  _tag_unpack_methods[8] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CalibrateMotors.unpack_from)
  _tag_unpack_methods[9] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DisplayFaceImage.unpack_from)
  _tag_unpack_methods[10] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DisplayProceduralFace.unpack_from)
  _tag_unpack_methods[11] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveOffChargerContacts.unpack_from)
  _tag_unpack_methods[12] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveStraight.unpack_from)
  _tag_unpack_methods[13] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnrollNamedFace.unpack_from)
  _tag_unpack_methods[14] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FlipBlock.unpack_from)
  _tag_unpack_methods[15] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GotoObject.unpack_from)
  _tag_unpack_methods[16] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GotoPose.unpack_from)
  _tag_unpack_methods[17] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MountCharger.unpack_from)
  _tag_unpack_methods[18] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PanAndTilt.unpack_from)
  _tag_unpack_methods[19] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PickupObject.unpack_from)
  _tag_unpack_methods[20] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceObjectOnGround.unpack_from)
  _tag_unpack_methods[21] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere.unpack_from)
  _tag_unpack_methods[22] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceOnObject.unpack_from)
  _tag_unpack_methods[23] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlaceRelObject.unpack_from)
  _tag_unpack_methods[24] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlayAnimation.unpack_from)
  _tag_unpack_methods[25] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlayAnimationTrigger.unpack_from)
  _tag_unpack_methods[26] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlayAnimation_DEV.unpack_from)
  _tag_unpack_methods[27] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PopAWheelie.unpack_from)
  _tag_unpack_methods[28] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FacePlant.unpack_from)
  _tag_unpack_methods[29] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReadToolCode.unpack_from)
  _tag_unpack_methods[30] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RealignWithObject.unpack_from)
  _tag_unpack_methods[31] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RollObject.unpack_from)
  _tag_unpack_methods[32] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SayText.unpack_from)
  _tag_unpack_methods[33] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SayTextWithIntent.unpack_from)
  _tag_unpack_methods[34] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SearchForNearbyObject.unpack_from)
  _tag_unpack_methods[35] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetHeadAngle.unpack_from)
  _tag_unpack_methods[36] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetLiftHeight.unpack_from)
  _tag_unpack_methods[37] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToFace.unpack_from)
  _tag_unpack_methods[38] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToObject.unpack_from)
  _tag_unpack_methods[39] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TrackToPet.unpack_from)
  _tag_unpack_methods[40] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TraverseObject.unpack_from)
  _tag_unpack_methods[41] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnInPlace.unpack_from)
  _tag_unpack_methods[42] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed.unpack_from)
  _tag_unpack_methods[43] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsFace.unpack_from)
  _tag_unpack_methods[44] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint.unpack_from)
  _tag_unpack_methods[45] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose.unpack_from)
  _tag_unpack_methods[46] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsObject.unpack_from)
  _tag_unpack_methods[47] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TurnTowardsPose.unpack_from)
  _tag_unpack_methods[48] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyFace.unpack_from)
  _tag_unpack_methods[49] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyObject.unpack_from)
  _tag_unpack_methods[50] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose.unpack_from)
  _tag_unpack_methods[51] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.Wait.unpack_from)
  _tag_unpack_methods[52] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.WaitForImages.unpack_from)
  _tag_unpack_methods[53] = lambda reader: reader.read_object(Anki.Cozmo.AdvertisementRegistrationMsg.unpack_from)
  _tag_unpack_methods[54] = lambda reader: reader.read_object(Anki.Cozmo.AdvertisementMsg.unpack_from)
  _tag_unpack_methods[55] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.Ping.unpack_from)
  _tag_unpack_methods[56] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DenyGameStart.unpack_from)
  _tag_unpack_methods[57] = lambda reader: reader.read_object(Anki.Cozmo.SetVizOrigin.unpack_from)
  _tag_unpack_methods[58] = lambda reader: reader.read_object(Anki.Cozmo.ImageChunk.unpack_from)
  _tag_unpack_methods[59] = lambda reader: reader.read_object(Anki.Cozmo.ImageImuData.unpack_from)
  _tag_unpack_methods[60] = lambda reader: reader.read_object(Anki.Cozmo.CameraCalibration.unpack_from)
  _tag_unpack_methods[61] = lambda reader: reader.read_object(Anki.Cozmo.IMURequest.unpack_from)
  _tag_unpack_methods[62] = lambda reader: reader.read_object(Anki.Cozmo.StartControllerTestMode.unpack_from)
  _tag_unpack_methods[63] = lambda reader: reader.read_object(Anki.Cozmo.RawPWM.unpack_from)
  _tag_unpack_methods[64] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess.unpack_from)
  _tag_unpack_methods[65] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ConnectToRobot.unpack_from)
  _tag_unpack_methods[66] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ConnectToUiDevice.unpack_from)
  _tag_unpack_methods[67] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice.unpack_from)
  _tag_unpack_methods[68] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.StartEngine.unpack_from)
  _tag_unpack_methods[69] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReliableTransportRunMode.unpack_from)
  _tag_unpack_methods[70] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestFeatureToggles.unpack_from)
  _tag_unpack_methods[71] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetFeatureToggle.unpack_from)
  _tag_unpack_methods[72] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.StartIdleTimeout.unpack_from)
  _tag_unpack_methods[73] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CancelIdleTimeout.unpack_from)
  _tag_unpack_methods[74] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetGameBeingPaused.unpack_from)
  _tag_unpack_methods[75] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UpdateFirmware.unpack_from)
  _tag_unpack_methods[76] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ResetFirmware.unpack_from)
  _tag_unpack_methods[77] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveWheels.unpack_from)
  _tag_unpack_methods[78] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DriveArc.unpack_from)
  _tag_unpack_methods[79] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MoveHead.unpack_from)
  _tag_unpack_methods[80] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MoveLift.unpack_from)
  _tag_unpack_methods[81] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableLiftPower.unpack_from)
  _tag_unpack_methods[82] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableCliffSensor.unpack_from)
  _tag_unpack_methods[83] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableBlockTapFilter.unpack_from)
  _tag_unpack_methods[84] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus.unpack_from)
  _tag_unpack_methods[85] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.StopAllMotors.unpack_from)
  _tag_unpack_methods[86] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ControllerGains.unpack_from)
  _tag_unpack_methods[87] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RollActionParams.unpack_from)
  _tag_unpack_methods[88] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetMotionModelParams.unpack_from)
  _tag_unpack_methods[89] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetRobotVolume.unpack_from)
  _tag_unpack_methods[90] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource.unpack_from)
  _tag_unpack_methods[91] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot.unpack_from)
  _tag_unpack_methods[92] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup.unpack_from)
  _tag_unpack_methods[93] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestRobotRestoreData.unpack_from)
  _tag_unpack_methods[94] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.WipeRobotGameData.unpack_from)
  _tag_unpack_methods[95] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup.unpack_from)
  _tag_unpack_methods[96] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CancelAction.unpack_from)
  _tag_unpack_methods[97] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CancelActionByIdTag.unpack_from)
  _tag_unpack_methods[98] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.QueueSingleAction.unpack_from)
  _tag_unpack_methods[99] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.QueueCompoundAction.unpack_from)
  _tag_unpack_methods[100] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ImageRequest.unpack_from)
  _tag_unpack_methods[101] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetRobotImageSendMode.unpack_from)
  _tag_unpack_methods[102] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SaveImages.unpack_from)
  _tag_unpack_methods[103] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SaveRobotState.unpack_from)
  _tag_unpack_methods[104] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableDisplay.unpack_from)
  _tag_unpack_methods[105] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ExecuteTestPlan.unpack_from)
  _tag_unpack_methods[106] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PlannerRunMode.unpack_from)
  _tag_unpack_methods[107] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SelectNextObject.unpack_from)
  _tag_unpack_methods[108] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetRobotCarryingObject.unpack_from)
  _tag_unpack_methods[109] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.CreateFixedCustomObject.unpack_from)
  _tag_unpack_methods[110] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DefineCustomObject.unpack_from)
  _tag_unpack_methods[111] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ClearAllBlocks.unpack_from)
  _tag_unpack_methods[112] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ClearAllObjects.unpack_from)
  _tag_unpack_methods[113] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DeleteAllObjects.unpack_from)
  _tag_unpack_methods[114] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects.unpack_from)
  _tag_unpack_methods[115] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion.unpack_from)
  _tag_unpack_methods[116] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisionWhileMoving.unpack_from)
  _tag_unpack_methods[117] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose.unpack_from)
  _tag_unpack_methods[118] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID.unpack_from)
  _tag_unpack_methods[119] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces.unpack_from)
  _tag_unpack_methods[120] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableVisionMode.unpack_from)
  _tag_unpack_methods[121] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID.unpack_from)
  _tag_unpack_methods[122] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisionRunMode.unpack_from)
  _tag_unpack_methods[123] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile.unpack_from)
  _tag_unpack_methods[124] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile.unpack_from)
  _tag_unpack_methods[125] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled.unpack_from)
  _tag_unpack_methods[126] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser.unpack_from)
  _tag_unpack_methods[127] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ExecuteBehavior.unpack_from)
  _tag_unpack_methods[128] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType.unpack_from)
  _tag_unpack_methods[129] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName.unpack_from)
  _tag_unpack_methods[130] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BehaviorManagerMessage.unpack_from)
  _tag_unpack_methods[131] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AbortPath.unpack_from)
  _tag_unpack_methods[132] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.AbortAll.unpack_from)
  _tag_unpack_methods[133] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.StartTestMode.unpack_from)
  _tag_unpack_methods[134] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList.unpack_from)
  _tag_unpack_methods[135] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior.unpack_from)
  _tag_unpack_methods[136] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState.unpack_from)
  _tag_unpack_methods[137] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestAvailableObjects.unpack_from)
  _tag_unpack_methods[138] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.DrawPoseMarker.unpack_from)
  _tag_unpack_methods[139] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ErasePoseMarker.unpack_from)
  _tag_unpack_methods[140] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.VisualizeQuad.unpack_from)
  _tag_unpack_methods[141] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EraseQuad.unpack_from)
  _tag_unpack_methods[142] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReplayLastAnimation.unpack_from)
  _tag_unpack_methods[143] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetIdleAnimation.unpack_from)
  _tag_unpack_methods[144] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PushIdleAnimation.unpack_from)
  _tag_unpack_methods[145] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PopIdleAnimation.unpack_from)
  _tag_unpack_methods[146] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir.unpack_from)
  _tag_unpack_methods[147] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ReadAnimationFile.unpack_from)
  _tag_unpack_methods[148] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestAvailableAnimations.unpack_from)
  _tag_unpack_methods[149] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups.unpack_from)
  _tag_unpack_methods[150] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters.unpack_from)
  _tag_unpack_methods[151] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PushDrivingAnimations.unpack_from)
  _tag_unpack_methods[152] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.PopDrivingAnimations.unpack_from)
  _tag_unpack_methods[153] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetHeadlight.unpack_from)
  _tag_unpack_methods[154] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs.unpack_from)
  _tag_unpack_methods[155] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs.unpack_from)
  _tag_unpack_methods[156] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetBackpackLEDs.unpack_from)
  _tag_unpack_methods[157] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableLightStates.unpack_from)
  _tag_unpack_methods[158] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableCubeSleep.unpack_from)
  _tag_unpack_methods[159] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages.unpack_from)
  _tag_unpack_methods[160] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.FlashCurrentLightsState.unpack_from)
  _tag_unpack_methods[161] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState.unpack_from)
  _tag_unpack_methods[162] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.MoodMessage.unpack_from)
  _tag_unpack_methods[163] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ProgressionMessage.unpack_from)
  _tag_unpack_methods[164] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestSetUnlock.unpack_from)
  _tag_unpack_methods[165] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RequestDeviceData.unpack_from)
  _tag_unpack_methods[166] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage.unpack_from)
  _tag_unpack_methods[167] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage.unpack_from)
  _tag_unpack_methods[168] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage.unpack_from)
  _tag_unpack_methods[169] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage.unpack_from)
  _tag_unpack_methods[170] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage.unpack_from)
  _tag_unpack_methods[171] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetEnableSOSLogging.unpack_from)
  _tag_unpack_methods[172] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors.unpack_from)
  _tag_unpack_methods[173] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser.unpack_from)
  _tag_unpack_methods[174] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage.unpack_from)
  _tag_unpack_methods[175] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockSelectedMessage.unpack_from)
  _tag_unpack_methods[176] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.GetBlockPoolMessage.unpack_from)
  _tag_unpack_methods[177] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SendAvailableObjects.unpack_from)
  _tag_unpack_methods[178] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.BlockPoolResetMessage.unpack_from)
  _tag_unpack_methods[179] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SaveCalibrationImage.unpack_from)
  _tag_unpack_methods[180] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ClearCalibrationImages.unpack_from)
  _tag_unpack_methods[181] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ComputeCameraCalibration.unpack_from)
  _tag_unpack_methods[182] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle.unpack_from)
  _tag_unpack_methods[183] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnableDroneMode.unpack_from)
  _tag_unpack_methods[184] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.EnterSdkMode.unpack_from)
  _tag_unpack_methods[185] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.ExitSdkMode.unpack_from)
  _tag_unpack_methods[186] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect.unpack_from)
  _tag_unpack_methods[187] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.StopRobotForSdk.unpack_from)
  _tag_unpack_methods[188] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.TransferFile.unpack_from)
  _tag_unpack_methods[189] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageEraseEntry.unpack_from)
  _tag_unpack_methods[190] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageWipeAll.unpack_from)
  _tag_unpack_methods[191] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageWriteEntry.unpack_from)
  _tag_unpack_methods[192] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry.unpack_from)
  _tag_unpack_methods[193] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.NVStorageReadEntry.unpack_from)
  _tag_unpack_methods[194] = lambda reader: reader.read_object(Anki.Cozmo.ExternalInterface.SetCameraSettings.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[4] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[5] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[6] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[7] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[8] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[9] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[10] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[11] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[12] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[13] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[14] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[15] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[16] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[17] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[18] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[19] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[20] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[21] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[22] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[23] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[24] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[25] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[26] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[27] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[28] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[29] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[30] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[31] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[32] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[33] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[34] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[35] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[36] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[37] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[38] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[39] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[40] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[41] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[42] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[43] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[44] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[45] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[46] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[47] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[48] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[49] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[50] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[51] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[52] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[53] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[54] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[55] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[56] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[57] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[58] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[59] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[60] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[61] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[62] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[63] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[64] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[65] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[66] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[67] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[68] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[69] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[70] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[71] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[72] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[73] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[74] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[75] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[76] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[77] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[78] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[79] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[80] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[81] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[82] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[83] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[84] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[85] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[86] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[87] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[88] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[89] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[90] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[91] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[92] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[93] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[94] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[95] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[96] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[97] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[98] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[99] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[100] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[101] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[102] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[103] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[104] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[105] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[106] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[107] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[108] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[109] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[110] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[111] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[112] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[113] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[114] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[115] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[116] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[117] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[118] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[119] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[120] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[121] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[122] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[123] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[124] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[125] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[126] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[127] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[128] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[129] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[130] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[131] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[132] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[133] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[134] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[135] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[136] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[137] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[138] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[139] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[140] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[141] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[142] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[143] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[144] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[145] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[146] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[147] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[148] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[149] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[150] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[151] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[152] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[153] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[154] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[155] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[156] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[157] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[158] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[159] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[160] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[161] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[162] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[163] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[164] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[165] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[166] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[167] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[168] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[169] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[170] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[171] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[172] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[173] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[174] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[175] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[176] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[177] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[178] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[179] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[180] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[181] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[182] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[183] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[184] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[185] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[186] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[187] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[188] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[189] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[190] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[191] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[192] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[193] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[194] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[4] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[5] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[6] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[7] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[8] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[9] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[10] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[11] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[12] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[13] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[14] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[15] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[16] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[17] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[18] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[19] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[20] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[21] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[22] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[23] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[24] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[25] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[26] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[27] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[28] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[29] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[30] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[31] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[32] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[33] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[34] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[35] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[36] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[37] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[38] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[39] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[40] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[41] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[42] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[43] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[44] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[45] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[46] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[47] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[48] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[49] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[50] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[51] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[52] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[53] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[54] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[55] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[56] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[57] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[58] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[59] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[60] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[61] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[62] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[63] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[64] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[65] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[66] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[67] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[68] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[69] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[70] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[71] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[72] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[73] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[74] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[75] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[76] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[77] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[78] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[79] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[80] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[81] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[82] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[83] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[84] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[85] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[86] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[87] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[88] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[89] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[90] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[91] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[92] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[93] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[94] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[95] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[96] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[97] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[98] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[99] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[100] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[101] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[102] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[103] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[104] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[105] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[106] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[107] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[108] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[109] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[110] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[111] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[112] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[113] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[114] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[115] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[116] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[117] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[118] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[119] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[120] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[121] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[122] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[123] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[124] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[125] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[126] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[127] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[128] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[129] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[130] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[131] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[132] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[133] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[134] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[135] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[136] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[137] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[138] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[139] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[140] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[141] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[142] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[143] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[144] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[145] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[146] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[147] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[148] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[149] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[150] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[151] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[152] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[153] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[154] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[155] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[156] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[157] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[158] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[159] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[160] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[161] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[162] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[163] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[164] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[165] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[166] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[167] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[168] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[169] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[170] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[171] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[172] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[173] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[174] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[175] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[176] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[177] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[178] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[179] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[180] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[181] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[182] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[183] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[184] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[185] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[186] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[187] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[188] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[189] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[190] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[191] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[192] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[193] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[194] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.ExternalInterface.UiDeviceConnectionWrongVersion
  _type_by_tag_value[1] = lambda : Anki.Cozmo.Audio.PostAudioEvent
  _type_by_tag_value[2] = lambda : Anki.Cozmo.Audio.StopAllAudioEvents
  _type_by_tag_value[3] = lambda : Anki.Cozmo.Audio.PostAudioGameState
  _type_by_tag_value[4] = lambda : Anki.Cozmo.Audio.PostAudioSwitchState
  _type_by_tag_value[5] = lambda : Anki.Cozmo.Audio.PostAudioParameter
  _type_by_tag_value[6] = lambda : Anki.Cozmo.Audio.PostAudioMusicState
  _type_by_tag_value[7] = lambda : Anki.Cozmo.ExternalInterface.AlignWithObject
  _type_by_tag_value[8] = lambda : Anki.Cozmo.ExternalInterface.CalibrateMotors
  _type_by_tag_value[9] = lambda : Anki.Cozmo.ExternalInterface.DisplayFaceImage
  _type_by_tag_value[10] = lambda : Anki.Cozmo.ExternalInterface.DisplayProceduralFace
  _type_by_tag_value[11] = lambda : Anki.Cozmo.ExternalInterface.DriveOffChargerContacts
  _type_by_tag_value[12] = lambda : Anki.Cozmo.ExternalInterface.DriveStraight
  _type_by_tag_value[13] = lambda : Anki.Cozmo.ExternalInterface.EnrollNamedFace
  _type_by_tag_value[14] = lambda : Anki.Cozmo.ExternalInterface.FlipBlock
  _type_by_tag_value[15] = lambda : Anki.Cozmo.ExternalInterface.GotoObject
  _type_by_tag_value[16] = lambda : Anki.Cozmo.ExternalInterface.GotoPose
  _type_by_tag_value[17] = lambda : Anki.Cozmo.ExternalInterface.MountCharger
  _type_by_tag_value[18] = lambda : Anki.Cozmo.ExternalInterface.PanAndTilt
  _type_by_tag_value[19] = lambda : Anki.Cozmo.ExternalInterface.PickupObject
  _type_by_tag_value[20] = lambda : Anki.Cozmo.ExternalInterface.PlaceObjectOnGround
  _type_by_tag_value[21] = lambda : Anki.Cozmo.ExternalInterface.PlaceObjectOnGroundHere
  _type_by_tag_value[22] = lambda : Anki.Cozmo.ExternalInterface.PlaceOnObject
  _type_by_tag_value[23] = lambda : Anki.Cozmo.ExternalInterface.PlaceRelObject
  _type_by_tag_value[24] = lambda : Anki.Cozmo.ExternalInterface.PlayAnimation
  _type_by_tag_value[25] = lambda : Anki.Cozmo.ExternalInterface.PlayAnimationTrigger
  _type_by_tag_value[26] = lambda : Anki.Cozmo.ExternalInterface.PlayAnimation_DEV
  _type_by_tag_value[27] = lambda : Anki.Cozmo.ExternalInterface.PopAWheelie
  _type_by_tag_value[28] = lambda : Anki.Cozmo.ExternalInterface.FacePlant
  _type_by_tag_value[29] = lambda : Anki.Cozmo.ExternalInterface.ReadToolCode
  _type_by_tag_value[30] = lambda : Anki.Cozmo.ExternalInterface.RealignWithObject
  _type_by_tag_value[31] = lambda : Anki.Cozmo.ExternalInterface.RollObject
  _type_by_tag_value[32] = lambda : Anki.Cozmo.ExternalInterface.SayText
  _type_by_tag_value[33] = lambda : Anki.Cozmo.ExternalInterface.SayTextWithIntent
  _type_by_tag_value[34] = lambda : Anki.Cozmo.ExternalInterface.SearchForNearbyObject
  _type_by_tag_value[35] = lambda : Anki.Cozmo.ExternalInterface.SetHeadAngle
  _type_by_tag_value[36] = lambda : Anki.Cozmo.ExternalInterface.SetLiftHeight
  _type_by_tag_value[37] = lambda : Anki.Cozmo.ExternalInterface.TrackToFace
  _type_by_tag_value[38] = lambda : Anki.Cozmo.ExternalInterface.TrackToObject
  _type_by_tag_value[39] = lambda : Anki.Cozmo.ExternalInterface.TrackToPet
  _type_by_tag_value[40] = lambda : Anki.Cozmo.ExternalInterface.TraverseObject
  _type_by_tag_value[41] = lambda : Anki.Cozmo.ExternalInterface.TurnInPlace
  _type_by_tag_value[42] = lambda : Anki.Cozmo.ExternalInterface.TurnInPlaceAtSpeed
  _type_by_tag_value[43] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsFace
  _type_by_tag_value[44] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsImagePoint
  _type_by_tag_value[45] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsLastFacePose
  _type_by_tag_value[46] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsObject
  _type_by_tag_value[47] = lambda : Anki.Cozmo.ExternalInterface.TurnTowardsPose
  _type_by_tag_value[48] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyFace
  _type_by_tag_value[49] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyObject
  _type_by_tag_value[50] = lambda : Anki.Cozmo.ExternalInterface.VisuallyVerifyNoObjectAtPose
  _type_by_tag_value[51] = lambda : Anki.Cozmo.ExternalInterface.Wait
  _type_by_tag_value[52] = lambda : Anki.Cozmo.ExternalInterface.WaitForImages
  _type_by_tag_value[53] = lambda : Anki.Cozmo.AdvertisementRegistrationMsg
  _type_by_tag_value[54] = lambda : Anki.Cozmo.AdvertisementMsg
  _type_by_tag_value[55] = lambda : Anki.Cozmo.ExternalInterface.Ping
  _type_by_tag_value[56] = lambda : Anki.Cozmo.ExternalInterface.DenyGameStart
  _type_by_tag_value[57] = lambda : Anki.Cozmo.SetVizOrigin
  _type_by_tag_value[58] = lambda : Anki.Cozmo.ImageChunk
  _type_by_tag_value[59] = lambda : Anki.Cozmo.ImageImuData
  _type_by_tag_value[60] = lambda : Anki.Cozmo.CameraCalibration
  _type_by_tag_value[61] = lambda : Anki.Cozmo.IMURequest
  _type_by_tag_value[62] = lambda : Anki.Cozmo.StartControllerTestMode
  _type_by_tag_value[63] = lambda : Anki.Cozmo.RawPWM
  _type_by_tag_value[64] = lambda : Anki.Cozmo.ExternalInterface.UiDeviceConnectionSuccess
  _type_by_tag_value[65] = lambda : Anki.Cozmo.ExternalInterface.ConnectToRobot
  _type_by_tag_value[66] = lambda : Anki.Cozmo.ExternalInterface.ConnectToUiDevice
  _type_by_tag_value[67] = lambda : Anki.Cozmo.ExternalInterface.DisconnectFromUiDevice
  _type_by_tag_value[68] = lambda : Anki.Cozmo.ExternalInterface.StartEngine
  _type_by_tag_value[69] = lambda : Anki.Cozmo.ExternalInterface.ReliableTransportRunMode
  _type_by_tag_value[70] = lambda : Anki.Cozmo.ExternalInterface.RequestFeatureToggles
  _type_by_tag_value[71] = lambda : Anki.Cozmo.ExternalInterface.SetFeatureToggle
  _type_by_tag_value[72] = lambda : Anki.Cozmo.ExternalInterface.StartIdleTimeout
  _type_by_tag_value[73] = lambda : Anki.Cozmo.ExternalInterface.CancelIdleTimeout
  _type_by_tag_value[74] = lambda : Anki.Cozmo.ExternalInterface.SetGameBeingPaused
  _type_by_tag_value[75] = lambda : Anki.Cozmo.ExternalInterface.UpdateFirmware
  _type_by_tag_value[76] = lambda : Anki.Cozmo.ExternalInterface.ResetFirmware
  _type_by_tag_value[77] = lambda : Anki.Cozmo.ExternalInterface.DriveWheels
  _type_by_tag_value[78] = lambda : Anki.Cozmo.ExternalInterface.DriveArc
  _type_by_tag_value[79] = lambda : Anki.Cozmo.ExternalInterface.MoveHead
  _type_by_tag_value[80] = lambda : Anki.Cozmo.ExternalInterface.MoveLift
  _type_by_tag_value[81] = lambda : Anki.Cozmo.ExternalInterface.EnableLiftPower
  _type_by_tag_value[82] = lambda : Anki.Cozmo.ExternalInterface.EnableCliffSensor
  _type_by_tag_value[83] = lambda : Anki.Cozmo.ExternalInterface.EnableBlockTapFilter
  _type_by_tag_value[84] = lambda : Anki.Cozmo.ExternalInterface.GetBlockTapFilterStatus
  _type_by_tag_value[85] = lambda : Anki.Cozmo.ExternalInterface.StopAllMotors
  _type_by_tag_value[86] = lambda : Anki.Cozmo.ExternalInterface.ControllerGains
  _type_by_tag_value[87] = lambda : Anki.Cozmo.ExternalInterface.RollActionParams
  _type_by_tag_value[88] = lambda : Anki.Cozmo.ExternalInterface.SetMotionModelParams
  _type_by_tag_value[89] = lambda : Anki.Cozmo.ExternalInterface.SetRobotVolume
  _type_by_tag_value[90] = lambda : Anki.Cozmo.ExternalInterface.SetRobotAudioOutputSource
  _type_by_tag_value[91] = lambda : Anki.Cozmo.ExternalInterface.ForceDelocalizeRobot
  _type_by_tag_value[92] = lambda : Anki.Cozmo.ExternalInterface.RestoreRobotFromBackup
  _type_by_tag_value[93] = lambda : Anki.Cozmo.ExternalInterface.RequestRobotRestoreData
  _type_by_tag_value[94] = lambda : Anki.Cozmo.ExternalInterface.WipeRobotGameData
  _type_by_tag_value[95] = lambda : Anki.Cozmo.ExternalInterface.RequestUnlockDataFromBackup
  _type_by_tag_value[96] = lambda : Anki.Cozmo.ExternalInterface.CancelAction
  _type_by_tag_value[97] = lambda : Anki.Cozmo.ExternalInterface.CancelActionByIdTag
  _type_by_tag_value[98] = lambda : Anki.Cozmo.ExternalInterface.QueueSingleAction
  _type_by_tag_value[99] = lambda : Anki.Cozmo.ExternalInterface.QueueCompoundAction
  _type_by_tag_value[100] = lambda : Anki.Cozmo.ExternalInterface.ImageRequest
  _type_by_tag_value[101] = lambda : Anki.Cozmo.ExternalInterface.SetRobotImageSendMode
  _type_by_tag_value[102] = lambda : Anki.Cozmo.ExternalInterface.SaveImages
  _type_by_tag_value[103] = lambda : Anki.Cozmo.ExternalInterface.SaveRobotState
  _type_by_tag_value[104] = lambda : Anki.Cozmo.ExternalInterface.EnableDisplay
  _type_by_tag_value[105] = lambda : Anki.Cozmo.ExternalInterface.ExecuteTestPlan
  _type_by_tag_value[106] = lambda : Anki.Cozmo.ExternalInterface.PlannerRunMode
  _type_by_tag_value[107] = lambda : Anki.Cozmo.ExternalInterface.SelectNextObject
  _type_by_tag_value[108] = lambda : Anki.Cozmo.ExternalInterface.SetRobotCarryingObject
  _type_by_tag_value[109] = lambda : Anki.Cozmo.ExternalInterface.CreateFixedCustomObject
  _type_by_tag_value[110] = lambda : Anki.Cozmo.ExternalInterface.DefineCustomObject
  _type_by_tag_value[111] = lambda : Anki.Cozmo.ExternalInterface.ClearAllBlocks
  _type_by_tag_value[112] = lambda : Anki.Cozmo.ExternalInterface.ClearAllObjects
  _type_by_tag_value[113] = lambda : Anki.Cozmo.ExternalInterface.DeleteAllObjects
  _type_by_tag_value[114] = lambda : Anki.Cozmo.ExternalInterface.DeleteAllCustomObjects
  _type_by_tag_value[115] = lambda : Anki.Cozmo.ExternalInterface.SetObjectAdditionAndDeletion
  _type_by_tag_value[116] = lambda : Anki.Cozmo.ExternalInterface.VisionWhileMoving
  _type_by_tag_value[117] = lambda : Anki.Cozmo.ExternalInterface.SetFaceEnrollmentPose
  _type_by_tag_value[118] = lambda : Anki.Cozmo.ExternalInterface.EraseEnrolledFaceByID
  _type_by_tag_value[119] = lambda : Anki.Cozmo.ExternalInterface.EraseAllEnrolledFaces
  _type_by_tag_value[120] = lambda : Anki.Cozmo.ExternalInterface.EnableVisionMode
  _type_by_tag_value[121] = lambda : Anki.Cozmo.ExternalInterface.UpdateEnrolledFaceByID
  _type_by_tag_value[122] = lambda : Anki.Cozmo.ExternalInterface.VisionRunMode
  _type_by_tag_value[123] = lambda : Anki.Cozmo.ExternalInterface.SaveFaceAlbumToFile
  _type_by_tag_value[124] = lambda : Anki.Cozmo.ExternalInterface.LoadFaceAlbumFromFile
  _type_by_tag_value[125] = lambda : Anki.Cozmo.ExternalInterface.SetMemoryMapRenderEnabled
  _type_by_tag_value[126] = lambda : Anki.Cozmo.ExternalInterface.ActivateBehaviorChooser
  _type_by_tag_value[127] = lambda : Anki.Cozmo.ExternalInterface.ExecuteBehavior
  _type_by_tag_value[128] = lambda : Anki.Cozmo.ExternalInterface.ExecuteBehaviorByExecutableType
  _type_by_tag_value[129] = lambda : Anki.Cozmo.ExternalInterface.ExecuteBehaviorByName
  _type_by_tag_value[130] = lambda : Anki.Cozmo.ExternalInterface.BehaviorManagerMessage
  _type_by_tag_value[131] = lambda : Anki.Cozmo.ExternalInterface.AbortPath
  _type_by_tag_value[132] = lambda : Anki.Cozmo.ExternalInterface.AbortAll
  _type_by_tag_value[133] = lambda : Anki.Cozmo.ExternalInterface.StartTestMode
  _type_by_tag_value[134] = lambda : Anki.Cozmo.ExternalInterface.RequestEnabledBehaviorList
  _type_by_tag_value[135] = lambda : Anki.Cozmo.ExternalInterface.RequestEnableReactionaryBehavior
  _type_by_tag_value[136] = lambda : Anki.Cozmo.ExternalInterface.SetDefaultHeadAndLiftState
  _type_by_tag_value[137] = lambda : Anki.Cozmo.ExternalInterface.RequestAvailableObjects
  _type_by_tag_value[138] = lambda : Anki.Cozmo.ExternalInterface.DrawPoseMarker
  _type_by_tag_value[139] = lambda : Anki.Cozmo.ExternalInterface.ErasePoseMarker
  _type_by_tag_value[140] = lambda : Anki.Cozmo.ExternalInterface.VisualizeQuad
  _type_by_tag_value[141] = lambda : Anki.Cozmo.ExternalInterface.EraseQuad
  _type_by_tag_value[142] = lambda : Anki.Cozmo.ExternalInterface.ReplayLastAnimation
  _type_by_tag_value[143] = lambda : Anki.Cozmo.ExternalInterface.SetIdleAnimation
  _type_by_tag_value[144] = lambda : Anki.Cozmo.ExternalInterface.PushIdleAnimation
  _type_by_tag_value[145] = lambda : Anki.Cozmo.ExternalInterface.PopIdleAnimation
  _type_by_tag_value[146] = lambda : Anki.Cozmo.ExternalInterface.ReadFaceAnimationDir
  _type_by_tag_value[147] = lambda : Anki.Cozmo.ExternalInterface.ReadAnimationFile
  _type_by_tag_value[148] = lambda : Anki.Cozmo.ExternalInterface.RequestAvailableAnimations
  _type_by_tag_value[149] = lambda : Anki.Cozmo.ExternalInterface.RequestAvailableAnimationGroups
  _type_by_tag_value[150] = lambda : Anki.Cozmo.ExternalInterface.SetLiveIdleAnimationParameters
  _type_by_tag_value[151] = lambda : Anki.Cozmo.ExternalInterface.PushDrivingAnimations
  _type_by_tag_value[152] = lambda : Anki.Cozmo.ExternalInterface.PopDrivingAnimations
  _type_by_tag_value[153] = lambda : Anki.Cozmo.ExternalInterface.SetHeadlight
  _type_by_tag_value[154] = lambda : Anki.Cozmo.ExternalInterface.SetActiveObjectLEDs
  _type_by_tag_value[155] = lambda : Anki.Cozmo.ExternalInterface.SetAllActiveObjectLEDs
  _type_by_tag_value[156] = lambda : Anki.Cozmo.ExternalInterface.SetBackpackLEDs
  _type_by_tag_value[157] = lambda : Anki.Cozmo.ExternalInterface.EnableLightStates
  _type_by_tag_value[158] = lambda : Anki.Cozmo.ExternalInterface.EnableCubeSleep
  _type_by_tag_value[159] = lambda : Anki.Cozmo.ExternalInterface.EnableCubeLightsStateTransitionMessages
  _type_by_tag_value[160] = lambda : Anki.Cozmo.ExternalInterface.FlashCurrentLightsState
  _type_by_tag_value[161] = lambda : Anki.Cozmo.ExternalInterface.TransitionToNextOnboardingState
  _type_by_tag_value[162] = lambda : Anki.Cozmo.ExternalInterface.MoodMessage
  _type_by_tag_value[163] = lambda : Anki.Cozmo.ExternalInterface.ProgressionMessage
  _type_by_tag_value[164] = lambda : Anki.Cozmo.ExternalInterface.RequestSetUnlock
  _type_by_tag_value[165] = lambda : Anki.Cozmo.ExternalInterface.RequestDeviceData
  _type_by_tag_value[166] = lambda : Anki.Cozmo.ExternalInterface.SetDebugConsoleVarMessage
  _type_by_tag_value[167] = lambda : Anki.Cozmo.ExternalInterface.RunDebugConsoleFuncMessage
  _type_by_tag_value[168] = lambda : Anki.Cozmo.ExternalInterface.GetDebugConsoleVarMessage
  _type_by_tag_value[169] = lambda : Anki.Cozmo.ExternalInterface.GetAllDebugConsoleVarMessage
  _type_by_tag_value[170] = lambda : Anki.Cozmo.ExternalInterface.GetJsonDasLogsMessage
  _type_by_tag_value[171] = lambda : Anki.Cozmo.ExternalInterface.SetEnableSOSLogging
  _type_by_tag_value[172] = lambda : Anki.Cozmo.ExternalInterface.EnableReactionaryBehaviors
  _type_by_tag_value[173] = lambda : Anki.Cozmo.ExternalInterface.SetEnableSpeedChooser
  _type_by_tag_value[174] = lambda : Anki.Cozmo.ExternalInterface.BlockPoolEnabledMessage
  _type_by_tag_value[175] = lambda : Anki.Cozmo.ExternalInterface.BlockSelectedMessage
  _type_by_tag_value[176] = lambda : Anki.Cozmo.ExternalInterface.GetBlockPoolMessage
  _type_by_tag_value[177] = lambda : Anki.Cozmo.ExternalInterface.SendAvailableObjects
  _type_by_tag_value[178] = lambda : Anki.Cozmo.ExternalInterface.BlockPoolResetMessage
  _type_by_tag_value[179] = lambda : Anki.Cozmo.ExternalInterface.SaveCalibrationImage
  _type_by_tag_value[180] = lambda : Anki.Cozmo.ExternalInterface.ClearCalibrationImages
  _type_by_tag_value[181] = lambda : Anki.Cozmo.ExternalInterface.ComputeCameraCalibration
  _type_by_tag_value[182] = lambda : Anki.Cozmo.ExternalInterface.ContinueFreeplayFromIdle
  _type_by_tag_value[183] = lambda : Anki.Cozmo.ExternalInterface.EnableDroneMode
  _type_by_tag_value[184] = lambda : Anki.Cozmo.ExternalInterface.EnterSdkMode
  _type_by_tag_value[185] = lambda : Anki.Cozmo.ExternalInterface.ExitSdkMode
  _type_by_tag_value[186] = lambda : Anki.Cozmo.ExternalInterface.SetStopRobotOnSdkDisconnect
  _type_by_tag_value[187] = lambda : Anki.Cozmo.ExternalInterface.StopRobotForSdk
  _type_by_tag_value[188] = lambda : Anki.Cozmo.ExternalInterface.TransferFile
  _type_by_tag_value[189] = lambda : Anki.Cozmo.ExternalInterface.NVStorageEraseEntry
  _type_by_tag_value[190] = lambda : Anki.Cozmo.ExternalInterface.NVStorageWipeAll
  _type_by_tag_value[191] = lambda : Anki.Cozmo.ExternalInterface.NVStorageWriteEntry
  _type_by_tag_value[192] = lambda : Anki.Cozmo.ExternalInterface.NVStorageClearPartialPendingWriteEntry
  _type_by_tag_value[193] = lambda : Anki.Cozmo.ExternalInterface.NVStorageReadEntry
  _type_by_tag_value[194] = lambda : Anki.Cozmo.ExternalInterface.SetCameraSettings
  

Anki.Cozmo.ExternalInterface.MessageGameToEngine = MessageGameToEngine
del MessageGameToEngine


