# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/externalInterface/messageShared.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/externalInterface/messageShared.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.Audio = msgbuffers.Namespace()
Anki.Cozmo.Audio.GameEvent = msgbuffers.Namespace()
Anki.Cozmo.ExternalInterface = msgbuffers.Namespace()

from clad.types.actionTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.advertisementTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class CommsConstants(object):
  "Automatically-generated uint_32 enumeration."
  kDirectCommsBufferSize = 1048576
  kVizCommsBufferSize    = 131072

Anki.Cozmo.ExternalInterface.CommsConstants = CommsConstants
del CommsConstants


class Ping(object):
  "Generated message-passing message."

  __slots__ = (
    '_counter',     # uint_32
    '_timeSent_ms', # float_64
    '_isResponse',  # bool
  )

  @property
  def counter(self):
    "uint_32 counter struct property."
    return self._counter

  @counter.setter
  def counter(self, value):
    self._counter = msgbuffers.validate_integer(
      'Ping.counter', value, 0, 4294967295)

  @property
  def timeSent_ms(self):
    "float_64 timeSent_ms struct property."
    return self._timeSent_ms

  @timeSent_ms.setter
  def timeSent_ms(self, value):
    self._timeSent_ms = msgbuffers.validate_float(
      'Ping.timeSent_ms', value, 'd')

  @property
  def isResponse(self):
    "bool isResponse struct property."
    return self._isResponse

  @isResponse.setter
  def isResponse(self, value):
    self._isResponse = msgbuffers.validate_bool(
      'Ping.isResponse', value)

  def __init__(self, counter=0, timeSent_ms=0.0, isResponse=False):
    self.counter = counter
    self.timeSent_ms = timeSent_ms
    self.isResponse = isResponse

  @classmethod
  def unpack(cls, buffer):
    "Reads a new Ping from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('Ping.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new Ping from the given BinaryReader."
    _counter = reader.read('I')
    _timeSent_ms = reader.read('d')
    _isResponse = bool(reader.read('b'))
    return cls(_counter, _timeSent_ms, _isResponse)

  def pack(self):
    "Writes the current Ping, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current Ping to the given BinaryWriter."
    writer.write(self._counter, 'I')
    writer.write(self._timeSent_ms, 'd')
    writer.write(int(self._isResponse), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._counter == other._counter and
        self._timeSent_ms == other._timeSent_ms and
        self._isResponse == other._isResponse)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._counter, 'I') +
      msgbuffers.size(self._timeSent_ms, 'd') +
      msgbuffers.size(self._isResponse, 'b'))

  def __str__(self):
    return '{type}(counter={counter}, timeSent_ms={timeSent_ms}, isResponse={isResponse})'.format(
      type=type(self).__name__,
      counter=self._counter,
      timeSent_ms=self._timeSent_ms,
      isResponse=self._isResponse)

  def __repr__(self):
    return '{type}(counter={counter}, timeSent_ms={timeSent_ms}, isResponse={isResponse})'.format(
      type=type(self).__name__,
      counter=repr(self._counter),
      timeSent_ms=repr(self._timeSent_ms),
      isResponse=repr(self._isResponse))

Anki.Cozmo.ExternalInterface.Ping = Ping
del Ping


class DenyGameStart(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DenyGameStart from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DenyGameStart.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DenyGameStart from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current DenyGameStart, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DenyGameStart to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.ExternalInterface.DenyGameStart = DenyGameStart
del DenyGameStart


