# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/physicsInterface/messageSimPhysics.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./vizSrc/ -I ../robot/clad/src/ ./src/ -o ../generated/cladPython// clad/physicsInterface/messageSimPhysics.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.PhysicsInterface = msgbuffers.Namespace()

class ApplyForce(object):
  "Generated message-passing message."

  __slots__ = (
    '_xForce',  # float_32
    '_yForce',  # float_32
    '_zForce',  # float_32
    '_DefName', # string[uint_8]
  )

  @property
  def xForce(self):
    "float_32 xForce struct property."
    return self._xForce

  @xForce.setter
  def xForce(self, value):
    self._xForce = msgbuffers.validate_float(
      'ApplyForce.xForce', value, 'f')

  @property
  def yForce(self):
    "float_32 yForce struct property."
    return self._yForce

  @yForce.setter
  def yForce(self, value):
    self._yForce = msgbuffers.validate_float(
      'ApplyForce.yForce', value, 'f')

  @property
  def zForce(self):
    "float_32 zForce struct property."
    return self._zForce

  @zForce.setter
  def zForce(self, value):
    self._zForce = msgbuffers.validate_float(
      'ApplyForce.zForce', value, 'f')

  @property
  def DefName(self):
    "string[uint_8] DefName struct property."
    return self._DefName

  @DefName.setter
  def DefName(self, value):
    self._DefName = msgbuffers.validate_string(
      'ApplyForce.DefName', value, 255)

  def __init__(self, xForce=0.0, yForce=0.0, zForce=0.0, DefName=''):
    self.xForce = xForce
    self.yForce = yForce
    self.zForce = zForce
    self.DefName = DefName

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ApplyForce from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ApplyForce.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ApplyForce from the given BinaryReader."
    _xForce = reader.read('f')
    _yForce = reader.read('f')
    _zForce = reader.read('f')
    _DefName = reader.read_string('B')
    return cls(_xForce, _yForce, _zForce, _DefName)

  def pack(self):
    "Writes the current ApplyForce, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ApplyForce to the given BinaryWriter."
    writer.write(self._xForce, 'f')
    writer.write(self._yForce, 'f')
    writer.write(self._zForce, 'f')
    writer.write_string(self._DefName, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._xForce == other._xForce and
        self._yForce == other._yForce and
        self._zForce == other._zForce and
        self._DefName == other._DefName)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._xForce, 'f') +
      msgbuffers.size(self._yForce, 'f') +
      msgbuffers.size(self._zForce, 'f') +
      msgbuffers.size_string(self._DefName, 'B'))

  def __str__(self):
    return '{type}(xForce={xForce}, yForce={yForce}, zForce={zForce}, DefName={DefName})'.format(
      type=type(self).__name__,
      xForce=self._xForce,
      yForce=self._yForce,
      zForce=self._zForce,
      DefName=msgbuffers.shorten_string(self._DefName))

  def __repr__(self):
    return '{type}(xForce={xForce}, yForce={yForce}, zForce={zForce}, DefName={DefName})'.format(
      type=type(self).__name__,
      xForce=repr(self._xForce),
      yForce=repr(self._yForce),
      zForce=repr(self._zForce),
      DefName=repr(self._DefName))

Anki.Cozmo.PhysicsInterface.ApplyForce = ApplyForce
del ApplyForce


class MessageSimPhysics(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    ApplyForce = 0 # Anki.Cozmo.PhysicsInterface.ApplyForce

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def ApplyForce(self):
    "Anki.Cozmo.PhysicsInterface.ApplyForce ApplyForce union property."
    msgbuffers.safety_check_tag('ApplyForce', self._tag, self.Tag.ApplyForce, self._tags_by_value)
    return self._data

  @ApplyForce.setter
  def ApplyForce(self, value):
    self._data = msgbuffers.validate_object(
      'MessageSimPhysics.ApplyForce', value, Anki.Cozmo.PhysicsInterface.ApplyForce)
    self._tag = self.Tag.ApplyForce

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MessageSimPhysics from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MessageSimPhysics.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MessageSimPhysics from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MessageSimPhysics attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MessageSimPhysics, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MessageSimPhysics.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 1:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 1:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 1:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    ApplyForce=0,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'ApplyForce'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.PhysicsInterface.ApplyForce.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.PhysicsInterface.ApplyForce
  

Anki.Cozmo.PhysicsInterface.MessageSimPhysics = MessageSimPhysics
del MessageSimPhysics


