# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/robotInterface/bleMessages.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/robotInterface/bleMessages.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class EnterPairing(object):
  "Generated message-passing message."

  __slots__ = (
    '_secret', # uint_8[16]
  )

  @property
  def secret(self):
    "uint_8[16] secret struct property."
    return self._secret

  @secret.setter
  def secret(self, value):
    self._secret = msgbuffers.validate_farray(
      'EnterPairing.secret', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, secret=(0,) * 16):
    self.secret = secret

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnterPairing from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnterPairing.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnterPairing from the given BinaryReader."
    _secret = reader.read_farray('B', 16)
    return cls(_secret)

  def pack(self):
    "Writes the current EnterPairing, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnterPairing to the given BinaryWriter."
    writer.write_farray(self._secret, 'B', 16)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._secret == other._secret
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._secret, 'B', 16))

  def __str__(self):
    return '{type}(secret={secret})'.format(
      type=type(self).__name__,
      secret=msgbuffers.shorten_sequence(self._secret))

  def __repr__(self):
    return '{type}(secret={secret})'.format(
      type=type(self).__name__,
      secret=repr(self._secret))

Anki.Cozmo.EnterPairing = EnterPairing
del EnterPairing


class EncodedAESKey(object):
  "Generated message-passing message."

  __slots__ = (
    '_secret',      # uint_8[16]
    '_encoded_key', # uint_8[16]
  )

  @property
  def secret(self):
    "uint_8[16] secret struct property."
    return self._secret

  @secret.setter
  def secret(self, value):
    self._secret = msgbuffers.validate_farray(
      'EncodedAESKey.secret', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def encoded_key(self):
    "uint_8[16] encoded_key struct property."
    return self._encoded_key

  @encoded_key.setter
  def encoded_key(self, value):
    self._encoded_key = msgbuffers.validate_farray(
      'EncodedAESKey.encoded_key', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, secret=(0,) * 16, encoded_key=(0,) * 16):
    self.secret = secret
    self.encoded_key = encoded_key

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EncodedAESKey from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EncodedAESKey.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EncodedAESKey from the given BinaryReader."
    _secret = reader.read_farray('B', 16)
    _encoded_key = reader.read_farray('B', 16)
    return cls(_secret, _encoded_key)

  def pack(self):
    "Writes the current EncodedAESKey, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EncodedAESKey to the given BinaryWriter."
    writer.write_farray(self._secret, 'B', 16)
    writer.write_farray(self._encoded_key, 'B', 16)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._secret == other._secret and
        self._encoded_key == other._encoded_key)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._secret, 'B', 16) +
      msgbuffers.size_farray(self._encoded_key, 'B', 16))

  def __str__(self):
    return '{type}(secret={secret}, encoded_key={encoded_key})'.format(
      type=type(self).__name__,
      secret=msgbuffers.shorten_sequence(self._secret),
      encoded_key=msgbuffers.shorten_sequence(self._encoded_key))

  def __repr__(self):
    return '{type}(secret={secret}, encoded_key={encoded_key})'.format(
      type=type(self).__name__,
      secret=repr(self._secret),
      encoded_key=repr(self._encoded_key))

Anki.Cozmo.EncodedAESKey = EncodedAESKey
del EncodedAESKey


class CalculateDiffieHellman(object):
  "Generated message-passing message."

  __slots__ = (
    '_local',  # uint_8[16]
    '_remote', # uint_8[16]
  )

  @property
  def local(self):
    "uint_8[16] local struct property."
    return self._local

  @local.setter
  def local(self, value):
    self._local = msgbuffers.validate_farray(
      'CalculateDiffieHellman.local', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  @property
  def remote(self):
    "uint_8[16] remote struct property."
    return self._remote

  @remote.setter
  def remote(self, value):
    self._remote = msgbuffers.validate_farray(
      'CalculateDiffieHellman.remote', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, local=(0,) * 16, remote=(0,) * 16):
    self.local = local
    self.remote = remote

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CalculateDiffieHellman from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CalculateDiffieHellman.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CalculateDiffieHellman from the given BinaryReader."
    _local = reader.read_farray('B', 16)
    _remote = reader.read_farray('B', 16)
    return cls(_local, _remote)

  def pack(self):
    "Writes the current CalculateDiffieHellman, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CalculateDiffieHellman to the given BinaryWriter."
    writer.write_farray(self._local, 'B', 16)
    writer.write_farray(self._remote, 'B', 16)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._local == other._local and
        self._remote == other._remote)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._local, 'B', 16) +
      msgbuffers.size_farray(self._remote, 'B', 16))

  def __str__(self):
    return '{type}(local={local}, remote={remote})'.format(
      type=type(self).__name__,
      local=msgbuffers.shorten_sequence(self._local),
      remote=msgbuffers.shorten_sequence(self._remote))

  def __repr__(self):
    return '{type}(local={local}, remote={remote})'.format(
      type=type(self).__name__,
      local=repr(self._local),
      remote=repr(self._remote))

Anki.Cozmo.CalculateDiffieHellman = CalculateDiffieHellman
del CalculateDiffieHellman


class DiffieHellmanResults(object):
  "Generated message-passing message."

  __slots__ = (
    '_result', # uint_8[16]
  )

  @property
  def result(self):
    "uint_8[16] result struct property."
    return self._result

  @result.setter
  def result(self, value):
    self._result = msgbuffers.validate_farray(
      'DiffieHellmanResults.result', value, 16,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, result=(0,) * 16):
    self.result = result

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DiffieHellmanResults from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DiffieHellmanResults.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DiffieHellmanResults from the given BinaryReader."
    _result = reader.read_farray('B', 16)
    return cls(_result)

  def pack(self):
    "Writes the current DiffieHellmanResults, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DiffieHellmanResults to the given BinaryWriter."
    writer.write_farray(self._result, 'B', 16)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._result == other._result
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._result, 'B', 16))

  def __str__(self):
    return '{type}(result={result})'.format(
      type=type(self).__name__,
      result=msgbuffers.shorten_sequence(self._result))

  def __repr__(self):
    return '{type}(result={result})'.format(
      type=type(self).__name__,
      result=repr(self._result))

Anki.Cozmo.DiffieHellmanResults = DiffieHellmanResults
del DiffieHellmanResults


class HelloPhone(object):
  "Generated message-passing message."

  __slots__ = (
    '_nonce', # uint_8[32]
  )

  @property
  def nonce(self):
    "uint_8[32] nonce struct property."
    return self._nonce

  @nonce.setter
  def nonce(self, value):
    self._nonce = msgbuffers.validate_farray(
      'HelloPhone.nonce', value, 32,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, nonce=(0,) * 32):
    self.nonce = nonce

  @classmethod
  def unpack(cls, buffer):
    "Reads a new HelloPhone from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('HelloPhone.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new HelloPhone from the given BinaryReader."
    _nonce = reader.read_farray('B', 32)
    return cls(_nonce)

  def pack(self):
    "Writes the current HelloPhone, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current HelloPhone to the given BinaryWriter."
    writer.write_farray(self._nonce, 'B', 32)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._nonce == other._nonce
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._nonce, 'B', 32))

  def __str__(self):
    return '{type}(nonce={nonce})'.format(
      type=type(self).__name__,
      nonce=msgbuffers.shorten_sequence(self._nonce))

  def __repr__(self):
    return '{type}(nonce={nonce})'.format(
      type=type(self).__name__,
      nonce=repr(self._nonce))

Anki.Cozmo.HelloPhone = HelloPhone
del HelloPhone


