# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/robotInterface/messageFromActiveObject.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/robotInterface/messageFromActiveObject.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

from clad.types.activeObjectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class ObjectDiscovered(object):
  "Generated message-passing message."

  __slots__ = (
    '_factory_id',  # uint_32
    '_device_type', # Anki.Cozmo.ActiveObjectType
    '_rssi',        # int_8
  )

  @property
  def factory_id(self):
    "uint_32 factory_id struct property."
    return self._factory_id

  @factory_id.setter
  def factory_id(self, value):
    self._factory_id = msgbuffers.validate_integer(
      'ObjectDiscovered.factory_id', value, 0, 4294967295)

  @property
  def device_type(self):
    "Anki.Cozmo.ActiveObjectType device_type struct property."
    return self._device_type

  @device_type.setter
  def device_type(self, value):
    self._device_type = msgbuffers.validate_integer(
      'ObjectDiscovered.device_type', value, 0, 65535)

  @property
  def rssi(self):
    "int_8 rssi struct property."
    return self._rssi

  @rssi.setter
  def rssi(self, value):
    self._rssi = msgbuffers.validate_integer(
      'ObjectDiscovered.rssi', value, -128, 127)

  def __init__(self, factory_id=0, device_type=Anki.Cozmo.ActiveObjectType.OBJECT_OTA_FAIL, rssi=0):
    self.factory_id = factory_id
    self.device_type = device_type
    self.rssi = rssi

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectDiscovered from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectDiscovered.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectDiscovered from the given BinaryReader."
    _factory_id = reader.read('I')
    _device_type = reader.read('H')
    _rssi = reader.read('b')
    return cls(_factory_id, _device_type, _rssi)

  def pack(self):
    "Writes the current ObjectDiscovered, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectDiscovered to the given BinaryWriter."
    writer.write(self._factory_id, 'I')
    writer.write(self._device_type, 'H')
    writer.write(self._rssi, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._factory_id == other._factory_id and
        self._device_type == other._device_type and
        self._rssi == other._rssi)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._factory_id, 'I') +
      msgbuffers.size(self._device_type, 'H') +
      msgbuffers.size(self._rssi, 'b'))

  def __str__(self):
    return '{type}(factory_id={factory_id}, device_type={device_type}, rssi={rssi})'.format(
      type=type(self).__name__,
      factory_id=self._factory_id,
      device_type=self._device_type,
      rssi=self._rssi)

  def __repr__(self):
    return '{type}(factory_id={factory_id}, device_type={device_type}, rssi={rssi})'.format(
      type=type(self).__name__,
      factory_id=repr(self._factory_id),
      device_type=repr(self._device_type),
      rssi=repr(self._rssi))

Anki.Cozmo.ObjectDiscovered = ObjectDiscovered
del ObjectDiscovered


class ObjectConnectionState(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',    # uint_32
    '_factoryID',   # uint_32
    '_device_type', # Anki.Cozmo.ActiveObjectType
    '_connected',   # bool
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectConnectionState.objectID', value, 0, 4294967295)

  @property
  def factoryID(self):
    "uint_32 factoryID struct property."
    return self._factoryID

  @factoryID.setter
  def factoryID(self, value):
    self._factoryID = msgbuffers.validate_integer(
      'ObjectConnectionState.factoryID', value, 0, 4294967295)

  @property
  def device_type(self):
    "Anki.Cozmo.ActiveObjectType device_type struct property."
    return self._device_type

  @device_type.setter
  def device_type(self, value):
    self._device_type = msgbuffers.validate_integer(
      'ObjectConnectionState.device_type', value, 0, 65535)

  @property
  def connected(self):
    "bool connected struct property."
    return self._connected

  @connected.setter
  def connected(self, value):
    self._connected = msgbuffers.validate_bool(
      'ObjectConnectionState.connected', value)

  def __init__(self, objectID=0, factoryID=0, device_type=Anki.Cozmo.ActiveObjectType.OBJECT_OTA_FAIL, connected=False):
    self.objectID = objectID
    self.factoryID = factoryID
    self.device_type = device_type
    self.connected = connected

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectConnectionState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectConnectionState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectConnectionState from the given BinaryReader."
    _objectID = reader.read('I')
    _factoryID = reader.read('I')
    _device_type = reader.read('H')
    _connected = bool(reader.read('b'))
    return cls(_objectID, _factoryID, _device_type, _connected)

  def pack(self):
    "Writes the current ObjectConnectionState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectConnectionState to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._factoryID, 'I')
    writer.write(self._device_type, 'H')
    writer.write(int(self._connected), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._factoryID == other._factoryID and
        self._device_type == other._device_type and
        self._connected == other._connected)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._factoryID, 'I') +
      msgbuffers.size(self._device_type, 'H') +
      msgbuffers.size(self._connected, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, device_type={device_type}, connected={connected})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      factoryID=self._factoryID,
      device_type=self._device_type,
      connected=self._connected)

  def __repr__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, device_type={device_type}, connected={connected})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      factoryID=repr(self._factoryID),
      device_type=repr(self._device_type),
      connected=repr(self._connected))

Anki.Cozmo.ObjectConnectionState = ObjectConnectionState
del ObjectConnectionState


class ObjectConnectionStateToRobot(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',    # uint_32
    '_factoryID',   # uint_32
    '_device_type', # Anki.Cozmo.ActiveObjectType
    '_connected',   # bool
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectConnectionStateToRobot.objectID', value, 0, 4294967295)

  @property
  def factoryID(self):
    "uint_32 factoryID struct property."
    return self._factoryID

  @factoryID.setter
  def factoryID(self, value):
    self._factoryID = msgbuffers.validate_integer(
      'ObjectConnectionStateToRobot.factoryID', value, 0, 4294967295)

  @property
  def device_type(self):
    "Anki.Cozmo.ActiveObjectType device_type struct property."
    return self._device_type

  @device_type.setter
  def device_type(self, value):
    self._device_type = msgbuffers.validate_integer(
      'ObjectConnectionStateToRobot.device_type', value, 0, 65535)

  @property
  def connected(self):
    "bool connected struct property."
    return self._connected

  @connected.setter
  def connected(self, value):
    self._connected = msgbuffers.validate_bool(
      'ObjectConnectionStateToRobot.connected', value)

  def __init__(self, objectID=0, factoryID=0, device_type=Anki.Cozmo.ActiveObjectType.OBJECT_OTA_FAIL, connected=False):
    self.objectID = objectID
    self.factoryID = factoryID
    self.device_type = device_type
    self.connected = connected

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectConnectionStateToRobot from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectConnectionStateToRobot.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectConnectionStateToRobot from the given BinaryReader."
    _objectID = reader.read('I')
    _factoryID = reader.read('I')
    _device_type = reader.read('H')
    _connected = bool(reader.read('b'))
    return cls(_objectID, _factoryID, _device_type, _connected)

  def pack(self):
    "Writes the current ObjectConnectionStateToRobot, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectConnectionStateToRobot to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._factoryID, 'I')
    writer.write(self._device_type, 'H')
    writer.write(int(self._connected), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._factoryID == other._factoryID and
        self._device_type == other._device_type and
        self._connected == other._connected)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._factoryID, 'I') +
      msgbuffers.size(self._device_type, 'H') +
      msgbuffers.size(self._connected, 'b'))

  def __str__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, device_type={device_type}, connected={connected})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      factoryID=self._factoryID,
      device_type=self._device_type,
      connected=self._connected)

  def __repr__(self):
    return '{type}(objectID={objectID}, factoryID={factoryID}, device_type={device_type}, connected={connected})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      factoryID=repr(self._factoryID),
      device_type=repr(self._device_type),
      connected=repr(self._connected))

Anki.Cozmo.ObjectConnectionStateToRobot = ObjectConnectionStateToRobot
del ObjectConnectionStateToRobot


class ObjectMoved(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp',   # uint_32
    '_objectID',    # uint_32
    '_robotID',     # uint_32
    '_accel',       # Anki.Cozmo.ActiveAccel
    '_axisOfAccel', # Anki.Cozmo.UpAxis
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'ObjectMoved.timestamp', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectMoved.objectID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ObjectMoved.robotID', value, 0, 4294967295)

  @property
  def accel(self):
    "Anki.Cozmo.ActiveAccel accel struct property."
    return self._accel

  @accel.setter
  def accel(self, value):
    self._accel = msgbuffers.validate_object(
      'ObjectMoved.accel', value, Anki.Cozmo.ActiveAccel)

  @property
  def axisOfAccel(self):
    "Anki.Cozmo.UpAxis axisOfAccel struct property."
    return self._axisOfAccel

  @axisOfAccel.setter
  def axisOfAccel(self, value):
    self._axisOfAccel = msgbuffers.validate_integer(
      'ObjectMoved.axisOfAccel', value, 0, 255)

  def __init__(self, timestamp=0, objectID=0, robotID=0, accel=Anki.Cozmo.ActiveAccel(), axisOfAccel=Anki.Cozmo.UpAxis.XNegative):
    self.timestamp = timestamp
    self.objectID = objectID
    self.robotID = robotID
    self.accel = accel
    self.axisOfAccel = axisOfAccel

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectMoved from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectMoved.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectMoved from the given BinaryReader."
    _timestamp = reader.read('I')
    _objectID = reader.read('I')
    _robotID = reader.read('I')
    _accel = reader.read_object(Anki.Cozmo.ActiveAccel.unpack_from)
    _axisOfAccel = reader.read('B')
    return cls(_timestamp, _objectID, _robotID, _accel, _axisOfAccel)

  def pack(self):
    "Writes the current ObjectMoved, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectMoved to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._objectID, 'I')
    writer.write(self._robotID, 'I')
    writer.write_object(self._accel)
    writer.write(self._axisOfAccel, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._objectID == other._objectID and
        self._robotID == other._robotID and
        self._accel == other._accel and
        self._axisOfAccel == other._axisOfAccel)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size_object(self._accel) +
      msgbuffers.size(self._axisOfAccel, 'B'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, accel={accel}, axisOfAccel={axisOfAccel})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      objectID=self._objectID,
      robotID=self._robotID,
      accel=self._accel,
      axisOfAccel=self._axisOfAccel)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, accel={accel}, axisOfAccel={axisOfAccel})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      objectID=repr(self._objectID),
      robotID=repr(self._robotID),
      accel=repr(self._accel),
      axisOfAccel=repr(self._axisOfAccel))

Anki.Cozmo.ObjectMoved = ObjectMoved
del ObjectMoved


class ObjectStoppedMoving(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp', # uint_32
    '_objectID',  # uint_32
    '_robotID',   # uint_32
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'ObjectStoppedMoving.timestamp', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectStoppedMoving.objectID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ObjectStoppedMoving.robotID', value, 0, 4294967295)

  def __init__(self, timestamp=0, objectID=0, robotID=0):
    self.timestamp = timestamp
    self.objectID = objectID
    self.robotID = robotID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectStoppedMoving from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectStoppedMoving.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectStoppedMoving from the given BinaryReader."
    _timestamp = reader.read('I')
    _objectID = reader.read('I')
    _robotID = reader.read('I')
    return cls(_timestamp, _objectID, _robotID)

  def pack(self):
    "Writes the current ObjectStoppedMoving, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectStoppedMoving to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._objectID, 'I')
    writer.write(self._robotID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._objectID == other._objectID and
        self._robotID == other._robotID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._robotID, 'I'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      objectID=self._objectID,
      robotID=self._robotID)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      objectID=repr(self._objectID),
      robotID=repr(self._robotID))

Anki.Cozmo.ObjectStoppedMoving = ObjectStoppedMoving
del ObjectStoppedMoving


class ObjectUpAxisChanged(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp', # uint_32
    '_objectID',  # uint_32
    '_robotID',   # uint_32
    '_upAxis',    # Anki.Cozmo.UpAxis
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'ObjectUpAxisChanged.timestamp', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectUpAxisChanged.objectID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ObjectUpAxisChanged.robotID', value, 0, 4294967295)

  @property
  def upAxis(self):
    "Anki.Cozmo.UpAxis upAxis struct property."
    return self._upAxis

  @upAxis.setter
  def upAxis(self, value):
    self._upAxis = msgbuffers.validate_integer(
      'ObjectUpAxisChanged.upAxis', value, 0, 255)

  def __init__(self, timestamp=0, objectID=0, robotID=0, upAxis=Anki.Cozmo.UpAxis.XNegative):
    self.timestamp = timestamp
    self.objectID = objectID
    self.robotID = robotID
    self.upAxis = upAxis

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectUpAxisChanged from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectUpAxisChanged.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectUpAxisChanged from the given BinaryReader."
    _timestamp = reader.read('I')
    _objectID = reader.read('I')
    _robotID = reader.read('I')
    _upAxis = reader.read('B')
    return cls(_timestamp, _objectID, _robotID, _upAxis)

  def pack(self):
    "Writes the current ObjectUpAxisChanged, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectUpAxisChanged to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._objectID, 'I')
    writer.write(self._robotID, 'I')
    writer.write(self._upAxis, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._objectID == other._objectID and
        self._robotID == other._robotID and
        self._upAxis == other._upAxis)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._upAxis, 'B'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, upAxis={upAxis})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      objectID=self._objectID,
      robotID=self._robotID,
      upAxis=self._upAxis)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, upAxis={upAxis})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      objectID=repr(self._objectID),
      robotID=repr(self._robotID),
      upAxis=repr(self._upAxis))

Anki.Cozmo.ObjectUpAxisChanged = ObjectUpAxisChanged
del ObjectUpAxisChanged


class ObjectTapped(object):
  "Generated message-passing message."

  __slots__ = (
    '_timestamp', # uint_32
    '_objectID',  # uint_32
    '_robotID',   # uint_32
    '_numTaps',   # uint_8
    '_tapTime',   # uint_8
    '_tapNeg',    # int_8
    '_tapPos',    # int_8
  )

  @property
  def timestamp(self):
    "uint_32 timestamp struct property."
    return self._timestamp

  @timestamp.setter
  def timestamp(self, value):
    self._timestamp = msgbuffers.validate_integer(
      'ObjectTapped.timestamp', value, 0, 4294967295)

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectTapped.objectID', value, 0, 4294967295)

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'ObjectTapped.robotID', value, 0, 4294967295)

  @property
  def numTaps(self):
    "uint_8 numTaps struct property."
    return self._numTaps

  @numTaps.setter
  def numTaps(self, value):
    self._numTaps = msgbuffers.validate_integer(
      'ObjectTapped.numTaps', value, 0, 255)

  @property
  def tapTime(self):
    "uint_8 tapTime struct property."
    return self._tapTime

  @tapTime.setter
  def tapTime(self, value):
    self._tapTime = msgbuffers.validate_integer(
      'ObjectTapped.tapTime', value, 0, 255)

  @property
  def tapNeg(self):
    "int_8 tapNeg struct property."
    return self._tapNeg

  @tapNeg.setter
  def tapNeg(self, value):
    self._tapNeg = msgbuffers.validate_integer(
      'ObjectTapped.tapNeg', value, -128, 127)

  @property
  def tapPos(self):
    "int_8 tapPos struct property."
    return self._tapPos

  @tapPos.setter
  def tapPos(self, value):
    self._tapPos = msgbuffers.validate_integer(
      'ObjectTapped.tapPos', value, -128, 127)

  def __init__(self, timestamp=0, objectID=0, robotID=0, numTaps=0, tapTime=0, tapNeg=0, tapPos=0):
    self.timestamp = timestamp
    self.objectID = objectID
    self.robotID = robotID
    self.numTaps = numTaps
    self.tapTime = tapTime
    self.tapNeg = tapNeg
    self.tapPos = tapPos

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectTapped from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectTapped.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectTapped from the given BinaryReader."
    _timestamp = reader.read('I')
    _objectID = reader.read('I')
    _robotID = reader.read('I')
    _numTaps = reader.read('B')
    _tapTime = reader.read('B')
    _tapNeg = reader.read('b')
    _tapPos = reader.read('b')
    return cls(_timestamp, _objectID, _robotID, _numTaps, _tapTime, _tapNeg, _tapPos)

  def pack(self):
    "Writes the current ObjectTapped, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectTapped to the given BinaryWriter."
    writer.write(self._timestamp, 'I')
    writer.write(self._objectID, 'I')
    writer.write(self._robotID, 'I')
    writer.write(self._numTaps, 'B')
    writer.write(self._tapTime, 'B')
    writer.write(self._tapNeg, 'b')
    writer.write(self._tapPos, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._timestamp == other._timestamp and
        self._objectID == other._objectID and
        self._robotID == other._robotID and
        self._numTaps == other._numTaps and
        self._tapTime == other._tapTime and
        self._tapNeg == other._tapNeg and
        self._tapPos == other._tapPos)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._timestamp, 'I') +
      msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._numTaps, 'B') +
      msgbuffers.size(self._tapTime, 'B') +
      msgbuffers.size(self._tapNeg, 'b') +
      msgbuffers.size(self._tapPos, 'b'))

  def __str__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, numTaps={numTaps}, tapTime={tapTime}, tapNeg={tapNeg}, tapPos={tapPos})'.format(
      type=type(self).__name__,
      timestamp=self._timestamp,
      objectID=self._objectID,
      robotID=self._robotID,
      numTaps=self._numTaps,
      tapTime=self._tapTime,
      tapNeg=self._tapNeg,
      tapPos=self._tapPos)

  def __repr__(self):
    return '{type}(timestamp={timestamp}, objectID={objectID}, robotID={robotID}, numTaps={numTaps}, tapTime={tapTime}, tapNeg={tapNeg}, tapPos={tapPos})'.format(
      type=type(self).__name__,
      timestamp=repr(self._timestamp),
      objectID=repr(self._objectID),
      robotID=repr(self._robotID),
      numTaps=repr(self._numTaps),
      tapTime=repr(self._tapTime),
      tapNeg=repr(self._tapNeg),
      tapPos=repr(self._tapPos))

Anki.Cozmo.ObjectTapped = ObjectTapped
del ObjectTapped


class ObjectPowerLevel(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',     # uint_32
    '_batteryLevel', # uint_8
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'ObjectPowerLevel.objectID', value, 0, 4294967295)

  @property
  def batteryLevel(self):
    "uint_8 batteryLevel struct property."
    return self._batteryLevel

  @batteryLevel.setter
  def batteryLevel(self, value):
    self._batteryLevel = msgbuffers.validate_integer(
      'ObjectPowerLevel.batteryLevel', value, 0, 255)

  def __init__(self, objectID=0, batteryLevel=0):
    self.objectID = objectID
    self.batteryLevel = batteryLevel

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ObjectPowerLevel from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ObjectPowerLevel.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ObjectPowerLevel from the given BinaryReader."
    _objectID = reader.read('I')
    _batteryLevel = reader.read('B')
    return cls(_objectID, _batteryLevel)

  def pack(self):
    "Writes the current ObjectPowerLevel, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ObjectPowerLevel to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._batteryLevel, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._batteryLevel == other._batteryLevel)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._batteryLevel, 'B'))

  def __str__(self):
    return '{type}(objectID={objectID}, batteryLevel={batteryLevel})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      batteryLevel=self._batteryLevel)

  def __repr__(self):
    return '{type}(objectID={objectID}, batteryLevel={batteryLevel})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      batteryLevel=repr(self._batteryLevel))

Anki.Cozmo.ObjectPowerLevel = ObjectPowerLevel
del ObjectPowerLevel


