# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/activeObjectTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/activeObjectTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

from clad.types.ledTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class ActiveObjectType(object):
  "Automatically-generated uint_16 enumeration."
  OBJECT_OTA_FAIL = 0xee00
  OBJECT_CHARGER  = 0xff00
  OBJECT_CUBE1    = 0xff01
  OBJECT_CUBE2    = 0xff02
  OBJECT_CUBE3    = 0xff03
  OBJECT_UNKNOWN  = 0xffff

Anki.Cozmo.ActiveObjectType = ActiveObjectType
del ActiveObjectType


class ActiveObjectConstants(object):
  "Automatically-generated uint_32 enumeration."
  MAX_NUM_CUBES                     = 4
  MAX_NUM_ACTIVE_OBJECTS            = 5
  NUM_CUBE_LEDS                     = 4
  FLASH_BLOCK_TIME_INTERVAL_MS      = 200
  ACTIVE_OBJECT_DISCOVERY_PERIOD_MS = 1000
  OBJECT_DISCOVERY_CHANNEL          = 5

Anki.Cozmo.ActiveObjectConstants = ActiveObjectConstants
del ActiveObjectConstants


class WhichCubeLEDs(object):
  "Automatically-generated uint_8 enumeration."
  NONE           = 0x0
  ALL            = 0xff
  BACK           = 0x1
  LEFT           = 0x2
  FRONT          = 0x4
  RIGHT          = 0x8
  FRONT_LEFT     = 0x6
  FRONT_RIGHT    = 0xc
  BACK_LEFT      = 0x3
  BACK_RIGHT     = 0x9
  CHARGER_BACK   = 0x1
  CHARGER_MIDDLE = 0x2
  CHARGER_FRONT  = 0x4

Anki.Cozmo.WhichCubeLEDs = WhichCubeLEDs
del WhichCubeLEDs


class MakeRelativeMode(object):
  "Automatically-generated uint_8 enumeration."
  RELATIVE_LED_MODE_OFF       = 0
  RELATIVE_LED_MODE_BY_CORNER = 1
  RELATIVE_LED_MODE_BY_SIDE   = 2

Anki.Cozmo.MakeRelativeMode = MakeRelativeMode
del MakeRelativeMode


class ActiveAccel(object):
  "Generated message-passing structure."

  __slots__ = (
    '_x', # float_32
    '_y', # float_32
    '_z', # float_32
  )

  @property
  def x(self):
    "float_32 x struct property."
    return self._x

  @x.setter
  def x(self, value):
    self._x = msgbuffers.validate_float(
      'ActiveAccel.x', value, 'f')

  @property
  def y(self):
    "float_32 y struct property."
    return self._y

  @y.setter
  def y(self, value):
    self._y = msgbuffers.validate_float(
      'ActiveAccel.y', value, 'f')

  @property
  def z(self):
    "float_32 z struct property."
    return self._z

  @z.setter
  def z(self, value):
    self._z = msgbuffers.validate_float(
      'ActiveAccel.z', value, 'f')

  def __init__(self, x=0.0, y=0.0, z=0.0):
    self.x = x
    self.y = y
    self.z = z

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ActiveAccel from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ActiveAccel.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ActiveAccel from the given BinaryReader."
    _x = reader.read('f')
    _y = reader.read('f')
    _z = reader.read('f')
    return cls(_x, _y, _z)

  def pack(self):
    "Writes the current ActiveAccel, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ActiveAccel to the given BinaryWriter."
    writer.write(self._x, 'f')
    writer.write(self._y, 'f')
    writer.write(self._z, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x == other._x and
        self._y == other._y and
        self._z == other._z)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x, 'f') +
      msgbuffers.size(self._y, 'f') +
      msgbuffers.size(self._z, 'f'))

  def __str__(self):
    return '{type}(x={x}, y={y}, z={z})'.format(
      type=type(self).__name__,
      x=self._x,
      y=self._y,
      z=self._z)

  def __repr__(self):
    return '{type}(x={x}, y={y}, z={z})'.format(
      type=type(self).__name__,
      x=repr(self._x),
      y=repr(self._y),
      z=repr(self._z))

Anki.Cozmo.ActiveAccel = ActiveAccel
del ActiveAccel


class UpAxis(object):
  "Automatically-generated uint_8 enumeration."
  XNegative = 0
  XPositive = 1
  YNegative = 2
  YPositive = 3
  ZNegative = 4
  ZPositive = 5
  NumAxes   = 6
  Unknown   = 7

Anki.Cozmo.UpAxis = UpAxis
del UpAxis


class ActiveIdentityState(object):
  "Automatically-generated uint_8 enumeration."
  Unidentified       = 0
  WaitingForIdentity = 1
  Identified         = 2

Anki.Cozmo.ActiveIdentityState = ActiveIdentityState
del ActiveIdentityState


