# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/advertisementTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/advertisementTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class AdvertisementRegistrationMsg(object):
  "Generated message-passing message."

  __slots__ = (
    '_toEnginePort',        # uint_16
    '_fromEnginePort',      # uint_16
    '_id',                  # uint_8
    '_enableAdvertisement', # bool
    '_oneShot',             # bool
    '_ip',                  # string[uint_8]
  )

  @property
  def toEnginePort(self):
    "uint_16 toEnginePort struct property."
    return self._toEnginePort

  @toEnginePort.setter
  def toEnginePort(self, value):
    self._toEnginePort = msgbuffers.validate_integer(
      'AdvertisementRegistrationMsg.toEnginePort', value, 0, 65535)

  @property
  def fromEnginePort(self):
    "uint_16 fromEnginePort struct property."
    return self._fromEnginePort

  @fromEnginePort.setter
  def fromEnginePort(self, value):
    self._fromEnginePort = msgbuffers.validate_integer(
      'AdvertisementRegistrationMsg.fromEnginePort', value, 0, 65535)

  @property
  def id(self):
    "uint_8 id struct property."
    return self._id

  @id.setter
  def id(self, value):
    self._id = msgbuffers.validate_integer(
      'AdvertisementRegistrationMsg.id', value, 0, 255)

  @property
  def enableAdvertisement(self):
    "bool enableAdvertisement struct property."
    return self._enableAdvertisement

  @enableAdvertisement.setter
  def enableAdvertisement(self, value):
    self._enableAdvertisement = msgbuffers.validate_bool(
      'AdvertisementRegistrationMsg.enableAdvertisement', value)

  @property
  def oneShot(self):
    "bool oneShot struct property."
    return self._oneShot

  @oneShot.setter
  def oneShot(self, value):
    self._oneShot = msgbuffers.validate_bool(
      'AdvertisementRegistrationMsg.oneShot', value)

  @property
  def ip(self):
    "string[uint_8] ip struct property."
    return self._ip

  @ip.setter
  def ip(self, value):
    self._ip = msgbuffers.validate_string(
      'AdvertisementRegistrationMsg.ip', value, 255)

  def __init__(self, toEnginePort=0, fromEnginePort=0, id=0, enableAdvertisement=False, oneShot=False, ip=''):
    self.toEnginePort = toEnginePort
    self.fromEnginePort = fromEnginePort
    self.id = id
    self.enableAdvertisement = enableAdvertisement
    self.oneShot = oneShot
    self.ip = ip

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AdvertisementRegistrationMsg from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AdvertisementRegistrationMsg.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AdvertisementRegistrationMsg from the given BinaryReader."
    _toEnginePort = reader.read('H')
    _fromEnginePort = reader.read('H')
    _id = reader.read('B')
    _enableAdvertisement = bool(reader.read('b'))
    _oneShot = bool(reader.read('b'))
    _ip = reader.read_string('B')
    return cls(_toEnginePort, _fromEnginePort, _id, _enableAdvertisement, _oneShot, _ip)

  def pack(self):
    "Writes the current AdvertisementRegistrationMsg, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AdvertisementRegistrationMsg to the given BinaryWriter."
    writer.write(self._toEnginePort, 'H')
    writer.write(self._fromEnginePort, 'H')
    writer.write(self._id, 'B')
    writer.write(int(self._enableAdvertisement), 'b')
    writer.write(int(self._oneShot), 'b')
    writer.write_string(self._ip, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._toEnginePort == other._toEnginePort and
        self._fromEnginePort == other._fromEnginePort and
        self._id == other._id and
        self._enableAdvertisement == other._enableAdvertisement and
        self._oneShot == other._oneShot and
        self._ip == other._ip)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._toEnginePort, 'H') +
      msgbuffers.size(self._fromEnginePort, 'H') +
      msgbuffers.size(self._id, 'B') +
      msgbuffers.size(self._enableAdvertisement, 'b') +
      msgbuffers.size(self._oneShot, 'b') +
      msgbuffers.size_string(self._ip, 'B'))

  def __str__(self):
    return '{type}(toEnginePort={toEnginePort}, fromEnginePort={fromEnginePort}, id={id}, enableAdvertisement={enableAdvertisement}, oneShot={oneShot}, ip={ip})'.format(
      type=type(self).__name__,
      toEnginePort=self._toEnginePort,
      fromEnginePort=self._fromEnginePort,
      id=self._id,
      enableAdvertisement=self._enableAdvertisement,
      oneShot=self._oneShot,
      ip=msgbuffers.shorten_string(self._ip))

  def __repr__(self):
    return '{type}(toEnginePort={toEnginePort}, fromEnginePort={fromEnginePort}, id={id}, enableAdvertisement={enableAdvertisement}, oneShot={oneShot}, ip={ip})'.format(
      type=type(self).__name__,
      toEnginePort=repr(self._toEnginePort),
      fromEnginePort=repr(self._fromEnginePort),
      id=repr(self._id),
      enableAdvertisement=repr(self._enableAdvertisement),
      oneShot=repr(self._oneShot),
      ip=repr(self._ip))

Anki.Cozmo.AdvertisementRegistrationMsg = AdvertisementRegistrationMsg
del AdvertisementRegistrationMsg


class AdvertisementMsg(object):
  "Generated message-passing message."

  __slots__ = (
    '_toEnginePort',   # uint_16
    '_fromEnginePort', # uint_16
    '_id',             # uint_8
    '_ip',             # string[uint_8]
  )

  @property
  def toEnginePort(self):
    "uint_16 toEnginePort struct property."
    return self._toEnginePort

  @toEnginePort.setter
  def toEnginePort(self, value):
    self._toEnginePort = msgbuffers.validate_integer(
      'AdvertisementMsg.toEnginePort', value, 0, 65535)

  @property
  def fromEnginePort(self):
    "uint_16 fromEnginePort struct property."
    return self._fromEnginePort

  @fromEnginePort.setter
  def fromEnginePort(self, value):
    self._fromEnginePort = msgbuffers.validate_integer(
      'AdvertisementMsg.fromEnginePort', value, 0, 65535)

  @property
  def id(self):
    "uint_8 id struct property."
    return self._id

  @id.setter
  def id(self, value):
    self._id = msgbuffers.validate_integer(
      'AdvertisementMsg.id', value, 0, 255)

  @property
  def ip(self):
    "string[uint_8] ip struct property."
    return self._ip

  @ip.setter
  def ip(self, value):
    self._ip = msgbuffers.validate_string(
      'AdvertisementMsg.ip', value, 255)

  def __init__(self, toEnginePort=0, fromEnginePort=0, id=0, ip=''):
    self.toEnginePort = toEnginePort
    self.fromEnginePort = fromEnginePort
    self.id = id
    self.ip = ip

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AdvertisementMsg from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AdvertisementMsg.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AdvertisementMsg from the given BinaryReader."
    _toEnginePort = reader.read('H')
    _fromEnginePort = reader.read('H')
    _id = reader.read('B')
    _ip = reader.read_string('B')
    return cls(_toEnginePort, _fromEnginePort, _id, _ip)

  def pack(self):
    "Writes the current AdvertisementMsg, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AdvertisementMsg to the given BinaryWriter."
    writer.write(self._toEnginePort, 'H')
    writer.write(self._fromEnginePort, 'H')
    writer.write(self._id, 'B')
    writer.write_string(self._ip, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._toEnginePort == other._toEnginePort and
        self._fromEnginePort == other._fromEnginePort and
        self._id == other._id and
        self._ip == other._ip)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._toEnginePort, 'H') +
      msgbuffers.size(self._fromEnginePort, 'H') +
      msgbuffers.size(self._id, 'B') +
      msgbuffers.size_string(self._ip, 'B'))

  def __str__(self):
    return '{type}(toEnginePort={toEnginePort}, fromEnginePort={fromEnginePort}, id={id}, ip={ip})'.format(
      type=type(self).__name__,
      toEnginePort=self._toEnginePort,
      fromEnginePort=self._fromEnginePort,
      id=self._id,
      ip=msgbuffers.shorten_string(self._ip))

  def __repr__(self):
    return '{type}(toEnginePort={toEnginePort}, fromEnginePort={fromEnginePort}, id={id}, ip={ip})'.format(
      type=type(self).__name__,
      toEnginePort=repr(self._toEnginePort),
      fromEnginePort=repr(self._fromEnginePort),
      id=repr(self._id),
      ip=repr(self._ip))

Anki.Cozmo.AdvertisementMsg = AdvertisementMsg
del AdvertisementMsg


