# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/animationTrigger.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/animationTrigger.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class AnimationTrigger(object):
  "Automatically-generated int_32 enumeration."
  AcknowledgeFaceInitPause              = 0
  AcknowledgeFaceNamed                  = 1
  AcknowledgeFaceUnnamed                = 2
  AcknowledgeObject                     = 3
  AskToBeRightedLeft                    = 4
  AskToBeRightedRight                   = 5
  BlockReact                            = 6
  BuildPyramidReactToBase               = 7
  BuildPyramidSuccess                   = 8
  CantHandleTallStack                   = 9
  PatternGuessNewIdea                   = 10
  PatternGuessThinking                  = 11
  ConnectWakeUp                         = 12
  CozmoSaysGetIn                        = 13
  CozmoSaysGetOut                       = 14
  CozmoSaysSpeakGetInShort              = 15
  CozmoSaysSpeakGetInMedium             = 16
  CozmoSaysSpeakGetInLong               = 17
  CozmoSaysSpeakGetOutShort             = 18
  CozmoSaysSpeakGetOutMedium            = 19
  CozmoSaysSpeakGetOutLong              = 20
  CozmoSaysSpeakLoop                    = 21
  CozmoSaysBadWord                      = 22
  CozmoSaysIdle                         = 23
  CubeMovedSense                        = 24
  CubeMovedUpset                        = 25
  CubePounceFake                        = 26
  CubePounceGetIn                       = 27
  CubePounceGetOut                      = 28
  CubePounceGetReady                    = 29
  CubePounceGetUnready                  = 30
  CubePounceIdleLiftDown                = 31
  CubePounceIdleLiftUp                  = 32
  CubePounceLoseHand                    = 33
  CubePounceLoseRound                   = 34
  CubePounceLoseSession                 = 35
  CubePouncePounceClose                 = 36
  CubePouncePounceNormal                = 37
  CubePounceWinHand                     = 38
  CubePounceWinRound                    = 39
  CubePounceWinSession                  = 40
  DriveEndAngry                         = 41
  DriveEndDefault                       = 42
  DriveEndLaunch                        = 43
  DriveLoopAngry                        = 44
  DriveLoopDefault                      = 45
  DriveLoopLaunch                       = 46
  DriveStartAngry                       = 47
  DriveStartDefault                     = 48
  DriveStartLaunch                      = 49
  DroneModeBackwardDrivingEnd           = 50
  DroneModeBackwardDrivingLoop          = 51
  DroneModeBackwardDrivingStart         = 52
  DroneModeCliffEvent                   = 53
  DroneModeForwardDrivingEnd            = 54
  DroneModeForwardDrivingLoop           = 55
  DroneModeForwardDrivingStart          = 56
  DroneModeGetIn                        = 57
  DroneModeGetOut                       = 58
  DroneModeIdle                         = 59
  DroneModeKeepAlive                    = 60
  DroneModeTurboDrivingStart            = 61
  FacePlantRoll                         = 62
  FacePlantRollArmUp                    = 63
  FailedToRightFromFace                 = 64
  FlipDownFromBack                      = 65
  FrustratedByFailure                   = 66
  FrustratedByFailureMajor              = 67
  GoToSleepGetIn                        = 68
  GoToSleepGetOut                       = 69
  GoToSleepOff                          = 70
  GoToSleepSleeping                     = 71
  HikingDrivingEnd                      = 72
  HikingDrivingLoop                     = 73
  HikingDrivingStart                    = 74
  HikingInterestingEdgeThought          = 75
  HikingIntro                           = 76
  HikingLookAround                      = 77
  HikingObserve                         = 78
  HikingReactToEdge                     = 79
  HikingReactToNewArea                  = 80
  HikingReactToPossibleMarker           = 81
  HikingSquintEnd                       = 82
  HikingSquintLoop                      = 83
  HikingSquintStart                     = 84
  HikingWakeUpOffCharger                = 85
  IdleOnCharger                         = 86
  InteractWithFaceTrackingIdle          = 87
  InteractWithFacesInitialNamed         = 88
  InteractWithFacesInitialUnnamed       = 89
  KnockOverEyes                         = 90
  KnockOverFailure                      = 91
  KnockOverGrabAttempt                  = 92
  KnockOverPreActionNamedFace           = 93
  KnockOverPreActionUnnamedFace         = 94
  KnockOverSuccess                      = 95
  LookInPlaceForFacesBodyPause          = 96
  LookInPlaceForFacesHeadMovePause      = 97
  MajorFail                             = 98
  MajorWin                              = 99
  MeetCozmoGetIn                        = 100
  MeetCozmoLookFaceGetIn                = 101
  MeetCozmoLookFaceGetOut               = 102
  MeetCozmoScanningIdle                 = 103
  MeetCozmoFirstEnrollmentSayName       = 104
  MeetCozmoFirstEnrollmentRepeatName    = 105
  MeetCozmoFirstEnrollmentCelebration   = 106
  MeetCozmoReEnrollmentSayName          = 107
  MeetCozmoRenameFaceSayName            = 108
  MeetCozmoLookFaceInterrupt            = 109
  MemoryMatchPlayerWinHand              = 110
  MemoryMatchPlayerWinHandLong          = 111
  MemoryMatchPlayerWinHandSolo          = 112
  MemoryMatchPlayerLoseHand             = 113
  MemoryMatchPlayerLoseHandSolo         = 114
  MemoryMatchCozmoWinHand               = 115
  MemoryMatchCozmoLoseHand              = 116
  MemoryMatchCozmoWinGame               = 117
  MemoryMatchPlayerWinGame              = 118
  MemoryMatchSoloGameOver               = 119
  MemoryMatchReactToPattern             = 120
  MemoryMatchReactToPatternSolo         = 121
  MemoryMatchPointCenter                = 122
  MemoryMatchPointLeftBig               = 123
  MemoryMatchPointLeftSmall             = 124
  MemoryMatchPointRightBig              = 125
  MemoryMatchPointRightSmall            = 126
  MemoryMatchPointCenterFast            = 127
  MemoryMatchPointLeftBigFast           = 128
  MemoryMatchPointLeftSmallFast         = 129
  MemoryMatchPointRightBigFast          = 130
  MemoryMatchPointRightSmallFast        = 131
  MemoryMatchCozmoGetOut                = 132
  NamedFaceInitialGreeting              = 133
  NeutralFace                           = 134
  NothingToDoBoredEvent                 = 135
  NothingToDoBoredIdle                  = 136
  NothingToDoBoredIntro                 = 137
  NothingToDoBoredOutro                 = 138
  OnLearnedPlayerName                   = 139
  OnSawNewNamedFace                     = 140
  OnSawNewUnnamedFace                   = 141
  OnSawOldNamedFace                     = 142
  OnSawOldUnnamedFace                   = 143
  OnSpeedtapCozmoConfirm                = 144
  OnSpeedtapFakeout                     = 145
  OnSpeedtapGameCozmoWinHighIntensity   = 146
  OnSpeedtapGameCozmoWinLowIntensity    = 147
  OnSpeedtapGamePlayerWinHighIntensity  = 148
  OnSpeedtapGamePlayerWinLowIntensity   = 149
  OnSpeedtapGetOut                      = 150
  OnSpeedtapHandCozmoWin                = 151
  OnSpeedtapHandPlayerWin               = 152
  OnSpeedtapIdle                        = 153
  OnSpeedtapRoundCozmoWinHighIntensity  = 154
  OnSpeedtapRoundCozmoWinLowIntensity   = 155
  OnSpeedtapRoundPlayerWinHighIntensity = 156
  OnSpeedtapRoundPlayerWinLowIntensity  = 157
  OnSpeedtapTap                         = 158
  OnWaitForCubesMinigameSetup           = 159
  OnWiggle                              = 160
  OnboardingBirth                       = 161
  OnboardingCubeDockFail                = 162
  OnboardingDiscoverCube                = 163
  OnboardingDriveEnd                    = 164
  OnboardingDriveLoop                   = 165
  OnboardingDriveStart                  = 166
  OnboardingEyesOn                      = 167
  OnboardingHelloPlayer                 = 168
  OnboardingHelloWorld                  = 169
  OnboardingIdle                        = 170
  OnboardingInteractWithCube            = 171
  OnboardingPreBirth                    = 172
  OnboardingReactToCube                 = 173
  OnboardingReactToCubePutDown          = 174
  OnboardingReactToFace                 = 175
  OnboardingSoundOnlyLiftEffortPickup   = 176
  OnboardingSoundOnlyLiftEffortPlaceLow = 177
  OnboardingGetOut                      = 178
  PetDetectionCat                       = 179
  PetDetectionDog                       = 180
  PetDetectionShort                     = 181
  PetDetectionShort_Cat                 = 182
  PetDetectionShort_Dog                 = 183
  PetDetectionSneeze                    = 184
  PlacedOnCharger                       = 185
  PopAWheelieInitial                    = 186
  PopAWheeliePreActionNamedFace         = 187
  PopAWheeliePreActionUnnamedFace       = 188
  PopAWheelieRealign                    = 189
  PopAWheelieRetry                      = 190
  PounceDriveEnd                        = 191
  PounceDriveLoop                       = 192
  PounceDriveStart                      = 193
  PounceFace                            = 194
  PounceFail                            = 195
  PounceGetOut                          = 196
  PounceInitial                         = 197
  PouncePounce                          = 198
  PounceSuccess                         = 199
  ProceduralLive                        = 200
  PutDownBlockKeepAlive                 = 201
  PutDownBlockPutDown                   = 202
  ReactToBlockPickupSuccess             = 203
  ReactToBlockRetryPickup               = 204
  ReactToCliff                          = 205
  ReactToCliffDetectorStop              = 206
  ReactToMotorCalibration               = 207
  ReactToNewBlockAsk                    = 208
  ReactToNewBlockBig                    = 209
  ReactToNewBlockSmall                  = 210
  ReactToOnLeftSide                     = 211
  ReactToOnRightSide                    = 212
  ReactToPickup                         = 213
  ReactToPokeReaction                   = 214
  ReactToPokeStartled                   = 215
  ReactToUnexpectedMovement             = 216
  RequestGameDrivingFail                = 217
  RequestGameKeepAwayAccept0            = 218
  RequestGameKeepAwayAccept1            = 219
  RequestGameKeepAwayDeny0              = 220
  RequestGameKeepAwayDeny1              = 221
  RequestGameKeepAwayIdle0              = 222
  RequestGameKeepAwayIdle1              = 223
  RequestGameKeepAwayInitial0           = 224
  RequestGameKeepAwayInitial1           = 225
  RequestGameKeepAwayPreDrive0          = 226
  RequestGameKeepAwayPreDrive1          = 227
  RequestGameKeepAwayRequest0           = 228
  RequestGameKeepAwayRequest1           = 229
  RequestGameMemoryMatchAccept0         = 230
  RequestGameMemoryMatchAccept1         = 231
  RequestGameMemoryMatchDeny0           = 232
  RequestGameMemoryMatchDeny1           = 233
  RequestGameMemoryMatchIdle0           = 234
  RequestGameMemoryMatchIdle1           = 235
  RequestGameMemoryMatchInitial0        = 236
  RequestGameMemoryMatchInitial1        = 237
  RequestGameMemoryMatchPreDrive0       = 238
  RequestGameMemoryMatchPreDrive1       = 239
  RequestGameMemoryMatchRequest0        = 240
  RequestGameMemoryMatchRequest1        = 241
  RequestGamePickupFail                 = 242
  RequestGameSpeedTapAccept0            = 243
  RequestGameSpeedTapAccept1            = 244
  RequestGameSpeedTapDeny0              = 245
  RequestGameSpeedTapDeny1              = 246
  RequestGameSpeedTapIdle0              = 247
  RequestGameSpeedTapIdle1              = 248
  RequestGameSpeedTapInitial0           = 249
  RequestGameSpeedTapInitial1           = 250
  RequestGameSpeedTapPreDrive0          = 251
  RequestGameSpeedTapPreDrive1          = 252
  RequestGameSpeedTapRequest0           = 253
  RequestGameSpeedTapRequest1           = 254
  RollBlockInitial                      = 255
  RollBlockPreActionNamedFace           = 256
  RollBlockPreActionUnnamedFace         = 257
  RollBlockPutDown                      = 258
  RollBlockRealign                      = 259
  RollBlockRetry                        = 260
  RollBlockSuccess                      = 261
  SdkTextToSpeech                       = 262
  Shiver                                = 263
  Shocked                               = 264
  Sleeping                              = 265
  SoftSparkUpgradeLift                  = 266
  SoftSparkUpgradeTracks                = 267
  SoundOnlyLiftEffortPickup             = 268
  SoundOnlyLiftEffortPlaceHigh          = 269
  SoundOnlyLiftEffortPlaceLow           = 270
  SoundOnlyLiftEffortPlaceRoll          = 271
  SoundOnlyTurnSmall                    = 272
  SparkDrivingLoop                      = 273
  SparkDrivingStart                     = 274
  SparkDrivingStop                      = 275
  SparkFailure                          = 276
  SparkGetIn                            = 277
  SparkGetOut                           = 278
  SparkIdle                             = 279
  SparkPickupFinalCubeReaction          = 280
  SparkPickupInitialCubeReaction        = 281
  SparkSuccess                          = 282
  SpeedTapDrivingEnd                    = 283
  SpeedTapDrivingLoop                   = 284
  SpeedTapDrivingStart                  = 285
  StackBlocksPreActionNamedFace         = 286
  StackBlocksPreActionUnnamedFace       = 287
  StackBlocksRetry                      = 288
  StackBlocksSuccess                    = 289
  StartSleeping                         = 290
  SuccessfulWheelie                     = 291
  Surprise                              = 292
  TurtleRoll                            = 293
  UnitTestAnim                          = 294
  WorkoutPickupRealign                  = 295
  WorkoutPickupRetry                    = 296
  WorkoutPostLift_highEnergy            = 297
  WorkoutPostLift_lowEnergy             = 298
  WorkoutPostLift_mediumEnergy          = 299
  WorkoutPreLift_highEnergy             = 300
  WorkoutPreLift_lowEnergy              = 301
  WorkoutPreLift_mediumEnergy           = 302
  WorkoutPutDown_highEnergy             = 303
  WorkoutPutDown_lowEnergy              = 304
  WorkoutPutDown_lowEnergy_simple       = 305
  WorkoutPutDown_mediumEnergy           = 306
  WorkoutStrongLift_highEnergy          = 307
  WorkoutStrongLift_lowEnergy           = 308
  WorkoutStrongLift_mediumEnergy        = 309
  WorkoutTransition_highEnergy          = 310
  WorkoutTransition_lowEnergy           = 311
  WorkoutTransition_mediumEnergy        = 312
  WorkoutWeakLift_highEnergy            = 313
  WorkoutWeakLift_lowEnergy             = 314
  WorkoutWeakLift_mediumEnergy          = 315
  Count                                 = 316

Anki.Cozmo.AnimationTrigger = AnimationTrigger
del AnimationTrigger


