# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/behaviorGroup.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/behaviorGroup.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class BehaviorGroup(object):
  "Automatically-generated uint_8 enumeration."
  Reactionary          = 0
  MiniGame             = 1
  RequestSpeedTap      = 2
  RequestMemoryMatch   = 3
  RequestKeepAway      = 4
  RequestCubePounce    = 5
  RequestFaceEnroll    = 6
  Unlock_CubeRoll      = 7
  FP_Hiking            = 8
  FP_PlayWithHumans    = 9
  FP_PlayAlone         = 10
  FP_Socialize         = 11
  FP_NothingToDo       = 12
  FP_PutDownDispatch   = 13
  SparksRollBlock      = 14
  SparksStackBlock     = 15
  SparksPounceOnMotion = 16
  SparksPopAWheelie    = 17
  SparksPickUpCube     = 18
  SparksKnockOverCubes = 19
  SparksBuildPyramid   = 20
  SparksWorkout        = 21
  MeetCozmo_Socialize  = 22
  ObjectTapInteraction = 23
  Count                = 24

Anki.Cozmo.BehaviorGroup = BehaviorGroup
del BehaviorGroup


