# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/behaviorTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/behaviorTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class BehaviorGameFlag(object):
  "Automatically-generated uint_8 enumeration."
  NoGame      = 0
  SpeedTap    = 0x1
  MemoryMatch = 0x2
  KeepAway    = 0x4
  All         = 0xff

Anki.Cozmo.BehaviorGameFlag = BehaviorGameFlag
del BehaviorGameFlag


class BehaviorType(object):
  "Automatically-generated uint_8 enumeration."
  NoneBehavior               = 0
  LookAround                 = 1
  LookForFaceAndCube         = 2
  InteractWithFaces          = 3
  ReactToCliff               = 4
  ReactToDoubleTap           = 5
  ReactToPet                 = 6
  ReactToPickup              = 7
  ReactToPoke                = 8
  ReactToRobotOnBack         = 9
  ReactToRobotOnSide         = 10
  ReactToRobotOnFace         = 11
  ReactToOnCharger           = 12
  ReactToCubeMoved           = 13
  ReactToFrustration         = 14
  ReactToReturnedToTreads    = 15
  ReactToSparked             = 16
  ReactToPyramid             = 17
  ReactToStackOfCubes        = 18
  PlayAnim                   = 19
  PlayArbitraryAnim          = 20
  PounceOnMotion             = 21
  FindFaces                  = 22
  BringCubeToBeacon          = 23
  ExploreLookAroundInPlace   = 24
  ExploreVisitPossibleMarker = 25
  LookInPlaceMemoryMap       = 26
  ThinkAboutBeacons          = 27
  VisitInterestingEdge       = 28
  RequestGameSimple          = 29
  RollBlock                  = 30
  BuildPyramid               = 31
  BuildPyramidBase           = 32
  StackBlocks                = 33
  PutDownBlock               = 34
  FactoryTest                = 35
  FactoryCentroidExtractor   = 36
  DockingTestSimple          = 37
  DriveOffCharger            = 38
  PopAWheelie                = 39
  KnockOverCubes             = 40
  AcknowledgeObject          = 41
  AcknowledgeFace            = 42
  DrivePath                  = 43
  ReactToUnexpectedMovement  = 44
  ReactToMotorCalibration    = 45
  PickUpCube                 = 46
  CantHandleTallStack        = 47
  OnboardingShowCube         = 48
  OnConfigSeen               = 49
  CubeLiftWorkout            = 50
  CheckForStackAtInterval    = 51
  Count                      = 52

Anki.Cozmo.BehaviorType = BehaviorType
del BehaviorType


class ExecutableBehaviorType(object):
  "Automatically-generated uint_8 enumeration."
  NoneBehavior      = 0
  FindFaces         = 1
  KnockOverCubes    = 2
  LookAroundInPlace = 3
  PounceOnMotion    = 4
  RollBlock         = 5
  StackBlocks       = 6
  Count             = 7

Anki.Cozmo.ExecutableBehaviorType = ExecutableBehaviorType
del ExecutableBehaviorType


