# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/cladRect.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/cladRect.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()

class CladRect(object):
  "Generated message-passing structure."

  __slots__ = (
    '_x_topLeft', # float_32
    '_y_topLeft', # float_32
    '_width',     # float_32
    '_height',    # float_32
  )

  @property
  def x_topLeft(self):
    "float_32 x_topLeft struct property."
    return self._x_topLeft

  @x_topLeft.setter
  def x_topLeft(self, value):
    self._x_topLeft = msgbuffers.validate_float(
      'CladRect.x_topLeft', value, 'f')

  @property
  def y_topLeft(self):
    "float_32 y_topLeft struct property."
    return self._y_topLeft

  @y_topLeft.setter
  def y_topLeft(self, value):
    self._y_topLeft = msgbuffers.validate_float(
      'CladRect.y_topLeft', value, 'f')

  @property
  def width(self):
    "float_32 width struct property."
    return self._width

  @width.setter
  def width(self, value):
    self._width = msgbuffers.validate_float(
      'CladRect.width', value, 'f')

  @property
  def height(self):
    "float_32 height struct property."
    return self._height

  @height.setter
  def height(self, value):
    self._height = msgbuffers.validate_float(
      'CladRect.height', value, 'f')

  def __init__(self, x_topLeft=0.0, y_topLeft=0.0, width=0.0, height=0.0):
    self.x_topLeft = x_topLeft
    self.y_topLeft = y_topLeft
    self.width = width
    self.height = height

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CladRect from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CladRect.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CladRect from the given BinaryReader."
    _x_topLeft = reader.read('f')
    _y_topLeft = reader.read('f')
    _width = reader.read('f')
    _height = reader.read('f')
    return cls(_x_topLeft, _y_topLeft, _width, _height)

  def pack(self):
    "Writes the current CladRect, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CladRect to the given BinaryWriter."
    writer.write(self._x_topLeft, 'f')
    writer.write(self._y_topLeft, 'f')
    writer.write(self._width, 'f')
    writer.write(self._height, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_topLeft == other._x_topLeft and
        self._y_topLeft == other._y_topLeft and
        self._width == other._width and
        self._height == other._height)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_topLeft, 'f') +
      msgbuffers.size(self._y_topLeft, 'f') +
      msgbuffers.size(self._width, 'f') +
      msgbuffers.size(self._height, 'f'))

  def __str__(self):
    return '{type}(x_topLeft={x_topLeft}, y_topLeft={y_topLeft}, width={width}, height={height})'.format(
      type=type(self).__name__,
      x_topLeft=self._x_topLeft,
      y_topLeft=self._y_topLeft,
      width=self._width,
      height=self._height)

  def __repr__(self):
    return '{type}(x_topLeft={x_topLeft}, y_topLeft={y_topLeft}, width={width}, height={height})'.format(
      type=type(self).__name__,
      x_topLeft=repr(self._x_topLeft),
      y_topLeft=repr(self._y_topLeft),
      width=repr(self._width),
      height=repr(self._height))

Anki.CladRect = CladRect
del CladRect


