# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/deviceDataTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/deviceDataTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class DeviceDataType(object):
  "Automatically-generated uint_8 enumeration."
  DeviceID     = 0x0
  DeviceModel  = 1
  AppRunID     = 2
  LastAppRunID = 3
  BuildVersion = 4
  Count        = 5

Anki.Cozmo.DeviceDataType = DeviceDataType
del DeviceDataType


class DeviceDataPair(object):
  "Generated message-passing structure."

  __slots__ = (
    '_dataType',  # Anki.Cozmo.DeviceDataType
    '_dataValue', # string[uint_8]
  )

  @property
  def dataType(self):
    "Anki.Cozmo.DeviceDataType dataType struct property."
    return self._dataType

  @dataType.setter
  def dataType(self, value):
    self._dataType = msgbuffers.validate_integer(
      'DeviceDataPair.dataType', value, 0, 255)

  @property
  def dataValue(self):
    "string[uint_8] dataValue struct property."
    return self._dataValue

  @dataValue.setter
  def dataValue(self, value):
    self._dataValue = msgbuffers.validate_string(
      'DeviceDataPair.dataValue', value, 255)

  def __init__(self, dataType=Anki.Cozmo.DeviceDataType.DeviceID, dataValue=''):
    self.dataType = dataType
    self.dataValue = dataValue

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DeviceDataPair from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DeviceDataPair.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DeviceDataPair from the given BinaryReader."
    _dataType = reader.read('B')
    _dataValue = reader.read_string('B')
    return cls(_dataType, _dataValue)

  def pack(self):
    "Writes the current DeviceDataPair, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DeviceDataPair to the given BinaryWriter."
    writer.write(self._dataType, 'B')
    writer.write_string(self._dataValue, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._dataType == other._dataType and
        self._dataValue == other._dataValue)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._dataType, 'B') +
      msgbuffers.size_string(self._dataValue, 'B'))

  def __str__(self):
    return '{type}(dataType={dataType}, dataValue={dataValue})'.format(
      type=type(self).__name__,
      dataType=self._dataType,
      dataValue=msgbuffers.shorten_string(self._dataValue))

  def __repr__(self):
    return '{type}(dataType={dataType}, dataValue={dataValue})'.format(
      type=type(self).__name__,
      dataType=repr(self._dataType),
      dataValue=repr(self._dataValue))

Anki.Cozmo.DeviceDataPair = DeviceDataPair
del DeviceDataPair


