# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/enrolledFaceStorage.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../coretech/vision/clad/src/ -o ../generated/cladPython// clad/types/enrolledFaceStorage.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Vision = msgbuffers.Namespace()

class FaceRecognitionConstants(object):
  "Automatically-generated uint_16 enumeration."
  EnrolledFaceStorageVersionNumber = 0x2
  MaxNumFacesInAlbum               = 10
  MaxNumAlbumEntriesPerFace        = 5
  MaxNumEnrollDataPerAlbumEntry    = 4

Anki.Vision.FaceRecognitionConstants = FaceRecognitionConstants
del FaceRecognitionConstants


class EnrolledFaceStorage(object):
  "Generated message-passing structure."

  __slots__ = (
    '_enrollmentTimeCount',     # int_64
    '_lastDataUpdateTimeCount', # int_64
    '_albumEntryUpdateTimes',   # int_64[uint_8]
    '_faceID',                  # int_32
    '_albumEntries',            # int_32[uint_8]
    '_name',                    # string[uint_8]
  )

  @property
  def enrollmentTimeCount(self):
    "int_64 enrollmentTimeCount struct property."
    return self._enrollmentTimeCount

  @enrollmentTimeCount.setter
  def enrollmentTimeCount(self, value):
    self._enrollmentTimeCount = msgbuffers.validate_integer(
      'EnrolledFaceStorage.enrollmentTimeCount', value, -9223372036854775808, 9223372036854775807)

  @property
  def lastDataUpdateTimeCount(self):
    "int_64 lastDataUpdateTimeCount struct property."
    return self._lastDataUpdateTimeCount

  @lastDataUpdateTimeCount.setter
  def lastDataUpdateTimeCount(self, value):
    self._lastDataUpdateTimeCount = msgbuffers.validate_integer(
      'EnrolledFaceStorage.lastDataUpdateTimeCount', value, -9223372036854775808, 9223372036854775807)

  @property
  def albumEntryUpdateTimes(self):
    "int_64[uint_8] albumEntryUpdateTimes struct property."
    return self._albumEntryUpdateTimes

  @albumEntryUpdateTimes.setter
  def albumEntryUpdateTimes(self, value):
    self._albumEntryUpdateTimes = msgbuffers.validate_varray(
      'EnrolledFaceStorage.albumEntryUpdateTimes', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -9223372036854775808, 9223372036854775807))

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'EnrolledFaceStorage.faceID', value, -2147483648, 2147483647)

  @property
  def albumEntries(self):
    "int_32[uint_8] albumEntries struct property."
    return self._albumEntries

  @albumEntries.setter
  def albumEntries(self, value):
    self._albumEntries = msgbuffers.validate_varray(
      'EnrolledFaceStorage.albumEntries', value, 255,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'EnrolledFaceStorage.name', value, 255)

  def __init__(self, enrollmentTimeCount=0, lastDataUpdateTimeCount=0, albumEntryUpdateTimes=(), faceID=0, albumEntries=(), name=''):
    self.enrollmentTimeCount = enrollmentTimeCount
    self.lastDataUpdateTimeCount = lastDataUpdateTimeCount
    self.albumEntryUpdateTimes = albumEntryUpdateTimes
    self.faceID = faceID
    self.albumEntries = albumEntries
    self.name = name

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EnrolledFaceStorage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EnrolledFaceStorage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EnrolledFaceStorage from the given BinaryReader."
    _enrollmentTimeCount = reader.read('q')
    _lastDataUpdateTimeCount = reader.read('q')
    _albumEntryUpdateTimes = reader.read_varray('q', 'B')
    _faceID = reader.read('i')
    _albumEntries = reader.read_varray('i', 'B')
    _name = reader.read_string('B')
    return cls(_enrollmentTimeCount, _lastDataUpdateTimeCount, _albumEntryUpdateTimes, _faceID, _albumEntries, _name)

  def pack(self):
    "Writes the current EnrolledFaceStorage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EnrolledFaceStorage to the given BinaryWriter."
    writer.write(self._enrollmentTimeCount, 'q')
    writer.write(self._lastDataUpdateTimeCount, 'q')
    writer.write_varray(self._albumEntryUpdateTimes, 'q', 'B')
    writer.write(self._faceID, 'i')
    writer.write_varray(self._albumEntries, 'i', 'B')
    writer.write_string(self._name, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enrollmentTimeCount == other._enrollmentTimeCount and
        self._lastDataUpdateTimeCount == other._lastDataUpdateTimeCount and
        self._albumEntryUpdateTimes == other._albumEntryUpdateTimes and
        self._faceID == other._faceID and
        self._albumEntries == other._albumEntries and
        self._name == other._name)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enrollmentTimeCount, 'q') +
      msgbuffers.size(self._lastDataUpdateTimeCount, 'q') +
      msgbuffers.size_varray(self._albumEntryUpdateTimes, 'q', 'B') +
      msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size_varray(self._albumEntries, 'i', 'B') +
      msgbuffers.size_string(self._name, 'B'))

  def __str__(self):
    return '{type}(enrollmentTimeCount={enrollmentTimeCount}, lastDataUpdateTimeCount={lastDataUpdateTimeCount}, albumEntryUpdateTimes={albumEntryUpdateTimes}, faceID={faceID}, albumEntries={albumEntries}, name={name})'.format(
      type=type(self).__name__,
      enrollmentTimeCount=self._enrollmentTimeCount,
      lastDataUpdateTimeCount=self._lastDataUpdateTimeCount,
      albumEntryUpdateTimes=msgbuffers.shorten_sequence(self._albumEntryUpdateTimes),
      faceID=self._faceID,
      albumEntries=msgbuffers.shorten_sequence(self._albumEntries),
      name=msgbuffers.shorten_string(self._name))

  def __repr__(self):
    return '{type}(enrollmentTimeCount={enrollmentTimeCount}, lastDataUpdateTimeCount={lastDataUpdateTimeCount}, albumEntryUpdateTimes={albumEntryUpdateTimes}, faceID={faceID}, albumEntries={albumEntries}, name={name})'.format(
      type=type(self).__name__,
      enrollmentTimeCount=repr(self._enrollmentTimeCount),
      lastDataUpdateTimeCount=repr(self._lastDataUpdateTimeCount),
      albumEntryUpdateTimes=repr(self._albumEntryUpdateTimes),
      faceID=repr(self._faceID),
      albumEntries=repr(self._albumEntries),
      name=repr(self._name))

Anki.Vision.EnrolledFaceStorage = EnrolledFaceStorage
del EnrolledFaceStorage


