# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/featureGateTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/featureGateTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class FeatureType(object):
  "Automatically-generated uint_8 enumeration."
  Dummy                 = 0
  ObjectTapInteractions = 1

Anki.Cozmo.FeatureType = FeatureType
del FeatureType


class FeatureToggle(object):
  "Generated message-passing structure."

  __slots__ = (
    '_name',    # string[uint_8]
    '_enabled', # bool
  )

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'FeatureToggle.name', value, 255)

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'FeatureToggle.enabled', value)

  def __init__(self, name='', enabled=False):
    self.name = name
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FeatureToggle from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FeatureToggle.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FeatureToggle from the given BinaryReader."
    _name = reader.read_string('B')
    _enabled = bool(reader.read('b'))
    return cls(_name, _enabled)

  def pack(self):
    "Writes the current FeatureToggle, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FeatureToggle to the given BinaryWriter."
    writer.write_string(self._name, 'B')
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._name == other._name and
        self._enabled == other._enabled)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._name, 'B') +
      msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(name={name}, enabled={enabled})'.format(
      type=type(self).__name__,
      name=msgbuffers.shorten_string(self._name),
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(name={name}, enabled={enabled})'.format(
      type=type(self).__name__,
      name=repr(self._name),
      enabled=repr(self._enabled))

Anki.Cozmo.FeatureToggle = FeatureToggle
del FeatureToggle


