# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/firmwareTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/firmwareTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class FirmwareUpdateResult(object):
  "Automatically-generated uint_8 enumeration."
  Success              = 0
  Failed_NoRobots      = 1
  Failed_LoadingFile   = 2
  Failed_LostAllRobots = 3
  Failed_SendingData   = 4
  Failed_NoResponse    = 5

Anki.Cozmo.FirmwareUpdateResult = FirmwareUpdateResult
del FirmwareUpdateResult


class FirmwareUpdateStage(object):
  "Automatically-generated uint_8 enumeration."
  Flashing = 0
  Done     = 1
  Failed   = 2

Anki.Cozmo.FirmwareUpdateStage = FirmwareUpdateStage
del FirmwareUpdateStage


class FirmwareUpdateSubStage(object):
  "Automatically-generated uint_8 enumeration."
  Init           = 0
  LoadingFile    = 1
  Flash          = 2
  SendFlashEOF   = 3
  WaitOTAUpgrade = 4

Anki.Cozmo.FirmwareUpdateSubStage = FirmwareUpdateSubStage
del FirmwareUpdateSubStage


class FirmwareType(object):
  "Automatically-generated uint_8 enumeration."
  Current = 0
  Old     = 1

Anki.Cozmo.FirmwareType = FirmwareType
del FirmwareType


