# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/globalVizOrigin.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/globalVizOrigin.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class SetVizOrigin(object):
  "Generated message-passing message."

  __slots__ = (
    '_rot_rad',    # float_32
    '_rot_axis_x', # float_32
    '_rot_axis_y', # float_32
    '_rot_axis_z', # float_32
    '_trans_x_mm', # float_32
    '_trans_y_mm', # float_32
    '_trans_z_mm', # float_32
  )

  @property
  def rot_rad(self):
    "float_32 rot_rad struct property."
    return self._rot_rad

  @rot_rad.setter
  def rot_rad(self, value):
    self._rot_rad = msgbuffers.validate_float(
      'SetVizOrigin.rot_rad', value, 'f')

  @property
  def rot_axis_x(self):
    "float_32 rot_axis_x struct property."
    return self._rot_axis_x

  @rot_axis_x.setter
  def rot_axis_x(self, value):
    self._rot_axis_x = msgbuffers.validate_float(
      'SetVizOrigin.rot_axis_x', value, 'f')

  @property
  def rot_axis_y(self):
    "float_32 rot_axis_y struct property."
    return self._rot_axis_y

  @rot_axis_y.setter
  def rot_axis_y(self, value):
    self._rot_axis_y = msgbuffers.validate_float(
      'SetVizOrigin.rot_axis_y', value, 'f')

  @property
  def rot_axis_z(self):
    "float_32 rot_axis_z struct property."
    return self._rot_axis_z

  @rot_axis_z.setter
  def rot_axis_z(self, value):
    self._rot_axis_z = msgbuffers.validate_float(
      'SetVizOrigin.rot_axis_z', value, 'f')

  @property
  def trans_x_mm(self):
    "float_32 trans_x_mm struct property."
    return self._trans_x_mm

  @trans_x_mm.setter
  def trans_x_mm(self, value):
    self._trans_x_mm = msgbuffers.validate_float(
      'SetVizOrigin.trans_x_mm', value, 'f')

  @property
  def trans_y_mm(self):
    "float_32 trans_y_mm struct property."
    return self._trans_y_mm

  @trans_y_mm.setter
  def trans_y_mm(self, value):
    self._trans_y_mm = msgbuffers.validate_float(
      'SetVizOrigin.trans_y_mm', value, 'f')

  @property
  def trans_z_mm(self):
    "float_32 trans_z_mm struct property."
    return self._trans_z_mm

  @trans_z_mm.setter
  def trans_z_mm(self, value):
    self._trans_z_mm = msgbuffers.validate_float(
      'SetVizOrigin.trans_z_mm', value, 'f')

  def __init__(self, rot_rad=0.0, rot_axis_x=0.0, rot_axis_y=0.0, rot_axis_z=0.0, trans_x_mm=0.0, trans_y_mm=0.0, trans_z_mm=0.0):
    self.rot_rad = rot_rad
    self.rot_axis_x = rot_axis_x
    self.rot_axis_y = rot_axis_y
    self.rot_axis_z = rot_axis_z
    self.trans_x_mm = trans_x_mm
    self.trans_y_mm = trans_y_mm
    self.trans_z_mm = trans_z_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetVizOrigin from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetVizOrigin.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetVizOrigin from the given BinaryReader."
    _rot_rad = reader.read('f')
    _rot_axis_x = reader.read('f')
    _rot_axis_y = reader.read('f')
    _rot_axis_z = reader.read('f')
    _trans_x_mm = reader.read('f')
    _trans_y_mm = reader.read('f')
    _trans_z_mm = reader.read('f')
    return cls(_rot_rad, _rot_axis_x, _rot_axis_y, _rot_axis_z, _trans_x_mm, _trans_y_mm, _trans_z_mm)

  def pack(self):
    "Writes the current SetVizOrigin, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetVizOrigin to the given BinaryWriter."
    writer.write(self._rot_rad, 'f')
    writer.write(self._rot_axis_x, 'f')
    writer.write(self._rot_axis_y, 'f')
    writer.write(self._rot_axis_z, 'f')
    writer.write(self._trans_x_mm, 'f')
    writer.write(self._trans_y_mm, 'f')
    writer.write(self._trans_z_mm, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._rot_rad == other._rot_rad and
        self._rot_axis_x == other._rot_axis_x and
        self._rot_axis_y == other._rot_axis_y and
        self._rot_axis_z == other._rot_axis_z and
        self._trans_x_mm == other._trans_x_mm and
        self._trans_y_mm == other._trans_y_mm and
        self._trans_z_mm == other._trans_z_mm)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._rot_rad, 'f') +
      msgbuffers.size(self._rot_axis_x, 'f') +
      msgbuffers.size(self._rot_axis_y, 'f') +
      msgbuffers.size(self._rot_axis_z, 'f') +
      msgbuffers.size(self._trans_x_mm, 'f') +
      msgbuffers.size(self._trans_y_mm, 'f') +
      msgbuffers.size(self._trans_z_mm, 'f'))

  def __str__(self):
    return '{type}(rot_rad={rot_rad}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, trans_x_mm={trans_x_mm}, trans_y_mm={trans_y_mm}, trans_z_mm={trans_z_mm})'.format(
      type=type(self).__name__,
      rot_rad=self._rot_rad,
      rot_axis_x=self._rot_axis_x,
      rot_axis_y=self._rot_axis_y,
      rot_axis_z=self._rot_axis_z,
      trans_x_mm=self._trans_x_mm,
      trans_y_mm=self._trans_y_mm,
      trans_z_mm=self._trans_z_mm)

  def __repr__(self):
    return '{type}(rot_rad={rot_rad}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, trans_x_mm={trans_x_mm}, trans_y_mm={trans_y_mm}, trans_z_mm={trans_z_mm})'.format(
      type=type(self).__name__,
      rot_rad=repr(self._rot_rad),
      rot_axis_x=repr(self._rot_axis_x),
      rot_axis_y=repr(self._rot_axis_y),
      rot_axis_z=repr(self._rot_axis_z),
      trans_x_mm=repr(self._trans_x_mm),
      trans_y_mm=repr(self._trans_y_mm),
      trans_z_mm=repr(self._trans_z_mm))

Anki.Cozmo.SetVizOrigin = SetVizOrigin
del SetVizOrigin


