# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/imageTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/imageTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class ImageResolution(object):
  "Automatically-generated int_8 enumeration."
  VerificationSnapshot = 0
  QQQQVGA              = 1
  QQQVGA               = 2
  QQVGA                = 3
  QVGA                 = 4
  CVGA                 = 5
  VGA                  = 6
  SVGA                 = 7
  XGA                  = 8
  SXGA                 = 9
  UXGA                 = 10
  QXGA                 = 11
  QUXGA                = 12
  ImageResolutionCount = 13
  ImageResolutionNone  = 14

Anki.Cozmo.ImageResolution = ImageResolution
del ImageResolution


class ImageEncoding(object):
  "Automatically-generated uint_8 enumeration."
  NoneImageEncoding  = 0
  RawGray            = 1
  RawRGB             = 2
  YUYV               = 3
  BAYER              = 4
  JPEGGray           = 5
  JPEGColor          = 6
  JPEGColorHalfWidth = 7
  JPEGMinimizedGray  = 8
  JPEGMinimizedColor = 9

Anki.Cozmo.ImageEncoding = ImageEncoding
del ImageEncoding


class ImageSendMode(object):
  "Automatically-generated uint_8 enumeration."
  Off        = 0
  Stream     = 1
  SingleShot = 2

Anki.Cozmo.ImageSendMode = ImageSendMode
del ImageSendMode


class ImageConstants(object):
  "Automatically-generated uint_32 enumeration."
  IMAGE_CHUNK_SIZE = 1200

Anki.Cozmo.ImageConstants = ImageConstants
del ImageConstants


class ImageChunk(object):
  "Generated message-passing message."

  __slots__ = (
    '_frameTimeStamp',  # uint_32
    '_imageId',         # uint_32
    '_chunkDebug',      # int_32
    '_imageEncoding',   # Anki.Cozmo.ImageEncoding
    '_resolution',      # Anki.Cozmo.ImageResolution
    '_imageChunkCount', # uint_8
    '_chunkId',         # uint_8
    '_status',          # int_16
    '_data',            # uint_8[uint_16]
  )

  @property
  def frameTimeStamp(self):
    "uint_32 frameTimeStamp struct property."
    return self._frameTimeStamp

  @frameTimeStamp.setter
  def frameTimeStamp(self, value):
    self._frameTimeStamp = msgbuffers.validate_integer(
      'ImageChunk.frameTimeStamp', value, 0, 4294967295)

  @property
  def imageId(self):
    "uint_32 imageId struct property."
    return self._imageId

  @imageId.setter
  def imageId(self, value):
    self._imageId = msgbuffers.validate_integer(
      'ImageChunk.imageId', value, 0, 4294967295)

  @property
  def chunkDebug(self):
    "int_32 chunkDebug struct property."
    return self._chunkDebug

  @chunkDebug.setter
  def chunkDebug(self, value):
    self._chunkDebug = msgbuffers.validate_integer(
      'ImageChunk.chunkDebug', value, -2147483648, 2147483647)

  @property
  def imageEncoding(self):
    "Anki.Cozmo.ImageEncoding imageEncoding struct property."
    return self._imageEncoding

  @imageEncoding.setter
  def imageEncoding(self, value):
    self._imageEncoding = msgbuffers.validate_integer(
      'ImageChunk.imageEncoding', value, 0, 255)

  @property
  def resolution(self):
    "Anki.Cozmo.ImageResolution resolution struct property."
    return self._resolution

  @resolution.setter
  def resolution(self, value):
    self._resolution = msgbuffers.validate_integer(
      'ImageChunk.resolution', value, -128, 127)

  @property
  def imageChunkCount(self):
    "uint_8 imageChunkCount struct property."
    return self._imageChunkCount

  @imageChunkCount.setter
  def imageChunkCount(self, value):
    self._imageChunkCount = msgbuffers.validate_integer(
      'ImageChunk.imageChunkCount', value, 0, 255)

  @property
  def chunkId(self):
    "uint_8 chunkId struct property."
    return self._chunkId

  @chunkId.setter
  def chunkId(self, value):
    self._chunkId = msgbuffers.validate_integer(
      'ImageChunk.chunkId', value, 0, 255)

  @property
  def status(self):
    "int_16 status struct property."
    return self._status

  @status.setter
  def status(self, value):
    self._status = msgbuffers.validate_integer(
      'ImageChunk.status', value, -32768, 32767)

  @property
  def data(self):
    "uint_8[uint_16] data struct property."
    return self._data

  @data.setter
  def data(self, value):
    self._data = msgbuffers.validate_varray(
      'ImageChunk.data', value, 65535,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, 0, 255))

  def __init__(self, frameTimeStamp=0, imageId=0, chunkDebug=0, imageEncoding=Anki.Cozmo.ImageEncoding.NoneImageEncoding, resolution=Anki.Cozmo.ImageResolution.VerificationSnapshot, imageChunkCount=0, chunkId=0, status=0, data=()):
    self.frameTimeStamp = frameTimeStamp
    self.imageId = imageId
    self.chunkDebug = chunkDebug
    self.imageEncoding = imageEncoding
    self.resolution = resolution
    self.imageChunkCount = imageChunkCount
    self.chunkId = chunkId
    self.status = status
    self.data = data

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ImageChunk from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ImageChunk.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ImageChunk from the given BinaryReader."
    _frameTimeStamp = reader.read('I')
    _imageId = reader.read('I')
    _chunkDebug = reader.read('i')
    _imageEncoding = reader.read('B')
    _resolution = reader.read('b')
    _imageChunkCount = reader.read('B')
    _chunkId = reader.read('B')
    _status = reader.read('h')
    _data = reader.read_varray('B', 'H')
    return cls(_frameTimeStamp, _imageId, _chunkDebug, _imageEncoding, _resolution, _imageChunkCount, _chunkId, _status, _data)

  def pack(self):
    "Writes the current ImageChunk, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ImageChunk to the given BinaryWriter."
    writer.write(self._frameTimeStamp, 'I')
    writer.write(self._imageId, 'I')
    writer.write(self._chunkDebug, 'i')
    writer.write(self._imageEncoding, 'B')
    writer.write(self._resolution, 'b')
    writer.write(self._imageChunkCount, 'B')
    writer.write(self._chunkId, 'B')
    writer.write(self._status, 'h')
    writer.write_varray(self._data, 'B', 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._frameTimeStamp == other._frameTimeStamp and
        self._imageId == other._imageId and
        self._chunkDebug == other._chunkDebug and
        self._imageEncoding == other._imageEncoding and
        self._resolution == other._resolution and
        self._imageChunkCount == other._imageChunkCount and
        self._chunkId == other._chunkId and
        self._status == other._status and
        self._data == other._data)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._frameTimeStamp, 'I') +
      msgbuffers.size(self._imageId, 'I') +
      msgbuffers.size(self._chunkDebug, 'i') +
      msgbuffers.size(self._imageEncoding, 'B') +
      msgbuffers.size(self._resolution, 'b') +
      msgbuffers.size(self._imageChunkCount, 'B') +
      msgbuffers.size(self._chunkId, 'B') +
      msgbuffers.size(self._status, 'h') +
      msgbuffers.size_varray(self._data, 'B', 'H'))

  def __str__(self):
    return '{type}(frameTimeStamp={frameTimeStamp}, imageId={imageId}, chunkDebug={chunkDebug}, imageEncoding={imageEncoding}, resolution={resolution}, imageChunkCount={imageChunkCount}, chunkId={chunkId}, status={status}, data={data})'.format(
      type=type(self).__name__,
      frameTimeStamp=self._frameTimeStamp,
      imageId=self._imageId,
      chunkDebug=self._chunkDebug,
      imageEncoding=self._imageEncoding,
      resolution=self._resolution,
      imageChunkCount=self._imageChunkCount,
      chunkId=self._chunkId,
      status=self._status,
      data=msgbuffers.shorten_sequence(self._data))

  def __repr__(self):
    return '{type}(frameTimeStamp={frameTimeStamp}, imageId={imageId}, chunkDebug={chunkDebug}, imageEncoding={imageEncoding}, resolution={resolution}, imageChunkCount={imageChunkCount}, chunkId={chunkId}, status={status}, data={data})'.format(
      type=type(self).__name__,
      frameTimeStamp=repr(self._frameTimeStamp),
      imageId=repr(self._imageId),
      chunkDebug=repr(self._chunkDebug),
      imageEncoding=repr(self._imageEncoding),
      resolution=repr(self._resolution),
      imageChunkCount=repr(self._imageChunkCount),
      chunkId=repr(self._chunkId),
      status=repr(self._status),
      data=repr(self._data))

Anki.Cozmo.ImageChunk = ImageChunk
del ImageChunk


class ImageImuData(object):
  "Generated message-passing message."

  __slots__ = (
    '_imageId',     # uint_32
    '_rateX',       # float_32
    '_rateY',       # float_32
    '_rateZ',       # float_32
    '_line2Number', # uint_8
  )

  @property
  def imageId(self):
    "uint_32 imageId struct property."
    return self._imageId

  @imageId.setter
  def imageId(self, value):
    self._imageId = msgbuffers.validate_integer(
      'ImageImuData.imageId', value, 0, 4294967295)

  @property
  def rateX(self):
    "float_32 rateX struct property."
    return self._rateX

  @rateX.setter
  def rateX(self, value):
    self._rateX = msgbuffers.validate_float(
      'ImageImuData.rateX', value, 'f')

  @property
  def rateY(self):
    "float_32 rateY struct property."
    return self._rateY

  @rateY.setter
  def rateY(self, value):
    self._rateY = msgbuffers.validate_float(
      'ImageImuData.rateY', value, 'f')

  @property
  def rateZ(self):
    "float_32 rateZ struct property."
    return self._rateZ

  @rateZ.setter
  def rateZ(self, value):
    self._rateZ = msgbuffers.validate_float(
      'ImageImuData.rateZ', value, 'f')

  @property
  def line2Number(self):
    "uint_8 line2Number struct property."
    return self._line2Number

  @line2Number.setter
  def line2Number(self, value):
    self._line2Number = msgbuffers.validate_integer(
      'ImageImuData.line2Number', value, 0, 255)

  def __init__(self, imageId=0, rateX=0.0, rateY=0.0, rateZ=0.0, line2Number=0):
    self.imageId = imageId
    self.rateX = rateX
    self.rateY = rateY
    self.rateZ = rateZ
    self.line2Number = line2Number

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ImageImuData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ImageImuData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ImageImuData from the given BinaryReader."
    _imageId = reader.read('I')
    _rateX = reader.read('f')
    _rateY = reader.read('f')
    _rateZ = reader.read('f')
    _line2Number = reader.read('B')
    return cls(_imageId, _rateX, _rateY, _rateZ, _line2Number)

  def pack(self):
    "Writes the current ImageImuData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ImageImuData to the given BinaryWriter."
    writer.write(self._imageId, 'I')
    writer.write(self._rateX, 'f')
    writer.write(self._rateY, 'f')
    writer.write(self._rateZ, 'f')
    writer.write(self._line2Number, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._imageId == other._imageId and
        self._rateX == other._rateX and
        self._rateY == other._rateY and
        self._rateZ == other._rateZ and
        self._line2Number == other._line2Number)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._imageId, 'I') +
      msgbuffers.size(self._rateX, 'f') +
      msgbuffers.size(self._rateY, 'f') +
      msgbuffers.size(self._rateZ, 'f') +
      msgbuffers.size(self._line2Number, 'B'))

  def __str__(self):
    return '{type}(imageId={imageId}, rateX={rateX}, rateY={rateY}, rateZ={rateZ}, line2Number={line2Number})'.format(
      type=type(self).__name__,
      imageId=self._imageId,
      rateX=self._rateX,
      rateY=self._rateY,
      rateZ=self._rateZ,
      line2Number=self._line2Number)

  def __repr__(self):
    return '{type}(imageId={imageId}, rateX={rateX}, rateY={rateY}, rateZ={rateZ}, line2Number={line2Number})'.format(
      type=type(self).__name__,
      imageId=repr(self._imageId),
      rateX=repr(self._rateX),
      rateY=repr(self._rateY),
      rateZ=repr(self._rateZ),
      line2Number=repr(self._line2Number))

Anki.Cozmo.ImageImuData = ImageImuData
del ImageImuData


class CameraCalibration(object):
  "Generated message-passing message."

  __slots__ = (
    '_focalLength_x', # float_32
    '_focalLength_y', # float_32
    '_center_x',      # float_32
    '_center_y',      # float_32
    '_skew',          # float_32
    '_nrows',         # uint_16
    '_ncols',         # uint_16
    '_distCoeffs',    # float_32[8]
  )

  @property
  def focalLength_x(self):
    "float_32 focalLength_x struct property."
    return self._focalLength_x

  @focalLength_x.setter
  def focalLength_x(self, value):
    self._focalLength_x = msgbuffers.validate_float(
      'CameraCalibration.focalLength_x', value, 'f')

  @property
  def focalLength_y(self):
    "float_32 focalLength_y struct property."
    return self._focalLength_y

  @focalLength_y.setter
  def focalLength_y(self, value):
    self._focalLength_y = msgbuffers.validate_float(
      'CameraCalibration.focalLength_y', value, 'f')

  @property
  def center_x(self):
    "float_32 center_x struct property."
    return self._center_x

  @center_x.setter
  def center_x(self, value):
    self._center_x = msgbuffers.validate_float(
      'CameraCalibration.center_x', value, 'f')

  @property
  def center_y(self):
    "float_32 center_y struct property."
    return self._center_y

  @center_y.setter
  def center_y(self, value):
    self._center_y = msgbuffers.validate_float(
      'CameraCalibration.center_y', value, 'f')

  @property
  def skew(self):
    "float_32 skew struct property."
    return self._skew

  @skew.setter
  def skew(self, value):
    self._skew = msgbuffers.validate_float(
      'CameraCalibration.skew', value, 'f')

  @property
  def nrows(self):
    "uint_16 nrows struct property."
    return self._nrows

  @nrows.setter
  def nrows(self, value):
    self._nrows = msgbuffers.validate_integer(
      'CameraCalibration.nrows', value, 0, 65535)

  @property
  def ncols(self):
    "uint_16 ncols struct property."
    return self._ncols

  @ncols.setter
  def ncols(self, value):
    self._ncols = msgbuffers.validate_integer(
      'CameraCalibration.ncols', value, 0, 65535)

  @property
  def distCoeffs(self):
    "float_32[8] distCoeffs struct property."
    return self._distCoeffs

  @distCoeffs.setter
  def distCoeffs(self, value):
    self._distCoeffs = msgbuffers.validate_farray(
      'CameraCalibration.distCoeffs', value, 8,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  def __init__(self, focalLength_x=0.0, focalLength_y=0.0, center_x=0.0, center_y=0.0, skew=0.0, nrows=0, ncols=0, distCoeffs=(0.0,) * 8):
    self.focalLength_x = focalLength_x
    self.focalLength_y = focalLength_y
    self.center_x = center_x
    self.center_y = center_y
    self.skew = skew
    self.nrows = nrows
    self.ncols = ncols
    self.distCoeffs = distCoeffs

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraCalibration from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraCalibration.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraCalibration from the given BinaryReader."
    _focalLength_x = reader.read('f')
    _focalLength_y = reader.read('f')
    _center_x = reader.read('f')
    _center_y = reader.read('f')
    _skew = reader.read('f')
    _nrows = reader.read('H')
    _ncols = reader.read('H')
    _distCoeffs = reader.read_farray('f', 8)
    return cls(_focalLength_x, _focalLength_y, _center_x, _center_y, _skew, _nrows, _ncols, _distCoeffs)

  def pack(self):
    "Writes the current CameraCalibration, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraCalibration to the given BinaryWriter."
    writer.write(self._focalLength_x, 'f')
    writer.write(self._focalLength_y, 'f')
    writer.write(self._center_x, 'f')
    writer.write(self._center_y, 'f')
    writer.write(self._skew, 'f')
    writer.write(self._nrows, 'H')
    writer.write(self._ncols, 'H')
    writer.write_farray(self._distCoeffs, 'f', 8)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._focalLength_x == other._focalLength_x and
        self._focalLength_y == other._focalLength_y and
        self._center_x == other._center_x and
        self._center_y == other._center_y and
        self._skew == other._skew and
        self._nrows == other._nrows and
        self._ncols == other._ncols and
        self._distCoeffs == other._distCoeffs)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._focalLength_x, 'f') +
      msgbuffers.size(self._focalLength_y, 'f') +
      msgbuffers.size(self._center_x, 'f') +
      msgbuffers.size(self._center_y, 'f') +
      msgbuffers.size(self._skew, 'f') +
      msgbuffers.size(self._nrows, 'H') +
      msgbuffers.size(self._ncols, 'H') +
      msgbuffers.size_farray(self._distCoeffs, 'f', 8))

  def __str__(self):
    return '{type}(focalLength_x={focalLength_x}, focalLength_y={focalLength_y}, center_x={center_x}, center_y={center_y}, skew={skew}, nrows={nrows}, ncols={ncols}, distCoeffs={distCoeffs})'.format(
      type=type(self).__name__,
      focalLength_x=self._focalLength_x,
      focalLength_y=self._focalLength_y,
      center_x=self._center_x,
      center_y=self._center_y,
      skew=self._skew,
      nrows=self._nrows,
      ncols=self._ncols,
      distCoeffs=msgbuffers.shorten_sequence(self._distCoeffs))

  def __repr__(self):
    return '{type}(focalLength_x={focalLength_x}, focalLength_y={focalLength_y}, center_x={center_x}, center_y={center_y}, skew={skew}, nrows={nrows}, ncols={ncols}, distCoeffs={distCoeffs})'.format(
      type=type(self).__name__,
      focalLength_x=repr(self._focalLength_x),
      focalLength_y=repr(self._focalLength_y),
      center_x=repr(self._center_x),
      center_y=repr(self._center_y),
      skew=repr(self._skew),
      nrows=repr(self._nrows),
      ncols=repr(self._ncols),
      distCoeffs=repr(self._distCoeffs))

Anki.Cozmo.CameraCalibration = CameraCalibration
del CameraCalibration


class ImageQuality(object):
  "Automatically-generated uint_8 enumeration."
  Unchecked = 0
  Good      = 1
  TooDark   = 2
  TooBright = 3

Anki.Cozmo.ImageQuality = ImageQuality
del ImageQuality


