# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/liveIdleAnimationParameters.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/liveIdleAnimationParameters.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class LiveIdleAnimationParameter(object):
  "Automatically-generated uint_8 enumeration."
  EnableKeepFaceAlive          = 0
  BlinkSpacingMinTime_ms       = 1
  BlinkSpacingMaxTime_ms       = 2
  TimeBeforeWiggleMotions_ms   = 3
  BodyMovementSpacingMin_ms    = 4
  BodyMovementSpacingMax_ms    = 5
  BodyMovementDurationMin_ms   = 6
  BodyMovementDurationMax_ms   = 7
  BodyMovementSpeedMinMax_mmps = 8
  BodyMovementStraightFraction = 9
  LiftMovementDurationMin_ms   = 10
  LiftMovementDurationMax_ms   = 11
  LiftMovementSpacingMin_ms    = 12
  LiftMovementSpacingMax_ms    = 13
  LiftHeightMean_mm            = 14
  LiftHeightVariability_mm     = 15
  HeadMovementDurationMin_ms   = 16
  HeadMovementDurationMax_ms   = 17
  HeadMovementSpacingMin_ms    = 18
  HeadMovementSpacingMax_ms    = 19
  HeadAngleVariability_deg     = 20
  EyeDartSpacingMinTime_ms     = 21
  EyeDartSpacingMaxTime_ms     = 22
  EyeDartMaxDistance_pix       = 23
  EyeDartMinScale              = 24
  EyeDartMaxScale              = 25
  EyeDartMinDuration_ms        = 26
  EyeDartMaxDuration_ms        = 27
  EyeDartOuterEyeScaleIncrease = 28
  EyeDartUpMaxScale            = 29
  EyeDartDownMinScale          = 30
  NumParameters                = 31

Anki.Cozmo.LiveIdleAnimationParameter = LiveIdleAnimationParameter
del LiveIdleAnimationParameter


