# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/loadedKnownFace.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../coretech/vision/clad/src/ -o ../generated/cladPython// clad/types/loadedKnownFace.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Vision = msgbuffers.Namespace()

class LoadedKnownFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_secondsSinceFirstEnrolled', # int_64
    '_secondsSinceLastUpdated',   # int_64
    '_secondsSinceLastSeen',      # int_64
    '_faceID',                    # int_32
    '_name',                      # string[uint_8]
  )

  @property
  def secondsSinceFirstEnrolled(self):
    "int_64 secondsSinceFirstEnrolled struct property."
    return self._secondsSinceFirstEnrolled

  @secondsSinceFirstEnrolled.setter
  def secondsSinceFirstEnrolled(self, value):
    self._secondsSinceFirstEnrolled = msgbuffers.validate_integer(
      'LoadedKnownFace.secondsSinceFirstEnrolled', value, -9223372036854775808, 9223372036854775807)

  @property
  def secondsSinceLastUpdated(self):
    "int_64 secondsSinceLastUpdated struct property."
    return self._secondsSinceLastUpdated

  @secondsSinceLastUpdated.setter
  def secondsSinceLastUpdated(self, value):
    self._secondsSinceLastUpdated = msgbuffers.validate_integer(
      'LoadedKnownFace.secondsSinceLastUpdated', value, -9223372036854775808, 9223372036854775807)

  @property
  def secondsSinceLastSeen(self):
    "int_64 secondsSinceLastSeen struct property."
    return self._secondsSinceLastSeen

  @secondsSinceLastSeen.setter
  def secondsSinceLastSeen(self, value):
    self._secondsSinceLastSeen = msgbuffers.validate_integer(
      'LoadedKnownFace.secondsSinceLastSeen', value, -9223372036854775808, 9223372036854775807)

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'LoadedKnownFace.faceID', value, -2147483648, 2147483647)

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'LoadedKnownFace.name', value, 255)

  def __init__(self, secondsSinceFirstEnrolled=0, secondsSinceLastUpdated=0, secondsSinceLastSeen=0, faceID=0, name=''):
    self.secondsSinceFirstEnrolled = secondsSinceFirstEnrolled
    self.secondsSinceLastUpdated = secondsSinceLastUpdated
    self.secondsSinceLastSeen = secondsSinceLastSeen
    self.faceID = faceID
    self.name = name

  @classmethod
  def unpack(cls, buffer):
    "Reads a new LoadedKnownFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('LoadedKnownFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new LoadedKnownFace from the given BinaryReader."
    _secondsSinceFirstEnrolled = reader.read('q')
    _secondsSinceLastUpdated = reader.read('q')
    _secondsSinceLastSeen = reader.read('q')
    _faceID = reader.read('i')
    _name = reader.read_string('B')
    return cls(_secondsSinceFirstEnrolled, _secondsSinceLastUpdated, _secondsSinceLastSeen, _faceID, _name)

  def pack(self):
    "Writes the current LoadedKnownFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current LoadedKnownFace to the given BinaryWriter."
    writer.write(self._secondsSinceFirstEnrolled, 'q')
    writer.write(self._secondsSinceLastUpdated, 'q')
    writer.write(self._secondsSinceLastSeen, 'q')
    writer.write(self._faceID, 'i')
    writer.write_string(self._name, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._secondsSinceFirstEnrolled == other._secondsSinceFirstEnrolled and
        self._secondsSinceLastUpdated == other._secondsSinceLastUpdated and
        self._secondsSinceLastSeen == other._secondsSinceLastSeen and
        self._faceID == other._faceID and
        self._name == other._name)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._secondsSinceFirstEnrolled, 'q') +
      msgbuffers.size(self._secondsSinceLastUpdated, 'q') +
      msgbuffers.size(self._secondsSinceLastSeen, 'q') +
      msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size_string(self._name, 'B'))

  def __str__(self):
    return '{type}(secondsSinceFirstEnrolled={secondsSinceFirstEnrolled}, secondsSinceLastUpdated={secondsSinceLastUpdated}, secondsSinceLastSeen={secondsSinceLastSeen}, faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      secondsSinceFirstEnrolled=self._secondsSinceFirstEnrolled,
      secondsSinceLastUpdated=self._secondsSinceLastUpdated,
      secondsSinceLastSeen=self._secondsSinceLastSeen,
      faceID=self._faceID,
      name=msgbuffers.shorten_string(self._name))

  def __repr__(self):
    return '{type}(secondsSinceFirstEnrolled={secondsSinceFirstEnrolled}, secondsSinceLastUpdated={secondsSinceLastUpdated}, secondsSinceLastSeen={secondsSinceLastSeen}, faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      secondsSinceFirstEnrolled=repr(self._secondsSinceFirstEnrolled),
      secondsSinceLastUpdated=repr(self._secondsSinceLastUpdated),
      secondsSinceLastSeen=repr(self._secondsSinceLastSeen),
      faceID=repr(self._faceID),
      name=repr(self._name))

Anki.Vision.LoadedKnownFace = LoadedKnownFace
del LoadedKnownFace


class RobotRenamedEnrolledFace(object):
  "Generated message-passing message."

  __slots__ = (
    '_faceID', # int_32
    '_name',   # string[uint_8]
  )

  @property
  def faceID(self):
    "int_32 faceID struct property."
    return self._faceID

  @faceID.setter
  def faceID(self, value):
    self._faceID = msgbuffers.validate_integer(
      'RobotRenamedEnrolledFace.faceID', value, -2147483648, 2147483647)

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'RobotRenamedEnrolledFace.name', value, 255)

  def __init__(self, faceID=0, name=''):
    self.faceID = faceID
    self.name = name

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotRenamedEnrolledFace from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotRenamedEnrolledFace.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotRenamedEnrolledFace from the given BinaryReader."
    _faceID = reader.read('i')
    _name = reader.read_string('B')
    return cls(_faceID, _name)

  def pack(self):
    "Writes the current RobotRenamedEnrolledFace, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotRenamedEnrolledFace to the given BinaryWriter."
    writer.write(self._faceID, 'i')
    writer.write_string(self._name, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._faceID == other._faceID and
        self._name == other._name)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._faceID, 'i') +
      msgbuffers.size_string(self._name, 'B'))

  def __str__(self):
    return '{type}(faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      faceID=self._faceID,
      name=msgbuffers.shorten_string(self._name))

  def __repr__(self):
    return '{type}(faceID={faceID}, name={name})'.format(
      type=type(self).__name__,
      faceID=repr(self._faceID),
      name=repr(self._name))

Anki.Vision.RobotRenamedEnrolledFace = RobotRenamedEnrolledFace
del RobotRenamedEnrolledFace


