# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/motorTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/motorTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class MotorID(object):
  "Automatically-generated uint_8 enumeration."
  MOTOR_LEFT_WHEEL  = 0
  MOTOR_RIGHT_WHEEL = 1
  MOTOR_LIFT        = 2
  MOTOR_HEAD        = 3
  MOTOR_COUNT       = 4

Anki.Cozmo.MotorID = MotorID
del MotorID


class MotorCalibration(object):
  "Generated message-passing message."

  __slots__ = (
    '_motorID',      # Anki.Cozmo.MotorID
    '_calibStarted', # bool
    '_autoStarted',  # bool
  )

  @property
  def motorID(self):
    "Anki.Cozmo.MotorID motorID struct property."
    return self._motorID

  @motorID.setter
  def motorID(self, value):
    self._motorID = msgbuffers.validate_integer(
      'MotorCalibration.motorID', value, 0, 255)

  @property
  def calibStarted(self):
    "bool calibStarted struct property."
    return self._calibStarted

  @calibStarted.setter
  def calibStarted(self, value):
    self._calibStarted = msgbuffers.validate_bool(
      'MotorCalibration.calibStarted', value)

  @property
  def autoStarted(self):
    "bool autoStarted struct property."
    return self._autoStarted

  @autoStarted.setter
  def autoStarted(self, value):
    self._autoStarted = msgbuffers.validate_bool(
      'MotorCalibration.autoStarted', value)

  def __init__(self, motorID=Anki.Cozmo.MotorID.MOTOR_LEFT_WHEEL, calibStarted=False, autoStarted=False):
    self.motorID = motorID
    self.calibStarted = calibStarted
    self.autoStarted = autoStarted

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MotorCalibration from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MotorCalibration.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MotorCalibration from the given BinaryReader."
    _motorID = reader.read('B')
    _calibStarted = bool(reader.read('b'))
    _autoStarted = bool(reader.read('b'))
    return cls(_motorID, _calibStarted, _autoStarted)

  def pack(self):
    "Writes the current MotorCalibration, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MotorCalibration to the given BinaryWriter."
    writer.write(self._motorID, 'B')
    writer.write(int(self._calibStarted), 'b')
    writer.write(int(self._autoStarted), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._motorID == other._motorID and
        self._calibStarted == other._calibStarted and
        self._autoStarted == other._autoStarted)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._motorID, 'B') +
      msgbuffers.size(self._calibStarted, 'b') +
      msgbuffers.size(self._autoStarted, 'b'))

  def __str__(self):
    return '{type}(motorID={motorID}, calibStarted={calibStarted}, autoStarted={autoStarted})'.format(
      type=type(self).__name__,
      motorID=self._motorID,
      calibStarted=self._calibStarted,
      autoStarted=self._autoStarted)

  def __repr__(self):
    return '{type}(motorID={motorID}, calibStarted={calibStarted}, autoStarted={autoStarted})'.format(
      type=type(self).__name__,
      motorID=repr(self._motorID),
      calibStarted=repr(self._calibStarted),
      autoStarted=repr(self._autoStarted))

Anki.Cozmo.MotorCalibration = MotorCalibration
del MotorCalibration


class MotorAutoEnabled(object):
  "Generated message-passing message."

  __slots__ = (
    '_motorID', # Anki.Cozmo.MotorID
    '_enabled', # bool
  )

  @property
  def motorID(self):
    "Anki.Cozmo.MotorID motorID struct property."
    return self._motorID

  @motorID.setter
  def motorID(self, value):
    self._motorID = msgbuffers.validate_integer(
      'MotorAutoEnabled.motorID', value, 0, 255)

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'MotorAutoEnabled.enabled', value)

  def __init__(self, motorID=Anki.Cozmo.MotorID.MOTOR_LEFT_WHEEL, enabled=False):
    self.motorID = motorID
    self.enabled = enabled

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MotorAutoEnabled from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MotorAutoEnabled.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MotorAutoEnabled from the given BinaryReader."
    _motorID = reader.read('B')
    _enabled = bool(reader.read('b'))
    return cls(_motorID, _enabled)

  def pack(self):
    "Writes the current MotorAutoEnabled, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current MotorAutoEnabled to the given BinaryWriter."
    writer.write(self._motorID, 'B')
    writer.write(int(self._enabled), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._motorID == other._motorID and
        self._enabled == other._enabled)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._motorID, 'B') +
      msgbuffers.size(self._enabled, 'b'))

  def __str__(self):
    return '{type}(motorID={motorID}, enabled={enabled})'.format(
      type=type(self).__name__,
      motorID=self._motorID,
      enabled=self._enabled)

  def __repr__(self):
    return '{type}(motorID={motorID}, enabled={enabled})'.format(
      type=type(self).__name__,
      motorID=repr(self._motorID),
      enabled=repr(self._enabled))

Anki.Cozmo.MotorAutoEnabled = MotorAutoEnabled
del MotorAutoEnabled


