# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/nvStorageTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/nvStorageTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.NVStorage = msgbuffers.Namespace()

class NVConst(object):
  "Automatically-generated uint_32 enumeration."
  NVConst_MIN_ADDRESS      = 0x180000
  NVConst_MAX_ADDRESS      = 0x1fc000
  NVConst_FACTORY_DATA_BIT = 0x80000000
  NVConst_FIXTURE_DATA_BIT = 0xc0000000

Anki.Cozmo.NVStorage.NVConst = NVConst
del NVConst


class NVEntryTag(object):
  "Automatically-generated uint_32 enumeration."
  NVEntry_Invalid             = 0xffffffff
  NVEntry_GameSkillLevels     = 0x180000
  NVEntry_OnboardingData      = 0x181000
  NVEntry_GameUnlocks         = 0x182000
  NVEntry_FaceEnrollData      = 0x183000
  NVEntry_FaceAlbumData       = 0x184000
  NVEntry_NEXT_SLOT           = 0x194000
  NVEntry_FACTORY_RESERVED1   = 0x1c0000
  NVEntry_FACTORY_RESERVED2   = 0x1de000
  NVEntry_BirthCertificate    = 0x80000000
  NVEntry_CameraCalib         = 0x80000001
  NVEntry_ToolCodeInfo        = 0x80000002
  NVEntry_CalibPose           = 0x80000003
  NVEntry_CalibMetaInfo       = 0x80000004
  NVEntry_ObservedCubePose    = 0x80000005
  NVEntry_IMUInfo             = 0x80000006
  NVEntry_CliffValOnDrop      = 0x80000007
  NVEntry_CliffValOnGround    = 0x80000008
  NVEntry_PlaypenTestResults  = 0x80000010
  NVEntry_FactoryLock         = 0x80000011
  NVEntry_CalibImage1         = 0x80010000
  NVEntry_CalibImage2         = 0x80020000
  NVEntry_CalibImage3         = 0x80030000
  NVEntry_CalibImage4         = 0x80040000
  NVEntry_CalibImage5         = 0x80050000
  NVEntry_CalibImage6         = 0x80060000
  NVEntry_ToolCodeImageLeft   = 0x80100000
  NVEntry_ToolCodeImageRight  = 0x80110000
  NVEntry_PrePlaypenResults   = 0xc0000000
  NVEntry_PrePlaypenCentroids = 0xc0000001
  NVEntry_IMUAverages         = 0xc0000004

Anki.Cozmo.NVStorage.NVEntryTag = NVEntryTag
del NVEntryTag


class NVResult(object):
  "Automatically-generated int_8 enumeration."
  NV_OKAY      = 0
  NV_SCHEDULED = 1
  NV_NO_DO     = 2
  NV_MORE      = 3
  NV_NOT_FOUND = -1
  NV_NO_ROOM   = -2
  NV_ERROR     = -3
  NV_TIMEOUT   = -4
  NV_BUSY      = -5
  NV_BAD_ARGS  = -6
  NV_NO_MEM    = -7
  NV_LOOP      = -8

Anki.Cozmo.NVStorage.NVResult = NVResult
del NVResult


class NVOperation(object):
  "Automatically-generated uint_8 enumeration."
  NVOP_READ    = 0
  NVOP_WRITE   = 1
  NVOP_ERASE   = 2
  NVOP_WIPEALL = 3

Anki.Cozmo.NVStorage.NVOperation = NVOperation
del NVOperation


