# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/onboardingData.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/onboardingData.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class OnboardingData(object):
  "Generated message-passing structure."

  __slots__ = (
    '_hasCompletedOnboarding', # bool
  )

  @property
  def hasCompletedOnboarding(self):
    "bool hasCompletedOnboarding struct property."
    return self._hasCompletedOnboarding

  @hasCompletedOnboarding.setter
  def hasCompletedOnboarding(self, value):
    self._hasCompletedOnboarding = msgbuffers.validate_bool(
      'OnboardingData.hasCompletedOnboarding', value)

  def __init__(self, hasCompletedOnboarding=False):
    self.hasCompletedOnboarding = hasCompletedOnboarding

  @classmethod
  def unpack(cls, buffer):
    "Reads a new OnboardingData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('OnboardingData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new OnboardingData from the given BinaryReader."
    _hasCompletedOnboarding = bool(reader.read('b'))
    return cls(_hasCompletedOnboarding)

  def pack(self):
    "Writes the current OnboardingData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current OnboardingData to the given BinaryWriter."
    writer.write(int(self._hasCompletedOnboarding), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._hasCompletedOnboarding == other._hasCompletedOnboarding
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._hasCompletedOnboarding, 'b'))

  def __str__(self):
    return '{type}(hasCompletedOnboarding={hasCompletedOnboarding})'.format(
      type=type(self).__name__,
      hasCompletedOnboarding=self._hasCompletedOnboarding)

  def __repr__(self):
    return '{type}(hasCompletedOnboarding={hasCompletedOnboarding})'.format(
      type=type(self).__name__,
      hasCompletedOnboarding=repr(self._hasCompletedOnboarding))

Anki.Cozmo.OnboardingData = OnboardingData
del OnboardingData


