# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/pathMotionProfile.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/pathMotionProfile.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class PathMotionProfile(object):
  "Generated message-passing structure."

  __slots__ = (
    '_speed_mmps',                  # float_32
    '_accel_mmps2',                 # float_32
    '_decel_mmps2',                 # float_32
    '_pointTurnSpeed_rad_per_sec',  # float_32
    '_pointTurnAccel_rad_per_sec2', # float_32
    '_pointTurnDecel_rad_per_sec2', # float_32
    '_dockSpeed_mmps',              # float_32
    '_dockAccel_mmps2',             # float_32
    '_dockDecel_mmps2',             # float_32
    '_reverseSpeed_mmps',           # float_32
    '_isCustom',                    # bool
  )

  @property
  def speed_mmps(self):
    "float_32 speed_mmps struct property."
    return self._speed_mmps

  @speed_mmps.setter
  def speed_mmps(self, value):
    self._speed_mmps = msgbuffers.validate_float(
      'PathMotionProfile.speed_mmps', value, 'f')

  @property
  def accel_mmps2(self):
    "float_32 accel_mmps2 struct property."
    return self._accel_mmps2

  @accel_mmps2.setter
  def accel_mmps2(self, value):
    self._accel_mmps2 = msgbuffers.validate_float(
      'PathMotionProfile.accel_mmps2', value, 'f')

  @property
  def decel_mmps2(self):
    "float_32 decel_mmps2 struct property."
    return self._decel_mmps2

  @decel_mmps2.setter
  def decel_mmps2(self, value):
    self._decel_mmps2 = msgbuffers.validate_float(
      'PathMotionProfile.decel_mmps2', value, 'f')

  @property
  def pointTurnSpeed_rad_per_sec(self):
    "float_32 pointTurnSpeed_rad_per_sec struct property."
    return self._pointTurnSpeed_rad_per_sec

  @pointTurnSpeed_rad_per_sec.setter
  def pointTurnSpeed_rad_per_sec(self, value):
    self._pointTurnSpeed_rad_per_sec = msgbuffers.validate_float(
      'PathMotionProfile.pointTurnSpeed_rad_per_sec', value, 'f')

  @property
  def pointTurnAccel_rad_per_sec2(self):
    "float_32 pointTurnAccel_rad_per_sec2 struct property."
    return self._pointTurnAccel_rad_per_sec2

  @pointTurnAccel_rad_per_sec2.setter
  def pointTurnAccel_rad_per_sec2(self, value):
    self._pointTurnAccel_rad_per_sec2 = msgbuffers.validate_float(
      'PathMotionProfile.pointTurnAccel_rad_per_sec2', value, 'f')

  @property
  def pointTurnDecel_rad_per_sec2(self):
    "float_32 pointTurnDecel_rad_per_sec2 struct property."
    return self._pointTurnDecel_rad_per_sec2

  @pointTurnDecel_rad_per_sec2.setter
  def pointTurnDecel_rad_per_sec2(self, value):
    self._pointTurnDecel_rad_per_sec2 = msgbuffers.validate_float(
      'PathMotionProfile.pointTurnDecel_rad_per_sec2', value, 'f')

  @property
  def dockSpeed_mmps(self):
    "float_32 dockSpeed_mmps struct property."
    return self._dockSpeed_mmps

  @dockSpeed_mmps.setter
  def dockSpeed_mmps(self, value):
    self._dockSpeed_mmps = msgbuffers.validate_float(
      'PathMotionProfile.dockSpeed_mmps', value, 'f')

  @property
  def dockAccel_mmps2(self):
    "float_32 dockAccel_mmps2 struct property."
    return self._dockAccel_mmps2

  @dockAccel_mmps2.setter
  def dockAccel_mmps2(self, value):
    self._dockAccel_mmps2 = msgbuffers.validate_float(
      'PathMotionProfile.dockAccel_mmps2', value, 'f')

  @property
  def dockDecel_mmps2(self):
    "float_32 dockDecel_mmps2 struct property."
    return self._dockDecel_mmps2

  @dockDecel_mmps2.setter
  def dockDecel_mmps2(self, value):
    self._dockDecel_mmps2 = msgbuffers.validate_float(
      'PathMotionProfile.dockDecel_mmps2', value, 'f')

  @property
  def reverseSpeed_mmps(self):
    "float_32 reverseSpeed_mmps struct property."
    return self._reverseSpeed_mmps

  @reverseSpeed_mmps.setter
  def reverseSpeed_mmps(self, value):
    self._reverseSpeed_mmps = msgbuffers.validate_float(
      'PathMotionProfile.reverseSpeed_mmps', value, 'f')

  @property
  def isCustom(self):
    "bool isCustom struct property."
    return self._isCustom

  @isCustom.setter
  def isCustom(self, value):
    self._isCustom = msgbuffers.validate_bool(
      'PathMotionProfile.isCustom', value)

  def __init__(self, speed_mmps=100.0, accel_mmps2=200.0, decel_mmps2=500.0, pointTurnSpeed_rad_per_sec=2.0, pointTurnAccel_rad_per_sec2=100.0, pointTurnDecel_rad_per_sec2=500.0, dockSpeed_mmps=60.0, dockAccel_mmps2=200.0, dockDecel_mmps2=500.0, reverseSpeed_mmps=80.0, isCustom=False):
    self.speed_mmps = speed_mmps
    self.accel_mmps2 = accel_mmps2
    self.decel_mmps2 = decel_mmps2
    self.pointTurnSpeed_rad_per_sec = pointTurnSpeed_rad_per_sec
    self.pointTurnAccel_rad_per_sec2 = pointTurnAccel_rad_per_sec2
    self.pointTurnDecel_rad_per_sec2 = pointTurnDecel_rad_per_sec2
    self.dockSpeed_mmps = dockSpeed_mmps
    self.dockAccel_mmps2 = dockAccel_mmps2
    self.dockDecel_mmps2 = dockDecel_mmps2
    self.reverseSpeed_mmps = reverseSpeed_mmps
    self.isCustom = isCustom

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PathMotionProfile from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PathMotionProfile.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PathMotionProfile from the given BinaryReader."
    _speed_mmps = reader.read('f')
    _accel_mmps2 = reader.read('f')
    _decel_mmps2 = reader.read('f')
    _pointTurnSpeed_rad_per_sec = reader.read('f')
    _pointTurnAccel_rad_per_sec2 = reader.read('f')
    _pointTurnDecel_rad_per_sec2 = reader.read('f')
    _dockSpeed_mmps = reader.read('f')
    _dockAccel_mmps2 = reader.read('f')
    _dockDecel_mmps2 = reader.read('f')
    _reverseSpeed_mmps = reader.read('f')
    _isCustom = bool(reader.read('b'))
    return cls(_speed_mmps, _accel_mmps2, _decel_mmps2, _pointTurnSpeed_rad_per_sec, _pointTurnAccel_rad_per_sec2, _pointTurnDecel_rad_per_sec2, _dockSpeed_mmps, _dockAccel_mmps2, _dockDecel_mmps2, _reverseSpeed_mmps, _isCustom)

  def pack(self):
    "Writes the current PathMotionProfile, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PathMotionProfile to the given BinaryWriter."
    writer.write(self._speed_mmps, 'f')
    writer.write(self._accel_mmps2, 'f')
    writer.write(self._decel_mmps2, 'f')
    writer.write(self._pointTurnSpeed_rad_per_sec, 'f')
    writer.write(self._pointTurnAccel_rad_per_sec2, 'f')
    writer.write(self._pointTurnDecel_rad_per_sec2, 'f')
    writer.write(self._dockSpeed_mmps, 'f')
    writer.write(self._dockAccel_mmps2, 'f')
    writer.write(self._dockDecel_mmps2, 'f')
    writer.write(self._reverseSpeed_mmps, 'f')
    writer.write(int(self._isCustom), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._speed_mmps == other._speed_mmps and
        self._accel_mmps2 == other._accel_mmps2 and
        self._decel_mmps2 == other._decel_mmps2 and
        self._pointTurnSpeed_rad_per_sec == other._pointTurnSpeed_rad_per_sec and
        self._pointTurnAccel_rad_per_sec2 == other._pointTurnAccel_rad_per_sec2 and
        self._pointTurnDecel_rad_per_sec2 == other._pointTurnDecel_rad_per_sec2 and
        self._dockSpeed_mmps == other._dockSpeed_mmps and
        self._dockAccel_mmps2 == other._dockAccel_mmps2 and
        self._dockDecel_mmps2 == other._dockDecel_mmps2 and
        self._reverseSpeed_mmps == other._reverseSpeed_mmps and
        self._isCustom == other._isCustom)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._speed_mmps, 'f') +
      msgbuffers.size(self._accel_mmps2, 'f') +
      msgbuffers.size(self._decel_mmps2, 'f') +
      msgbuffers.size(self._pointTurnSpeed_rad_per_sec, 'f') +
      msgbuffers.size(self._pointTurnAccel_rad_per_sec2, 'f') +
      msgbuffers.size(self._pointTurnDecel_rad_per_sec2, 'f') +
      msgbuffers.size(self._dockSpeed_mmps, 'f') +
      msgbuffers.size(self._dockAccel_mmps2, 'f') +
      msgbuffers.size(self._dockDecel_mmps2, 'f') +
      msgbuffers.size(self._reverseSpeed_mmps, 'f') +
      msgbuffers.size(self._isCustom, 'b'))

  def __str__(self):
    return '{type}(speed_mmps={speed_mmps}, accel_mmps2={accel_mmps2}, decel_mmps2={decel_mmps2}, pointTurnSpeed_rad_per_sec={pointTurnSpeed_rad_per_sec}, pointTurnAccel_rad_per_sec2={pointTurnAccel_rad_per_sec2}, pointTurnDecel_rad_per_sec2={pointTurnDecel_rad_per_sec2}, dockSpeed_mmps={dockSpeed_mmps}, dockAccel_mmps2={dockAccel_mmps2}, dockDecel_mmps2={dockDecel_mmps2}, reverseSpeed_mmps={reverseSpeed_mmps}, isCustom={isCustom})'.format(
      type=type(self).__name__,
      speed_mmps=self._speed_mmps,
      accel_mmps2=self._accel_mmps2,
      decel_mmps2=self._decel_mmps2,
      pointTurnSpeed_rad_per_sec=self._pointTurnSpeed_rad_per_sec,
      pointTurnAccel_rad_per_sec2=self._pointTurnAccel_rad_per_sec2,
      pointTurnDecel_rad_per_sec2=self._pointTurnDecel_rad_per_sec2,
      dockSpeed_mmps=self._dockSpeed_mmps,
      dockAccel_mmps2=self._dockAccel_mmps2,
      dockDecel_mmps2=self._dockDecel_mmps2,
      reverseSpeed_mmps=self._reverseSpeed_mmps,
      isCustom=self._isCustom)

  def __repr__(self):
    return '{type}(speed_mmps={speed_mmps}, accel_mmps2={accel_mmps2}, decel_mmps2={decel_mmps2}, pointTurnSpeed_rad_per_sec={pointTurnSpeed_rad_per_sec}, pointTurnAccel_rad_per_sec2={pointTurnAccel_rad_per_sec2}, pointTurnDecel_rad_per_sec2={pointTurnDecel_rad_per_sec2}, dockSpeed_mmps={dockSpeed_mmps}, dockAccel_mmps2={dockAccel_mmps2}, dockDecel_mmps2={dockDecel_mmps2}, reverseSpeed_mmps={reverseSpeed_mmps}, isCustom={isCustom})'.format(
      type=type(self).__name__,
      speed_mmps=repr(self._speed_mmps),
      accel_mmps2=repr(self._accel_mmps2),
      decel_mmps2=repr(self._decel_mmps2),
      pointTurnSpeed_rad_per_sec=repr(self._pointTurnSpeed_rad_per_sec),
      pointTurnAccel_rad_per_sec2=repr(self._pointTurnAccel_rad_per_sec2),
      pointTurnDecel_rad_per_sec2=repr(self._pointTurnDecel_rad_per_sec2),
      dockSpeed_mmps=repr(self._dockSpeed_mmps),
      dockAccel_mmps2=repr(self._dockAccel_mmps2),
      dockDecel_mmps2=repr(self._dockDecel_mmps2),
      reverseSpeed_mmps=repr(self._reverseSpeed_mmps),
      isCustom=repr(self._isCustom))

Anki.Cozmo.PathMotionProfile = PathMotionProfile
del PathMotionProfile


