# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/poseStructs.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/poseStructs.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()

class PoseStruct3d(object):
  "Generated message-passing structure."

  __slots__ = (
    '_x',        # float_32
    '_y',        # float_32
    '_z',        # float_32
    '_q0',       # float_32
    '_q1',       # float_32
    '_q2',       # float_32
    '_q3',       # float_32
    '_originID', # uint_32
  )

  @property
  def x(self):
    "float_32 x struct property."
    return self._x

  @x.setter
  def x(self, value):
    self._x = msgbuffers.validate_float(
      'PoseStruct3d.x', value, 'f')

  @property
  def y(self):
    "float_32 y struct property."
    return self._y

  @y.setter
  def y(self, value):
    self._y = msgbuffers.validate_float(
      'PoseStruct3d.y', value, 'f')

  @property
  def z(self):
    "float_32 z struct property."
    return self._z

  @z.setter
  def z(self, value):
    self._z = msgbuffers.validate_float(
      'PoseStruct3d.z', value, 'f')

  @property
  def q0(self):
    "float_32 q0 struct property."
    return self._q0

  @q0.setter
  def q0(self, value):
    self._q0 = msgbuffers.validate_float(
      'PoseStruct3d.q0', value, 'f')

  @property
  def q1(self):
    "float_32 q1 struct property."
    return self._q1

  @q1.setter
  def q1(self, value):
    self._q1 = msgbuffers.validate_float(
      'PoseStruct3d.q1', value, 'f')

  @property
  def q2(self):
    "float_32 q2 struct property."
    return self._q2

  @q2.setter
  def q2(self, value):
    self._q2 = msgbuffers.validate_float(
      'PoseStruct3d.q2', value, 'f')

  @property
  def q3(self):
    "float_32 q3 struct property."
    return self._q3

  @q3.setter
  def q3(self, value):
    self._q3 = msgbuffers.validate_float(
      'PoseStruct3d.q3', value, 'f')

  @property
  def originID(self):
    "uint_32 originID struct property."
    return self._originID

  @originID.setter
  def originID(self, value):
    self._originID = msgbuffers.validate_integer(
      'PoseStruct3d.originID', value, 0, 4294967295)

  def __init__(self, x=0.0, y=0.0, z=0.0, q0=0.0, q1=0.0, q2=0.0, q3=0.0, originID=0):
    self.x = x
    self.y = y
    self.z = z
    self.q0 = q0
    self.q1 = q1
    self.q2 = q2
    self.q3 = q3
    self.originID = originID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PoseStruct3d from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PoseStruct3d.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PoseStruct3d from the given BinaryReader."
    _x = reader.read('f')
    _y = reader.read('f')
    _z = reader.read('f')
    _q0 = reader.read('f')
    _q1 = reader.read('f')
    _q2 = reader.read('f')
    _q3 = reader.read('f')
    _originID = reader.read('I')
    return cls(_x, _y, _z, _q0, _q1, _q2, _q3, _originID)

  def pack(self):
    "Writes the current PoseStruct3d, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PoseStruct3d to the given BinaryWriter."
    writer.write(self._x, 'f')
    writer.write(self._y, 'f')
    writer.write(self._z, 'f')
    writer.write(self._q0, 'f')
    writer.write(self._q1, 'f')
    writer.write(self._q2, 'f')
    writer.write(self._q3, 'f')
    writer.write(self._originID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x == other._x and
        self._y == other._y and
        self._z == other._z and
        self._q0 == other._q0 and
        self._q1 == other._q1 and
        self._q2 == other._q2 and
        self._q3 == other._q3 and
        self._originID == other._originID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x, 'f') +
      msgbuffers.size(self._y, 'f') +
      msgbuffers.size(self._z, 'f') +
      msgbuffers.size(self._q0, 'f') +
      msgbuffers.size(self._q1, 'f') +
      msgbuffers.size(self._q2, 'f') +
      msgbuffers.size(self._q3, 'f') +
      msgbuffers.size(self._originID, 'I'))

  def __str__(self):
    return '{type}(x={x}, y={y}, z={z}, q0={q0}, q1={q1}, q2={q2}, q3={q3}, originID={originID})'.format(
      type=type(self).__name__,
      x=self._x,
      y=self._y,
      z=self._z,
      q0=self._q0,
      q1=self._q1,
      q2=self._q2,
      q3=self._q3,
      originID=self._originID)

  def __repr__(self):
    return '{type}(x={x}, y={y}, z={z}, q0={q0}, q1={q1}, q2={q2}, q3={q3}, originID={originID})'.format(
      type=type(self).__name__,
      x=repr(self._x),
      y=repr(self._y),
      z=repr(self._z),
      q0=repr(self._q0),
      q1=repr(self._q1),
      q2=repr(self._q2),
      q3=repr(self._q3),
      originID=repr(self._originID))

Anki.PoseStruct3d = PoseStruct3d
del PoseStruct3d


class PoseState(object):
  "Automatically-generated uint_8 enumeration."
  Known   = 0
  Dirty   = 1
  Unknown = 2

Anki.PoseState = PoseState
del PoseState


