# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/proxMessages.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/proxMessages.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class CliffEvent(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_mm',            # float_32
    '_y_mm',            # float_32
    '_angle_rad',       # float_32
    '_detected',        # bool
    '_didStopForCliff', # bool
  )

  @property
  def x_mm(self):
    "float_32 x_mm struct property."
    return self._x_mm

  @x_mm.setter
  def x_mm(self, value):
    self._x_mm = msgbuffers.validate_float(
      'CliffEvent.x_mm', value, 'f')

  @property
  def y_mm(self):
    "float_32 y_mm struct property."
    return self._y_mm

  @y_mm.setter
  def y_mm(self, value):
    self._y_mm = msgbuffers.validate_float(
      'CliffEvent.y_mm', value, 'f')

  @property
  def angle_rad(self):
    "float_32 angle_rad struct property."
    return self._angle_rad

  @angle_rad.setter
  def angle_rad(self, value):
    self._angle_rad = msgbuffers.validate_float(
      'CliffEvent.angle_rad', value, 'f')

  @property
  def detected(self):
    "bool detected struct property."
    return self._detected

  @detected.setter
  def detected(self, value):
    self._detected = msgbuffers.validate_bool(
      'CliffEvent.detected', value)

  @property
  def didStopForCliff(self):
    "bool didStopForCliff struct property."
    return self._didStopForCliff

  @didStopForCliff.setter
  def didStopForCliff(self, value):
    self._didStopForCliff = msgbuffers.validate_bool(
      'CliffEvent.didStopForCliff', value)

  def __init__(self, x_mm=0.0, y_mm=0.0, angle_rad=0.0, detected=False, didStopForCliff=False):
    self.x_mm = x_mm
    self.y_mm = y_mm
    self.angle_rad = angle_rad
    self.detected = detected
    self.didStopForCliff = didStopForCliff

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CliffEvent from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CliffEvent.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CliffEvent from the given BinaryReader."
    _x_mm = reader.read('f')
    _y_mm = reader.read('f')
    _angle_rad = reader.read('f')
    _detected = bool(reader.read('b'))
    _didStopForCliff = bool(reader.read('b'))
    return cls(_x_mm, _y_mm, _angle_rad, _detected, _didStopForCliff)

  def pack(self):
    "Writes the current CliffEvent, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CliffEvent to the given BinaryWriter."
    writer.write(self._x_mm, 'f')
    writer.write(self._y_mm, 'f')
    writer.write(self._angle_rad, 'f')
    writer.write(int(self._detected), 'b')
    writer.write(int(self._didStopForCliff), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_mm == other._x_mm and
        self._y_mm == other._y_mm and
        self._angle_rad == other._angle_rad and
        self._detected == other._detected and
        self._didStopForCliff == other._didStopForCliff)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_mm, 'f') +
      msgbuffers.size(self._y_mm, 'f') +
      msgbuffers.size(self._angle_rad, 'f') +
      msgbuffers.size(self._detected, 'b') +
      msgbuffers.size(self._didStopForCliff, 'b'))

  def __str__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, angle_rad={angle_rad}, detected={detected}, didStopForCliff={didStopForCliff})'.format(
      type=type(self).__name__,
      x_mm=self._x_mm,
      y_mm=self._y_mm,
      angle_rad=self._angle_rad,
      detected=self._detected,
      didStopForCliff=self._didStopForCliff)

  def __repr__(self):
    return '{type}(x_mm={x_mm}, y_mm={y_mm}, angle_rad={angle_rad}, detected={detected}, didStopForCliff={didStopForCliff})'.format(
      type=type(self).__name__,
      x_mm=repr(self._x_mm),
      y_mm=repr(self._y_mm),
      angle_rad=repr(self._angle_rad),
      detected=repr(self._detected),
      didStopForCliff=repr(self._didStopForCliff))

Anki.Cozmo.CliffEvent = CliffEvent
del CliffEvent


class PotentialCliff(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new PotentialCliff from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('PotentialCliff.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new PotentialCliff from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current PotentialCliff, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current PotentialCliff to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.PotentialCliff = PotentialCliff
del PotentialCliff


class ProxObstacle(object):
  "Generated message-passing message."

  __slots__ = (
    '_distance_mm', # uint_8
  )

  @property
  def distance_mm(self):
    "uint_8 distance_mm struct property."
    return self._distance_mm

  @distance_mm.setter
  def distance_mm(self, value):
    self._distance_mm = msgbuffers.validate_integer(
      'ProxObstacle.distance_mm', value, 0, 255)

  def __init__(self, distance_mm=0):
    self.distance_mm = distance_mm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ProxObstacle from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ProxObstacle.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ProxObstacle from the given BinaryReader."
    _distance_mm = reader.read('B')
    return cls(_distance_mm)

  def pack(self):
    "Writes the current ProxObstacle, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ProxObstacle to the given BinaryWriter."
    writer.write(self._distance_mm, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._distance_mm == other._distance_mm
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._distance_mm, 'B'))

  def __str__(self):
    return '{type}(distance_mm={distance_mm})'.format(
      type=type(self).__name__,
      distance_mm=self._distance_mm)

  def __repr__(self):
    return '{type}(distance_mm={distance_mm})'.format(
      type=type(self).__name__,
      distance_mm=repr(self._distance_mm))

Anki.Cozmo.ProxObstacle = ProxObstacle
del ProxObstacle


