# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/robotTestModes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ../robot/clad/src/ -o ../generated/cladPython// clad/types/robotTestModes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class TestMode(object):
  "Automatically-generated uint_8 enumeration."
  TM_NONE                              = 0
  TM_PLACE_BLOCK_ON_GROUND             = 1
  TM_DOCK_PATH                         = 2
  TM_PATH_FOLLOW                       = 3
  TM_PATH_FOLLOW_CONVENIENCE_FUNCTIONS = 4
  TM_DIRECT_DRIVE                      = 5
  TM_LIFT                              = 6
  TM_LIFT_TOGGLE                       = 7
  TM_HEAD                              = 8
  TM_IMU                               = 9
  TM_ANIMATION                         = 10
  TM_LIGHTS                            = 11
  TM_FACE_DISPLAY                      = 12
  TM_STOP_TEST                         = 13
  TM_MAX_POWER_TEST                    = 14
  TM_FACE_TRACKING                     = 15
  TM_NUM_TESTS                         = 16

Anki.Cozmo.TestMode = TestMode
del TestMode


class DriveTestFlags(object):
  "Automatically-generated uint_8 enumeration."
  DTF_ENABLE_DIRECT_HAL_TEST   = 0x1
  DTF_ENABLE_CYCLE_SPEEDS_TEST = 0x2
  DTF_ENABLE_TOGGLE_DIR        = 0x4

Anki.Cozmo.DriveTestFlags = DriveTestFlags
del DriveTestFlags


class LiftTestFlags(object):
  "Automatically-generated uint_8 enumeration."
  LiftTF_TEST_POWER    = 0
  LiftTF_TEST_HEIGHTS  = 1
  LiftTF_NODDING       = 2
  LiftTF_DISABLE_MOTOR = 3

Anki.Cozmo.LiftTestFlags = LiftTestFlags
del LiftTestFlags


class HeadTestFlags(object):
  "Automatically-generated uint_8 enumeration."
  HTF_TEST_POWER  = 0
  HTF_TEST_ANGLES = 1
  HTF_NODDING     = 2

Anki.Cozmo.HeadTestFlags = HeadTestFlags
del HeadTestFlags


class IMUTestFlags(object):
  "Automatically-generated uint_8 enumeration."
  ITF_DO_TURNS = 0x1

Anki.Cozmo.IMUTestFlags = IMUTestFlags
del IMUTestFlags


class LightTestFlags(object):
  "Automatically-generated uint_8 enumeration."
  LTF_CYCLE_ALL = 0x1

Anki.Cozmo.LightTestFlags = LightTestFlags
del LightTestFlags


class StartControllerTestMode(object):
  "Generated message-passing message."

  __slots__ = (
    '_p1',   # int_32
    '_p2',   # int_32
    '_p3',   # int_32
    '_mode', # Anki.Cozmo.TestMode
  )

  @property
  def p1(self):
    "int_32 p1 struct property."
    return self._p1

  @p1.setter
  def p1(self, value):
    self._p1 = msgbuffers.validate_integer(
      'StartControllerTestMode.p1', value, -2147483648, 2147483647)

  @property
  def p2(self):
    "int_32 p2 struct property."
    return self._p2

  @p2.setter
  def p2(self, value):
    self._p2 = msgbuffers.validate_integer(
      'StartControllerTestMode.p2', value, -2147483648, 2147483647)

  @property
  def p3(self):
    "int_32 p3 struct property."
    return self._p3

  @p3.setter
  def p3(self, value):
    self._p3 = msgbuffers.validate_integer(
      'StartControllerTestMode.p3', value, -2147483648, 2147483647)

  @property
  def mode(self):
    "Anki.Cozmo.TestMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'StartControllerTestMode.mode', value, 0, 255)

  def __init__(self, p1=0, p2=0, p3=0, mode=Anki.Cozmo.TestMode.TM_NONE):
    self.p1 = p1
    self.p2 = p2
    self.p3 = p3
    self.mode = mode

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StartControllerTestMode from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StartControllerTestMode.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StartControllerTestMode from the given BinaryReader."
    _p1 = reader.read('i')
    _p2 = reader.read('i')
    _p3 = reader.read('i')
    _mode = reader.read('B')
    return cls(_p1, _p2, _p3, _mode)

  def pack(self):
    "Writes the current StartControllerTestMode, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StartControllerTestMode to the given BinaryWriter."
    writer.write(self._p1, 'i')
    writer.write(self._p2, 'i')
    writer.write(self._p3, 'i')
    writer.write(self._mode, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._p1 == other._p1 and
        self._p2 == other._p2 and
        self._p3 == other._p3 and
        self._mode == other._mode)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._p1, 'i') +
      msgbuffers.size(self._p2, 'i') +
      msgbuffers.size(self._p3, 'i') +
      msgbuffers.size(self._mode, 'B'))

  def __str__(self):
    return '{type}(p1={p1}, p2={p2}, p3={p3}, mode={mode})'.format(
      type=type(self).__name__,
      p1=self._p1,
      p2=self._p2,
      p3=self._p3,
      mode=self._mode)

  def __repr__(self):
    return '{type}(p1={p1}, p2={p2}, p3={p3}, mode={mode})'.format(
      type=type(self).__name__,
      p1=repr(self._p1),
      p2=repr(self._p2),
      p3=repr(self._p3),
      mode=repr(self._mode))

Anki.Cozmo.StartControllerTestMode = StartControllerTestMode
del StartControllerTestMode


class RawPWM(object):
  "Generated message-passing message."

  __slots__ = (
    '_pwm', # int_16[4]
  )

  @property
  def pwm(self):
    "int_16[4] pwm struct property."
    return self._pwm

  @pwm.setter
  def pwm(self, value):
    self._pwm = msgbuffers.validate_farray(
      'RawPWM.pwm', value, 4,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -32768, 32767))

  def __init__(self, pwm=(0,) * 4):
    self.pwm = pwm

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RawPWM from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RawPWM.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RawPWM from the given BinaryReader."
    _pwm = reader.read_farray('h', 4)
    return cls(_pwm)

  def pack(self):
    "Writes the current RawPWM, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RawPWM to the given BinaryWriter."
    writer.write_farray(self._pwm, 'h', 4)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._pwm == other._pwm
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._pwm, 'h', 4))

  def __str__(self):
    return '{type}(pwm={pwm})'.format(
      type=type(self).__name__,
      pwm=msgbuffers.shorten_sequence(self._pwm))

  def __repr__(self):
    return '{type}(pwm={pwm})'.format(
      type=type(self).__name__,
      pwm=repr(self._pwm))

Anki.Cozmo.RawPWM = RawPWM
del RawPWM


