# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/toolCodes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/toolCodes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class ToolCode(object):
  "Automatically-generated uint_16 enumeration."
  UnknownTool     = 0
  CubeLiftingTool = 1
  NumTools        = 2

Anki.Cozmo.ToolCode = ToolCode
del ToolCode


class ToolCodeInfo(object):
  "Generated message-passing structure."

  __slots__ = (
    '_expectedCalibDotLeft_x',  # float_32
    '_expectedCalibDotLeft_y',  # float_32
    '_expectedCalibDotRight_x', # float_32
    '_expectedCalibDotRight_y', # float_32
    '_observedCalibDotLeft_x',  # float_32
    '_observedCalibDotLeft_y',  # float_32
    '_observedCalibDotRight_x', # float_32
    '_observedCalibDotRight_y', # float_32
    '_code',                    # Anki.Cozmo.ToolCode
  )

  @property
  def expectedCalibDotLeft_x(self):
    "float_32 expectedCalibDotLeft_x struct property."
    return self._expectedCalibDotLeft_x

  @expectedCalibDotLeft_x.setter
  def expectedCalibDotLeft_x(self, value):
    self._expectedCalibDotLeft_x = msgbuffers.validate_float(
      'ToolCodeInfo.expectedCalibDotLeft_x', value, 'f')

  @property
  def expectedCalibDotLeft_y(self):
    "float_32 expectedCalibDotLeft_y struct property."
    return self._expectedCalibDotLeft_y

  @expectedCalibDotLeft_y.setter
  def expectedCalibDotLeft_y(self, value):
    self._expectedCalibDotLeft_y = msgbuffers.validate_float(
      'ToolCodeInfo.expectedCalibDotLeft_y', value, 'f')

  @property
  def expectedCalibDotRight_x(self):
    "float_32 expectedCalibDotRight_x struct property."
    return self._expectedCalibDotRight_x

  @expectedCalibDotRight_x.setter
  def expectedCalibDotRight_x(self, value):
    self._expectedCalibDotRight_x = msgbuffers.validate_float(
      'ToolCodeInfo.expectedCalibDotRight_x', value, 'f')

  @property
  def expectedCalibDotRight_y(self):
    "float_32 expectedCalibDotRight_y struct property."
    return self._expectedCalibDotRight_y

  @expectedCalibDotRight_y.setter
  def expectedCalibDotRight_y(self, value):
    self._expectedCalibDotRight_y = msgbuffers.validate_float(
      'ToolCodeInfo.expectedCalibDotRight_y', value, 'f')

  @property
  def observedCalibDotLeft_x(self):
    "float_32 observedCalibDotLeft_x struct property."
    return self._observedCalibDotLeft_x

  @observedCalibDotLeft_x.setter
  def observedCalibDotLeft_x(self, value):
    self._observedCalibDotLeft_x = msgbuffers.validate_float(
      'ToolCodeInfo.observedCalibDotLeft_x', value, 'f')

  @property
  def observedCalibDotLeft_y(self):
    "float_32 observedCalibDotLeft_y struct property."
    return self._observedCalibDotLeft_y

  @observedCalibDotLeft_y.setter
  def observedCalibDotLeft_y(self, value):
    self._observedCalibDotLeft_y = msgbuffers.validate_float(
      'ToolCodeInfo.observedCalibDotLeft_y', value, 'f')

  @property
  def observedCalibDotRight_x(self):
    "float_32 observedCalibDotRight_x struct property."
    return self._observedCalibDotRight_x

  @observedCalibDotRight_x.setter
  def observedCalibDotRight_x(self, value):
    self._observedCalibDotRight_x = msgbuffers.validate_float(
      'ToolCodeInfo.observedCalibDotRight_x', value, 'f')

  @property
  def observedCalibDotRight_y(self):
    "float_32 observedCalibDotRight_y struct property."
    return self._observedCalibDotRight_y

  @observedCalibDotRight_y.setter
  def observedCalibDotRight_y(self, value):
    self._observedCalibDotRight_y = msgbuffers.validate_float(
      'ToolCodeInfo.observedCalibDotRight_y', value, 'f')

  @property
  def code(self):
    "Anki.Cozmo.ToolCode code struct property."
    return self._code

  @code.setter
  def code(self, value):
    self._code = msgbuffers.validate_integer(
      'ToolCodeInfo.code', value, 0, 65535)

  def __init__(self, expectedCalibDotLeft_x=-1.0, expectedCalibDotLeft_y=-1.0, expectedCalibDotRight_x=-1.0, expectedCalibDotRight_y=-1.0, observedCalibDotLeft_x=-1.0, observedCalibDotLeft_y=-1.0, observedCalibDotRight_x=-1.0, observedCalibDotRight_y=-1.0, code=Anki.Cozmo.ToolCode.UnknownTool):
    self.expectedCalibDotLeft_x = expectedCalibDotLeft_x
    self.expectedCalibDotLeft_y = expectedCalibDotLeft_y
    self.expectedCalibDotRight_x = expectedCalibDotRight_x
    self.expectedCalibDotRight_y = expectedCalibDotRight_y
    self.observedCalibDotLeft_x = observedCalibDotLeft_x
    self.observedCalibDotLeft_y = observedCalibDotLeft_y
    self.observedCalibDotRight_x = observedCalibDotRight_x
    self.observedCalibDotRight_y = observedCalibDotRight_y
    self.code = code

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ToolCodeInfo from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ToolCodeInfo.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ToolCodeInfo from the given BinaryReader."
    _expectedCalibDotLeft_x = reader.read('f')
    _expectedCalibDotLeft_y = reader.read('f')
    _expectedCalibDotRight_x = reader.read('f')
    _expectedCalibDotRight_y = reader.read('f')
    _observedCalibDotLeft_x = reader.read('f')
    _observedCalibDotLeft_y = reader.read('f')
    _observedCalibDotRight_x = reader.read('f')
    _observedCalibDotRight_y = reader.read('f')
    _code = reader.read('H')
    return cls(_expectedCalibDotLeft_x, _expectedCalibDotLeft_y, _expectedCalibDotRight_x, _expectedCalibDotRight_y, _observedCalibDotLeft_x, _observedCalibDotLeft_y, _observedCalibDotRight_x, _observedCalibDotRight_y, _code)

  def pack(self):
    "Writes the current ToolCodeInfo, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ToolCodeInfo to the given BinaryWriter."
    writer.write(self._expectedCalibDotLeft_x, 'f')
    writer.write(self._expectedCalibDotLeft_y, 'f')
    writer.write(self._expectedCalibDotRight_x, 'f')
    writer.write(self._expectedCalibDotRight_y, 'f')
    writer.write(self._observedCalibDotLeft_x, 'f')
    writer.write(self._observedCalibDotLeft_y, 'f')
    writer.write(self._observedCalibDotRight_x, 'f')
    writer.write(self._observedCalibDotRight_y, 'f')
    writer.write(self._code, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._expectedCalibDotLeft_x == other._expectedCalibDotLeft_x and
        self._expectedCalibDotLeft_y == other._expectedCalibDotLeft_y and
        self._expectedCalibDotRight_x == other._expectedCalibDotRight_x and
        self._expectedCalibDotRight_y == other._expectedCalibDotRight_y and
        self._observedCalibDotLeft_x == other._observedCalibDotLeft_x and
        self._observedCalibDotLeft_y == other._observedCalibDotLeft_y and
        self._observedCalibDotRight_x == other._observedCalibDotRight_x and
        self._observedCalibDotRight_y == other._observedCalibDotRight_y and
        self._code == other._code)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._expectedCalibDotLeft_x, 'f') +
      msgbuffers.size(self._expectedCalibDotLeft_y, 'f') +
      msgbuffers.size(self._expectedCalibDotRight_x, 'f') +
      msgbuffers.size(self._expectedCalibDotRight_y, 'f') +
      msgbuffers.size(self._observedCalibDotLeft_x, 'f') +
      msgbuffers.size(self._observedCalibDotLeft_y, 'f') +
      msgbuffers.size(self._observedCalibDotRight_x, 'f') +
      msgbuffers.size(self._observedCalibDotRight_y, 'f') +
      msgbuffers.size(self._code, 'H'))

  def __str__(self):
    return '{type}(expectedCalibDotLeft_x={expectedCalibDotLeft_x}, expectedCalibDotLeft_y={expectedCalibDotLeft_y}, expectedCalibDotRight_x={expectedCalibDotRight_x}, expectedCalibDotRight_y={expectedCalibDotRight_y}, observedCalibDotLeft_x={observedCalibDotLeft_x}, observedCalibDotLeft_y={observedCalibDotLeft_y}, observedCalibDotRight_x={observedCalibDotRight_x}, observedCalibDotRight_y={observedCalibDotRight_y}, code={code})'.format(
      type=type(self).__name__,
      expectedCalibDotLeft_x=self._expectedCalibDotLeft_x,
      expectedCalibDotLeft_y=self._expectedCalibDotLeft_y,
      expectedCalibDotRight_x=self._expectedCalibDotRight_x,
      expectedCalibDotRight_y=self._expectedCalibDotRight_y,
      observedCalibDotLeft_x=self._observedCalibDotLeft_x,
      observedCalibDotLeft_y=self._observedCalibDotLeft_y,
      observedCalibDotRight_x=self._observedCalibDotRight_x,
      observedCalibDotRight_y=self._observedCalibDotRight_y,
      code=self._code)

  def __repr__(self):
    return '{type}(expectedCalibDotLeft_x={expectedCalibDotLeft_x}, expectedCalibDotLeft_y={expectedCalibDotLeft_y}, expectedCalibDotRight_x={expectedCalibDotRight_x}, expectedCalibDotRight_y={expectedCalibDotRight_y}, observedCalibDotLeft_x={observedCalibDotLeft_x}, observedCalibDotLeft_y={observedCalibDotLeft_y}, observedCalibDotRight_x={observedCalibDotRight_x}, observedCalibDotRight_y={observedCalibDotRight_y}, code={code})'.format(
      type=type(self).__name__,
      expectedCalibDotLeft_x=repr(self._expectedCalibDotLeft_x),
      expectedCalibDotLeft_y=repr(self._expectedCalibDotLeft_y),
      expectedCalibDotRight_x=repr(self._expectedCalibDotRight_x),
      expectedCalibDotRight_y=repr(self._expectedCalibDotRight_y),
      observedCalibDotLeft_x=repr(self._observedCalibDotLeft_x),
      observedCalibDotLeft_y=repr(self._observedCalibDotLeft_y),
      observedCalibDotRight_x=repr(self._observedCalibDotRight_x),
      observedCalibDotRight_y=repr(self._observedCalibDotRight_y),
      code=repr(self._code))

Anki.Cozmo.ToolCodeInfo = ToolCodeInfo
del ToolCodeInfo


