# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/unlockTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./src/ -I ../robot/clad/src/ ../coretech/vision/clad/src/ ../coretech/common/clad/src/ -o ../generated/cladPython// clad/types/unlockTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class UnlockId(object):
  "Automatically-generated int_32 enumeration."
  Invalid                 = 0
  All                     = 1
  Defaults                = 2
  BuildPyramid            = 3
  KnockOverThreeCubeStack = 5
  PickupCube              = 6
  RollCube                = 9
  StackTwoCubes           = 10
  TakeCubeFromHand        = 11
  PounceOnMotionAction    = 12
  PopAWheelieAction       = 13
  DroneModeGame           = 14
  KeepawayGame            = 15
  MeetCozmoGame           = 16
  MemoryMatchGame         = 17
  QuickTapGame            = 18
  FaceEnrollmentSlot0     = 19
  FaceEnrollmentSlot1     = 20
  FaceEnrollmentSlot2     = 21
  FaceEnrollmentSlot3     = 22
  FaceEnrollmentSlot4     = 23
  FaceEnrollmentSlot5     = 24
  FaceEnrollmentSlot6     = 25
  FaceEnrollmentSlot7     = 26
  FaceEnrollmentSlot8     = 27
  FaceEnrollmentSlot9     = 28
  Workout                 = 29
  MysteryUnlock1          = 30
  MysteryUnlock2          = 31
  MysteryUnlock3          = 32
  MysteryUnlock4          = 33
  CozmoSaysGame           = 34
  Count                   = 35

Anki.Cozmo.UnlockId = UnlockId
del UnlockId


class UnlockedIdsList(object):
  "Generated message-passing structure."

  __slots__ = (
    '_unlockedIds', # UnlockId[512]
  )

  @property
  def unlockedIds(self):
    "UnlockId[512] unlockedIds struct property."
    return self._unlockedIds

  @unlockedIds.setter
  def unlockedIds(self, value):
    self._unlockedIds = msgbuffers.validate_farray(
      'UnlockedIdsList.unlockedIds', value, 512,
      lambda name, value_inner: msgbuffers.validate_integer(
        name, value_inner, -2147483648, 2147483647))

  def __init__(self, unlockedIds=(Anki.Cozmo.UnlockId.Invalid,) * 512):
    self.unlockedIds = unlockedIds

  @classmethod
  def unpack(cls, buffer):
    "Reads a new UnlockedIdsList from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('UnlockedIdsList.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new UnlockedIdsList from the given BinaryReader."
    _unlockedIds = reader.read_farray('i', 512)
    return cls(_unlockedIds)

  def pack(self):
    "Writes the current UnlockedIdsList, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current UnlockedIdsList to the given BinaryWriter."
    writer.write_farray(self._unlockedIds, 'i', 512)

  def __eq__(self, other):
    if type(self) is type(other):
      return self._unlockedIds == other._unlockedIds
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_farray(self._unlockedIds, 'i', 512))

  def __str__(self):
    return '{type}(unlockedIds={unlockedIds})'.format(
      type=type(self).__name__,
      unlockedIds=msgbuffers.shorten_sequence(self._unlockedIds))

  def __repr__(self):
    return '{type}(unlockedIds={unlockedIds})'.format(
      type=type(self).__name__,
      unlockedIds=repr(self._unlockedIds))

Anki.Cozmo.UnlockedIdsList = UnlockedIdsList
del UnlockedIdsList


