# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/types/vizTypes.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./vizSrc/ -I ../robot/clad/src/ ./src/ -o ../generated/cladPython// clad/types/vizTypes.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()

class VizConstants(object):
  "Automatically-generated uint_32 enumeration."
  VIZ_SERVER_PORT                = 5252
  PHYSICS_PLUGIN_SERVER_PORT     = 5253
  UNITY_VIZ_SERVER_PORT          = 5352
  WEBOTS_PHYSICS_CONTROLLER_PORT = 5354
  ALL_PATH_IDs                   = 0xffffffff
  ALL_QUAD_IDs                   = 0xffffffff
  ALL_QUAD_TYPEs                 = 0xffffffff
  ALL_OBJECT_IDs                 = 0xffffffff
  OBJECT_ID_RANGE                = 0xfffffffe
  MaxMessageSize                 = 2848

Anki.Cozmo.VizConstants = VizConstants
del VizConstants


class VizObjectType(object):
  "Automatically-generated uint_32 enumeration."
  VIZ_OBJECT_ROBOT       = 0
  VIZ_OBJECT_CUBOID      = 1
  VIZ_OBJECT_RAMP        = 2
  VIZ_OBJECT_CHARGER     = 3
  VIZ_OBJECT_PREDOCKPOSE = 4
  VIZ_OBJECT_HUMAN_HEAD  = 5
  VIZ_OBJECT_CAMERA_FACE = 6
  NUM_VIZ_OBJECT_TYPES   = 7

Anki.Cozmo.VizObjectType = VizObjectType
del VizObjectType


class VizQuadType(object):
  "Automatically-generated uint_8 enumeration."
  VIZ_QUAD_GENERIC_2D              = 0
  VIZ_QUAD_GENERIC_3D              = 1
  VIZ_QUAD_MAT_MARKER              = 2
  VIZ_QUAD_PLANNER_OBSTACLE        = 3
  VIZ_QUAD_PLANNER_OBSTACLE_REPLAN = 4
  VIZ_QUAD_ROBOT_BOUNDING_BOX      = 5
  VIZ_QUAD_POSE_MARKER             = 6
  NUM_VIZ_QUAD_TYPES               = 7

Anki.Cozmo.VizQuadType = VizQuadType
del VizQuadType


class VizRobotMarkerType(object):
  "Automatically-generated uint_8 enumeration."
  VIZ_ROBOT_MARKER_SMALL_TRIANGLE = 0
  VIZ_ROBOT_MARKER_BIG_TRIANGLE   = 1

Anki.Cozmo.VizRobotMarkerType = VizRobotMarkerType
del VizRobotMarkerType


