# Copyright (c) 2016 Anki, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License in the file LICENSE.txt or at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Autogenerated python message buffer code.
Source: clad/vizInterface/messageViz.clad
Full command line: ../tools/message-buffers/emitters/Python_emitter.py -C ./vizSrc/ -I ../robot/clad/src/ ./src/ -o ../generated/cladPython// clad/vizInterface/messageViz.clad
"""

from __future__ import absolute_import
from __future__ import print_function

def _modify_path():
  import inspect, os, sys
  search_paths = [
    '../..',
    '../../../../tools/message-buffers/support/python',
  ]
  currentpath = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
  for search_path in search_paths:
    search_path = os.path.normpath(os.path.abspath(os.path.realpath(os.path.join(currentpath, search_path))))
    if search_path not in sys.path:
      sys.path.insert(0, search_path)
_modify_path()

import msgbuffers

Anki = msgbuffers.Namespace()
Anki.Cozmo = msgbuffers.Namespace()
Anki.Cozmo.RobotInterface = msgbuffers.Namespace()
Anki.Cozmo.VizInterface = msgbuffers.Namespace()

from clad.types.globalVizOrigin import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.imageTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.objectTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.robotStatusAndActions import Anki as _Anki
Anki.update(_Anki.deep_clone())

from clad.types.vizTypes import Anki as _Anki
Anki.update(_Anki.deep_clone())

class RobotStateMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_state',                  # Anki.Cozmo.RobotState
    '_numAnimBytesFree',       # int_32
    '_numAnimAudioFramesFree', # int_32
    '_videoFrameRateHz',       # uint_8
    '_imageProcFrameRateHz',   # uint_8
    '_enabledAnimTracks',      # uint_8
    '_animTag',                # uint_8
  )

  @property
  def state(self):
    "Anki.Cozmo.RobotState state struct property."
    return self._state

  @state.setter
  def state(self, value):
    self._state = msgbuffers.validate_object(
      'RobotStateMessage.state', value, Anki.Cozmo.RobotState)

  @property
  def numAnimBytesFree(self):
    "int_32 numAnimBytesFree struct property."
    return self._numAnimBytesFree

  @numAnimBytesFree.setter
  def numAnimBytesFree(self, value):
    self._numAnimBytesFree = msgbuffers.validate_integer(
      'RobotStateMessage.numAnimBytesFree', value, -2147483648, 2147483647)

  @property
  def numAnimAudioFramesFree(self):
    "int_32 numAnimAudioFramesFree struct property."
    return self._numAnimAudioFramesFree

  @numAnimAudioFramesFree.setter
  def numAnimAudioFramesFree(self, value):
    self._numAnimAudioFramesFree = msgbuffers.validate_integer(
      'RobotStateMessage.numAnimAudioFramesFree', value, -2147483648, 2147483647)

  @property
  def videoFrameRateHz(self):
    "uint_8 videoFrameRateHz struct property."
    return self._videoFrameRateHz

  @videoFrameRateHz.setter
  def videoFrameRateHz(self, value):
    self._videoFrameRateHz = msgbuffers.validate_integer(
      'RobotStateMessage.videoFrameRateHz', value, 0, 255)

  @property
  def imageProcFrameRateHz(self):
    "uint_8 imageProcFrameRateHz struct property."
    return self._imageProcFrameRateHz

  @imageProcFrameRateHz.setter
  def imageProcFrameRateHz(self, value):
    self._imageProcFrameRateHz = msgbuffers.validate_integer(
      'RobotStateMessage.imageProcFrameRateHz', value, 0, 255)

  @property
  def enabledAnimTracks(self):
    "uint_8 enabledAnimTracks struct property."
    return self._enabledAnimTracks

  @enabledAnimTracks.setter
  def enabledAnimTracks(self, value):
    self._enabledAnimTracks = msgbuffers.validate_integer(
      'RobotStateMessage.enabledAnimTracks', value, 0, 255)

  @property
  def animTag(self):
    "uint_8 animTag struct property."
    return self._animTag

  @animTag.setter
  def animTag(self, value):
    self._animTag = msgbuffers.validate_integer(
      'RobotStateMessage.animTag', value, 0, 255)

  def __init__(self, state=Anki.Cozmo.RobotState(), numAnimBytesFree=0, numAnimAudioFramesFree=0, videoFrameRateHz=0, imageProcFrameRateHz=0, enabledAnimTracks=0, animTag=0):
    self.state = state
    self.numAnimBytesFree = numAnimBytesFree
    self.numAnimAudioFramesFree = numAnimAudioFramesFree
    self.videoFrameRateHz = videoFrameRateHz
    self.imageProcFrameRateHz = imageProcFrameRateHz
    self.enabledAnimTracks = enabledAnimTracks
    self.animTag = animTag

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotStateMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotStateMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotStateMessage from the given BinaryReader."
    _state = reader.read_object(Anki.Cozmo.RobotState.unpack_from)
    _numAnimBytesFree = reader.read('i')
    _numAnimAudioFramesFree = reader.read('i')
    _videoFrameRateHz = reader.read('B')
    _imageProcFrameRateHz = reader.read('B')
    _enabledAnimTracks = reader.read('B')
    _animTag = reader.read('B')
    return cls(_state, _numAnimBytesFree, _numAnimAudioFramesFree, _videoFrameRateHz, _imageProcFrameRateHz, _enabledAnimTracks, _animTag)

  def pack(self):
    "Writes the current RobotStateMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotStateMessage to the given BinaryWriter."
    writer.write_object(self._state)
    writer.write(self._numAnimBytesFree, 'i')
    writer.write(self._numAnimAudioFramesFree, 'i')
    writer.write(self._videoFrameRateHz, 'B')
    writer.write(self._imageProcFrameRateHz, 'B')
    writer.write(self._enabledAnimTracks, 'B')
    writer.write(self._animTag, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._state == other._state and
        self._numAnimBytesFree == other._numAnimBytesFree and
        self._numAnimAudioFramesFree == other._numAnimAudioFramesFree and
        self._videoFrameRateHz == other._videoFrameRateHz and
        self._imageProcFrameRateHz == other._imageProcFrameRateHz and
        self._enabledAnimTracks == other._enabledAnimTracks and
        self._animTag == other._animTag)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object(self._state) +
      msgbuffers.size(self._numAnimBytesFree, 'i') +
      msgbuffers.size(self._numAnimAudioFramesFree, 'i') +
      msgbuffers.size(self._videoFrameRateHz, 'B') +
      msgbuffers.size(self._imageProcFrameRateHz, 'B') +
      msgbuffers.size(self._enabledAnimTracks, 'B') +
      msgbuffers.size(self._animTag, 'B'))

  def __str__(self):
    return '{type}(state={state}, numAnimBytesFree={numAnimBytesFree}, numAnimAudioFramesFree={numAnimAudioFramesFree}, videoFrameRateHz={videoFrameRateHz}, imageProcFrameRateHz={imageProcFrameRateHz}, enabledAnimTracks={enabledAnimTracks}, animTag={animTag})'.format(
      type=type(self).__name__,
      state=self._state,
      numAnimBytesFree=self._numAnimBytesFree,
      numAnimAudioFramesFree=self._numAnimAudioFramesFree,
      videoFrameRateHz=self._videoFrameRateHz,
      imageProcFrameRateHz=self._imageProcFrameRateHz,
      enabledAnimTracks=self._enabledAnimTracks,
      animTag=self._animTag)

  def __repr__(self):
    return '{type}(state={state}, numAnimBytesFree={numAnimBytesFree}, numAnimAudioFramesFree={numAnimAudioFramesFree}, videoFrameRateHz={videoFrameRateHz}, imageProcFrameRateHz={imageProcFrameRateHz}, enabledAnimTracks={enabledAnimTracks}, animTag={animTag})'.format(
      type=type(self).__name__,
      state=repr(self._state),
      numAnimBytesFree=repr(self._numAnimBytesFree),
      numAnimAudioFramesFree=repr(self._numAnimAudioFramesFree),
      videoFrameRateHz=repr(self._videoFrameRateHz),
      imageProcFrameRateHz=repr(self._imageProcFrameRateHz),
      enabledAnimTracks=repr(self._enabledAnimTracks),
      animTag=repr(self._animTag))

Anki.Cozmo.VizInterface.RobotStateMessage = RobotStateMessage
del RobotStateMessage


class Object(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',      # uint_32
    '_objectTypeID',  # Anki.Cozmo.VizObjectType
    '_color',         # uint_32
    '_x_size_m',      # float_32
    '_y_size_m',      # float_32
    '_z_size_m',      # float_32
    '_x_trans_m',     # float_32
    '_y_trans_m',     # float_32
    '_z_trans_m',     # float_32
    '_rot_deg',       # float_32
    '_rot_axis_x',    # float_32
    '_rot_axis_y',    # float_32
    '_rot_axis_z',    # float_32
    '_objParameters', # float_32[4]
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'Object.objectID', value, 0, 4294967295)

  @property
  def objectTypeID(self):
    "Anki.Cozmo.VizObjectType objectTypeID struct property."
    return self._objectTypeID

  @objectTypeID.setter
  def objectTypeID(self, value):
    self._objectTypeID = msgbuffers.validate_integer(
      'Object.objectTypeID', value, 0, 4294967295)

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'Object.color', value, 0, 4294967295)

  @property
  def x_size_m(self):
    "float_32 x_size_m struct property."
    return self._x_size_m

  @x_size_m.setter
  def x_size_m(self, value):
    self._x_size_m = msgbuffers.validate_float(
      'Object.x_size_m', value, 'f')

  @property
  def y_size_m(self):
    "float_32 y_size_m struct property."
    return self._y_size_m

  @y_size_m.setter
  def y_size_m(self, value):
    self._y_size_m = msgbuffers.validate_float(
      'Object.y_size_m', value, 'f')

  @property
  def z_size_m(self):
    "float_32 z_size_m struct property."
    return self._z_size_m

  @z_size_m.setter
  def z_size_m(self, value):
    self._z_size_m = msgbuffers.validate_float(
      'Object.z_size_m', value, 'f')

  @property
  def x_trans_m(self):
    "float_32 x_trans_m struct property."
    return self._x_trans_m

  @x_trans_m.setter
  def x_trans_m(self, value):
    self._x_trans_m = msgbuffers.validate_float(
      'Object.x_trans_m', value, 'f')

  @property
  def y_trans_m(self):
    "float_32 y_trans_m struct property."
    return self._y_trans_m

  @y_trans_m.setter
  def y_trans_m(self, value):
    self._y_trans_m = msgbuffers.validate_float(
      'Object.y_trans_m', value, 'f')

  @property
  def z_trans_m(self):
    "float_32 z_trans_m struct property."
    return self._z_trans_m

  @z_trans_m.setter
  def z_trans_m(self, value):
    self._z_trans_m = msgbuffers.validate_float(
      'Object.z_trans_m', value, 'f')

  @property
  def rot_deg(self):
    "float_32 rot_deg struct property."
    return self._rot_deg

  @rot_deg.setter
  def rot_deg(self, value):
    self._rot_deg = msgbuffers.validate_float(
      'Object.rot_deg', value, 'f')

  @property
  def rot_axis_x(self):
    "float_32 rot_axis_x struct property."
    return self._rot_axis_x

  @rot_axis_x.setter
  def rot_axis_x(self, value):
    self._rot_axis_x = msgbuffers.validate_float(
      'Object.rot_axis_x', value, 'f')

  @property
  def rot_axis_y(self):
    "float_32 rot_axis_y struct property."
    return self._rot_axis_y

  @rot_axis_y.setter
  def rot_axis_y(self, value):
    self._rot_axis_y = msgbuffers.validate_float(
      'Object.rot_axis_y', value, 'f')

  @property
  def rot_axis_z(self):
    "float_32 rot_axis_z struct property."
    return self._rot_axis_z

  @rot_axis_z.setter
  def rot_axis_z(self, value):
    self._rot_axis_z = msgbuffers.validate_float(
      'Object.rot_axis_z', value, 'f')

  @property
  def objParameters(self):
    "float_32[4] objParameters struct property."
    return self._objParameters

  @objParameters.setter
  def objParameters(self, value):
    self._objParameters = msgbuffers.validate_farray(
      'Object.objParameters', value, 4,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  def __init__(self, objectID=0, objectTypeID=Anki.Cozmo.VizObjectType.VIZ_OBJECT_ROBOT, color=0, x_size_m=0.0, y_size_m=0.0, z_size_m=0.0, x_trans_m=0.0, y_trans_m=0.0, z_trans_m=0.0, rot_deg=0.0, rot_axis_x=0.0, rot_axis_y=0.0, rot_axis_z=0.0, objParameters=(0.0,) * 4):
    self.objectID = objectID
    self.objectTypeID = objectTypeID
    self.color = color
    self.x_size_m = x_size_m
    self.y_size_m = y_size_m
    self.z_size_m = z_size_m
    self.x_trans_m = x_trans_m
    self.y_trans_m = y_trans_m
    self.z_trans_m = z_trans_m
    self.rot_deg = rot_deg
    self.rot_axis_x = rot_axis_x
    self.rot_axis_y = rot_axis_y
    self.rot_axis_z = rot_axis_z
    self.objParameters = objParameters

  @classmethod
  def unpack(cls, buffer):
    "Reads a new Object from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('Object.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new Object from the given BinaryReader."
    _objectID = reader.read('I')
    _objectTypeID = reader.read('I')
    _color = reader.read('I')
    _x_size_m = reader.read('f')
    _y_size_m = reader.read('f')
    _z_size_m = reader.read('f')
    _x_trans_m = reader.read('f')
    _y_trans_m = reader.read('f')
    _z_trans_m = reader.read('f')
    _rot_deg = reader.read('f')
    _rot_axis_x = reader.read('f')
    _rot_axis_y = reader.read('f')
    _rot_axis_z = reader.read('f')
    _objParameters = reader.read_farray('f', 4)
    return cls(_objectID, _objectTypeID, _color, _x_size_m, _y_size_m, _z_size_m, _x_trans_m, _y_trans_m, _z_trans_m, _rot_deg, _rot_axis_x, _rot_axis_y, _rot_axis_z, _objParameters)

  def pack(self):
    "Writes the current Object, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current Object to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._objectTypeID, 'I')
    writer.write(self._color, 'I')
    writer.write(self._x_size_m, 'f')
    writer.write(self._y_size_m, 'f')
    writer.write(self._z_size_m, 'f')
    writer.write(self._x_trans_m, 'f')
    writer.write(self._y_trans_m, 'f')
    writer.write(self._z_trans_m, 'f')
    writer.write(self._rot_deg, 'f')
    writer.write(self._rot_axis_x, 'f')
    writer.write(self._rot_axis_y, 'f')
    writer.write(self._rot_axis_z, 'f')
    writer.write_farray(self._objParameters, 'f', 4)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._objectTypeID == other._objectTypeID and
        self._color == other._color and
        self._x_size_m == other._x_size_m and
        self._y_size_m == other._y_size_m and
        self._z_size_m == other._z_size_m and
        self._x_trans_m == other._x_trans_m and
        self._y_trans_m == other._y_trans_m and
        self._z_trans_m == other._z_trans_m and
        self._rot_deg == other._rot_deg and
        self._rot_axis_x == other._rot_axis_x and
        self._rot_axis_y == other._rot_axis_y and
        self._rot_axis_z == other._rot_axis_z and
        self._objParameters == other._objParameters)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._objectTypeID, 'I') +
      msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._x_size_m, 'f') +
      msgbuffers.size(self._y_size_m, 'f') +
      msgbuffers.size(self._z_size_m, 'f') +
      msgbuffers.size(self._x_trans_m, 'f') +
      msgbuffers.size(self._y_trans_m, 'f') +
      msgbuffers.size(self._z_trans_m, 'f') +
      msgbuffers.size(self._rot_deg, 'f') +
      msgbuffers.size(self._rot_axis_x, 'f') +
      msgbuffers.size(self._rot_axis_y, 'f') +
      msgbuffers.size(self._rot_axis_z, 'f') +
      msgbuffers.size_farray(self._objParameters, 'f', 4))

  def __str__(self):
    return '{type}(objectID={objectID}, objectTypeID={objectTypeID}, color={color}, x_size_m={x_size_m}, y_size_m={y_size_m}, z_size_m={z_size_m}, x_trans_m={x_trans_m}, y_trans_m={y_trans_m}, z_trans_m={z_trans_m}, rot_deg={rot_deg}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, objParameters={objParameters})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      objectTypeID=self._objectTypeID,
      color=self._color,
      x_size_m=self._x_size_m,
      y_size_m=self._y_size_m,
      z_size_m=self._z_size_m,
      x_trans_m=self._x_trans_m,
      y_trans_m=self._y_trans_m,
      z_trans_m=self._z_trans_m,
      rot_deg=self._rot_deg,
      rot_axis_x=self._rot_axis_x,
      rot_axis_y=self._rot_axis_y,
      rot_axis_z=self._rot_axis_z,
      objParameters=msgbuffers.shorten_sequence(self._objParameters))

  def __repr__(self):
    return '{type}(objectID={objectID}, objectTypeID={objectTypeID}, color={color}, x_size_m={x_size_m}, y_size_m={y_size_m}, z_size_m={z_size_m}, x_trans_m={x_trans_m}, y_trans_m={y_trans_m}, z_trans_m={z_trans_m}, rot_deg={rot_deg}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, objParameters={objParameters})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      objectTypeID=repr(self._objectTypeID),
      color=repr(self._color),
      x_size_m=repr(self._x_size_m),
      y_size_m=repr(self._y_size_m),
      z_size_m=repr(self._z_size_m),
      x_trans_m=repr(self._x_trans_m),
      y_trans_m=repr(self._y_trans_m),
      z_trans_m=repr(self._z_trans_m),
      rot_deg=repr(self._rot_deg),
      rot_axis_x=repr(self._rot_axis_x),
      rot_axis_y=repr(self._rot_axis_y),
      rot_axis_z=repr(self._rot_axis_z),
      objParameters=repr(self._objParameters))

Anki.Cozmo.VizInterface.Object = Object
del Object


class SegmentPrimitive(object):
  "Generated message-passing message."

  __slots__ = (
    '_identifier',    # string[uint_8]
    '_color',         # uint_32
    '_origin',        # float_32[3]
    '_dest',          # float_32[3]
    '_clearPrevious', # bool
  )

  @property
  def identifier(self):
    "string[uint_8] identifier struct property."
    return self._identifier

  @identifier.setter
  def identifier(self, value):
    self._identifier = msgbuffers.validate_string(
      'SegmentPrimitive.identifier', value, 255)

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'SegmentPrimitive.color', value, 0, 4294967295)

  @property
  def origin(self):
    "float_32[3] origin struct property."
    return self._origin

  @origin.setter
  def origin(self, value):
    self._origin = msgbuffers.validate_farray(
      'SegmentPrimitive.origin', value, 3,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def dest(self):
    "float_32[3] dest struct property."
    return self._dest

  @dest.setter
  def dest(self, value):
    self._dest = msgbuffers.validate_farray(
      'SegmentPrimitive.dest', value, 3,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def clearPrevious(self):
    "bool clearPrevious struct property."
    return self._clearPrevious

  @clearPrevious.setter
  def clearPrevious(self, value):
    self._clearPrevious = msgbuffers.validate_bool(
      'SegmentPrimitive.clearPrevious', value)

  def __init__(self, identifier='', color=0, origin=(0.0,) * 3, dest=(0.0,) * 3, clearPrevious=False):
    self.identifier = identifier
    self.color = color
    self.origin = origin
    self.dest = dest
    self.clearPrevious = clearPrevious

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SegmentPrimitive from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SegmentPrimitive.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SegmentPrimitive from the given BinaryReader."
    _identifier = reader.read_string('B')
    _color = reader.read('I')
    _origin = reader.read_farray('f', 3)
    _dest = reader.read_farray('f', 3)
    _clearPrevious = bool(reader.read('b'))
    return cls(_identifier, _color, _origin, _dest, _clearPrevious)

  def pack(self):
    "Writes the current SegmentPrimitive, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SegmentPrimitive to the given BinaryWriter."
    writer.write_string(self._identifier, 'B')
    writer.write(self._color, 'I')
    writer.write_farray(self._origin, 'f', 3)
    writer.write_farray(self._dest, 'f', 3)
    writer.write(int(self._clearPrevious), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._identifier == other._identifier and
        self._color == other._color and
        self._origin == other._origin and
        self._dest == other._dest and
        self._clearPrevious == other._clearPrevious)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._identifier, 'B') +
      msgbuffers.size(self._color, 'I') +
      msgbuffers.size_farray(self._origin, 'f', 3) +
      msgbuffers.size_farray(self._dest, 'f', 3) +
      msgbuffers.size(self._clearPrevious, 'b'))

  def __str__(self):
    return '{type}(identifier={identifier}, color={color}, origin={origin}, dest={dest}, clearPrevious={clearPrevious})'.format(
      type=type(self).__name__,
      identifier=msgbuffers.shorten_string(self._identifier),
      color=self._color,
      origin=msgbuffers.shorten_sequence(self._origin),
      dest=msgbuffers.shorten_sequence(self._dest),
      clearPrevious=self._clearPrevious)

  def __repr__(self):
    return '{type}(identifier={identifier}, color={color}, origin={origin}, dest={dest}, clearPrevious={clearPrevious})'.format(
      type=type(self).__name__,
      identifier=repr(self._identifier),
      color=repr(self._color),
      origin=repr(self._origin),
      dest=repr(self._dest),
      clearPrevious=repr(self._clearPrevious))

Anki.Cozmo.VizInterface.SegmentPrimitive = SegmentPrimitive
del SegmentPrimitive


class Quad(object):
  "Generated message-passing message."

  __slots__ = (
    '_quadType',    # Anki.Cozmo.VizQuadType
    '_quadID',      # uint_32
    '_color',       # uint_32
    '_xUpperLeft',  # float_32
    '_yUpperLeft',  # float_32
    '_zUpperLeft',  # float_32
    '_xLowerLeft',  # float_32
    '_yLowerLeft',  # float_32
    '_zLowerLeft',  # float_32
    '_xUpperRight', # float_32
    '_yUpperRight', # float_32
    '_zUpperRight', # float_32
    '_xLowerRight', # float_32
    '_yLowerRight', # float_32
    '_zLowerRight', # float_32
  )

  @property
  def quadType(self):
    "Anki.Cozmo.VizQuadType quadType struct property."
    return self._quadType

  @quadType.setter
  def quadType(self, value):
    self._quadType = msgbuffers.validate_integer(
      'Quad.quadType', value, 0, 255)

  @property
  def quadID(self):
    "uint_32 quadID struct property."
    return self._quadID

  @quadID.setter
  def quadID(self, value):
    self._quadID = msgbuffers.validate_integer(
      'Quad.quadID', value, 0, 4294967295)

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'Quad.color', value, 0, 4294967295)

  @property
  def xUpperLeft(self):
    "float_32 xUpperLeft struct property."
    return self._xUpperLeft

  @xUpperLeft.setter
  def xUpperLeft(self, value):
    self._xUpperLeft = msgbuffers.validate_float(
      'Quad.xUpperLeft', value, 'f')

  @property
  def yUpperLeft(self):
    "float_32 yUpperLeft struct property."
    return self._yUpperLeft

  @yUpperLeft.setter
  def yUpperLeft(self, value):
    self._yUpperLeft = msgbuffers.validate_float(
      'Quad.yUpperLeft', value, 'f')

  @property
  def zUpperLeft(self):
    "float_32 zUpperLeft struct property."
    return self._zUpperLeft

  @zUpperLeft.setter
  def zUpperLeft(self, value):
    self._zUpperLeft = msgbuffers.validate_float(
      'Quad.zUpperLeft', value, 'f')

  @property
  def xLowerLeft(self):
    "float_32 xLowerLeft struct property."
    return self._xLowerLeft

  @xLowerLeft.setter
  def xLowerLeft(self, value):
    self._xLowerLeft = msgbuffers.validate_float(
      'Quad.xLowerLeft', value, 'f')

  @property
  def yLowerLeft(self):
    "float_32 yLowerLeft struct property."
    return self._yLowerLeft

  @yLowerLeft.setter
  def yLowerLeft(self, value):
    self._yLowerLeft = msgbuffers.validate_float(
      'Quad.yLowerLeft', value, 'f')

  @property
  def zLowerLeft(self):
    "float_32 zLowerLeft struct property."
    return self._zLowerLeft

  @zLowerLeft.setter
  def zLowerLeft(self, value):
    self._zLowerLeft = msgbuffers.validate_float(
      'Quad.zLowerLeft', value, 'f')

  @property
  def xUpperRight(self):
    "float_32 xUpperRight struct property."
    return self._xUpperRight

  @xUpperRight.setter
  def xUpperRight(self, value):
    self._xUpperRight = msgbuffers.validate_float(
      'Quad.xUpperRight', value, 'f')

  @property
  def yUpperRight(self):
    "float_32 yUpperRight struct property."
    return self._yUpperRight

  @yUpperRight.setter
  def yUpperRight(self, value):
    self._yUpperRight = msgbuffers.validate_float(
      'Quad.yUpperRight', value, 'f')

  @property
  def zUpperRight(self):
    "float_32 zUpperRight struct property."
    return self._zUpperRight

  @zUpperRight.setter
  def zUpperRight(self, value):
    self._zUpperRight = msgbuffers.validate_float(
      'Quad.zUpperRight', value, 'f')

  @property
  def xLowerRight(self):
    "float_32 xLowerRight struct property."
    return self._xLowerRight

  @xLowerRight.setter
  def xLowerRight(self, value):
    self._xLowerRight = msgbuffers.validate_float(
      'Quad.xLowerRight', value, 'f')

  @property
  def yLowerRight(self):
    "float_32 yLowerRight struct property."
    return self._yLowerRight

  @yLowerRight.setter
  def yLowerRight(self, value):
    self._yLowerRight = msgbuffers.validate_float(
      'Quad.yLowerRight', value, 'f')

  @property
  def zLowerRight(self):
    "float_32 zLowerRight struct property."
    return self._zLowerRight

  @zLowerRight.setter
  def zLowerRight(self, value):
    self._zLowerRight = msgbuffers.validate_float(
      'Quad.zLowerRight', value, 'f')

  def __init__(self, quadType=Anki.Cozmo.VizQuadType.VIZ_QUAD_GENERIC_2D, quadID=0, color=0, xUpperLeft=0.0, yUpperLeft=0.0, zUpperLeft=0.0, xLowerLeft=0.0, yLowerLeft=0.0, zLowerLeft=0.0, xUpperRight=0.0, yUpperRight=0.0, zUpperRight=0.0, xLowerRight=0.0, yLowerRight=0.0, zLowerRight=0.0):
    self.quadType = quadType
    self.quadID = quadID
    self.color = color
    self.xUpperLeft = xUpperLeft
    self.yUpperLeft = yUpperLeft
    self.zUpperLeft = zUpperLeft
    self.xLowerLeft = xLowerLeft
    self.yLowerLeft = yLowerLeft
    self.zLowerLeft = zLowerLeft
    self.xUpperRight = xUpperRight
    self.yUpperRight = yUpperRight
    self.zUpperRight = zUpperRight
    self.xLowerRight = xLowerRight
    self.yLowerRight = yLowerRight
    self.zLowerRight = zLowerRight

  @classmethod
  def unpack(cls, buffer):
    "Reads a new Quad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('Quad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new Quad from the given BinaryReader."
    _quadType = reader.read('B')
    _quadID = reader.read('I')
    _color = reader.read('I')
    _xUpperLeft = reader.read('f')
    _yUpperLeft = reader.read('f')
    _zUpperLeft = reader.read('f')
    _xLowerLeft = reader.read('f')
    _yLowerLeft = reader.read('f')
    _zLowerLeft = reader.read('f')
    _xUpperRight = reader.read('f')
    _yUpperRight = reader.read('f')
    _zUpperRight = reader.read('f')
    _xLowerRight = reader.read('f')
    _yLowerRight = reader.read('f')
    _zLowerRight = reader.read('f')
    return cls(_quadType, _quadID, _color, _xUpperLeft, _yUpperLeft, _zUpperLeft, _xLowerLeft, _yLowerLeft, _zLowerLeft, _xUpperRight, _yUpperRight, _zUpperRight, _xLowerRight, _yLowerRight, _zLowerRight)

  def pack(self):
    "Writes the current Quad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current Quad to the given BinaryWriter."
    writer.write(self._quadType, 'B')
    writer.write(self._quadID, 'I')
    writer.write(self._color, 'I')
    writer.write(self._xUpperLeft, 'f')
    writer.write(self._yUpperLeft, 'f')
    writer.write(self._zUpperLeft, 'f')
    writer.write(self._xLowerLeft, 'f')
    writer.write(self._yLowerLeft, 'f')
    writer.write(self._zLowerLeft, 'f')
    writer.write(self._xUpperRight, 'f')
    writer.write(self._yUpperRight, 'f')
    writer.write(self._zUpperRight, 'f')
    writer.write(self._xLowerRight, 'f')
    writer.write(self._yLowerRight, 'f')
    writer.write(self._zLowerRight, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._quadType == other._quadType and
        self._quadID == other._quadID and
        self._color == other._color and
        self._xUpperLeft == other._xUpperLeft and
        self._yUpperLeft == other._yUpperLeft and
        self._zUpperLeft == other._zUpperLeft and
        self._xLowerLeft == other._xLowerLeft and
        self._yLowerLeft == other._yLowerLeft and
        self._zLowerLeft == other._zLowerLeft and
        self._xUpperRight == other._xUpperRight and
        self._yUpperRight == other._yUpperRight and
        self._zUpperRight == other._zUpperRight and
        self._xLowerRight == other._xLowerRight and
        self._yLowerRight == other._yLowerRight and
        self._zLowerRight == other._zLowerRight)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._quadType, 'B') +
      msgbuffers.size(self._quadID, 'I') +
      msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._xUpperLeft, 'f') +
      msgbuffers.size(self._yUpperLeft, 'f') +
      msgbuffers.size(self._zUpperLeft, 'f') +
      msgbuffers.size(self._xLowerLeft, 'f') +
      msgbuffers.size(self._yLowerLeft, 'f') +
      msgbuffers.size(self._zLowerLeft, 'f') +
      msgbuffers.size(self._xUpperRight, 'f') +
      msgbuffers.size(self._yUpperRight, 'f') +
      msgbuffers.size(self._zUpperRight, 'f') +
      msgbuffers.size(self._xLowerRight, 'f') +
      msgbuffers.size(self._yLowerRight, 'f') +
      msgbuffers.size(self._zLowerRight, 'f'))

  def __str__(self):
    return '{type}(quadType={quadType}, quadID={quadID}, color={color}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, zUpperLeft={zUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, zLowerLeft={zLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, zUpperRight={zUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight}, zLowerRight={zLowerRight})'.format(
      type=type(self).__name__,
      quadType=self._quadType,
      quadID=self._quadID,
      color=self._color,
      xUpperLeft=self._xUpperLeft,
      yUpperLeft=self._yUpperLeft,
      zUpperLeft=self._zUpperLeft,
      xLowerLeft=self._xLowerLeft,
      yLowerLeft=self._yLowerLeft,
      zLowerLeft=self._zLowerLeft,
      xUpperRight=self._xUpperRight,
      yUpperRight=self._yUpperRight,
      zUpperRight=self._zUpperRight,
      xLowerRight=self._xLowerRight,
      yLowerRight=self._yLowerRight,
      zLowerRight=self._zLowerRight)

  def __repr__(self):
    return '{type}(quadType={quadType}, quadID={quadID}, color={color}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, zUpperLeft={zUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, zLowerLeft={zLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, zUpperRight={zUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight}, zLowerRight={zLowerRight})'.format(
      type=type(self).__name__,
      quadType=repr(self._quadType),
      quadID=repr(self._quadID),
      color=repr(self._color),
      xUpperLeft=repr(self._xUpperLeft),
      yUpperLeft=repr(self._yUpperLeft),
      zUpperLeft=repr(self._zUpperLeft),
      xLowerLeft=repr(self._xLowerLeft),
      yLowerLeft=repr(self._yLowerLeft),
      zLowerLeft=repr(self._zLowerLeft),
      xUpperRight=repr(self._xUpperRight),
      yUpperRight=repr(self._yUpperRight),
      zUpperRight=repr(self._zUpperRight),
      xLowerRight=repr(self._xLowerRight),
      yLowerRight=repr(self._yLowerRight),
      zLowerRight=repr(self._zLowerRight))

Anki.Cozmo.VizInterface.Quad = Quad
del Quad


class SimpleQuad(object):
  "Generated message-passing structure."

  __slots__ = (
    '_color',    # uint_32
    '_sideSize', # float_32
    '_center',   # float_32[3]
  )

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'SimpleQuad.color', value, 0, 4294967295)

  @property
  def sideSize(self):
    "float_32 sideSize struct property."
    return self._sideSize

  @sideSize.setter
  def sideSize(self, value):
    self._sideSize = msgbuffers.validate_float(
      'SimpleQuad.sideSize', value, 'f')

  @property
  def center(self):
    "float_32[3] center struct property."
    return self._center

  @center.setter
  def center(self, value):
    self._center = msgbuffers.validate_farray(
      'SimpleQuad.center', value, 3,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  def __init__(self, color=0, sideSize=0.0, center=(0.0,) * 3):
    self.color = color
    self.sideSize = sideSize
    self.center = center

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SimpleQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SimpleQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SimpleQuad from the given BinaryReader."
    _color = reader.read('I')
    _sideSize = reader.read('f')
    _center = reader.read_farray('f', 3)
    return cls(_color, _sideSize, _center)

  def pack(self):
    "Writes the current SimpleQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SimpleQuad to the given BinaryWriter."
    writer.write(self._color, 'I')
    writer.write(self._sideSize, 'f')
    writer.write_farray(self._center, 'f', 3)

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._color == other._color and
        self._sideSize == other._sideSize and
        self._center == other._center)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._sideSize, 'f') +
      msgbuffers.size_farray(self._center, 'f', 3))

  def __str__(self):
    return '{type}(color={color}, sideSize={sideSize}, center={center})'.format(
      type=type(self).__name__,
      color=self._color,
      sideSize=self._sideSize,
      center=msgbuffers.shorten_sequence(self._center))

  def __repr__(self):
    return '{type}(color={color}, sideSize={sideSize}, center={center})'.format(
      type=type(self).__name__,
      color=repr(self._color),
      sideSize=repr(self._sideSize),
      center=repr(self._center))

Anki.Cozmo.VizInterface.SimpleQuad = SimpleQuad
del SimpleQuad


class SimpleQuadVectorMessageBegin(object):
  "Generated message-passing message."

  __slots__ = (
    '_identifier', # string[uint_8]
  )

  @property
  def identifier(self):
    "string[uint_8] identifier struct property."
    return self._identifier

  @identifier.setter
  def identifier(self, value):
    self._identifier = msgbuffers.validate_string(
      'SimpleQuadVectorMessageBegin.identifier', value, 255)

  def __init__(self, identifier=''):
    self.identifier = identifier

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SimpleQuadVectorMessageBegin from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SimpleQuadVectorMessageBegin.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SimpleQuadVectorMessageBegin from the given BinaryReader."
    _identifier = reader.read_string('B')
    return cls(_identifier)

  def pack(self):
    "Writes the current SimpleQuadVectorMessageBegin, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SimpleQuadVectorMessageBegin to the given BinaryWriter."
    writer.write_string(self._identifier, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._identifier == other._identifier
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._identifier, 'B'))

  def __str__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=msgbuffers.shorten_string(self._identifier))

  def __repr__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=repr(self._identifier))

Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin = SimpleQuadVectorMessageBegin
del SimpleQuadVectorMessageBegin


class SimpleQuadVectorMessage(object):
  "Generated message-passing message."

  __slots__ = (
    '_identifier', # string[uint_8]
    '_quads',      # SimpleQuad[uint_8]
  )

  @property
  def identifier(self):
    "string[uint_8] identifier struct property."
    return self._identifier

  @identifier.setter
  def identifier(self, value):
    self._identifier = msgbuffers.validate_string(
      'SimpleQuadVectorMessage.identifier', value, 255)

  @property
  def quads(self):
    "SimpleQuad[uint_8] quads struct property."
    return self._quads

  @quads.setter
  def quads(self, value):
    self._quads = msgbuffers.validate_varray(
      'SimpleQuadVectorMessage.quads', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.VizInterface.SimpleQuad))

  def __init__(self, identifier='', quads=()):
    self.identifier = identifier
    self.quads = quads

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SimpleQuadVectorMessage from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SimpleQuadVectorMessage.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SimpleQuadVectorMessage from the given BinaryReader."
    _identifier = reader.read_string('B')
    _quads = reader.read_object_varray(Anki.Cozmo.VizInterface.SimpleQuad.unpack_from, 'B')
    return cls(_identifier, _quads)

  def pack(self):
    "Writes the current SimpleQuadVectorMessage, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SimpleQuadVectorMessage to the given BinaryWriter."
    writer.write_string(self._identifier, 'B')
    writer.write_object_varray(self._quads, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._identifier == other._identifier and
        self._quads == other._quads)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._identifier, 'B') +
      msgbuffers.size_object_varray(self._quads, 'B'))

  def __str__(self):
    return '{type}(identifier={identifier}, quads={quads})'.format(
      type=type(self).__name__,
      identifier=msgbuffers.shorten_string(self._identifier),
      quads=msgbuffers.shorten_sequence(self._quads))

  def __repr__(self):
    return '{type}(identifier={identifier}, quads={quads})'.format(
      type=type(self).__name__,
      identifier=repr(self._identifier),
      quads=repr(self._quads))

Anki.Cozmo.VizInterface.SimpleQuadVectorMessage = SimpleQuadVectorMessage
del SimpleQuadVectorMessage


class SimpleQuadVectorMessageEnd(object):
  "Generated message-passing message."

  __slots__ = (
    '_identifier', # string[uint_8]
  )

  @property
  def identifier(self):
    "string[uint_8] identifier struct property."
    return self._identifier

  @identifier.setter
  def identifier(self, value):
    self._identifier = msgbuffers.validate_string(
      'SimpleQuadVectorMessageEnd.identifier', value, 255)

  def __init__(self, identifier=''):
    self.identifier = identifier

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SimpleQuadVectorMessageEnd from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SimpleQuadVectorMessageEnd.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SimpleQuadVectorMessageEnd from the given BinaryReader."
    _identifier = reader.read_string('B')
    return cls(_identifier)

  def pack(self):
    "Writes the current SimpleQuadVectorMessageEnd, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SimpleQuadVectorMessageEnd to the given BinaryWriter."
    writer.write_string(self._identifier, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._identifier == other._identifier
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._identifier, 'B'))

  def __str__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=msgbuffers.shorten_string(self._identifier))

  def __repr__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=repr(self._identifier))

Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd = SimpleQuadVectorMessageEnd
del SimpleQuadVectorMessageEnd


class CameraQuad(object):
  "Generated message-passing message."

  __slots__ = (
    '_color',       # uint_32
    '_topColor',    # uint_32
    '_xUpperLeft',  # float_32
    '_yUpperLeft',  # float_32
    '_xLowerLeft',  # float_32
    '_yLowerLeft',  # float_32
    '_xUpperRight', # float_32
    '_yUpperRight', # float_32
    '_xLowerRight', # float_32
    '_yLowerRight', # float_32
  )

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'CameraQuad.color', value, 0, 4294967295)

  @property
  def topColor(self):
    "uint_32 topColor struct property."
    return self._topColor

  @topColor.setter
  def topColor(self, value):
    self._topColor = msgbuffers.validate_integer(
      'CameraQuad.topColor', value, 0, 4294967295)

  @property
  def xUpperLeft(self):
    "float_32 xUpperLeft struct property."
    return self._xUpperLeft

  @xUpperLeft.setter
  def xUpperLeft(self, value):
    self._xUpperLeft = msgbuffers.validate_float(
      'CameraQuad.xUpperLeft', value, 'f')

  @property
  def yUpperLeft(self):
    "float_32 yUpperLeft struct property."
    return self._yUpperLeft

  @yUpperLeft.setter
  def yUpperLeft(self, value):
    self._yUpperLeft = msgbuffers.validate_float(
      'CameraQuad.yUpperLeft', value, 'f')

  @property
  def xLowerLeft(self):
    "float_32 xLowerLeft struct property."
    return self._xLowerLeft

  @xLowerLeft.setter
  def xLowerLeft(self, value):
    self._xLowerLeft = msgbuffers.validate_float(
      'CameraQuad.xLowerLeft', value, 'f')

  @property
  def yLowerLeft(self):
    "float_32 yLowerLeft struct property."
    return self._yLowerLeft

  @yLowerLeft.setter
  def yLowerLeft(self, value):
    self._yLowerLeft = msgbuffers.validate_float(
      'CameraQuad.yLowerLeft', value, 'f')

  @property
  def xUpperRight(self):
    "float_32 xUpperRight struct property."
    return self._xUpperRight

  @xUpperRight.setter
  def xUpperRight(self, value):
    self._xUpperRight = msgbuffers.validate_float(
      'CameraQuad.xUpperRight', value, 'f')

  @property
  def yUpperRight(self):
    "float_32 yUpperRight struct property."
    return self._yUpperRight

  @yUpperRight.setter
  def yUpperRight(self, value):
    self._yUpperRight = msgbuffers.validate_float(
      'CameraQuad.yUpperRight', value, 'f')

  @property
  def xLowerRight(self):
    "float_32 xLowerRight struct property."
    return self._xLowerRight

  @xLowerRight.setter
  def xLowerRight(self, value):
    self._xLowerRight = msgbuffers.validate_float(
      'CameraQuad.xLowerRight', value, 'f')

  @property
  def yLowerRight(self):
    "float_32 yLowerRight struct property."
    return self._yLowerRight

  @yLowerRight.setter
  def yLowerRight(self, value):
    self._yLowerRight = msgbuffers.validate_float(
      'CameraQuad.yLowerRight', value, 'f')

  def __init__(self, color=0, topColor=0, xUpperLeft=0.0, yUpperLeft=0.0, xLowerLeft=0.0, yLowerLeft=0.0, xUpperRight=0.0, yUpperRight=0.0, xLowerRight=0.0, yLowerRight=0.0):
    self.color = color
    self.topColor = topColor
    self.xUpperLeft = xUpperLeft
    self.yUpperLeft = yUpperLeft
    self.xLowerLeft = xLowerLeft
    self.yLowerLeft = yLowerLeft
    self.xUpperRight = xUpperRight
    self.yUpperRight = yUpperRight
    self.xLowerRight = xLowerRight
    self.yLowerRight = yLowerRight

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraQuad from the given BinaryReader."
    _color = reader.read('I')
    _topColor = reader.read('I')
    _xUpperLeft = reader.read('f')
    _yUpperLeft = reader.read('f')
    _xLowerLeft = reader.read('f')
    _yLowerLeft = reader.read('f')
    _xUpperRight = reader.read('f')
    _yUpperRight = reader.read('f')
    _xLowerRight = reader.read('f')
    _yLowerRight = reader.read('f')
    return cls(_color, _topColor, _xUpperLeft, _yUpperLeft, _xLowerLeft, _yLowerLeft, _xUpperRight, _yUpperRight, _xLowerRight, _yLowerRight)

  def pack(self):
    "Writes the current CameraQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraQuad to the given BinaryWriter."
    writer.write(self._color, 'I')
    writer.write(self._topColor, 'I')
    writer.write(self._xUpperLeft, 'f')
    writer.write(self._yUpperLeft, 'f')
    writer.write(self._xLowerLeft, 'f')
    writer.write(self._yLowerLeft, 'f')
    writer.write(self._xUpperRight, 'f')
    writer.write(self._yUpperRight, 'f')
    writer.write(self._xLowerRight, 'f')
    writer.write(self._yLowerRight, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._color == other._color and
        self._topColor == other._topColor and
        self._xUpperLeft == other._xUpperLeft and
        self._yUpperLeft == other._yUpperLeft and
        self._xLowerLeft == other._xLowerLeft and
        self._yLowerLeft == other._yLowerLeft and
        self._xUpperRight == other._xUpperRight and
        self._yUpperRight == other._yUpperRight and
        self._xLowerRight == other._xLowerRight and
        self._yLowerRight == other._yLowerRight)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._topColor, 'I') +
      msgbuffers.size(self._xUpperLeft, 'f') +
      msgbuffers.size(self._yUpperLeft, 'f') +
      msgbuffers.size(self._xLowerLeft, 'f') +
      msgbuffers.size(self._yLowerLeft, 'f') +
      msgbuffers.size(self._xUpperRight, 'f') +
      msgbuffers.size(self._yUpperRight, 'f') +
      msgbuffers.size(self._xLowerRight, 'f') +
      msgbuffers.size(self._yLowerRight, 'f'))

  def __str__(self):
    return '{type}(color={color}, topColor={topColor}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight})'.format(
      type=type(self).__name__,
      color=self._color,
      topColor=self._topColor,
      xUpperLeft=self._xUpperLeft,
      yUpperLeft=self._yUpperLeft,
      xLowerLeft=self._xLowerLeft,
      yLowerLeft=self._yLowerLeft,
      xUpperRight=self._xUpperRight,
      yUpperRight=self._yUpperRight,
      xLowerRight=self._xLowerRight,
      yLowerRight=self._yLowerRight)

  def __repr__(self):
    return '{type}(color={color}, topColor={topColor}, xUpperLeft={xUpperLeft}, yUpperLeft={yUpperLeft}, xLowerLeft={xLowerLeft}, yLowerLeft={yLowerLeft}, xUpperRight={xUpperRight}, yUpperRight={yUpperRight}, xLowerRight={xLowerRight}, yLowerRight={yLowerRight})'.format(
      type=type(self).__name__,
      color=repr(self._color),
      topColor=repr(self._topColor),
      xUpperLeft=repr(self._xUpperLeft),
      yUpperLeft=repr(self._yUpperLeft),
      xLowerLeft=repr(self._xLowerLeft),
      yLowerLeft=repr(self._yLowerLeft),
      xUpperRight=repr(self._xUpperRight),
      yUpperRight=repr(self._yUpperRight),
      xLowerRight=repr(self._xLowerRight),
      yLowerRight=repr(self._yLowerRight))

Anki.Cozmo.VizInterface.CameraQuad = CameraQuad
del CameraQuad


class CameraLine(object):
  "Generated message-passing message."

  __slots__ = (
    '_color',  # uint_32
    '_xStart', # float_32
    '_yStart', # float_32
    '_xEnd',   # float_32
    '_yEnd',   # float_32
  )

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'CameraLine.color', value, 0, 4294967295)

  @property
  def xStart(self):
    "float_32 xStart struct property."
    return self._xStart

  @xStart.setter
  def xStart(self, value):
    self._xStart = msgbuffers.validate_float(
      'CameraLine.xStart', value, 'f')

  @property
  def yStart(self):
    "float_32 yStart struct property."
    return self._yStart

  @yStart.setter
  def yStart(self, value):
    self._yStart = msgbuffers.validate_float(
      'CameraLine.yStart', value, 'f')

  @property
  def xEnd(self):
    "float_32 xEnd struct property."
    return self._xEnd

  @xEnd.setter
  def xEnd(self, value):
    self._xEnd = msgbuffers.validate_float(
      'CameraLine.xEnd', value, 'f')

  @property
  def yEnd(self):
    "float_32 yEnd struct property."
    return self._yEnd

  @yEnd.setter
  def yEnd(self, value):
    self._yEnd = msgbuffers.validate_float(
      'CameraLine.yEnd', value, 'f')

  def __init__(self, color=0, xStart=0.0, yStart=0.0, xEnd=0.0, yEnd=0.0):
    self.color = color
    self.xStart = xStart
    self.yStart = yStart
    self.xEnd = xEnd
    self.yEnd = yEnd

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraLine from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraLine.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraLine from the given BinaryReader."
    _color = reader.read('I')
    _xStart = reader.read('f')
    _yStart = reader.read('f')
    _xEnd = reader.read('f')
    _yEnd = reader.read('f')
    return cls(_color, _xStart, _yStart, _xEnd, _yEnd)

  def pack(self):
    "Writes the current CameraLine, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraLine to the given BinaryWriter."
    writer.write(self._color, 'I')
    writer.write(self._xStart, 'f')
    writer.write(self._yStart, 'f')
    writer.write(self._xEnd, 'f')
    writer.write(self._yEnd, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._color == other._color and
        self._xStart == other._xStart and
        self._yStart == other._yStart and
        self._xEnd == other._xEnd and
        self._yEnd == other._yEnd)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._xStart, 'f') +
      msgbuffers.size(self._yStart, 'f') +
      msgbuffers.size(self._xEnd, 'f') +
      msgbuffers.size(self._yEnd, 'f'))

  def __str__(self):
    return '{type}(color={color}, xStart={xStart}, yStart={yStart}, xEnd={xEnd}, yEnd={yEnd})'.format(
      type=type(self).__name__,
      color=self._color,
      xStart=self._xStart,
      yStart=self._yStart,
      xEnd=self._xEnd,
      yEnd=self._yEnd)

  def __repr__(self):
    return '{type}(color={color}, xStart={xStart}, yStart={yStart}, xEnd={xEnd}, yEnd={yEnd})'.format(
      type=type(self).__name__,
      color=repr(self._color),
      xStart=repr(self._xStart),
      yStart=repr(self._yStart),
      xEnd=repr(self._xEnd),
      yEnd=repr(self._yEnd))

Anki.Cozmo.VizInterface.CameraLine = CameraLine
del CameraLine


class CameraOval(object):
  "Generated message-passing message."

  __slots__ = (
    '_color', # uint_32
    '_xCen',  # float_32
    '_yCen',  # float_32
    '_xRad',  # float_32
    '_yRad',  # float_32
  )

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'CameraOval.color', value, 0, 4294967295)

  @property
  def xCen(self):
    "float_32 xCen struct property."
    return self._xCen

  @xCen.setter
  def xCen(self, value):
    self._xCen = msgbuffers.validate_float(
      'CameraOval.xCen', value, 'f')

  @property
  def yCen(self):
    "float_32 yCen struct property."
    return self._yCen

  @yCen.setter
  def yCen(self, value):
    self._yCen = msgbuffers.validate_float(
      'CameraOval.yCen', value, 'f')

  @property
  def xRad(self):
    "float_32 xRad struct property."
    return self._xRad

  @xRad.setter
  def xRad(self, value):
    self._xRad = msgbuffers.validate_float(
      'CameraOval.xRad', value, 'f')

  @property
  def yRad(self):
    "float_32 yRad struct property."
    return self._yRad

  @yRad.setter
  def yRad(self, value):
    self._yRad = msgbuffers.validate_float(
      'CameraOval.yRad', value, 'f')

  def __init__(self, color=0, xCen=0.0, yCen=0.0, xRad=0.0, yRad=0.0):
    self.color = color
    self.xCen = xCen
    self.yCen = yCen
    self.xRad = xRad
    self.yRad = yRad

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraOval from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraOval.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraOval from the given BinaryReader."
    _color = reader.read('I')
    _xCen = reader.read('f')
    _yCen = reader.read('f')
    _xRad = reader.read('f')
    _yRad = reader.read('f')
    return cls(_color, _xCen, _yCen, _xRad, _yRad)

  def pack(self):
    "Writes the current CameraOval, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraOval to the given BinaryWriter."
    writer.write(self._color, 'I')
    writer.write(self._xCen, 'f')
    writer.write(self._yCen, 'f')
    writer.write(self._xRad, 'f')
    writer.write(self._yRad, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._color == other._color and
        self._xCen == other._xCen and
        self._yCen == other._yCen and
        self._xRad == other._xRad and
        self._yRad == other._yRad)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._xCen, 'f') +
      msgbuffers.size(self._yCen, 'f') +
      msgbuffers.size(self._xRad, 'f') +
      msgbuffers.size(self._yRad, 'f'))

  def __str__(self):
    return '{type}(color={color}, xCen={xCen}, yCen={yCen}, xRad={xRad}, yRad={yRad})'.format(
      type=type(self).__name__,
      color=self._color,
      xCen=self._xCen,
      yCen=self._yCen,
      xRad=self._xRad,
      yRad=self._yRad)

  def __repr__(self):
    return '{type}(color={color}, xCen={xCen}, yCen={yCen}, xRad={xRad}, yRad={yRad})'.format(
      type=type(self).__name__,
      color=repr(self._color),
      xCen=repr(self._xCen),
      yCen=repr(self._yCen),
      xRad=repr(self._xRad),
      yRad=repr(self._yRad))

Anki.Cozmo.VizInterface.CameraOval = CameraOval
del CameraOval


class CameraText(object):
  "Generated message-passing message."

  __slots__ = (
    '_color', # uint_32
    '_x',     # int_32
    '_y',     # int_32
    '_text',  # string[uint_8][uint_8]
  )

  @property
  def color(self):
    "uint_32 color struct property."
    return self._color

  @color.setter
  def color(self, value):
    self._color = msgbuffers.validate_integer(
      'CameraText.color', value, 0, 4294967295)

  @property
  def x(self):
    "int_32 x struct property."
    return self._x

  @x.setter
  def x(self, value):
    self._x = msgbuffers.validate_integer(
      'CameraText.x', value, -2147483648, 2147483647)

  @property
  def y(self):
    "int_32 y struct property."
    return self._y

  @y.setter
  def y(self, value):
    self._y = msgbuffers.validate_integer(
      'CameraText.y', value, -2147483648, 2147483647)

  @property
  def text(self):
    "string[uint_8][uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_varray(
      'CameraText.text', value, 255,
      lambda name, value_inner: msgbuffers.validate_string(
        name, value_inner, 255))

  def __init__(self, color=0, x=0, y=0, text=()):
    self.color = color
    self.x = x
    self.y = y
    self.text = text

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraText from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraText.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraText from the given BinaryReader."
    _color = reader.read('I')
    _x = reader.read('i')
    _y = reader.read('i')
    _text = reader.read_string_varray('B', 'B')
    return cls(_color, _x, _y, _text)

  def pack(self):
    "Writes the current CameraText, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraText to the given BinaryWriter."
    writer.write(self._color, 'I')
    writer.write(self._x, 'i')
    writer.write(self._y, 'i')
    writer.write_string_varray(self._text, 'B', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._color == other._color and
        self._x == other._x and
        self._y == other._y and
        self._text == other._text)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._color, 'I') +
      msgbuffers.size(self._x, 'i') +
      msgbuffers.size(self._y, 'i') +
      msgbuffers.size_string_varray(self._text, 'B', 'B'))

  def __str__(self):
    return '{type}(color={color}, x={x}, y={y}, text={text})'.format(
      type=type(self).__name__,
      color=self._color,
      x=self._x,
      y=self._y,
      text=msgbuffers.shorten_sequence(self._text, msgbuffers.shorten_string))

  def __repr__(self):
    return '{type}(color={color}, x={x}, y={y}, text={text})'.format(
      type=type(self).__name__,
      color=repr(self._color),
      x=repr(self._x),
      y=repr(self._y),
      text=repr(self._text))

Anki.Cozmo.VizInterface.CameraText = CameraText
del CameraText


class EraseObject(object):
  "Generated message-passing message."

  __slots__ = (
    '_objectID',       # uint_32
    '_lower_bound_id', # uint_32
    '_upper_bound_id', # uint_32
  )

  @property
  def objectID(self):
    "uint_32 objectID struct property."
    return self._objectID

  @objectID.setter
  def objectID(self, value):
    self._objectID = msgbuffers.validate_integer(
      'EraseObject.objectID', value, 0, 4294967295)

  @property
  def lower_bound_id(self):
    "uint_32 lower_bound_id struct property."
    return self._lower_bound_id

  @lower_bound_id.setter
  def lower_bound_id(self, value):
    self._lower_bound_id = msgbuffers.validate_integer(
      'EraseObject.lower_bound_id', value, 0, 4294967295)

  @property
  def upper_bound_id(self):
    "uint_32 upper_bound_id struct property."
    return self._upper_bound_id

  @upper_bound_id.setter
  def upper_bound_id(self, value):
    self._upper_bound_id = msgbuffers.validate_integer(
      'EraseObject.upper_bound_id', value, 0, 4294967295)

  def __init__(self, objectID=0, lower_bound_id=0, upper_bound_id=0):
    self.objectID = objectID
    self.lower_bound_id = lower_bound_id
    self.upper_bound_id = upper_bound_id

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseObject from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseObject.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseObject from the given BinaryReader."
    _objectID = reader.read('I')
    _lower_bound_id = reader.read('I')
    _upper_bound_id = reader.read('I')
    return cls(_objectID, _lower_bound_id, _upper_bound_id)

  def pack(self):
    "Writes the current EraseObject, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseObject to the given BinaryWriter."
    writer.write(self._objectID, 'I')
    writer.write(self._lower_bound_id, 'I')
    writer.write(self._upper_bound_id, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._objectID == other._objectID and
        self._lower_bound_id == other._lower_bound_id and
        self._upper_bound_id == other._upper_bound_id)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._objectID, 'I') +
      msgbuffers.size(self._lower_bound_id, 'I') +
      msgbuffers.size(self._upper_bound_id, 'I'))

  def __str__(self):
    return '{type}(objectID={objectID}, lower_bound_id={lower_bound_id}, upper_bound_id={upper_bound_id})'.format(
      type=type(self).__name__,
      objectID=self._objectID,
      lower_bound_id=self._lower_bound_id,
      upper_bound_id=self._upper_bound_id)

  def __repr__(self):
    return '{type}(objectID={objectID}, lower_bound_id={lower_bound_id}, upper_bound_id={upper_bound_id})'.format(
      type=type(self).__name__,
      objectID=repr(self._objectID),
      lower_bound_id=repr(self._lower_bound_id),
      upper_bound_id=repr(self._upper_bound_id))

Anki.Cozmo.VizInterface.EraseObject = EraseObject
del EraseObject


class EraseSegmentPrimitives(object):
  "Generated message-passing message."

  __slots__ = (
    '_identifier', # string[uint_8]
  )

  @property
  def identifier(self):
    "string[uint_8] identifier struct property."
    return self._identifier

  @identifier.setter
  def identifier(self, value):
    self._identifier = msgbuffers.validate_string(
      'EraseSegmentPrimitives.identifier', value, 255)

  def __init__(self, identifier=''):
    self.identifier = identifier

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseSegmentPrimitives from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseSegmentPrimitives.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseSegmentPrimitives from the given BinaryReader."
    _identifier = reader.read_string('B')
    return cls(_identifier)

  def pack(self):
    "Writes the current EraseSegmentPrimitives, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseSegmentPrimitives to the given BinaryWriter."
    writer.write_string(self._identifier, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._identifier == other._identifier
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._identifier, 'B'))

  def __str__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=msgbuffers.shorten_string(self._identifier))

  def __repr__(self):
    return '{type}(identifier={identifier})'.format(
      type=type(self).__name__,
      identifier=repr(self._identifier))

Anki.Cozmo.VizInterface.EraseSegmentPrimitives = EraseSegmentPrimitives
del EraseSegmentPrimitives


class EraseQuad(object):
  "Generated message-passing message."

  __slots__ = (
    '_quadType', # uint_32
    '_quadID',   # uint_32
  )

  @property
  def quadType(self):
    "uint_32 quadType struct property."
    return self._quadType

  @quadType.setter
  def quadType(self, value):
    self._quadType = msgbuffers.validate_integer(
      'EraseQuad.quadType', value, 0, 4294967295)

  @property
  def quadID(self):
    "uint_32 quadID struct property."
    return self._quadID

  @quadID.setter
  def quadID(self, value):
    self._quadID = msgbuffers.validate_integer(
      'EraseQuad.quadID', value, 0, 4294967295)

  def __init__(self, quadType=0, quadID=0):
    self.quadType = quadType
    self.quadID = quadID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EraseQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EraseQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EraseQuad from the given BinaryReader."
    _quadType = reader.read('I')
    _quadID = reader.read('I')
    return cls(_quadType, _quadID)

  def pack(self):
    "Writes the current EraseQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EraseQuad to the given BinaryWriter."
    writer.write(self._quadType, 'I')
    writer.write(self._quadID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._quadType == other._quadType and
        self._quadID == other._quadID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._quadType, 'I') +
      msgbuffers.size(self._quadID, 'I'))

  def __str__(self):
    return '{type}(quadType={quadType}, quadID={quadID})'.format(
      type=type(self).__name__,
      quadType=self._quadType,
      quadID=self._quadID)

  def __repr__(self):
    return '{type}(quadType={quadType}, quadID={quadID})'.format(
      type=type(self).__name__,
      quadType=repr(self._quadType),
      quadID=repr(self._quadID))

Anki.Cozmo.VizInterface.EraseQuad = EraseQuad
del EraseQuad


class SetRobot(object):
  "Generated message-passing message."

  __slots__ = (
    '_robotID',    # uint_32
    '_x_trans_m',  # float_32
    '_y_trans_m',  # float_32
    '_z_trans_m',  # float_32
    '_rot_rad',    # float_32
    '_rot_axis_x', # float_32
    '_rot_axis_y', # float_32
    '_rot_axis_z', # float_32
    '_head_angle', # float_32
    '_lift_angle', # float_32
  )

  @property
  def robotID(self):
    "uint_32 robotID struct property."
    return self._robotID

  @robotID.setter
  def robotID(self, value):
    self._robotID = msgbuffers.validate_integer(
      'SetRobot.robotID', value, 0, 4294967295)

  @property
  def x_trans_m(self):
    "float_32 x_trans_m struct property."
    return self._x_trans_m

  @x_trans_m.setter
  def x_trans_m(self, value):
    self._x_trans_m = msgbuffers.validate_float(
      'SetRobot.x_trans_m', value, 'f')

  @property
  def y_trans_m(self):
    "float_32 y_trans_m struct property."
    return self._y_trans_m

  @y_trans_m.setter
  def y_trans_m(self, value):
    self._y_trans_m = msgbuffers.validate_float(
      'SetRobot.y_trans_m', value, 'f')

  @property
  def z_trans_m(self):
    "float_32 z_trans_m struct property."
    return self._z_trans_m

  @z_trans_m.setter
  def z_trans_m(self, value):
    self._z_trans_m = msgbuffers.validate_float(
      'SetRobot.z_trans_m', value, 'f')

  @property
  def rot_rad(self):
    "float_32 rot_rad struct property."
    return self._rot_rad

  @rot_rad.setter
  def rot_rad(self, value):
    self._rot_rad = msgbuffers.validate_float(
      'SetRobot.rot_rad', value, 'f')

  @property
  def rot_axis_x(self):
    "float_32 rot_axis_x struct property."
    return self._rot_axis_x

  @rot_axis_x.setter
  def rot_axis_x(self, value):
    self._rot_axis_x = msgbuffers.validate_float(
      'SetRobot.rot_axis_x', value, 'f')

  @property
  def rot_axis_y(self):
    "float_32 rot_axis_y struct property."
    return self._rot_axis_y

  @rot_axis_y.setter
  def rot_axis_y(self, value):
    self._rot_axis_y = msgbuffers.validate_float(
      'SetRobot.rot_axis_y', value, 'f')

  @property
  def rot_axis_z(self):
    "float_32 rot_axis_z struct property."
    return self._rot_axis_z

  @rot_axis_z.setter
  def rot_axis_z(self, value):
    self._rot_axis_z = msgbuffers.validate_float(
      'SetRobot.rot_axis_z', value, 'f')

  @property
  def head_angle(self):
    "float_32 head_angle struct property."
    return self._head_angle

  @head_angle.setter
  def head_angle(self, value):
    self._head_angle = msgbuffers.validate_float(
      'SetRobot.head_angle', value, 'f')

  @property
  def lift_angle(self):
    "float_32 lift_angle struct property."
    return self._lift_angle

  @lift_angle.setter
  def lift_angle(self, value):
    self._lift_angle = msgbuffers.validate_float(
      'SetRobot.lift_angle', value, 'f')

  def __init__(self, robotID=0, x_trans_m=0.0, y_trans_m=0.0, z_trans_m=0.0, rot_rad=0.0, rot_axis_x=0.0, rot_axis_y=0.0, rot_axis_z=0.0, head_angle=0.0, lift_angle=0.0):
    self.robotID = robotID
    self.x_trans_m = x_trans_m
    self.y_trans_m = y_trans_m
    self.z_trans_m = z_trans_m
    self.rot_rad = rot_rad
    self.rot_axis_x = rot_axis_x
    self.rot_axis_y = rot_axis_y
    self.rot_axis_z = rot_axis_z
    self.head_angle = head_angle
    self.lift_angle = lift_angle

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetRobot from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetRobot.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetRobot from the given BinaryReader."
    _robotID = reader.read('I')
    _x_trans_m = reader.read('f')
    _y_trans_m = reader.read('f')
    _z_trans_m = reader.read('f')
    _rot_rad = reader.read('f')
    _rot_axis_x = reader.read('f')
    _rot_axis_y = reader.read('f')
    _rot_axis_z = reader.read('f')
    _head_angle = reader.read('f')
    _lift_angle = reader.read('f')
    return cls(_robotID, _x_trans_m, _y_trans_m, _z_trans_m, _rot_rad, _rot_axis_x, _rot_axis_y, _rot_axis_z, _head_angle, _lift_angle)

  def pack(self):
    "Writes the current SetRobot, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetRobot to the given BinaryWriter."
    writer.write(self._robotID, 'I')
    writer.write(self._x_trans_m, 'f')
    writer.write(self._y_trans_m, 'f')
    writer.write(self._z_trans_m, 'f')
    writer.write(self._rot_rad, 'f')
    writer.write(self._rot_axis_x, 'f')
    writer.write(self._rot_axis_y, 'f')
    writer.write(self._rot_axis_z, 'f')
    writer.write(self._head_angle, 'f')
    writer.write(self._lift_angle, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._robotID == other._robotID and
        self._x_trans_m == other._x_trans_m and
        self._y_trans_m == other._y_trans_m and
        self._z_trans_m == other._z_trans_m and
        self._rot_rad == other._rot_rad and
        self._rot_axis_x == other._rot_axis_x and
        self._rot_axis_y == other._rot_axis_y and
        self._rot_axis_z == other._rot_axis_z and
        self._head_angle == other._head_angle and
        self._lift_angle == other._lift_angle)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._robotID, 'I') +
      msgbuffers.size(self._x_trans_m, 'f') +
      msgbuffers.size(self._y_trans_m, 'f') +
      msgbuffers.size(self._z_trans_m, 'f') +
      msgbuffers.size(self._rot_rad, 'f') +
      msgbuffers.size(self._rot_axis_x, 'f') +
      msgbuffers.size(self._rot_axis_y, 'f') +
      msgbuffers.size(self._rot_axis_z, 'f') +
      msgbuffers.size(self._head_angle, 'f') +
      msgbuffers.size(self._lift_angle, 'f'))

  def __str__(self):
    return '{type}(robotID={robotID}, x_trans_m={x_trans_m}, y_trans_m={y_trans_m}, z_trans_m={z_trans_m}, rot_rad={rot_rad}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, head_angle={head_angle}, lift_angle={lift_angle})'.format(
      type=type(self).__name__,
      robotID=self._robotID,
      x_trans_m=self._x_trans_m,
      y_trans_m=self._y_trans_m,
      z_trans_m=self._z_trans_m,
      rot_rad=self._rot_rad,
      rot_axis_x=self._rot_axis_x,
      rot_axis_y=self._rot_axis_y,
      rot_axis_z=self._rot_axis_z,
      head_angle=self._head_angle,
      lift_angle=self._lift_angle)

  def __repr__(self):
    return '{type}(robotID={robotID}, x_trans_m={x_trans_m}, y_trans_m={y_trans_m}, z_trans_m={z_trans_m}, rot_rad={rot_rad}, rot_axis_x={rot_axis_x}, rot_axis_y={rot_axis_y}, rot_axis_z={rot_axis_z}, head_angle={head_angle}, lift_angle={lift_angle})'.format(
      type=type(self).__name__,
      robotID=repr(self._robotID),
      x_trans_m=repr(self._x_trans_m),
      y_trans_m=repr(self._y_trans_m),
      z_trans_m=repr(self._z_trans_m),
      rot_rad=repr(self._rot_rad),
      rot_axis_x=repr(self._rot_axis_x),
      rot_axis_y=repr(self._rot_axis_y),
      rot_axis_z=repr(self._rot_axis_z),
      head_angle=repr(self._head_angle),
      lift_angle=repr(self._lift_angle))

Anki.Cozmo.VizInterface.SetRobot = SetRobot
del SetRobot


class AppendPathSegmentLine(object):
  "Generated message-passing message."

  __slots__ = (
    '_pathID',    # uint_32
    '_x_start_m', # float_32
    '_y_start_m', # float_32
    '_z_start_m', # float_32
    '_x_end_m',   # float_32
    '_y_end_m',   # float_32
    '_z_end_m',   # float_32
  )

  @property
  def pathID(self):
    "uint_32 pathID struct property."
    return self._pathID

  @pathID.setter
  def pathID(self, value):
    self._pathID = msgbuffers.validate_integer(
      'AppendPathSegmentLine.pathID', value, 0, 4294967295)

  @property
  def x_start_m(self):
    "float_32 x_start_m struct property."
    return self._x_start_m

  @x_start_m.setter
  def x_start_m(self, value):
    self._x_start_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.x_start_m', value, 'f')

  @property
  def y_start_m(self):
    "float_32 y_start_m struct property."
    return self._y_start_m

  @y_start_m.setter
  def y_start_m(self, value):
    self._y_start_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.y_start_m', value, 'f')

  @property
  def z_start_m(self):
    "float_32 z_start_m struct property."
    return self._z_start_m

  @z_start_m.setter
  def z_start_m(self, value):
    self._z_start_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.z_start_m', value, 'f')

  @property
  def x_end_m(self):
    "float_32 x_end_m struct property."
    return self._x_end_m

  @x_end_m.setter
  def x_end_m(self, value):
    self._x_end_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.x_end_m', value, 'f')

  @property
  def y_end_m(self):
    "float_32 y_end_m struct property."
    return self._y_end_m

  @y_end_m.setter
  def y_end_m(self, value):
    self._y_end_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.y_end_m', value, 'f')

  @property
  def z_end_m(self):
    "float_32 z_end_m struct property."
    return self._z_end_m

  @z_end_m.setter
  def z_end_m(self, value):
    self._z_end_m = msgbuffers.validate_float(
      'AppendPathSegmentLine.z_end_m', value, 'f')

  def __init__(self, pathID=0, x_start_m=0.0, y_start_m=0.0, z_start_m=0.0, x_end_m=0.0, y_end_m=0.0, z_end_m=0.0):
    self.pathID = pathID
    self.x_start_m = x_start_m
    self.y_start_m = y_start_m
    self.z_start_m = z_start_m
    self.x_end_m = x_end_m
    self.y_end_m = y_end_m
    self.z_end_m = z_end_m

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AppendPathSegmentLine from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AppendPathSegmentLine.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AppendPathSegmentLine from the given BinaryReader."
    _pathID = reader.read('I')
    _x_start_m = reader.read('f')
    _y_start_m = reader.read('f')
    _z_start_m = reader.read('f')
    _x_end_m = reader.read('f')
    _y_end_m = reader.read('f')
    _z_end_m = reader.read('f')
    return cls(_pathID, _x_start_m, _y_start_m, _z_start_m, _x_end_m, _y_end_m, _z_end_m)

  def pack(self):
    "Writes the current AppendPathSegmentLine, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AppendPathSegmentLine to the given BinaryWriter."
    writer.write(self._pathID, 'I')
    writer.write(self._x_start_m, 'f')
    writer.write(self._y_start_m, 'f')
    writer.write(self._z_start_m, 'f')
    writer.write(self._x_end_m, 'f')
    writer.write(self._y_end_m, 'f')
    writer.write(self._z_end_m, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._pathID == other._pathID and
        self._x_start_m == other._x_start_m and
        self._y_start_m == other._y_start_m and
        self._z_start_m == other._z_start_m and
        self._x_end_m == other._x_end_m and
        self._y_end_m == other._y_end_m and
        self._z_end_m == other._z_end_m)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._pathID, 'I') +
      msgbuffers.size(self._x_start_m, 'f') +
      msgbuffers.size(self._y_start_m, 'f') +
      msgbuffers.size(self._z_start_m, 'f') +
      msgbuffers.size(self._x_end_m, 'f') +
      msgbuffers.size(self._y_end_m, 'f') +
      msgbuffers.size(self._z_end_m, 'f'))

  def __str__(self):
    return '{type}(pathID={pathID}, x_start_m={x_start_m}, y_start_m={y_start_m}, z_start_m={z_start_m}, x_end_m={x_end_m}, y_end_m={y_end_m}, z_end_m={z_end_m})'.format(
      type=type(self).__name__,
      pathID=self._pathID,
      x_start_m=self._x_start_m,
      y_start_m=self._y_start_m,
      z_start_m=self._z_start_m,
      x_end_m=self._x_end_m,
      y_end_m=self._y_end_m,
      z_end_m=self._z_end_m)

  def __repr__(self):
    return '{type}(pathID={pathID}, x_start_m={x_start_m}, y_start_m={y_start_m}, z_start_m={z_start_m}, x_end_m={x_end_m}, y_end_m={y_end_m}, z_end_m={z_end_m})'.format(
      type=type(self).__name__,
      pathID=repr(self._pathID),
      x_start_m=repr(self._x_start_m),
      y_start_m=repr(self._y_start_m),
      z_start_m=repr(self._z_start_m),
      x_end_m=repr(self._x_end_m),
      y_end_m=repr(self._y_end_m),
      z_end_m=repr(self._z_end_m))

Anki.Cozmo.VizInterface.AppendPathSegmentLine = AppendPathSegmentLine
del AppendPathSegmentLine


class AppendPathSegmentArc(object):
  "Generated message-passing message."

  __slots__ = (
    '_pathID',     # uint_32
    '_x_center_m', # float_32
    '_y_center_m', # float_32
    '_radius_m',   # float_32
    '_start_rad',  # float_32
    '_sweep_rad',  # float_32
  )

  @property
  def pathID(self):
    "uint_32 pathID struct property."
    return self._pathID

  @pathID.setter
  def pathID(self, value):
    self._pathID = msgbuffers.validate_integer(
      'AppendPathSegmentArc.pathID', value, 0, 4294967295)

  @property
  def x_center_m(self):
    "float_32 x_center_m struct property."
    return self._x_center_m

  @x_center_m.setter
  def x_center_m(self, value):
    self._x_center_m = msgbuffers.validate_float(
      'AppendPathSegmentArc.x_center_m', value, 'f')

  @property
  def y_center_m(self):
    "float_32 y_center_m struct property."
    return self._y_center_m

  @y_center_m.setter
  def y_center_m(self, value):
    self._y_center_m = msgbuffers.validate_float(
      'AppendPathSegmentArc.y_center_m', value, 'f')

  @property
  def radius_m(self):
    "float_32 radius_m struct property."
    return self._radius_m

  @radius_m.setter
  def radius_m(self, value):
    self._radius_m = msgbuffers.validate_float(
      'AppendPathSegmentArc.radius_m', value, 'f')

  @property
  def start_rad(self):
    "float_32 start_rad struct property."
    return self._start_rad

  @start_rad.setter
  def start_rad(self, value):
    self._start_rad = msgbuffers.validate_float(
      'AppendPathSegmentArc.start_rad', value, 'f')

  @property
  def sweep_rad(self):
    "float_32 sweep_rad struct property."
    return self._sweep_rad

  @sweep_rad.setter
  def sweep_rad(self, value):
    self._sweep_rad = msgbuffers.validate_float(
      'AppendPathSegmentArc.sweep_rad', value, 'f')

  def __init__(self, pathID=0, x_center_m=0.0, y_center_m=0.0, radius_m=0.0, start_rad=0.0, sweep_rad=0.0):
    self.pathID = pathID
    self.x_center_m = x_center_m
    self.y_center_m = y_center_m
    self.radius_m = radius_m
    self.start_rad = start_rad
    self.sweep_rad = sweep_rad

  @classmethod
  def unpack(cls, buffer):
    "Reads a new AppendPathSegmentArc from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('AppendPathSegmentArc.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new AppendPathSegmentArc from the given BinaryReader."
    _pathID = reader.read('I')
    _x_center_m = reader.read('f')
    _y_center_m = reader.read('f')
    _radius_m = reader.read('f')
    _start_rad = reader.read('f')
    _sweep_rad = reader.read('f')
    return cls(_pathID, _x_center_m, _y_center_m, _radius_m, _start_rad, _sweep_rad)

  def pack(self):
    "Writes the current AppendPathSegmentArc, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current AppendPathSegmentArc to the given BinaryWriter."
    writer.write(self._pathID, 'I')
    writer.write(self._x_center_m, 'f')
    writer.write(self._y_center_m, 'f')
    writer.write(self._radius_m, 'f')
    writer.write(self._start_rad, 'f')
    writer.write(self._sweep_rad, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._pathID == other._pathID and
        self._x_center_m == other._x_center_m and
        self._y_center_m == other._y_center_m and
        self._radius_m == other._radius_m and
        self._start_rad == other._start_rad and
        self._sweep_rad == other._sweep_rad)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._pathID, 'I') +
      msgbuffers.size(self._x_center_m, 'f') +
      msgbuffers.size(self._y_center_m, 'f') +
      msgbuffers.size(self._radius_m, 'f') +
      msgbuffers.size(self._start_rad, 'f') +
      msgbuffers.size(self._sweep_rad, 'f'))

  def __str__(self):
    return '{type}(pathID={pathID}, x_center_m={x_center_m}, y_center_m={y_center_m}, radius_m={radius_m}, start_rad={start_rad}, sweep_rad={sweep_rad})'.format(
      type=type(self).__name__,
      pathID=self._pathID,
      x_center_m=self._x_center_m,
      y_center_m=self._y_center_m,
      radius_m=self._radius_m,
      start_rad=self._start_rad,
      sweep_rad=self._sweep_rad)

  def __repr__(self):
    return '{type}(pathID={pathID}, x_center_m={x_center_m}, y_center_m={y_center_m}, radius_m={radius_m}, start_rad={start_rad}, sweep_rad={sweep_rad})'.format(
      type=type(self).__name__,
      pathID=repr(self._pathID),
      x_center_m=repr(self._x_center_m),
      y_center_m=repr(self._y_center_m),
      radius_m=repr(self._radius_m),
      start_rad=repr(self._start_rad),
      sweep_rad=repr(self._sweep_rad))

Anki.Cozmo.VizInterface.AppendPathSegmentArc = AppendPathSegmentArc
del AppendPathSegmentArc


class SetPathColor(object):
  "Generated message-passing message."

  __slots__ = (
    '_pathID',  # uint_32
    '_colorID', # uint_32
  )

  @property
  def pathID(self):
    "uint_32 pathID struct property."
    return self._pathID

  @pathID.setter
  def pathID(self, value):
    self._pathID = msgbuffers.validate_integer(
      'SetPathColor.pathID', value, 0, 4294967295)

  @property
  def colorID(self):
    "uint_32 colorID struct property."
    return self._colorID

  @colorID.setter
  def colorID(self, value):
    self._colorID = msgbuffers.validate_integer(
      'SetPathColor.colorID', value, 0, 4294967295)

  def __init__(self, pathID=0, colorID=0):
    self.pathID = pathID
    self.colorID = colorID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetPathColor from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetPathColor.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetPathColor from the given BinaryReader."
    _pathID = reader.read('I')
    _colorID = reader.read('I')
    return cls(_pathID, _colorID)

  def pack(self):
    "Writes the current SetPathColor, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetPathColor to the given BinaryWriter."
    writer.write(self._pathID, 'I')
    writer.write(self._colorID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._pathID == other._pathID and
        self._colorID == other._colorID)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._pathID, 'I') +
      msgbuffers.size(self._colorID, 'I'))

  def __str__(self):
    return '{type}(pathID={pathID}, colorID={colorID})'.format(
      type=type(self).__name__,
      pathID=self._pathID,
      colorID=self._colorID)

  def __repr__(self):
    return '{type}(pathID={pathID}, colorID={colorID})'.format(
      type=type(self).__name__,
      pathID=repr(self._pathID),
      colorID=repr(self._colorID))

Anki.Cozmo.VizInterface.SetPathColor = SetPathColor
del SetPathColor


class ErasePath(object):
  "Generated message-passing message."

  __slots__ = (
    '_pathID', # uint_32
  )

  @property
  def pathID(self):
    "uint_32 pathID struct property."
    return self._pathID

  @pathID.setter
  def pathID(self, value):
    self._pathID = msgbuffers.validate_integer(
      'ErasePath.pathID', value, 0, 4294967295)

  def __init__(self, pathID=0):
    self.pathID = pathID

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ErasePath from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ErasePath.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ErasePath from the given BinaryReader."
    _pathID = reader.read('I')
    return cls(_pathID)

  def pack(self):
    "Writes the current ErasePath, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ErasePath to the given BinaryWriter."
    writer.write(self._pathID, 'I')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._pathID == other._pathID
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._pathID, 'I'))

  def __str__(self):
    return '{type}(pathID={pathID})'.format(
      type=type(self).__name__,
      pathID=self._pathID)

  def __repr__(self):
    return '{type}(pathID={pathID})'.format(
      type=type(self).__name__,
      pathID=repr(self._pathID))

Anki.Cozmo.VizInterface.ErasePath = ErasePath
del ErasePath


class DefineColor(object):
  "Generated message-passing message."

  __slots__ = (
    '_colorID', # uint_32
    '_r',       # float_32
    '_g',       # float_32
    '_b',       # float_32
    '_alpha',   # float_32
  )

  @property
  def colorID(self):
    "uint_32 colorID struct property."
    return self._colorID

  @colorID.setter
  def colorID(self, value):
    self._colorID = msgbuffers.validate_integer(
      'DefineColor.colorID', value, 0, 4294967295)

  @property
  def r(self):
    "float_32 r struct property."
    return self._r

  @r.setter
  def r(self, value):
    self._r = msgbuffers.validate_float(
      'DefineColor.r', value, 'f')

  @property
  def g(self):
    "float_32 g struct property."
    return self._g

  @g.setter
  def g(self, value):
    self._g = msgbuffers.validate_float(
      'DefineColor.g', value, 'f')

  @property
  def b(self):
    "float_32 b struct property."
    return self._b

  @b.setter
  def b(self, value):
    self._b = msgbuffers.validate_float(
      'DefineColor.b', value, 'f')

  @property
  def alpha(self):
    "float_32 alpha struct property."
    return self._alpha

  @alpha.setter
  def alpha(self, value):
    self._alpha = msgbuffers.validate_float(
      'DefineColor.alpha', value, 'f')

  def __init__(self, colorID=0, r=0.0, g=0.0, b=0.0, alpha=0.0):
    self.colorID = colorID
    self.r = r
    self.g = g
    self.b = b
    self.alpha = alpha

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DefineColor from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DefineColor.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DefineColor from the given BinaryReader."
    _colorID = reader.read('I')
    _r = reader.read('f')
    _g = reader.read('f')
    _b = reader.read('f')
    _alpha = reader.read('f')
    return cls(_colorID, _r, _g, _b, _alpha)

  def pack(self):
    "Writes the current DefineColor, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DefineColor to the given BinaryWriter."
    writer.write(self._colorID, 'I')
    writer.write(self._r, 'f')
    writer.write(self._g, 'f')
    writer.write(self._b, 'f')
    writer.write(self._alpha, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._colorID == other._colorID and
        self._r == other._r and
        self._g == other._g and
        self._b == other._b and
        self._alpha == other._alpha)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._colorID, 'I') +
      msgbuffers.size(self._r, 'f') +
      msgbuffers.size(self._g, 'f') +
      msgbuffers.size(self._b, 'f') +
      msgbuffers.size(self._alpha, 'f'))

  def __str__(self):
    return '{type}(colorID={colorID}, r={r}, g={g}, b={b}, alpha={alpha})'.format(
      type=type(self).__name__,
      colorID=self._colorID,
      r=self._r,
      g=self._g,
      b=self._b,
      alpha=self._alpha)

  def __repr__(self):
    return '{type}(colorID={colorID}, r={r}, g={g}, b={b}, alpha={alpha})'.format(
      type=type(self).__name__,
      colorID=repr(self._colorID),
      r=repr(self._r),
      g=repr(self._g),
      b=repr(self._b),
      alpha=repr(self._alpha))

Anki.Cozmo.VizInterface.DefineColor = DefineColor
del DefineColor


class SetLabel(object):
  "Generated message-passing message."

  __slots__ = (
    '_labelID', # uint_32
    '_colorID', # uint_32
    '_text',    # string[uint_8][uint_8]
  )

  @property
  def labelID(self):
    "uint_32 labelID struct property."
    return self._labelID

  @labelID.setter
  def labelID(self, value):
    self._labelID = msgbuffers.validate_integer(
      'SetLabel.labelID', value, 0, 4294967295)

  @property
  def colorID(self):
    "uint_32 colorID struct property."
    return self._colorID

  @colorID.setter
  def colorID(self, value):
    self._colorID = msgbuffers.validate_integer(
      'SetLabel.colorID', value, 0, 4294967295)

  @property
  def text(self):
    "string[uint_8][uint_8] text struct property."
    return self._text

  @text.setter
  def text(self, value):
    self._text = msgbuffers.validate_varray(
      'SetLabel.text', value, 255,
      lambda name, value_inner: msgbuffers.validate_string(
        name, value_inner, 255))

  def __init__(self, labelID=0, colorID=0, text=()):
    self.labelID = labelID
    self.colorID = colorID
    self.text = text

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SetLabel from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SetLabel.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SetLabel from the given BinaryReader."
    _labelID = reader.read('I')
    _colorID = reader.read('I')
    _text = reader.read_string_varray('B', 'B')
    return cls(_labelID, _colorID, _text)

  def pack(self):
    "Writes the current SetLabel, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SetLabel to the given BinaryWriter."
    writer.write(self._labelID, 'I')
    writer.write(self._colorID, 'I')
    writer.write_string_varray(self._text, 'B', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._labelID == other._labelID and
        self._colorID == other._colorID and
        self._text == other._text)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._labelID, 'I') +
      msgbuffers.size(self._colorID, 'I') +
      msgbuffers.size_string_varray(self._text, 'B', 'B'))

  def __str__(self):
    return '{type}(labelID={labelID}, colorID={colorID}, text={text})'.format(
      type=type(self).__name__,
      labelID=self._labelID,
      colorID=self._colorID,
      text=msgbuffers.shorten_sequence(self._text, msgbuffers.shorten_string))

  def __repr__(self):
    return '{type}(labelID={labelID}, colorID={colorID}, text={text})'.format(
      type=type(self).__name__,
      labelID=repr(self._labelID),
      colorID=repr(self._colorID),
      text=repr(self._text))

Anki.Cozmo.VizInterface.SetLabel = SetLabel
del SetLabel


class DockingErrorSignal(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_dist', # float_32
    '_y_dist', # float_32
    '_z_dist', # float_32
    '_angle',  # float_32
  )

  @property
  def x_dist(self):
    "float_32 x_dist struct property."
    return self._x_dist

  @x_dist.setter
  def x_dist(self, value):
    self._x_dist = msgbuffers.validate_float(
      'DockingErrorSignal.x_dist', value, 'f')

  @property
  def y_dist(self):
    "float_32 y_dist struct property."
    return self._y_dist

  @y_dist.setter
  def y_dist(self, value):
    self._y_dist = msgbuffers.validate_float(
      'DockingErrorSignal.y_dist', value, 'f')

  @property
  def z_dist(self):
    "float_32 z_dist struct property."
    return self._z_dist

  @z_dist.setter
  def z_dist(self, value):
    self._z_dist = msgbuffers.validate_float(
      'DockingErrorSignal.z_dist', value, 'f')

  @property
  def angle(self):
    "float_32 angle struct property."
    return self._angle

  @angle.setter
  def angle(self, value):
    self._angle = msgbuffers.validate_float(
      'DockingErrorSignal.angle', value, 'f')

  def __init__(self, x_dist=0.0, y_dist=0.0, z_dist=0.0, angle=0.0):
    self.x_dist = x_dist
    self.y_dist = y_dist
    self.z_dist = z_dist
    self.angle = angle

  @classmethod
  def unpack(cls, buffer):
    "Reads a new DockingErrorSignal from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('DockingErrorSignal.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new DockingErrorSignal from the given BinaryReader."
    _x_dist = reader.read('f')
    _y_dist = reader.read('f')
    _z_dist = reader.read('f')
    _angle = reader.read('f')
    return cls(_x_dist, _y_dist, _z_dist, _angle)

  def pack(self):
    "Writes the current DockingErrorSignal, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current DockingErrorSignal to the given BinaryWriter."
    writer.write(self._x_dist, 'f')
    writer.write(self._y_dist, 'f')
    writer.write(self._z_dist, 'f')
    writer.write(self._angle, 'f')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_dist == other._x_dist and
        self._y_dist == other._y_dist and
        self._z_dist == other._z_dist and
        self._angle == other._angle)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_dist, 'f') +
      msgbuffers.size(self._y_dist, 'f') +
      msgbuffers.size(self._z_dist, 'f') +
      msgbuffers.size(self._angle, 'f'))

  def __str__(self):
    return '{type}(x_dist={x_dist}, y_dist={y_dist}, z_dist={z_dist}, angle={angle})'.format(
      type=type(self).__name__,
      x_dist=self._x_dist,
      y_dist=self._y_dist,
      z_dist=self._z_dist,
      angle=self._angle)

  def __repr__(self):
    return '{type}(x_dist={x_dist}, y_dist={y_dist}, z_dist={z_dist}, angle={angle})'.format(
      type=type(self).__name__,
      x_dist=repr(self._x_dist),
      y_dist=repr(self._y_dist),
      z_dist=repr(self._z_dist),
      angle=repr(self._angle))

Anki.Cozmo.VizInterface.DockingErrorSignal = DockingErrorSignal
del DockingErrorSignal


class CameraInfo(object):
  "Generated message-passing message."

  __slots__ = (
    '_gain',        # float_32
    '_exposure_ms', # uint_16
  )

  @property
  def gain(self):
    "float_32 gain struct property."
    return self._gain

  @gain.setter
  def gain(self, value):
    self._gain = msgbuffers.validate_float(
      'CameraInfo.gain', value, 'f')

  @property
  def exposure_ms(self):
    "uint_16 exposure_ms struct property."
    return self._exposure_ms

  @exposure_ms.setter
  def exposure_ms(self, value):
    self._exposure_ms = msgbuffers.validate_integer(
      'CameraInfo.exposure_ms', value, 0, 65535)

  def __init__(self, gain=0.0, exposure_ms=0):
    self.gain = gain
    self.exposure_ms = exposure_ms

  @classmethod
  def unpack(cls, buffer):
    "Reads a new CameraInfo from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('CameraInfo.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new CameraInfo from the given BinaryReader."
    _gain = reader.read('f')
    _exposure_ms = reader.read('H')
    return cls(_gain, _exposure_ms)

  def pack(self):
    "Writes the current CameraInfo, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current CameraInfo to the given BinaryWriter."
    writer.write(self._gain, 'f')
    writer.write(self._exposure_ms, 'H')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._gain == other._gain and
        self._exposure_ms == other._exposure_ms)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._gain, 'f') +
      msgbuffers.size(self._exposure_ms, 'H'))

  def __str__(self):
    return '{type}(gain={gain}, exposure_ms={exposure_ms})'.format(
      type=type(self).__name__,
      gain=self._gain,
      exposure_ms=self._exposure_ms)

  def __repr__(self):
    return '{type}(gain={gain}, exposure_ms={exposure_ms})'.format(
      type=type(self).__name__,
      gain=repr(self._gain),
      exposure_ms=repr(self._exposure_ms))

Anki.Cozmo.VizInterface.CameraInfo = CameraInfo
del CameraInfo


class VisionMarker(object):
  "Generated message-passing message."

  __slots__ = (
    '_topLeft_x',     # int_16
    '_topLeft_y',     # int_16
    '_topRight_x',    # int_16
    '_topRight_y',    # int_16
    '_bottomRight_x', # int_16
    '_bottomRight_y', # int_16
    '_bottomLeft_x',  # int_16
    '_bottomLeft_y',  # int_16
    '_verified',      # int_8
  )

  @property
  def topLeft_x(self):
    "int_16 topLeft_x struct property."
    return self._topLeft_x

  @topLeft_x.setter
  def topLeft_x(self, value):
    self._topLeft_x = msgbuffers.validate_integer(
      'VisionMarker.topLeft_x', value, -32768, 32767)

  @property
  def topLeft_y(self):
    "int_16 topLeft_y struct property."
    return self._topLeft_y

  @topLeft_y.setter
  def topLeft_y(self, value):
    self._topLeft_y = msgbuffers.validate_integer(
      'VisionMarker.topLeft_y', value, -32768, 32767)

  @property
  def topRight_x(self):
    "int_16 topRight_x struct property."
    return self._topRight_x

  @topRight_x.setter
  def topRight_x(self, value):
    self._topRight_x = msgbuffers.validate_integer(
      'VisionMarker.topRight_x', value, -32768, 32767)

  @property
  def topRight_y(self):
    "int_16 topRight_y struct property."
    return self._topRight_y

  @topRight_y.setter
  def topRight_y(self, value):
    self._topRight_y = msgbuffers.validate_integer(
      'VisionMarker.topRight_y', value, -32768, 32767)

  @property
  def bottomRight_x(self):
    "int_16 bottomRight_x struct property."
    return self._bottomRight_x

  @bottomRight_x.setter
  def bottomRight_x(self, value):
    self._bottomRight_x = msgbuffers.validate_integer(
      'VisionMarker.bottomRight_x', value, -32768, 32767)

  @property
  def bottomRight_y(self):
    "int_16 bottomRight_y struct property."
    return self._bottomRight_y

  @bottomRight_y.setter
  def bottomRight_y(self, value):
    self._bottomRight_y = msgbuffers.validate_integer(
      'VisionMarker.bottomRight_y', value, -32768, 32767)

  @property
  def bottomLeft_x(self):
    "int_16 bottomLeft_x struct property."
    return self._bottomLeft_x

  @bottomLeft_x.setter
  def bottomLeft_x(self, value):
    self._bottomLeft_x = msgbuffers.validate_integer(
      'VisionMarker.bottomLeft_x', value, -32768, 32767)

  @property
  def bottomLeft_y(self):
    "int_16 bottomLeft_y struct property."
    return self._bottomLeft_y

  @bottomLeft_y.setter
  def bottomLeft_y(self, value):
    self._bottomLeft_y = msgbuffers.validate_integer(
      'VisionMarker.bottomLeft_y', value, -32768, 32767)

  @property
  def verified(self):
    "int_8 verified struct property."
    return self._verified

  @verified.setter
  def verified(self, value):
    self._verified = msgbuffers.validate_integer(
      'VisionMarker.verified', value, -128, 127)

  def __init__(self, topLeft_x=0, topLeft_y=0, topRight_x=0, topRight_y=0, bottomRight_x=0, bottomRight_y=0, bottomLeft_x=0, bottomLeft_y=0, verified=0):
    self.topLeft_x = topLeft_x
    self.topLeft_y = topLeft_y
    self.topRight_x = topRight_x
    self.topRight_y = topRight_y
    self.bottomRight_x = bottomRight_x
    self.bottomRight_y = bottomRight_y
    self.bottomLeft_x = bottomLeft_x
    self.bottomLeft_y = bottomLeft_y
    self.verified = verified

  @classmethod
  def unpack(cls, buffer):
    "Reads a new VisionMarker from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('VisionMarker.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new VisionMarker from the given BinaryReader."
    _topLeft_x = reader.read('h')
    _topLeft_y = reader.read('h')
    _topRight_x = reader.read('h')
    _topRight_y = reader.read('h')
    _bottomRight_x = reader.read('h')
    _bottomRight_y = reader.read('h')
    _bottomLeft_x = reader.read('h')
    _bottomLeft_y = reader.read('h')
    _verified = reader.read('b')
    return cls(_topLeft_x, _topLeft_y, _topRight_x, _topRight_y, _bottomRight_x, _bottomRight_y, _bottomLeft_x, _bottomLeft_y, _verified)

  def pack(self):
    "Writes the current VisionMarker, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current VisionMarker to the given BinaryWriter."
    writer.write(self._topLeft_x, 'h')
    writer.write(self._topLeft_y, 'h')
    writer.write(self._topRight_x, 'h')
    writer.write(self._topRight_y, 'h')
    writer.write(self._bottomRight_x, 'h')
    writer.write(self._bottomRight_y, 'h')
    writer.write(self._bottomLeft_x, 'h')
    writer.write(self._bottomLeft_y, 'h')
    writer.write(self._verified, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._topLeft_x == other._topLeft_x and
        self._topLeft_y == other._topLeft_y and
        self._topRight_x == other._topRight_x and
        self._topRight_y == other._topRight_y and
        self._bottomRight_x == other._bottomRight_x and
        self._bottomRight_y == other._bottomRight_y and
        self._bottomLeft_x == other._bottomLeft_x and
        self._bottomLeft_y == other._bottomLeft_y and
        self._verified == other._verified)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._topLeft_x, 'h') +
      msgbuffers.size(self._topLeft_y, 'h') +
      msgbuffers.size(self._topRight_x, 'h') +
      msgbuffers.size(self._topRight_y, 'h') +
      msgbuffers.size(self._bottomRight_x, 'h') +
      msgbuffers.size(self._bottomRight_y, 'h') +
      msgbuffers.size(self._bottomLeft_x, 'h') +
      msgbuffers.size(self._bottomLeft_y, 'h') +
      msgbuffers.size(self._verified, 'b'))

  def __str__(self):
    return '{type}(topLeft_x={topLeft_x}, topLeft_y={topLeft_y}, topRight_x={topRight_x}, topRight_y={topRight_y}, bottomRight_x={bottomRight_x}, bottomRight_y={bottomRight_y}, bottomLeft_x={bottomLeft_x}, bottomLeft_y={bottomLeft_y}, verified={verified})'.format(
      type=type(self).__name__,
      topLeft_x=self._topLeft_x,
      topLeft_y=self._topLeft_y,
      topRight_x=self._topRight_x,
      topRight_y=self._topRight_y,
      bottomRight_x=self._bottomRight_x,
      bottomRight_y=self._bottomRight_y,
      bottomLeft_x=self._bottomLeft_x,
      bottomLeft_y=self._bottomLeft_y,
      verified=self._verified)

  def __repr__(self):
    return '{type}(topLeft_x={topLeft_x}, topLeft_y={topLeft_y}, topRight_x={topRight_x}, topRight_y={topRight_y}, bottomRight_x={bottomRight_x}, bottomRight_y={bottomRight_y}, bottomLeft_x={bottomLeft_x}, bottomLeft_y={bottomLeft_y}, verified={verified})'.format(
      type=type(self).__name__,
      topLeft_x=repr(self._topLeft_x),
      topLeft_y=repr(self._topLeft_y),
      topRight_x=repr(self._topRight_x),
      topRight_y=repr(self._topRight_y),
      bottomRight_x=repr(self._bottomRight_x),
      bottomRight_y=repr(self._bottomRight_y),
      bottomLeft_x=repr(self._bottomLeft_x),
      bottomLeft_y=repr(self._bottomLeft_y),
      verified=repr(self._verified))

Anki.Cozmo.VizInterface.VisionMarker = VisionMarker
del VisionMarker


class ShowObjects(object):
  "Generated message-passing message."

  __slots__ = (
    '_show', # int_8
  )

  @property
  def show(self):
    "int_8 show struct property."
    return self._show

  @show.setter
  def show(self, value):
    self._show = msgbuffers.validate_integer(
      'ShowObjects.show', value, -128, 127)

  def __init__(self, show=0):
    self.show = show

  @classmethod
  def unpack(cls, buffer):
    "Reads a new ShowObjects from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('ShowObjects.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new ShowObjects from the given BinaryReader."
    _show = reader.read('b')
    return cls(_show)

  def pack(self):
    "Writes the current ShowObjects, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current ShowObjects to the given BinaryWriter."
    writer.write(self._show, 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._show == other._show
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._show, 'b'))

  def __str__(self):
    return '{type}(show={show})'.format(
      type=type(self).__name__,
      show=self._show)

  def __repr__(self):
    return '{type}(show={show})'.format(
      type=type(self).__name__,
      show=repr(self._show))

Anki.Cozmo.VizInterface.ShowObjects = ShowObjects
del ShowObjects


class TrackerQuad(object):
  "Generated message-passing message."

  __slots__ = (
    '_topLeft_x',     # int_16
    '_topLeft_y',     # int_16
    '_topRight_x',    # int_16
    '_topRight_y',    # int_16
    '_bottomRight_x', # int_16
    '_bottomRight_y', # int_16
    '_bottomLeft_x',  # int_16
    '_bottomLeft_y',  # int_16
  )

  @property
  def topLeft_x(self):
    "int_16 topLeft_x struct property."
    return self._topLeft_x

  @topLeft_x.setter
  def topLeft_x(self, value):
    self._topLeft_x = msgbuffers.validate_integer(
      'TrackerQuad.topLeft_x', value, -32768, 32767)

  @property
  def topLeft_y(self):
    "int_16 topLeft_y struct property."
    return self._topLeft_y

  @topLeft_y.setter
  def topLeft_y(self, value):
    self._topLeft_y = msgbuffers.validate_integer(
      'TrackerQuad.topLeft_y', value, -32768, 32767)

  @property
  def topRight_x(self):
    "int_16 topRight_x struct property."
    return self._topRight_x

  @topRight_x.setter
  def topRight_x(self, value):
    self._topRight_x = msgbuffers.validate_integer(
      'TrackerQuad.topRight_x', value, -32768, 32767)

  @property
  def topRight_y(self):
    "int_16 topRight_y struct property."
    return self._topRight_y

  @topRight_y.setter
  def topRight_y(self, value):
    self._topRight_y = msgbuffers.validate_integer(
      'TrackerQuad.topRight_y', value, -32768, 32767)

  @property
  def bottomRight_x(self):
    "int_16 bottomRight_x struct property."
    return self._bottomRight_x

  @bottomRight_x.setter
  def bottomRight_x(self, value):
    self._bottomRight_x = msgbuffers.validate_integer(
      'TrackerQuad.bottomRight_x', value, -32768, 32767)

  @property
  def bottomRight_y(self):
    "int_16 bottomRight_y struct property."
    return self._bottomRight_y

  @bottomRight_y.setter
  def bottomRight_y(self, value):
    self._bottomRight_y = msgbuffers.validate_integer(
      'TrackerQuad.bottomRight_y', value, -32768, 32767)

  @property
  def bottomLeft_x(self):
    "int_16 bottomLeft_x struct property."
    return self._bottomLeft_x

  @bottomLeft_x.setter
  def bottomLeft_x(self, value):
    self._bottomLeft_x = msgbuffers.validate_integer(
      'TrackerQuad.bottomLeft_x', value, -32768, 32767)

  @property
  def bottomLeft_y(self):
    "int_16 bottomLeft_y struct property."
    return self._bottomLeft_y

  @bottomLeft_y.setter
  def bottomLeft_y(self, value):
    self._bottomLeft_y = msgbuffers.validate_integer(
      'TrackerQuad.bottomLeft_y', value, -32768, 32767)

  def __init__(self, topLeft_x=0, topLeft_y=0, topRight_x=0, topRight_y=0, bottomRight_x=0, bottomRight_y=0, bottomLeft_x=0, bottomLeft_y=0):
    self.topLeft_x = topLeft_x
    self.topLeft_y = topLeft_y
    self.topRight_x = topRight_x
    self.topRight_y = topRight_y
    self.bottomRight_x = bottomRight_x
    self.bottomRight_y = bottomRight_y
    self.bottomLeft_x = bottomLeft_x
    self.bottomLeft_y = bottomLeft_y

  @classmethod
  def unpack(cls, buffer):
    "Reads a new TrackerQuad from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('TrackerQuad.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new TrackerQuad from the given BinaryReader."
    _topLeft_x = reader.read('h')
    _topLeft_y = reader.read('h')
    _topRight_x = reader.read('h')
    _topRight_y = reader.read('h')
    _bottomRight_x = reader.read('h')
    _bottomRight_y = reader.read('h')
    _bottomLeft_x = reader.read('h')
    _bottomLeft_y = reader.read('h')
    return cls(_topLeft_x, _topLeft_y, _topRight_x, _topRight_y, _bottomRight_x, _bottomRight_y, _bottomLeft_x, _bottomLeft_y)

  def pack(self):
    "Writes the current TrackerQuad, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current TrackerQuad to the given BinaryWriter."
    writer.write(self._topLeft_x, 'h')
    writer.write(self._topLeft_y, 'h')
    writer.write(self._topRight_x, 'h')
    writer.write(self._topRight_y, 'h')
    writer.write(self._bottomRight_x, 'h')
    writer.write(self._bottomRight_y, 'h')
    writer.write(self._bottomLeft_x, 'h')
    writer.write(self._bottomLeft_y, 'h')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._topLeft_x == other._topLeft_x and
        self._topLeft_y == other._topLeft_y and
        self._topRight_x == other._topRight_x and
        self._topRight_y == other._topRight_y and
        self._bottomRight_x == other._bottomRight_x and
        self._bottomRight_y == other._bottomRight_y and
        self._bottomLeft_x == other._bottomLeft_x and
        self._bottomLeft_y == other._bottomLeft_y)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._topLeft_x, 'h') +
      msgbuffers.size(self._topLeft_y, 'h') +
      msgbuffers.size(self._topRight_x, 'h') +
      msgbuffers.size(self._topRight_y, 'h') +
      msgbuffers.size(self._bottomRight_x, 'h') +
      msgbuffers.size(self._bottomRight_y, 'h') +
      msgbuffers.size(self._bottomLeft_x, 'h') +
      msgbuffers.size(self._bottomLeft_y, 'h'))

  def __str__(self):
    return '{type}(topLeft_x={topLeft_x}, topLeft_y={topLeft_y}, topRight_x={topRight_x}, topRight_y={topRight_y}, bottomRight_x={bottomRight_x}, bottomRight_y={bottomRight_y}, bottomLeft_x={bottomLeft_x}, bottomLeft_y={bottomLeft_y})'.format(
      type=type(self).__name__,
      topLeft_x=self._topLeft_x,
      topLeft_y=self._topLeft_y,
      topRight_x=self._topRight_x,
      topRight_y=self._topRight_y,
      bottomRight_x=self._bottomRight_x,
      bottomRight_y=self._bottomRight_y,
      bottomLeft_x=self._bottomLeft_x,
      bottomLeft_y=self._bottomLeft_y)

  def __repr__(self):
    return '{type}(topLeft_x={topLeft_x}, topLeft_y={topLeft_y}, topRight_x={topRight_x}, topRight_y={topRight_y}, bottomRight_x={bottomRight_x}, bottomRight_y={bottomRight_y}, bottomLeft_x={bottomLeft_x}, bottomLeft_y={bottomLeft_y})'.format(
      type=type(self).__name__,
      topLeft_x=repr(self._topLeft_x),
      topLeft_y=repr(self._topLeft_y),
      topRight_x=repr(self._topRight_x),
      topRight_y=repr(self._topRight_y),
      bottomRight_x=repr(self._bottomRight_x),
      bottomRight_y=repr(self._bottomRight_y),
      bottomLeft_x=repr(self._bottomLeft_x),
      bottomLeft_y=repr(self._bottomLeft_y))

Anki.Cozmo.VizInterface.TrackerQuad = TrackerQuad
del TrackerQuad


class FaceDetection(object):
  "Generated message-passing message."

  __slots__ = (
    '_x_upperLeft', # uint_16
    '_y_upperLeft', # uint_16
    '_width',       # uint_16
    '_height',      # uint_16
    '_visualize',   # bool
  )

  @property
  def x_upperLeft(self):
    "uint_16 x_upperLeft struct property."
    return self._x_upperLeft

  @x_upperLeft.setter
  def x_upperLeft(self, value):
    self._x_upperLeft = msgbuffers.validate_integer(
      'FaceDetection.x_upperLeft', value, 0, 65535)

  @property
  def y_upperLeft(self):
    "uint_16 y_upperLeft struct property."
    return self._y_upperLeft

  @y_upperLeft.setter
  def y_upperLeft(self, value):
    self._y_upperLeft = msgbuffers.validate_integer(
      'FaceDetection.y_upperLeft', value, 0, 65535)

  @property
  def width(self):
    "uint_16 width struct property."
    return self._width

  @width.setter
  def width(self, value):
    self._width = msgbuffers.validate_integer(
      'FaceDetection.width', value, 0, 65535)

  @property
  def height(self):
    "uint_16 height struct property."
    return self._height

  @height.setter
  def height(self, value):
    self._height = msgbuffers.validate_integer(
      'FaceDetection.height', value, 0, 65535)

  @property
  def visualize(self):
    "bool visualize struct property."
    return self._visualize

  @visualize.setter
  def visualize(self, value):
    self._visualize = msgbuffers.validate_bool(
      'FaceDetection.visualize', value)

  def __init__(self, x_upperLeft=0, y_upperLeft=0, width=0, height=0, visualize=False):
    self.x_upperLeft = x_upperLeft
    self.y_upperLeft = y_upperLeft
    self.width = width
    self.height = height
    self.visualize = visualize

  @classmethod
  def unpack(cls, buffer):
    "Reads a new FaceDetection from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('FaceDetection.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new FaceDetection from the given BinaryReader."
    _x_upperLeft = reader.read('H')
    _y_upperLeft = reader.read('H')
    _width = reader.read('H')
    _height = reader.read('H')
    _visualize = bool(reader.read('b'))
    return cls(_x_upperLeft, _y_upperLeft, _width, _height, _visualize)

  def pack(self):
    "Writes the current FaceDetection, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current FaceDetection to the given BinaryWriter."
    writer.write(self._x_upperLeft, 'H')
    writer.write(self._y_upperLeft, 'H')
    writer.write(self._width, 'H')
    writer.write(self._height, 'H')
    writer.write(int(self._visualize), 'b')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._x_upperLeft == other._x_upperLeft and
        self._y_upperLeft == other._y_upperLeft and
        self._width == other._width and
        self._height == other._height and
        self._visualize == other._visualize)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._x_upperLeft, 'H') +
      msgbuffers.size(self._y_upperLeft, 'H') +
      msgbuffers.size(self._width, 'H') +
      msgbuffers.size(self._height, 'H') +
      msgbuffers.size(self._visualize, 'b'))

  def __str__(self):
    return '{type}(x_upperLeft={x_upperLeft}, y_upperLeft={y_upperLeft}, width={width}, height={height}, visualize={visualize})'.format(
      type=type(self).__name__,
      x_upperLeft=self._x_upperLeft,
      y_upperLeft=self._y_upperLeft,
      width=self._width,
      height=self._height,
      visualize=self._visualize)

  def __repr__(self):
    return '{type}(x_upperLeft={x_upperLeft}, y_upperLeft={y_upperLeft}, width={width}, height={height}, visualize={visualize})'.format(
      type=type(self).__name__,
      x_upperLeft=repr(self._x_upperLeft),
      y_upperLeft=repr(self._y_upperLeft),
      width=repr(self._width),
      height=repr(self._height),
      visualize=repr(self._visualize))

Anki.Cozmo.VizInterface.FaceDetection = FaceDetection
del FaceDetection


class RobotMood(object):
  "Generated message-passing message."

  __slots__ = (
    '_emotion',      # float_32[uint_8]
    '_recentEvents', # string[uint_8][uint_8]
  )

  @property
  def emotion(self):
    "float_32[uint_8] emotion struct property."
    return self._emotion

  @emotion.setter
  def emotion(self, value):
    self._emotion = msgbuffers.validate_varray(
      'RobotMood.emotion', value, 255,
      lambda name, value_inner: msgbuffers.validate_float(
        name, value_inner, 'f'))

  @property
  def recentEvents(self):
    "string[uint_8][uint_8] recentEvents struct property."
    return self._recentEvents

  @recentEvents.setter
  def recentEvents(self, value):
    self._recentEvents = msgbuffers.validate_varray(
      'RobotMood.recentEvents', value, 255,
      lambda name, value_inner: msgbuffers.validate_string(
        name, value_inner, 255))

  def __init__(self, emotion=(), recentEvents=()):
    self.emotion = emotion
    self.recentEvents = recentEvents

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotMood from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotMood.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotMood from the given BinaryReader."
    _emotion = reader.read_varray('f', 'B')
    _recentEvents = reader.read_string_varray('B', 'B')
    return cls(_emotion, _recentEvents)

  def pack(self):
    "Writes the current RobotMood, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotMood to the given BinaryWriter."
    writer.write_varray(self._emotion, 'f', 'B')
    writer.write_string_varray(self._recentEvents, 'B', 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._emotion == other._emotion and
        self._recentEvents == other._recentEvents)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_varray(self._emotion, 'f', 'B') +
      msgbuffers.size_string_varray(self._recentEvents, 'B', 'B'))

  def __str__(self):
    return '{type}(emotion={emotion}, recentEvents={recentEvents})'.format(
      type=type(self).__name__,
      emotion=msgbuffers.shorten_sequence(self._emotion),
      recentEvents=msgbuffers.shorten_sequence(self._recentEvents, msgbuffers.shorten_string))

  def __repr__(self):
    return '{type}(emotion={emotion}, recentEvents={recentEvents})'.format(
      type=type(self).__name__,
      emotion=repr(self._emotion),
      recentEvents=repr(self._recentEvents))

Anki.Cozmo.VizInterface.RobotMood = RobotMood
del RobotMood


class BehaviorScoreData(object):
  "Generated message-passing structure."

  __slots__ = (
    '_behaviorScore', # float_32
    '_totalScore',    # float_32
    '_name',          # string[uint_8]
  )

  @property
  def behaviorScore(self):
    "float_32 behaviorScore struct property."
    return self._behaviorScore

  @behaviorScore.setter
  def behaviorScore(self, value):
    self._behaviorScore = msgbuffers.validate_float(
      'BehaviorScoreData.behaviorScore', value, 'f')

  @property
  def totalScore(self):
    "float_32 totalScore struct property."
    return self._totalScore

  @totalScore.setter
  def totalScore(self, value):
    self._totalScore = msgbuffers.validate_float(
      'BehaviorScoreData.totalScore', value, 'f')

  @property
  def name(self):
    "string[uint_8] name struct property."
    return self._name

  @name.setter
  def name(self, value):
    self._name = msgbuffers.validate_string(
      'BehaviorScoreData.name', value, 255)

  def __init__(self, behaviorScore=0.0, totalScore=0.0, name=''):
    self.behaviorScore = behaviorScore
    self.totalScore = totalScore
    self.name = name

  @classmethod
  def unpack(cls, buffer):
    "Reads a new BehaviorScoreData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('BehaviorScoreData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new BehaviorScoreData from the given BinaryReader."
    _behaviorScore = reader.read('f')
    _totalScore = reader.read('f')
    _name = reader.read_string('B')
    return cls(_behaviorScore, _totalScore, _name)

  def pack(self):
    "Writes the current BehaviorScoreData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current BehaviorScoreData to the given BinaryWriter."
    writer.write(self._behaviorScore, 'f')
    writer.write(self._totalScore, 'f')
    writer.write_string(self._name, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._behaviorScore == other._behaviorScore and
        self._totalScore == other._totalScore and
        self._name == other._name)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._behaviorScore, 'f') +
      msgbuffers.size(self._totalScore, 'f') +
      msgbuffers.size_string(self._name, 'B'))

  def __str__(self):
    return '{type}(behaviorScore={behaviorScore}, totalScore={totalScore}, name={name})'.format(
      type=type(self).__name__,
      behaviorScore=self._behaviorScore,
      totalScore=self._totalScore,
      name=msgbuffers.shorten_string(self._name))

  def __repr__(self):
    return '{type}(behaviorScore={behaviorScore}, totalScore={totalScore}, name={name})'.format(
      type=type(self).__name__,
      behaviorScore=repr(self._behaviorScore),
      totalScore=repr(self._totalScore),
      name=repr(self._name))

Anki.Cozmo.VizInterface.BehaviorScoreData = BehaviorScoreData
del BehaviorScoreData


class RobotBehaviorSelectData(object):
  "Generated message-passing message."

  __slots__ = (
    '_scoreData', # BehaviorScoreData[uint_8]
  )

  @property
  def scoreData(self):
    "BehaviorScoreData[uint_8] scoreData struct property."
    return self._scoreData

  @scoreData.setter
  def scoreData(self, value):
    self._scoreData = msgbuffers.validate_varray(
      'RobotBehaviorSelectData.scoreData', value, 255,
      lambda name, value_inner: msgbuffers.validate_object(
        name, value_inner, Anki.Cozmo.VizInterface.BehaviorScoreData))

  def __init__(self, scoreData=()):
    self.scoreData = scoreData

  @classmethod
  def unpack(cls, buffer):
    "Reads a new RobotBehaviorSelectData from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('RobotBehaviorSelectData.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new RobotBehaviorSelectData from the given BinaryReader."
    _scoreData = reader.read_object_varray(Anki.Cozmo.VizInterface.BehaviorScoreData.unpack_from, 'B')
    return cls(_scoreData)

  def pack(self):
    "Writes the current RobotBehaviorSelectData, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current RobotBehaviorSelectData to the given BinaryWriter."
    writer.write_object_varray(self._scoreData, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._scoreData == other._scoreData
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_object_varray(self._scoreData, 'B'))

  def __str__(self):
    return '{type}(scoreData={scoreData})'.format(
      type=type(self).__name__,
      scoreData=msgbuffers.shorten_sequence(self._scoreData))

  def __repr__(self):
    return '{type}(scoreData={scoreData})'.format(
      type=type(self).__name__,
      scoreData=repr(self._scoreData))

Anki.Cozmo.VizInterface.RobotBehaviorSelectData = RobotBehaviorSelectData
del RobotBehaviorSelectData


class NewBehaviorSelected(object):
  "Generated message-passing message."

  __slots__ = (
    '_newCurrentBehavior', # string[uint_8]
  )

  @property
  def newCurrentBehavior(self):
    "string[uint_8] newCurrentBehavior struct property."
    return self._newCurrentBehavior

  @newCurrentBehavior.setter
  def newCurrentBehavior(self, value):
    self._newCurrentBehavior = msgbuffers.validate_string(
      'NewBehaviorSelected.newCurrentBehavior', value, 255)

  def __init__(self, newCurrentBehavior=''):
    self.newCurrentBehavior = newCurrentBehavior

  @classmethod
  def unpack(cls, buffer):
    "Reads a new NewBehaviorSelected from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('NewBehaviorSelected.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new NewBehaviorSelected from the given BinaryReader."
    _newCurrentBehavior = reader.read_string('B')
    return cls(_newCurrentBehavior)

  def pack(self):
    "Writes the current NewBehaviorSelected, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current NewBehaviorSelected to the given BinaryWriter."
    writer.write_string(self._newCurrentBehavior, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return self._newCurrentBehavior == other._newCurrentBehavior
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size_string(self._newCurrentBehavior, 'B'))

  def __str__(self):
    return '{type}(newCurrentBehavior={newCurrentBehavior})'.format(
      type=type(self).__name__,
      newCurrentBehavior=msgbuffers.shorten_string(self._newCurrentBehavior))

  def __repr__(self):
    return '{type}(newCurrentBehavior={newCurrentBehavior})'.format(
      type=type(self).__name__,
      newCurrentBehavior=repr(self._newCurrentBehavior))

Anki.Cozmo.VizInterface.NewBehaviorSelected = NewBehaviorSelected
del NewBehaviorSelected


class StartRobotUpdate(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new StartRobotUpdate from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('StartRobotUpdate.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new StartRobotUpdate from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current StartRobotUpdate, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current StartRobotUpdate to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.VizInterface.StartRobotUpdate = StartRobotUpdate
del StartRobotUpdate


class EndRobotUpdate(object):
  "Generated message-passing message."

  __slots__ = ()

  def __init__(self):
    pass

  @classmethod
  def unpack(cls, buffer):
    "Reads a new EndRobotUpdate from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('EndRobotUpdate.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new EndRobotUpdate from the given BinaryReader."
    return cls()

  def pack(self):
    "Writes the current EndRobotUpdate, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current EndRobotUpdate to the given BinaryWriter."

  def __eq__(self, other):
    if type(self) is type(other):
      return True
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return 0

  def __str__(self):
    return '{type}()'.format(type=type(self).__name__)

  def __repr__(self):
    return '{type}()'.format(type=type(self).__name__)

Anki.Cozmo.VizInterface.EndRobotUpdate = EndRobotUpdate
del EndRobotUpdate


class SaveImages(object):
  "Generated message-passing message."

  __slots__ = (
    '_mode', # Anki.Cozmo.ImageSendMode
    '_path', # string[uint_8]
  )

  @property
  def mode(self):
    "Anki.Cozmo.ImageSendMode mode struct property."
    return self._mode

  @mode.setter
  def mode(self, value):
    self._mode = msgbuffers.validate_integer(
      'SaveImages.mode', value, 0, 255)

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'SaveImages.path', value, 255)

  def __init__(self, mode=Anki.Cozmo.ImageSendMode.Off, path=''):
    self.mode = mode
    self.path = path

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveImages from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveImages.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveImages from the given BinaryReader."
    _mode = reader.read('B')
    _path = reader.read_string('B')
    return cls(_mode, _path)

  def pack(self):
    "Writes the current SaveImages, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveImages to the given BinaryWriter."
    writer.write(self._mode, 'B')
    writer.write_string(self._path, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._mode == other._mode and
        self._path == other._path)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._mode, 'B') +
      msgbuffers.size_string(self._path, 'B'))

  def __str__(self):
    return '{type}(mode={mode}, path={path})'.format(
      type=type(self).__name__,
      mode=self._mode,
      path=msgbuffers.shorten_string(self._path))

  def __repr__(self):
    return '{type}(mode={mode}, path={path})'.format(
      type=type(self).__name__,
      mode=repr(self._mode),
      path=repr(self._path))

Anki.Cozmo.VizInterface.SaveImages = SaveImages
del SaveImages


class SaveState(object):
  "Generated message-passing message."

  __slots__ = (
    '_enabled', # bool
    '_path',    # string[uint_8]
  )

  @property
  def enabled(self):
    "bool enabled struct property."
    return self._enabled

  @enabled.setter
  def enabled(self, value):
    self._enabled = msgbuffers.validate_bool(
      'SaveState.enabled', value)

  @property
  def path(self):
    "string[uint_8] path struct property."
    return self._path

  @path.setter
  def path(self, value):
    self._path = msgbuffers.validate_string(
      'SaveState.path', value, 255)

  def __init__(self, enabled=False, path=''):
    self.enabled = enabled
    self.path = path

  @classmethod
  def unpack(cls, buffer):
    "Reads a new SaveState from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('SaveState.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new SaveState from the given BinaryReader."
    _enabled = bool(reader.read('b'))
    _path = reader.read_string('B')
    return cls(_enabled, _path)

  def pack(self):
    "Writes the current SaveState, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SaveState to the given BinaryWriter."
    writer.write(int(self._enabled), 'b')
    writer.write_string(self._path, 'B')

  def __eq__(self, other):
    if type(self) is type(other):
      return (self._enabled == other._enabled and
        self._path == other._path)
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    return (msgbuffers.size(self._enabled, 'b') +
      msgbuffers.size_string(self._path, 'B'))

  def __str__(self):
    return '{type}(enabled={enabled}, path={path})'.format(
      type=type(self).__name__,
      enabled=self._enabled,
      path=msgbuffers.shorten_string(self._path))

  def __repr__(self):
    return '{type}(enabled={enabled}, path={path})'.format(
      type=type(self).__name__,
      enabled=repr(self._enabled),
      path=repr(self._path))

Anki.Cozmo.VizInterface.SaveState = SaveState
del SaveState


class MessageViz(object):
  "Generated message-passing union."

  __slots__ = ('_tag', '_data')

  class Tag(object):
    "The type indicator for this union."
    IMURequest                   = 0  # Anki.Cozmo.IMURequest
    CarryStateUpdate             = 1  # Anki.Cozmo.CarryStateUpdate
    SetBodyRadioMode             = 2  # Anki.Cozmo.SetBodyRadioMode
    AnimationState               = 3  # Anki.Cozmo.RobotInterface.AnimationState
    ImageChunk                   = 4  # Anki.Cozmo.ImageChunk
    ImageImuData                 = 5  # Anki.Cozmo.ImageImuData
    CameraCalibration            = 6  # Anki.Cozmo.CameraCalibration
    SetVizOrigin                 = 7  # Anki.Cozmo.SetVizOrigin
    RobotStateMessage            = 8  # Anki.Cozmo.VizInterface.RobotStateMessage
    Object                       = 9  # Anki.Cozmo.VizInterface.Object
    SegmentPrimitive             = 10 # Anki.Cozmo.VizInterface.SegmentPrimitive
    Quad                         = 11 # Anki.Cozmo.VizInterface.Quad
    SimpleQuadVectorMessageBegin = 12 # Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin
    SimpleQuadVectorMessage      = 13 # Anki.Cozmo.VizInterface.SimpleQuadVectorMessage
    SimpleQuadVectorMessageEnd   = 14 # Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd
    CameraQuad                   = 15 # Anki.Cozmo.VizInterface.CameraQuad
    CameraLine                   = 16 # Anki.Cozmo.VizInterface.CameraLine
    CameraOval                   = 17 # Anki.Cozmo.VizInterface.CameraOval
    CameraText                   = 18 # Anki.Cozmo.VizInterface.CameraText
    EraseObject                  = 19 # Anki.Cozmo.VizInterface.EraseObject
    EraseSegmentPrimitives       = 20 # Anki.Cozmo.VizInterface.EraseSegmentPrimitives
    EraseQuad                    = 21 # Anki.Cozmo.VizInterface.EraseQuad
    SetRobot                     = 22 # Anki.Cozmo.VizInterface.SetRobot
    AppendPathSegmentLine        = 23 # Anki.Cozmo.VizInterface.AppendPathSegmentLine
    AppendPathSegmentArc         = 24 # Anki.Cozmo.VizInterface.AppendPathSegmentArc
    SetPathColor                 = 25 # Anki.Cozmo.VizInterface.SetPathColor
    ErasePath                    = 26 # Anki.Cozmo.VizInterface.ErasePath
    DefineColor                  = 27 # Anki.Cozmo.VizInterface.DefineColor
    SetLabel                     = 28 # Anki.Cozmo.VizInterface.SetLabel
    DockingErrorSignal           = 29 # Anki.Cozmo.VizInterface.DockingErrorSignal
    CameraInfo                   = 30 # Anki.Cozmo.VizInterface.CameraInfo
    VisionMarker                 = 31 # Anki.Cozmo.VizInterface.VisionMarker
    ShowObjects                  = 32 # Anki.Cozmo.VizInterface.ShowObjects
    TrackerQuad                  = 33 # Anki.Cozmo.VizInterface.TrackerQuad
    FaceDetection                = 34 # Anki.Cozmo.VizInterface.FaceDetection
    RobotMood                    = 35 # Anki.Cozmo.VizInterface.RobotMood
    RobotBehaviorSelectData      = 36 # Anki.Cozmo.VizInterface.RobotBehaviorSelectData
    NewBehaviorSelected          = 37 # Anki.Cozmo.VizInterface.NewBehaviorSelected
    StartRobotUpdate             = 38 # Anki.Cozmo.VizInterface.StartRobotUpdate
    EndRobotUpdate               = 39 # Anki.Cozmo.VizInterface.EndRobotUpdate
    SaveImages                   = 40 # Anki.Cozmo.VizInterface.SaveImages
    SaveState                    = 41 # Anki.Cozmo.VizInterface.SaveState

  @property
  def tag(self):
    "The current tag for this union."
    return self._tag

  @property
  def tag_name(self):
    "The name of the current tag for this union."
    if self._tag in self._tags_by_value:
      return self._tags_by_value[self._tag]
    else:
      return None

  @property
  def data(self):
    "The data held by this union. None if no data is set."
    return self._data

  @property
  def IMURequest(self):
    "Anki.Cozmo.IMURequest IMURequest union property."
    msgbuffers.safety_check_tag('IMURequest', self._tag, self.Tag.IMURequest, self._tags_by_value)
    return self._data

  @IMURequest.setter
  def IMURequest(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.IMURequest', value, Anki.Cozmo.IMURequest)
    self._tag = self.Tag.IMURequest

  @property
  def CarryStateUpdate(self):
    "Anki.Cozmo.CarryStateUpdate CarryStateUpdate union property."
    msgbuffers.safety_check_tag('CarryStateUpdate', self._tag, self.Tag.CarryStateUpdate, self._tags_by_value)
    return self._data

  @CarryStateUpdate.setter
  def CarryStateUpdate(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CarryStateUpdate', value, Anki.Cozmo.CarryStateUpdate)
    self._tag = self.Tag.CarryStateUpdate

  @property
  def SetBodyRadioMode(self):
    "Anki.Cozmo.SetBodyRadioMode SetBodyRadioMode union property."
    msgbuffers.safety_check_tag('SetBodyRadioMode', self._tag, self.Tag.SetBodyRadioMode, self._tags_by_value)
    return self._data

  @SetBodyRadioMode.setter
  def SetBodyRadioMode(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SetBodyRadioMode', value, Anki.Cozmo.SetBodyRadioMode)
    self._tag = self.Tag.SetBodyRadioMode

  @property
  def AnimationState(self):
    "Anki.Cozmo.RobotInterface.AnimationState AnimationState union property."
    msgbuffers.safety_check_tag('AnimationState', self._tag, self.Tag.AnimationState, self._tags_by_value)
    return self._data

  @AnimationState.setter
  def AnimationState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.AnimationState', value, Anki.Cozmo.RobotInterface.AnimationState)
    self._tag = self.Tag.AnimationState

  @property
  def ImageChunk(self):
    "Anki.Cozmo.ImageChunk ImageChunk union property."
    msgbuffers.safety_check_tag('ImageChunk', self._tag, self.Tag.ImageChunk, self._tags_by_value)
    return self._data

  @ImageChunk.setter
  def ImageChunk(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.ImageChunk', value, Anki.Cozmo.ImageChunk)
    self._tag = self.Tag.ImageChunk

  @property
  def ImageImuData(self):
    "Anki.Cozmo.ImageImuData ImageImuData union property."
    msgbuffers.safety_check_tag('ImageImuData', self._tag, self.Tag.ImageImuData, self._tags_by_value)
    return self._data

  @ImageImuData.setter
  def ImageImuData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.ImageImuData', value, Anki.Cozmo.ImageImuData)
    self._tag = self.Tag.ImageImuData

  @property
  def CameraCalibration(self):
    "Anki.Cozmo.CameraCalibration CameraCalibration union property."
    msgbuffers.safety_check_tag('CameraCalibration', self._tag, self.Tag.CameraCalibration, self._tags_by_value)
    return self._data

  @CameraCalibration.setter
  def CameraCalibration(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraCalibration', value, Anki.Cozmo.CameraCalibration)
    self._tag = self.Tag.CameraCalibration

  @property
  def SetVizOrigin(self):
    "Anki.Cozmo.SetVizOrigin SetVizOrigin union property."
    msgbuffers.safety_check_tag('SetVizOrigin', self._tag, self.Tag.SetVizOrigin, self._tags_by_value)
    return self._data

  @SetVizOrigin.setter
  def SetVizOrigin(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SetVizOrigin', value, Anki.Cozmo.SetVizOrigin)
    self._tag = self.Tag.SetVizOrigin

  @property
  def RobotStateMessage(self):
    "Anki.Cozmo.VizInterface.RobotStateMessage RobotStateMessage union property."
    msgbuffers.safety_check_tag('RobotStateMessage', self._tag, self.Tag.RobotStateMessage, self._tags_by_value)
    return self._data

  @RobotStateMessage.setter
  def RobotStateMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.RobotStateMessage', value, Anki.Cozmo.VizInterface.RobotStateMessage)
    self._tag = self.Tag.RobotStateMessage

  @property
  def Object(self):
    "Anki.Cozmo.VizInterface.Object Object union property."
    msgbuffers.safety_check_tag('Object', self._tag, self.Tag.Object, self._tags_by_value)
    return self._data

  @Object.setter
  def Object(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.Object', value, Anki.Cozmo.VizInterface.Object)
    self._tag = self.Tag.Object

  @property
  def SegmentPrimitive(self):
    "Anki.Cozmo.VizInterface.SegmentPrimitive SegmentPrimitive union property."
    msgbuffers.safety_check_tag('SegmentPrimitive', self._tag, self.Tag.SegmentPrimitive, self._tags_by_value)
    return self._data

  @SegmentPrimitive.setter
  def SegmentPrimitive(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SegmentPrimitive', value, Anki.Cozmo.VizInterface.SegmentPrimitive)
    self._tag = self.Tag.SegmentPrimitive

  @property
  def Quad(self):
    "Anki.Cozmo.VizInterface.Quad Quad union property."
    msgbuffers.safety_check_tag('Quad', self._tag, self.Tag.Quad, self._tags_by_value)
    return self._data

  @Quad.setter
  def Quad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.Quad', value, Anki.Cozmo.VizInterface.Quad)
    self._tag = self.Tag.Quad

  @property
  def SimpleQuadVectorMessageBegin(self):
    "Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin SimpleQuadVectorMessageBegin union property."
    msgbuffers.safety_check_tag('SimpleQuadVectorMessageBegin', self._tag, self.Tag.SimpleQuadVectorMessageBegin, self._tags_by_value)
    return self._data

  @SimpleQuadVectorMessageBegin.setter
  def SimpleQuadVectorMessageBegin(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SimpleQuadVectorMessageBegin', value, Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin)
    self._tag = self.Tag.SimpleQuadVectorMessageBegin

  @property
  def SimpleQuadVectorMessage(self):
    "Anki.Cozmo.VizInterface.SimpleQuadVectorMessage SimpleQuadVectorMessage union property."
    msgbuffers.safety_check_tag('SimpleQuadVectorMessage', self._tag, self.Tag.SimpleQuadVectorMessage, self._tags_by_value)
    return self._data

  @SimpleQuadVectorMessage.setter
  def SimpleQuadVectorMessage(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SimpleQuadVectorMessage', value, Anki.Cozmo.VizInterface.SimpleQuadVectorMessage)
    self._tag = self.Tag.SimpleQuadVectorMessage

  @property
  def SimpleQuadVectorMessageEnd(self):
    "Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd SimpleQuadVectorMessageEnd union property."
    msgbuffers.safety_check_tag('SimpleQuadVectorMessageEnd', self._tag, self.Tag.SimpleQuadVectorMessageEnd, self._tags_by_value)
    return self._data

  @SimpleQuadVectorMessageEnd.setter
  def SimpleQuadVectorMessageEnd(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SimpleQuadVectorMessageEnd', value, Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd)
    self._tag = self.Tag.SimpleQuadVectorMessageEnd

  @property
  def CameraQuad(self):
    "Anki.Cozmo.VizInterface.CameraQuad CameraQuad union property."
    msgbuffers.safety_check_tag('CameraQuad', self._tag, self.Tag.CameraQuad, self._tags_by_value)
    return self._data

  @CameraQuad.setter
  def CameraQuad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraQuad', value, Anki.Cozmo.VizInterface.CameraQuad)
    self._tag = self.Tag.CameraQuad

  @property
  def CameraLine(self):
    "Anki.Cozmo.VizInterface.CameraLine CameraLine union property."
    msgbuffers.safety_check_tag('CameraLine', self._tag, self.Tag.CameraLine, self._tags_by_value)
    return self._data

  @CameraLine.setter
  def CameraLine(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraLine', value, Anki.Cozmo.VizInterface.CameraLine)
    self._tag = self.Tag.CameraLine

  @property
  def CameraOval(self):
    "Anki.Cozmo.VizInterface.CameraOval CameraOval union property."
    msgbuffers.safety_check_tag('CameraOval', self._tag, self.Tag.CameraOval, self._tags_by_value)
    return self._data

  @CameraOval.setter
  def CameraOval(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraOval', value, Anki.Cozmo.VizInterface.CameraOval)
    self._tag = self.Tag.CameraOval

  @property
  def CameraText(self):
    "Anki.Cozmo.VizInterface.CameraText CameraText union property."
    msgbuffers.safety_check_tag('CameraText', self._tag, self.Tag.CameraText, self._tags_by_value)
    return self._data

  @CameraText.setter
  def CameraText(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraText', value, Anki.Cozmo.VizInterface.CameraText)
    self._tag = self.Tag.CameraText

  @property
  def EraseObject(self):
    "Anki.Cozmo.VizInterface.EraseObject EraseObject union property."
    msgbuffers.safety_check_tag('EraseObject', self._tag, self.Tag.EraseObject, self._tags_by_value)
    return self._data

  @EraseObject.setter
  def EraseObject(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.EraseObject', value, Anki.Cozmo.VizInterface.EraseObject)
    self._tag = self.Tag.EraseObject

  @property
  def EraseSegmentPrimitives(self):
    "Anki.Cozmo.VizInterface.EraseSegmentPrimitives EraseSegmentPrimitives union property."
    msgbuffers.safety_check_tag('EraseSegmentPrimitives', self._tag, self.Tag.EraseSegmentPrimitives, self._tags_by_value)
    return self._data

  @EraseSegmentPrimitives.setter
  def EraseSegmentPrimitives(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.EraseSegmentPrimitives', value, Anki.Cozmo.VizInterface.EraseSegmentPrimitives)
    self._tag = self.Tag.EraseSegmentPrimitives

  @property
  def EraseQuad(self):
    "Anki.Cozmo.VizInterface.EraseQuad EraseQuad union property."
    msgbuffers.safety_check_tag('EraseQuad', self._tag, self.Tag.EraseQuad, self._tags_by_value)
    return self._data

  @EraseQuad.setter
  def EraseQuad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.EraseQuad', value, Anki.Cozmo.VizInterface.EraseQuad)
    self._tag = self.Tag.EraseQuad

  @property
  def SetRobot(self):
    "Anki.Cozmo.VizInterface.SetRobot SetRobot union property."
    msgbuffers.safety_check_tag('SetRobot', self._tag, self.Tag.SetRobot, self._tags_by_value)
    return self._data

  @SetRobot.setter
  def SetRobot(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SetRobot', value, Anki.Cozmo.VizInterface.SetRobot)
    self._tag = self.Tag.SetRobot

  @property
  def AppendPathSegmentLine(self):
    "Anki.Cozmo.VizInterface.AppendPathSegmentLine AppendPathSegmentLine union property."
    msgbuffers.safety_check_tag('AppendPathSegmentLine', self._tag, self.Tag.AppendPathSegmentLine, self._tags_by_value)
    return self._data

  @AppendPathSegmentLine.setter
  def AppendPathSegmentLine(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.AppendPathSegmentLine', value, Anki.Cozmo.VizInterface.AppendPathSegmentLine)
    self._tag = self.Tag.AppendPathSegmentLine

  @property
  def AppendPathSegmentArc(self):
    "Anki.Cozmo.VizInterface.AppendPathSegmentArc AppendPathSegmentArc union property."
    msgbuffers.safety_check_tag('AppendPathSegmentArc', self._tag, self.Tag.AppendPathSegmentArc, self._tags_by_value)
    return self._data

  @AppendPathSegmentArc.setter
  def AppendPathSegmentArc(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.AppendPathSegmentArc', value, Anki.Cozmo.VizInterface.AppendPathSegmentArc)
    self._tag = self.Tag.AppendPathSegmentArc

  @property
  def SetPathColor(self):
    "Anki.Cozmo.VizInterface.SetPathColor SetPathColor union property."
    msgbuffers.safety_check_tag('SetPathColor', self._tag, self.Tag.SetPathColor, self._tags_by_value)
    return self._data

  @SetPathColor.setter
  def SetPathColor(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SetPathColor', value, Anki.Cozmo.VizInterface.SetPathColor)
    self._tag = self.Tag.SetPathColor

  @property
  def ErasePath(self):
    "Anki.Cozmo.VizInterface.ErasePath ErasePath union property."
    msgbuffers.safety_check_tag('ErasePath', self._tag, self.Tag.ErasePath, self._tags_by_value)
    return self._data

  @ErasePath.setter
  def ErasePath(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.ErasePath', value, Anki.Cozmo.VizInterface.ErasePath)
    self._tag = self.Tag.ErasePath

  @property
  def DefineColor(self):
    "Anki.Cozmo.VizInterface.DefineColor DefineColor union property."
    msgbuffers.safety_check_tag('DefineColor', self._tag, self.Tag.DefineColor, self._tags_by_value)
    return self._data

  @DefineColor.setter
  def DefineColor(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.DefineColor', value, Anki.Cozmo.VizInterface.DefineColor)
    self._tag = self.Tag.DefineColor

  @property
  def SetLabel(self):
    "Anki.Cozmo.VizInterface.SetLabel SetLabel union property."
    msgbuffers.safety_check_tag('SetLabel', self._tag, self.Tag.SetLabel, self._tags_by_value)
    return self._data

  @SetLabel.setter
  def SetLabel(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SetLabel', value, Anki.Cozmo.VizInterface.SetLabel)
    self._tag = self.Tag.SetLabel

  @property
  def DockingErrorSignal(self):
    "Anki.Cozmo.VizInterface.DockingErrorSignal DockingErrorSignal union property."
    msgbuffers.safety_check_tag('DockingErrorSignal', self._tag, self.Tag.DockingErrorSignal, self._tags_by_value)
    return self._data

  @DockingErrorSignal.setter
  def DockingErrorSignal(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.DockingErrorSignal', value, Anki.Cozmo.VizInterface.DockingErrorSignal)
    self._tag = self.Tag.DockingErrorSignal

  @property
  def CameraInfo(self):
    "Anki.Cozmo.VizInterface.CameraInfo CameraInfo union property."
    msgbuffers.safety_check_tag('CameraInfo', self._tag, self.Tag.CameraInfo, self._tags_by_value)
    return self._data

  @CameraInfo.setter
  def CameraInfo(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.CameraInfo', value, Anki.Cozmo.VizInterface.CameraInfo)
    self._tag = self.Tag.CameraInfo

  @property
  def VisionMarker(self):
    "Anki.Cozmo.VizInterface.VisionMarker VisionMarker union property."
    msgbuffers.safety_check_tag('VisionMarker', self._tag, self.Tag.VisionMarker, self._tags_by_value)
    return self._data

  @VisionMarker.setter
  def VisionMarker(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.VisionMarker', value, Anki.Cozmo.VizInterface.VisionMarker)
    self._tag = self.Tag.VisionMarker

  @property
  def ShowObjects(self):
    "Anki.Cozmo.VizInterface.ShowObjects ShowObjects union property."
    msgbuffers.safety_check_tag('ShowObjects', self._tag, self.Tag.ShowObjects, self._tags_by_value)
    return self._data

  @ShowObjects.setter
  def ShowObjects(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.ShowObjects', value, Anki.Cozmo.VizInterface.ShowObjects)
    self._tag = self.Tag.ShowObjects

  @property
  def TrackerQuad(self):
    "Anki.Cozmo.VizInterface.TrackerQuad TrackerQuad union property."
    msgbuffers.safety_check_tag('TrackerQuad', self._tag, self.Tag.TrackerQuad, self._tags_by_value)
    return self._data

  @TrackerQuad.setter
  def TrackerQuad(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.TrackerQuad', value, Anki.Cozmo.VizInterface.TrackerQuad)
    self._tag = self.Tag.TrackerQuad

  @property
  def FaceDetection(self):
    "Anki.Cozmo.VizInterface.FaceDetection FaceDetection union property."
    msgbuffers.safety_check_tag('FaceDetection', self._tag, self.Tag.FaceDetection, self._tags_by_value)
    return self._data

  @FaceDetection.setter
  def FaceDetection(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.FaceDetection', value, Anki.Cozmo.VizInterface.FaceDetection)
    self._tag = self.Tag.FaceDetection

  @property
  def RobotMood(self):
    "Anki.Cozmo.VizInterface.RobotMood RobotMood union property."
    msgbuffers.safety_check_tag('RobotMood', self._tag, self.Tag.RobotMood, self._tags_by_value)
    return self._data

  @RobotMood.setter
  def RobotMood(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.RobotMood', value, Anki.Cozmo.VizInterface.RobotMood)
    self._tag = self.Tag.RobotMood

  @property
  def RobotBehaviorSelectData(self):
    "Anki.Cozmo.VizInterface.RobotBehaviorSelectData RobotBehaviorSelectData union property."
    msgbuffers.safety_check_tag('RobotBehaviorSelectData', self._tag, self.Tag.RobotBehaviorSelectData, self._tags_by_value)
    return self._data

  @RobotBehaviorSelectData.setter
  def RobotBehaviorSelectData(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.RobotBehaviorSelectData', value, Anki.Cozmo.VizInterface.RobotBehaviorSelectData)
    self._tag = self.Tag.RobotBehaviorSelectData

  @property
  def NewBehaviorSelected(self):
    "Anki.Cozmo.VizInterface.NewBehaviorSelected NewBehaviorSelected union property."
    msgbuffers.safety_check_tag('NewBehaviorSelected', self._tag, self.Tag.NewBehaviorSelected, self._tags_by_value)
    return self._data

  @NewBehaviorSelected.setter
  def NewBehaviorSelected(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.NewBehaviorSelected', value, Anki.Cozmo.VizInterface.NewBehaviorSelected)
    self._tag = self.Tag.NewBehaviorSelected

  @property
  def StartRobotUpdate(self):
    "Anki.Cozmo.VizInterface.StartRobotUpdate StartRobotUpdate union property."
    msgbuffers.safety_check_tag('StartRobotUpdate', self._tag, self.Tag.StartRobotUpdate, self._tags_by_value)
    return self._data

  @StartRobotUpdate.setter
  def StartRobotUpdate(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.StartRobotUpdate', value, Anki.Cozmo.VizInterface.StartRobotUpdate)
    self._tag = self.Tag.StartRobotUpdate

  @property
  def EndRobotUpdate(self):
    "Anki.Cozmo.VizInterface.EndRobotUpdate EndRobotUpdate union property."
    msgbuffers.safety_check_tag('EndRobotUpdate', self._tag, self.Tag.EndRobotUpdate, self._tags_by_value)
    return self._data

  @EndRobotUpdate.setter
  def EndRobotUpdate(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.EndRobotUpdate', value, Anki.Cozmo.VizInterface.EndRobotUpdate)
    self._tag = self.Tag.EndRobotUpdate

  @property
  def SaveImages(self):
    "Anki.Cozmo.VizInterface.SaveImages SaveImages union property."
    msgbuffers.safety_check_tag('SaveImages', self._tag, self.Tag.SaveImages, self._tags_by_value)
    return self._data

  @SaveImages.setter
  def SaveImages(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SaveImages', value, Anki.Cozmo.VizInterface.SaveImages)
    self._tag = self.Tag.SaveImages

  @property
  def SaveState(self):
    "Anki.Cozmo.VizInterface.SaveState SaveState union property."
    msgbuffers.safety_check_tag('SaveState', self._tag, self.Tag.SaveState, self._tags_by_value)
    return self._data

  @SaveState.setter
  def SaveState(self, value):
    self._data = msgbuffers.validate_object(
      'MessageViz.SaveState', value, Anki.Cozmo.VizInterface.SaveState)
    self._tag = self.Tag.SaveState

  def __init__(self, **kwargs):
    if not kwargs:
      self._tag = None
      self._data = None

    elif len(kwargs) == 1:
      key, value = next(iter(kwargs.items()))
      if key not in self._tags_by_name:
        raise TypeError("'{argument}' is an invalid keyword argument for this method.".format(argument=key))
      # calls the correct property
      setattr(self, key, value)

    else:
      raise TypeError('This method only accepts up to one keyword argument.')

  @classmethod
  def unpack(cls, buffer):
    "Reads a new MessageViz from the given buffer."
    reader = msgbuffers.BinaryReader(buffer)
    value = cls.unpack_from(reader)
    if reader.tell() != len(reader):
      raise msgbuffers.ReadError(
        ('MessageViz.unpack received a buffer of length {length}, ' +
        'but only {position} bytes were read.').format(
        length=len(reader), position=reader.tell()))
    return value

  @classmethod
  def unpack_from(cls, reader):
    "Reads a new MessageViz from the given BinaryReader."
    tag = reader.read('B')
    if tag in cls._tags_by_value:
      value = cls()
      setattr(value, cls._tags_by_value[tag], cls._tag_unpack_methods[tag](reader))
      return value
    else:
      raise ValueError('MessageViz attempted to unpack unknown tag {tag}.'.format(tag=tag))

  def pack(self):
    "Writes the current MessageViz, returning bytes."
    writer = msgbuffers.BinaryWriter()
    self.pack_to(writer)
    return writer.dumps()

  def pack_to(self, writer):
    "Writes the current SampleUnion to the given BinaryWriter."
    if self._tag in self._tags_by_value:
      writer.write(self._tag, 'B')
      self._tag_pack_methods[self._tag](writer, self._data)
    else:
      raise ValueError('Cannot pack an empty MessageViz.')

  def clear(self):
    self._tag = None
    self._data = None

  @classmethod
  def typeByTag(cls, tag):
    return cls._type_by_tag_value[tag]()

  def __eq__(self, other):
    if type(self) is type(other):
      return self._tag == other._tag and self._data == other._data
    else:
      return NotImplemented

  def __ne__(self, other):
    if type(self) is type(other):
      return not self.__eq__(other)
    else:
      return NotImplemented

  def __len__(self):
    if 0 <= self._tag < 42:
      return self._tag_size_methods[self._tag](self._data)
    else:
      return 1

  def __str__(self):
    if 0 <= self._tag < 42:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=self._data)
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  def __repr__(self):
    if 0 <= self._tag < 42:
      return '{type}({name}={value})'.format(
        type=type(self).__name__,
        name=self.tag_name,
        value=repr(self._data))
    else:
      return '{type}()'.format(
        type=type(self).__name__)

  _tags_by_name = dict(
    IMURequest=0,
    CarryStateUpdate=1,
    SetBodyRadioMode=2,
    AnimationState=3,
    ImageChunk=4,
    ImageImuData=5,
    CameraCalibration=6,
    SetVizOrigin=7,
    RobotStateMessage=8,
    Object=9,
    SegmentPrimitive=10,
    Quad=11,
    SimpleQuadVectorMessageBegin=12,
    SimpleQuadVectorMessage=13,
    SimpleQuadVectorMessageEnd=14,
    CameraQuad=15,
    CameraLine=16,
    CameraOval=17,
    CameraText=18,
    EraseObject=19,
    EraseSegmentPrimitives=20,
    EraseQuad=21,
    SetRobot=22,
    AppendPathSegmentLine=23,
    AppendPathSegmentArc=24,
    SetPathColor=25,
    ErasePath=26,
    DefineColor=27,
    SetLabel=28,
    DockingErrorSignal=29,
    CameraInfo=30,
    VisionMarker=31,
    ShowObjects=32,
    TrackerQuad=33,
    FaceDetection=34,
    RobotMood=35,
    RobotBehaviorSelectData=36,
    NewBehaviorSelected=37,
    StartRobotUpdate=38,
    EndRobotUpdate=39,
    SaveImages=40,
    SaveState=41,
  )

  _tags_by_value = dict()
  _tags_by_value[0] = 'IMURequest'
  _tags_by_value[1] = 'CarryStateUpdate'
  _tags_by_value[2] = 'SetBodyRadioMode'
  _tags_by_value[3] = 'AnimationState'
  _tags_by_value[4] = 'ImageChunk'
  _tags_by_value[5] = 'ImageImuData'
  _tags_by_value[6] = 'CameraCalibration'
  _tags_by_value[7] = 'SetVizOrigin'
  _tags_by_value[8] = 'RobotStateMessage'
  _tags_by_value[9] = 'Object'
  _tags_by_value[10] = 'SegmentPrimitive'
  _tags_by_value[11] = 'Quad'
  _tags_by_value[12] = 'SimpleQuadVectorMessageBegin'
  _tags_by_value[13] = 'SimpleQuadVectorMessage'
  _tags_by_value[14] = 'SimpleQuadVectorMessageEnd'
  _tags_by_value[15] = 'CameraQuad'
  _tags_by_value[16] = 'CameraLine'
  _tags_by_value[17] = 'CameraOval'
  _tags_by_value[18] = 'CameraText'
  _tags_by_value[19] = 'EraseObject'
  _tags_by_value[20] = 'EraseSegmentPrimitives'
  _tags_by_value[21] = 'EraseQuad'
  _tags_by_value[22] = 'SetRobot'
  _tags_by_value[23] = 'AppendPathSegmentLine'
  _tags_by_value[24] = 'AppendPathSegmentArc'
  _tags_by_value[25] = 'SetPathColor'
  _tags_by_value[26] = 'ErasePath'
  _tags_by_value[27] = 'DefineColor'
  _tags_by_value[28] = 'SetLabel'
  _tags_by_value[29] = 'DockingErrorSignal'
  _tags_by_value[30] = 'CameraInfo'
  _tags_by_value[31] = 'VisionMarker'
  _tags_by_value[32] = 'ShowObjects'
  _tags_by_value[33] = 'TrackerQuad'
  _tags_by_value[34] = 'FaceDetection'
  _tags_by_value[35] = 'RobotMood'
  _tags_by_value[36] = 'RobotBehaviorSelectData'
  _tags_by_value[37] = 'NewBehaviorSelected'
  _tags_by_value[38] = 'StartRobotUpdate'
  _tags_by_value[39] = 'EndRobotUpdate'
  _tags_by_value[40] = 'SaveImages'
  _tags_by_value[41] = 'SaveState'
  

  _tag_unpack_methods = dict()
  _tag_unpack_methods[0] = lambda reader: reader.read_object(Anki.Cozmo.IMURequest.unpack_from)
  _tag_unpack_methods[1] = lambda reader: reader.read_object(Anki.Cozmo.CarryStateUpdate.unpack_from)
  _tag_unpack_methods[2] = lambda reader: reader.read_object(Anki.Cozmo.SetBodyRadioMode.unpack_from)
  _tag_unpack_methods[3] = lambda reader: reader.read_object(Anki.Cozmo.RobotInterface.AnimationState.unpack_from)
  _tag_unpack_methods[4] = lambda reader: reader.read_object(Anki.Cozmo.ImageChunk.unpack_from)
  _tag_unpack_methods[5] = lambda reader: reader.read_object(Anki.Cozmo.ImageImuData.unpack_from)
  _tag_unpack_methods[6] = lambda reader: reader.read_object(Anki.Cozmo.CameraCalibration.unpack_from)
  _tag_unpack_methods[7] = lambda reader: reader.read_object(Anki.Cozmo.SetVizOrigin.unpack_from)
  _tag_unpack_methods[8] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.RobotStateMessage.unpack_from)
  _tag_unpack_methods[9] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.Object.unpack_from)
  _tag_unpack_methods[10] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SegmentPrimitive.unpack_from)
  _tag_unpack_methods[11] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.Quad.unpack_from)
  _tag_unpack_methods[12] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin.unpack_from)
  _tag_unpack_methods[13] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SimpleQuadVectorMessage.unpack_from)
  _tag_unpack_methods[14] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd.unpack_from)
  _tag_unpack_methods[15] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.CameraQuad.unpack_from)
  _tag_unpack_methods[16] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.CameraLine.unpack_from)
  _tag_unpack_methods[17] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.CameraOval.unpack_from)
  _tag_unpack_methods[18] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.CameraText.unpack_from)
  _tag_unpack_methods[19] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.EraseObject.unpack_from)
  _tag_unpack_methods[20] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.EraseSegmentPrimitives.unpack_from)
  _tag_unpack_methods[21] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.EraseQuad.unpack_from)
  _tag_unpack_methods[22] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SetRobot.unpack_from)
  _tag_unpack_methods[23] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.AppendPathSegmentLine.unpack_from)
  _tag_unpack_methods[24] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.AppendPathSegmentArc.unpack_from)
  _tag_unpack_methods[25] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SetPathColor.unpack_from)
  _tag_unpack_methods[26] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.ErasePath.unpack_from)
  _tag_unpack_methods[27] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.DefineColor.unpack_from)
  _tag_unpack_methods[28] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SetLabel.unpack_from)
  _tag_unpack_methods[29] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.DockingErrorSignal.unpack_from)
  _tag_unpack_methods[30] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.CameraInfo.unpack_from)
  _tag_unpack_methods[31] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.VisionMarker.unpack_from)
  _tag_unpack_methods[32] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.ShowObjects.unpack_from)
  _tag_unpack_methods[33] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.TrackerQuad.unpack_from)
  _tag_unpack_methods[34] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.FaceDetection.unpack_from)
  _tag_unpack_methods[35] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.RobotMood.unpack_from)
  _tag_unpack_methods[36] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.RobotBehaviorSelectData.unpack_from)
  _tag_unpack_methods[37] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.NewBehaviorSelected.unpack_from)
  _tag_unpack_methods[38] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.StartRobotUpdate.unpack_from)
  _tag_unpack_methods[39] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.EndRobotUpdate.unpack_from)
  _tag_unpack_methods[40] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SaveImages.unpack_from)
  _tag_unpack_methods[41] = lambda reader: reader.read_object(Anki.Cozmo.VizInterface.SaveState.unpack_from)
  

  _tag_pack_methods = dict()
  _tag_pack_methods[0] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[1] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[2] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[3] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[4] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[5] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[6] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[7] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[8] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[9] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[10] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[11] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[12] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[13] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[14] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[15] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[16] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[17] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[18] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[19] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[20] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[21] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[22] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[23] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[24] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[25] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[26] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[27] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[28] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[29] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[30] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[31] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[32] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[33] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[34] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[35] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[36] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[37] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[38] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[39] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[40] = lambda writer, value: writer.write_object(value)
  _tag_pack_methods[41] = lambda writer, value: writer.write_object(value)
  

  _tag_size_methods = dict()
  _tag_size_methods[0] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[1] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[2] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[3] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[4] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[5] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[6] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[7] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[8] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[9] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[10] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[11] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[12] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[13] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[14] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[15] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[16] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[17] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[18] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[19] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[20] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[21] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[22] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[23] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[24] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[25] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[26] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[27] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[28] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[29] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[30] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[31] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[32] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[33] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[34] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[35] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[36] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[37] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[38] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[39] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[40] = lambda value: msgbuffers.size_object(value)
  _tag_size_methods[41] = lambda value: msgbuffers.size_object(value)
  

  _type_by_tag_value = dict()
  _type_by_tag_value[0] = lambda : Anki.Cozmo.IMURequest
  _type_by_tag_value[1] = lambda : Anki.Cozmo.CarryStateUpdate
  _type_by_tag_value[2] = lambda : Anki.Cozmo.SetBodyRadioMode
  _type_by_tag_value[3] = lambda : Anki.Cozmo.RobotInterface.AnimationState
  _type_by_tag_value[4] = lambda : Anki.Cozmo.ImageChunk
  _type_by_tag_value[5] = lambda : Anki.Cozmo.ImageImuData
  _type_by_tag_value[6] = lambda : Anki.Cozmo.CameraCalibration
  _type_by_tag_value[7] = lambda : Anki.Cozmo.SetVizOrigin
  _type_by_tag_value[8] = lambda : Anki.Cozmo.VizInterface.RobotStateMessage
  _type_by_tag_value[9] = lambda : Anki.Cozmo.VizInterface.Object
  _type_by_tag_value[10] = lambda : Anki.Cozmo.VizInterface.SegmentPrimitive
  _type_by_tag_value[11] = lambda : Anki.Cozmo.VizInterface.Quad
  _type_by_tag_value[12] = lambda : Anki.Cozmo.VizInterface.SimpleQuadVectorMessageBegin
  _type_by_tag_value[13] = lambda : Anki.Cozmo.VizInterface.SimpleQuadVectorMessage
  _type_by_tag_value[14] = lambda : Anki.Cozmo.VizInterface.SimpleQuadVectorMessageEnd
  _type_by_tag_value[15] = lambda : Anki.Cozmo.VizInterface.CameraQuad
  _type_by_tag_value[16] = lambda : Anki.Cozmo.VizInterface.CameraLine
  _type_by_tag_value[17] = lambda : Anki.Cozmo.VizInterface.CameraOval
  _type_by_tag_value[18] = lambda : Anki.Cozmo.VizInterface.CameraText
  _type_by_tag_value[19] = lambda : Anki.Cozmo.VizInterface.EraseObject
  _type_by_tag_value[20] = lambda : Anki.Cozmo.VizInterface.EraseSegmentPrimitives
  _type_by_tag_value[21] = lambda : Anki.Cozmo.VizInterface.EraseQuad
  _type_by_tag_value[22] = lambda : Anki.Cozmo.VizInterface.SetRobot
  _type_by_tag_value[23] = lambda : Anki.Cozmo.VizInterface.AppendPathSegmentLine
  _type_by_tag_value[24] = lambda : Anki.Cozmo.VizInterface.AppendPathSegmentArc
  _type_by_tag_value[25] = lambda : Anki.Cozmo.VizInterface.SetPathColor
  _type_by_tag_value[26] = lambda : Anki.Cozmo.VizInterface.ErasePath
  _type_by_tag_value[27] = lambda : Anki.Cozmo.VizInterface.DefineColor
  _type_by_tag_value[28] = lambda : Anki.Cozmo.VizInterface.SetLabel
  _type_by_tag_value[29] = lambda : Anki.Cozmo.VizInterface.DockingErrorSignal
  _type_by_tag_value[30] = lambda : Anki.Cozmo.VizInterface.CameraInfo
  _type_by_tag_value[31] = lambda : Anki.Cozmo.VizInterface.VisionMarker
  _type_by_tag_value[32] = lambda : Anki.Cozmo.VizInterface.ShowObjects
  _type_by_tag_value[33] = lambda : Anki.Cozmo.VizInterface.TrackerQuad
  _type_by_tag_value[34] = lambda : Anki.Cozmo.VizInterface.FaceDetection
  _type_by_tag_value[35] = lambda : Anki.Cozmo.VizInterface.RobotMood
  _type_by_tag_value[36] = lambda : Anki.Cozmo.VizInterface.RobotBehaviorSelectData
  _type_by_tag_value[37] = lambda : Anki.Cozmo.VizInterface.NewBehaviorSelected
  _type_by_tag_value[38] = lambda : Anki.Cozmo.VizInterface.StartRobotUpdate
  _type_by_tag_value[39] = lambda : Anki.Cozmo.VizInterface.EndRobotUpdate
  _type_by_tag_value[40] = lambda : Anki.Cozmo.VizInterface.SaveImages
  _type_by_tag_value[41] = lambda : Anki.Cozmo.VizInterface.SaveState
  

Anki.Cozmo.VizInterface.MessageViz = MessageViz
del MessageViz


