# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.map_component import MapComponent
from ..types.map_config import MapConfig
from ..types.time_series_component import TimeSeriesComponent
from .types.list_components_api_v_1_dashboard_components_get_response_item import (
    ListComponentsApiV1DashboardComponentsGetResponseItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawComponentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_map(
        self,
        *,
        name: str,
        config: MapConfig,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MapComponent]:
        """
        Create a new map component.

        Parameters
        ----------
        name : str

        config : MapConfig

        layer_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MapComponent]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components/map",
            method="POST",
            params={
                "name": name,
            },
            json={
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=MapConfig, direction="write"
                ),
                "layer_ids": layer_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MapComponent,
                    parse_obj_as(
                        type_=MapComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_timeseries(
        self,
        *,
        name: str,
        title: str,
        datasets: typing.Sequence[str],
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TimeSeriesComponent]:
        """
        Create a new time series component.

        Parameters
        ----------
        name : str

        title : str
            The user-defined title of the chart.

        datasets : typing.Sequence[str]
            List of timeseries dataset IDs to display on this chart.

        y_axis_label : typing.Optional[str]
            Label for the Y-axis.

        unit : typing.Optional[str]
            The unit for the Y-axis values, e.g., 'MW'.

        formula : typing.Optional[str]
            Optional formula to combine datasets, e.g., 'dataset_1 + dataset_2'

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional ECharts options for the chart.

        theme : typing.Optional[str]
            Theme name for the chart component, e.g., 'wind_dark', 'wind_light'.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TimeSeriesComponent]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components/timeseries",
            method="POST",
            params={
                "name": name,
            },
            json={
                "title": title,
                "yAxisLabel": y_axis_label,
                "unit": unit,
                "datasets": datasets,
                "formula": formula,
                "echartsOptions": echarts_options,
                "theme": theme,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TimeSeriesComponent,
                    parse_obj_as(
                        type_=TimeSeriesComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_components(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]]:
        """
        List all components in the user's library.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem],
                    parse_obj_as(
                        type_=typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Retrieve a single component.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/{jsonable_encoder(component_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a component from the user's library.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/{jsonable_encoder(component_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_map(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[MapConfig] = OMIT,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[MapComponent]:
        """
        Update a map component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        config : typing.Optional[MapConfig]
            Updated map configuration

        layer_ids : typing.Optional[typing.Sequence[str]]
            Updated list of layer IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[MapComponent]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/map/{jsonable_encoder(component_id)}",
            method="PUT",
            json={
                "name": name,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=MapConfig, direction="write"
                ),
                "layerIds": layer_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MapComponent,
                    parse_obj_as(
                        type_=MapComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_timeseries(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        datasets: typing.Optional[typing.Sequence[str]] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[TimeSeriesComponent]:
        """
        Update a timeseries component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        title : typing.Optional[str]
            Updated chart title

        y_axis_label : typing.Optional[str]
            Updated Y-axis label

        unit : typing.Optional[str]
            Updated unit for Y-axis values

        datasets : typing.Optional[typing.Sequence[str]]
            Updated list of timeseries dataset IDs

        formula : typing.Optional[str]
            Updated formula to combine datasets

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Updated ECharts options

        theme : typing.Optional[str]
            Updated theme name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TimeSeriesComponent]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/timeseries/{jsonable_encoder(component_id)}",
            method="PUT",
            json={
                "name": name,
                "title": title,
                "yAxisLabel": y_axis_label,
                "unit": unit,
                "datasets": datasets,
                "formula": formula,
                "echartsOptions": echarts_options,
                "theme": theme,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TimeSeriesComponent,
                    parse_obj_as(
                        type_=TimeSeriesComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawComponentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_map(
        self,
        *,
        name: str,
        config: MapConfig,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MapComponent]:
        """
        Create a new map component.

        Parameters
        ----------
        name : str

        config : MapConfig

        layer_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MapComponent]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components/map",
            method="POST",
            params={
                "name": name,
            },
            json={
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=MapConfig, direction="write"
                ),
                "layer_ids": layer_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MapComponent,
                    parse_obj_as(
                        type_=MapComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_timeseries(
        self,
        *,
        name: str,
        title: str,
        datasets: typing.Sequence[str],
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TimeSeriesComponent]:
        """
        Create a new time series component.

        Parameters
        ----------
        name : str

        title : str
            The user-defined title of the chart.

        datasets : typing.Sequence[str]
            List of timeseries dataset IDs to display on this chart.

        y_axis_label : typing.Optional[str]
            Label for the Y-axis.

        unit : typing.Optional[str]
            The unit for the Y-axis values, e.g., 'MW'.

        formula : typing.Optional[str]
            Optional formula to combine datasets, e.g., 'dataset_1 + dataset_2'

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional ECharts options for the chart.

        theme : typing.Optional[str]
            Theme name for the chart component, e.g., 'wind_dark', 'wind_light'.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TimeSeriesComponent]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components/timeseries",
            method="POST",
            params={
                "name": name,
            },
            json={
                "title": title,
                "yAxisLabel": y_axis_label,
                "unit": unit,
                "datasets": datasets,
                "formula": formula,
                "echartsOptions": echarts_options,
                "theme": theme,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TimeSeriesComponent,
                    parse_obj_as(
                        type_=TimeSeriesComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_components(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]]:
        """
        List all components in the user's library.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/components",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem],
                    parse_obj_as(
                        type_=typing.List[ListComponentsApiV1DashboardComponentsGetResponseItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Retrieve a single component.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/{jsonable_encoder(component_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_component(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Delete a component from the user's library.

        Parameters
        ----------
        component_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/{jsonable_encoder(component_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_map(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[MapConfig] = OMIT,
        layer_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[MapComponent]:
        """
        Update a map component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        config : typing.Optional[MapConfig]
            Updated map configuration

        layer_ids : typing.Optional[typing.Sequence[str]]
            Updated list of layer IDs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[MapComponent]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/map/{jsonable_encoder(component_id)}",
            method="PUT",
            json={
                "name": name,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=MapConfig, direction="write"
                ),
                "layerIds": layer_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    MapComponent,
                    parse_obj_as(
                        type_=MapComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_timeseries(
        self,
        component_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        y_axis_label: typing.Optional[str] = OMIT,
        unit: typing.Optional[str] = OMIT,
        datasets: typing.Optional[typing.Sequence[str]] = OMIT,
        formula: typing.Optional[str] = OMIT,
        echarts_options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        theme: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[TimeSeriesComponent]:
        """
        Update a timeseries component.

        Parameters
        ----------
        component_id : str

        name : typing.Optional[str]
            Updated component name

        title : typing.Optional[str]
            Updated chart title

        y_axis_label : typing.Optional[str]
            Updated Y-axis label

        unit : typing.Optional[str]
            Updated unit for Y-axis values

        datasets : typing.Optional[typing.Sequence[str]]
            Updated list of timeseries dataset IDs

        formula : typing.Optional[str]
            Updated formula to combine datasets

        echarts_options : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Updated ECharts options

        theme : typing.Optional[str]
            Updated theme name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TimeSeriesComponent]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/components/timeseries/{jsonable_encoder(component_id)}",
            method="PUT",
            json={
                "name": name,
                "title": title,
                "yAxisLabel": y_axis_label,
                "unit": unit,
                "datasets": datasets,
                "formula": formula,
                "echartsOptions": echarts_options,
                "theme": theme,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TimeSeriesComponent,
                    parse_obj_as(
                        type_=TimeSeriesComponent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
