# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class TimeSeriesConfig(UniversalBaseModel):
    """
    Configuration specific to a time series component.
    """

    title: str = pydantic.Field()
    """
    The user-defined title of the chart.
    """

    y_axis_label: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="yAxisLabel")] = pydantic.Field(
        default=None
    )
    """
    Label for the Y-axis.
    """

    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unit for the Y-axis values, e.g., 'MW'.
    """

    datasets: typing.List[str] = pydantic.Field()
    """
    List of timeseries dataset IDs to display on this chart.
    """

    formula: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional formula to combine datasets, e.g., 'dataset_1 + dataset_2'
    """

    echarts_options: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="echartsOptions")
    ] = pydantic.Field(default=None)
    """
    Optional ECharts options for the chart.
    """

    theme: typing.Optional[str] = pydantic.Field(default=None)
    """
    Theme name for the chart component, e.g., 'wind_dark', 'wind_light'.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
