# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class TimeSeriesDataType(UniversalBaseModel):
    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unit of measurement, e.g., 'MW'
    """

    forecast_type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="forecastType")] = (
        pydantic.Field(default=None)
    )
    """
    Type of forecast data, e.g., 'Offshore Wind'
    """

    price_area: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="priceArea")] = pydantic.Field(
        default=None
    )
    """
    Price area identifier, e.g., 'DK1'
    """

    forecast_horizon: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="forecastHorizon")] = (
        pydantic.Field(default=None)
    )
    """
    Forecast horizon, e.g., 'ForecastDayAhead'
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
